package software.amazon.awscdk.services.cloudwatch;

/**
 * Types of view.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * dashboard.addWidgets(LogQueryWidget.Builder.create()
 *         .logGroupNames(List.of("my-log-group"))
 *         .view(LogQueryVisualizationType.TABLE)
 *         // The lines will be automatically combined using '\n|'.
 *         .queryLines(List.of("fields &#64;message", "filter &#64;message like /Error/"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:51.486Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.LogQueryVisualizationType")
public enum LogQueryVisualizationType {
    /**
     * Table view.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TABLE,
    /**
     * Line view.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LINE,
    /**
     * Stacked area view.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STACKEDAREA,
    /**
     * Bar view.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BAR,
    /**
     * Pie view.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PIE,
}
