package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for TableWidget's summary columns.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * dashboard.addWidgets(TableWidget.Builder.create()
 *         // ...
 *         .summary(TableSummaryProps.builder()
 *                 .columns(List.of(TableSummaryColumn.AVERAGE))
 *                 .hideNonSummaryColumns(true)
 *                 .sticky(true)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:51.514Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.TableSummaryProps")
@software.amazon.jsii.Jsii.Proxy(TableSummaryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TableSummaryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Summary columns.
     * <p>
     * Default: - No summary columns will be shown
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudwatch.TableSummaryColumn> getColumns() {
        return null;
    }

    /**
     * Prevent the columns of datapoints from being displayed, so that only the label and summary columns are displayed.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getHideNonSummaryColumns() {
        return null;
    }

    /**
     * Make the summary columns sticky, so that they remain in view while scrolling.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSticky() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TableSummaryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableSummaryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TableSummaryProps> {
        java.util.List<software.amazon.awscdk.services.cloudwatch.TableSummaryColumn> columns;
        java.lang.Boolean hideNonSummaryColumns;
        java.lang.Boolean sticky;

        /**
         * Sets the value of {@link TableSummaryProps#getColumns}
         * @param columns Summary columns.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder columns(java.util.List<? extends software.amazon.awscdk.services.cloudwatch.TableSummaryColumn> columns) {
            this.columns = (java.util.List<software.amazon.awscdk.services.cloudwatch.TableSummaryColumn>)columns;
            return this;
        }

        /**
         * Sets the value of {@link TableSummaryProps#getHideNonSummaryColumns}
         * @param hideNonSummaryColumns Prevent the columns of datapoints from being displayed, so that only the label and summary columns are displayed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hideNonSummaryColumns(java.lang.Boolean hideNonSummaryColumns) {
            this.hideNonSummaryColumns = hideNonSummaryColumns;
            return this;
        }

        /**
         * Sets the value of {@link TableSummaryProps#getSticky}
         * @param sticky Make the summary columns sticky, so that they remain in view while scrolling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sticky(java.lang.Boolean sticky) {
            this.sticky = sticky;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableSummaryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TableSummaryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TableSummaryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableSummaryProps {
        private final java.util.List<software.amazon.awscdk.services.cloudwatch.TableSummaryColumn> columns;
        private final java.lang.Boolean hideNonSummaryColumns;
        private final java.lang.Boolean sticky;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.TableSummaryColumn.class)));
            this.hideNonSummaryColumns = software.amazon.jsii.Kernel.get(this, "hideNonSummaryColumns", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.sticky = software.amazon.jsii.Kernel.get(this, "sticky", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.columns = (java.util.List<software.amazon.awscdk.services.cloudwatch.TableSummaryColumn>)builder.columns;
            this.hideNonSummaryColumns = builder.hideNonSummaryColumns;
            this.sticky = builder.sticky;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudwatch.TableSummaryColumn> getColumns() {
            return this.columns;
        }

        @Override
        public final java.lang.Boolean getHideNonSummaryColumns() {
            return this.hideNonSummaryColumns;
        }

        @Override
        public final java.lang.Boolean getSticky() {
            return this.sticky;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getColumns() != null) {
                data.set("columns", om.valueToTree(this.getColumns()));
            }
            if (this.getHideNonSummaryColumns() != null) {
                data.set("hideNonSummaryColumns", om.valueToTree(this.getHideNonSummaryColumns()));
            }
            if (this.getSticky() != null) {
                data.set("sticky", om.valueToTree(this.getSticky()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.TableSummaryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableSummaryProps.Jsii$Proxy that = (TableSummaryProps.Jsii$Proxy) o;

            if (this.columns != null ? !this.columns.equals(that.columns) : that.columns != null) return false;
            if (this.hideNonSummaryColumns != null ? !this.hideNonSummaryColumns.equals(that.hideNonSummaryColumns) : that.hideNonSummaryColumns != null) return false;
            return this.sticky != null ? this.sticky.equals(that.sticky) : that.sticky == null;
        }

        @Override
        public final int hashCode() {
            int result = this.columns != null ? this.columns.hashCode() : 0;
            result = 31 * result + (this.hideNonSummaryColumns != null ? this.hideNonSummaryColumns.hashCode() : 0);
            result = 31 * result + (this.sticky != null ? this.sticky.hashCode() : 0);
            return result;
        }
    }
}
