package software.amazon.awscdk.services.codebuild;

/**
 * The list of event types for AWS Codebuild.
 * <p>
 * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-buildproject">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-buildproject</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:51.638Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.ProjectNotificationEvents")
public enum ProjectNotificationEvents {
    /**
     * Trigger notification when project build state failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD_FAILED,
    /**
     * Trigger notification when project build state succeeded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD_SUCCEEDED,
    /**
     * Trigger notification when project build state in progress.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD_IN_PROGRESS,
    /**
     * Trigger notification when project build state stopped.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD_STOPPED,
    /**
     * Trigger notification when project build phase failure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD_PHASE_FAILED,
    /**
     * Trigger notification when project build phase success.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD_PHASE_SUCCEEDED,
}
