package software.amazon.awscdk.services.codedeploy;

/**
 * Properties for defining a <code>CfnDeploymentConfig</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codedeploy.*;
 * CfnDeploymentConfigProps cfnDeploymentConfigProps = CfnDeploymentConfigProps.builder()
 *         .computePlatform("computePlatform")
 *         .deploymentConfigName("deploymentConfigName")
 *         .minimumHealthyHosts(MinimumHealthyHostsProperty.builder()
 *                 .type("type")
 *                 .value(123)
 *                 .build())
 *         .trafficRoutingConfig(TrafficRoutingConfigProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .timeBasedCanary(TimeBasedCanaryProperty.builder()
 *                         .canaryInterval(123)
 *                         .canaryPercentage(123)
 *                         .build())
 *                 .timeBasedLinear(TimeBasedLinearProperty.builder()
 *                         .linearInterval(123)
 *                         .linearPercentage(123)
 *                         .build())
 *                 .build())
 *         .zonalConfig(ZonalConfigProperty.builder()
 *                 .firstZoneMonitorDurationInSeconds(123)
 *                 .minimumHealthyHostsPerZone(MinimumHealthyHostsPerZoneProperty.builder()
 *                         .type("type")
 *                         .value(123)
 *                         .build())
 *                 .monitorDurationInSeconds(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:51.702Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.CfnDeploymentConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnDeploymentConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDeploymentConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The destination platform type for the deployment ( <code>Lambda</code> , <code>Server</code> , or <code>ECS</code> ).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html#cfn-codedeploy-deploymentconfig-computeplatform">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html#cfn-codedeploy-deploymentconfig-computeplatform</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComputePlatform() {
        return null;
    }

    /**
     * A name for the deployment configuration.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the deployment configuration name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html#cfn-codedeploy-deploymentconfig-deploymentconfigname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html#cfn-codedeploy-deploymentconfig-deploymentconfigname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentConfigName() {
        return null;
    }

    /**
     * The minimum number of healthy instances that should be available at any time during the deployment.
     * <p>
     * There are two parameters expected in the input: type and value.
     * <p>
     * The type parameter takes either of the following values:
     * <p>
     * <ul>
     * <li>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</li>
     * <li>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional instances.</li>
     * </ul>
     * <p>
     * The value parameter takes an integer.
     * <p>
     * For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
     * <p>
     * For more information about instance health, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">CodeDeploy Instance Health</a> in the AWS CodeDeploy User Guide.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html#cfn-codedeploy-deploymentconfig-minimumhealthyhosts</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMinimumHealthyHosts() {
        return null;
    }

    /**
     * The configuration that specifies how the deployment traffic is routed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html#cfn-codedeploy-deploymentconfig-trafficroutingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html#cfn-codedeploy-deploymentconfig-trafficroutingconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTrafficRoutingConfig() {
        return null;
    }

    /**
     * Configure the <code>ZonalConfig</code> object if you want AWS CodeDeploy to deploy your application to one <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones">Availability Zone</a> at a time, within an AWS Region.
     * <p>
     * For more information about the zonal configuration feature, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config">zonal configuration</a> in the <em>CodeDeploy User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html#cfn-codedeploy-deploymentconfig-zonalconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codedeploy-deploymentconfig.html#cfn-codedeploy-deploymentconfig-zonalconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getZonalConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDeploymentConfigProps> {
        java.lang.String computePlatform;
        java.lang.String deploymentConfigName;
        java.lang.Object minimumHealthyHosts;
        java.lang.Object trafficRoutingConfig;
        java.lang.Object zonalConfig;

        /**
         * Sets the value of {@link CfnDeploymentConfigProps#getComputePlatform}
         * @param computePlatform The destination platform type for the deployment ( <code>Lambda</code> , <code>Server</code> , or <code>ECS</code> ).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computePlatform(java.lang.String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentConfigProps#getDeploymentConfigName}
         * @param deploymentConfigName A name for the deployment configuration.
         *                             If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the deployment configuration name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfigName(java.lang.String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentConfigProps#getMinimumHealthyHosts}
         * @param minimumHealthyHosts The minimum number of healthy instances that should be available at any time during the deployment.
         *                            There are two parameters expected in the input: type and value.
         *                            <p>
         *                            The type parameter takes either of the following values:
         *                            <p>
         *                            <ul>
         *                            <li>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</li>
         *                            <li>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional instances.</li>
         *                            </ul>
         *                            <p>
         *                            The value parameter takes an integer.
         *                            <p>
         *                            For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
         *                            <p>
         *                            For more information about instance health, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">CodeDeploy Instance Health</a> in the AWS CodeDeploy User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumHealthyHosts(software.amazon.awscdk.IResolvable minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentConfigProps#getMinimumHealthyHosts}
         * @param minimumHealthyHosts The minimum number of healthy instances that should be available at any time during the deployment.
         *                            There are two parameters expected in the input: type and value.
         *                            <p>
         *                            The type parameter takes either of the following values:
         *                            <p>
         *                            <ul>
         *                            <li>HOST_COUNT: The value parameter represents the minimum number of healthy instances as an absolute value.</li>
         *                            <li>FLEET_PERCENT: The value parameter represents the minimum number of healthy instances as a percentage of the total number of instances in the deployment. If you specify FLEET_PERCENT, at the start of the deployment, AWS CodeDeploy converts the percentage to the equivalent number of instance and rounds up fractional instances.</li>
         *                            </ul>
         *                            <p>
         *                            The value parameter takes an integer.
         *                            <p>
         *                            For example, to set a minimum of 95% healthy instance, specify a type of FLEET_PERCENT and a value of 95.
         *                            <p>
         *                            For more information about instance health, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">CodeDeploy Instance Health</a> in the AWS CodeDeploy User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumHealthyHosts(software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.MinimumHealthyHostsProperty minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentConfigProps#getTrafficRoutingConfig}
         * @param trafficRoutingConfig The configuration that specifies how the deployment traffic is routed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficRoutingConfig(software.amazon.awscdk.IResolvable trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentConfigProps#getTrafficRoutingConfig}
         * @param trafficRoutingConfig The configuration that specifies how the deployment traffic is routed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficRoutingConfig(software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.TrafficRoutingConfigProperty trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentConfigProps#getZonalConfig}
         * @param zonalConfig Configure the <code>ZonalConfig</code> object if you want AWS CodeDeploy to deploy your application to one <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones">Availability Zone</a> at a time, within an AWS Region.
         *                    For more information about the zonal configuration feature, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config">zonal configuration</a> in the <em>CodeDeploy User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zonalConfig(software.amazon.awscdk.IResolvable zonalConfig) {
            this.zonalConfig = zonalConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeploymentConfigProps#getZonalConfig}
         * @param zonalConfig Configure the <code>ZonalConfig</code> object if you want AWS CodeDeploy to deploy your application to one <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones">Availability Zone</a> at a time, within an AWS Region.
         *                    For more information about the zonal configuration feature, see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config">zonal configuration</a> in the <em>CodeDeploy User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zonalConfig(software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.ZonalConfigProperty zonalConfig) {
            this.zonalConfig = zonalConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDeploymentConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDeploymentConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDeploymentConfigProps {
        private final java.lang.String computePlatform;
        private final java.lang.String deploymentConfigName;
        private final java.lang.Object minimumHealthyHosts;
        private final java.lang.Object trafficRoutingConfig;
        private final java.lang.Object zonalConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.computePlatform = software.amazon.jsii.Kernel.get(this, "computePlatform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deploymentConfigName = software.amazon.jsii.Kernel.get(this, "deploymentConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.minimumHealthyHosts = software.amazon.jsii.Kernel.get(this, "minimumHealthyHosts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.trafficRoutingConfig = software.amazon.jsii.Kernel.get(this, "trafficRoutingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.zonalConfig = software.amazon.jsii.Kernel.get(this, "zonalConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.computePlatform = builder.computePlatform;
            this.deploymentConfigName = builder.deploymentConfigName;
            this.minimumHealthyHosts = builder.minimumHealthyHosts;
            this.trafficRoutingConfig = builder.trafficRoutingConfig;
            this.zonalConfig = builder.zonalConfig;
        }

        @Override
        public final java.lang.String getComputePlatform() {
            return this.computePlatform;
        }

        @Override
        public final java.lang.String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public final java.lang.Object getMinimumHealthyHosts() {
            return this.minimumHealthyHosts;
        }

        @Override
        public final java.lang.Object getTrafficRoutingConfig() {
            return this.trafficRoutingConfig;
        }

        @Override
        public final java.lang.Object getZonalConfig() {
            return this.zonalConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getComputePlatform() != null) {
                data.set("computePlatform", om.valueToTree(this.getComputePlatform()));
            }
            if (this.getDeploymentConfigName() != null) {
                data.set("deploymentConfigName", om.valueToTree(this.getDeploymentConfigName()));
            }
            if (this.getMinimumHealthyHosts() != null) {
                data.set("minimumHealthyHosts", om.valueToTree(this.getMinimumHealthyHosts()));
            }
            if (this.getTrafficRoutingConfig() != null) {
                data.set("trafficRoutingConfig", om.valueToTree(this.getTrafficRoutingConfig()));
            }
            if (this.getZonalConfig() != null) {
                data.set("zonalConfig", om.valueToTree(this.getZonalConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codedeploy.CfnDeploymentConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDeploymentConfigProps.Jsii$Proxy that = (CfnDeploymentConfigProps.Jsii$Proxy) o;

            if (this.computePlatform != null ? !this.computePlatform.equals(that.computePlatform) : that.computePlatform != null) return false;
            if (this.deploymentConfigName != null ? !this.deploymentConfigName.equals(that.deploymentConfigName) : that.deploymentConfigName != null) return false;
            if (this.minimumHealthyHosts != null ? !this.minimumHealthyHosts.equals(that.minimumHealthyHosts) : that.minimumHealthyHosts != null) return false;
            if (this.trafficRoutingConfig != null ? !this.trafficRoutingConfig.equals(that.trafficRoutingConfig) : that.trafficRoutingConfig != null) return false;
            return this.zonalConfig != null ? this.zonalConfig.equals(that.zonalConfig) : that.zonalConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.computePlatform != null ? this.computePlatform.hashCode() : 0;
            result = 31 * result + (this.deploymentConfigName != null ? this.deploymentConfigName.hashCode() : 0);
            result = 31 * result + (this.minimumHealthyHosts != null ? this.minimumHealthyHosts.hashCode() : 0);
            result = 31 * result + (this.trafficRoutingConfig != null ? this.trafficRoutingConfig.hashCode() : 0);
            result = 31 * result + (this.zonalConfig != null ? this.zonalConfig.hashCode() : 0);
            return result;
        }
    }
}
