package software.amazon.awscdk.services.codepipeline.actions;

/**
 * The type of the CodeBuild action that determines its CodePipeline Category - Build, or Test.
 * <p>
 * The default is Build.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * PipelineProject project;
 * Artifact sourceOutput = new Artifact();
 * CodeBuildAction testAction = CodeBuildAction.Builder.create()
 *         .actionName("IntegrationTest")
 *         .project(project)
 *         .input(sourceOutput)
 *         .type(CodeBuildActionType.TEST)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:51.894Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CodeBuildActionType")
public enum CodeBuildActionType {
    /**
     * The action will have the Build Category.
     * <p>
     * This is the default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD,
    /**
     * The action will have the Test Category.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TEST,
}
