package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Construction properties of the <code>CodeCommitSourceAction CodeCommit source CodePipeline Action</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Source stage: read from repository
 * Repository repo = Repository.Builder.create(stack, "TemplateRepo")
 *         .repositoryName("template-repo")
 *         .build();
 * Artifact sourceOutput = new Artifact("SourceArtifact");
 * CodeCommitSourceAction source = CodeCommitSourceAction.Builder.create()
 *         .actionName("Source")
 *         .repository(repo)
 *         .output(sourceOutput)
 *         .trigger(CodeCommitTrigger.POLL)
 *         .build();
 * Map&lt;String, Object&gt; sourceStage = Map.of(
 *         "stageName", "Source",
 *         "actions", List.of(source));
 * // Deployment stage: create and deploy changeset with manual approval
 * String stackName = "OurStack";
 * String changeSetName = "StagedChangeSet";
 * Map&lt;String, Object&gt; prodStage = Map.of(
 *         "stageName", "Deploy",
 *         "actions", List.of(
 *             CloudFormationCreateReplaceChangeSetAction.Builder.create()
 *                     .actionName("PrepareChanges")
 *                     .stackName(stackName)
 *                     .changeSetName(changeSetName)
 *                     .adminPermissions(true)
 *                     .templatePath(sourceOutput.atPath("template.yaml"))
 *                     .runOrder(1)
 *                     .build(),
 *             ManualApprovalAction.Builder.create()
 *                     .actionName("ApproveChanges")
 *                     .runOrder(2)
 *                     .build(),
 *             CloudFormationExecuteChangeSetAction.Builder.create()
 *                     .actionName("ExecuteChanges")
 *                     .stackName(stackName)
 *                     .changeSetName(changeSetName)
 *                     .runOrder(3)
 *                     .build()));
 * Pipeline.Builder.create(stack, "Pipeline")
 *         .crossAccountKeys(true)
 *         .stages(List.of(sourceStage, prodStage))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:51.896Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CodeCommitSourceActionProps")
@software.amazon.jsii.Jsii.Proxy(CodeCommitSourceActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CodeCommitSourceActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.CommonAwsActionProps {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getOutput();

    /**
     * The CodeCommit repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.IRepository getRepository();

    /**
     * Default: 'master'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBranch() {
        return null;
    }

    /**
     * Whether the output should be the contents of the repository (which is the default), or a link that allows CodeBuild to clone the repository before building.
     * <p>
     * <strong>Note</strong>: if this option is true,
     * then only CodeBuild actions can use the resulting <code>output</code>.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeCommit.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeCommit.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCodeBuildCloneOutput() {
        return null;
    }

    /**
     * You can pass a <code>customEventRule</code> to set up a custom event rule for the CodeCommit source action.
     * <p>
     * You must provide the <code>eventPattern</code> and <code>target</code> properties in the <code>customEventRule</code> object.
     * Check which <code>eventPattern</code> to use: https://docs.aws.amazon.com/codecommit/latest/userguide/monitoring-events.html
     * <p>
     * Default: Event rule which is triggered by CodeCommit repository on commit
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.ICustomEventRule getCustomEventRule() {
        return null;
    }

    /**
     * Role to be used by on commit event rule.
     * <p>
     * Used only when trigger value is CodeCommitTrigger.EVENTS.
     * <p>
     * Default: a new role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getEventRole() {
        return null;
    }

    /**
     * How should CodePipeline detect source changes for this Action.
     * <p>
     * Default: CodeCommitTrigger.EVENTS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger getTrigger() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodeCommitSourceActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeCommitSourceActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CodeCommitSourceActionProps> {
        software.amazon.awscdk.services.codepipeline.Artifact output;
        software.amazon.awscdk.services.codecommit.IRepository repository;
        java.lang.String branch;
        java.lang.Boolean codeBuildCloneOutput;
        software.amazon.awscdk.services.codepipeline.actions.ICustomEventRule customEventRule;
        software.amazon.awscdk.services.iam.IRole eventRole;
        software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger trigger;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.String actionName;
        java.lang.Number runOrder;
        java.lang.String variablesNamespace;

        /**
         * Sets the value of {@link CodeCommitSourceActionProps#getOutput}
         * @param output the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.output = output;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceActionProps#getRepository}
         * @param repository The CodeCommit repository. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repository(software.amazon.awscdk.services.codecommit.IRepository repository) {
            this.repository = repository;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceActionProps#getBranch}
         * @param branch the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branch(java.lang.String branch) {
            this.branch = branch;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceActionProps#getCodeBuildCloneOutput}
         * @param codeBuildCloneOutput Whether the output should be the contents of the repository (which is the default), or a link that allows CodeBuild to clone the repository before building.
         *                             <strong>Note</strong>: if this option is true,
         *                             then only CodeBuild actions can use the resulting <code>output</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeBuildCloneOutput(java.lang.Boolean codeBuildCloneOutput) {
            this.codeBuildCloneOutput = codeBuildCloneOutput;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceActionProps#getCustomEventRule}
         * @param customEventRule You can pass a <code>customEventRule</code> to set up a custom event rule for the CodeCommit source action.
         *                        You must provide the <code>eventPattern</code> and <code>target</code> properties in the <code>customEventRule</code> object.
         *                        Check which <code>eventPattern</code> to use: https://docs.aws.amazon.com/codecommit/latest/userguide/monitoring-events.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customEventRule(software.amazon.awscdk.services.codepipeline.actions.ICustomEventRule customEventRule) {
            this.customEventRule = customEventRule;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceActionProps#getEventRole}
         * @param eventRole Role to be used by on commit event rule.
         *                  Used only when trigger value is CodeCommitTrigger.EVENTS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRole(software.amazon.awscdk.services.iam.IRole eventRole) {
            this.eventRole = eventRole;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceActionProps#getTrigger}
         * @param trigger How should CodePipeline detect source changes for this Action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trigger(software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger trigger) {
            this.trigger = trigger;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceActionProps#getRole}
         * @param role The Role in which context's this Action will be executing in.
         *             The Pipeline's Role will assume this Role
         *             (the required permissions for that will be granted automatically)
         *             right before executing this Action.
         *             This Action will be passed into your <code>IAction.bind</code>
         *             method in the <code>ActionBindOptions.role</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceActionProps#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceActionProps#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceActionProps#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeCommitSourceActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CodeCommitSourceActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeCommitSourceActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeCommitSourceActionProps {
        private final software.amazon.awscdk.services.codepipeline.Artifact output;
        private final software.amazon.awscdk.services.codecommit.IRepository repository;
        private final java.lang.String branch;
        private final java.lang.Boolean codeBuildCloneOutput;
        private final software.amazon.awscdk.services.codepipeline.actions.ICustomEventRule customEventRule;
        private final software.amazon.awscdk.services.iam.IRole eventRole;
        private final software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger trigger;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.repository = software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.IRepository.class));
            this.branch = software.amazon.jsii.Kernel.get(this, "branch", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.codeBuildCloneOutput = software.amazon.jsii.Kernel.get(this, "codeBuildCloneOutput", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.customEventRule = software.amazon.jsii.Kernel.get(this, "customEventRule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.ICustomEventRule.class));
            this.eventRole = software.amazon.jsii.Kernel.get(this, "eventRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.trigger = software.amazon.jsii.Kernel.get(this, "trigger", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.output = java.util.Objects.requireNonNull(builder.output, "output is required");
            this.repository = java.util.Objects.requireNonNull(builder.repository, "repository is required");
            this.branch = builder.branch;
            this.codeBuildCloneOutput = builder.codeBuildCloneOutput;
            this.customEventRule = builder.customEventRule;
            this.eventRole = builder.eventRole;
            this.trigger = builder.trigger;
            this.role = builder.role;
            this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            this.runOrder = builder.runOrder;
            this.variablesNamespace = builder.variablesNamespace;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getOutput() {
            return this.output;
        }

        @Override
        public final software.amazon.awscdk.services.codecommit.IRepository getRepository() {
            return this.repository;
        }

        @Override
        public final java.lang.String getBranch() {
            return this.branch;
        }

        @Override
        public final java.lang.Boolean getCodeBuildCloneOutput() {
            return this.codeBuildCloneOutput;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.ICustomEventRule getCustomEventRule() {
            return this.customEventRule;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getEventRole() {
            return this.eventRole;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger getTrigger() {
            return this.trigger;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("output", om.valueToTree(this.getOutput()));
            data.set("repository", om.valueToTree(this.getRepository()));
            if (this.getBranch() != null) {
                data.set("branch", om.valueToTree(this.getBranch()));
            }
            if (this.getCodeBuildCloneOutput() != null) {
                data.set("codeBuildCloneOutput", om.valueToTree(this.getCodeBuildCloneOutput()));
            }
            if (this.getCustomEventRule() != null) {
                data.set("customEventRule", om.valueToTree(this.getCustomEventRule()));
            }
            if (this.getEventRole() != null) {
                data.set("eventRole", om.valueToTree(this.getEventRole()));
            }
            if (this.getTrigger() != null) {
                data.set("trigger", om.valueToTree(this.getTrigger()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.CodeCommitSourceActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeCommitSourceActionProps.Jsii$Proxy that = (CodeCommitSourceActionProps.Jsii$Proxy) o;

            if (!output.equals(that.output)) return false;
            if (!repository.equals(that.repository)) return false;
            if (this.branch != null ? !this.branch.equals(that.branch) : that.branch != null) return false;
            if (this.codeBuildCloneOutput != null ? !this.codeBuildCloneOutput.equals(that.codeBuildCloneOutput) : that.codeBuildCloneOutput != null) return false;
            if (this.customEventRule != null ? !this.customEventRule.equals(that.customEventRule) : that.customEventRule != null) return false;
            if (this.eventRole != null ? !this.eventRole.equals(that.eventRole) : that.eventRole != null) return false;
            if (this.trigger != null ? !this.trigger.equals(that.trigger) : that.trigger != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            return this.variablesNamespace != null ? this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.output.hashCode();
            result = 31 * result + (this.repository.hashCode());
            result = 31 * result + (this.branch != null ? this.branch.hashCode() : 0);
            result = 31 * result + (this.codeBuildCloneOutput != null ? this.codeBuildCloneOutput.hashCode() : 0);
            result = 31 * result + (this.customEventRule != null ? this.customEventRule.hashCode() : 0);
            result = 31 * result + (this.eventRole != null ? this.eventRole.hashCode() : 0);
            result = 31 * result + (this.trigger != null ? this.trigger.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            return result;
        }
    }
}
