package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * JenkinsProvider jenkinsProvider = JenkinsProvider.Builder.create(this, "JenkinsProvider")
 *         .providerName("MyJenkinsProvider")
 *         .serverUrl("http://my-jenkins.com:8080")
 *         .version("2")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:51.916Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.JenkinsProviderProps")
@software.amazon.jsii.Jsii.Proxy(JenkinsProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface JenkinsProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Jenkins provider that you set in the AWS CodePipeline plugin configuration of your Jenkins project.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "MyJenkinsProvider";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProviderName();

    /**
     * The base URL of your Jenkins server.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "http://myjenkins.com:8080";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServerUrl();

    /**
     * Whether to immediately register a Jenkins Provider for the build category.
     * <p>
     * The Provider will always be registered if you create a <code>JenkinsAction</code>.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getForBuild() {
        return null;
    }

    /**
     * Whether to immediately register a Jenkins Provider for the test category.
     * <p>
     * The Provider will always be registered if you create a <code>JenkinsTestAction</code>.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getForTest() {
        return null;
    }

    /**
     * The version of your provider.
     * <p>
     * Default: '1'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JenkinsProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JenkinsProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<JenkinsProviderProps> {
        java.lang.String providerName;
        java.lang.String serverUrl;
        java.lang.Boolean forBuild;
        java.lang.Boolean forTest;
        java.lang.String version;

        /**
         * Sets the value of {@link JenkinsProviderProps#getProviderName}
         * @param providerName The name of the Jenkins provider that you set in the AWS CodePipeline plugin configuration of your Jenkins project. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerName(java.lang.String providerName) {
            this.providerName = providerName;
            return this;
        }

        /**
         * Sets the value of {@link JenkinsProviderProps#getServerUrl}
         * @param serverUrl The base URL of your Jenkins server. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverUrl(java.lang.String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        /**
         * Sets the value of {@link JenkinsProviderProps#getForBuild}
         * @param forBuild Whether to immediately register a Jenkins Provider for the build category.
         *                 The Provider will always be registered if you create a <code>JenkinsAction</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forBuild(java.lang.Boolean forBuild) {
            this.forBuild = forBuild;
            return this;
        }

        /**
         * Sets the value of {@link JenkinsProviderProps#getForTest}
         * @param forTest Whether to immediately register a Jenkins Provider for the test category.
         *                The Provider will always be registered if you create a <code>JenkinsTestAction</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forTest(java.lang.Boolean forTest) {
            this.forTest = forTest;
            return this;
        }

        /**
         * Sets the value of {@link JenkinsProviderProps#getVersion}
         * @param version The version of your provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JenkinsProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public JenkinsProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JenkinsProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JenkinsProviderProps {
        private final java.lang.String providerName;
        private final java.lang.String serverUrl;
        private final java.lang.Boolean forBuild;
        private final java.lang.Boolean forTest;
        private final java.lang.String version;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.providerName = software.amazon.jsii.Kernel.get(this, "providerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverUrl = software.amazon.jsii.Kernel.get(this, "serverUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.forBuild = software.amazon.jsii.Kernel.get(this, "forBuild", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.forTest = software.amazon.jsii.Kernel.get(this, "forTest", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.providerName = java.util.Objects.requireNonNull(builder.providerName, "providerName is required");
            this.serverUrl = java.util.Objects.requireNonNull(builder.serverUrl, "serverUrl is required");
            this.forBuild = builder.forBuild;
            this.forTest = builder.forTest;
            this.version = builder.version;
        }

        @Override
        public final java.lang.String getProviderName() {
            return this.providerName;
        }

        @Override
        public final java.lang.String getServerUrl() {
            return this.serverUrl;
        }

        @Override
        public final java.lang.Boolean getForBuild() {
            return this.forBuild;
        }

        @Override
        public final java.lang.Boolean getForTest() {
            return this.forTest;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("providerName", om.valueToTree(this.getProviderName()));
            data.set("serverUrl", om.valueToTree(this.getServerUrl()));
            if (this.getForBuild() != null) {
                data.set("forBuild", om.valueToTree(this.getForBuild()));
            }
            if (this.getForTest() != null) {
                data.set("forTest", om.valueToTree(this.getForTest()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.JenkinsProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JenkinsProviderProps.Jsii$Proxy that = (JenkinsProviderProps.Jsii$Proxy) o;

            if (!providerName.equals(that.providerName)) return false;
            if (!serverUrl.equals(that.serverUrl)) return false;
            if (this.forBuild != null ? !this.forBuild.equals(that.forBuild) : that.forBuild != null) return false;
            if (this.forTest != null ? !this.forTest.equals(that.forTest) : that.forTest != null) return false;
            return this.version != null ? this.version.equals(that.version) : that.version == null;
        }

        @Override
        public final int hashCode() {
            int result = this.providerName.hashCode();
            result = 31 * result + (this.serverUrl.hashCode());
            result = 31 * result + (this.forBuild != null ? this.forBuild.hashCode() : 0);
            result = 31 * result + (this.forTest != null ? this.forTest.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}
