package software.amazon.awscdk.services.cognito;

/**
 * This interface contains standard attributes recognized by Cognito from https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html including built-in attributes <code>email_verified</code> and <code>phone_number_verified</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "Pool");
 * ClientAttributes clientWriteAttributes = (new ClientAttributes()).withStandardAttributes(StandardAttributesMask.builder().fullname(true).email(true).build()).withCustomAttributes("favouritePizza", "favouriteBeverage");
 * ClientAttributes clientReadAttributes = clientWriteAttributes.withStandardAttributes(StandardAttributesMask.builder().emailVerified(true).build()).withCustomAttributes("pointsEarned");
 * pool.addClient("app-client", UserPoolClientOptions.builder()
 *         // ...
 *         .readAttributes(clientReadAttributes)
 *         .writeAttributes(clientWriteAttributes)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:52.091Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.StandardAttributesMask")
@software.amazon.jsii.Jsii.Proxy(StandardAttributesMask.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StandardAttributesMask extends software.amazon.jsii.JsiiSerializable {

    /**
     * The user's postal address.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAddress() {
        return null;
    }

    /**
     * The user's birthday, represented as an ISO 8601:2004 format.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getBirthdate() {
        return null;
    }

    /**
     * The user's e-mail address, represented as an RFC 5322 [RFC5322] addr-spec.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEmail() {
        return null;
    }

    /**
     * Whether the email address has been verified.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEmailVerified() {
        return null;
    }

    /**
     * The surname or last name of the user.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFamilyName() {
        return null;
    }

    /**
     * The user's full name in displayable form, including all name parts, titles and suffixes.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFullname() {
        return null;
    }

    /**
     * The user's gender.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getGender() {
        return null;
    }

    /**
     * The user's first name or give name.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getGivenName() {
        return null;
    }

    /**
     * The time, the user's information was last updated.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLastUpdateTime() {
        return null;
    }

    /**
     * The user's locale, represented as a BCP47 [RFC5646] language tag.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLocale() {
        return null;
    }

    /**
     * The user's middle name.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMiddleName() {
        return null;
    }

    /**
     * The user's nickname or casual name.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getNickname() {
        return null;
    }

    /**
     * The user's telephone number.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPhoneNumber() {
        return null;
    }

    /**
     * Whether the phone number has been verified.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPhoneNumberVerified() {
        return null;
    }

    /**
     * The user's preffered username, different from the immutable user name.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPreferredUsername() {
        return null;
    }

    /**
     * The URL to the user's profile page.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getProfilePage() {
        return null;
    }

    /**
     * The URL to the user's profile picture.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getProfilePicture() {
        return null;
    }

    /**
     * The user's time zone.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTimezone() {
        return null;
    }

    /**
     * The URL to the user's web page or blog.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWebsite() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StandardAttributesMask}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StandardAttributesMask}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StandardAttributesMask> {
        java.lang.Boolean address;
        java.lang.Boolean birthdate;
        java.lang.Boolean email;
        java.lang.Boolean emailVerified;
        java.lang.Boolean familyName;
        java.lang.Boolean fullname;
        java.lang.Boolean gender;
        java.lang.Boolean givenName;
        java.lang.Boolean lastUpdateTime;
        java.lang.Boolean locale;
        java.lang.Boolean middleName;
        java.lang.Boolean nickname;
        java.lang.Boolean phoneNumber;
        java.lang.Boolean phoneNumberVerified;
        java.lang.Boolean preferredUsername;
        java.lang.Boolean profilePage;
        java.lang.Boolean profilePicture;
        java.lang.Boolean timezone;
        java.lang.Boolean website;

        /**
         * Sets the value of {@link StandardAttributesMask#getAddress}
         * @param address The user's postal address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder address(java.lang.Boolean address) {
            this.address = address;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getBirthdate}
         * @param birthdate The user's birthday, represented as an ISO 8601:2004 format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder birthdate(java.lang.Boolean birthdate) {
            this.birthdate = birthdate;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getEmail}
         * @param email The user's e-mail address, represented as an RFC 5322 [RFC5322] addr-spec.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder email(java.lang.Boolean email) {
            this.email = email;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getEmailVerified}
         * @param emailVerified Whether the email address has been verified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailVerified(java.lang.Boolean emailVerified) {
            this.emailVerified = emailVerified;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getFamilyName}
         * @param familyName The surname or last name of the user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder familyName(java.lang.Boolean familyName) {
            this.familyName = familyName;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getFullname}
         * @param fullname The user's full name in displayable form, including all name parts, titles and suffixes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fullname(java.lang.Boolean fullname) {
            this.fullname = fullname;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getGender}
         * @param gender The user's gender.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gender(java.lang.Boolean gender) {
            this.gender = gender;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getGivenName}
         * @param givenName The user's first name or give name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder givenName(java.lang.Boolean givenName) {
            this.givenName = givenName;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getLastUpdateTime}
         * @param lastUpdateTime The time, the user's information was last updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastUpdateTime(java.lang.Boolean lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getLocale}
         * @param locale The user's locale, represented as a BCP47 [RFC5646] language tag.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locale(java.lang.Boolean locale) {
            this.locale = locale;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getMiddleName}
         * @param middleName The user's middle name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder middleName(java.lang.Boolean middleName) {
            this.middleName = middleName;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getNickname}
         * @param nickname The user's nickname or casual name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nickname(java.lang.Boolean nickname) {
            this.nickname = nickname;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getPhoneNumber}
         * @param phoneNumber The user's telephone number.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder phoneNumber(java.lang.Boolean phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getPhoneNumberVerified}
         * @param phoneNumberVerified Whether the phone number has been verified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder phoneNumberVerified(java.lang.Boolean phoneNumberVerified) {
            this.phoneNumberVerified = phoneNumberVerified;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getPreferredUsername}
         * @param preferredUsername The user's preffered username, different from the immutable user name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredUsername(java.lang.Boolean preferredUsername) {
            this.preferredUsername = preferredUsername;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getProfilePage}
         * @param profilePage The URL to the user's profile page.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profilePage(java.lang.Boolean profilePage) {
            this.profilePage = profilePage;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getProfilePicture}
         * @param profilePicture The URL to the user's profile picture.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profilePicture(java.lang.Boolean profilePicture) {
            this.profilePicture = profilePicture;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getTimezone}
         * @param timezone The user's time zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timezone(java.lang.Boolean timezone) {
            this.timezone = timezone;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributesMask#getWebsite}
         * @param website The URL to the user's web page or blog.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder website(java.lang.Boolean website) {
            this.website = website;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StandardAttributesMask}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StandardAttributesMask build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StandardAttributesMask}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StandardAttributesMask {
        private final java.lang.Boolean address;
        private final java.lang.Boolean birthdate;
        private final java.lang.Boolean email;
        private final java.lang.Boolean emailVerified;
        private final java.lang.Boolean familyName;
        private final java.lang.Boolean fullname;
        private final java.lang.Boolean gender;
        private final java.lang.Boolean givenName;
        private final java.lang.Boolean lastUpdateTime;
        private final java.lang.Boolean locale;
        private final java.lang.Boolean middleName;
        private final java.lang.Boolean nickname;
        private final java.lang.Boolean phoneNumber;
        private final java.lang.Boolean phoneNumberVerified;
        private final java.lang.Boolean preferredUsername;
        private final java.lang.Boolean profilePage;
        private final java.lang.Boolean profilePicture;
        private final java.lang.Boolean timezone;
        private final java.lang.Boolean website;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.birthdate = software.amazon.jsii.Kernel.get(this, "birthdate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.email = software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.emailVerified = software.amazon.jsii.Kernel.get(this, "emailVerified", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.familyName = software.amazon.jsii.Kernel.get(this, "familyName", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.fullname = software.amazon.jsii.Kernel.get(this, "fullname", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.gender = software.amazon.jsii.Kernel.get(this, "gender", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.givenName = software.amazon.jsii.Kernel.get(this, "givenName", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.lastUpdateTime = software.amazon.jsii.Kernel.get(this, "lastUpdateTime", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.locale = software.amazon.jsii.Kernel.get(this, "locale", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.middleName = software.amazon.jsii.Kernel.get(this, "middleName", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.nickname = software.amazon.jsii.Kernel.get(this, "nickname", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.phoneNumber = software.amazon.jsii.Kernel.get(this, "phoneNumber", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.phoneNumberVerified = software.amazon.jsii.Kernel.get(this, "phoneNumberVerified", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.preferredUsername = software.amazon.jsii.Kernel.get(this, "preferredUsername", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.profilePage = software.amazon.jsii.Kernel.get(this, "profilePage", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.profilePicture = software.amazon.jsii.Kernel.get(this, "profilePicture", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.timezone = software.amazon.jsii.Kernel.get(this, "timezone", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.website = software.amazon.jsii.Kernel.get(this, "website", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.address = builder.address;
            this.birthdate = builder.birthdate;
            this.email = builder.email;
            this.emailVerified = builder.emailVerified;
            this.familyName = builder.familyName;
            this.fullname = builder.fullname;
            this.gender = builder.gender;
            this.givenName = builder.givenName;
            this.lastUpdateTime = builder.lastUpdateTime;
            this.locale = builder.locale;
            this.middleName = builder.middleName;
            this.nickname = builder.nickname;
            this.phoneNumber = builder.phoneNumber;
            this.phoneNumberVerified = builder.phoneNumberVerified;
            this.preferredUsername = builder.preferredUsername;
            this.profilePage = builder.profilePage;
            this.profilePicture = builder.profilePicture;
            this.timezone = builder.timezone;
            this.website = builder.website;
        }

        @Override
        public final java.lang.Boolean getAddress() {
            return this.address;
        }

        @Override
        public final java.lang.Boolean getBirthdate() {
            return this.birthdate;
        }

        @Override
        public final java.lang.Boolean getEmail() {
            return this.email;
        }

        @Override
        public final java.lang.Boolean getEmailVerified() {
            return this.emailVerified;
        }

        @Override
        public final java.lang.Boolean getFamilyName() {
            return this.familyName;
        }

        @Override
        public final java.lang.Boolean getFullname() {
            return this.fullname;
        }

        @Override
        public final java.lang.Boolean getGender() {
            return this.gender;
        }

        @Override
        public final java.lang.Boolean getGivenName() {
            return this.givenName;
        }

        @Override
        public final java.lang.Boolean getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final java.lang.Boolean getLocale() {
            return this.locale;
        }

        @Override
        public final java.lang.Boolean getMiddleName() {
            return this.middleName;
        }

        @Override
        public final java.lang.Boolean getNickname() {
            return this.nickname;
        }

        @Override
        public final java.lang.Boolean getPhoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public final java.lang.Boolean getPhoneNumberVerified() {
            return this.phoneNumberVerified;
        }

        @Override
        public final java.lang.Boolean getPreferredUsername() {
            return this.preferredUsername;
        }

        @Override
        public final java.lang.Boolean getProfilePage() {
            return this.profilePage;
        }

        @Override
        public final java.lang.Boolean getProfilePicture() {
            return this.profilePicture;
        }

        @Override
        public final java.lang.Boolean getTimezone() {
            return this.timezone;
        }

        @Override
        public final java.lang.Boolean getWebsite() {
            return this.website;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAddress() != null) {
                data.set("address", om.valueToTree(this.getAddress()));
            }
            if (this.getBirthdate() != null) {
                data.set("birthdate", om.valueToTree(this.getBirthdate()));
            }
            if (this.getEmail() != null) {
                data.set("email", om.valueToTree(this.getEmail()));
            }
            if (this.getEmailVerified() != null) {
                data.set("emailVerified", om.valueToTree(this.getEmailVerified()));
            }
            if (this.getFamilyName() != null) {
                data.set("familyName", om.valueToTree(this.getFamilyName()));
            }
            if (this.getFullname() != null) {
                data.set("fullname", om.valueToTree(this.getFullname()));
            }
            if (this.getGender() != null) {
                data.set("gender", om.valueToTree(this.getGender()));
            }
            if (this.getGivenName() != null) {
                data.set("givenName", om.valueToTree(this.getGivenName()));
            }
            if (this.getLastUpdateTime() != null) {
                data.set("lastUpdateTime", om.valueToTree(this.getLastUpdateTime()));
            }
            if (this.getLocale() != null) {
                data.set("locale", om.valueToTree(this.getLocale()));
            }
            if (this.getMiddleName() != null) {
                data.set("middleName", om.valueToTree(this.getMiddleName()));
            }
            if (this.getNickname() != null) {
                data.set("nickname", om.valueToTree(this.getNickname()));
            }
            if (this.getPhoneNumber() != null) {
                data.set("phoneNumber", om.valueToTree(this.getPhoneNumber()));
            }
            if (this.getPhoneNumberVerified() != null) {
                data.set("phoneNumberVerified", om.valueToTree(this.getPhoneNumberVerified()));
            }
            if (this.getPreferredUsername() != null) {
                data.set("preferredUsername", om.valueToTree(this.getPreferredUsername()));
            }
            if (this.getProfilePage() != null) {
                data.set("profilePage", om.valueToTree(this.getProfilePage()));
            }
            if (this.getProfilePicture() != null) {
                data.set("profilePicture", om.valueToTree(this.getProfilePicture()));
            }
            if (this.getTimezone() != null) {
                data.set("timezone", om.valueToTree(this.getTimezone()));
            }
            if (this.getWebsite() != null) {
                data.set("website", om.valueToTree(this.getWebsite()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.StandardAttributesMask"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StandardAttributesMask.Jsii$Proxy that = (StandardAttributesMask.Jsii$Proxy) o;

            if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
            if (this.birthdate != null ? !this.birthdate.equals(that.birthdate) : that.birthdate != null) return false;
            if (this.email != null ? !this.email.equals(that.email) : that.email != null) return false;
            if (this.emailVerified != null ? !this.emailVerified.equals(that.emailVerified) : that.emailVerified != null) return false;
            if (this.familyName != null ? !this.familyName.equals(that.familyName) : that.familyName != null) return false;
            if (this.fullname != null ? !this.fullname.equals(that.fullname) : that.fullname != null) return false;
            if (this.gender != null ? !this.gender.equals(that.gender) : that.gender != null) return false;
            if (this.givenName != null ? !this.givenName.equals(that.givenName) : that.givenName != null) return false;
            if (this.lastUpdateTime != null ? !this.lastUpdateTime.equals(that.lastUpdateTime) : that.lastUpdateTime != null) return false;
            if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) return false;
            if (this.middleName != null ? !this.middleName.equals(that.middleName) : that.middleName != null) return false;
            if (this.nickname != null ? !this.nickname.equals(that.nickname) : that.nickname != null) return false;
            if (this.phoneNumber != null ? !this.phoneNumber.equals(that.phoneNumber) : that.phoneNumber != null) return false;
            if (this.phoneNumberVerified != null ? !this.phoneNumberVerified.equals(that.phoneNumberVerified) : that.phoneNumberVerified != null) return false;
            if (this.preferredUsername != null ? !this.preferredUsername.equals(that.preferredUsername) : that.preferredUsername != null) return false;
            if (this.profilePage != null ? !this.profilePage.equals(that.profilePage) : that.profilePage != null) return false;
            if (this.profilePicture != null ? !this.profilePicture.equals(that.profilePicture) : that.profilePicture != null) return false;
            if (this.timezone != null ? !this.timezone.equals(that.timezone) : that.timezone != null) return false;
            return this.website != null ? this.website.equals(that.website) : that.website == null;
        }

        @Override
        public final int hashCode() {
            int result = this.address != null ? this.address.hashCode() : 0;
            result = 31 * result + (this.birthdate != null ? this.birthdate.hashCode() : 0);
            result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
            result = 31 * result + (this.emailVerified != null ? this.emailVerified.hashCode() : 0);
            result = 31 * result + (this.familyName != null ? this.familyName.hashCode() : 0);
            result = 31 * result + (this.fullname != null ? this.fullname.hashCode() : 0);
            result = 31 * result + (this.gender != null ? this.gender.hashCode() : 0);
            result = 31 * result + (this.givenName != null ? this.givenName.hashCode() : 0);
            result = 31 * result + (this.lastUpdateTime != null ? this.lastUpdateTime.hashCode() : 0);
            result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
            result = 31 * result + (this.middleName != null ? this.middleName.hashCode() : 0);
            result = 31 * result + (this.nickname != null ? this.nickname.hashCode() : 0);
            result = 31 * result + (this.phoneNumber != null ? this.phoneNumber.hashCode() : 0);
            result = 31 * result + (this.phoneNumberVerified != null ? this.phoneNumberVerified.hashCode() : 0);
            result = 31 * result + (this.preferredUsername != null ? this.preferredUsername.hashCode() : 0);
            result = 31 * result + (this.profilePage != null ? this.profilePage.hashCode() : 0);
            result = 31 * result + (this.profilePicture != null ? this.profilePicture.hashCode() : 0);
            result = 31 * result + (this.timezone != null ? this.timezone.hashCode() : 0);
            result = 31 * result + (this.website != null ? this.website.hashCode() : 0);
            return result;
        }
    }
}
