package software.amazon.awscdk.services.cognito;

/**
 * Metadata for a SAML user pool identity provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * UserPoolIdentityProviderSamlMetadata userPoolIdentityProviderSamlMetadata = UserPoolIdentityProviderSamlMetadata.file("fileContent");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:52.109Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolIdentityProviderSamlMetadata")
public class UserPoolIdentityProviderSamlMetadata extends software.amazon.jsii.JsiiObject {

    protected UserPoolIdentityProviderSamlMetadata(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolIdentityProviderSamlMetadata(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Specify SAML metadata via the contents of a file.
     * <p>
     * @param fileContent This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlMetadata file(final @org.jetbrains.annotations.NotNull java.lang.String fileContent) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlMetadata.class, "file", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlMetadata.class), new Object[] { java.util.Objects.requireNonNull(fileContent, "fileContent is required") });
    }

    /**
     * Specify SAML metadata via a URL.
     * <p>
     * @param url This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlMetadata url(final @org.jetbrains.annotations.NotNull java.lang.String url) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlMetadata.class, "url", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlMetadata.class), new Object[] { java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * A URL hosting SAML metadata, or the content of a file containing SAML metadata.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMetadataContent() {
        return software.amazon.jsii.Kernel.get(this, "metadataContent", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of metadata, either a URL or file content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlMetadataType getMetadataType() {
        return software.amazon.jsii.Kernel.get(this, "metadataType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolIdentityProviderSamlMetadataType.class));
    }
}
