package software.amazon.awscdk.services.cognito;

/**
 * Defines a User Pool OAuth2.0 Resource Server.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "Pool");
 * ResourceServerScope readOnlyScope = ResourceServerScope.Builder.create().scopeName("read").scopeDescription("Read-only access").build();
 * ResourceServerScope fullAccessScope = ResourceServerScope.Builder.create().scopeName("*").scopeDescription("Full access").build();
 * UserPoolResourceServer userServer = pool.addResourceServer("ResourceServer", UserPoolResourceServerOptions.builder()
 *         .identifier("users")
 *         .scopes(List.of(readOnlyScope, fullAccessScope))
 *         .build());
 * UserPoolClient readOnlyClient = pool.addClient("read-only-client", UserPoolClientOptions.builder()
 *         // ...
 *         .oAuth(OAuthSettings.builder()
 *                 // ...
 *                 .scopes(List.of(OAuthScope.resourceServer(userServer, readOnlyScope)))
 *                 .build())
 *         .build());
 * UserPoolClient fullAccessClient = pool.addClient("full-access-client", UserPoolClientOptions.builder()
 *         // ...
 *         .oAuth(OAuthSettings.builder()
 *                 // ...
 *                 .scopes(List.of(OAuthScope.resourceServer(userServer, fullAccessScope)))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:52.126Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolResourceServer")
public class UserPoolResourceServer extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cognito.IUserPoolResourceServer {

    protected UserPoolResourceServer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolResourceServer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UserPoolResourceServer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolResourceServerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import a user pool resource client given its id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param userPoolResourceServerId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPoolResourceServer fromUserPoolResourceServerId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String userPoolResourceServerId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPoolResourceServer.class, "fromUserPoolResourceServerId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPoolResourceServer.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(userPoolResourceServerId, "userPoolResourceServerId is required") });
    }

    /**
     * Resource server id.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolResourceServerId() {
        return software.amazon.jsii.Kernel.get(this, "userPoolResourceServerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.UserPoolResourceServer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.UserPoolResourceServer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.UserPoolResourceServerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.UserPoolResourceServerProps.Builder();
        }

        /**
         * A unique resource server identifier for the resource server.
         * <p>
         * @return {@code this}
         * @param identifier A unique resource server identifier for the resource server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identifier(final java.lang.String identifier) {
            this.props.identifier(identifier);
            return this;
        }

        /**
         * Oauth scopes.
         * <p>
         * Default: - No scopes will be added
         * <p>
         * @return {@code this}
         * @param scopes Oauth scopes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopes(final java.util.List<? extends software.amazon.awscdk.services.cognito.ResourceServerScope> scopes) {
            this.props.scopes(scopes);
            return this;
        }

        /**
         * A friendly name for the resource server.
         * <p>
         * Default: - same as `identifier`
         * <p>
         * @return {@code this}
         * @param userPoolResourceServerName A friendly name for the resource server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolResourceServerName(final java.lang.String userPoolResourceServerName) {
            this.props.userPoolResourceServerName(userPoolResourceServerName);
            return this;
        }

        /**
         * The user pool to add this resource server to.
         * <p>
         * @return {@code this}
         * @param userPool The user pool to add this resource server to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(final software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.props.userPool(userPool);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cognito.UserPoolResourceServer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.UserPoolResourceServer build() {
            return new software.amazon.awscdk.services.cognito.UserPoolResourceServer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
