package software.amazon.awscdk.services.config;

/**
 * Resources types that are supported by AWS Config.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Lambda function containing logic that evaluates compliance with the rule.
 * Function evalComplianceFn = Function.Builder.create(this, "CustomFunction")
 *         .code(AssetCode.fromInline("exports.handler = (event) =&gt; console.log(event);"))
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .build();
 * // A custom rule that runs on configuration changes of EC2 instances
 * CustomRule customRule = CustomRule.Builder.create(this, "Custom")
 *         .configurationChanges(true)
 *         .lambdaFunction(evalComplianceFn)
 *         .ruleScope(RuleScope.fromResource(ResourceType.EC2_INSTANCE))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html">https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:52.217Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.ResourceType")
public class ResourceType extends software.amazon.jsii.JsiiObject {

    protected ResourceType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ResourceType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ACM_CERTIFICATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ACM_CERTIFICATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AMAZON_MQ_BROKER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AMAZON_MQ_BROKER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APIGATEWAY_REST_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APIGATEWAY_REST_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APIGATEWAY_STAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APIGATEWAY_STAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APIGATEWAYV2_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APIGATEWAYV2_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APIGATEWAYV2_STAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APIGATEWAYV2_STAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APPCONFIG_APPLICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APPCONFIG_APPLICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APPCONFIG_CONFIGURATION_PROFILE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APPCONFIG_CONFIGURATION_PROFILE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APPCONFIG_ENVIRONMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APPCONFIG_ENVIRONMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        APPSYNC_GRAPHQL_API = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "APPSYNC_GRAPHQL_API", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AUTO_SCALING_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AUTO_SCALING_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AUTO_SCALING_LAUNCH_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AUTO_SCALING_LAUNCH_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AUTO_SCALING_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AUTO_SCALING_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        AUTO_SCALING_SCHEDULED_ACTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "AUTO_SCALING_SCHEDULED_ACTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BACKUP_BACKUP_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BACKUP_BACKUP_PLAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BACKUP_BACKUP_SELECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BACKUP_BACKUP_SELECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BACKUP_BACKUP_VAULT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BACKUP_BACKUP_VAULT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BACKUP_RECOVERY_POINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BACKUP_RECOVERY_POINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BACKUP_REPORT_PLAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BACKUP_REPORT_PLAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BATCH_COMPUTE_ENVIRONMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BATCH_COMPUTE_ENVIRONMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        BATCH_JOB_QUEUE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "BATCH_JOB_QUEUE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUD9_ENVIRONMENT_EC2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUD9_ENVIRONMENT_EC2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDFORMATION_STACK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDFORMATION_STACK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDFRONT_DISTRIBUTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDFRONT_DISTRIBUTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDFRONT_STREAMING_DISTRIBUTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDFRONT_STREAMING_DISTRIBUTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDTRAIL_TRAIL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDTRAIL_TRAIL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDWATCH_ALARM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDWATCH_ALARM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CLOUDWATCH_RUM_APP_MONITOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CLOUDWATCH_RUM_APP_MONITOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODEBUILD_PROJECT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODEBUILD_PROJECT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODEDEPLOY_APPLICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODEDEPLOY_APPLICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODEDEPLOY_DEPLOYMENT_CONFIG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODEDEPLOY_DEPLOYMENT_CONFIG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODEDEPLOY_DEPLOYMENT_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODEDEPLOY_DEPLOYMENT_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CODEPIPELINE_PIPELINE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CODEPIPELINE_PIPELINE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CONFIG_CONFORMANCE_PACK_COMPLIANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CONFIG_CONFORMANCE_PACK_COMPLIANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        CONFIG_RESOURCE_COMPLIANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "CONFIG_RESOURCE_COMPLIANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_EFS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_EFS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_FSX_LUSTRE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_FSX_LUSTRE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_FSX_WINDOWS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_FSX_WINDOWS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_HDFS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_HDFS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_NFS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_NFS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_OBJECT_STORAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_OBJECT_STORAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_S3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_S3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_LOCATION_SMB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_LOCATION_SMB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DATASYNC_TASK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DATASYNC_TASK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DMS_EVENT_SUBSCRIPTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DMS_EVENT_SUBSCRIPTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DMS_REPLICATION_SUBNET_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DMS_REPLICATION_SUBNET_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        DYNAMODB_TABLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "DYNAMODB_TABLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EBS_VOLUME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EBS_VOLUME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_CUSTOMER_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_CUSTOMER_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_EGRESS_ONLY_INTERNET_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_EGRESS_ONLY_INTERNET_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_EIP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_EIP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_FLOW_LOG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_FLOW_LOG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_HOST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_HOST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_INSTANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_INTERNET_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_INTERNET_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_LAUNCH_TEMPLATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_LAUNCH_TEMPLATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_NAT_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_NAT_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_NETWORK_ACL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_NETWORK_ACL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_NETWORK_INTERFACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_NETWORK_INTERFACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_REGISTERED_HA_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_REGISTERED_HA_INSTANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_ROUTE_TABLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_ROUTE_TABLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_SECURITY_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_SECURITY_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_SUBNET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_SUBNET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_TRANSIT_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_TRANSIT_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_TRANSIT_GATEWAY_ATTACHMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_TRANSIT_GATEWAY_ATTACHMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_TRANSIT_GATEWAY_ROUTE_TABLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_TRANSIT_GATEWAY_ROUTE_TABLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPC_ENDPOINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPC_ENDPOINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPC_ENDPOINT_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPC_ENDPOINT_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPC_PEERING_CONNECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPC_PEERING_CONNECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPN_CONNECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPN_CONNECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EC2_VPN_GATEWAY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EC2_VPN_GATEWAY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECR_PUBLIC_REPOSITORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECR_PUBLIC_REPOSITORY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECR_REGISTRY_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECR_REGISTRY_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECR_REPOSITORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECR_REPOSITORY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECS_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECS_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECS_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECS_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ECS_TASK_DEFINITION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ECS_TASK_DEFINITION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EFS_ACCESS_POINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EFS_ACCESS_POINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EFS_FILE_SYSTEM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EFS_FILE_SYSTEM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EKS_ADDON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EKS_ADDON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EKS_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EKS_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EKS_IDENTITY_PROVIDER_CONFIG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EKS_IDENTITY_PROVIDER_CONFIG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELASTIC_BEANSTALK_APPLICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELASTIC_BEANSTALK_APPLICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELASTIC_BEANSTALK_APPLICATION_VERSION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELASTIC_BEANSTALK_APPLICATION_VERSION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELASTIC_BEANSTALK_ENVIRONMENT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELASTIC_BEANSTALK_ENVIRONMENT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELASTICSEARCH_DOMAIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELASTICSEARCH_DOMAIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELB_LOAD_BALANCER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELB_LOAD_BALANCER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELBV2_LISTENER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELBV2_LISTENER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ELBV2_LOAD_BALANCER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ELBV2_LOAD_BALANCER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EMR_SECURITY_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EMR_SECURITY_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTBRIDGE_API_DESTINATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTBRIDGE_API_DESTINATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTBRIDGE_ARCHIVE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTBRIDGE_ARCHIVE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTBRIDGE_ENDPOINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTBRIDGE_ENDPOINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTBRIDGE_EVENTBUS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTBRIDGE_EVENTBUS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTSCHEMAS_DISCOVERER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTSCHEMAS_DISCOVERER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTSCHEMAS_REGISTRY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTSCHEMAS_REGISTRY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        EVENTSCHEMAS_REGISTRY_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "EVENTSCHEMAS_REGISTRY_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        FIS_EXPERIMENT_TEMPLATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "FIS_EXPERIMENT_TEMPLATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        FRAUDDETECTOR_ENTITY_TYPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "FRAUDDETECTOR_ENTITY_TYPE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        FRAUDDETECTOR_LABEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "FRAUDDETECTOR_LABEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        FRAUDDETECTOR_OUTCOME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "FRAUDDETECTOR_OUTCOME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        FRAUDDETECTOR_VARIABLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "FRAUDDETECTOR_VARIABLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GLOBALACCELERATOR_ACCELERATOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GLOBALACCELERATOR_ACCELERATOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GLOBALACCELERATOR_ENDPOINT_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GLOBALACCELERATOR_ENDPOINT_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GLOBALACCELERATOR_LISTENER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GLOBALACCELERATOR_LISTENER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GLUE_CLASSIFIER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GLUE_CLASSIFIER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GLUE_JOB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GLUE_JOB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GLUE_ML_TRANSFORM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GLUE_ML_TRANSFORM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GUARDDUTY_DETECTOR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GUARDDUTY_DETECTOR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GUARDDUTY_FILTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GUARDDUTY_FILTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GUARDDUTY_IP_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GUARDDUTY_IP_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        GUARDDUTY_THREAT_INTEL_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "GUARDDUTY_THREAT_INTEL_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_ACCESSANALYZER_ANALYZER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_ACCESSANALYZER_ANALYZER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_ROLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_ROLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IAM_USER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IAM_USER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IMAGEBUILDER_CONTAINER_RECIPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IMAGEBUILDER_CONTAINER_RECIPE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IMAGEBUILDER_DISTRIBUTION_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IMAGEBUILDER_DISTRIBUTION_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IMAGEBUILDER_INFRASTRUCTURE_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IMAGEBUILDER_INFRASTRUCTURE_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_ANALYTICS_CHANNEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_ANALYTICS_CHANNEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_ANALYTICS_DATASET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_ANALYTICS_DATASET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_ANALYTICS_DATASTORE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_ANALYTICS_DATASTORE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_ANALYTICS_PIPELINE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_ANALYTICS_PIPELINE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_AUTHORIZER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_AUTHORIZER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_DIMENSION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_DIMENSION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_EVENTS_ALARM_MODEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_EVENTS_ALARM_MODEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_EVENTS_DETECTOR_MODEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_EVENTS_DETECTOR_MODEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_EVENTS_INPUT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_EVENTS_INPUT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_MITIGATION_ACTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_MITIGATION_ACTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_ROLE_ALIAS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_ROLE_ALIAS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_SECURITY_PROFILE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_SECURITY_PROFILE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_SITEWISE_ASSETMODEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_SITEWISE_ASSETMODEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_SITEWISE_DASHBOARD = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_SITEWISE_DASHBOARD", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_SITEWISE_PORTAL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_SITEWISE_PORTAL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_SITEWISE_PROJECT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_SITEWISE_PROJECT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_TWINMAKER_ENTITY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_TWINMAKER_ENTITY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IOT_TWINMAKER_WORKSPACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IOT_TWINMAKER_WORKSPACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IVS_CHANNEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IVS_CHANNEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IVS_PLAYBACK_KEYPAIR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IVS_PLAYBACK_KEYPAIR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        IVS_RECORDING_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "IVS_RECORDING_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KINESIS_ANALYTICS_V2_APPLICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KINESIS_ANALYTICS_V2_APPLICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KINESIS_STREAM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KINESIS_STREAM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KINESIS_STREAM_CONSUMER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KINESIS_STREAM_CONSUMER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        KMS_KEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "KMS_KEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LAMBDA_FUNCTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LAMBDA_FUNCTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LIGHTSAIL_BUCKET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LIGHTSAIL_BUCKET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LIGHTSAIL_CERTIFICATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LIGHTSAIL_CERTIFICATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LIGHTSAIL_DISK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LIGHTSAIL_DISK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        LIGHTSAIL_STATIC_IP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "LIGHTSAIL_STATIC_IP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        MEDIAPACKAGE_PACKAGING_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "MEDIAPACKAGE_PACKAGING_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        MSK_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "MSK_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        NETWORK_FIREWALL_FIREWALL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "NETWORK_FIREWALL_FIREWALL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        NETWORK_FIREWALL_FIREWALL_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "NETWORK_FIREWALL_FIREWALL_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        NETWORK_FIREWALL_RULE_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "NETWORK_FIREWALL_RULE_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        OPENSEARCH_DOMAIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "OPENSEARCH_DOMAIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        QLDB_LEDGER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "QLDB_LEDGER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_CLUSTER_SNAPSHOT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_CLUSTER_SNAPSHOT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_INSTANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_SECURITY_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_SECURITY_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_SNAPSHOT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_SNAPSHOT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_DB_SUBNET_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_DB_SUBNET_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_EVENT_SUBSCRIPTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_EVENT_SUBSCRIPTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RDS_GLOBAL_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RDS_GLOBAL_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_CLUSTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_CLUSTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_CLUSTER_PARAMETER_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_CLUSTER_PARAMETER_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_CLUSTER_SECURITY_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_CLUSTER_SECURITY_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_CLUSTER_SNAPSHOT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_CLUSTER_SNAPSHOT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_CLUSTER_SUBNET_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_CLUSTER_SUBNET_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        REDSHIFT_EVENT_SUBSCRIPTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "REDSHIFT_EVENT_SUBSCRIPTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        RESILIENCEHUB_RESILIENCY_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "RESILIENCEHUB_RESILIENCY_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_HEALTH_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_HEALTH_CHECK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_HOSTED_ZONE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_HOSTED_ZONE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RECOVERY_READINESS_CELL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RECOVERY_READINESS_CELL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RECOVERY_READINESS_READINESS_CHECK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RECOVERY_READINESS_READINESS_CHECK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RECOVERY_READINESS_RECOVERY_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RECOVERY_READINESS_RECOVERY_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RESOLVER_RESOLVER_ENDPOINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RESOLVER_RESOLVER_ENDPOINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RESOLVER_RESOLVER_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RESOLVER_RESOLVER_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        ROUTE53_RESOLVER_RESOLVER_RULE_ASSOCIATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "ROUTE53_RESOLVER_RESOLVER_RULE_ASSOCIATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        S3_ACCOUNT_PUBLIC_ACCESS_BLOCK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "S3_ACCOUNT_PUBLIC_ACCESS_BLOCK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        S3_BUCKET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "S3_BUCKET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        S3_MULTIREGION_ACCESS_POINT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "S3_MULTIREGION_ACCESS_POINT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGEMAKER_CODE_REPOSITORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGEMAKER_CODE_REPOSITORY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGEMAKER_MODEL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGEMAKER_MODEL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGEMAKER_NOTEBOOK_INSTANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGEMAKER_NOTEBOOK_INSTANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SAGEMAKER_WORKTEAM = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SAGEMAKER_WORKTEAM", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SECRETS_MANAGER_SECRET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SECRETS_MANAGER_SECRET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICE_CATALOG_CLOUDFORMATION_PRODUCT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICE_CATALOG_CLOUDFORMATION_PRODUCT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICE_CATALOG_CLOUDFORMATION_PROVISIONED_PRODUCT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICE_CATALOG_CLOUDFORMATION_PROVISIONED_PRODUCT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICE_CATALOG_PORTFOLIO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICE_CATALOG_PORTFOLIO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICEDISCOVERY_HTTP_NAMESPACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICEDISCOVERY_HTTP_NAMESPACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICEDISCOVERY_PUBLIC_DNS_NAMESPACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICEDISCOVERY_PUBLIC_DNS_NAMESPACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SERVICEDISCOVERY_SERVICE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SERVICEDISCOVERY_SERVICE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SES_CONFIGURATION_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SES_CONFIGURATION_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SES_CONTACT_LIST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SES_CONTACT_LIST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SES_RECEIPT_FILTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SES_RECEIPT_FILTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SES_RECEIPT_RECEIPT_RULE_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SES_RECEIPT_RECEIPT_RULE_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SES_TEMPLATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SES_TEMPLATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SHIELD_PROTECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SHIELD_PROTECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SHIELD_REGIONAL_PROTECTION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SHIELD_REGIONAL_PROTECTION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SNS_TOPIC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SNS_TOPIC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SQS_QUEUE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SQS_QUEUE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        STEPFUNCTIONS_ACTIVITY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "STEPFUNCTIONS_ACTIVITY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        STEPFUNCTIONS_STATE_MACHINE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "STEPFUNCTIONS_STATE_MACHINE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SYSTEMS_MANAGER_ASSOCIATION_COMPLIANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SYSTEMS_MANAGER_ASSOCIATION_COMPLIANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SYSTEMS_MANAGER_FILE_DATA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SYSTEMS_MANAGER_FILE_DATA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SYSTEMS_MANAGER_MANAGED_INSTANCE_INVENTORY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SYSTEMS_MANAGER_MANAGED_INSTANCE_INVENTORY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        SYSTEMS_MANAGER_PATCH_COMPLIANCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "SYSTEMS_MANAGER_PATCH_COMPLIANCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        TRANSFER_WORKFLOW = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "TRANSFER_WORKFLOW", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_RATE_BASED_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_RATE_BASED_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_REGIONAL_RATE_BASED_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_REGIONAL_RATE_BASED_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_REGIONAL_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_REGIONAL_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_REGIONAL_RULE_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_REGIONAL_RULE_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_REGIONAL_WEB_ACL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_REGIONAL_WEB_ACL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_RULE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_RULE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_RULE_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_RULE_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAF_WEB_ACL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAF_WEB_ACL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAFV2_IP_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAFV2_IP_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAFV2_MANAGED_RULE_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAFV2_MANAGED_RULE_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAFV2_REGEX_PATTERN_SET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAFV2_REGEX_PATTERN_SET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAFV2_RULE_GROUP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAFV2_RULE_GROUP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WAFV2_WEB_ACL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WAFV2_WEB_ACL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WORKSPACES_CONNECTION_ALIAS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WORKSPACES_CONNECTION_ALIAS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        WORKSPACES_WORKSPACE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "WORKSPACES_WORKSPACE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
        XRAY_ENCRYPTION_CONFIGURATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.ResourceType.class, "XRAY_ENCRYPTION_CONFIGURATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class));
    }

    /**
     * A custom resource type to support future cases.
     * <p>
     * @param type This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.ResourceType of(final @org.jetbrains.annotations.NotNull java.lang.String type) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.config.ResourceType.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class), new Object[] { java.util.Objects.requireNonNull(type, "type is required") });
    }

    /**
     * AWS Certificate manager certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ACM_CERTIFICATE;

    /**
     * Amazon MQ broker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AMAZON_MQ_BROKER;

    /**
     * API Gateway REST API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APIGATEWAY_REST_API;

    /**
     * API Gateway Stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APIGATEWAY_STAGE;

    /**
     * API Gatewayv2 API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APIGATEWAYV2_API;

    /**
     * API Gatewayv2 Stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APIGATEWAYV2_STAGE;

    /**
     * AWS AppConfig application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APPCONFIG_APPLICATION;

    /**
     * AWS AppConfig configuration profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APPCONFIG_CONFIGURATION_PROFILE;

    /**
     * AWS AppConfig environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APPCONFIG_ENVIRONMENT;

    /**
     * AWS AppSync GraphQL Api.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType APPSYNC_GRAPHQL_API;

    /**
     * AWS Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AUTO_SCALING_GROUP;

    /**
     * AWS Auto Scaling launch configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AUTO_SCALING_LAUNCH_CONFIGURATION;

    /**
     * AWS Auto Scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AUTO_SCALING_POLICY;

    /**
     * AWS Auto Scaling scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType AUTO_SCALING_SCHEDULED_ACTION;

    /**
     * AWS Backup backup plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BACKUP_BACKUP_PLAN;

    /**
     * AWS Backup backup selection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BACKUP_BACKUP_SELECTION;

    /**
     * AWS Backup backup vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BACKUP_BACKUP_VAULT;

    /**
     * AWS Backup recovery point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BACKUP_RECOVERY_POINT;

    /**
     * AWS Backup report plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BACKUP_REPORT_PLAN;

    /**
     * AWS Batch compute environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BATCH_COMPUTE_ENVIRONMENT;

    /**
     * AWS Batch job queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType BATCH_JOB_QUEUE;

    /**
     * AWS Cloud9 environment EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUD9_ENVIRONMENT_EC2;

    /**
     * AWS CloudFormation stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDFORMATION_STACK;

    /**
     * Amazon CloudFront Distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDFRONT_DISTRIBUTION;

    /**
     * Amazon CloudFront streaming distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDFRONT_STREAMING_DISTRIBUTION;

    /**
     * AWS CloudTrail trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDTRAIL_TRAIL;

    /**
     * Amazon CloudWatch Alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDWATCH_ALARM;

    /**
     * Amazon CloudWatch RUM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CLOUDWATCH_RUM_APP_MONITOR;

    /**
     * AWS CodeBuild project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODEBUILD_PROJECT;

    /**
     * AWS CodeDeploy application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODEDEPLOY_APPLICATION;

    /**
     * AWS CodeDeploy deployment config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODEDEPLOY_DEPLOYMENT_CONFIG;

    /**
     * AWS CodeDeploy deployment group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODEDEPLOY_DEPLOYMENT_GROUP;

    /**
     * AWS CodePipeline pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CODEPIPELINE_PIPELINE;

    /**
     * AWS Config conformance pack compliance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CONFIG_CONFORMANCE_PACK_COMPLIANCE;

    /**
     * AWS Config resource compliance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType CONFIG_RESOURCE_COMPLIANCE;

    /**
     * AWS DataSync location EFS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_EFS;

    /**
     * AWS DataSync location FSx Lustre.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_FSX_LUSTRE;

    /**
     * AWS DataSync location FSx Windows.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_FSX_WINDOWS;

    /**
     * AWS DataSync location HDFS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_HDFS;

    /**
     * AWS DataSync location NFS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_NFS;

    /**
     * AWS DataSync location object storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_OBJECT_STORAGE;

    /**
     * AWS DataSync location S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_S3;

    /**
     * AWS DataSync location SMB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_LOCATION_SMB;

    /**
     * AWS DataSync task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DATASYNC_TASK;

    /**
     * AWS DMS event subscription.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DMS_EVENT_SUBSCRIPTION;

    /**
     * AWS DMS replication subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DMS_REPLICATION_SUBNET_GROUP;

    /**
     * Amazon DynamoDB Table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType DYNAMODB_TABLE;

    /**
     * Elastic Block Store (EBS) volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EBS_VOLUME;

    /**
     * Amazon EC2 customer gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_CUSTOMER_GATEWAY;

    /**
     * EC2 Egress only internet gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_EGRESS_ONLY_INTERNET_GATEWAY;

    /**
     * EC2 Elastic IP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_EIP;

    /**
     * EC2 flow log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_FLOW_LOG;

    /**
     * EC2 host.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_HOST;

    /**
     * EC2 instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_INSTANCE;

    /**
     * Amazon EC2 internet gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_INTERNET_GATEWAY;

    /**
     * EC2 launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_LAUNCH_TEMPLATE;

    /**
     * EC2 NAT gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_NAT_GATEWAY;

    /**
     * Amazon EC2 network ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_NETWORK_ACL;

    /**
     * EC2 Network Insights Access Scope Analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS;

    /**
     * EC2 Network Interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_NETWORK_INTERFACE;

    /**
     * EC2 registered HA instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_REGISTERED_HA_INSTANCE;

    /**
     * Amazon EC2 route table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_ROUTE_TABLE;

    /**
     * EC2 security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_SECURITY_GROUP;

    /**
     * Amazon EC2 subnet table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_SUBNET;

    /**
     * EC2 transit gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_TRANSIT_GATEWAY;

    /**
     * EC2 transit gateway attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_TRANSIT_GATEWAY_ATTACHMENT;

    /**
     * EC2 transit gateway route table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_TRANSIT_GATEWAY_ROUTE_TABLE;

    /**
     * Amazon EC2 VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPC;

    /**
     * EC2 VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPC_ENDPOINT;

    /**
     * EC2 VPC endpoint service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPC_ENDPOINT_SERVICE;

    /**
     * EC2 VPC peering connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPC_PEERING_CONNECTION;

    /**
     * Amazon EC2 VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPN_CONNECTION;

    /**
     * Amazon EC2 VPN gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EC2_VPN_GATEWAY;

    /**
     * Amazon ECR public repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECR_PUBLIC_REPOSITORY;

    /**
     * Amazon ECR registry policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECR_REGISTRY_POLICY;

    /**
     * Amazon ECR repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECR_REPOSITORY;

    /**
     * Amazon ECS cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECS_CLUSTER;

    /**
     * Amazon ECS service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECS_SERVICE;

    /**
     * Amazon ECS task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ECS_TASK_DEFINITION;

    /**
     * Amazon EFS access point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EFS_ACCESS_POINT;

    /**
     * Amazon EFS file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EFS_FILE_SYSTEM;

    /**
     * Amazon Elastic Kubernetes Service addon.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EKS_ADDON;

    /**
     * Amazon Elastic Kubernetes Service cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EKS_CLUSTER;

    /**
     * Amazon Elastic Kubernetes Service identity provider config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EKS_IDENTITY_PROVIDER_CONFIG;

    /**
     * AWS Elastic Beanstalk (EB) application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELASTIC_BEANSTALK_APPLICATION;

    /**
     * AWS Elastic Beanstalk (EB) application version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELASTIC_BEANSTALK_APPLICATION_VERSION;

    /**
     * AWS Elastic Beanstalk (EB) environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELASTIC_BEANSTALK_ENVIRONMENT;

    /**
     * Amazon ElasticSearch domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELASTICSEARCH_DOMAIN;

    /**
     * AWS ELB classic load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELB_LOAD_BALANCER;

    /**
     * AWS ELBv2 application load balancer listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELBV2_LISTENER;

    /**
     * AWS ELBv2 network load balancer or AWS ELBv2 application load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ELBV2_LOAD_BALANCER;

    /**
     * Amazon EMR security configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EMR_SECURITY_CONFIGURATION;

    /**
     * Amazon EventBridge Api Destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTBRIDGE_API_DESTINATION;

    /**
     * Amazon EventBridge Archive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTBRIDGE_ARCHIVE;

    /**
     * Amazon EventBridge Endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTBRIDGE_ENDPOINT;

    /**
     * Amazon EventBridge EventBus.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTBRIDGE_EVENTBUS;

    /**
     * Amazon EventBridge EventSchemas discoverer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTSCHEMAS_DISCOVERER;

    /**
     * Amazon EventBridge EventSchemas registry.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTSCHEMAS_REGISTRY;

    /**
     * Amazon EventBridge EventSchemas registry policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType EVENTSCHEMAS_REGISTRY_POLICY;

    /**
     * AWS Fault Injection Simulator Experiment_Template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType FIS_EXPERIMENT_TEMPLATE;

    /**
     * AWS FraudDetector entity type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType FRAUDDETECTOR_ENTITY_TYPE;

    /**
     * AWS FraudDetector label.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType FRAUDDETECTOR_LABEL;

    /**
     * AWS FraudDetector outcome.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType FRAUDDETECTOR_OUTCOME;

    /**
     * AWS FraudDetector variable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType FRAUDDETECTOR_VARIABLE;

    /**
     * AWS GlobalAccelerator accelerator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GLOBALACCELERATOR_ACCELERATOR;

    /**
     * AWS GlobalAccelerator endpoint group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GLOBALACCELERATOR_ENDPOINT_GROUP;

    /**
     * AWS GlobalAccelerator listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GLOBALACCELERATOR_LISTENER;

    /**
     * AWS Glue Classifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GLUE_CLASSIFIER;

    /**
     * AWS Glue Job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GLUE_JOB;

    /**
     * AWS Glue machine learning transform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GLUE_ML_TRANSFORM;

    /**
     * Amazon GuardDuty detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GUARDDUTY_DETECTOR;

    /**
     * Amazon GuardDuty Filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GUARDDUTY_FILTER;

    /**
     * Amazon GuardDuty IP Set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GUARDDUTY_IP_SET;

    /**
     * Amazon GuardDuty Threat Intel Set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType GUARDDUTY_THREAT_INTEL_SET;

    /**
     * AWS IAM AccessAnalyzer analyzer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_ACCESSANALYZER_ANALYZER;

    /**
     * AWS IAM group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_GROUP;

    /**
     * AWS IAM policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_POLICY;

    /**
     * AWS IAM role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_ROLE;

    /**
     * AWS IAM user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IAM_USER;

    /**
     * EC2 Image Builder ContainerRecipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IMAGEBUILDER_CONTAINER_RECIPE;

    /**
     * EC2 Image Builder DistributionConfiguration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IMAGEBUILDER_DISTRIBUTION_CONFIGURATION;

    /**
     * EC2 Image Builder InfrastructureConfiguration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IMAGEBUILDER_INFRASTRUCTURE_CONFIGURATION;

    /**
     * AWS IoT Analytics channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_ANALYTICS_CHANNEL;

    /**
     * AWS IoT Analytics dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_ANALYTICS_DATASET;

    /**
     * AWS IoT Analytics datastore.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_ANALYTICS_DATASTORE;

    /**
     * AWS IoT Analytics pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_ANALYTICS_PIPELINE;

    /**
     * AWS IoT authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_AUTHORIZER;

    /**
     * AWS IoT dimension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_DIMENSION;

    /**
     * AWS IoT Events Alarm Model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_EVENTS_ALARM_MODEL;

    /**
     * AWS IoT Events Detector Model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_EVENTS_DETECTOR_MODEL;

    /**
     * AWS IoT Events Input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_EVENTS_INPUT;

    /**
     * AWS IoT mitigation action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_MITIGATION_ACTION;

    /**
     * AWS IoT policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_POLICY;

    /**
     * AWS IoT role alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_ROLE_ALIAS;

    /**
     * AWS IoT security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_SECURITY_PROFILE;

    /**
     * AWS IoT SiteWise asset model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_SITEWISE_ASSETMODEL;

    /**
     * AWS IoT SiteWise dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_SITEWISE_DASHBOARD;

    /**
     * AWS IoT SiteWise portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_SITEWISE_PORTAL;

    /**
     * AWS IoT SiteWise project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_SITEWISE_PROJECT;

    /**
     * AWS IoT TwinMaker entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_TWINMAKER_ENTITY;

    /**
     * AWS IoT TwinMaker workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IOT_TWINMAKER_WORKSPACE;

    /**
     * Amazon Interactive Video Service (IVS) channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IVS_CHANNEL;

    /**
     * Amazon Interactive Video Service (IVS) playback key pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IVS_PLAYBACK_KEYPAIR;

    /**
     * Amazon Interactive Video Service (IVS) recording configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType IVS_RECORDING_CONFIGURATION;

    /**
     * Amazon Kinesis Analytics V2 application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KINESIS_ANALYTICS_V2_APPLICATION;

    /**
     * Amazon Kinesis stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KINESIS_STREAM;

    /**
     * Amazon Kinesis stream consumer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KINESIS_STREAM_CONSUMER;

    /**
     * AWS KMS Key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType KMS_KEY;

    /**
     * AWS Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LAMBDA_FUNCTION;

    /**
     * AWS Lightsail bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LIGHTSAIL_BUCKET;

    /**
     * Amazon Lightsail Certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LIGHTSAIL_CERTIFICATE;

    /**
     * Amazon Lightsail Disk.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LIGHTSAIL_DISK;

    /**
     * AWS Lightsail static IP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType LIGHTSAIL_STATIC_IP;

    /**
     * AWS Elemental MediaPackage packaging group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType MEDIAPACKAGE_PACKAGING_GROUP;

    /**
     * Amazon MSK cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType MSK_CLUSTER;

    /**
     * AWS Network Firewall Firewall.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType NETWORK_FIREWALL_FIREWALL;

    /**
     * AWS Network Firewall Firewall Policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType NETWORK_FIREWALL_FIREWALL_POLICY;

    /**
     * AWS Network Firewall Rule Group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType NETWORK_FIREWALL_RULE_GROUP;

    /**
     * Amazon OpenSearch domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType OPENSEARCH_DOMAIN;

    /**
     * Amazon QLDB ledger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType QLDB_LEDGER;

    /**
     * Amazon RDS database cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_CLUSTER;

    /**
     * Amazon RDS database cluster snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_CLUSTER_SNAPSHOT;

    /**
     * Amazon RDS database instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_INSTANCE;

    /**
     * Amazon RDS database security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_SECURITY_GROUP;

    /**
     * Amazon RDS database snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_SNAPSHOT;

    /**
     * Amazon RDS database subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_DB_SUBNET_GROUP;

    /**
     * Amazon RDS event subscription.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_EVENT_SUBSCRIPTION;

    /**
     * Amazon RDS global cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RDS_GLOBAL_CLUSTER;

    /**
     * Amazon Redshift cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_CLUSTER;

    /**
     * Amazon Redshift cluster parameter group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_CLUSTER_PARAMETER_GROUP;

    /**
     * Amazon Redshift cluster security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_CLUSTER_SECURITY_GROUP;

    /**
     * Amazon Redshift cluster snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_CLUSTER_SNAPSHOT;

    /**
     * Amazon Redshift cluster subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_CLUSTER_SUBNET_GROUP;

    /**
     * Amazon Redshift event subscription.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType REDSHIFT_EVENT_SUBSCRIPTION;

    /**
     * AWS ResilienceHub resiliency policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType RESILIENCEHUB_RESILIENCY_POLICY;

    /**
     * Amazon Route53 Health Check.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_HEALTH_CHECK;

    /**
     * Amazon Route53 Hosted Zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_HOSTED_ZONE;

    /**
     * Amazon Route 53 Application Recovery Controller Cell.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RECOVERY_READINESS_CELL;

    /**
     * Amazon Route 53 Application Recovery Controller Readiness Check.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RECOVERY_READINESS_READINESS_CHECK;

    /**
     * Amazon Route53 recovery readiness recovery group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RECOVERY_READINESS_RECOVERY_GROUP;

    /**
     * Amazon Route53 resolver resolver endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RESOLVER_RESOLVER_ENDPOINT;

    /**
     * Amazon Route53 resolver resolver rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RESOLVER_RESOLVER_RULE;

    /**
     * Amazon Route53 resolver resolver rule association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType ROUTE53_RESOLVER_RESOLVER_RULE_ASSOCIATION;

    /**
     * Amazon S3 account public access block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType S3_ACCOUNT_PUBLIC_ACCESS_BLOCK;

    /**
     * Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType S3_BUCKET;

    /**
     * Amazon S3 Multi-Region Access Point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType S3_MULTIREGION_ACCESS_POINT;

    /**
     * Amazon SageMaker code repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGEMAKER_CODE_REPOSITORY;

    /**
     * Amazon SageMaker model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGEMAKER_MODEL;

    /**
     * Amazon SageMaker notebook instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGEMAKER_NOTEBOOK_INSTANCE;

    /**
     * Amazon SageMaker workteam.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SAGEMAKER_WORKTEAM;

    /**
     * AWS Secrets Manager secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SECRETS_MANAGER_SECRET;

    /**
     * AWS Service Catalog CloudFormation product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICE_CATALOG_CLOUDFORMATION_PRODUCT;

    /**
     * AWS Service Catalog CloudFormation provisioned product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICE_CATALOG_CLOUDFORMATION_PROVISIONED_PRODUCT;

    /**
     * AWS Service Catalog portfolio.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICE_CATALOG_PORTFOLIO;

    /**
     * AWS Cloud Map(ServiceDiscovery) Http Namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICEDISCOVERY_HTTP_NAMESPACE;

    /**
     * AWS Cloud Map(ServiceDiscovery) Public Dns Namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICEDISCOVERY_PUBLIC_DNS_NAMESPACE;

    /**
     * AWS Cloud Map(ServiceDiscovery) service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SERVICEDISCOVERY_SERVICE;

    /**
     * Amazon SES Configuration Set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SES_CONFIGURATION_SET;

    /**
     * Amazon SES Contact List.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SES_CONTACT_LIST;

    /**
     * Amazon SES ReceiptFilter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SES_RECEIPT_FILTER;

    /**
     * Amazon SES ReceiptRuleSet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SES_RECEIPT_RECEIPT_RULE_SET;

    /**
     * Amazon SES Template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SES_TEMPLATE;

    /**
     * AWS Shield protection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SHIELD_PROTECTION;

    /**
     * AWS Shield regional protection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SHIELD_REGIONAL_PROTECTION;

    /**
     * Amazon SNS topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SNS_TOPIC;

    /**
     * Amazon SQS queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SQS_QUEUE;

    /**
     * AWS StepFunctions activity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType STEPFUNCTIONS_ACTIVITY;

    /**
     * AWS StepFunctions state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType STEPFUNCTIONS_STATE_MACHINE;

    /**
     * AWS Systems Manager association compliance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SYSTEMS_MANAGER_ASSOCIATION_COMPLIANCE;

    /**
     * AWS Systems Manager file data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SYSTEMS_MANAGER_FILE_DATA;

    /**
     * AWS Systems Manager managed instance inventory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SYSTEMS_MANAGER_MANAGED_INSTANCE_INVENTORY;

    /**
     * AWS Systems Manager patch compliance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType SYSTEMS_MANAGER_PATCH_COMPLIANCE;

    /**
     * AWS Transfer workflow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType TRANSFER_WORKFLOW;

    /**
     * AWS WAF rate based rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_RATE_BASED_RULE;

    /**
     * AWS WAF regional rate based rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_REGIONAL_RATE_BASED_RULE;

    /**
     * AWS WAF regional rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_REGIONAL_RULE;

    /**
     * AWS WAF regional rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_REGIONAL_RULE_GROUP;

    /**
     * AWS WAF web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_REGIONAL_WEB_ACL;

    /**
     * AWS WAF rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_RULE;

    /**
     * AWS WAF rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_RULE_GROUP;

    /**
     * AWS WAF web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAF_WEB_ACL;

    /**
     * AWS WAFv2 ip set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAFV2_IP_SET;

    /**
     * AWS WAFv2 managed rule set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAFV2_MANAGED_RULE_SET;

    /**
     * AWS WAFv2 regex pattern set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAFV2_REGEX_PATTERN_SET;

    /**
     * AWS WAFv2 rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAFV2_RULE_GROUP;

    /**
     * AWS WAFv2 web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WAFV2_WEB_ACL;

    /**
     * Amazon WorkSpaces connection alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WORKSPACES_CONNECTION_ALIAS;

    /**
     * Amazon WorkSpaces workSpace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType WORKSPACES_WORKSPACE;

    /**
     * AWS X-Ray encryption configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.config.ResourceType XRAY_ENCRYPTION_CONFIGURATION;

    /**
     * Valid value of resource type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getComplianceResourceType() {
        return software.amazon.jsii.Kernel.get(this, "complianceResourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
