package software.amazon.awscdk.services.devopsguru;

/**
 * A collection of AWS resources supported by DevOps Guru.
 * <p>
 * The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze only the AWS resources that are defined in the stacks.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.devopsguru.*;
 * CfnResourceCollection cfnResourceCollection = CfnResourceCollection.Builder.create(this, "MyCfnResourceCollection")
 *         .resourceCollectionFilter(ResourceCollectionFilterProperty.builder()
 *                 .cloudFormation(CloudFormationCollectionFilterProperty.builder()
 *                         .stackNames(List.of("stackNames"))
 *                         .build())
 *                 .tags(List.of(TagCollectionProperty.builder()
 *                         .appBoundaryKey("appBoundaryKey")
 *                         .tagValues(List.of("tagValues"))
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:52.594Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_devopsguru.CfnResourceCollection")
public class CfnResourceCollection extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnResourceCollection(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnResourceCollection(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.devopsguru.CfnResourceCollection.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnResourceCollection(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.devopsguru.CfnResourceCollectionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The type of AWS resource collections to return.
     * <p>
     * The one valid value is <code>CLOUD_FORMATION</code> for AWS CloudFormation stacks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceCollectionType() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceCollectionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResourceCollectionFilter() {
        return software.amazon.jsii.Kernel.get(this, "resourceCollectionFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceCollectionFilter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourceCollectionFilter", java.util.Objects.requireNonNull(value, "resourceCollectionFilter is required"));
    }

    /**
     * Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceCollectionFilter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.devopsguru.CfnResourceCollection.ResourceCollectionFilterProperty value) {
        software.amazon.jsii.Kernel.set(this, "resourceCollectionFilter", java.util.Objects.requireNonNull(value, "resourceCollectionFilter is required"));
    }
    /**
     * Information about AWS CloudFormation stacks.
     * <p>
     * You can use up to 1000 stacks to specify which AWS resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.devopsguru.*;
     * CloudFormationCollectionFilterProperty cloudFormationCollectionFilterProperty = CloudFormationCollectionFilterProperty.builder()
     *         .stackNames(List.of("stackNames"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-cloudformationcollectionfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-cloudformationcollectionfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_devopsguru.CfnResourceCollection.CloudFormationCollectionFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudFormationCollectionFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudFormationCollectionFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of CloudFormation stack names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-cloudformationcollectionfilter.html#cfn-devopsguru-resourcecollection-cloudformationcollectionfilter-stacknames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-cloudformationcollectionfilter.html#cfn-devopsguru-resourcecollection-cloudformationcollectionfilter-stacknames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStackNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudFormationCollectionFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudFormationCollectionFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudFormationCollectionFilterProperty> {
            java.util.List<java.lang.String> stackNames;

            /**
             * Sets the value of {@link CloudFormationCollectionFilterProperty#getStackNames}
             * @param stackNames An array of CloudFormation stack names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stackNames(java.util.List<java.lang.String> stackNames) {
                this.stackNames = stackNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudFormationCollectionFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudFormationCollectionFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudFormationCollectionFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudFormationCollectionFilterProperty {
            private final java.util.List<java.lang.String> stackNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.stackNames = software.amazon.jsii.Kernel.get(this, "stackNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.stackNames = builder.stackNames;
            }

            @Override
            public final java.util.List<java.lang.String> getStackNames() {
                return this.stackNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStackNames() != null) {
                    data.set("stackNames", om.valueToTree(this.getStackNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_devopsguru.CfnResourceCollection.CloudFormationCollectionFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudFormationCollectionFilterProperty.Jsii$Proxy that = (CloudFormationCollectionFilterProperty.Jsii$Proxy) o;

                return this.stackNames != null ? this.stackNames.equals(that.stackNames) : that.stackNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.stackNames != null ? this.stackNames.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.devopsguru.*;
     * ResourceCollectionFilterProperty resourceCollectionFilterProperty = ResourceCollectionFilterProperty.builder()
     *         .cloudFormation(CloudFormationCollectionFilterProperty.builder()
     *                 .stackNames(List.of("stackNames"))
     *                 .build())
     *         .tags(List.of(TagCollectionProperty.builder()
     *                 .appBoundaryKey("appBoundaryKey")
     *                 .tagValues(List.of("tagValues"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-resourcecollectionfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-resourcecollectionfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_devopsguru.CfnResourceCollection.ResourceCollectionFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceCollectionFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceCollectionFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about AWS CloudFormation stacks.
         * <p>
         * You can use up to 1000 stacks to specify which AWS resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <em>AWS CloudFormation User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-resourcecollectionfilter.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter-cloudformation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-resourcecollectionfilter.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter-cloudformation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudFormation() {
            return null;
        }

        /**
         * The AWS tags used to filter the resources in the resource collection.
         * <p>
         * Tags help you identify and organize your AWS resources. Many AWS services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an AWS Lambda function. For more information about using tags, see the <a href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html">Tagging best practices</a> whitepaper.
         * <p>
         * Each AWS tag has two parts.
         * <p>
         * <ul>
         * <li>A tag <em>key</em> (for example, <code>CostCenter</code> , <code>Environment</code> , <code>Project</code> , or <code>Secret</code> ). Tag <em>keys</em> are case-sensitive.</li>
         * <li>A field known as a tag <em>value</em> (for example, <code>111122223333</code> , <code>Production</code> , or a team name). Omitting the tag <em>value</em> is the same as using an empty string. Like tag <em>keys</em> , tag <em>values</em> are case-sensitive. The tag value is a required property when AppBoundaryKey is specified.</li>
         * </ul>
         * <p>
         * Together these are known as <em>key</em> - <em>value</em> pairs.
         * <p>
         * <blockquote>
         * <p>
         * The string used for a <em>key</em> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code> . The tag <em>key</em> might be <code>DevOps-Guru-deployment-application</code> or <code>devops-guru-rds-application</code> . When you create a <em>key</em> , the case of characters in the <em>key</em> can be whatever you choose. After you create a <em>key</em> , it is case-sensitive. For example, DevOps Guru works with a <em>key</em> named <code>devops-guru-rds</code> and a <em>key</em> named <code>DevOps-Guru-RDS</code> , and these act as two different <em>keys</em> . Possible <em>key</em> / <em>value</em> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-resourcecollectionfilter.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-resourcecollectionfilter.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter-tags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.devopsguru.CfnResourceCollection.TagCollectionProperty> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceCollectionFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceCollectionFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceCollectionFilterProperty> {
            java.lang.Object cloudFormation;
            java.util.List<software.amazon.awscdk.services.devopsguru.CfnResourceCollection.TagCollectionProperty> tags;

            /**
             * Sets the value of {@link ResourceCollectionFilterProperty#getCloudFormation}
             * @param cloudFormation Information about AWS CloudFormation stacks.
             *                       You can use up to 1000 stacks to specify which AWS resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <em>AWS CloudFormation User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFormation(software.amazon.awscdk.IResolvable cloudFormation) {
                this.cloudFormation = cloudFormation;
                return this;
            }

            /**
             * Sets the value of {@link ResourceCollectionFilterProperty#getCloudFormation}
             * @param cloudFormation Information about AWS CloudFormation stacks.
             *                       You can use up to 1000 stacks to specify which AWS resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <em>AWS CloudFormation User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFormation(software.amazon.awscdk.services.devopsguru.CfnResourceCollection.CloudFormationCollectionFilterProperty cloudFormation) {
                this.cloudFormation = cloudFormation;
                return this;
            }

            /**
             * Sets the value of {@link ResourceCollectionFilterProperty#getTags}
             * @param tags The AWS tags used to filter the resources in the resource collection.
             *             Tags help you identify and organize your AWS resources. Many AWS services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an AWS Lambda function. For more information about using tags, see the <a href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html">Tagging best practices</a> whitepaper.
             *             <p>
             *             Each AWS tag has two parts.
             *             <p>
             *             <ul>
             *             <li>A tag <em>key</em> (for example, <code>CostCenter</code> , <code>Environment</code> , <code>Project</code> , or <code>Secret</code> ). Tag <em>keys</em> are case-sensitive.</li>
             *             <li>A field known as a tag <em>value</em> (for example, <code>111122223333</code> , <code>Production</code> , or a team name). Omitting the tag <em>value</em> is the same as using an empty string. Like tag <em>keys</em> , tag <em>values</em> are case-sensitive. The tag value is a required property when AppBoundaryKey is specified.</li>
             *             </ul>
             *             <p>
             *             Together these are known as <em>key</em> - <em>value</em> pairs.
             *             <p>
             *             <blockquote>
             *             <p>
             *             The string used for a <em>key</em> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code> . The tag <em>key</em> might be <code>DevOps-Guru-deployment-application</code> or <code>devops-guru-rds-application</code> . When you create a <em>key</em> , the case of characters in the <em>key</em> can be whatever you choose. After you create a <em>key</em> , it is case-sensitive. For example, DevOps Guru works with a <em>key</em> named <code>devops-guru-rds</code> and a <em>key</em> named <code>DevOps-Guru-RDS</code> , and these act as two different <em>keys</em> . Possible <em>key</em> / <em>value</em> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code> .
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.services.devopsguru.CfnResourceCollection.TagCollectionProperty> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.services.devopsguru.CfnResourceCollection.TagCollectionProperty>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceCollectionFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceCollectionFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceCollectionFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceCollectionFilterProperty {
            private final java.lang.Object cloudFormation;
            private final java.util.List<software.amazon.awscdk.services.devopsguru.CfnResourceCollection.TagCollectionProperty> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudFormation = software.amazon.jsii.Kernel.get(this, "cloudFormation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.devopsguru.CfnResourceCollection.TagCollectionProperty.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudFormation = builder.cloudFormation;
                this.tags = (java.util.List<software.amazon.awscdk.services.devopsguru.CfnResourceCollection.TagCollectionProperty>)builder.tags;
            }

            @Override
            public final java.lang.Object getCloudFormation() {
                return this.cloudFormation;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.services.devopsguru.CfnResourceCollection.TagCollectionProperty> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudFormation() != null) {
                    data.set("cloudFormation", om.valueToTree(this.getCloudFormation()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_devopsguru.CfnResourceCollection.ResourceCollectionFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceCollectionFilterProperty.Jsii$Proxy that = (ResourceCollectionFilterProperty.Jsii$Proxy) o;

                if (this.cloudFormation != null ? !this.cloudFormation.equals(that.cloudFormation) : that.cloudFormation != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudFormation != null ? this.cloudFormation.hashCode() : 0;
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A collection of AWS tags.
     * <p>
     * Tags help you identify and organize your AWS resources. Many AWS services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an AWS Lambda function. For more information about using tags, see the <a href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html">Tagging best practices</a> whitepaper.
     * <p>
     * Each AWS tag has two parts.
     * <p>
     * <ul>
     * <li>A tag <em>key</em> (for example, <code>CostCenter</code> , <code>Environment</code> , <code>Project</code> , or <code>Secret</code> ). Tag <em>keys</em> are case-sensitive.</li>
     * <li>A field known as a tag <em>value</em> (for example, <code>111122223333</code> , <code>Production</code> , or a team name). Omitting the tag <em>value</em> is the same as using an empty string. Like tag <em>keys</em> , tag <em>values</em> are case-sensitive. The tag value is a required property when <em>AppBoundaryKey</em> is specified.</li>
     * </ul>
     * <p>
     * Together these are known as <em>key</em> - <em>value</em> pairs.
     * <p>
     * <blockquote>
     * <p>
     * The string used for a <em>key</em> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code> . The tag <em>key</em> might be <code>DevOps-Guru-deployment-application</code> or <code>devops-guru-rds-application</code> . When you create a <em>key</em> , the case of characters in the <em>key</em> can be whatever you choose. After you create a <em>key</em> , it is case-sensitive. For example, DevOps Guru works with a <em>key</em> named <code>devops-guru-rds</code> and a <em>key</em> named <code>DevOps-Guru-RDS</code> , and these act as two different <em>keys</em> . Possible <em>key</em> / <em>value</em> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.devopsguru.*;
     * TagCollectionProperty tagCollectionProperty = TagCollectionProperty.builder()
     *         .appBoundaryKey("appBoundaryKey")
     *         .tagValues(List.of("tagValues"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-tagcollection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-tagcollection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_devopsguru.CfnResourceCollection.TagCollectionProperty")
    @software.amazon.jsii.Jsii.Proxy(TagCollectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagCollectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An AWS tag <em>key</em> that is used to identify the AWS resources that DevOps Guru analyzes.
         * <p>
         * All AWS resources in your account and Region tagged with this <em>key</em> make up your DevOps Guru application and analysis boundary.
         * <p>
         * <blockquote>
         * <p>
         * The string used for a <em>key</em> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code> . The tag <em>key</em> might be <code>DevOps-Guru-deployment-application</code> or <code>devops-guru-rds-application</code> . When you create a <em>key</em> , the case of characters in the <em>key</em> can be whatever you choose. After you create a <em>key</em> , it is case-sensitive. For example, DevOps Guru works with a <em>key</em> named <code>devops-guru-rds</code> and a <em>key</em> named <code>DevOps-Guru-RDS</code> , and these act as two different <em>keys</em> . Possible <em>key</em> / <em>value</em> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-tagcollection.html#cfn-devopsguru-resourcecollection-tagcollection-appboundarykey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-tagcollection.html#cfn-devopsguru-resourcecollection-tagcollection-appboundarykey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAppBoundaryKey() {
            return null;
        }

        /**
         * The values in an AWS tag collection.
         * <p>
         * The tag's <em>value</em> is a field used to associate a string with the tag <em>key</em> (for example, <code>111122223333</code> , <code>Production</code> , or a team name). The <em>key</em> and <em>value</em> are the tag's <em>key</em> pair. Omitting the tag <em>value</em> is the same as using an empty string. Like tag <em>keys</em> , tag <em>values</em> are case-sensitive. You can specify a maximum of 256 characters for a tag value. The tag value is a required property when <em>AppBoundaryKey</em> is specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-tagcollection.html#cfn-devopsguru-resourcecollection-tagcollection-tagvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-tagcollection.html#cfn-devopsguru-resourcecollection-tagcollection-tagvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTagValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagCollectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagCollectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagCollectionProperty> {
            java.lang.String appBoundaryKey;
            java.util.List<java.lang.String> tagValues;

            /**
             * Sets the value of {@link TagCollectionProperty#getAppBoundaryKey}
             * @param appBoundaryKey An AWS tag <em>key</em> that is used to identify the AWS resources that DevOps Guru analyzes.
             *                       All AWS resources in your account and Region tagged with this <em>key</em> make up your DevOps Guru application and analysis boundary.
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       The string used for a <em>key</em> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code> . The tag <em>key</em> might be <code>DevOps-Guru-deployment-application</code> or <code>devops-guru-rds-application</code> . When you create a <em>key</em> , the case of characters in the <em>key</em> can be whatever you choose. After you create a <em>key</em> , it is case-sensitive. For example, DevOps Guru works with a <em>key</em> named <code>devops-guru-rds</code> and a <em>key</em> named <code>DevOps-Guru-RDS</code> , and these act as two different <em>keys</em> . Possible <em>key</em> / <em>value</em> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code> .
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appBoundaryKey(java.lang.String appBoundaryKey) {
                this.appBoundaryKey = appBoundaryKey;
                return this;
            }

            /**
             * Sets the value of {@link TagCollectionProperty#getTagValues}
             * @param tagValues The values in an AWS tag collection.
             *                  The tag's <em>value</em> is a field used to associate a string with the tag <em>key</em> (for example, <code>111122223333</code> , <code>Production</code> , or a team name). The <em>key</em> and <em>value</em> are the tag's <em>key</em> pair. Omitting the tag <em>value</em> is the same as using an empty string. Like tag <em>keys</em> , tag <em>values</em> are case-sensitive. You can specify a maximum of 256 characters for a tag value. The tag value is a required property when <em>AppBoundaryKey</em> is specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagValues(java.util.List<java.lang.String> tagValues) {
                this.tagValues = tagValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagCollectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagCollectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagCollectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagCollectionProperty {
            private final java.lang.String appBoundaryKey;
            private final java.util.List<java.lang.String> tagValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appBoundaryKey = software.amazon.jsii.Kernel.get(this, "appBoundaryKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagValues = software.amazon.jsii.Kernel.get(this, "tagValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appBoundaryKey = builder.appBoundaryKey;
                this.tagValues = builder.tagValues;
            }

            @Override
            public final java.lang.String getAppBoundaryKey() {
                return this.appBoundaryKey;
            }

            @Override
            public final java.util.List<java.lang.String> getTagValues() {
                return this.tagValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAppBoundaryKey() != null) {
                    data.set("appBoundaryKey", om.valueToTree(this.getAppBoundaryKey()));
                }
                if (this.getTagValues() != null) {
                    data.set("tagValues", om.valueToTree(this.getTagValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_devopsguru.CfnResourceCollection.TagCollectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagCollectionProperty.Jsii$Proxy that = (TagCollectionProperty.Jsii$Proxy) o;

                if (this.appBoundaryKey != null ? !this.appBoundaryKey.equals(that.appBoundaryKey) : that.appBoundaryKey != null) return false;
                return this.tagValues != null ? this.tagValues.equals(that.tagValues) : that.tagValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appBoundaryKey != null ? this.appBoundaryKey.hashCode() : 0;
                result = 31 * result + (this.tagValues != null ? this.tagValues.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.devopsguru.CfnResourceCollection}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.devopsguru.CfnResourceCollection> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.devopsguru.CfnResourceCollectionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.devopsguru.CfnResourceCollectionProps.Builder();
        }

        /**
         * Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter</a>
         * @param resourceCollectionFilter Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceCollectionFilter(final software.amazon.awscdk.IResolvable resourceCollectionFilter) {
            this.props.resourceCollectionFilter(resourceCollectionFilter);
            return this;
        }
        /**
         * Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter</a>
         * @param resourceCollectionFilter Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceCollectionFilter(final software.amazon.awscdk.services.devopsguru.CfnResourceCollection.ResourceCollectionFilterProperty resourceCollectionFilter) {
            this.props.resourceCollectionFilter(resourceCollectionFilter);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.devopsguru.CfnResourceCollection}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.devopsguru.CfnResourceCollection build() {
            return new software.amazon.awscdk.services.devopsguru.CfnResourceCollection(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
