package software.amazon.awscdk.services.docdb;

/**
 * Properties for defining a <code>CfnEventSubscription</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.docdb.*;
 * CfnEventSubscriptionProps cfnEventSubscriptionProps = CfnEventSubscriptionProps.builder()
 *         .snsTopicArn("snsTopicArn")
 *         // the properties below are optional
 *         .enabled(false)
 *         .eventCategories(List.of("eventCategories"))
 *         .sourceIds(List.of("sourceIds"))
 *         .sourceType("sourceType")
 *         .subscriptionName("subscriptionName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-eventsubscription.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-eventsubscription.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:52.753Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.CfnEventSubscriptionProps")
@software.amazon.jsii.Jsii.Proxy(CfnEventSubscriptionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEventSubscriptionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the SNS topic created for event notification.
     * <p>
     * Amazon SNS creates the ARN when you create a topic and subscribe to it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-eventsubscription.html#cfn-docdb-eventsubscription-snstopicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-eventsubscription.html#cfn-docdb-eventsubscription-snstopicarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSnsTopicArn();

    /**
     * A Boolean value;
     * <p>
     * set to <code>true</code> to activate the subscription, set to <code>false</code> to create the subscription but not active it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-eventsubscription.html#cfn-docdb-eventsubscription-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-eventsubscription.html#cfn-docdb-eventsubscription-enabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return null;
    }

    /**
     * A list of event categories for a <code>SourceType</code> that you want to subscribe to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-eventsubscription.html#cfn-docdb-eventsubscription-eventcategories">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-eventsubscription.html#cfn-docdb-eventsubscription-eventcategories</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEventCategories() {
        return null;
    }

    /**
     * The list of identifiers of the event sources for which events are returned.
     * <p>
     * If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>If <code>SourceIds</code> are provided, <code>SourceType</code> must also be provided.</li>
     * <li>If the source type is an instance, a <code>DBInstanceIdentifier</code> must be provided.</li>
     * <li>If the source type is a security group, a <code>DBSecurityGroupName</code> must be provided.</li>
     * <li>If the source type is a parameter group, a <code>DBParameterGroupName</code> must be provided.</li>
     * <li>If the source type is a snapshot, a <code>DBSnapshotIdentifier</code> must be provided.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-eventsubscription.html#cfn-docdb-eventsubscription-sourceids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-eventsubscription.html#cfn-docdb-eventsubscription-sourceids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSourceIds() {
        return null;
    }

    /**
     * The type of source that is generating the events.
     * <p>
     * For example, if you want to be notified of events generated by an instance, you would set this parameter to <code>db-instance</code> . If this value is not specified, all events are returned.
     * <p>
     * Valid values: <code>db-instance</code> , <code>db-cluster</code> , <code>db-parameter-group</code> , <code>db-security-group</code> , <code>db-cluster-snapshot</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-eventsubscription.html#cfn-docdb-eventsubscription-sourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-eventsubscription.html#cfn-docdb-eventsubscription-sourcetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceType() {
        return null;
    }

    /**
     * The name of the subscription.
     * <p>
     * Constraints: The name must be fewer than 255 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-eventsubscription.html#cfn-docdb-eventsubscription-subscriptionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-eventsubscription.html#cfn-docdb-eventsubscription-subscriptionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubscriptionName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEventSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEventSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEventSubscriptionProps> {
        java.lang.String snsTopicArn;
        java.lang.Object enabled;
        java.util.List<java.lang.String> eventCategories;
        java.util.List<java.lang.String> sourceIds;
        java.lang.String sourceType;
        java.lang.String subscriptionName;

        /**
         * Sets the value of {@link CfnEventSubscriptionProps#getSnsTopicArn}
         * @param snsTopicArn The Amazon Resource Name (ARN) of the SNS topic created for event notification. This parameter is required.
         *                    Amazon SNS creates the ARN when you create a topic and subscribe to it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsTopicArn(java.lang.String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSubscriptionProps#getEnabled}
         * @param enabled A Boolean value;.
         *                set to <code>true</code> to activate the subscription, set to <code>false</code> to create the subscription but not active it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSubscriptionProps#getEnabled}
         * @param enabled A Boolean value;.
         *                set to <code>true</code> to activate the subscription, set to <code>false</code> to create the subscription but not active it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSubscriptionProps#getEventCategories}
         * @param eventCategories A list of event categories for a <code>SourceType</code> that you want to subscribe to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventCategories(java.util.List<java.lang.String> eventCategories) {
            this.eventCategories = eventCategories;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSubscriptionProps#getSourceIds}
         * @param sourceIds The list of identifiers of the event sources for which events are returned.
         *                  If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
         *                  <p>
         *                  Constraints:
         *                  <p>
         *                  <ul>
         *                  <li>If <code>SourceIds</code> are provided, <code>SourceType</code> must also be provided.</li>
         *                  <li>If the source type is an instance, a <code>DBInstanceIdentifier</code> must be provided.</li>
         *                  <li>If the source type is a security group, a <code>DBSecurityGroupName</code> must be provided.</li>
         *                  <li>If the source type is a parameter group, a <code>DBParameterGroupName</code> must be provided.</li>
         *                  <li>If the source type is a snapshot, a <code>DBSnapshotIdentifier</code> must be provided.</li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceIds(java.util.List<java.lang.String> sourceIds) {
            this.sourceIds = sourceIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSubscriptionProps#getSourceType}
         * @param sourceType The type of source that is generating the events.
         *                   For example, if you want to be notified of events generated by an instance, you would set this parameter to <code>db-instance</code> . If this value is not specified, all events are returned.
         *                   <p>
         *                   Valid values: <code>db-instance</code> , <code>db-cluster</code> , <code>db-parameter-group</code> , <code>db-security-group</code> , <code>db-cluster-snapshot</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceType(java.lang.String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSubscriptionProps#getSubscriptionName}
         * @param subscriptionName The name of the subscription.
         *                         Constraints: The name must be fewer than 255 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptionName(java.lang.String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEventSubscriptionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEventSubscriptionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEventSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEventSubscriptionProps {
        private final java.lang.String snsTopicArn;
        private final java.lang.Object enabled;
        private final java.util.List<java.lang.String> eventCategories;
        private final java.util.List<java.lang.String> sourceIds;
        private final java.lang.String sourceType;
        private final java.lang.String subscriptionName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.snsTopicArn = software.amazon.jsii.Kernel.get(this, "snsTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.eventCategories = software.amazon.jsii.Kernel.get(this, "eventCategories", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sourceIds = software.amazon.jsii.Kernel.get(this, "sourceIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sourceType = software.amazon.jsii.Kernel.get(this, "sourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subscriptionName = software.amazon.jsii.Kernel.get(this, "subscriptionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.snsTopicArn = java.util.Objects.requireNonNull(builder.snsTopicArn, "snsTopicArn is required");
            this.enabled = builder.enabled;
            this.eventCategories = builder.eventCategories;
            this.sourceIds = builder.sourceIds;
            this.sourceType = builder.sourceType;
            this.subscriptionName = builder.subscriptionName;
        }

        @Override
        public final java.lang.String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final java.lang.Object getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.util.List<java.lang.String> getEventCategories() {
            return this.eventCategories;
        }

        @Override
        public final java.util.List<java.lang.String> getSourceIds() {
            return this.sourceIds;
        }

        @Override
        public final java.lang.String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final java.lang.String getSubscriptionName() {
            return this.subscriptionName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("snsTopicArn", om.valueToTree(this.getSnsTopicArn()));
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEventCategories() != null) {
                data.set("eventCategories", om.valueToTree(this.getEventCategories()));
            }
            if (this.getSourceIds() != null) {
                data.set("sourceIds", om.valueToTree(this.getSourceIds()));
            }
            if (this.getSourceType() != null) {
                data.set("sourceType", om.valueToTree(this.getSourceType()));
            }
            if (this.getSubscriptionName() != null) {
                data.set("subscriptionName", om.valueToTree(this.getSubscriptionName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_docdb.CfnEventSubscriptionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEventSubscriptionProps.Jsii$Proxy that = (CfnEventSubscriptionProps.Jsii$Proxy) o;

            if (!snsTopicArn.equals(that.snsTopicArn)) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.eventCategories != null ? !this.eventCategories.equals(that.eventCategories) : that.eventCategories != null) return false;
            if (this.sourceIds != null ? !this.sourceIds.equals(that.sourceIds) : that.sourceIds != null) return false;
            if (this.sourceType != null ? !this.sourceType.equals(that.sourceType) : that.sourceType != null) return false;
            return this.subscriptionName != null ? this.subscriptionName.equals(that.subscriptionName) : that.subscriptionName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.snsTopicArn.hashCode();
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.eventCategories != null ? this.eventCategories.hashCode() : 0);
            result = 31 * result + (this.sourceIds != null ? this.sourceIds.hashCode() : 0);
            result = 31 * result + (this.sourceType != null ? this.sourceType.hashCode() : 0);
            result = 31 * result + (this.subscriptionName != null ? this.subscriptionName.hashCode() : 0);
            return result;
        }
    }
}
