package software.amazon.awscdk.services.dynamodb;

/**
 * When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.kinesis.*;
 * App app = new App();
 * Stack stack = Stack.Builder.create(app, "Stack").env(Environment.builder().region("us-west-2").build()).build();
 * TableV2 globalTable = TableV2.Builder.create(this, "GlobalTable")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .dynamoStream(StreamViewType.OLD_IMAGE)
 *         // tables in us-west-2, us-east-1, and us-east-2 all have dynamo stream type of OLD_IMAGES
 *         .replicas(List.of(ReplicaTableProps.builder().region("us-east-1").build(), ReplicaTableProps.builder().region("us-east-2").build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_StreamSpecification.html">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_StreamSpecification.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:52.858Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.StreamViewType")
public enum StreamViewType {
    /**
     * The entire item, as it appears after it was modified, is written to the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEW_IMAGE,
    /**
     * The entire item, as it appeared before it was modified, is written to the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OLD_IMAGE,
    /**
     * Both the new and the old item images of the item are written to the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEW_AND_OLD_IMAGES,
    /**
     * Only the key attributes of the modified item are written to the stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KEYS_ONLY,
}
