package software.amazon.awscdk.services.ec2;

/**
 * Base properties for an Amazon Linux SSM Parameter.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * UserData userData;
 * AmazonLinuxImageSsmParameterBaseProps amazonLinuxImageSsmParameterBaseProps = AmazonLinuxImageSsmParameterBaseProps.builder()
 *         .parameterName("parameterName")
 *         // the properties below are optional
 *         .cachedInContext(false)
 *         .userData(userData)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:52.930Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AmazonLinuxImageSsmParameterBaseProps")
@software.amazon.jsii.Jsii.Proxy(AmazonLinuxImageSsmParameterBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AmazonLinuxImageSsmParameterBaseProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.AmazonLinuxImageSsmParameterBaseOptions {

    /**
     * The name of the SSM parameter that contains the AMI value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getParameterName();

    /**
     * @return a {@link Builder} of {@link AmazonLinuxImageSsmParameterBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AmazonLinuxImageSsmParameterBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AmazonLinuxImageSsmParameterBaseProps> {
        java.lang.String parameterName;
        java.lang.Boolean cachedInContext;
        software.amazon.awscdk.services.ec2.UserData userData;

        /**
         * Sets the value of {@link AmazonLinuxImageSsmParameterBaseProps#getParameterName}
         * @param parameterName The name of the SSM parameter that contains the AMI value. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterName(java.lang.String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        /**
         * Sets the value of {@link AmazonLinuxImageSsmParameterBaseProps#getCachedInContext}
         * @param cachedInContext Whether the AMI ID is cached to be stable between deployments.
         *                        By default, the newest image is used on each deployment. This will cause
         *                        instances to be replaced whenever a new version is released, and may cause
         *                        downtime if there aren't enough running instances in the AutoScalingGroup
         *                        to reschedule the tasks on.
         *                        <p>
         *                        If set to true, the AMI ID will be cached in <code>cdk.context.json</code> and the
         *                        same value will be used on future runs. Your instances will not be replaced
         *                        but your AMI version will grow old over time. To refresh the AMI lookup,
         *                        you will have to evict the value from the cache using the <code>cdk context</code>
         *                        command. See https://docs.aws.amazon.com/cdk/latest/guide/context.html for
         *                        more information.
         *                        <p>
         *                        Can not be set to <code>true</code> in environment-agnostic stacks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachedInContext(java.lang.Boolean cachedInContext) {
            this.cachedInContext = cachedInContext;
            return this;
        }

        /**
         * Sets the value of {@link AmazonLinuxImageSsmParameterBaseProps#getUserData}
         * @param userData Initial user data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(software.amazon.awscdk.services.ec2.UserData userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AmazonLinuxImageSsmParameterBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AmazonLinuxImageSsmParameterBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AmazonLinuxImageSsmParameterBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonLinuxImageSsmParameterBaseProps {
        private final java.lang.String parameterName;
        private final java.lang.Boolean cachedInContext;
        private final software.amazon.awscdk.services.ec2.UserData userData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.parameterName = software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cachedInContext = software.amazon.jsii.Kernel.get(this, "cachedInContext", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.UserData.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.parameterName = java.util.Objects.requireNonNull(builder.parameterName, "parameterName is required");
            this.cachedInContext = builder.cachedInContext;
            this.userData = builder.userData;
        }

        @Override
        public final java.lang.String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final java.lang.Boolean getCachedInContext() {
            return this.cachedInContext;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.userData;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("parameterName", om.valueToTree(this.getParameterName()));
            if (this.getCachedInContext() != null) {
                data.set("cachedInContext", om.valueToTree(this.getCachedInContext()));
            }
            if (this.getUserData() != null) {
                data.set("userData", om.valueToTree(this.getUserData()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.AmazonLinuxImageSsmParameterBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AmazonLinuxImageSsmParameterBaseProps.Jsii$Proxy that = (AmazonLinuxImageSsmParameterBaseProps.Jsii$Proxy) o;

            if (!parameterName.equals(that.parameterName)) return false;
            if (this.cachedInContext != null ? !this.cachedInContext.equals(that.cachedInContext) : that.cachedInContext != null) return false;
            return this.userData != null ? this.userData.equals(that.userData) : that.userData == null;
        }

        @Override
        public final int hashCode() {
            int result = this.parameterName.hashCode();
            result = 31 * result + (this.cachedInContext != null ? this.cachedInContext.hashCode() : 0);
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            return result;
        }
    }
}
