package software.amazon.awscdk.services.ec2;

/**
 * Specifies the configuration information to launch a fleet--or group--of instances.
 * <p>
 * An EC2 Fleet can launch multiple instance types across multiple Availability Zones, using the On-Demand Instance, Reserved Instance, and Spot Instance purchasing models together. Using EC2 Fleet, you can define separate On-Demand and Spot capacity targets, specify the instance types that work best for your applications, and specify how Amazon EC2 should distribute your fleet capacity within each purchasing model. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">Launching an EC2 Fleet</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnEC2Fleet cfnEC2Fleet = CfnEC2Fleet.Builder.create(this, "MyCfnEC2Fleet")
 *         .launchTemplateConfigs(List.of(FleetLaunchTemplateConfigRequestProperty.builder()
 *                 .launchTemplateSpecification(FleetLaunchTemplateSpecificationRequestProperty.builder()
 *                         .version("version")
 *                         // the properties below are optional
 *                         .launchTemplateId("launchTemplateId")
 *                         .launchTemplateName("launchTemplateName")
 *                         .build())
 *                 .overrides(List.of(FleetLaunchTemplateOverridesRequestProperty.builder()
 *                         .availabilityZone("availabilityZone")
 *                         .instanceRequirements(InstanceRequirementsRequestProperty.builder()
 *                                 .acceleratorCount(AcceleratorCountRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .acceleratorManufacturers(List.of("acceleratorManufacturers"))
 *                                 .acceleratorNames(List.of("acceleratorNames"))
 *                                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .acceleratorTypes(List.of("acceleratorTypes"))
 *                                 .allowedInstanceTypes(List.of("allowedInstanceTypes"))
 *                                 .bareMetal("bareMetal")
 *                                 .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .burstablePerformance("burstablePerformance")
 *                                 .cpuManufacturers(List.of("cpuManufacturers"))
 *                                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
 *                                 .instanceGenerations(List.of("instanceGenerations"))
 *                                 .localStorage("localStorage")
 *                                 .localStorageTypes(List.of("localStorageTypes"))
 *                                 .maxSpotPriceAsPercentageOfOptimalOnDemandPrice(123)
 *                                 .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .memoryMiB(MemoryMiBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .networkBandwidthGbps(NetworkBandwidthGbpsRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .onDemandMaxPricePercentageOverLowestPrice(123)
 *                                 .requireHibernateSupport(false)
 *                                 .spotMaxPricePercentageOverLowestPrice(123)
 *                                 .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .vCpuCount(VCpuCountRangeRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .build())
 *                         .instanceType("instanceType")
 *                         .maxPrice("maxPrice")
 *                         .placement(PlacementProperty.builder()
 *                                 .affinity("affinity")
 *                                 .availabilityZone("availabilityZone")
 *                                 .groupName("groupName")
 *                                 .hostId("hostId")
 *                                 .hostResourceGroupArn("hostResourceGroupArn")
 *                                 .partitionNumber(123)
 *                                 .spreadDomain("spreadDomain")
 *                                 .tenancy("tenancy")
 *                                 .build())
 *                         .priority(123)
 *                         .subnetId("subnetId")
 *                         .weightedCapacity(123)
 *                         .build()))
 *                 .build()))
 *         .targetCapacitySpecification(TargetCapacitySpecificationRequestProperty.builder()
 *                 .totalTargetCapacity(123)
 *                 // the properties below are optional
 *                 .defaultTargetCapacityType("defaultTargetCapacityType")
 *                 .onDemandTargetCapacity(123)
 *                 .spotTargetCapacity(123)
 *                 .targetCapacityUnitType("targetCapacityUnitType")
 *                 .build())
 *         // the properties below are optional
 *         .context("context")
 *         .excessCapacityTerminationPolicy("excessCapacityTerminationPolicy")
 *         .onDemandOptions(OnDemandOptionsRequestProperty.builder()
 *                 .allocationStrategy("allocationStrategy")
 *                 .capacityReservationOptions(CapacityReservationOptionsRequestProperty.builder()
 *                         .usageStrategy("usageStrategy")
 *                         .build())
 *                 .maxTotalPrice("maxTotalPrice")
 *                 .minTargetCapacity(123)
 *                 .singleAvailabilityZone(false)
 *                 .singleInstanceType(false)
 *                 .build())
 *         .replaceUnhealthyInstances(false)
 *         .spotOptions(SpotOptionsRequestProperty.builder()
 *                 .allocationStrategy("allocationStrategy")
 *                 .instanceInterruptionBehavior("instanceInterruptionBehavior")
 *                 .instancePoolsToUseCount(123)
 *                 .maintenanceStrategies(MaintenanceStrategiesProperty.builder()
 *                         .capacityRebalance(CapacityRebalanceProperty.builder()
 *                                 .replacementStrategy("replacementStrategy")
 *                                 .terminationDelay(123)
 *                                 .build())
 *                         .build())
 *                 .maxTotalPrice("maxTotalPrice")
 *                 .minTargetCapacity(123)
 *                 .singleAvailabilityZone(false)
 *                 .singleInstanceType(false)
 *                 .build())
 *         .tagSpecifications(List.of(TagSpecificationProperty.builder()
 *                 .resourceType("resourceType")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .terminateInstancesWithExpiration(false)
 *         .type("type")
 *         .validFrom("validFrom")
 *         .validUntil("validUntil")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:52.976Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet")
public class CfnEC2Fleet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnEC2Fleet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEC2Fleet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnEC2Fleet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEC2Fleet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnEC2FleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFleetId() {
        return software.amazon.jsii.Kernel.get(this, "attrFleetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The configuration for the EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getLaunchTemplateConfigs() {
        return software.amazon.jsii.Kernel.get(this, "launchTemplateConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for the EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchTemplateConfigs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "launchTemplateConfigs", java.util.Objects.requireNonNull(value, "launchTemplateConfigs is required"));
    }

    /**
     * The configuration for the EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchTemplateConfigs(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "launchTemplateConfigs", java.util.Objects.requireNonNull(value, "launchTemplateConfigs is required"));
    }

    /**
     * The number of units to request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTargetCapacitySpecification() {
        return software.amazon.jsii.Kernel.get(this, "targetCapacitySpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The number of units to request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetCapacitySpecification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targetCapacitySpecification", java.util.Objects.requireNonNull(value, "targetCapacitySpecification is required"));
    }

    /**
     * The number of units to request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetCapacitySpecification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty value) {
        software.amazon.jsii.Kernel.set(this, "targetCapacitySpecification", java.util.Objects.requireNonNull(value, "targetCapacitySpecification is required"));
    }

    /**
     * Reserved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getContext() {
        return software.amazon.jsii.Kernel.get(this, "context", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Reserved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContext(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "context", value);
    }

    /**
     * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExcessCapacityTerminationPolicy() {
        return software.amazon.jsii.Kernel.get(this, "excessCapacityTerminationPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcessCapacityTerminationPolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "excessCapacityTerminationPolicy", value);
    }

    /**
     * Describes the configuration of On-Demand Instances in an EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOnDemandOptions() {
        return software.amazon.jsii.Kernel.get(this, "onDemandOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the configuration of On-Demand Instances in an EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnDemandOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "onDemandOptions", value);
    }

    /**
     * Describes the configuration of On-Demand Instances in an EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnDemandOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty value) {
        software.amazon.jsii.Kernel.set(this, "onDemandOptions", value);
    }

    /**
     * Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReplaceUnhealthyInstances() {
        return software.amazon.jsii.Kernel.get(this, "replaceUnhealthyInstances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplaceUnhealthyInstances(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "replaceUnhealthyInstances", value);
    }

    /**
     * Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplaceUnhealthyInstances(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "replaceUnhealthyInstances", value);
    }

    /**
     * Describes the configuration of Spot Instances in an EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSpotOptions() {
        return software.amazon.jsii.Kernel.get(this, "spotOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the configuration of Spot Instances in an EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpotOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "spotOptions", value);
    }

    /**
     * Describes the configuration of Spot Instances in an EC2 Fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpotOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnEC2Fleet.SpotOptionsRequestProperty value) {
        software.amazon.jsii.Kernel.set(this, "spotOptions", value);
    }

    /**
     * The key-value pair for tagging the EC2 Fleet request on creation.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tag your resources</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The key-value pair for tagging the EC2 Fleet request on creation.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tag your resources</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * The key-value pair for tagging the EC2 Fleet request on creation.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tag your resources</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagSpecificationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagSpecificationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "tagSpecifications", value);
    }

    /**
     * Indicates whether running instances should be terminated when the EC2 Fleet expires.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTerminateInstancesWithExpiration() {
        return software.amazon.jsii.Kernel.get(this, "terminateInstancesWithExpiration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether running instances should be terminated when the EC2 Fleet expires.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminateInstancesWithExpiration(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "terminateInstancesWithExpiration", value);
    }

    /**
     * Indicates whether running instances should be terminated when the EC2 Fleet expires.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminateInstancesWithExpiration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "terminateInstancesWithExpiration", value);
    }

    /**
     * The fleet type.
     * <p>
     * The default value is <code>maintain</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The fleet type.
     * <p>
     * The default value is <code>maintain</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", value);
    }

    /**
     * The start date and time of the request, in UTC format (for example, <em>YYYY</em> - <em>MM</em> - <em>DD</em> T <em>HH</em> : <em>MM</em> : <em>SS</em> Z).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getValidFrom() {
        return software.amazon.jsii.Kernel.get(this, "validFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The start date and time of the request, in UTC format (for example, <em>YYYY</em> - <em>MM</em> - <em>DD</em> T <em>HH</em> : <em>MM</em> : <em>SS</em> Z).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidFrom(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "validFrom", value);
    }

    /**
     * The end date and time of the request, in UTC format (for example, <em>YYYY</em> - <em>MM</em> - <em>DD</em> T <em>HH</em> : <em>MM</em> : <em>SS</em> Z).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getValidUntil() {
        return software.amazon.jsii.Kernel.get(this, "validUntil", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The end date and time of the request, in UTC format (for example, <em>YYYY</em> - <em>MM</em> - <em>DD</em> T <em>HH</em> : <em>MM</em> : <em>SS</em> Z).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidUntil(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "validUntil", value);
    }
    /**
     * The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
     * <p>
     * To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AcceleratorCountRequestProperty acceleratorCountRequestProperty = AcceleratorCountRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratorcountrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratorcountrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.AcceleratorCountRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorCountRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorCountRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of accelerators.
         * <p>
         * To specify no maximum limit, omit this parameter. To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratorcountrequest.html#cfn-ec2-ec2fleet-acceleratorcountrequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratorcountrequest.html#cfn-ec2-ec2fleet-acceleratorcountrequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum number of accelerators.
         * <p>
         * To specify no minimum limit, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratorcountrequest.html#cfn-ec2-ec2fleet-acceleratorcountrequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratorcountrequest.html#cfn-ec2-ec2fleet-acceleratorcountrequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorCountRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link AcceleratorCountRequestProperty#getMax}
             * @param max The maximum number of accelerators.
             *            To specify no maximum limit, omit this parameter. To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorCountRequestProperty#getMin}
             * @param min The minimum number of accelerators.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorCountRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorCountRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorCountRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.AcceleratorCountRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorCountRequestProperty.Jsii$Proxy that = (AcceleratorCountRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of total accelerator memory, in MiB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * AcceleratorTotalMemoryMiBRequestProperty acceleratorTotalMemoryMiBRequestProperty = AcceleratorTotalMemoryMiBRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratortotalmemorymibrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratortotalmemorymibrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorTotalMemoryMiBRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorTotalMemoryMiBRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of accelerator memory, in MiB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratortotalmemorymibrequest.html#cfn-ec2-ec2fleet-acceleratortotalmemorymibrequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratortotalmemorymibrequest.html#cfn-ec2-ec2fleet-acceleratortotalmemorymibrequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of accelerator memory, in MiB.
         * <p>
         * To specify no minimum limit, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratortotalmemorymibrequest.html#cfn-ec2-ec2fleet-acceleratortotalmemorymibrequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-acceleratortotalmemorymibrequest.html#cfn-ec2-ec2fleet-acceleratortotalmemorymibrequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorTotalMemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorTotalMemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorTotalMemoryMiBRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link AcceleratorTotalMemoryMiBRequestProperty#getMax}
             * @param max The maximum amount of accelerator memory, in MiB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorTotalMemoryMiBRequestProperty#getMin}
             * @param min The minimum amount of accelerator memory, in MiB.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorTotalMemoryMiBRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorTotalMemoryMiBRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorTotalMemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorTotalMemoryMiBRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorTotalMemoryMiBRequestProperty.Jsii$Proxy that = (AcceleratorTotalMemoryMiBRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * BaselineEbsBandwidthMbpsRequestProperty baselineEbsBandwidthMbpsRequestProperty = BaselineEbsBandwidthMbpsRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-baselineebsbandwidthmbpsrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-baselineebsbandwidthmbpsrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(BaselineEbsBandwidthMbpsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BaselineEbsBandwidthMbpsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum baseline bandwidth, in Mbps.
         * <p>
         * To specify no maximum limit, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-baselineebsbandwidthmbpsrequest.html#cfn-ec2-ec2fleet-baselineebsbandwidthmbpsrequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-baselineebsbandwidthmbpsrequest.html#cfn-ec2-ec2fleet-baselineebsbandwidthmbpsrequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum baseline bandwidth, in Mbps.
         * <p>
         * To specify no minimum limit, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-baselineebsbandwidthmbpsrequest.html#cfn-ec2-ec2fleet-baselineebsbandwidthmbpsrequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-baselineebsbandwidthmbpsrequest.html#cfn-ec2-ec2fleet-baselineebsbandwidthmbpsrequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BaselineEbsBandwidthMbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BaselineEbsBandwidthMbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BaselineEbsBandwidthMbpsRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link BaselineEbsBandwidthMbpsRequestProperty#getMax}
             * @param max The maximum baseline bandwidth, in Mbps.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link BaselineEbsBandwidthMbpsRequestProperty#getMin}
             * @param min The minimum baseline bandwidth, in Mbps.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BaselineEbsBandwidthMbpsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BaselineEbsBandwidthMbpsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BaselineEbsBandwidthMbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaselineEbsBandwidthMbpsRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BaselineEbsBandwidthMbpsRequestProperty.Jsii$Proxy that = (BaselineEbsBandwidthMbpsRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Spot Instance replacement strategy to use when Amazon EC2 emits a rebalance notification signal that your Spot Instance is at an elevated risk of being interrupted.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-capacity-rebalance.html">Capacity rebalancing</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * CapacityRebalanceProperty capacityRebalanceProperty = CapacityRebalanceProperty.builder()
     *         .replacementStrategy("replacementStrategy")
     *         .terminationDelay(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityrebalance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityrebalance.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.CapacityRebalanceProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityRebalanceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityRebalanceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The replacement strategy to use. Only available for fleets of type <code>maintain</code> .
         * <p>
         * <code>launch</code> - EC2 Fleet launches a replacement Spot Instance when a rebalance notification is emitted for an existing Spot Instance in the fleet. EC2 Fleet does not terminate the instances that receive a rebalance notification. You can terminate the old instances, or you can leave them running. You are charged for all instances while they are running.
         * <p>
         * <code>launch-before-terminate</code> - EC2 Fleet launches a replacement Spot Instance when a rebalance notification is emitted for an existing Spot Instance in the fleet, and then, after a delay that you specify (in <code>TerminationDelay</code> ), terminates the instances that received a rebalance notification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityrebalance.html#cfn-ec2-ec2fleet-capacityrebalance-replacementstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityrebalance.html#cfn-ec2-ec2fleet-capacityrebalance-replacementstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReplacementStrategy() {
            return null;
        }

        /**
         * The amount of time (in seconds) that Amazon EC2 waits before terminating the old Spot Instance after launching a new replacement Spot Instance.
         * <p>
         * Required when <code>ReplacementStrategy</code> is set to <code>launch-before-terminate</code> .
         * <p>
         * Not valid when <code>ReplacementStrategy</code> is set to <code>launch</code> .
         * <p>
         * Valid values: Minimum value of <code>120</code> seconds. Maximum value of <code>7200</code> seconds.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityrebalance.html#cfn-ec2-ec2fleet-capacityrebalance-terminationdelay">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityrebalance.html#cfn-ec2-ec2fleet-capacityrebalance-terminationdelay</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTerminationDelay() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityRebalanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityRebalanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityRebalanceProperty> {
            java.lang.String replacementStrategy;
            java.lang.Number terminationDelay;

            /**
             * Sets the value of {@link CapacityRebalanceProperty#getReplacementStrategy}
             * @param replacementStrategy The replacement strategy to use. Only available for fleets of type <code>maintain</code> .
             *                            <code>launch</code> - EC2 Fleet launches a replacement Spot Instance when a rebalance notification is emitted for an existing Spot Instance in the fleet. EC2 Fleet does not terminate the instances that receive a rebalance notification. You can terminate the old instances, or you can leave them running. You are charged for all instances while they are running.
             *                            <p>
             *                            <code>launch-before-terminate</code> - EC2 Fleet launches a replacement Spot Instance when a rebalance notification is emitted for an existing Spot Instance in the fleet, and then, after a delay that you specify (in <code>TerminationDelay</code> ), terminates the instances that received a rebalance notification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replacementStrategy(java.lang.String replacementStrategy) {
                this.replacementStrategy = replacementStrategy;
                return this;
            }

            /**
             * Sets the value of {@link CapacityRebalanceProperty#getTerminationDelay}
             * @param terminationDelay The amount of time (in seconds) that Amazon EC2 waits before terminating the old Spot Instance after launching a new replacement Spot Instance.
             *                         Required when <code>ReplacementStrategy</code> is set to <code>launch-before-terminate</code> .
             *                         <p>
             *                         Not valid when <code>ReplacementStrategy</code> is set to <code>launch</code> .
             *                         <p>
             *                         Valid values: Minimum value of <code>120</code> seconds. Maximum value of <code>7200</code> seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terminationDelay(java.lang.Number terminationDelay) {
                this.terminationDelay = terminationDelay;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityRebalanceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityRebalanceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityRebalanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityRebalanceProperty {
            private final java.lang.String replacementStrategy;
            private final java.lang.Number terminationDelay;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.replacementStrategy = software.amazon.jsii.Kernel.get(this, "replacementStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.terminationDelay = software.amazon.jsii.Kernel.get(this, "terminationDelay", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.replacementStrategy = builder.replacementStrategy;
                this.terminationDelay = builder.terminationDelay;
            }

            @Override
            public final java.lang.String getReplacementStrategy() {
                return this.replacementStrategy;
            }

            @Override
            public final java.lang.Number getTerminationDelay() {
                return this.terminationDelay;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReplacementStrategy() != null) {
                    data.set("replacementStrategy", om.valueToTree(this.getReplacementStrategy()));
                }
                if (this.getTerminationDelay() != null) {
                    data.set("terminationDelay", om.valueToTree(this.getTerminationDelay()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.CapacityRebalanceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityRebalanceProperty.Jsii$Proxy that = (CapacityRebalanceProperty.Jsii$Proxy) o;

                if (this.replacementStrategy != null ? !this.replacementStrategy.equals(that.replacementStrategy) : that.replacementStrategy != null) return false;
                return this.terminationDelay != null ? this.terminationDelay.equals(that.terminationDelay) : that.terminationDelay == null;
            }

            @Override
            public final int hashCode() {
                int result = this.replacementStrategy != null ? this.replacementStrategy.hashCode() : 0;
                result = 31 * result + (this.terminationDelay != null ? this.terminationDelay.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.
     * <p>
     * <blockquote>
     * <p>
     * This strategy can only be used if the EC2 Fleet is of type <code>instant</code> .
     * <p>
     * </blockquote>
     * <p>
     * For more information about Capacity Reservations, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">On-Demand Capacity Reservations</a> in the <em>Amazon EC2 User Guide</em> . For examples of using Capacity Reservations in an EC2 Fleet, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html">EC2 Fleet example configurations</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * CapacityReservationOptionsRequestProperty capacityReservationOptionsRequestProperty = CapacityReservationOptionsRequestProperty.builder()
     *         .usageStrategy("usageStrategy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityreservationoptionsrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityreservationoptionsrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.CapacityReservationOptionsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityReservationOptionsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityReservationOptionsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.
         * <p>
         * If you specify <code>use-capacity-reservations-first</code> , the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy ( <code>lowest-price</code> or <code>prioritized</code> ) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy ( <code>lowest-price</code> or <code>prioritized</code> ).
         * <p>
         * If you do not specify a value, the fleet fulfils the On-Demand capacity according to the chosen On-Demand allocation strategy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityreservationoptionsrequest.html#cfn-ec2-ec2fleet-capacityreservationoptionsrequest-usagestrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-capacityreservationoptionsrequest.html#cfn-ec2-ec2fleet-capacityreservationoptionsrequest-usagestrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsageStrategy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityReservationOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityReservationOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityReservationOptionsRequestProperty> {
            java.lang.String usageStrategy;

            /**
             * Sets the value of {@link CapacityReservationOptionsRequestProperty#getUsageStrategy}
             * @param usageStrategy Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.
             *                      If you specify <code>use-capacity-reservations-first</code> , the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy ( <code>lowest-price</code> or <code>prioritized</code> ) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy ( <code>lowest-price</code> or <code>prioritized</code> ).
             *                      <p>
             *                      If you do not specify a value, the fleet fulfils the On-Demand capacity according to the chosen On-Demand allocation strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usageStrategy(java.lang.String usageStrategy) {
                this.usageStrategy = usageStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityReservationOptionsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityReservationOptionsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityReservationOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityReservationOptionsRequestProperty {
            private final java.lang.String usageStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.usageStrategy = software.amazon.jsii.Kernel.get(this, "usageStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.usageStrategy = builder.usageStrategy;
            }

            @Override
            public final java.lang.String getUsageStrategy() {
                return this.usageStrategy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getUsageStrategy() != null) {
                    data.set("usageStrategy", om.valueToTree(this.getUsageStrategy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.CapacityReservationOptionsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityReservationOptionsRequestProperty.Jsii$Proxy that = (CapacityReservationOptionsRequestProperty.Jsii$Proxy) o;

                return this.usageStrategy != null ? this.usageStrategy.equals(that.usageStrategy) : that.usageStrategy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.usageStrategy != null ? this.usageStrategy.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies a launch template and overrides for an EC2 Fleet.
     * <p>
     * <code>FleetLaunchTemplateConfigRequest</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html">AWS::EC2::EC2Fleet</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * FleetLaunchTemplateConfigRequestProperty fleetLaunchTemplateConfigRequestProperty = FleetLaunchTemplateConfigRequestProperty.builder()
     *         .launchTemplateSpecification(FleetLaunchTemplateSpecificationRequestProperty.builder()
     *                 .version("version")
     *                 // the properties below are optional
     *                 .launchTemplateId("launchTemplateId")
     *                 .launchTemplateName("launchTemplateName")
     *                 .build())
     *         .overrides(List.of(FleetLaunchTemplateOverridesRequestProperty.builder()
     *                 .availabilityZone("availabilityZone")
     *                 .instanceRequirements(InstanceRequirementsRequestProperty.builder()
     *                         .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *                         .acceleratorNames(List.of("acceleratorNames"))
     *                         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .acceleratorTypes(List.of("acceleratorTypes"))
     *                         .allowedInstanceTypes(List.of("allowedInstanceTypes"))
     *                         .bareMetal("bareMetal")
     *                         .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .burstablePerformance("burstablePerformance")
     *                         .cpuManufacturers(List.of("cpuManufacturers"))
     *                         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                         .instanceGenerations(List.of("instanceGenerations"))
     *                         .localStorage("localStorage")
     *                         .localStorageTypes(List.of("localStorageTypes"))
     *                         .maxSpotPriceAsPercentageOfOptimalOnDemandPrice(123)
     *                         .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .memoryMiB(MemoryMiBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .networkBandwidthGbps(NetworkBandwidthGbpsRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .onDemandMaxPricePercentageOverLowestPrice(123)
     *                         .requireHibernateSupport(false)
     *                         .spotMaxPricePercentageOverLowestPrice(123)
     *                         .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .build())
     *                 .instanceType("instanceType")
     *                 .maxPrice("maxPrice")
     *                 .placement(PlacementProperty.builder()
     *                         .affinity("affinity")
     *                         .availabilityZone("availabilityZone")
     *                         .groupName("groupName")
     *                         .hostId("hostId")
     *                         .hostResourceGroupArn("hostResourceGroupArn")
     *                         .partitionNumber(123)
     *                         .spreadDomain("spreadDomain")
     *                         .tenancy("tenancy")
     *                         .build())
     *                 .priority(123)
     *                 .subnetId("subnetId")
     *                 .weightedCapacity(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetLaunchTemplateConfigRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetLaunchTemplateConfigRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The launch template to use.
         * <p>
         * You must specify either the launch template ID or launch template name in the request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-launchtemplatespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-launchtemplatespecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplateSpecification() {
            return null;
        }

        /**
         * Any parameters that you specify override the same parameters in the launch template.
         * <p>
         * For fleets of type <code>request</code> and <code>maintain</code> , a maximum of 300 items is allowed across all launch templates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-overrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-overrides</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrides() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateConfigRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetLaunchTemplateConfigRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetLaunchTemplateConfigRequestProperty> {
            java.lang.Object launchTemplateSpecification;
            java.lang.Object overrides;

            /**
             * Sets the value of {@link FleetLaunchTemplateConfigRequestProperty#getLaunchTemplateSpecification}
             * @param launchTemplateSpecification The launch template to use.
             *                                    You must specify either the launch template ID or launch template name in the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateSpecification(software.amazon.awscdk.IResolvable launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateConfigRequestProperty#getLaunchTemplateSpecification}
             * @param launchTemplateSpecification The launch template to use.
             *                                    You must specify either the launch template ID or launch template name in the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateSpecification(software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty launchTemplateSpecification) {
                this.launchTemplateSpecification = launchTemplateSpecification;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateConfigRequestProperty#getOverrides}
             * @param overrides Any parameters that you specify override the same parameters in the launch template.
             *                  For fleets of type <code>request</code> and <code>maintain</code> , a maximum of 300 items is allowed across all launch templates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(software.amazon.awscdk.IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateConfigRequestProperty#getOverrides}
             * @param overrides Any parameters that you specify override the same parameters in the launch template.
             *                  For fleets of type <code>request</code> and <code>maintain</code> , a maximum of 300 items is allowed across all launch templates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(java.util.List<? extends java.lang.Object> overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateConfigRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetLaunchTemplateConfigRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FleetLaunchTemplateConfigRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetLaunchTemplateConfigRequestProperty {
            private final java.lang.Object launchTemplateSpecification;
            private final java.lang.Object overrides;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.launchTemplateSpecification = software.amazon.jsii.Kernel.get(this, "launchTemplateSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.overrides = software.amazon.jsii.Kernel.get(this, "overrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.launchTemplateSpecification = builder.launchTemplateSpecification;
                this.overrides = builder.overrides;
            }

            @Override
            public final java.lang.Object getLaunchTemplateSpecification() {
                return this.launchTemplateSpecification;
            }

            @Override
            public final java.lang.Object getOverrides() {
                return this.overrides;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLaunchTemplateSpecification() != null) {
                    data.set("launchTemplateSpecification", om.valueToTree(this.getLaunchTemplateSpecification()));
                }
                if (this.getOverrides() != null) {
                    data.set("overrides", om.valueToTree(this.getOverrides()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetLaunchTemplateConfigRequestProperty.Jsii$Proxy that = (FleetLaunchTemplateConfigRequestProperty.Jsii$Proxy) o;

                if (this.launchTemplateSpecification != null ? !this.launchTemplateSpecification.equals(that.launchTemplateSpecification) : that.launchTemplateSpecification != null) return false;
                return this.overrides != null ? this.overrides.equals(that.overrides) : that.overrides == null;
            }

            @Override
            public final int hashCode() {
                int result = this.launchTemplateSpecification != null ? this.launchTemplateSpecification.hashCode() : 0;
                result = 31 * result + (this.overrides != null ? this.overrides.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies overrides for a launch template for an EC2 Fleet.
     * <p>
     * <code>FleetLaunchTemplateOverridesRequest</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html">FleetLaunchTemplateConfigRequest</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * FleetLaunchTemplateOverridesRequestProperty fleetLaunchTemplateOverridesRequestProperty = FleetLaunchTemplateOverridesRequestProperty.builder()
     *         .availabilityZone("availabilityZone")
     *         .instanceRequirements(InstanceRequirementsRequestProperty.builder()
     *                 .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *                 .acceleratorNames(List.of("acceleratorNames"))
     *                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .acceleratorTypes(List.of("acceleratorTypes"))
     *                 .allowedInstanceTypes(List.of("allowedInstanceTypes"))
     *                 .bareMetal("bareMetal")
     *                 .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .burstablePerformance("burstablePerformance")
     *                 .cpuManufacturers(List.of("cpuManufacturers"))
     *                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                 .instanceGenerations(List.of("instanceGenerations"))
     *                 .localStorage("localStorage")
     *                 .localStorageTypes(List.of("localStorageTypes"))
     *                 .maxSpotPriceAsPercentageOfOptimalOnDemandPrice(123)
     *                 .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .memoryMiB(MemoryMiBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .networkBandwidthGbps(NetworkBandwidthGbpsRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .onDemandMaxPricePercentageOverLowestPrice(123)
     *                 .requireHibernateSupport(false)
     *                 .spotMaxPricePercentageOverLowestPrice(123)
     *                 .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .build())
     *         .instanceType("instanceType")
     *         .maxPrice("maxPrice")
     *         .placement(PlacementProperty.builder()
     *                 .affinity("affinity")
     *                 .availabilityZone("availabilityZone")
     *                 .groupName("groupName")
     *                 .hostId("hostId")
     *                 .hostResourceGroupArn("hostResourceGroupArn")
     *                 .partitionNumber(123)
     *                 .spreadDomain("spreadDomain")
     *                 .tenancy("tenancy")
     *                 .build())
     *         .priority(123)
     *         .subnetId("subnetId")
     *         .weightedCapacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetLaunchTemplateOverridesRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetLaunchTemplateOverridesRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Availability Zone in which to launch the instances.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-availabilityzone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * The attributes for the instance types.
         * <p>
         * When you specify instance attributes, Amazon EC2 will identify instance types with those attributes.
         * <p>
         * <blockquote>
         * <p>
         * If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceType</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-instancerequirements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-instancerequirements</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceRequirements() {
            return null;
        }

        /**
         * The instance type.
         * <p>
         * <code>mac1.metal</code> is not supported as a launch template override.
         * <p>
         * <blockquote>
         * <p>
         * If you specify <code>InstanceType</code> , you can't specify <code>InstanceRequirements</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The maximum price per unit hour that you are willing to pay for a Spot Instance.
         * <p>
         * We do not recommend using this parameter because it can lead to increased interruptions. If you do not specify this parameter, you will pay the current Spot price.
         * <p>
         * <blockquote>
         * <p>
         * If you specify a maximum price, your instances will be interrupted more frequently than if you do not specify this parameter.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-maxprice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-maxprice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxPrice() {
            return null;
        }

        /**
         * The location where the instance launched, if applicable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-placement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-placement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlacement() {
            return null;
        }

        /**
         * The priority for the launch template override. The highest priority is launched first.
         * <p>
         * If the On-Demand <code>AllocationStrategy</code> is set to <code>prioritized</code> , EC2 Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity.
         * <p>
         * If the Spot <code>AllocationStrategy</code> is set to <code>capacity-optimized-prioritized</code> , EC2 Fleet uses priority on a best-effort basis to determine which launch template override to use in fulfilling Spot capacity, but optimizes for capacity first.
         * <p>
         * Valid values are whole numbers starting at <code>0</code> . The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority. You can set the same priority for different launch template overrides.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-priority</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * The IDs of the subnets in which to launch the instances.
         * <p>
         * Separate multiple subnet IDs using commas (for example, <code>subnet-1234abcdeexample1, subnet-0987cdef6example2</code> ). A request of type <code>instant</code> can have only one subnet ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-subnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-subnetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * The number of units provided by the specified instance type.
         * <p>
         * <blockquote>
         * <p>
         * When specifying weights, the price used in the <code>lowest-price</code> and <code>price-capacity-optimized</code> allocation strategies is per <em>unit</em> hour (where the instance price is divided by the specified weight). However, if all the specified weights are above the requested <code>TargetCapacity</code> , resulting in only 1 instance being launched, the price used is per <em>instance</em> hour.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-weightedcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-weightedcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeightedCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateOverridesRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetLaunchTemplateOverridesRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetLaunchTemplateOverridesRequestProperty> {
            java.lang.String availabilityZone;
            java.lang.Object instanceRequirements;
            java.lang.String instanceType;
            java.lang.String maxPrice;
            java.lang.Object placement;
            java.lang.Number priority;
            java.lang.String subnetId;
            java.lang.Number weightedCapacity;

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getAvailabilityZone}
             * @param availabilityZone The Availability Zone in which to launch the instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getInstanceRequirements}
             * @param instanceRequirements The attributes for the instance types.
             *                             When you specify instance attributes, Amazon EC2 will identify instance types with those attributes.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceType</code> .
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRequirements(software.amazon.awscdk.IResolvable instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getInstanceRequirements}
             * @param instanceRequirements The attributes for the instance types.
             *                             When you specify instance attributes, Amazon EC2 will identify instance types with those attributes.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceType</code> .
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRequirements(software.amazon.awscdk.services.ec2.CfnEC2Fleet.InstanceRequirementsRequestProperty instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getInstanceType}
             * @param instanceType The instance type.
             *                     <code>mac1.metal</code> is not supported as a launch template override.
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     If you specify <code>InstanceType</code> , you can't specify <code>InstanceRequirements</code> .
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getMaxPrice}
             * @param maxPrice The maximum price per unit hour that you are willing to pay for a Spot Instance.
             *                 We do not recommend using this parameter because it can lead to increased interruptions. If you do not specify this parameter, you will pay the current Spot price.
             *                 <p>
             *                 <blockquote>
             *                 <p>
             *                 If you specify a maximum price, your instances will be interrupted more frequently than if you do not specify this parameter.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxPrice(java.lang.String maxPrice) {
                this.maxPrice = maxPrice;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getPlacement}
             * @param placement The location where the instance launched, if applicable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.IResolvable placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getPlacement}
             * @param placement The location where the instance launched, if applicable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placement(software.amazon.awscdk.services.ec2.CfnEC2Fleet.PlacementProperty placement) {
                this.placement = placement;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getPriority}
             * @param priority The priority for the launch template override. The highest priority is launched first.
             *                 If the On-Demand <code>AllocationStrategy</code> is set to <code>prioritized</code> , EC2 Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity.
             *                 <p>
             *                 If the Spot <code>AllocationStrategy</code> is set to <code>capacity-optimized-prioritized</code> , EC2 Fleet uses priority on a best-effort basis to determine which launch template override to use in fulfilling Spot capacity, but optimizes for capacity first.
             *                 <p>
             *                 Valid values are whole numbers starting at <code>0</code> . The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority. You can set the same priority for different launch template overrides.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getSubnetId}
             * @param subnetId The IDs of the subnets in which to launch the instances.
             *                 Separate multiple subnet IDs using commas (for example, <code>subnet-1234abcdeexample1, subnet-0987cdef6example2</code> ). A request of type <code>instant</code> can have only one subnet ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateOverridesRequestProperty#getWeightedCapacity}
             * @param weightedCapacity The number of units provided by the specified instance type.
             *                         <blockquote>
             *                         <p>
             *                         When specifying weights, the price used in the <code>lowest-price</code> and <code>price-capacity-optimized</code> allocation strategies is per <em>unit</em> hour (where the instance price is divided by the specified weight). However, if all the specified weights are above the requested <code>TargetCapacity</code> , resulting in only 1 instance being launched, the price used is per <em>instance</em> hour.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightedCapacity(java.lang.Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateOverridesRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetLaunchTemplateOverridesRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FleetLaunchTemplateOverridesRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetLaunchTemplateOverridesRequestProperty {
            private final java.lang.String availabilityZone;
            private final java.lang.Object instanceRequirements;
            private final java.lang.String instanceType;
            private final java.lang.String maxPrice;
            private final java.lang.Object placement;
            private final java.lang.Number priority;
            private final java.lang.String subnetId;
            private final java.lang.Number weightedCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceRequirements = software.amazon.jsii.Kernel.get(this, "instanceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxPrice = software.amazon.jsii.Kernel.get(this, "maxPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.placement = software.amazon.jsii.Kernel.get(this, "placement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weightedCapacity = software.amazon.jsii.Kernel.get(this, "weightedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = builder.availabilityZone;
                this.instanceRequirements = builder.instanceRequirements;
                this.instanceType = builder.instanceType;
                this.maxPrice = builder.maxPrice;
                this.placement = builder.placement;
                this.priority = builder.priority;
                this.subnetId = builder.subnetId;
                this.weightedCapacity = builder.weightedCapacity;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.Object getInstanceRequirements() {
                return this.instanceRequirements;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getMaxPrice() {
                return this.maxPrice;
            }

            @Override
            public final java.lang.Object getPlacement() {
                return this.placement;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            public final java.lang.Number getWeightedCapacity() {
                return this.weightedCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getInstanceRequirements() != null) {
                    data.set("instanceRequirements", om.valueToTree(this.getInstanceRequirements()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getMaxPrice() != null) {
                    data.set("maxPrice", om.valueToTree(this.getMaxPrice()));
                }
                if (this.getPlacement() != null) {
                    data.set("placement", om.valueToTree(this.getPlacement()));
                }
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }
                if (this.getWeightedCapacity() != null) {
                    data.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetLaunchTemplateOverridesRequestProperty.Jsii$Proxy that = (FleetLaunchTemplateOverridesRequestProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.instanceRequirements != null ? !this.instanceRequirements.equals(that.instanceRequirements) : that.instanceRequirements != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.maxPrice != null ? !this.maxPrice.equals(that.maxPrice) : that.maxPrice != null) return false;
                if (this.placement != null ? !this.placement.equals(that.placement) : that.placement != null) return false;
                if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
                if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
                return this.weightedCapacity != null ? this.weightedCapacity.equals(that.weightedCapacity) : that.weightedCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.instanceRequirements != null ? this.instanceRequirements.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.maxPrice != null ? this.maxPrice.hashCode() : 0);
                result = 31 * result + (this.placement != null ? this.placement.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                result = 31 * result + (this.weightedCapacity != null ? this.weightedCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the launch template to be used by the EC2 Fleet for configuring Amazon EC2 instances.
     * <p>
     * You must specify the following:
     * <p>
     * <ul>
     * <li>The ID or the name of the launch template, but not both.</li>
     * <li>The version of the launch template.</li>
     * </ul>
     * <p>
     * <code>FleetLaunchTemplateSpecificationRequest</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html">FleetLaunchTemplateConfigRequest</a> property type.
     * <p>
     * For information about creating a launch template, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html">AWS::EC2::LaunchTemplate</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">Create a launch template</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * For examples of launch templates, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#aws-resource-ec2-launchtemplate--examples">Examples</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * FleetLaunchTemplateSpecificationRequestProperty fleetLaunchTemplateSpecificationRequestProperty = FleetLaunchTemplateSpecificationRequestProperty.builder()
     *         .version("version")
     *         // the properties below are optional
     *         .launchTemplateId("launchTemplateId")
     *         .launchTemplateName("launchTemplateName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(FleetLaunchTemplateSpecificationRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FleetLaunchTemplateSpecificationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The launch template version number, <code>$Latest</code> , or <code>$Default</code> . You must specify a value, otherwise the request fails.
         * <p>
         * If the value is <code>$Latest</code> , Amazon EC2 uses the latest version of the launch template.
         * <p>
         * If the value is <code>$Default</code> , Amazon EC2 uses the default version of the launch template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVersion();

        /**
         * The ID of the launch template.
         * <p>
         * You must specify the <code>LaunchTemplateId</code> or the <code>LaunchTemplateName</code> , but not both.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplateid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplateid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateId() {
            return null;
        }

        /**
         * The name of the launch template.
         * <p>
         * You must specify the <code>LaunchTemplateName</code> or the <code>LaunchTemplateId</code> , but not both.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplatename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplatename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FleetLaunchTemplateSpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FleetLaunchTemplateSpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FleetLaunchTemplateSpecificationRequestProperty> {
            java.lang.String version;
            java.lang.String launchTemplateId;
            java.lang.String launchTemplateName;

            /**
             * Sets the value of {@link FleetLaunchTemplateSpecificationRequestProperty#getVersion}
             * @param version The launch template version number, <code>$Latest</code> , or <code>$Default</code> . You must specify a value, otherwise the request fails. This parameter is required.
             *                If the value is <code>$Latest</code> , Amazon EC2 uses the latest version of the launch template.
             *                <p>
             *                If the value is <code>$Default</code> , Amazon EC2 uses the default version of the launch template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateSpecificationRequestProperty#getLaunchTemplateId}
             * @param launchTemplateId The ID of the launch template.
             *                         You must specify the <code>LaunchTemplateId</code> or the <code>LaunchTemplateName</code> , but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateId(java.lang.String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            /**
             * Sets the value of {@link FleetLaunchTemplateSpecificationRequestProperty#getLaunchTemplateName}
             * @param launchTemplateName The name of the launch template.
             *                           You must specify the <code>LaunchTemplateName</code> or the <code>LaunchTemplateId</code> , but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchTemplateName(java.lang.String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FleetLaunchTemplateSpecificationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FleetLaunchTemplateSpecificationRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FleetLaunchTemplateSpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FleetLaunchTemplateSpecificationRequestProperty {
            private final java.lang.String version;
            private final java.lang.String launchTemplateId;
            private final java.lang.String launchTemplateName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchTemplateId = software.amazon.jsii.Kernel.get(this, "launchTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchTemplateName = software.amazon.jsii.Kernel.get(this, "launchTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
                this.launchTemplateId = builder.launchTemplateId;
                this.launchTemplateName = builder.launchTemplateName;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public final java.lang.String getLaunchTemplateId() {
                return this.launchTemplateId;
            }

            @Override
            public final java.lang.String getLaunchTemplateName() {
                return this.launchTemplateName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("version", om.valueToTree(this.getVersion()));
                if (this.getLaunchTemplateId() != null) {
                    data.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                }
                if (this.getLaunchTemplateName() != null) {
                    data.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FleetLaunchTemplateSpecificationRequestProperty.Jsii$Proxy that = (FleetLaunchTemplateSpecificationRequestProperty.Jsii$Proxy) o;

                if (!version.equals(that.version)) return false;
                if (this.launchTemplateId != null ? !this.launchTemplateId.equals(that.launchTemplateId) : that.launchTemplateId != null) return false;
                return this.launchTemplateName != null ? this.launchTemplateName.equals(that.launchTemplateName) : that.launchTemplateName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.version.hashCode();
                result = 31 * result + (this.launchTemplateId != null ? this.launchTemplateId.hashCode() : 0);
                result = 31 * result + (this.launchTemplateName != null ? this.launchTemplateName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The attributes for the instance types.
     * <p>
     * When you specify instance attributes, Amazon EC2 will identify instance types with these attributes.
     * <p>
     * You must specify <code>VCpuCount</code> and <code>MemoryMiB</code> . All other attributes are optional. Any unspecified optional attribute is set to its default.
     * <p>
     * When you specify multiple attributes, you get instance types that satisfy all of the specified attributes. If you specify multiple values for an attribute, you get instance types that satisfy any of the specified values.
     * <p>
     * To limit the list of instance types from which Amazon EC2 can identify matching instance types, you can use one of the following parameters, but not both in the same request:
     * <p>
     * <ul>
     * <li><code>AllowedInstanceTypes</code> - The instance types to include in the list. All other instance types are ignored, even if they match your specified attributes.</li>
     * <li><code>ExcludedInstanceTypes</code> - The instance types to exclude from the list, even if they match your specified attributes.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you specify <code>InstanceRequirements</code> , you can't specify <code>InstanceType</code> .
     * <p>
     * Attribute-based instance type selection is only supported when using Auto Scaling groups, EC2 Fleet, and Spot Fleet to launch instances. If you plan to use the launch template in the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-instance-wizard.html">launch instance wizard</a> , or with the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> API or <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html">AWS::EC2::Instance</a> AWS CloudFormation resource, you can't specify <code>InstanceRequirements</code> .
     * <p>
     * </blockquote>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html">Attribute-based instance type selection for EC2 Fleet</a> , <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-attribute-based-instance-type-selection.html">Attribute-based instance type selection for Spot Fleet</a> , and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html">Spot placement score</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * InstanceRequirementsRequestProperty instanceRequirementsRequestProperty = InstanceRequirementsRequestProperty.builder()
     *         .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *         .acceleratorNames(List.of("acceleratorNames"))
     *         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .acceleratorTypes(List.of("acceleratorTypes"))
     *         .allowedInstanceTypes(List.of("allowedInstanceTypes"))
     *         .bareMetal("bareMetal")
     *         .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .burstablePerformance("burstablePerformance")
     *         .cpuManufacturers(List.of("cpuManufacturers"))
     *         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *         .instanceGenerations(List.of("instanceGenerations"))
     *         .localStorage("localStorage")
     *         .localStorageTypes(List.of("localStorageTypes"))
     *         .maxSpotPriceAsPercentageOfOptimalOnDemandPrice(123)
     *         .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .memoryMiB(MemoryMiBRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .networkBandwidthGbps(NetworkBandwidthGbpsRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .onDemandMaxPricePercentageOverLowestPrice(123)
     *         .requireHibernateSupport(false)
     *         .spotMaxPricePercentageOverLowestPrice(123)
     *         .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.InstanceRequirementsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceRequirementsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceRequirementsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
         * <p>
         * To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
         * <p>
         * Default: No minimum or maximum limits
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-acceleratorcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-acceleratorcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceleratorCount() {
            return null;
        }

        /**
         * Indicates whether instance types must have accelerators by specific manufacturers.
         * <p>
         * <ul>
         * <li>For instance types with AWS devices, specify <code>amazon-web-services</code> .</li>
         * <li>For instance types with AMD devices, specify <code>amd</code> .</li>
         * <li>For instance types with Habana devices, specify <code>habana</code> .</li>
         * <li>For instance types with NVIDIA devices, specify <code>nvidia</code> .</li>
         * <li>For instance types with Xilinx devices, specify <code>xilinx</code> .</li>
         * </ul>
         * <p>
         * Default: Any manufacturer
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-acceleratormanufacturers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-acceleratormanufacturers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorManufacturers() {
            return null;
        }

        /**
         * The accelerators that must be on the instance type.
         * <p>
         * <ul>
         * <li>For instance types with NVIDIA A10G GPUs, specify <code>a10g</code> .</li>
         * <li>For instance types with NVIDIA A100 GPUs, specify <code>a100</code> .</li>
         * <li>For instance types with NVIDIA H100 GPUs, specify <code>h100</code> .</li>
         * <li>For instance types with AWS Inferentia chips, specify <code>inferentia</code> .</li>
         * <li>For instance types with NVIDIA GRID K520 GPUs, specify <code>k520</code> .</li>
         * <li>For instance types with NVIDIA K80 GPUs, specify <code>k80</code> .</li>
         * <li>For instance types with NVIDIA M60 GPUs, specify <code>m60</code> .</li>
         * <li>For instance types with AMD Radeon Pro V520 GPUs, specify <code>radeon-pro-v520</code> .</li>
         * <li>For instance types with NVIDIA T4 GPUs, specify <code>t4</code> .</li>
         * <li>For instance types with NVIDIA T4G GPUs, specify <code>t4g</code> .</li>
         * <li>For instance types with Xilinx VU9P FPGAs, specify <code>vu9p</code> .</li>
         * <li>For instance types with NVIDIA V100 GPUs, specify <code>v100</code> .</li>
         * </ul>
         * <p>
         * Default: Any accelerator
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-acceleratornames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-acceleratornames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorNames() {
            return null;
        }

        /**
         * The minimum and maximum amount of total accelerator memory, in MiB.
         * <p>
         * Default: No minimum or maximum limits
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-acceleratortotalmemorymib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-acceleratortotalmemorymib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceleratorTotalMemoryMiB() {
            return null;
        }

        /**
         * The accelerator types that must be on the instance type.
         * <p>
         * <ul>
         * <li>To include instance types with GPU hardware, specify <code>gpu</code> .</li>
         * <li>To include instance types with FPGA hardware, specify <code>fpga</code> .</li>
         * <li>To include instance types with inference hardware, specify <code>inference</code> .</li>
         * </ul>
         * <p>
         * Default: Any accelerator type
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-acceleratortypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-acceleratortypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorTypes() {
            return null;
        }

        /**
         * The instance types to apply your specified attributes against.
         * <p>
         * All other instance types are ignored, even if they match your specified attributes.
         * <p>
         * You can use strings with one or more wild cards, represented by an asterisk ( <code>*</code> ), to allow an instance type, size, or generation. The following are examples: <code>m5.8xlarge</code> , <code>c5*.*</code> , <code>m5a.*</code> , <code>r*</code> , <code>*3*</code> .
         * <p>
         * For example, if you specify <code>c5*</code> ,Amazon EC2 will allow the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code> , Amazon EC2 will allow all the M5a instance types, but not the M5n instance types.
         * <p>
         * <blockquote>
         * <p>
         * If you specify <code>AllowedInstanceTypes</code> , you can't specify <code>ExcludedInstanceTypes</code> .
         * <p>
         * </blockquote>
         * <p>
         * Default: All instance types
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-allowedinstancetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-allowedinstancetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedInstanceTypes() {
            return null;
        }

        /**
         * Indicates whether bare metal instance types must be included, excluded, or required.
         * <p>
         * <ul>
         * <li>To include bare metal instance types, specify <code>included</code> .</li>
         * <li>To require only bare metal instance types, specify <code>required</code> .</li>
         * <li>To exclude bare metal instance types, specify <code>excluded</code> .</li>
         * </ul>
         * <p>
         * Default: <code>excluded</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-baremetal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-baremetal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBareMetal() {
            return null;
        }

        /**
         * The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * Default: No minimum or maximum limits
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-baselineebsbandwidthmbps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-baselineebsbandwidthmbps</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBaselineEbsBandwidthMbps() {
            return null;
        }

        /**
         * Indicates whether burstable performance T instance types are included, excluded, or required.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> .
         * <p>
         * <ul>
         * <li>To include burstable performance instance types, specify <code>included</code> .</li>
         * <li>To require only burstable performance instance types, specify <code>required</code> .</li>
         * <li>To exclude burstable performance instance types, specify <code>excluded</code> .</li>
         * </ul>
         * <p>
         * Default: <code>excluded</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-burstableperformance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-burstableperformance</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBurstablePerformance() {
            return null;
        }

        /**
         * The CPU manufacturers to include.
         * <p>
         * <ul>
         * <li>For instance types with Intel CPUs, specify <code>intel</code> .</li>
         * <li>For instance types with AMD CPUs, specify <code>amd</code> .</li>
         * <li>For instance types with AWS CPUs, specify <code>amazon-web-services</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Don't confuse the CPU manufacturer with the CPU architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
         * <p>
         * </blockquote>
         * <p>
         * Default: Any manufacturer
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-cpumanufacturers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-cpumanufacturers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCpuManufacturers() {
            return null;
        }

        /**
         * The instance types to exclude.
         * <p>
         * You can use strings with one or more wild cards, represented by an asterisk ( <code>*</code> ), to exclude an instance family, type, size, or generation. The following are examples: <code>m5.8xlarge</code> , <code>c5*.*</code> , <code>m5a.*</code> , <code>r*</code> , <code>*3*</code> .
         * <p>
         * For example, if you specify <code>c5*</code> ,Amazon EC2 will exclude the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code> , Amazon EC2 will exclude all the M5a instance types, but not the M5n instance types.
         * <p>
         * <blockquote>
         * <p>
         * If you specify <code>ExcludedInstanceTypes</code> , you can't specify <code>AllowedInstanceTypes</code> .
         * <p>
         * </blockquote>
         * <p>
         * Default: No excluded instance types
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-excludedinstancetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-excludedinstancetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedInstanceTypes() {
            return null;
        }

        /**
         * Indicates whether current or previous generation instance types are included.
         * <p>
         * The current generation instance types are recommended for use. Current generation instance types are typically the latest two to three generations in each instance family. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * For current generation instance types, specify <code>current</code> .
         * <p>
         * For previous generation instance types, specify <code>previous</code> .
         * <p>
         * Default: Current and previous generation instance types
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-instancegenerations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-instancegenerations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceGenerations() {
            return null;
        }

        /**
         * Indicates whether instance types with instance store volumes are included, excluded, or required.
         * <p>
         * For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * <ul>
         * <li>To include instance types with instance store volumes, specify <code>included</code> .</li>
         * <li>To require only instance types with instance store volumes, specify <code>required</code> .</li>
         * <li>To exclude instance types with instance store volumes, specify <code>excluded</code> .</li>
         * </ul>
         * <p>
         * Default: <code>included</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-localstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-localstorage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocalStorage() {
            return null;
        }

        /**
         * The type of local storage that is required.
         * <p>
         * <ul>
         * <li>For instance types with hard disk drive (HDD) storage, specify <code>hdd</code> .</li>
         * <li>For instance types with solid state drive (SSD) storage, specify <code>ssd</code> .</li>
         * </ul>
         * <p>
         * Default: <code>hdd</code> and <code>ssd</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-localstoragetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-localstoragetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLocalStorageTypes() {
            return null;
        }

        /**
         * [Price protection] The price protection threshold for Spot Instances, as a percentage of an identified On-Demand price.
         * <p>
         * The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from the lowest priced current generation instance types, and failing that, from the lowest priced previous generation instance types that match your attributes. When Amazon EC2 selects instance types with your attributes, it will exclude instance types whose price exceeds your specified threshold.
         * <p>
         * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
         * <p>
         * If you set <code>DesiredCapacityType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is based on the per vCPU or per memory price instead of the per instance price.
         * <p>
         * <blockquote>
         * <p>
         * Only one of <code>SpotMaxPricePercentageOverLowestPrice</code> or <code>MaxSpotPriceAsPercentageOfOptimalOnDemandPrice</code> can be specified. If you don't specify either, Amazon EC2 will automatically apply optimal price protection to consistently select from a wide range of instance types. To indicate no price protection threshold for Spot Instances, meaning you want to consider all instance types that match your attributes, include one of these parameters and specify a high value, such as <code>999999</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-maxspotpriceaspercentageofoptimalondemandprice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-maxspotpriceaspercentageofoptimalondemandprice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice() {
            return null;
        }

        /**
         * The minimum and maximum amount of memory per vCPU, in GiB.
         * <p>
         * Default: No minimum or maximum limits
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-memorygibpervcpu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-memorygibpervcpu</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemoryGiBPerVCpu() {
            return null;
        }

        /**
         * The minimum and maximum amount of memory, in MiB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-memorymib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-memorymib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemoryMiB() {
            return null;
        }

        /**
         * The minimum and maximum amount of baseline network bandwidth, in gigabits per second (Gbps).
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-network-bandwidth.html">Amazon EC2 instance network bandwidth</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * Default: No minimum or maximum limits
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-networkbandwidthgbps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-networkbandwidthgbps</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkBandwidthGbps() {
            return null;
        }

        /**
         * The minimum and maximum number of network interfaces.
         * <p>
         * Default: No minimum or maximum limits
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-networkinterfacecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-networkinterfacecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaceCount() {
            return null;
        }

        /**
         * [Price protection] The price protection threshold for On-Demand Instances, as a percentage higher than an identified On-Demand price.
         * <p>
         * The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it will exclude instance types whose price exceeds your specified threshold.
         * <p>
         * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
         * <p>
         * To indicate no price protection threshold, specify a high value, such as <code>999999</code> .
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
         * <p>
         * </blockquote>
         * <p>
         * Default: <code>20</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-ondemandmaxpricepercentageoverlowestprice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-ondemandmaxpricepercentageoverlowestprice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOnDemandMaxPricePercentageOverLowestPrice() {
            return null;
        }

        /**
         * Indicates whether instance types must support hibernation for On-Demand Instances.
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> .
         * <p>
         * Default: <code>false</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-requirehibernatesupport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-requirehibernatesupport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireHibernateSupport() {
            return null;
        }

        /**
         * [Price protection] The price protection threshold for Spot Instances, as a percentage higher than an identified Spot price.
         * <p>
         * The identified Spot price is the Spot price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified Spot price is from the lowest priced current generation instance types, and failing that, from the lowest priced previous generation instance types that match your attributes. When Amazon EC2 selects instance types with your attributes, it will exclude instance types whose Spot price exceeds your specified threshold.
         * <p>
         * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
         * <p>
         * If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
         * <p>
         * <blockquote>
         * <p>
         * Only one of <code>SpotMaxPricePercentageOverLowestPrice</code> or <code>MaxSpotPriceAsPercentageOfOptimalOnDemandPrice</code> can be specified. If you don't specify either, Amazon EC2 will automatically apply optimal price protection to consistently select from a wide range of instance types. To indicate no price protection threshold for Spot Instances, meaning you want to consider all instance types that match your attributes, include one of these parameters and specify a high value, such as <code>999999</code> .
         * <p>
         * </blockquote>
         * <p>
         * Default: <code>100</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-spotmaxpricepercentageoverlowestprice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-spotmaxpricepercentageoverlowestprice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSpotMaxPricePercentageOverLowestPrice() {
            return null;
        }

        /**
         * The minimum and maximum amount of total local storage, in GB.
         * <p>
         * Default: No minimum or maximum limits
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-totallocalstoragegb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-totallocalstoragegb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTotalLocalStorageGb() {
            return null;
        }

        /**
         * The minimum and maximum number of vCPUs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-vcpucount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-instancerequirementsrequest.html#cfn-ec2-ec2fleet-instancerequirementsrequest-vcpucount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVCpuCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceRequirementsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceRequirementsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceRequirementsRequestProperty> {
            java.lang.Object acceleratorCount;
            java.util.List<java.lang.String> acceleratorManufacturers;
            java.util.List<java.lang.String> acceleratorNames;
            java.lang.Object acceleratorTotalMemoryMiB;
            java.util.List<java.lang.String> acceleratorTypes;
            java.util.List<java.lang.String> allowedInstanceTypes;
            java.lang.String bareMetal;
            java.lang.Object baselineEbsBandwidthMbps;
            java.lang.String burstablePerformance;
            java.util.List<java.lang.String> cpuManufacturers;
            java.util.List<java.lang.String> excludedInstanceTypes;
            java.util.List<java.lang.String> instanceGenerations;
            java.lang.String localStorage;
            java.util.List<java.lang.String> localStorageTypes;
            java.lang.Number maxSpotPriceAsPercentageOfOptimalOnDemandPrice;
            java.lang.Object memoryGiBPerVCpu;
            java.lang.Object memoryMiB;
            java.lang.Object networkBandwidthGbps;
            java.lang.Object networkInterfaceCount;
            java.lang.Number onDemandMaxPricePercentageOverLowestPrice;
            java.lang.Object requireHibernateSupport;
            java.lang.Number spotMaxPricePercentageOverLowestPrice;
            java.lang.Object totalLocalStorageGb;
            java.lang.Object vCpuCount;

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorCount}
             * @param acceleratorCount The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
             *                         To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
             *                         <p>
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCount(software.amazon.awscdk.IResolvable acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorCount}
             * @param acceleratorCount The minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips) on an instance.
             *                         To exclude accelerator-enabled instance types, set <code>Max</code> to <code>0</code> .
             *                         <p>
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCount(software.amazon.awscdk.services.ec2.CfnEC2Fleet.AcceleratorCountRequestProperty acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorManufacturers}
             * @param acceleratorManufacturers Indicates whether instance types must have accelerators by specific manufacturers.
             *                                 <ul>
             *                                 <li>For instance types with AWS devices, specify <code>amazon-web-services</code> .</li>
             *                                 <li>For instance types with AMD devices, specify <code>amd</code> .</li>
             *                                 <li>For instance types with Habana devices, specify <code>habana</code> .</li>
             *                                 <li>For instance types with NVIDIA devices, specify <code>nvidia</code> .</li>
             *                                 <li>For instance types with Xilinx devices, specify <code>xilinx</code> .</li>
             *                                 </ul>
             *                                 <p>
             *                                 Default: Any manufacturer
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorManufacturers(java.util.List<java.lang.String> acceleratorManufacturers) {
                this.acceleratorManufacturers = acceleratorManufacturers;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorNames}
             * @param acceleratorNames The accelerators that must be on the instance type.
             *                         <ul>
             *                         <li>For instance types with NVIDIA A10G GPUs, specify <code>a10g</code> .</li>
             *                         <li>For instance types with NVIDIA A100 GPUs, specify <code>a100</code> .</li>
             *                         <li>For instance types with NVIDIA H100 GPUs, specify <code>h100</code> .</li>
             *                         <li>For instance types with AWS Inferentia chips, specify <code>inferentia</code> .</li>
             *                         <li>For instance types with NVIDIA GRID K520 GPUs, specify <code>k520</code> .</li>
             *                         <li>For instance types with NVIDIA K80 GPUs, specify <code>k80</code> .</li>
             *                         <li>For instance types with NVIDIA M60 GPUs, specify <code>m60</code> .</li>
             *                         <li>For instance types with AMD Radeon Pro V520 GPUs, specify <code>radeon-pro-v520</code> .</li>
             *                         <li>For instance types with NVIDIA T4 GPUs, specify <code>t4</code> .</li>
             *                         <li>For instance types with NVIDIA T4G GPUs, specify <code>t4g</code> .</li>
             *                         <li>For instance types with Xilinx VU9P FPGAs, specify <code>vu9p</code> .</li>
             *                         <li>For instance types with NVIDIA V100 GPUs, specify <code>v100</code> .</li>
             *                         </ul>
             *                         <p>
             *                         Default: Any accelerator
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorNames(java.util.List<java.lang.String> acceleratorNames) {
                this.acceleratorNames = acceleratorNames;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorTotalMemoryMiB}
             * @param acceleratorTotalMemoryMiB The minimum and maximum amount of total accelerator memory, in MiB.
             *                                  Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTotalMemoryMiB(software.amazon.awscdk.IResolvable acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorTotalMemoryMiB}
             * @param acceleratorTotalMemoryMiB The minimum and maximum amount of total accelerator memory, in MiB.
             *                                  Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTotalMemoryMiB(software.amazon.awscdk.services.ec2.CfnEC2Fleet.AcceleratorTotalMemoryMiBRequestProperty acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorTypes}
             * @param acceleratorTypes The accelerator types that must be on the instance type.
             *                         <ul>
             *                         <li>To include instance types with GPU hardware, specify <code>gpu</code> .</li>
             *                         <li>To include instance types with FPGA hardware, specify <code>fpga</code> .</li>
             *                         <li>To include instance types with inference hardware, specify <code>inference</code> .</li>
             *                         </ul>
             *                         <p>
             *                         Default: Any accelerator type
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTypes(java.util.List<java.lang.String> acceleratorTypes) {
                this.acceleratorTypes = acceleratorTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAllowedInstanceTypes}
             * @param allowedInstanceTypes The instance types to apply your specified attributes against.
             *                             All other instance types are ignored, even if they match your specified attributes.
             *                             <p>
             *                             You can use strings with one or more wild cards, represented by an asterisk ( <code>*</code> ), to allow an instance type, size, or generation. The following are examples: <code>m5.8xlarge</code> , <code>c5*.*</code> , <code>m5a.*</code> , <code>r*</code> , <code>*3*</code> .
             *                             <p>
             *                             For example, if you specify <code>c5*</code> ,Amazon EC2 will allow the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code> , Amazon EC2 will allow all the M5a instance types, but not the M5n instance types.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             If you specify <code>AllowedInstanceTypes</code> , you can't specify <code>ExcludedInstanceTypes</code> .
             *                             <p>
             *                             </blockquote>
             *                             <p>
             *                             Default: All instance types
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedInstanceTypes(java.util.List<java.lang.String> allowedInstanceTypes) {
                this.allowedInstanceTypes = allowedInstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBareMetal}
             * @param bareMetal Indicates whether bare metal instance types must be included, excluded, or required.
             *                  <ul>
             *                  <li>To include bare metal instance types, specify <code>included</code> .</li>
             *                  <li>To require only bare metal instance types, specify <code>required</code> .</li>
             *                  <li>To exclude bare metal instance types, specify <code>excluded</code> .</li>
             *                  </ul>
             *                  <p>
             *                  Default: <code>excluded</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bareMetal(java.lang.String bareMetal) {
                this.bareMetal = bareMetal;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBaselineEbsBandwidthMbps}
             * @param baselineEbsBandwidthMbps The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
             *                                 For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
             *                                 <p>
             *                                 Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineEbsBandwidthMbps(software.amazon.awscdk.IResolvable baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBaselineEbsBandwidthMbps}
             * @param baselineEbsBandwidthMbps The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps.
             *                                 For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
             *                                 <p>
             *                                 Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineEbsBandwidthMbps(software.amazon.awscdk.services.ec2.CfnEC2Fleet.BaselineEbsBandwidthMbpsRequestProperty baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBurstablePerformance}
             * @param burstablePerformance Indicates whether burstable performance T instance types are included, excluded, or required.
             *                             For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> .
             *                             <p>
             *                             <ul>
             *                             <li>To include burstable performance instance types, specify <code>included</code> .</li>
             *                             <li>To require only burstable performance instance types, specify <code>required</code> .</li>
             *                             <li>To exclude burstable performance instance types, specify <code>excluded</code> .</li>
             *                             </ul>
             *                             <p>
             *                             Default: <code>excluded</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder burstablePerformance(java.lang.String burstablePerformance) {
                this.burstablePerformance = burstablePerformance;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getCpuManufacturers}
             * @param cpuManufacturers The CPU manufacturers to include.
             *                         <ul>
             *                         <li>For instance types with Intel CPUs, specify <code>intel</code> .</li>
             *                         <li>For instance types with AMD CPUs, specify <code>amd</code> .</li>
             *                         <li>For instance types with AWS CPUs, specify <code>amazon-web-services</code> .</li>
             *                         </ul>
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         Don't confuse the CPU manufacturer with the CPU architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         Default: Any manufacturer
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuManufacturers(java.util.List<java.lang.String> cpuManufacturers) {
                this.cpuManufacturers = cpuManufacturers;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getExcludedInstanceTypes}
             * @param excludedInstanceTypes The instance types to exclude.
             *                              You can use strings with one or more wild cards, represented by an asterisk ( <code>*</code> ), to exclude an instance family, type, size, or generation. The following are examples: <code>m5.8xlarge</code> , <code>c5*.*</code> , <code>m5a.*</code> , <code>r*</code> , <code>*3*</code> .
             *                              <p>
             *                              For example, if you specify <code>c5*</code> ,Amazon EC2 will exclude the entire C5 instance family, which includes all C5a and C5n instance types. If you specify <code>m5a.*</code> , Amazon EC2 will exclude all the M5a instance types, but not the M5n instance types.
             *                              <p>
             *                              <blockquote>
             *                              <p>
             *                              If you specify <code>ExcludedInstanceTypes</code> , you can't specify <code>AllowedInstanceTypes</code> .
             *                              <p>
             *                              </blockquote>
             *                              <p>
             *                              Default: No excluded instance types
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedInstanceTypes(java.util.List<java.lang.String> excludedInstanceTypes) {
                this.excludedInstanceTypes = excludedInstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getInstanceGenerations}
             * @param instanceGenerations Indicates whether current or previous generation instance types are included.
             *                            The current generation instance types are recommended for use. Current generation instance types are typically the latest two to three generations in each instance family. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <em>Amazon EC2 User Guide</em> .
             *                            <p>
             *                            For current generation instance types, specify <code>current</code> .
             *                            <p>
             *                            For previous generation instance types, specify <code>previous</code> .
             *                            <p>
             *                            Default: Current and previous generation instance types
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceGenerations(java.util.List<java.lang.String> instanceGenerations) {
                this.instanceGenerations = instanceGenerations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getLocalStorage}
             * @param localStorage Indicates whether instance types with instance store volumes are included, excluded, or required.
             *                     For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in the <em>Amazon EC2 User Guide</em> .
             *                     <p>
             *                     <ul>
             *                     <li>To include instance types with instance store volumes, specify <code>included</code> .</li>
             *                     <li>To require only instance types with instance store volumes, specify <code>required</code> .</li>
             *                     <li>To exclude instance types with instance store volumes, specify <code>excluded</code> .</li>
             *                     </ul>
             *                     <p>
             *                     Default: <code>included</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localStorage(java.lang.String localStorage) {
                this.localStorage = localStorage;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getLocalStorageTypes}
             * @param localStorageTypes The type of local storage that is required.
             *                          <ul>
             *                          <li>For instance types with hard disk drive (HDD) storage, specify <code>hdd</code> .</li>
             *                          <li>For instance types with solid state drive (SSD) storage, specify <code>ssd</code> .</li>
             *                          </ul>
             *                          <p>
             *                          Default: <code>hdd</code> and <code>ssd</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localStorageTypes(java.util.List<java.lang.String> localStorageTypes) {
                this.localStorageTypes = localStorageTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice}
             * @param maxSpotPriceAsPercentageOfOptimalOnDemandPrice [Price protection] The price protection threshold for Spot Instances, as a percentage of an identified On-Demand price.
             *                                                       The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from the lowest priced current generation instance types, and failing that, from the lowest priced previous generation instance types that match your attributes. When Amazon EC2 selects instance types with your attributes, it will exclude instance types whose price exceeds your specified threshold.
             *                                                       <p>
             *                                                       The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
             *                                                       <p>
             *                                                       If you set <code>DesiredCapacityType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is based on the per vCPU or per memory price instead of the per instance price.
             *                                                       <p>
             *                                                       <blockquote>
             *                                                       <p>
             *                                                       Only one of <code>SpotMaxPricePercentageOverLowestPrice</code> or <code>MaxSpotPriceAsPercentageOfOptimalOnDemandPrice</code> can be specified. If you don't specify either, Amazon EC2 will automatically apply optimal price protection to consistently select from a wide range of instance types. To indicate no price protection threshold for Spot Instances, meaning you want to consider all instance types that match your attributes, include one of these parameters and specify a high value, such as <code>999999</code> .
             *                                                       <p>
             *                                                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxSpotPriceAsPercentageOfOptimalOnDemandPrice(java.lang.Number maxSpotPriceAsPercentageOfOptimalOnDemandPrice) {
                this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice = maxSpotPriceAsPercentageOfOptimalOnDemandPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryGiBPerVCpu}
             * @param memoryGiBPerVCpu The minimum and maximum amount of memory per vCPU, in GiB.
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryGiBPerVCpu(software.amazon.awscdk.IResolvable memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryGiBPerVCpu}
             * @param memoryGiBPerVCpu The minimum and maximum amount of memory per vCPU, in GiB.
             *                         Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryGiBPerVCpu(software.amazon.awscdk.services.ec2.CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryMiB}
             * @param memoryMiB The minimum and maximum amount of memory, in MiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.IResolvable memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryMiB}
             * @param memoryMiB The minimum and maximum amount of memory, in MiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.services.ec2.CfnEC2Fleet.MemoryMiBRequestProperty memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getNetworkBandwidthGbps}
             * @param networkBandwidthGbps The minimum and maximum amount of baseline network bandwidth, in gigabits per second (Gbps).
             *                             For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-network-bandwidth.html">Amazon EC2 instance network bandwidth</a> in the <em>Amazon EC2 User Guide</em> .
             *                             <p>
             *                             Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkBandwidthGbps(software.amazon.awscdk.IResolvable networkBandwidthGbps) {
                this.networkBandwidthGbps = networkBandwidthGbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getNetworkBandwidthGbps}
             * @param networkBandwidthGbps The minimum and maximum amount of baseline network bandwidth, in gigabits per second (Gbps).
             *                             For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-network-bandwidth.html">Amazon EC2 instance network bandwidth</a> in the <em>Amazon EC2 User Guide</em> .
             *                             <p>
             *                             Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkBandwidthGbps(software.amazon.awscdk.services.ec2.CfnEC2Fleet.NetworkBandwidthGbpsRequestProperty networkBandwidthGbps) {
                this.networkBandwidthGbps = networkBandwidthGbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getNetworkInterfaceCount}
             * @param networkInterfaceCount The minimum and maximum number of network interfaces.
             *                              Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceCount(software.amazon.awscdk.IResolvable networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getNetworkInterfaceCount}
             * @param networkInterfaceCount The minimum and maximum number of network interfaces.
             *                              Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceCount(software.amazon.awscdk.services.ec2.CfnEC2Fleet.NetworkInterfaceCountRequestProperty networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getOnDemandMaxPricePercentageOverLowestPrice}
             * @param onDemandMaxPricePercentageOverLowestPrice [Price protection] The price protection threshold for On-Demand Instances, as a percentage higher than an identified On-Demand price.
             *                                                  The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it will exclude instance types whose price exceeds your specified threshold.
             *                                                  <p>
             *                                                  The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
             *                                                  <p>
             *                                                  To indicate no price protection threshold, specify a high value, such as <code>999999</code> .
             *                                                  <p>
             *                                                  This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
             *                                                  <p>
             *                                                  <blockquote>
             *                                                  <p>
             *                                                  If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
             *                                                  <p>
             *                                                  </blockquote>
             *                                                  <p>
             *                                                  Default: <code>20</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandMaxPricePercentageOverLowestPrice(java.lang.Number onDemandMaxPricePercentageOverLowestPrice) {
                this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getRequireHibernateSupport}
             * @param requireHibernateSupport Indicates whether instance types must support hibernation for On-Demand Instances.
             *                                This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> .
             *                                <p>
             *                                Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireHibernateSupport(java.lang.Boolean requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getRequireHibernateSupport}
             * @param requireHibernateSupport Indicates whether instance types must support hibernation for On-Demand Instances.
             *                                This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> .
             *                                <p>
             *                                Default: <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireHibernateSupport(software.amazon.awscdk.IResolvable requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getSpotMaxPricePercentageOverLowestPrice}
             * @param spotMaxPricePercentageOverLowestPrice [Price protection] The price protection threshold for Spot Instances, as a percentage higher than an identified Spot price.
             *                                              The identified Spot price is the Spot price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified Spot price is from the lowest priced current generation instance types, and failing that, from the lowest priced previous generation instance types that match your attributes. When Amazon EC2 selects instance types with your attributes, it will exclude instance types whose Spot price exceeds your specified threshold.
             *                                              <p>
             *                                              The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
             *                                              <p>
             *                                              If you set <code>TargetCapacityUnitType</code> to <code>vcpu</code> or <code>memory-mib</code> , the price protection threshold is applied based on the per-vCPU or per-memory price instead of the per-instance price.
             *                                              <p>
             *                                              This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetSpotPlacementScores.html">GetSpotPlacementScores</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements.html">GetInstanceTypesFromInstanceRequirements</a> .
             *                                              <p>
             *                                              <blockquote>
             *                                              <p>
             *                                              Only one of <code>SpotMaxPricePercentageOverLowestPrice</code> or <code>MaxSpotPriceAsPercentageOfOptimalOnDemandPrice</code> can be specified. If you don't specify either, Amazon EC2 will automatically apply optimal price protection to consistently select from a wide range of instance types. To indicate no price protection threshold for Spot Instances, meaning you want to consider all instance types that match your attributes, include one of these parameters and specify a high value, such as <code>999999</code> .
             *                                              <p>
             *                                              </blockquote>
             *                                              <p>
             *                                              Default: <code>100</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotMaxPricePercentageOverLowestPrice(java.lang.Number spotMaxPricePercentageOverLowestPrice) {
                this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getTotalLocalStorageGb}
             * @param totalLocalStorageGb The minimum and maximum amount of total local storage, in GB.
             *                            Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalLocalStorageGb(software.amazon.awscdk.IResolvable totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getTotalLocalStorageGb}
             * @param totalLocalStorageGb The minimum and maximum amount of total local storage, in GB.
             *                            Default: No minimum or maximum limits
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalLocalStorageGb(software.amazon.awscdk.services.ec2.CfnEC2Fleet.TotalLocalStorageGBRequestProperty totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getVCpuCount}
             * @param vCpuCount The minimum and maximum number of vCPUs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.IResolvable vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getVCpuCount}
             * @param vCpuCount The minimum and maximum number of vCPUs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.services.ec2.CfnEC2Fleet.VCpuCountRangeRequestProperty vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceRequirementsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceRequirementsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceRequirementsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceRequirementsRequestProperty {
            private final java.lang.Object acceleratorCount;
            private final java.util.List<java.lang.String> acceleratorManufacturers;
            private final java.util.List<java.lang.String> acceleratorNames;
            private final java.lang.Object acceleratorTotalMemoryMiB;
            private final java.util.List<java.lang.String> acceleratorTypes;
            private final java.util.List<java.lang.String> allowedInstanceTypes;
            private final java.lang.String bareMetal;
            private final java.lang.Object baselineEbsBandwidthMbps;
            private final java.lang.String burstablePerformance;
            private final java.util.List<java.lang.String> cpuManufacturers;
            private final java.util.List<java.lang.String> excludedInstanceTypes;
            private final java.util.List<java.lang.String> instanceGenerations;
            private final java.lang.String localStorage;
            private final java.util.List<java.lang.String> localStorageTypes;
            private final java.lang.Number maxSpotPriceAsPercentageOfOptimalOnDemandPrice;
            private final java.lang.Object memoryGiBPerVCpu;
            private final java.lang.Object memoryMiB;
            private final java.lang.Object networkBandwidthGbps;
            private final java.lang.Object networkInterfaceCount;
            private final java.lang.Number onDemandMaxPricePercentageOverLowestPrice;
            private final java.lang.Object requireHibernateSupport;
            private final java.lang.Number spotMaxPricePercentageOverLowestPrice;
            private final java.lang.Object totalLocalStorageGb;
            private final java.lang.Object vCpuCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acceleratorCount = software.amazon.jsii.Kernel.get(this, "acceleratorCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorManufacturers = software.amazon.jsii.Kernel.get(this, "acceleratorManufacturers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.acceleratorNames = software.amazon.jsii.Kernel.get(this, "acceleratorNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.acceleratorTotalMemoryMiB = software.amazon.jsii.Kernel.get(this, "acceleratorTotalMemoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorTypes = software.amazon.jsii.Kernel.get(this, "acceleratorTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedInstanceTypes = software.amazon.jsii.Kernel.get(this, "allowedInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.bareMetal = software.amazon.jsii.Kernel.get(this, "bareMetal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.baselineEbsBandwidthMbps = software.amazon.jsii.Kernel.get(this, "baselineEbsBandwidthMbps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.burstablePerformance = software.amazon.jsii.Kernel.get(this, "burstablePerformance", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cpuManufacturers = software.amazon.jsii.Kernel.get(this, "cpuManufacturers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.excludedInstanceTypes = software.amazon.jsii.Kernel.get(this, "excludedInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.instanceGenerations = software.amazon.jsii.Kernel.get(this, "instanceGenerations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.localStorage = software.amazon.jsii.Kernel.get(this, "localStorage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localStorageTypes = software.amazon.jsii.Kernel.get(this, "localStorageTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice = software.amazon.jsii.Kernel.get(this, "maxSpotPriceAsPercentageOfOptimalOnDemandPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.memoryGiBPerVCpu = software.amazon.jsii.Kernel.get(this, "memoryGiBPerVCpu", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.memoryMiB = software.amazon.jsii.Kernel.get(this, "memoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkBandwidthGbps = software.amazon.jsii.Kernel.get(this, "networkBandwidthGbps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkInterfaceCount = software.amazon.jsii.Kernel.get(this, "networkInterfaceCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onDemandMaxPricePercentageOverLowestPrice = software.amazon.jsii.Kernel.get(this, "onDemandMaxPricePercentageOverLowestPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.requireHibernateSupport = software.amazon.jsii.Kernel.get(this, "requireHibernateSupport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spotMaxPricePercentageOverLowestPrice = software.amazon.jsii.Kernel.get(this, "spotMaxPricePercentageOverLowestPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.totalLocalStorageGb = software.amazon.jsii.Kernel.get(this, "totalLocalStorageGb", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vCpuCount = software.amazon.jsii.Kernel.get(this, "vCpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acceleratorCount = builder.acceleratorCount;
                this.acceleratorManufacturers = builder.acceleratorManufacturers;
                this.acceleratorNames = builder.acceleratorNames;
                this.acceleratorTotalMemoryMiB = builder.acceleratorTotalMemoryMiB;
                this.acceleratorTypes = builder.acceleratorTypes;
                this.allowedInstanceTypes = builder.allowedInstanceTypes;
                this.bareMetal = builder.bareMetal;
                this.baselineEbsBandwidthMbps = builder.baselineEbsBandwidthMbps;
                this.burstablePerformance = builder.burstablePerformance;
                this.cpuManufacturers = builder.cpuManufacturers;
                this.excludedInstanceTypes = builder.excludedInstanceTypes;
                this.instanceGenerations = builder.instanceGenerations;
                this.localStorage = builder.localStorage;
                this.localStorageTypes = builder.localStorageTypes;
                this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice = builder.maxSpotPriceAsPercentageOfOptimalOnDemandPrice;
                this.memoryGiBPerVCpu = builder.memoryGiBPerVCpu;
                this.memoryMiB = builder.memoryMiB;
                this.networkBandwidthGbps = builder.networkBandwidthGbps;
                this.networkInterfaceCount = builder.networkInterfaceCount;
                this.onDemandMaxPricePercentageOverLowestPrice = builder.onDemandMaxPricePercentageOverLowestPrice;
                this.requireHibernateSupport = builder.requireHibernateSupport;
                this.spotMaxPricePercentageOverLowestPrice = builder.spotMaxPricePercentageOverLowestPrice;
                this.totalLocalStorageGb = builder.totalLocalStorageGb;
                this.vCpuCount = builder.vCpuCount;
            }

            @Override
            public final java.lang.Object getAcceleratorCount() {
                return this.acceleratorCount;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorManufacturers() {
                return this.acceleratorManufacturers;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorNames() {
                return this.acceleratorNames;
            }

            @Override
            public final java.lang.Object getAcceleratorTotalMemoryMiB() {
                return this.acceleratorTotalMemoryMiB;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorTypes() {
                return this.acceleratorTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedInstanceTypes() {
                return this.allowedInstanceTypes;
            }

            @Override
            public final java.lang.String getBareMetal() {
                return this.bareMetal;
            }

            @Override
            public final java.lang.Object getBaselineEbsBandwidthMbps() {
                return this.baselineEbsBandwidthMbps;
            }

            @Override
            public final java.lang.String getBurstablePerformance() {
                return this.burstablePerformance;
            }

            @Override
            public final java.util.List<java.lang.String> getCpuManufacturers() {
                return this.cpuManufacturers;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedInstanceTypes() {
                return this.excludedInstanceTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getInstanceGenerations() {
                return this.instanceGenerations;
            }

            @Override
            public final java.lang.String getLocalStorage() {
                return this.localStorage;
            }

            @Override
            public final java.util.List<java.lang.String> getLocalStorageTypes() {
                return this.localStorageTypes;
            }

            @Override
            public final java.lang.Number getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice() {
                return this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice;
            }

            @Override
            public final java.lang.Object getMemoryGiBPerVCpu() {
                return this.memoryGiBPerVCpu;
            }

            @Override
            public final java.lang.Object getMemoryMiB() {
                return this.memoryMiB;
            }

            @Override
            public final java.lang.Object getNetworkBandwidthGbps() {
                return this.networkBandwidthGbps;
            }

            @Override
            public final java.lang.Object getNetworkInterfaceCount() {
                return this.networkInterfaceCount;
            }

            @Override
            public final java.lang.Number getOnDemandMaxPricePercentageOverLowestPrice() {
                return this.onDemandMaxPricePercentageOverLowestPrice;
            }

            @Override
            public final java.lang.Object getRequireHibernateSupport() {
                return this.requireHibernateSupport;
            }

            @Override
            public final java.lang.Number getSpotMaxPricePercentageOverLowestPrice() {
                return this.spotMaxPricePercentageOverLowestPrice;
            }

            @Override
            public final java.lang.Object getTotalLocalStorageGb() {
                return this.totalLocalStorageGb;
            }

            @Override
            public final java.lang.Object getVCpuCount() {
                return this.vCpuCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcceleratorCount() != null) {
                    data.set("acceleratorCount", om.valueToTree(this.getAcceleratorCount()));
                }
                if (this.getAcceleratorManufacturers() != null) {
                    data.set("acceleratorManufacturers", om.valueToTree(this.getAcceleratorManufacturers()));
                }
                if (this.getAcceleratorNames() != null) {
                    data.set("acceleratorNames", om.valueToTree(this.getAcceleratorNames()));
                }
                if (this.getAcceleratorTotalMemoryMiB() != null) {
                    data.set("acceleratorTotalMemoryMiB", om.valueToTree(this.getAcceleratorTotalMemoryMiB()));
                }
                if (this.getAcceleratorTypes() != null) {
                    data.set("acceleratorTypes", om.valueToTree(this.getAcceleratorTypes()));
                }
                if (this.getAllowedInstanceTypes() != null) {
                    data.set("allowedInstanceTypes", om.valueToTree(this.getAllowedInstanceTypes()));
                }
                if (this.getBareMetal() != null) {
                    data.set("bareMetal", om.valueToTree(this.getBareMetal()));
                }
                if (this.getBaselineEbsBandwidthMbps() != null) {
                    data.set("baselineEbsBandwidthMbps", om.valueToTree(this.getBaselineEbsBandwidthMbps()));
                }
                if (this.getBurstablePerformance() != null) {
                    data.set("burstablePerformance", om.valueToTree(this.getBurstablePerformance()));
                }
                if (this.getCpuManufacturers() != null) {
                    data.set("cpuManufacturers", om.valueToTree(this.getCpuManufacturers()));
                }
                if (this.getExcludedInstanceTypes() != null) {
                    data.set("excludedInstanceTypes", om.valueToTree(this.getExcludedInstanceTypes()));
                }
                if (this.getInstanceGenerations() != null) {
                    data.set("instanceGenerations", om.valueToTree(this.getInstanceGenerations()));
                }
                if (this.getLocalStorage() != null) {
                    data.set("localStorage", om.valueToTree(this.getLocalStorage()));
                }
                if (this.getLocalStorageTypes() != null) {
                    data.set("localStorageTypes", om.valueToTree(this.getLocalStorageTypes()));
                }
                if (this.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice() != null) {
                    data.set("maxSpotPriceAsPercentageOfOptimalOnDemandPrice", om.valueToTree(this.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice()));
                }
                if (this.getMemoryGiBPerVCpu() != null) {
                    data.set("memoryGiBPerVCpu", om.valueToTree(this.getMemoryGiBPerVCpu()));
                }
                if (this.getMemoryMiB() != null) {
                    data.set("memoryMiB", om.valueToTree(this.getMemoryMiB()));
                }
                if (this.getNetworkBandwidthGbps() != null) {
                    data.set("networkBandwidthGbps", om.valueToTree(this.getNetworkBandwidthGbps()));
                }
                if (this.getNetworkInterfaceCount() != null) {
                    data.set("networkInterfaceCount", om.valueToTree(this.getNetworkInterfaceCount()));
                }
                if (this.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
                    data.set("onDemandMaxPricePercentageOverLowestPrice", om.valueToTree(this.getOnDemandMaxPricePercentageOverLowestPrice()));
                }
                if (this.getRequireHibernateSupport() != null) {
                    data.set("requireHibernateSupport", om.valueToTree(this.getRequireHibernateSupport()));
                }
                if (this.getSpotMaxPricePercentageOverLowestPrice() != null) {
                    data.set("spotMaxPricePercentageOverLowestPrice", om.valueToTree(this.getSpotMaxPricePercentageOverLowestPrice()));
                }
                if (this.getTotalLocalStorageGb() != null) {
                    data.set("totalLocalStorageGb", om.valueToTree(this.getTotalLocalStorageGb()));
                }
                if (this.getVCpuCount() != null) {
                    data.set("vCpuCount", om.valueToTree(this.getVCpuCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.InstanceRequirementsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceRequirementsRequestProperty.Jsii$Proxy that = (InstanceRequirementsRequestProperty.Jsii$Proxy) o;

                if (this.acceleratorCount != null ? !this.acceleratorCount.equals(that.acceleratorCount) : that.acceleratorCount != null) return false;
                if (this.acceleratorManufacturers != null ? !this.acceleratorManufacturers.equals(that.acceleratorManufacturers) : that.acceleratorManufacturers != null) return false;
                if (this.acceleratorNames != null ? !this.acceleratorNames.equals(that.acceleratorNames) : that.acceleratorNames != null) return false;
                if (this.acceleratorTotalMemoryMiB != null ? !this.acceleratorTotalMemoryMiB.equals(that.acceleratorTotalMemoryMiB) : that.acceleratorTotalMemoryMiB != null) return false;
                if (this.acceleratorTypes != null ? !this.acceleratorTypes.equals(that.acceleratorTypes) : that.acceleratorTypes != null) return false;
                if (this.allowedInstanceTypes != null ? !this.allowedInstanceTypes.equals(that.allowedInstanceTypes) : that.allowedInstanceTypes != null) return false;
                if (this.bareMetal != null ? !this.bareMetal.equals(that.bareMetal) : that.bareMetal != null) return false;
                if (this.baselineEbsBandwidthMbps != null ? !this.baselineEbsBandwidthMbps.equals(that.baselineEbsBandwidthMbps) : that.baselineEbsBandwidthMbps != null) return false;
                if (this.burstablePerformance != null ? !this.burstablePerformance.equals(that.burstablePerformance) : that.burstablePerformance != null) return false;
                if (this.cpuManufacturers != null ? !this.cpuManufacturers.equals(that.cpuManufacturers) : that.cpuManufacturers != null) return false;
                if (this.excludedInstanceTypes != null ? !this.excludedInstanceTypes.equals(that.excludedInstanceTypes) : that.excludedInstanceTypes != null) return false;
                if (this.instanceGenerations != null ? !this.instanceGenerations.equals(that.instanceGenerations) : that.instanceGenerations != null) return false;
                if (this.localStorage != null ? !this.localStorage.equals(that.localStorage) : that.localStorage != null) return false;
                if (this.localStorageTypes != null ? !this.localStorageTypes.equals(that.localStorageTypes) : that.localStorageTypes != null) return false;
                if (this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice != null ? !this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice.equals(that.maxSpotPriceAsPercentageOfOptimalOnDemandPrice) : that.maxSpotPriceAsPercentageOfOptimalOnDemandPrice != null) return false;
                if (this.memoryGiBPerVCpu != null ? !this.memoryGiBPerVCpu.equals(that.memoryGiBPerVCpu) : that.memoryGiBPerVCpu != null) return false;
                if (this.memoryMiB != null ? !this.memoryMiB.equals(that.memoryMiB) : that.memoryMiB != null) return false;
                if (this.networkBandwidthGbps != null ? !this.networkBandwidthGbps.equals(that.networkBandwidthGbps) : that.networkBandwidthGbps != null) return false;
                if (this.networkInterfaceCount != null ? !this.networkInterfaceCount.equals(that.networkInterfaceCount) : that.networkInterfaceCount != null) return false;
                if (this.onDemandMaxPricePercentageOverLowestPrice != null ? !this.onDemandMaxPricePercentageOverLowestPrice.equals(that.onDemandMaxPricePercentageOverLowestPrice) : that.onDemandMaxPricePercentageOverLowestPrice != null) return false;
                if (this.requireHibernateSupport != null ? !this.requireHibernateSupport.equals(that.requireHibernateSupport) : that.requireHibernateSupport != null) return false;
                if (this.spotMaxPricePercentageOverLowestPrice != null ? !this.spotMaxPricePercentageOverLowestPrice.equals(that.spotMaxPricePercentageOverLowestPrice) : that.spotMaxPricePercentageOverLowestPrice != null) return false;
                if (this.totalLocalStorageGb != null ? !this.totalLocalStorageGb.equals(that.totalLocalStorageGb) : that.totalLocalStorageGb != null) return false;
                return this.vCpuCount != null ? this.vCpuCount.equals(that.vCpuCount) : that.vCpuCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acceleratorCount != null ? this.acceleratorCount.hashCode() : 0;
                result = 31 * result + (this.acceleratorManufacturers != null ? this.acceleratorManufacturers.hashCode() : 0);
                result = 31 * result + (this.acceleratorNames != null ? this.acceleratorNames.hashCode() : 0);
                result = 31 * result + (this.acceleratorTotalMemoryMiB != null ? this.acceleratorTotalMemoryMiB.hashCode() : 0);
                result = 31 * result + (this.acceleratorTypes != null ? this.acceleratorTypes.hashCode() : 0);
                result = 31 * result + (this.allowedInstanceTypes != null ? this.allowedInstanceTypes.hashCode() : 0);
                result = 31 * result + (this.bareMetal != null ? this.bareMetal.hashCode() : 0);
                result = 31 * result + (this.baselineEbsBandwidthMbps != null ? this.baselineEbsBandwidthMbps.hashCode() : 0);
                result = 31 * result + (this.burstablePerformance != null ? this.burstablePerformance.hashCode() : 0);
                result = 31 * result + (this.cpuManufacturers != null ? this.cpuManufacturers.hashCode() : 0);
                result = 31 * result + (this.excludedInstanceTypes != null ? this.excludedInstanceTypes.hashCode() : 0);
                result = 31 * result + (this.instanceGenerations != null ? this.instanceGenerations.hashCode() : 0);
                result = 31 * result + (this.localStorage != null ? this.localStorage.hashCode() : 0);
                result = 31 * result + (this.localStorageTypes != null ? this.localStorageTypes.hashCode() : 0);
                result = 31 * result + (this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice != null ? this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice.hashCode() : 0);
                result = 31 * result + (this.memoryGiBPerVCpu != null ? this.memoryGiBPerVCpu.hashCode() : 0);
                result = 31 * result + (this.memoryMiB != null ? this.memoryMiB.hashCode() : 0);
                result = 31 * result + (this.networkBandwidthGbps != null ? this.networkBandwidthGbps.hashCode() : 0);
                result = 31 * result + (this.networkInterfaceCount != null ? this.networkInterfaceCount.hashCode() : 0);
                result = 31 * result + (this.onDemandMaxPricePercentageOverLowestPrice != null ? this.onDemandMaxPricePercentageOverLowestPrice.hashCode() : 0);
                result = 31 * result + (this.requireHibernateSupport != null ? this.requireHibernateSupport.hashCode() : 0);
                result = 31 * result + (this.spotMaxPricePercentageOverLowestPrice != null ? this.spotMaxPricePercentageOverLowestPrice.hashCode() : 0);
                result = 31 * result + (this.totalLocalStorageGb != null ? this.totalLocalStorageGb.hashCode() : 0);
                result = 31 * result + (this.vCpuCount != null ? this.vCpuCount.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MaintenanceStrategiesProperty maintenanceStrategiesProperty = MaintenanceStrategiesProperty.builder()
     *         .capacityRebalance(CapacityRebalanceProperty.builder()
     *                 .replacementStrategy("replacementStrategy")
     *                 .terminationDelay(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-maintenancestrategies.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-maintenancestrategies.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.MaintenanceStrategiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceStrategiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceStrategiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of being interrupted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-maintenancestrategies.html#cfn-ec2-ec2fleet-maintenancestrategies-capacityrebalance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-maintenancestrategies.html#cfn-ec2-ec2fleet-maintenancestrategies-capacityrebalance</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityRebalance() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaintenanceStrategiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceStrategiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceStrategiesProperty> {
            java.lang.Object capacityRebalance;

            /**
             * Sets the value of {@link MaintenanceStrategiesProperty#getCapacityRebalance}
             * @param capacityRebalance The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of being interrupted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityRebalance(software.amazon.awscdk.IResolvable capacityRebalance) {
                this.capacityRebalance = capacityRebalance;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceStrategiesProperty#getCapacityRebalance}
             * @param capacityRebalance The strategy to use when Amazon EC2 emits a signal that your Spot Instance is at an elevated risk of being interrupted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityRebalance(software.amazon.awscdk.services.ec2.CfnEC2Fleet.CapacityRebalanceProperty capacityRebalance) {
                this.capacityRebalance = capacityRebalance;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceStrategiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceStrategiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceStrategiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceStrategiesProperty {
            private final java.lang.Object capacityRebalance;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capacityRebalance = software.amazon.jsii.Kernel.get(this, "capacityRebalance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityRebalance = builder.capacityRebalance;
            }

            @Override
            public final java.lang.Object getCapacityRebalance() {
                return this.capacityRebalance;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCapacityRebalance() != null) {
                    data.set("capacityRebalance", om.valueToTree(this.getCapacityRebalance()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.MaintenanceStrategiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceStrategiesProperty.Jsii$Proxy that = (MaintenanceStrategiesProperty.Jsii$Proxy) o;

                return this.capacityRebalance != null ? this.capacityRebalance.equals(that.capacityRebalance) : that.capacityRebalance == null;
            }

            @Override
            public final int hashCode() {
                int result = this.capacityRebalance != null ? this.capacityRebalance.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of memory per vCPU, in GiB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MemoryGiBPerVCpuRequestProperty memoryGiBPerVCpuRequestProperty = MemoryGiBPerVCpuRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorygibpervcpurequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorygibpervcpurequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(MemoryGiBPerVCpuRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemoryGiBPerVCpuRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of memory per vCPU, in GiB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorygibpervcpurequest.html#cfn-ec2-ec2fleet-memorygibpervcpurequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorygibpervcpurequest.html#cfn-ec2-ec2fleet-memorygibpervcpurequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of memory per vCPU, in GiB.
         * <p>
         * To specify no minimum limit, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorygibpervcpurequest.html#cfn-ec2-ec2fleet-memorygibpervcpurequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorygibpervcpurequest.html#cfn-ec2-ec2fleet-memorygibpervcpurequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemoryGiBPerVCpuRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemoryGiBPerVCpuRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemoryGiBPerVCpuRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link MemoryGiBPerVCpuRequestProperty#getMax}
             * @param max The maximum amount of memory per vCPU, in GiB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link MemoryGiBPerVCpuRequestProperty#getMin}
             * @param min The minimum amount of memory per vCPU, in GiB.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemoryGiBPerVCpuRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemoryGiBPerVCpuRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemoryGiBPerVCpuRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemoryGiBPerVCpuRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.MemoryGiBPerVCpuRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemoryGiBPerVCpuRequestProperty.Jsii$Proxy that = (MemoryGiBPerVCpuRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of memory, in MiB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * MemoryMiBRequestProperty memoryMiBRequestProperty = MemoryMiBRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorymibrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorymibrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.MemoryMiBRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(MemoryMiBRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemoryMiBRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of memory, in MiB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorymibrequest.html#cfn-ec2-ec2fleet-memorymibrequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorymibrequest.html#cfn-ec2-ec2fleet-memorymibrequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of memory, in MiB.
         * <p>
         * To specify no minimum limit, specify <code>0</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorymibrequest.html#cfn-ec2-ec2fleet-memorymibrequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-memorymibrequest.html#cfn-ec2-ec2fleet-memorymibrequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemoryMiBRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link MemoryMiBRequestProperty#getMax}
             * @param max The maximum amount of memory, in MiB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link MemoryMiBRequestProperty#getMin}
             * @param min The minimum amount of memory, in MiB.
             *            To specify no minimum limit, specify <code>0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemoryMiBRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemoryMiBRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemoryMiBRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.MemoryMiBRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemoryMiBRequestProperty.Jsii$Proxy that = (MemoryMiBRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of network bandwidth, in gigabits per second (Gbps).
     * <p>
     * <blockquote>
     * <p>
     * Setting the minimum bandwidth does not guarantee that your instance will achieve the minimum bandwidth. Amazon EC2 will identify instance types that support the specified minimum bandwidth, but the actual bandwidth of your instance might go below the specified minimum at times. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-network-bandwidth.html#available-instance-bandwidth">Available instance bandwidth</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * NetworkBandwidthGbpsRequestProperty networkBandwidthGbpsRequestProperty = NetworkBandwidthGbpsRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-networkbandwidthgbpsrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-networkbandwidthgbpsrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.NetworkBandwidthGbpsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkBandwidthGbpsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkBandwidthGbpsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of network bandwidth, in Gbps.
         * <p>
         * To specify no maximum limit, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-networkbandwidthgbpsrequest.html#cfn-ec2-ec2fleet-networkbandwidthgbpsrequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-networkbandwidthgbpsrequest.html#cfn-ec2-ec2fleet-networkbandwidthgbpsrequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of network bandwidth, in Gbps.
         * <p>
         * To specify no minimum limit, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-networkbandwidthgbpsrequest.html#cfn-ec2-ec2fleet-networkbandwidthgbpsrequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-networkbandwidthgbpsrequest.html#cfn-ec2-ec2fleet-networkbandwidthgbpsrequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkBandwidthGbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkBandwidthGbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkBandwidthGbpsRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link NetworkBandwidthGbpsRequestProperty#getMax}
             * @param max The maximum amount of network bandwidth, in Gbps.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link NetworkBandwidthGbpsRequestProperty#getMin}
             * @param min The minimum amount of network bandwidth, in Gbps.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkBandwidthGbpsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkBandwidthGbpsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkBandwidthGbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkBandwidthGbpsRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.NetworkBandwidthGbpsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkBandwidthGbpsRequestProperty.Jsii$Proxy that = (NetworkBandwidthGbpsRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum number of network interfaces.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * NetworkInterfaceCountRequestProperty networkInterfaceCountRequestProperty = NetworkInterfaceCountRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-networkinterfacecountrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-networkinterfacecountrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.NetworkInterfaceCountRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkInterfaceCountRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkInterfaceCountRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of network interfaces.
         * <p>
         * To specify no maximum limit, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-networkinterfacecountrequest.html#cfn-ec2-ec2fleet-networkinterfacecountrequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-networkinterfacecountrequest.html#cfn-ec2-ec2fleet-networkinterfacecountrequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum number of network interfaces.
         * <p>
         * To specify no minimum limit, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-networkinterfacecountrequest.html#cfn-ec2-ec2fleet-networkinterfacecountrequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-networkinterfacecountrequest.html#cfn-ec2-ec2fleet-networkinterfacecountrequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkInterfaceCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkInterfaceCountRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link NetworkInterfaceCountRequestProperty#getMax}
             * @param max The maximum number of network interfaces.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceCountRequestProperty#getMin}
             * @param min The minimum number of network interfaces.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceCountRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkInterfaceCountRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkInterfaceCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInterfaceCountRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.NetworkInterfaceCountRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkInterfaceCountRequestProperty.Jsii$Proxy that = (NetworkInterfaceCountRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the allocation strategy of On-Demand Instances in an EC2 Fleet.
     * <p>
     * <code>OnDemandOptionsRequest</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html">AWS::EC2::EC2Fleet</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * OnDemandOptionsRequestProperty onDemandOptionsRequestProperty = OnDemandOptionsRequestProperty.builder()
     *         .allocationStrategy("allocationStrategy")
     *         .capacityReservationOptions(CapacityReservationOptionsRequestProperty.builder()
     *                 .usageStrategy("usageStrategy")
     *                 .build())
     *         .maxTotalPrice("maxTotalPrice")
     *         .minTargetCapacity(123)
     *         .singleAvailabilityZone(false)
     *         .singleInstanceType(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(OnDemandOptionsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnDemandOptionsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The strategy that determines the order of the launch template overrides to use in fulfilling On-Demand capacity.
         * <p>
         * <code>lowest-price</code> - EC2 Fleet uses price to determine the order, launching the lowest price first.
         * <p>
         * <code>prioritized</code> - EC2 Fleet uses the priority that you assigned to each launch template override, launching the highest priority first.
         * <p>
         * Default: <code>lowest-price</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-allocationstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-allocationstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
            return null;
        }

        /**
         * The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.
         * <p>
         * Supported only for fleets of type <code>instant</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-capacityreservationoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-capacityreservationoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityReservationOptions() {
            return null;
        }

        /**
         * The maximum amount per hour for On-Demand Instances that you're willing to pay.
         * <p>
         * <blockquote>
         * <p>
         * If your fleet includes T instances that are configured as <code>unlimited</code> , and if their average CPU usage exceeds the baseline utilization, you will incur a charge for surplus credits. The <code>MaxTotalPrice</code> does not account for surplus credits, and, if you use surplus credits, your final cost might be higher than what you specified for <code>MaxTotalPrice</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-unlimited-mode-concepts.html#unlimited-mode-surplus-credits">Surplus credits can incur charges</a> in the <em>EC2 User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-maxtotalprice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-maxtotalprice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxTotalPrice() {
            return null;
        }

        /**
         * The minimum target capacity for On-Demand Instances in the fleet.
         * <p>
         * If the minimum target capacity is not reached, the fleet launches no instances.
         * <p>
         * Supported only for fleets of type <code>instant</code> .
         * <p>
         * At least one of the following must be specified: <code>SingleAvailabilityZone</code> | <code>SingleInstanceType</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-mintargetcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-mintargetcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinTargetCapacity() {
            return null;
        }

        /**
         * Indicates that the fleet launches all On-Demand Instances into a single Availability Zone.
         * <p>
         * Supported only for fleets of type <code>instant</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-singleavailabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-singleavailabilityzone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleAvailabilityZone() {
            return null;
        }

        /**
         * Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet.
         * <p>
         * Supported only for fleets of type <code>instant</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-singleinstancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-singleinstancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleInstanceType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OnDemandOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnDemandOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnDemandOptionsRequestProperty> {
            java.lang.String allocationStrategy;
            java.lang.Object capacityReservationOptions;
            java.lang.String maxTotalPrice;
            java.lang.Number minTargetCapacity;
            java.lang.Object singleAvailabilityZone;
            java.lang.Object singleInstanceType;

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getAllocationStrategy}
             * @param allocationStrategy The strategy that determines the order of the launch template overrides to use in fulfilling On-Demand capacity.
             *                           <code>lowest-price</code> - EC2 Fleet uses price to determine the order, launching the lowest price first.
             *                           <p>
             *                           <code>prioritized</code> - EC2 Fleet uses the priority that you assigned to each launch template override, launching the highest priority first.
             *                           <p>
             *                           Default: <code>lowest-price</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getCapacityReservationOptions}
             * @param capacityReservationOptions The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.
             *                                   Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationOptions(software.amazon.awscdk.IResolvable capacityReservationOptions) {
                this.capacityReservationOptions = capacityReservationOptions;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getCapacityReservationOptions}
             * @param capacityReservationOptions The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.
             *                                   Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationOptions(software.amazon.awscdk.services.ec2.CfnEC2Fleet.CapacityReservationOptionsRequestProperty capacityReservationOptions) {
                this.capacityReservationOptions = capacityReservationOptions;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getMaxTotalPrice}
             * @param maxTotalPrice The maximum amount per hour for On-Demand Instances that you're willing to pay.
             *                      <blockquote>
             *                      <p>
             *                      If your fleet includes T instances that are configured as <code>unlimited</code> , and if their average CPU usage exceeds the baseline utilization, you will incur a charge for surplus credits. The <code>MaxTotalPrice</code> does not account for surplus credits, and, if you use surplus credits, your final cost might be higher than what you specified for <code>MaxTotalPrice</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-unlimited-mode-concepts.html#unlimited-mode-surplus-credits">Surplus credits can incur charges</a> in the <em>EC2 User Guide</em> .
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTotalPrice(java.lang.String maxTotalPrice) {
                this.maxTotalPrice = maxTotalPrice;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getMinTargetCapacity}
             * @param minTargetCapacity The minimum target capacity for On-Demand Instances in the fleet.
             *                          If the minimum target capacity is not reached, the fleet launches no instances.
             *                          <p>
             *                          Supported only for fleets of type <code>instant</code> .
             *                          <p>
             *                          At least one of the following must be specified: <code>SingleAvailabilityZone</code> | <code>SingleInstanceType</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTargetCapacity(java.lang.Number minTargetCapacity) {
                this.minTargetCapacity = minTargetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getSingleAvailabilityZone}
             * @param singleAvailabilityZone Indicates that the fleet launches all On-Demand Instances into a single Availability Zone.
             *                               Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleAvailabilityZone(java.lang.Boolean singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getSingleAvailabilityZone}
             * @param singleAvailabilityZone Indicates that the fleet launches all On-Demand Instances into a single Availability Zone.
             *                               Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleAvailabilityZone(software.amazon.awscdk.IResolvable singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getSingleInstanceType}
             * @param singleInstanceType Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet.
             *                           Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleInstanceType(java.lang.Boolean singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandOptionsRequestProperty#getSingleInstanceType}
             * @param singleInstanceType Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet.
             *                           Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleInstanceType(software.amazon.awscdk.IResolvable singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnDemandOptionsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnDemandOptionsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnDemandOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnDemandOptionsRequestProperty {
            private final java.lang.String allocationStrategy;
            private final java.lang.Object capacityReservationOptions;
            private final java.lang.String maxTotalPrice;
            private final java.lang.Number minTargetCapacity;
            private final java.lang.Object singleAvailabilityZone;
            private final java.lang.Object singleInstanceType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.capacityReservationOptions = software.amazon.jsii.Kernel.get(this, "capacityReservationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxTotalPrice = software.amazon.jsii.Kernel.get(this, "maxTotalPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minTargetCapacity = software.amazon.jsii.Kernel.get(this, "minTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.singleAvailabilityZone = software.amazon.jsii.Kernel.get(this, "singleAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleInstanceType = software.amazon.jsii.Kernel.get(this, "singleInstanceType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allocationStrategy = builder.allocationStrategy;
                this.capacityReservationOptions = builder.capacityReservationOptions;
                this.maxTotalPrice = builder.maxTotalPrice;
                this.minTargetCapacity = builder.minTargetCapacity;
                this.singleAvailabilityZone = builder.singleAvailabilityZone;
                this.singleInstanceType = builder.singleInstanceType;
            }

            @Override
            public final java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public final java.lang.Object getCapacityReservationOptions() {
                return this.capacityReservationOptions;
            }

            @Override
            public final java.lang.String getMaxTotalPrice() {
                return this.maxTotalPrice;
            }

            @Override
            public final java.lang.Number getMinTargetCapacity() {
                return this.minTargetCapacity;
            }

            @Override
            public final java.lang.Object getSingleAvailabilityZone() {
                return this.singleAvailabilityZone;
            }

            @Override
            public final java.lang.Object getSingleInstanceType() {
                return this.singleInstanceType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllocationStrategy() != null) {
                    data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getCapacityReservationOptions() != null) {
                    data.set("capacityReservationOptions", om.valueToTree(this.getCapacityReservationOptions()));
                }
                if (this.getMaxTotalPrice() != null) {
                    data.set("maxTotalPrice", om.valueToTree(this.getMaxTotalPrice()));
                }
                if (this.getMinTargetCapacity() != null) {
                    data.set("minTargetCapacity", om.valueToTree(this.getMinTargetCapacity()));
                }
                if (this.getSingleAvailabilityZone() != null) {
                    data.set("singleAvailabilityZone", om.valueToTree(this.getSingleAvailabilityZone()));
                }
                if (this.getSingleInstanceType() != null) {
                    data.set("singleInstanceType", om.valueToTree(this.getSingleInstanceType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnDemandOptionsRequestProperty.Jsii$Proxy that = (OnDemandOptionsRequestProperty.Jsii$Proxy) o;

                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                if (this.capacityReservationOptions != null ? !this.capacityReservationOptions.equals(that.capacityReservationOptions) : that.capacityReservationOptions != null) return false;
                if (this.maxTotalPrice != null ? !this.maxTotalPrice.equals(that.maxTotalPrice) : that.maxTotalPrice != null) return false;
                if (this.minTargetCapacity != null ? !this.minTargetCapacity.equals(that.minTargetCapacity) : that.minTargetCapacity != null) return false;
                if (this.singleAvailabilityZone != null ? !this.singleAvailabilityZone.equals(that.singleAvailabilityZone) : that.singleAvailabilityZone != null) return false;
                return this.singleInstanceType != null ? this.singleInstanceType.equals(that.singleInstanceType) : that.singleInstanceType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0;
                result = 31 * result + (this.capacityReservationOptions != null ? this.capacityReservationOptions.hashCode() : 0);
                result = 31 * result + (this.maxTotalPrice != null ? this.maxTotalPrice.hashCode() : 0);
                result = 31 * result + (this.minTargetCapacity != null ? this.minTargetCapacity.hashCode() : 0);
                result = 31 * result + (this.singleAvailabilityZone != null ? this.singleAvailabilityZone.hashCode() : 0);
                result = 31 * result + (this.singleInstanceType != null ? this.singleInstanceType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the placement of an instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * PlacementProperty placementProperty = PlacementProperty.builder()
     *         .affinity("affinity")
     *         .availabilityZone("availabilityZone")
     *         .groupName("groupName")
     *         .hostId("hostId")
     *         .hostResourceGroupArn("hostResourceGroupArn")
     *         .partitionNumber(123)
     *         .spreadDomain("spreadDomain")
     *         .tenancy("tenancy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.PlacementProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The affinity setting for the instance on the Dedicated Host.
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-affinity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-affinity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAffinity() {
            return null;
        }

        /**
         * The Availability Zone of the instance.
         * <p>
         * If not specified, an Availability Zone will be automatically chosen for you based on the load balancing criteria for the Region.
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-availabilityzone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * The name of the placement group that the instance is in.
         * <p>
         * If you specify <code>GroupName</code> , you can't specify <code>GroupId</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-groupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-groupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
            return null;
        }

        /**
         * The ID of the Dedicated Host on which the instance resides.
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-hostid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-hostid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostId() {
            return null;
        }

        /**
         * The ARN of the host resource group in which to launch the instances.
         * <p>
         * If you specify this parameter, either omit the <em>Tenancy</em> parameter or set it to <code>host</code> .
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-hostresourcegrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-hostresourcegrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostResourceGroupArn() {
            return null;
        }

        /**
         * The number of the partition that the instance is in.
         * <p>
         * Valid only if the placement group strategy is set to <code>partition</code> .
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-partitionnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-partitionnumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPartitionNumber() {
            return null;
        }

        /**
         * Reserved for future use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-spreaddomain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-spreaddomain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpreadDomain() {
            return null;
        }

        /**
         * The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware.
         * <p>
         * This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> . The <code>host</code> tenancy is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> or for T3 instances that are configured for the <code>unlimited</code> CPU credit option.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-tenancy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-placement.html#cfn-ec2-ec2fleet-placement-tenancy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementProperty> {
            java.lang.String affinity;
            java.lang.String availabilityZone;
            java.lang.String groupName;
            java.lang.String hostId;
            java.lang.String hostResourceGroupArn;
            java.lang.Number partitionNumber;
            java.lang.String spreadDomain;
            java.lang.String tenancy;

            /**
             * Sets the value of {@link PlacementProperty#getAffinity}
             * @param affinity The affinity setting for the instance on the Dedicated Host.
             *                 This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder affinity(java.lang.String affinity) {
                this.affinity = affinity;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getAvailabilityZone}
             * @param availabilityZone The Availability Zone of the instance.
             *                         If not specified, an Availability Zone will be automatically chosen for you based on the load balancing criteria for the Region.
             *                         <p>
             *                         This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getGroupName}
             * @param groupName The name of the placement group that the instance is in.
             *                  If you specify <code>GroupName</code> , you can't specify <code>GroupId</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupName(java.lang.String groupName) {
                this.groupName = groupName;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getHostId}
             * @param hostId The ID of the Dedicated Host on which the instance resides.
             *               This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostId(java.lang.String hostId) {
                this.hostId = hostId;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getHostResourceGroupArn}
             * @param hostResourceGroupArn The ARN of the host resource group in which to launch the instances.
             *                             If you specify this parameter, either omit the <em>Tenancy</em> parameter or set it to <code>host</code> .
             *                             <p>
             *                             This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostResourceGroupArn(java.lang.String hostResourceGroupArn) {
                this.hostResourceGroupArn = hostResourceGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getPartitionNumber}
             * @param partitionNumber The number of the partition that the instance is in.
             *                        Valid only if the placement group strategy is set to <code>partition</code> .
             *                        <p>
             *                        This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionNumber(java.lang.Number partitionNumber) {
                this.partitionNumber = partitionNumber;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getSpreadDomain}
             * @param spreadDomain Reserved for future use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spreadDomain(java.lang.String spreadDomain) {
                this.spreadDomain = spreadDomain;
                return this;
            }

            /**
             * Sets the value of {@link PlacementProperty#getTenancy}
             * @param tenancy The tenancy of the instance. An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware.
             *                This parameter is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a> . The <code>host</code> tenancy is not supported for <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> or for T3 instances that are configured for the <code>unlimited</code> CPU credit option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tenancy(java.lang.String tenancy) {
                this.tenancy = tenancy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementProperty {
            private final java.lang.String affinity;
            private final java.lang.String availabilityZone;
            private final java.lang.String groupName;
            private final java.lang.String hostId;
            private final java.lang.String hostResourceGroupArn;
            private final java.lang.Number partitionNumber;
            private final java.lang.String spreadDomain;
            private final java.lang.String tenancy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.affinity = software.amazon.jsii.Kernel.get(this, "affinity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostId = software.amazon.jsii.Kernel.get(this, "hostId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostResourceGroupArn = software.amazon.jsii.Kernel.get(this, "hostResourceGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.partitionNumber = software.amazon.jsii.Kernel.get(this, "partitionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.spreadDomain = software.amazon.jsii.Kernel.get(this, "spreadDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tenancy = software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.affinity = builder.affinity;
                this.availabilityZone = builder.availabilityZone;
                this.groupName = builder.groupName;
                this.hostId = builder.hostId;
                this.hostResourceGroupArn = builder.hostResourceGroupArn;
                this.partitionNumber = builder.partitionNumber;
                this.spreadDomain = builder.spreadDomain;
                this.tenancy = builder.tenancy;
            }

            @Override
            public final java.lang.String getAffinity() {
                return this.affinity;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.String getGroupName() {
                return this.groupName;
            }

            @Override
            public final java.lang.String getHostId() {
                return this.hostId;
            }

            @Override
            public final java.lang.String getHostResourceGroupArn() {
                return this.hostResourceGroupArn;
            }

            @Override
            public final java.lang.Number getPartitionNumber() {
                return this.partitionNumber;
            }

            @Override
            public final java.lang.String getSpreadDomain() {
                return this.spreadDomain;
            }

            @Override
            public final java.lang.String getTenancy() {
                return this.tenancy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAffinity() != null) {
                    data.set("affinity", om.valueToTree(this.getAffinity()));
                }
                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getGroupName() != null) {
                    data.set("groupName", om.valueToTree(this.getGroupName()));
                }
                if (this.getHostId() != null) {
                    data.set("hostId", om.valueToTree(this.getHostId()));
                }
                if (this.getHostResourceGroupArn() != null) {
                    data.set("hostResourceGroupArn", om.valueToTree(this.getHostResourceGroupArn()));
                }
                if (this.getPartitionNumber() != null) {
                    data.set("partitionNumber", om.valueToTree(this.getPartitionNumber()));
                }
                if (this.getSpreadDomain() != null) {
                    data.set("spreadDomain", om.valueToTree(this.getSpreadDomain()));
                }
                if (this.getTenancy() != null) {
                    data.set("tenancy", om.valueToTree(this.getTenancy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.PlacementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementProperty.Jsii$Proxy that = (PlacementProperty.Jsii$Proxy) o;

                if (this.affinity != null ? !this.affinity.equals(that.affinity) : that.affinity != null) return false;
                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
                if (this.hostId != null ? !this.hostId.equals(that.hostId) : that.hostId != null) return false;
                if (this.hostResourceGroupArn != null ? !this.hostResourceGroupArn.equals(that.hostResourceGroupArn) : that.hostResourceGroupArn != null) return false;
                if (this.partitionNumber != null ? !this.partitionNumber.equals(that.partitionNumber) : that.partitionNumber != null) return false;
                if (this.spreadDomain != null ? !this.spreadDomain.equals(that.spreadDomain) : that.spreadDomain != null) return false;
                return this.tenancy != null ? this.tenancy.equals(that.tenancy) : that.tenancy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.affinity != null ? this.affinity.hashCode() : 0;
                result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
                result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
                result = 31 * result + (this.hostId != null ? this.hostId.hashCode() : 0);
                result = 31 * result + (this.hostResourceGroupArn != null ? this.hostResourceGroupArn.hashCode() : 0);
                result = 31 * result + (this.partitionNumber != null ? this.partitionNumber.hashCode() : 0);
                result = 31 * result + (this.spreadDomain != null ? this.spreadDomain.hashCode() : 0);
                result = 31 * result + (this.tenancy != null ? this.tenancy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of Spot Instances for an EC2 Fleet.
     * <p>
     * <code>SpotOptionsRequest</code> is a property of the <a href="https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html">AWS::EC2::EC2Fleet</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * SpotOptionsRequestProperty spotOptionsRequestProperty = SpotOptionsRequestProperty.builder()
     *         .allocationStrategy("allocationStrategy")
     *         .instanceInterruptionBehavior("instanceInterruptionBehavior")
     *         .instancePoolsToUseCount(123)
     *         .maintenanceStrategies(MaintenanceStrategiesProperty.builder()
     *                 .capacityRebalance(CapacityRebalanceProperty.builder()
     *                         .replacementStrategy("replacementStrategy")
     *                         .terminationDelay(123)
     *                         .build())
     *                 .build())
     *         .maxTotalPrice("maxTotalPrice")
     *         .minTargetCapacity(123)
     *         .singleAvailabilityZone(false)
     *         .singleInstanceType(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.SpotOptionsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotOptionsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotOptionsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by the EC2 Fleet.
         * <p>
         * If the allocation strategy is <code>lowestPrice</code> , EC2 Fleet launches instances from the Spot Instance pools with the lowest price. This is the default allocation strategy.
         * <p>
         * If the allocation strategy is <code>diversified</code> , EC2 Fleet launches instances from all the Spot Instance pools that you specify.
         * <p>
         * If the allocation strategy is <code>capacityOptimized</code> , EC2 Fleet launches instances from Spot Instance pools that are optimally chosen based on the available Spot Instance capacity.
         * <p>
         * <em>Allowed Values</em> : <code>lowestPrice</code> | <code>diversified</code> | <code>capacityOptimized</code> | <code>capacityOptimizedPrioritized</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-allocationstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-allocationstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
            return null;
        }

        /**
         * The behavior when a Spot Instance is interrupted.
         * <p>
         * Default: <code>terminate</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instanceinterruptionbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instanceinterruptionbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceInterruptionBehavior() {
            return null;
        }

        /**
         * The number of Spot pools across which to allocate your target Spot capacity.
         * <p>
         * Supported only when Spot <code>AllocationStrategy</code> is set to <code>lowest-price</code> . EC2 Fleet selects the cheapest Spot pools and evenly allocates your target Spot capacity across the number of Spot pools that you specify.
         * <p>
         * Note that EC2 Fleet attempts to draw Spot Instances from the number of pools that you specify on a best effort basis. If a pool runs out of Spot capacity before fulfilling your target capacity, EC2 Fleet will continue to fulfill your request by drawing from the next cheapest pool. To ensure that your target capacity is met, you might receive Spot Instances from more than the number of pools that you specified. Similarly, if most of the pools have no Spot capacity, you might receive your full target capacity from fewer than the number of pools that you specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instancepoolstousecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instancepoolstousecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInstancePoolsToUseCount() {
            return null;
        }

        /**
         * The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-maintenancestrategies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-maintenancestrategies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceStrategies() {
            return null;
        }

        /**
         * The maximum amount per hour for Spot Instances that you're willing to pay.
         * <p>
         * We do not recommend using this parameter because it can lead to increased interruptions. If you do not specify this parameter, you will pay the current Spot price.
         * <p>
         * <blockquote>
         * <p>
         * If you specify a maximum price, your Spot Instances will be interrupted more frequently than if you do not specify this parameter. &gt; If your fleet includes T instances that are configured as <code>unlimited</code> , and if their average CPU usage exceeds the baseline utilization, you will incur a charge for surplus credits. The <code>MaxTotalPrice</code> does not account for surplus credits, and, if you use surplus credits, your final cost might be higher than what you specified for <code>MaxTotalPrice</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-unlimited-mode-concepts.html#unlimited-mode-surplus-credits">Surplus credits can incur charges</a> in the <em>EC2 User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-maxtotalprice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-maxtotalprice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxTotalPrice() {
            return null;
        }

        /**
         * The minimum target capacity for Spot Instances in the fleet.
         * <p>
         * If the minimum target capacity is not reached, the fleet launches no instances.
         * <p>
         * Supported only for fleets of type <code>instant</code> .
         * <p>
         * At least one of the following must be specified: <code>SingleAvailabilityZone</code> | <code>SingleInstanceType</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-mintargetcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-mintargetcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinTargetCapacity() {
            return null;
        }

        /**
         * Indicates that the fleet launches all Spot Instances into a single Availability Zone.
         * <p>
         * Supported only for fleets of type <code>instant</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-singleavailabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-singleavailabilityzone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleAvailabilityZone() {
            return null;
        }

        /**
         * Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.
         * <p>
         * Supported only for fleets of type <code>instant</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-singleinstancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-singleinstancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleInstanceType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotOptionsRequestProperty> {
            java.lang.String allocationStrategy;
            java.lang.String instanceInterruptionBehavior;
            java.lang.Number instancePoolsToUseCount;
            java.lang.Object maintenanceStrategies;
            java.lang.String maxTotalPrice;
            java.lang.Number minTargetCapacity;
            java.lang.Object singleAvailabilityZone;
            java.lang.Object singleInstanceType;

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getAllocationStrategy}
             * @param allocationStrategy Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by the EC2 Fleet.
             *                           If the allocation strategy is <code>lowestPrice</code> , EC2 Fleet launches instances from the Spot Instance pools with the lowest price. This is the default allocation strategy.
             *                           <p>
             *                           If the allocation strategy is <code>diversified</code> , EC2 Fleet launches instances from all the Spot Instance pools that you specify.
             *                           <p>
             *                           If the allocation strategy is <code>capacityOptimized</code> , EC2 Fleet launches instances from Spot Instance pools that are optimally chosen based on the available Spot Instance capacity.
             *                           <p>
             *                           <em>Allowed Values</em> : <code>lowestPrice</code> | <code>diversified</code> | <code>capacityOptimized</code> | <code>capacityOptimizedPrioritized</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getInstanceInterruptionBehavior}
             * @param instanceInterruptionBehavior The behavior when a Spot Instance is interrupted.
             *                                     Default: <code>terminate</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceInterruptionBehavior(java.lang.String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getInstancePoolsToUseCount}
             * @param instancePoolsToUseCount The number of Spot pools across which to allocate your target Spot capacity.
             *                                Supported only when Spot <code>AllocationStrategy</code> is set to <code>lowest-price</code> . EC2 Fleet selects the cheapest Spot pools and evenly allocates your target Spot capacity across the number of Spot pools that you specify.
             *                                <p>
             *                                Note that EC2 Fleet attempts to draw Spot Instances from the number of pools that you specify on a best effort basis. If a pool runs out of Spot capacity before fulfilling your target capacity, EC2 Fleet will continue to fulfill your request by drawing from the next cheapest pool. To ensure that your target capacity is met, you might receive Spot Instances from more than the number of pools that you specified. Similarly, if most of the pools have no Spot capacity, you might receive your full target capacity from fewer than the number of pools that you specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instancePoolsToUseCount(java.lang.Number instancePoolsToUseCount) {
                this.instancePoolsToUseCount = instancePoolsToUseCount;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getMaintenanceStrategies}
             * @param maintenanceStrategies The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceStrategies(software.amazon.awscdk.IResolvable maintenanceStrategies) {
                this.maintenanceStrategies = maintenanceStrategies;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getMaintenanceStrategies}
             * @param maintenanceStrategies The strategies for managing your Spot Instances that are at an elevated risk of being interrupted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceStrategies(software.amazon.awscdk.services.ec2.CfnEC2Fleet.MaintenanceStrategiesProperty maintenanceStrategies) {
                this.maintenanceStrategies = maintenanceStrategies;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getMaxTotalPrice}
             * @param maxTotalPrice The maximum amount per hour for Spot Instances that you're willing to pay.
             *                      We do not recommend using this parameter because it can lead to increased interruptions. If you do not specify this parameter, you will pay the current Spot price.
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      If you specify a maximum price, your Spot Instances will be interrupted more frequently than if you do not specify this parameter. &gt; If your fleet includes T instances that are configured as <code>unlimited</code> , and if their average CPU usage exceeds the baseline utilization, you will incur a charge for surplus credits. The <code>MaxTotalPrice</code> does not account for surplus credits, and, if you use surplus credits, your final cost might be higher than what you specified for <code>MaxTotalPrice</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances-unlimited-mode-concepts.html#unlimited-mode-surplus-credits">Surplus credits can incur charges</a> in the <em>EC2 User Guide</em> .
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTotalPrice(java.lang.String maxTotalPrice) {
                this.maxTotalPrice = maxTotalPrice;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getMinTargetCapacity}
             * @param minTargetCapacity The minimum target capacity for Spot Instances in the fleet.
             *                          If the minimum target capacity is not reached, the fleet launches no instances.
             *                          <p>
             *                          Supported only for fleets of type <code>instant</code> .
             *                          <p>
             *                          At least one of the following must be specified: <code>SingleAvailabilityZone</code> | <code>SingleInstanceType</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTargetCapacity(java.lang.Number minTargetCapacity) {
                this.minTargetCapacity = minTargetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getSingleAvailabilityZone}
             * @param singleAvailabilityZone Indicates that the fleet launches all Spot Instances into a single Availability Zone.
             *                               Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleAvailabilityZone(java.lang.Boolean singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getSingleAvailabilityZone}
             * @param singleAvailabilityZone Indicates that the fleet launches all Spot Instances into a single Availability Zone.
             *                               Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleAvailabilityZone(software.amazon.awscdk.IResolvable singleAvailabilityZone) {
                this.singleAvailabilityZone = singleAvailabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getSingleInstanceType}
             * @param singleInstanceType Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.
             *                           Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleInstanceType(java.lang.Boolean singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            /**
             * Sets the value of {@link SpotOptionsRequestProperty#getSingleInstanceType}
             * @param singleInstanceType Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.
             *                           Supported only for fleets of type <code>instant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleInstanceType(software.amazon.awscdk.IResolvable singleInstanceType) {
                this.singleInstanceType = singleInstanceType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotOptionsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotOptionsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpotOptionsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotOptionsRequestProperty {
            private final java.lang.String allocationStrategy;
            private final java.lang.String instanceInterruptionBehavior;
            private final java.lang.Number instancePoolsToUseCount;
            private final java.lang.Object maintenanceStrategies;
            private final java.lang.String maxTotalPrice;
            private final java.lang.Number minTargetCapacity;
            private final java.lang.Object singleAvailabilityZone;
            private final java.lang.Object singleInstanceType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceInterruptionBehavior = software.amazon.jsii.Kernel.get(this, "instanceInterruptionBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instancePoolsToUseCount = software.amazon.jsii.Kernel.get(this, "instancePoolsToUseCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maintenanceStrategies = software.amazon.jsii.Kernel.get(this, "maintenanceStrategies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxTotalPrice = software.amazon.jsii.Kernel.get(this, "maxTotalPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minTargetCapacity = software.amazon.jsii.Kernel.get(this, "minTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.singleAvailabilityZone = software.amazon.jsii.Kernel.get(this, "singleAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleInstanceType = software.amazon.jsii.Kernel.get(this, "singleInstanceType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allocationStrategy = builder.allocationStrategy;
                this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
                this.instancePoolsToUseCount = builder.instancePoolsToUseCount;
                this.maintenanceStrategies = builder.maintenanceStrategies;
                this.maxTotalPrice = builder.maxTotalPrice;
                this.minTargetCapacity = builder.minTargetCapacity;
                this.singleAvailabilityZone = builder.singleAvailabilityZone;
                this.singleInstanceType = builder.singleInstanceType;
            }

            @Override
            public final java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public final java.lang.String getInstanceInterruptionBehavior() {
                return this.instanceInterruptionBehavior;
            }

            @Override
            public final java.lang.Number getInstancePoolsToUseCount() {
                return this.instancePoolsToUseCount;
            }

            @Override
            public final java.lang.Object getMaintenanceStrategies() {
                return this.maintenanceStrategies;
            }

            @Override
            public final java.lang.String getMaxTotalPrice() {
                return this.maxTotalPrice;
            }

            @Override
            public final java.lang.Number getMinTargetCapacity() {
                return this.minTargetCapacity;
            }

            @Override
            public final java.lang.Object getSingleAvailabilityZone() {
                return this.singleAvailabilityZone;
            }

            @Override
            public final java.lang.Object getSingleInstanceType() {
                return this.singleInstanceType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllocationStrategy() != null) {
                    data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getInstanceInterruptionBehavior() != null) {
                    data.set("instanceInterruptionBehavior", om.valueToTree(this.getInstanceInterruptionBehavior()));
                }
                if (this.getInstancePoolsToUseCount() != null) {
                    data.set("instancePoolsToUseCount", om.valueToTree(this.getInstancePoolsToUseCount()));
                }
                if (this.getMaintenanceStrategies() != null) {
                    data.set("maintenanceStrategies", om.valueToTree(this.getMaintenanceStrategies()));
                }
                if (this.getMaxTotalPrice() != null) {
                    data.set("maxTotalPrice", om.valueToTree(this.getMaxTotalPrice()));
                }
                if (this.getMinTargetCapacity() != null) {
                    data.set("minTargetCapacity", om.valueToTree(this.getMinTargetCapacity()));
                }
                if (this.getSingleAvailabilityZone() != null) {
                    data.set("singleAvailabilityZone", om.valueToTree(this.getSingleAvailabilityZone()));
                }
                if (this.getSingleInstanceType() != null) {
                    data.set("singleInstanceType", om.valueToTree(this.getSingleInstanceType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.SpotOptionsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotOptionsRequestProperty.Jsii$Proxy that = (SpotOptionsRequestProperty.Jsii$Proxy) o;

                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                if (this.instanceInterruptionBehavior != null ? !this.instanceInterruptionBehavior.equals(that.instanceInterruptionBehavior) : that.instanceInterruptionBehavior != null) return false;
                if (this.instancePoolsToUseCount != null ? !this.instancePoolsToUseCount.equals(that.instancePoolsToUseCount) : that.instancePoolsToUseCount != null) return false;
                if (this.maintenanceStrategies != null ? !this.maintenanceStrategies.equals(that.maintenanceStrategies) : that.maintenanceStrategies != null) return false;
                if (this.maxTotalPrice != null ? !this.maxTotalPrice.equals(that.maxTotalPrice) : that.maxTotalPrice != null) return false;
                if (this.minTargetCapacity != null ? !this.minTargetCapacity.equals(that.minTargetCapacity) : that.minTargetCapacity != null) return false;
                if (this.singleAvailabilityZone != null ? !this.singleAvailabilityZone.equals(that.singleAvailabilityZone) : that.singleAvailabilityZone != null) return false;
                return this.singleInstanceType != null ? this.singleInstanceType.equals(that.singleInstanceType) : that.singleInstanceType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0;
                result = 31 * result + (this.instanceInterruptionBehavior != null ? this.instanceInterruptionBehavior.hashCode() : 0);
                result = 31 * result + (this.instancePoolsToUseCount != null ? this.instancePoolsToUseCount.hashCode() : 0);
                result = 31 * result + (this.maintenanceStrategies != null ? this.maintenanceStrategies.hashCode() : 0);
                result = 31 * result + (this.maxTotalPrice != null ? this.maxTotalPrice.hashCode() : 0);
                result = 31 * result + (this.minTargetCapacity != null ? this.minTargetCapacity.hashCode() : 0);
                result = 31 * result + (this.singleAvailabilityZone != null ? this.singleAvailabilityZone.hashCode() : 0);
                result = 31 * result + (this.singleInstanceType != null ? this.singleInstanceType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the tags to apply to a resource when the resource is being created for an EC2 Fleet.
     * <p>
     * <code>TagSpecification</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html">AWS::EC2::EC2Fleet</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TagSpecificationProperty tagSpecificationProperty = TagSpecificationProperty.builder()
     *         .resourceType("resourceType")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.TagSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(TagSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of resource to tag.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-resourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-resourcetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
            return null;
        }

        /**
         * The tags to apply to the resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-tags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagSpecificationProperty> {
            java.lang.String resourceType;
            java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Sets the value of {@link TagSpecificationProperty#getResourceType}
             * @param resourceType The type of resource to tag.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link TagSpecificationProperty#getTags}
             * @param tags The tags to apply to the resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = builder.resourceType;
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.TagSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagSpecificationProperty.Jsii$Proxy that = (TagSpecificationProperty.Jsii$Proxy) o;

                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the number of units to request for an EC2 Fleet.
     * <p>
     * You can choose to set the target capacity in terms of instances or a performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If the request type is <code>maintain</code> , you can specify a target capacity of <code>0</code> and add capacity later.
     * <p>
     * <code>TargetCapacitySpecificationRequest</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html">AWS::EC2::EC2Fleet</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TargetCapacitySpecificationRequestProperty targetCapacitySpecificationRequestProperty = TargetCapacitySpecificationRequestProperty.builder()
     *         .totalTargetCapacity(123)
     *         // the properties below are optional
     *         .defaultTargetCapacityType("defaultTargetCapacityType")
     *         .onDemandTargetCapacity(123)
     *         .spotTargetCapacity(123)
     *         .targetCapacityUnitType("targetCapacityUnitType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetCapacitySpecificationRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetCapacitySpecificationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of units to request, filled using the default target capacity type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-totaltargetcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-totaltargetcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTotalTargetCapacity();

        /**
         * The default target capacity type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-defaulttargetcapacitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-defaulttargetcapacitytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultTargetCapacityType() {
            return null;
        }

        /**
         * The number of On-Demand units to request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-ondemandtargetcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-ondemandtargetcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOnDemandTargetCapacity() {
            return null;
        }

        /**
         * The number of Spot units to request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-spottargetcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-spottargetcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSpotTargetCapacity() {
            return null;
        }

        /**
         * The unit for the target capacity. You can specify this parameter only when using attributed-based instance type selection.
         * <p>
         * Default: <code>units</code> (the number of instances)
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-targetcapacityunittype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-targetcapacityunittype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetCapacityUnitType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetCapacitySpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetCapacitySpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetCapacitySpecificationRequestProperty> {
            java.lang.Number totalTargetCapacity;
            java.lang.String defaultTargetCapacityType;
            java.lang.Number onDemandTargetCapacity;
            java.lang.Number spotTargetCapacity;
            java.lang.String targetCapacityUnitType;

            /**
             * Sets the value of {@link TargetCapacitySpecificationRequestProperty#getTotalTargetCapacity}
             * @param totalTargetCapacity The number of units to request, filled using the default target capacity type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalTargetCapacity(java.lang.Number totalTargetCapacity) {
                this.totalTargetCapacity = totalTargetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link TargetCapacitySpecificationRequestProperty#getDefaultTargetCapacityType}
             * @param defaultTargetCapacityType The default target capacity type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultTargetCapacityType(java.lang.String defaultTargetCapacityType) {
                this.defaultTargetCapacityType = defaultTargetCapacityType;
                return this;
            }

            /**
             * Sets the value of {@link TargetCapacitySpecificationRequestProperty#getOnDemandTargetCapacity}
             * @param onDemandTargetCapacity The number of On-Demand units to request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandTargetCapacity(java.lang.Number onDemandTargetCapacity) {
                this.onDemandTargetCapacity = onDemandTargetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link TargetCapacitySpecificationRequestProperty#getSpotTargetCapacity}
             * @param spotTargetCapacity The number of Spot units to request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotTargetCapacity(java.lang.Number spotTargetCapacity) {
                this.spotTargetCapacity = spotTargetCapacity;
                return this;
            }

            /**
             * Sets the value of {@link TargetCapacitySpecificationRequestProperty#getTargetCapacityUnitType}
             * @param targetCapacityUnitType The unit for the target capacity. You can specify this parameter only when using attributed-based instance type selection.
             *                               Default: <code>units</code> (the number of instances)
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetCapacityUnitType(java.lang.String targetCapacityUnitType) {
                this.targetCapacityUnitType = targetCapacityUnitType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetCapacitySpecificationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetCapacitySpecificationRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetCapacitySpecificationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetCapacitySpecificationRequestProperty {
            private final java.lang.Number totalTargetCapacity;
            private final java.lang.String defaultTargetCapacityType;
            private final java.lang.Number onDemandTargetCapacity;
            private final java.lang.Number spotTargetCapacity;
            private final java.lang.String targetCapacityUnitType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.totalTargetCapacity = software.amazon.jsii.Kernel.get(this, "totalTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.defaultTargetCapacityType = software.amazon.jsii.Kernel.get(this, "defaultTargetCapacityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onDemandTargetCapacity = software.amazon.jsii.Kernel.get(this, "onDemandTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.spotTargetCapacity = software.amazon.jsii.Kernel.get(this, "spotTargetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.targetCapacityUnitType = software.amazon.jsii.Kernel.get(this, "targetCapacityUnitType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.totalTargetCapacity = java.util.Objects.requireNonNull(builder.totalTargetCapacity, "totalTargetCapacity is required");
                this.defaultTargetCapacityType = builder.defaultTargetCapacityType;
                this.onDemandTargetCapacity = builder.onDemandTargetCapacity;
                this.spotTargetCapacity = builder.spotTargetCapacity;
                this.targetCapacityUnitType = builder.targetCapacityUnitType;
            }

            @Override
            public final java.lang.Number getTotalTargetCapacity() {
                return this.totalTargetCapacity;
            }

            @Override
            public final java.lang.String getDefaultTargetCapacityType() {
                return this.defaultTargetCapacityType;
            }

            @Override
            public final java.lang.Number getOnDemandTargetCapacity() {
                return this.onDemandTargetCapacity;
            }

            @Override
            public final java.lang.Number getSpotTargetCapacity() {
                return this.spotTargetCapacity;
            }

            @Override
            public final java.lang.String getTargetCapacityUnitType() {
                return this.targetCapacityUnitType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("totalTargetCapacity", om.valueToTree(this.getTotalTargetCapacity()));
                if (this.getDefaultTargetCapacityType() != null) {
                    data.set("defaultTargetCapacityType", om.valueToTree(this.getDefaultTargetCapacityType()));
                }
                if (this.getOnDemandTargetCapacity() != null) {
                    data.set("onDemandTargetCapacity", om.valueToTree(this.getOnDemandTargetCapacity()));
                }
                if (this.getSpotTargetCapacity() != null) {
                    data.set("spotTargetCapacity", om.valueToTree(this.getSpotTargetCapacity()));
                }
                if (this.getTargetCapacityUnitType() != null) {
                    data.set("targetCapacityUnitType", om.valueToTree(this.getTargetCapacityUnitType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetCapacitySpecificationRequestProperty.Jsii$Proxy that = (TargetCapacitySpecificationRequestProperty.Jsii$Proxy) o;

                if (!totalTargetCapacity.equals(that.totalTargetCapacity)) return false;
                if (this.defaultTargetCapacityType != null ? !this.defaultTargetCapacityType.equals(that.defaultTargetCapacityType) : that.defaultTargetCapacityType != null) return false;
                if (this.onDemandTargetCapacity != null ? !this.onDemandTargetCapacity.equals(that.onDemandTargetCapacity) : that.onDemandTargetCapacity != null) return false;
                if (this.spotTargetCapacity != null ? !this.spotTargetCapacity.equals(that.spotTargetCapacity) : that.spotTargetCapacity != null) return false;
                return this.targetCapacityUnitType != null ? this.targetCapacityUnitType.equals(that.targetCapacityUnitType) : that.targetCapacityUnitType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.totalTargetCapacity.hashCode();
                result = 31 * result + (this.defaultTargetCapacityType != null ? this.defaultTargetCapacityType.hashCode() : 0);
                result = 31 * result + (this.onDemandTargetCapacity != null ? this.onDemandTargetCapacity.hashCode() : 0);
                result = 31 * result + (this.spotTargetCapacity != null ? this.spotTargetCapacity.hashCode() : 0);
                result = 31 * result + (this.targetCapacityUnitType != null ? this.targetCapacityUnitType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of total local storage, in GB.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TotalLocalStorageGBRequestProperty totalLocalStorageGBRequestProperty = TotalLocalStorageGBRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-totallocalstoragegbrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-totallocalstoragegbrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.TotalLocalStorageGBRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(TotalLocalStorageGBRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TotalLocalStorageGBRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of total local storage, in GB.
         * <p>
         * To specify no maximum limit, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-totallocalstoragegbrequest.html#cfn-ec2-ec2fleet-totallocalstoragegbrequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-totallocalstoragegbrequest.html#cfn-ec2-ec2fleet-totallocalstoragegbrequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of total local storage, in GB.
         * <p>
         * To specify no minimum limit, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-totallocalstoragegbrequest.html#cfn-ec2-ec2fleet-totallocalstoragegbrequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-totallocalstoragegbrequest.html#cfn-ec2-ec2fleet-totallocalstoragegbrequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TotalLocalStorageGBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TotalLocalStorageGBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TotalLocalStorageGBRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link TotalLocalStorageGBRequestProperty#getMax}
             * @param max The maximum amount of total local storage, in GB.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link TotalLocalStorageGBRequestProperty#getMin}
             * @param min The minimum amount of total local storage, in GB.
             *            To specify no minimum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TotalLocalStorageGBRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TotalLocalStorageGBRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TotalLocalStorageGBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TotalLocalStorageGBRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.TotalLocalStorageGBRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TotalLocalStorageGBRequestProperty.Jsii$Proxy that = (TotalLocalStorageGBRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum number of vCPUs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * VCpuCountRangeRequestProperty vCpuCountRangeRequestProperty = VCpuCountRangeRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-vcpucountrangerequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-vcpucountrangerequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEC2Fleet.VCpuCountRangeRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(VCpuCountRangeRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VCpuCountRangeRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of vCPUs.
         * <p>
         * To specify no maximum limit, omit this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-vcpucountrangerequest.html#cfn-ec2-ec2fleet-vcpucountrangerequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-vcpucountrangerequest.html#cfn-ec2-ec2fleet-vcpucountrangerequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum number of vCPUs.
         * <p>
         * To specify no minimum limit, specify <code>0</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-vcpucountrangerequest.html#cfn-ec2-ec2fleet-vcpucountrangerequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-vcpucountrangerequest.html#cfn-ec2-ec2fleet-vcpucountrangerequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VCpuCountRangeRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VCpuCountRangeRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VCpuCountRangeRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link VCpuCountRangeRequestProperty#getMax}
             * @param max The maximum number of vCPUs.
             *            To specify no maximum limit, omit this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link VCpuCountRangeRequestProperty#getMin}
             * @param min The minimum number of vCPUs.
             *            To specify no minimum limit, specify <code>0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VCpuCountRangeRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VCpuCountRangeRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VCpuCountRangeRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VCpuCountRangeRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEC2Fleet.VCpuCountRangeRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VCpuCountRangeRequestProperty.Jsii$Proxy that = (VCpuCountRangeRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnEC2Fleet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnEC2Fleet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnEC2FleetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnEC2FleetProps.Builder();
        }

        /**
         * The configuration for the EC2 Fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs</a>
         * @param launchTemplateConfigs The configuration for the EC2 Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateConfigs(final software.amazon.awscdk.IResolvable launchTemplateConfigs) {
            this.props.launchTemplateConfigs(launchTemplateConfigs);
            return this;
        }
        /**
         * The configuration for the EC2 Fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs</a>
         * @param launchTemplateConfigs The configuration for the EC2 Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateConfigs(final java.util.List<? extends java.lang.Object> launchTemplateConfigs) {
            this.props.launchTemplateConfigs(launchTemplateConfigs);
            return this;
        }

        /**
         * The number of units to request.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification</a>
         * @param targetCapacitySpecification The number of units to request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetCapacitySpecification(final software.amazon.awscdk.IResolvable targetCapacitySpecification) {
            this.props.targetCapacitySpecification(targetCapacitySpecification);
            return this;
        }
        /**
         * The number of units to request.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification</a>
         * @param targetCapacitySpecification The number of units to request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetCapacitySpecification(final software.amazon.awscdk.services.ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty targetCapacitySpecification) {
            this.props.targetCapacitySpecification(targetCapacitySpecification);
            return this;
        }

        /**
         * Reserved.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-context">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-context</a>
         * @param context Reserved. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder context(final java.lang.String context) {
            this.props.context(context);
            return this;
        }

        /**
         * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.
         * <p>
         * Supported only for fleets of type <code>maintain</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-excesscapacityterminationpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-excesscapacityterminationpolicy</a>
         * @param excessCapacityTerminationPolicy Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excessCapacityTerminationPolicy(final java.lang.String excessCapacityTerminationPolicy) {
            this.props.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy);
            return this;
        }

        /**
         * Describes the configuration of On-Demand Instances in an EC2 Fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions</a>
         * @param onDemandOptions Describes the configuration of On-Demand Instances in an EC2 Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDemandOptions(final software.amazon.awscdk.IResolvable onDemandOptions) {
            this.props.onDemandOptions(onDemandOptions);
            return this;
        }
        /**
         * Describes the configuration of On-Demand Instances in an EC2 Fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions</a>
         * @param onDemandOptions Describes the configuration of On-Demand Instances in an EC2 Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDemandOptions(final software.amazon.awscdk.services.ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty onDemandOptions) {
            this.props.onDemandOptions(onDemandOptions);
            return this;
        }

        /**
         * Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
         * <p>
         * Supported only for fleets of type <code>maintain</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances</a>
         * @param replaceUnhealthyInstances Indicates whether EC2 Fleet should replace unhealthy Spot Instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceUnhealthyInstances(final java.lang.Boolean replaceUnhealthyInstances) {
            this.props.replaceUnhealthyInstances(replaceUnhealthyInstances);
            return this;
        }
        /**
         * Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
         * <p>
         * Supported only for fleets of type <code>maintain</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances</a>
         * @param replaceUnhealthyInstances Indicates whether EC2 Fleet should replace unhealthy Spot Instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceUnhealthyInstances(final software.amazon.awscdk.IResolvable replaceUnhealthyInstances) {
            this.props.replaceUnhealthyInstances(replaceUnhealthyInstances);
            return this;
        }

        /**
         * Describes the configuration of Spot Instances in an EC2 Fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions</a>
         * @param spotOptions Describes the configuration of Spot Instances in an EC2 Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotOptions(final software.amazon.awscdk.IResolvable spotOptions) {
            this.props.spotOptions(spotOptions);
            return this;
        }
        /**
         * Describes the configuration of Spot Instances in an EC2 Fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions</a>
         * @param spotOptions Describes the configuration of Spot Instances in an EC2 Fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotOptions(final software.amazon.awscdk.services.ec2.CfnEC2Fleet.SpotOptionsRequestProperty spotOptions) {
            this.props.spotOptions(spotOptions);
            return this;
        }

        /**
         * The key-value pair for tagging the EC2 Fleet request on creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tag your resources</a> .
         * <p>
         * If the fleet type is <code>instant</code> , specify a resource type of <code>fleet</code> to tag the fleet or <code>instance</code> to tag the instances at launch.
         * <p>
         * If the fleet type is <code>maintain</code> or <code>request</code> , specify a resource type of <code>fleet</code> to tag the fleet. You cannot specify a resource type of <code>instance</code> . To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications</a>
         * @param tagSpecifications The key-value pair for tagging the EC2 Fleet request on creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tag your resources</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final software.amazon.awscdk.IResolvable tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }
        /**
         * The key-value pair for tagging the EC2 Fleet request on creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tag your resources</a> .
         * <p>
         * If the fleet type is <code>instant</code> , specify a resource type of <code>fleet</code> to tag the fleet or <code>instance</code> to tag the instances at launch.
         * <p>
         * If the fleet type is <code>maintain</code> or <code>request</code> , specify a resource type of <code>fleet</code> to tag the fleet. You cannot specify a resource type of <code>instance</code> . To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications</a>
         * @param tagSpecifications The key-value pair for tagging the EC2 Fleet request on creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tag your resources</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(final java.util.List<? extends java.lang.Object> tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }

        /**
         * Indicates whether running instances should be terminated when the EC2 Fleet expires.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration</a>
         * @param terminateInstancesWithExpiration Indicates whether running instances should be terminated when the EC2 Fleet expires. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateInstancesWithExpiration(final java.lang.Boolean terminateInstancesWithExpiration) {
            this.props.terminateInstancesWithExpiration(terminateInstancesWithExpiration);
            return this;
        }
        /**
         * Indicates whether running instances should be terminated when the EC2 Fleet expires.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration</a>
         * @param terminateInstancesWithExpiration Indicates whether running instances should be terminated when the EC2 Fleet expires. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateInstancesWithExpiration(final software.amazon.awscdk.IResolvable terminateInstancesWithExpiration) {
            this.props.terminateInstancesWithExpiration(terminateInstancesWithExpiration);
            return this;
        }

        /**
         * The fleet type. The default value is <code>maintain</code> .
         * <p>
         * <ul>
         * <li><code>maintain</code> - The EC2 Fleet places an asynchronous request for your desired capacity, and continues to maintain your desired Spot capacity by replenishing interrupted Spot Instances.</li>
         * <li><code>request</code> - The EC2 Fleet places an asynchronous one-time request for your desired capacity, but does submit Spot requests in alternative capacity pools if Spot capacity is unavailable, and does not maintain Spot capacity if Spot Instances are interrupted.</li>
         * <li><code>instant</code> - The EC2 Fleet places a synchronous one-time request for your desired capacity, and returns errors for any instances that could not be launched.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-request-type.html">EC2 Fleet request types</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-type</a>
         * @param type The fleet type. The default value is <code>maintain</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * The start date and time of the request, in UTC format (for example, <em>YYYY</em> - <em>MM</em> - <em>DD</em> T <em>HH</em> : <em>MM</em> : <em>SS</em> Z).
         * <p>
         * The default is to start fulfilling the request immediately.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validfrom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validfrom</a>
         * @param validFrom The start date and time of the request, in UTC format (for example, <em>YYYY</em> - <em>MM</em> - <em>DD</em> T <em>HH</em> : <em>MM</em> : <em>SS</em> Z). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validFrom(final java.lang.String validFrom) {
            this.props.validFrom(validFrom);
            return this;
        }

        /**
         * The end date and time of the request, in UTC format (for example, <em>YYYY</em> - <em>MM</em> - <em>DD</em> T <em>HH</em> : <em>MM</em> : <em>SS</em> Z).
         * <p>
         * At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validuntil">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validuntil</a>
         * @param validUntil The end date and time of the request, in UTC format (for example, <em>YYYY</em> - <em>MM</em> - <em>DD</em> T <em>HH</em> : <em>MM</em> : <em>SS</em> Z). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validUntil(final java.lang.String validUntil) {
            this.props.validUntil(validUntil);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnEC2Fleet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnEC2Fleet build() {
            return new software.amazon.awscdk.services.ec2.CfnEC2Fleet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
