package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnVerifiedAccessTrustProvider</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVerifiedAccessTrustProviderProps cfnVerifiedAccessTrustProviderProps = CfnVerifiedAccessTrustProviderProps.builder()
 *         .policyReferenceName("policyReferenceName")
 *         .trustProviderType("trustProviderType")
 *         // the properties below are optional
 *         .description("description")
 *         .deviceOptions(DeviceOptionsProperty.builder()
 *                 .publicSigningKeyUrl("publicSigningKeyUrl")
 *                 .tenantId("tenantId")
 *                 .build())
 *         .deviceTrustProviderType("deviceTrustProviderType")
 *         .oidcOptions(OidcOptionsProperty.builder()
 *                 .authorizationEndpoint("authorizationEndpoint")
 *                 .clientId("clientId")
 *                 .clientSecret("clientSecret")
 *                 .issuer("issuer")
 *                 .scope("scope")
 *                 .tokenEndpoint("tokenEndpoint")
 *                 .userInfoEndpoint("userInfoEndpoint")
 *                 .build())
 *         .sseSpecification(SseSpecificationProperty.builder()
 *                 .customerManagedKeyEnabled(false)
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userTrustProviderType("userTrustProviderType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:53.649Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVerifiedAccessTrustProviderProps")
@software.amazon.jsii.Jsii.Proxy(CfnVerifiedAccessTrustProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVerifiedAccessTrustProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier to be used when working with policy rules.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-policyreferencename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-policyreferencename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyReferenceName();

    /**
     * The type of Verified Access trust provider.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-trustprovidertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-trustprovidertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrustProviderType();

    /**
     * A description for the AWS Verified Access trust provider.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The options for device-identity trust provider.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-deviceoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-deviceoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeviceOptions() {
        return null;
    }

    /**
     * The type of device-based trust provider.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-devicetrustprovidertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-devicetrustprovidertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeviceTrustProviderType() {
        return null;
    }

    /**
     * The options for an OpenID Connect-compatible user-identity trust provider.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-oidcoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-oidcoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOidcOptions() {
        return null;
    }

    /**
     * The options for additional server side encryption.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-ssespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-ssespecification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSseSpecification() {
        return null;
    }

    /**
     * The tags.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The type of user-based trust provider.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-usertrustprovidertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccesstrustprovider.html#cfn-ec2-verifiedaccesstrustprovider-usertrustprovidertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserTrustProviderType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVerifiedAccessTrustProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVerifiedAccessTrustProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVerifiedAccessTrustProviderProps> {
        java.lang.String policyReferenceName;
        java.lang.String trustProviderType;
        java.lang.String description;
        java.lang.Object deviceOptions;
        java.lang.String deviceTrustProviderType;
        java.lang.Object oidcOptions;
        java.lang.Object sseSpecification;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String userTrustProviderType;

        /**
         * Sets the value of {@link CfnVerifiedAccessTrustProviderProps#getPolicyReferenceName}
         * @param policyReferenceName The identifier to be used when working with policy rules. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyReferenceName(java.lang.String policyReferenceName) {
            this.policyReferenceName = policyReferenceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessTrustProviderProps#getTrustProviderType}
         * @param trustProviderType The type of Verified Access trust provider. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trustProviderType(java.lang.String trustProviderType) {
            this.trustProviderType = trustProviderType;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessTrustProviderProps#getDescription}
         * @param description A description for the AWS Verified Access trust provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessTrustProviderProps#getDeviceOptions}
         * @param deviceOptions The options for device-identity trust provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceOptions(software.amazon.awscdk.IResolvable deviceOptions) {
            this.deviceOptions = deviceOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessTrustProviderProps#getDeviceOptions}
         * @param deviceOptions The options for device-identity trust provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceOptions(software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProvider.DeviceOptionsProperty deviceOptions) {
            this.deviceOptions = deviceOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessTrustProviderProps#getDeviceTrustProviderType}
         * @param deviceTrustProviderType The type of device-based trust provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceTrustProviderType(java.lang.String deviceTrustProviderType) {
            this.deviceTrustProviderType = deviceTrustProviderType;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessTrustProviderProps#getOidcOptions}
         * @param oidcOptions The options for an OpenID Connect-compatible user-identity trust provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oidcOptions(software.amazon.awscdk.IResolvable oidcOptions) {
            this.oidcOptions = oidcOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessTrustProviderProps#getOidcOptions}
         * @param oidcOptions The options for an OpenID Connect-compatible user-identity trust provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oidcOptions(software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProvider.OidcOptionsProperty oidcOptions) {
            this.oidcOptions = oidcOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessTrustProviderProps#getSseSpecification}
         * @param sseSpecification The options for additional server side encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(software.amazon.awscdk.IResolvable sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessTrustProviderProps#getSseSpecification}
         * @param sseSpecification The options for additional server side encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProvider.SseSpecificationProperty sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessTrustProviderProps#getTags}
         * @param tags The tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessTrustProviderProps#getUserTrustProviderType}
         * @param userTrustProviderType The type of user-based trust provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userTrustProviderType(java.lang.String userTrustProviderType) {
            this.userTrustProviderType = userTrustProviderType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVerifiedAccessTrustProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVerifiedAccessTrustProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVerifiedAccessTrustProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVerifiedAccessTrustProviderProps {
        private final java.lang.String policyReferenceName;
        private final java.lang.String trustProviderType;
        private final java.lang.String description;
        private final java.lang.Object deviceOptions;
        private final java.lang.String deviceTrustProviderType;
        private final java.lang.Object oidcOptions;
        private final java.lang.Object sseSpecification;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String userTrustProviderType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policyReferenceName = software.amazon.jsii.Kernel.get(this, "policyReferenceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.trustProviderType = software.amazon.jsii.Kernel.get(this, "trustProviderType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deviceOptions = software.amazon.jsii.Kernel.get(this, "deviceOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deviceTrustProviderType = software.amazon.jsii.Kernel.get(this, "deviceTrustProviderType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.oidcOptions = software.amazon.jsii.Kernel.get(this, "oidcOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sseSpecification = software.amazon.jsii.Kernel.get(this, "sseSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.userTrustProviderType = software.amazon.jsii.Kernel.get(this, "userTrustProviderType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policyReferenceName = java.util.Objects.requireNonNull(builder.policyReferenceName, "policyReferenceName is required");
            this.trustProviderType = java.util.Objects.requireNonNull(builder.trustProviderType, "trustProviderType is required");
            this.description = builder.description;
            this.deviceOptions = builder.deviceOptions;
            this.deviceTrustProviderType = builder.deviceTrustProviderType;
            this.oidcOptions = builder.oidcOptions;
            this.sseSpecification = builder.sseSpecification;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.userTrustProviderType = builder.userTrustProviderType;
        }

        @Override
        public final java.lang.String getPolicyReferenceName() {
            return this.policyReferenceName;
        }

        @Override
        public final java.lang.String getTrustProviderType() {
            return this.trustProviderType;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getDeviceOptions() {
            return this.deviceOptions;
        }

        @Override
        public final java.lang.String getDeviceTrustProviderType() {
            return this.deviceTrustProviderType;
        }

        @Override
        public final java.lang.Object getOidcOptions() {
            return this.oidcOptions;
        }

        @Override
        public final java.lang.Object getSseSpecification() {
            return this.sseSpecification;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getUserTrustProviderType() {
            return this.userTrustProviderType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("policyReferenceName", om.valueToTree(this.getPolicyReferenceName()));
            data.set("trustProviderType", om.valueToTree(this.getTrustProviderType()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDeviceOptions() != null) {
                data.set("deviceOptions", om.valueToTree(this.getDeviceOptions()));
            }
            if (this.getDeviceTrustProviderType() != null) {
                data.set("deviceTrustProviderType", om.valueToTree(this.getDeviceTrustProviderType()));
            }
            if (this.getOidcOptions() != null) {
                data.set("oidcOptions", om.valueToTree(this.getOidcOptions()));
            }
            if (this.getSseSpecification() != null) {
                data.set("sseSpecification", om.valueToTree(this.getSseSpecification()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUserTrustProviderType() != null) {
                data.set("userTrustProviderType", om.valueToTree(this.getUserTrustProviderType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVerifiedAccessTrustProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVerifiedAccessTrustProviderProps.Jsii$Proxy that = (CfnVerifiedAccessTrustProviderProps.Jsii$Proxy) o;

            if (!policyReferenceName.equals(that.policyReferenceName)) return false;
            if (!trustProviderType.equals(that.trustProviderType)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.deviceOptions != null ? !this.deviceOptions.equals(that.deviceOptions) : that.deviceOptions != null) return false;
            if (this.deviceTrustProviderType != null ? !this.deviceTrustProviderType.equals(that.deviceTrustProviderType) : that.deviceTrustProviderType != null) return false;
            if (this.oidcOptions != null ? !this.oidcOptions.equals(that.oidcOptions) : that.oidcOptions != null) return false;
            if (this.sseSpecification != null ? !this.sseSpecification.equals(that.sseSpecification) : that.sseSpecification != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.userTrustProviderType != null ? this.userTrustProviderType.equals(that.userTrustProviderType) : that.userTrustProviderType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.policyReferenceName.hashCode();
            result = 31 * result + (this.trustProviderType.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.deviceOptions != null ? this.deviceOptions.hashCode() : 0);
            result = 31 * result + (this.deviceTrustProviderType != null ? this.deviceTrustProviderType.hashCode() : 0);
            result = 31 * result + (this.oidcOptions != null ? this.oidcOptions.hashCode() : 0);
            result = 31 * result + (this.sseSpecification != null ? this.sseSpecification.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.userTrustProviderType != null ? this.userTrustProviderType.hashCode() : 0);
            return result;
        }
    }
}
