package software.amazon.awscdk.services.ec2;

/**
 * Direction of traffic to allow all by default.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * InstanceType instanceType;
 * NatInstanceProviderV2 provider = NatProvider.instanceV2(NatInstanceProps.builder()
 *         .instanceType(instanceType)
 *         .defaultAllowedTraffic(NatTrafficDirection.OUTBOUND_ONLY)
 *         .build());
 * Vpc.Builder.create(this, "TheVPC")
 *         .natGatewayProvider(provider)
 *         .build();
 * provider.connections.allowFrom(Peer.ipv4("1.2.3.4/8"), Port.tcp(80));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:53.965Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.NatTrafficDirection")
public enum NatTrafficDirection {
    /**
     * Allow all outbound traffic and disallow all inbound traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OUTBOUND_ONLY,
    /**
     * Allow all outbound and inbound traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INBOUND_AND_OUTBOUND,
    /**
     * Disallow all outbound and inbound traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
}
