package software.amazon.awscdk.services.ecs;

/**
 * Represents the configuration for an ECS Service managed EBS volume.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * FargateTaskDefinition taskDefinition = new FargateTaskDefinition(this, "TaskDef");
 * ContainerDefinition container = taskDefinition.addContainer("web", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .portMappings(List.of(PortMapping.builder()
 *                 .containerPort(80)
 *                 .protocol(Protocol.TCP)
 *                 .build()))
 *         .build());
 * ServiceManagedVolume volume = ServiceManagedVolume.Builder.create(this, "EBSVolume")
 *         .name("ebs1")
 *         .managedEBSVolume(ServiceManagedEBSVolumeConfiguration.builder()
 *                 .size(Size.gibibytes(15))
 *                 .volumeType(EbsDeviceVolumeType.GP3)
 *                 .fileSystemType(FileSystemType.XFS)
 *                 .tagSpecifications(List.of(EBSTagSpecification.builder()
 *                         .tags(Map.of(
 *                                 "purpose", "production"))
 *                         .propagateTags(EbsPropagatedTagSource.SERVICE)
 *                         .build()))
 *                 .build())
 *         .build();
 * volume.mountIn(container, ContainerMountPoint.builder()
 *         .containerPath("/var/lib")
 *         .readOnly(false)
 *         .build());
 * taskDefinition.addVolume(volume);
 * FargateService service = FargateService.Builder.create(this, "FargateService")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .build();
 * service.addVolume(volume);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:54.824Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ServiceManagedEBSVolumeConfiguration")
@software.amazon.jsii.Jsii.Proxy(ServiceManagedEBSVolumeConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServiceManagedEBSVolumeConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether the volume should be encrypted.
     * <p>
     * Default: - Default Amazon EBS encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEncrypted() {
        return null;
    }

    /**
     * The Linux filesystem type for the volume.
     * <p>
     * For volumes created from a snapshot, you must specify the same filesystem type that
     * the volume was using when the snapshot was created.
     * The available filesystem types are ext3, ext4, and xfs.
     * <p>
     * Default: - FileSystemType.XFS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FileSystemType getFileSystemType() {
        return null;
    }

    /**
     * The number of I/O operations per second (IOPS).
     * <p>
     * For gp3, io1, and io2 volumes, this represents the number of IOPS that are provisioned
     * for the volume. For gp2 volumes, this represents the baseline performance of the volume
     * and the rate at which the volume accumulates I/O credits for bursting.
     * <p>
     * The following are the supported values for each volume type.
     * <p>
     * <ul>
     * <li>gp3: 3,000 - 16,000 IOPS</li>
     * <li>io1: 100 - 64,000 IOPS</li>
     * <li>io2: 100 - 256,000 IOPS</li>
     * </ul>
     * <p>
     * This parameter is required for io1 and io2 volume types. The default for gp3 volumes is
     * 3,000 IOPS. This parameter is not supported for st1, sc1, or standard volume types.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
        return null;
    }

    /**
     * AWS Key Management Service key to use for Amazon EBS encryption.
     * <p>
     * Default: - When `encryption` is turned on and no `kmsKey` is specified,
     * the default AWS managed key for Amazon EBS volumes is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKeyId() {
        return null;
    }

    /**
     * An IAM role that allows ECS to make calls to EBS APIs on your behalf.
     * <p>
     * This role is required to create and manage the Amazon EBS volume.
     * <p>
     * Default: - automatically generated role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * The size of the volume in GiB.
     * <p>
     * You must specify either <code>size</code> or <code>snapshotId</code>.
     * You can optionally specify a volume size greater than or equal to the snapshot size.
     * <p>
     * The following are the supported volume size values for each volume type.
     * <p>
     * <ul>
     * <li>gp2 and gp3: 1-16,384</li>
     * <li>io1 and io2: 4-16,384</li>
     * <li>st1 and sc1: 125-16,384</li>
     * <li>standard: 1-1,024</li>
     * </ul>
     * <p>
     * Default: - The snapshot size is used for the volume size if you specify `snapshotId`,
     * otherwise this parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getSize() {
        return null;
    }

    /**
     * The snapshot that Amazon ECS uses to create the volume.
     * <p>
     * You must specify either <code>size</code> or <code>snapshotId</code>.
     * <p>
     * Default: - No snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapShotId() {
        return null;
    }

    /**
     * Specifies the tags to apply to the volume and whether to propagate those tags to the volume.
     * <p>
     * Default: - No tags are specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.EBSTagSpecification> getTagSpecifications() {
        return null;
    }

    /**
     * The throughput to provision for a volume, in MiB/s, with a maximum of 1,000 MiB/s.
     * <p>
     * This parameter is only supported for the gp3 volume type.
     * <p>
     * Default: - No throughput.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getThroughput() {
        return null;
    }

    /**
     * The volume type.
     * <p>
     * Default: - ec2.EbsDeviceVolumeType.GP2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.EbsDeviceVolumeType getVolumeType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ServiceManagedEBSVolumeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServiceManagedEBSVolumeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServiceManagedEBSVolumeConfiguration> {
        java.lang.Boolean encrypted;
        software.amazon.awscdk.services.ecs.FileSystemType fileSystemType;
        java.lang.Number iops;
        software.amazon.awscdk.services.kms.IKey kmsKeyId;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.Size size;
        java.lang.String snapShotId;
        java.util.List<software.amazon.awscdk.services.ecs.EBSTagSpecification> tagSpecifications;
        java.lang.Number throughput;
        software.amazon.awscdk.services.ec2.EbsDeviceVolumeType volumeType;

        /**
         * Sets the value of {@link ServiceManagedEBSVolumeConfiguration#getEncrypted}
         * @param encrypted Indicates whether the volume should be encrypted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(java.lang.Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link ServiceManagedEBSVolumeConfiguration#getFileSystemType}
         * @param fileSystemType The Linux filesystem type for the volume.
         *                       For volumes created from a snapshot, you must specify the same filesystem type that
         *                       the volume was using when the snapshot was created.
         *                       The available filesystem types are ext3, ext4, and xfs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemType(software.amazon.awscdk.services.ecs.FileSystemType fileSystemType) {
            this.fileSystemType = fileSystemType;
            return this;
        }

        /**
         * Sets the value of {@link ServiceManagedEBSVolumeConfiguration#getIops}
         * @param iops The number of I/O operations per second (IOPS).
         *             For gp3, io1, and io2 volumes, this represents the number of IOPS that are provisioned
         *             for the volume. For gp2 volumes, this represents the baseline performance of the volume
         *             and the rate at which the volume accumulates I/O credits for bursting.
         *             <p>
         *             The following are the supported values for each volume type.
         *             <p>
         *             <ul>
         *             <li>gp3: 3,000 - 16,000 IOPS</li>
         *             <li>io1: 100 - 64,000 IOPS</li>
         *             <li>io2: 100 - 256,000 IOPS</li>
         *             </ul>
         *             <p>
         *             This parameter is required for io1 and io2 volume types. The default for gp3 volumes is
         *             3,000 IOPS. This parameter is not supported for st1, sc1, or standard volume types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iops(java.lang.Number iops) {
            this.iops = iops;
            return this;
        }

        /**
         * Sets the value of {@link ServiceManagedEBSVolumeConfiguration#getKmsKeyId}
         * @param kmsKeyId AWS Key Management Service key to use for Amazon EBS encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(software.amazon.awscdk.services.kms.IKey kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link ServiceManagedEBSVolumeConfiguration#getRole}
         * @param role An IAM role that allows ECS to make calls to EBS APIs on your behalf.
         *             This role is required to create and manage the Amazon EBS volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link ServiceManagedEBSVolumeConfiguration#getSize}
         * @param size The size of the volume in GiB.
         *             You must specify either <code>size</code> or <code>snapshotId</code>.
         *             You can optionally specify a volume size greater than or equal to the snapshot size.
         *             <p>
         *             The following are the supported volume size values for each volume type.
         *             <p>
         *             <ul>
         *             <li>gp2 and gp3: 1-16,384</li>
         *             <li>io1 and io2: 4-16,384</li>
         *             <li>st1 and sc1: 125-16,384</li>
         *             <li>standard: 1-1,024</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder size(software.amazon.awscdk.Size size) {
            this.size = size;
            return this;
        }

        /**
         * Sets the value of {@link ServiceManagedEBSVolumeConfiguration#getSnapShotId}
         * @param snapShotId The snapshot that Amazon ECS uses to create the volume.
         *                   You must specify either <code>size</code> or <code>snapshotId</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapShotId(java.lang.String snapShotId) {
            this.snapShotId = snapShotId;
            return this;
        }

        /**
         * Sets the value of {@link ServiceManagedEBSVolumeConfiguration#getTagSpecifications}
         * @param tagSpecifications Specifies the tags to apply to the volume and whether to propagate those tags to the volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tagSpecifications(java.util.List<? extends software.amazon.awscdk.services.ecs.EBSTagSpecification> tagSpecifications) {
            this.tagSpecifications = (java.util.List<software.amazon.awscdk.services.ecs.EBSTagSpecification>)tagSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link ServiceManagedEBSVolumeConfiguration#getThroughput}
         * @param throughput The throughput to provision for a volume, in MiB/s, with a maximum of 1,000 MiB/s.
         *                   This parameter is only supported for the gp3 volume type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throughput(java.lang.Number throughput) {
            this.throughput = throughput;
            return this;
        }

        /**
         * Sets the value of {@link ServiceManagedEBSVolumeConfiguration#getVolumeType}
         * @param volumeType The volume type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeType(software.amazon.awscdk.services.ec2.EbsDeviceVolumeType volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServiceManagedEBSVolumeConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServiceManagedEBSVolumeConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServiceManagedEBSVolumeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceManagedEBSVolumeConfiguration {
        private final java.lang.Boolean encrypted;
        private final software.amazon.awscdk.services.ecs.FileSystemType fileSystemType;
        private final java.lang.Number iops;
        private final software.amazon.awscdk.services.kms.IKey kmsKeyId;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.Size size;
        private final java.lang.String snapShotId;
        private final java.util.List<software.amazon.awscdk.services.ecs.EBSTagSpecification> tagSpecifications;
        private final java.lang.Number throughput;
        private final software.amazon.awscdk.services.ec2.EbsDeviceVolumeType volumeType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.fileSystemType = software.amazon.jsii.Kernel.get(this, "fileSystemType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FileSystemType.class));
            this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.snapShotId = software.amazon.jsii.Kernel.get(this, "snapShotId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tagSpecifications = software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EBSTagSpecification.class)));
            this.throughput = software.amazon.jsii.Kernel.get(this, "throughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.EbsDeviceVolumeType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.encrypted = builder.encrypted;
            this.fileSystemType = builder.fileSystemType;
            this.iops = builder.iops;
            this.kmsKeyId = builder.kmsKeyId;
            this.role = builder.role;
            this.size = builder.size;
            this.snapShotId = builder.snapShotId;
            this.tagSpecifications = (java.util.List<software.amazon.awscdk.services.ecs.EBSTagSpecification>)builder.tagSpecifications;
            this.throughput = builder.throughput;
            this.volumeType = builder.volumeType;
        }

        @Override
        public final java.lang.Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FileSystemType getFileSystemType() {
            return this.fileSystemType;
        }

        @Override
        public final java.lang.Number getIops() {
            return this.iops;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.Size getSize() {
            return this.size;
        }

        @Override
        public final java.lang.String getSnapShotId() {
            return this.snapShotId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.EBSTagSpecification> getTagSpecifications() {
            return this.tagSpecifications;
        }

        @Override
        public final java.lang.Number getThroughput() {
            return this.throughput;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.EbsDeviceVolumeType getVolumeType() {
            return this.volumeType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEncrypted() != null) {
                data.set("encrypted", om.valueToTree(this.getEncrypted()));
            }
            if (this.getFileSystemType() != null) {
                data.set("fileSystemType", om.valueToTree(this.getFileSystemType()));
            }
            if (this.getIops() != null) {
                data.set("iops", om.valueToTree(this.getIops()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSize() != null) {
                data.set("size", om.valueToTree(this.getSize()));
            }
            if (this.getSnapShotId() != null) {
                data.set("snapShotId", om.valueToTree(this.getSnapShotId()));
            }
            if (this.getTagSpecifications() != null) {
                data.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
            }
            if (this.getThroughput() != null) {
                data.set("throughput", om.valueToTree(this.getThroughput()));
            }
            if (this.getVolumeType() != null) {
                data.set("volumeType", om.valueToTree(this.getVolumeType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.ServiceManagedEBSVolumeConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServiceManagedEBSVolumeConfiguration.Jsii$Proxy that = (ServiceManagedEBSVolumeConfiguration.Jsii$Proxy) o;

            if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
            if (this.fileSystemType != null ? !this.fileSystemType.equals(that.fileSystemType) : that.fileSystemType != null) return false;
            if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.size != null ? !this.size.equals(that.size) : that.size != null) return false;
            if (this.snapShotId != null ? !this.snapShotId.equals(that.snapShotId) : that.snapShotId != null) return false;
            if (this.tagSpecifications != null ? !this.tagSpecifications.equals(that.tagSpecifications) : that.tagSpecifications != null) return false;
            if (this.throughput != null ? !this.throughput.equals(that.throughput) : that.throughput != null) return false;
            return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.encrypted != null ? this.encrypted.hashCode() : 0;
            result = 31 * result + (this.fileSystemType != null ? this.fileSystemType.hashCode() : 0);
            result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
            result = 31 * result + (this.snapShotId != null ? this.snapShotId.hashCode() : 0);
            result = 31 * result + (this.tagSpecifications != null ? this.tagSpecifications.hashCode() : 0);
            result = 31 * result + (this.throughput != null ? this.throughput.hashCode() : 0);
            result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
            return result;
        }
    }
}
