package software.amazon.awscdk.services.ecs.patterns;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.ecs.patterns.*;
 * ContainerImage containerImage;
 * LogDriver logDriver;
 * Secret secret;
 * ScheduledTaskImageProps scheduledTaskImageProps = ScheduledTaskImageProps.builder()
 *         .image(containerImage)
 *         // the properties below are optional
 *         .command(List.of("command"))
 *         .environment(Map.of(
 *                 "environmentKey", "environment"))
 *         .logDriver(logDriver)
 *         .secrets(Map.of(
 *                 "secretsKey", secret))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:54.969Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.ScheduledTaskImageProps")
@software.amazon.jsii.Jsii.Proxy(ScheduledTaskImageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScheduledTaskImageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The image used to start a container.
     * <p>
     * Image or taskDefinition must be specified, but not both.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage getImage();

    /**
     * The command that is passed to the container.
     * <p>
     * If you provide a shell command as a single string, you have to quote command-line arguments.
     * <p>
     * Default: - CMD value built into container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * The environment variables to pass to the container.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * The log driver to use.
     * <p>
     * Default: - AwsLogDriver if enableLogging is true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LogDriver getLogDriver() {
        return null;
    }

    /**
     * The secret to expose to the container as an environment variable.
     * <p>
     * Default: - No secret environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecrets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ScheduledTaskImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScheduledTaskImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ScheduledTaskImageProps> {
        software.amazon.awscdk.services.ecs.ContainerImage image;
        java.util.List<java.lang.String> command;
        java.util.Map<java.lang.String, java.lang.String> environment;
        software.amazon.awscdk.services.ecs.LogDriver logDriver;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;

        /**
         * Sets the value of {@link ScheduledTaskImageProps#getImage}
         * @param image The image used to start a container. This parameter is required.
         *              Image or taskDefinition must be specified, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledTaskImageProps#getCommand}
         * @param command The command that is passed to the container.
         *                If you provide a shell command as a single string, you have to quote command-line arguments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledTaskImageProps#getEnvironment}
         * @param environment The environment variables to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledTaskImageProps#getLogDriver}
         * @param logDriver The log driver to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDriver(software.amazon.awscdk.services.ecs.LogDriver logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledTaskImageProps#getSecrets}
         * @param secrets The secret to expose to the container as an environment variable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder secrets(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ecs.Secret> secrets) {
            this.secrets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret>)secrets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScheduledTaskImageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ScheduledTaskImageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ScheduledTaskImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledTaskImageProps {
        private final software.amazon.awscdk.services.ecs.ContainerImage image;
        private final java.util.List<java.lang.String> command;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final software.amazon.awscdk.services.ecs.LogDriver logDriver;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.logDriver = software.amazon.jsii.Kernel.get(this, "logDriver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class));
            this.secrets = software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
            this.command = builder.command;
            this.environment = builder.environment;
            this.logDriver = builder.logDriver;
            this.secrets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret>)builder.secrets;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.image;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.LogDriver getLogDriver() {
            return this.logDriver;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecrets() {
            return this.secrets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("image", om.valueToTree(this.getImage()));
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getLogDriver() != null) {
                data.set("logDriver", om.valueToTree(this.getLogDriver()));
            }
            if (this.getSecrets() != null) {
                data.set("secrets", om.valueToTree(this.getSecrets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs_patterns.ScheduledTaskImageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScheduledTaskImageProps.Jsii$Proxy that = (ScheduledTaskImageProps.Jsii$Proxy) o;

            if (!image.equals(that.image)) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.logDriver != null ? !this.logDriver.equals(that.logDriver) : that.logDriver != null) return false;
            return this.secrets != null ? this.secrets.equals(that.secrets) : that.secrets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.image.hashCode();
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.logDriver != null ? this.logDriver.hashCode() : 0);
            result = 31 * result + (this.secrets != null ? this.secrets.hashCode() : 0);
            return result;
        }
    }
}
