package software.amazon.awscdk.services.eks;

/**
 * Properties for defining a <code>CfnNodegroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * CfnNodegroupProps cfnNodegroupProps = CfnNodegroupProps.builder()
 *         .clusterName("clusterName")
 *         .nodeRole("nodeRole")
 *         .subnets(List.of("subnets"))
 *         // the properties below are optional
 *         .amiType("amiType")
 *         .capacityType("capacityType")
 *         .diskSize(123)
 *         .forceUpdateEnabled(false)
 *         .instanceTypes(List.of("instanceTypes"))
 *         .labels(Map.of(
 *                 "labelsKey", "labels"))
 *         .launchTemplate(LaunchTemplateSpecificationProperty.builder()
 *                 .id("id")
 *                 .name("name")
 *                 .version("version")
 *                 .build())
 *         .nodegroupName("nodegroupName")
 *         .releaseVersion("releaseVersion")
 *         .remoteAccess(RemoteAccessProperty.builder()
 *                 .ec2SshKey("ec2SshKey")
 *                 // the properties below are optional
 *                 .sourceSecurityGroups(List.of("sourceSecurityGroups"))
 *                 .build())
 *         .scalingConfig(ScalingConfigProperty.builder()
 *                 .desiredSize(123)
 *                 .maxSize(123)
 *                 .minSize(123)
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .taints(List.of(TaintProperty.builder()
 *                 .effect("effect")
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .updateConfig(UpdateConfigProperty.builder()
 *                 .maxUnavailable(123)
 *                 .maxUnavailablePercentage(123)
 *                 .build())
 *         .version("version")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:55.100Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnNodegroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnNodegroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNodegroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of your cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-clustername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * The Amazon Resource Name (ARN) of the IAM role to associate with your node group.
     * <p>
     * The Amazon EKS worker node <code>kubelet</code> daemon makes calls to AWS APIs on your behalf. Nodes receive permissions for these API calls through an IAM instance profile and associated policies. Before you can launch nodes and register them into a cluster, you must create an IAM role for those nodes to use when they are launched. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in the <strong>Amazon EKS User Guide</strong> . If you specify <code>launchTemplate</code> , then don't specify <code>[IamInstanceProfile](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html)</code> in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <em>Amazon EKS User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-noderole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-noderole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNodeRole();

    /**
     * The subnets to use for the Auto Scaling group that is created for your node group.
     * <p>
     * If you specify <code>launchTemplate</code> , then don't specify <code>[SubnetId](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html)</code> in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <em>Amazon EKS User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-subnets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-subnets</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

    /**
     * The AMI type for your node group.
     * <p>
     * If you specify <code>launchTemplate</code> , and your launch template uses a custom AMI, then don't specify <code>amiType</code> , or the node group deployment will fail. If your launch template uses a Windows custom AMI, then add <code>eks:kube-proxy-windows</code> to your Windows nodes <code>rolearn</code> in the <code>aws-auth</code> <code>ConfigMap</code> . For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <em>Amazon EKS User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-amitype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-amitype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAmiType() {
        return null;
    }

    /**
     * The capacity type of your managed node group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-capacitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-capacitytype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCapacityType() {
        return null;
    }

    /**
     * The root device disk size (in GiB) for your node group instances.
     * <p>
     * The default disk size is 20 GiB for Linux and Bottlerocket. The default disk size is 50 GiB for Windows. If you specify <code>launchTemplate</code> , then don't specify <code>diskSize</code> , or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <em>Amazon EKS User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-disksize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-disksize</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDiskSize() {
        return null;
    }

    /**
     * Force the update if any <code>Pod</code> on the existing node group can't be drained due to a <code>Pod</code> disruption budget issue.
     * <p>
     * If an update fails because all Pods can't be drained, you can force the update after it fails to terminate the old node whether or not any <code>Pod</code> is running on the node.
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-forceupdateenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-forceupdateenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getForceUpdateEnabled() {
        return null;
    }

    /**
     * Specify the instance types for a node group.
     * <p>
     * If you specify a GPU instance type, make sure to also specify an applicable GPU AMI type with the <code>amiType</code> parameter. If you specify <code>launchTemplate</code> , then you can specify zero or one instance type in your launch template <em>or</em> you can specify 0-20 instance types for <code>instanceTypes</code> . If however, you specify an instance type in your launch template <em>and</em> specify any <code>instanceTypes</code> , the node group deployment will fail. If you don't specify an instance type in a launch template or for <code>instanceTypes</code> , then <code>t3.medium</code> is used, by default. If you specify <code>Spot</code> for <code>capacityType</code> , then we recommend specifying multiple values for <code>instanceTypes</code> . For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types">Managed node group capacity types</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <em>Amazon EKS User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-instancetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-instancetypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceTypes() {
        return null;
    }

    /**
     * The Kubernetes <code>labels</code> applied to the nodes in the node group.
     * <p>
     * <blockquote>
     * <p>
     * Only <code>labels</code> that are applied with the Amazon EKS API are shown here. There may be other Kubernetes <code>labels</code> applied to the nodes in this group.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-labels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-labels</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLabels() {
        return null;
    }

    /**
     * An object representing a node group's launch template specification.
     * <p>
     * If specified, then do not specify <code>instanceTypes</code> , <code>diskSize</code> , or <code>remoteAccess</code> and make sure that the launch template meets the requirements in <code>launchTemplateSpecification</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-launchtemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-launchtemplate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplate() {
        return null;
    }

    /**
     * The unique name to give your node group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-nodegroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-nodegroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNodegroupName() {
        return null;
    }

    /**
     * The AMI version of the Amazon EKS optimized AMI to use with your node group (for example, <code>1.14.7- *YYYYMMDD*</code> ). By default, the latest available AMI version for the node group's current Kubernetes version is used. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Linux AMI Versions</a> in the <em>Amazon EKS User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Changing this value triggers an update of the node group if one is available. You can't update other properties at the same time as updating <code>Release Version</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-releaseversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-releaseversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReleaseVersion() {
        return null;
    }

    /**
     * The remote access configuration to use with your node group.
     * <p>
     * For Linux, the protocol is SSH. For Windows, the protocol is RDP. If you specify <code>launchTemplate</code> , then don't specify <code>remoteAccess</code> , or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <em>Amazon EKS User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-remoteaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-remoteaccess</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRemoteAccess() {
        return null;
    }

    /**
     * The scaling configuration details for the Auto Scaling group that is created for your node group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-scalingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-scalingconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScalingConfig() {
        return null;
    }

    /**
     * Metadata that assists with categorization and organization.
     * <p>
     * Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or AWS resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * The Kubernetes taints to be applied to the nodes in the node group when they are created.
     * <p>
     * Effect is one of <code>No_Schedule</code> , <code>Prefer_No_Schedule</code> , or <code>No_Execute</code> . Kubernetes taints can be used together with tolerations to control how workloads are scheduled to your nodes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node taints on managed node groups</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-taints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-taints</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTaints() {
        return null;
    }

    /**
     * The node group update configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-updateconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-updateconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUpdateConfig() {
        return null;
    }

    /**
     * The Kubernetes version to use for your managed nodes.
     * <p>
     * By default, the Kubernetes version of the cluster is used, and this is the only accepted specified value. If you specify <code>launchTemplate</code> , and your launch template uses a custom AMI, then don't specify <code>version</code> , or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <em>Amazon EKS User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * You can't update other properties at the same time as updating <code>Version</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-version</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNodegroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNodegroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNodegroupProps> {
        java.lang.String clusterName;
        java.lang.String nodeRole;
        java.util.List<java.lang.String> subnets;
        java.lang.String amiType;
        java.lang.String capacityType;
        java.lang.Number diskSize;
        java.lang.Object forceUpdateEnabled;
        java.util.List<java.lang.String> instanceTypes;
        java.lang.Object labels;
        java.lang.Object launchTemplate;
        java.lang.String nodegroupName;
        java.lang.String releaseVersion;
        java.lang.Object remoteAccess;
        java.lang.Object scalingConfig;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Object taints;
        java.lang.Object updateConfig;
        java.lang.String version;

        /**
         * Sets the value of {@link CfnNodegroupProps#getClusterName}
         * @param clusterName The name of your cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getNodeRole}
         * @param nodeRole The Amazon Resource Name (ARN) of the IAM role to associate with your node group. This parameter is required.
         *                 The Amazon EKS worker node <code>kubelet</code> daemon makes calls to AWS APIs on your behalf. Nodes receive permissions for these API calls through an IAM instance profile and associated policies. Before you can launch nodes and register them into a cluster, you must create an IAM role for those nodes to use when they are launched. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in the <strong>Amazon EKS User Guide</strong> . If you specify <code>launchTemplate</code> , then don't specify <code>[IamInstanceProfile](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html)</code> in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <em>Amazon EKS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeRole(java.lang.String nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getSubnets}
         * @param subnets The subnets to use for the Auto Scaling group that is created for your node group. This parameter is required.
         *                If you specify <code>launchTemplate</code> , then don't specify <code>[SubnetId](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html)</code> in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <em>Amazon EKS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(java.util.List<java.lang.String> subnets) {
            this.subnets = subnets;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getAmiType}
         * @param amiType The AMI type for your node group.
         *                If you specify <code>launchTemplate</code> , and your launch template uses a custom AMI, then don't specify <code>amiType</code> , or the node group deployment will fail. If your launch template uses a Windows custom AMI, then add <code>eks:kube-proxy-windows</code> to your Windows nodes <code>rolearn</code> in the <code>aws-auth</code> <code>ConfigMap</code> . For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <em>Amazon EKS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amiType(java.lang.String amiType) {
            this.amiType = amiType;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getCapacityType}
         * @param capacityType The capacity type of your managed node group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityType(java.lang.String capacityType) {
            this.capacityType = capacityType;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getDiskSize}
         * @param diskSize The root device disk size (in GiB) for your node group instances.
         *                 The default disk size is 20 GiB for Linux and Bottlerocket. The default disk size is 50 GiB for Windows. If you specify <code>launchTemplate</code> , then don't specify <code>diskSize</code> , or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <em>Amazon EKS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder diskSize(java.lang.Number diskSize) {
            this.diskSize = diskSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getForceUpdateEnabled}
         * @param forceUpdateEnabled Force the update if any <code>Pod</code> on the existing node group can't be drained due to a <code>Pod</code> disruption budget issue.
         *                           If an update fails because all Pods can't be drained, you can force the update after it fails to terminate the old node whether or not any <code>Pod</code> is running on the node.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceUpdateEnabled(java.lang.Boolean forceUpdateEnabled) {
            this.forceUpdateEnabled = forceUpdateEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getForceUpdateEnabled}
         * @param forceUpdateEnabled Force the update if any <code>Pod</code> on the existing node group can't be drained due to a <code>Pod</code> disruption budget issue.
         *                           If an update fails because all Pods can't be drained, you can force the update after it fails to terminate the old node whether or not any <code>Pod</code> is running on the node.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceUpdateEnabled(software.amazon.awscdk.IResolvable forceUpdateEnabled) {
            this.forceUpdateEnabled = forceUpdateEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getInstanceTypes}
         * @param instanceTypes Specify the instance types for a node group.
         *                      If you specify a GPU instance type, make sure to also specify an applicable GPU AMI type with the <code>amiType</code> parameter. If you specify <code>launchTemplate</code> , then you can specify zero or one instance type in your launch template <em>or</em> you can specify 0-20 instance types for <code>instanceTypes</code> . If however, you specify an instance type in your launch template <em>and</em> specify any <code>instanceTypes</code> , the node group deployment will fail. If you don't specify an instance type in a launch template or for <code>instanceTypes</code> , then <code>t3.medium</code> is used, by default. If you specify <code>Spot</code> for <code>capacityType</code> , then we recommend specifying multiple values for <code>instanceTypes</code> . For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types">Managed node group capacity types</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <em>Amazon EKS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypes(java.util.List<java.lang.String> instanceTypes) {
            this.instanceTypes = instanceTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getLabels}
         * @param labels The Kubernetes <code>labels</code> applied to the nodes in the node group.
         *               <blockquote>
         *               <p>
         *               Only <code>labels</code> that are applied with the Amazon EKS API are shown here. There may be other Kubernetes <code>labels</code> applied to the nodes in this group.
         *               <p>
         *               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(software.amazon.awscdk.IResolvable labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getLabels}
         * @param labels The Kubernetes <code>labels</code> applied to the nodes in the node group.
         *               <blockquote>
         *               <p>
         *               Only <code>labels</code> that are applied with the Amazon EKS API are shown here. There may be other Kubernetes <code>labels</code> applied to the nodes in this group.
         *               <p>
         *               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.Map<java.lang.String, java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getLaunchTemplate}
         * @param launchTemplate An object representing a node group's launch template specification.
         *                       If specified, then do not specify <code>instanceTypes</code> , <code>diskSize</code> , or <code>remoteAccess</code> and make sure that the launch template meets the requirements in <code>launchTemplateSpecification</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplate(software.amazon.awscdk.IResolvable launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getLaunchTemplate}
         * @param launchTemplate An object representing a node group's launch template specification.
         *                       If specified, then do not specify <code>instanceTypes</code> , <code>diskSize</code> , or <code>remoteAccess</code> and make sure that the launch template meets the requirements in <code>launchTemplateSpecification</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplate(software.amazon.awscdk.services.eks.CfnNodegroup.LaunchTemplateSpecificationProperty launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getNodegroupName}
         * @param nodegroupName The unique name to give your node group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodegroupName(java.lang.String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getReleaseVersion}
         * @param releaseVersion The AMI version of the Amazon EKS optimized AMI to use with your node group (for example, <code>1.14.7- *YYYYMMDD*</code> ). By default, the latest available AMI version for the node group's current Kubernetes version is used. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Linux AMI Versions</a> in the <em>Amazon EKS User Guide</em> .
         *                       <blockquote>
         *                       <p>
         *                       Changing this value triggers an update of the node group if one is available. You can't update other properties at the same time as updating <code>Release Version</code> .
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder releaseVersion(java.lang.String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getRemoteAccess}
         * @param remoteAccess The remote access configuration to use with your node group.
         *                     For Linux, the protocol is SSH. For Windows, the protocol is RDP. If you specify <code>launchTemplate</code> , then don't specify <code>remoteAccess</code> , or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <em>Amazon EKS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remoteAccess(software.amazon.awscdk.IResolvable remoteAccess) {
            this.remoteAccess = remoteAccess;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getRemoteAccess}
         * @param remoteAccess The remote access configuration to use with your node group.
         *                     For Linux, the protocol is SSH. For Windows, the protocol is RDP. If you specify <code>launchTemplate</code> , then don't specify <code>remoteAccess</code> , or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <em>Amazon EKS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remoteAccess(software.amazon.awscdk.services.eks.CfnNodegroup.RemoteAccessProperty remoteAccess) {
            this.remoteAccess = remoteAccess;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getScalingConfig}
         * @param scalingConfig The scaling configuration details for the Auto Scaling group that is created for your node group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfig(software.amazon.awscdk.IResolvable scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getScalingConfig}
         * @param scalingConfig The scaling configuration details for the Auto Scaling group that is created for your node group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfig(software.amazon.awscdk.services.eks.CfnNodegroup.ScalingConfigProperty scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getTags}
         * @param tags Metadata that assists with categorization and organization.
         *             Each tag consists of a key and an optional value. You define both. Tags don't propagate to any other cluster or AWS resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getTaints}
         * @param taints The Kubernetes taints to be applied to the nodes in the node group when they are created.
         *               Effect is one of <code>No_Schedule</code> , <code>Prefer_No_Schedule</code> , or <code>No_Execute</code> . Kubernetes taints can be used together with tolerations to control how workloads are scheduled to your nodes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node taints on managed node groups</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taints(software.amazon.awscdk.IResolvable taints) {
            this.taints = taints;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getTaints}
         * @param taints The Kubernetes taints to be applied to the nodes in the node group when they are created.
         *               Effect is one of <code>No_Schedule</code> , <code>Prefer_No_Schedule</code> , or <code>No_Execute</code> . Kubernetes taints can be used together with tolerations to control how workloads are scheduled to your nodes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node taints on managed node groups</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taints(java.util.List<? extends java.lang.Object> taints) {
            this.taints = taints;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getUpdateConfig}
         * @param updateConfig The node group update configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateConfig(software.amazon.awscdk.IResolvable updateConfig) {
            this.updateConfig = updateConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getUpdateConfig}
         * @param updateConfig The node group update configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateConfig(software.amazon.awscdk.services.eks.CfnNodegroup.UpdateConfigProperty updateConfig) {
            this.updateConfig = updateConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnNodegroupProps#getVersion}
         * @param version The Kubernetes version to use for your managed nodes.
         *                By default, the Kubernetes version of the cluster is used, and this is the only accepted specified value. If you specify <code>launchTemplate</code> , and your launch template uses a custom AMI, then don't specify <code>version</code> , or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <em>Amazon EKS User Guide</em> .
         *                <p>
         *                <blockquote>
         *                <p>
         *                You can't update other properties at the same time as updating <code>Version</code> .
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNodegroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNodegroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnNodegroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNodegroupProps {
        private final java.lang.String clusterName;
        private final java.lang.String nodeRole;
        private final java.util.List<java.lang.String> subnets;
        private final java.lang.String amiType;
        private final java.lang.String capacityType;
        private final java.lang.Number diskSize;
        private final java.lang.Object forceUpdateEnabled;
        private final java.util.List<java.lang.String> instanceTypes;
        private final java.lang.Object labels;
        private final java.lang.Object launchTemplate;
        private final java.lang.String nodegroupName;
        private final java.lang.String releaseVersion;
        private final java.lang.Object remoteAccess;
        private final java.lang.Object scalingConfig;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Object taints;
        private final java.lang.Object updateConfig;
        private final java.lang.String version;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nodeRole = software.amazon.jsii.Kernel.get(this, "nodeRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.amiType = software.amazon.jsii.Kernel.get(this, "amiType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.capacityType = software.amazon.jsii.Kernel.get(this, "capacityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.diskSize = software.amazon.jsii.Kernel.get(this, "diskSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.forceUpdateEnabled = software.amazon.jsii.Kernel.get(this, "forceUpdateEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.instanceTypes = software.amazon.jsii.Kernel.get(this, "instanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.launchTemplate = software.amazon.jsii.Kernel.get(this, "launchTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.nodegroupName = software.amazon.jsii.Kernel.get(this, "nodegroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.releaseVersion = software.amazon.jsii.Kernel.get(this, "releaseVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.remoteAccess = software.amazon.jsii.Kernel.get(this, "remoteAccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scalingConfig = software.amazon.jsii.Kernel.get(this, "scalingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.taints = software.amazon.jsii.Kernel.get(this, "taints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.updateConfig = software.amazon.jsii.Kernel.get(this, "updateConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            this.nodeRole = java.util.Objects.requireNonNull(builder.nodeRole, "nodeRole is required");
            this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
            this.amiType = builder.amiType;
            this.capacityType = builder.capacityType;
            this.diskSize = builder.diskSize;
            this.forceUpdateEnabled = builder.forceUpdateEnabled;
            this.instanceTypes = builder.instanceTypes;
            this.labels = builder.labels;
            this.launchTemplate = builder.launchTemplate;
            this.nodegroupName = builder.nodegroupName;
            this.releaseVersion = builder.releaseVersion;
            this.remoteAccess = builder.remoteAccess;
            this.scalingConfig = builder.scalingConfig;
            this.tags = builder.tags;
            this.taints = builder.taints;
            this.updateConfig = builder.updateConfig;
            this.version = builder.version;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.String getNodeRole() {
            return this.nodeRole;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final java.lang.String getAmiType() {
            return this.amiType;
        }

        @Override
        public final java.lang.String getCapacityType() {
            return this.capacityType;
        }

        @Override
        public final java.lang.Number getDiskSize() {
            return this.diskSize;
        }

        @Override
        public final java.lang.Object getForceUpdateEnabled() {
            return this.forceUpdateEnabled;
        }

        @Override
        public final java.util.List<java.lang.String> getInstanceTypes() {
            return this.instanceTypes;
        }

        @Override
        public final java.lang.Object getLabels() {
            return this.labels;
        }

        @Override
        public final java.lang.Object getLaunchTemplate() {
            return this.launchTemplate;
        }

        @Override
        public final java.lang.String getNodegroupName() {
            return this.nodegroupName;
        }

        @Override
        public final java.lang.String getReleaseVersion() {
            return this.releaseVersion;
        }

        @Override
        public final java.lang.Object getRemoteAccess() {
            return this.remoteAccess;
        }

        @Override
        public final java.lang.Object getScalingConfig() {
            return this.scalingConfig;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTaints() {
            return this.taints;
        }

        @Override
        public final java.lang.Object getUpdateConfig() {
            return this.updateConfig;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterName", om.valueToTree(this.getClusterName()));
            data.set("nodeRole", om.valueToTree(this.getNodeRole()));
            data.set("subnets", om.valueToTree(this.getSubnets()));
            if (this.getAmiType() != null) {
                data.set("amiType", om.valueToTree(this.getAmiType()));
            }
            if (this.getCapacityType() != null) {
                data.set("capacityType", om.valueToTree(this.getCapacityType()));
            }
            if (this.getDiskSize() != null) {
                data.set("diskSize", om.valueToTree(this.getDiskSize()));
            }
            if (this.getForceUpdateEnabled() != null) {
                data.set("forceUpdateEnabled", om.valueToTree(this.getForceUpdateEnabled()));
            }
            if (this.getInstanceTypes() != null) {
                data.set("instanceTypes", om.valueToTree(this.getInstanceTypes()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getLaunchTemplate() != null) {
                data.set("launchTemplate", om.valueToTree(this.getLaunchTemplate()));
            }
            if (this.getNodegroupName() != null) {
                data.set("nodegroupName", om.valueToTree(this.getNodegroupName()));
            }
            if (this.getReleaseVersion() != null) {
                data.set("releaseVersion", om.valueToTree(this.getReleaseVersion()));
            }
            if (this.getRemoteAccess() != null) {
                data.set("remoteAccess", om.valueToTree(this.getRemoteAccess()));
            }
            if (this.getScalingConfig() != null) {
                data.set("scalingConfig", om.valueToTree(this.getScalingConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTaints() != null) {
                data.set("taints", om.valueToTree(this.getTaints()));
            }
            if (this.getUpdateConfig() != null) {
                data.set("updateConfig", om.valueToTree(this.getUpdateConfig()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnNodegroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNodegroupProps.Jsii$Proxy that = (CfnNodegroupProps.Jsii$Proxy) o;

            if (!clusterName.equals(that.clusterName)) return false;
            if (!nodeRole.equals(that.nodeRole)) return false;
            if (!subnets.equals(that.subnets)) return false;
            if (this.amiType != null ? !this.amiType.equals(that.amiType) : that.amiType != null) return false;
            if (this.capacityType != null ? !this.capacityType.equals(that.capacityType) : that.capacityType != null) return false;
            if (this.diskSize != null ? !this.diskSize.equals(that.diskSize) : that.diskSize != null) return false;
            if (this.forceUpdateEnabled != null ? !this.forceUpdateEnabled.equals(that.forceUpdateEnabled) : that.forceUpdateEnabled != null) return false;
            if (this.instanceTypes != null ? !this.instanceTypes.equals(that.instanceTypes) : that.instanceTypes != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            if (this.launchTemplate != null ? !this.launchTemplate.equals(that.launchTemplate) : that.launchTemplate != null) return false;
            if (this.nodegroupName != null ? !this.nodegroupName.equals(that.nodegroupName) : that.nodegroupName != null) return false;
            if (this.releaseVersion != null ? !this.releaseVersion.equals(that.releaseVersion) : that.releaseVersion != null) return false;
            if (this.remoteAccess != null ? !this.remoteAccess.equals(that.remoteAccess) : that.remoteAccess != null) return false;
            if (this.scalingConfig != null ? !this.scalingConfig.equals(that.scalingConfig) : that.scalingConfig != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.taints != null ? !this.taints.equals(that.taints) : that.taints != null) return false;
            if (this.updateConfig != null ? !this.updateConfig.equals(that.updateConfig) : that.updateConfig != null) return false;
            return this.version != null ? this.version.equals(that.version) : that.version == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterName.hashCode();
            result = 31 * result + (this.nodeRole.hashCode());
            result = 31 * result + (this.subnets.hashCode());
            result = 31 * result + (this.amiType != null ? this.amiType.hashCode() : 0);
            result = 31 * result + (this.capacityType != null ? this.capacityType.hashCode() : 0);
            result = 31 * result + (this.diskSize != null ? this.diskSize.hashCode() : 0);
            result = 31 * result + (this.forceUpdateEnabled != null ? this.forceUpdateEnabled.hashCode() : 0);
            result = 31 * result + (this.instanceTypes != null ? this.instanceTypes.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.launchTemplate != null ? this.launchTemplate.hashCode() : 0);
            result = 31 * result + (this.nodegroupName != null ? this.nodegroupName.hashCode() : 0);
            result = 31 * result + (this.releaseVersion != null ? this.releaseVersion.hashCode() : 0);
            result = 31 * result + (this.remoteAccess != null ? this.remoteAccess.hashCode() : 0);
            result = 31 * result + (this.scalingConfig != null ? this.scalingConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.taints != null ? this.taints.hashCode() : 0);
            result = 31 * result + (this.updateConfig != null ? this.updateConfig.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}
