package software.amazon.awscdk.services.eks;

/**
 * Properties for KubernetesPatch.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * KubernetesPatch.Builder.create(this, "hello-kub-deployment-label")
 *         .cluster(cluster)
 *         .resourceName("deployment/hello-kubernetes")
 *         .applyPatch(Map.of("spec", Map.of("replicas", 5)))
 *         .restorePatch(Map.of("spec", Map.of("replicas", 3)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:55.143Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.KubernetesPatchProps")
@software.amazon.jsii.Jsii.Proxy(KubernetesPatchProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KubernetesPatchProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The JSON object to pass to <code>kubectl patch</code> when the resource is created/updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getApplyPatch();

    /**
     * The cluster to apply the patch to.
     * <p>
     * [disable-awslint:ref-via-interface]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ICluster getCluster();

    /**
     * The full name of the resource to patch (e.g. <code>deployment/coredns</code>).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceName();

    /**
     * The JSON object to pass to <code>kubectl patch</code> when the resource is removed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getRestorePatch();

    /**
     * The patch type to pass to <code>kubectl patch</code>.
     * <p>
     * The default type used by <code>kubectl patch</code> is "strategic".
     * <p>
     * Default: PatchType.STRATEGIC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.PatchType getPatchType() {
        return null;
    }

    /**
     * The kubernetes API namespace.
     * <p>
     * Default: "default"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceNamespace() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link KubernetesPatchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KubernetesPatchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KubernetesPatchProps> {
        java.util.Map<java.lang.String, java.lang.Object> applyPatch;
        software.amazon.awscdk.services.eks.ICluster cluster;
        java.lang.String resourceName;
        java.util.Map<java.lang.String, java.lang.Object> restorePatch;
        software.amazon.awscdk.services.eks.PatchType patchType;
        java.lang.String resourceNamespace;

        /**
         * Sets the value of {@link KubernetesPatchProps#getApplyPatch}
         * @param applyPatch The JSON object to pass to <code>kubectl patch</code> when the resource is created/updated. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder applyPatch(java.util.Map<java.lang.String, ? extends java.lang.Object> applyPatch) {
            this.applyPatch = (java.util.Map<java.lang.String, java.lang.Object>)applyPatch;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesPatchProps#getCluster}
         * @param cluster The cluster to apply the patch to. This parameter is required.
         *                [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.eks.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesPatchProps#getResourceName}
         * @param resourceName The full name of the resource to patch (e.g. <code>deployment/coredns</code>). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceName(java.lang.String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesPatchProps#getRestorePatch}
         * @param restorePatch The JSON object to pass to <code>kubectl patch</code> when the resource is removed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder restorePatch(java.util.Map<java.lang.String, ? extends java.lang.Object> restorePatch) {
            this.restorePatch = (java.util.Map<java.lang.String, java.lang.Object>)restorePatch;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesPatchProps#getPatchType}
         * @param patchType The patch type to pass to <code>kubectl patch</code>.
         *                  The default type used by <code>kubectl patch</code> is "strategic".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder patchType(software.amazon.awscdk.services.eks.PatchType patchType) {
            this.patchType = patchType;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesPatchProps#getResourceNamespace}
         * @param resourceNamespace The kubernetes API namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceNamespace(java.lang.String resourceNamespace) {
            this.resourceNamespace = resourceNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KubernetesPatchProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KubernetesPatchProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KubernetesPatchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KubernetesPatchProps {
        private final java.util.Map<java.lang.String, java.lang.Object> applyPatch;
        private final software.amazon.awscdk.services.eks.ICluster cluster;
        private final java.lang.String resourceName;
        private final java.util.Map<java.lang.String, java.lang.Object> restorePatch;
        private final software.amazon.awscdk.services.eks.PatchType patchType;
        private final java.lang.String resourceNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applyPatch = software.amazon.jsii.Kernel.get(this, "applyPatch", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ICluster.class));
            this.resourceName = software.amazon.jsii.Kernel.get(this, "resourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restorePatch = software.amazon.jsii.Kernel.get(this, "restorePatch", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.patchType = software.amazon.jsii.Kernel.get(this, "patchType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.PatchType.class));
            this.resourceNamespace = software.amazon.jsii.Kernel.get(this, "resourceNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applyPatch = (java.util.Map<java.lang.String, java.lang.Object>)java.util.Objects.requireNonNull(builder.applyPatch, "applyPatch is required");
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.resourceName = java.util.Objects.requireNonNull(builder.resourceName, "resourceName is required");
            this.restorePatch = (java.util.Map<java.lang.String, java.lang.Object>)java.util.Objects.requireNonNull(builder.restorePatch, "restorePatch is required");
            this.patchType = builder.patchType;
            this.resourceNamespace = builder.resourceNamespace;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getApplyPatch() {
            return this.applyPatch;
        }

        @Override
        public final software.amazon.awscdk.services.eks.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getRestorePatch() {
            return this.restorePatch;
        }

        @Override
        public final software.amazon.awscdk.services.eks.PatchType getPatchType() {
            return this.patchType;
        }

        @Override
        public final java.lang.String getResourceNamespace() {
            return this.resourceNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applyPatch", om.valueToTree(this.getApplyPatch()));
            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("resourceName", om.valueToTree(this.getResourceName()));
            data.set("restorePatch", om.valueToTree(this.getRestorePatch()));
            if (this.getPatchType() != null) {
                data.set("patchType", om.valueToTree(this.getPatchType()));
            }
            if (this.getResourceNamespace() != null) {
                data.set("resourceNamespace", om.valueToTree(this.getResourceNamespace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.KubernetesPatchProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KubernetesPatchProps.Jsii$Proxy that = (KubernetesPatchProps.Jsii$Proxy) o;

            if (!applyPatch.equals(that.applyPatch)) return false;
            if (!cluster.equals(that.cluster)) return false;
            if (!resourceName.equals(that.resourceName)) return false;
            if (!restorePatch.equals(that.restorePatch)) return false;
            if (this.patchType != null ? !this.patchType.equals(that.patchType) : that.patchType != null) return false;
            return this.resourceNamespace != null ? this.resourceNamespace.equals(that.resourceNamespace) : that.resourceNamespace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applyPatch.hashCode();
            result = 31 * result + (this.cluster.hashCode());
            result = 31 * result + (this.resourceName.hashCode());
            result = 31 * result + (this.restorePatch.hashCode());
            result = 31 * result + (this.patchType != null ? this.patchType.hashCode() : 0);
            result = 31 * result + (this.resourceNamespace != null ? this.resourceNamespace.hashCode() : 0);
            return result;
        }
    }
}
