package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * How the load balancer handles requests that might pose a security risk to your application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ApplicationLoadBalancer lb = ApplicationLoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         // Whether HTTP/2 is enabled
 *         .http2Enabled(false)
 *         // The idle timeout value, in seconds
 *         .idleTimeout(Duration.seconds(1000))
 *         // Whether HTTP headers with header fields thatare not valid
 *         // are removed by the load balancer (true), or routed to targets
 *         .dropInvalidHeaderFields(true)
 *         // How the load balancer handles requests that might
 *         // pose a security risk to your application
 *         .desyncMitigationMode(DesyncMitigationMode.DEFENSIVE)
 *         // The type of IP addresses to use.
 *         .ipAddressType(IpAddressType.IPV4)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#desync-mitigation-mode">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#desync-mitigation-mode</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:55.361Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.DesyncMitigationMode")
public enum DesyncMitigationMode {
    /**
     * Allows all traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONITOR,
    /**
     * Provides durable mitigation against HTTP desync while maintaining the availability of your application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEFENSIVE,
    /**
     * Receives only requests that comply with RFC 7230.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STRICTEST,
}
