package software.amazon.awscdk.services.events;

/**
 * Creates or updates the specified rule.
 * <p>
 * Rules are enabled by default, or based on value of the state. You can disable a rule using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DisableRule.html">DisableRule</a> .
 * <p>
 * A single rule watches for events from a single event bus. Events generated by AWS services go to your account's default event bus. Events generated by SaaS partner services or applications go to the matching partner event bus. If you have custom applications or services, you can specify whether their events go to your default event bus or a custom event bus that you have created. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a> .
 * <p>
 * If you are updating an existing rule, the rule is replaced with what you specify in this <code>PutRule</code> command. If you omit arguments in <code>PutRule</code> , the old values for those arguments are not kept. Instead, they are replaced with null values.
 * <p>
 * When you create or update a rule, incoming events might not immediately start matching to new or updated rules. Allow a short period of time for changes to take effect.
 * <p>
 * A rule must contain at least an EventPattern or ScheduleExpression. Rules with EventPatterns are triggered when a matching event is observed. Rules with ScheduleExpressions self-trigger based on the given schedule. A rule can have both an EventPattern and a ScheduleExpression, in which case the rule triggers on matching events as well as on a schedule.
 * <p>
 * Most services in AWS treat : or / as the same character in Amazon Resource Names (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when creating event patterns so that they match the ARN syntax in the event you want to match.
 * <p>
 * In EventBridge, it is possible to create rules that lead to infinite loops, where a rule is fired repeatedly. For example, a rule might detect that ACLs have changed on an S3 bucket, and trigger software to change them to the desired state. If the rule is not written carefully, the subsequent change to the ACLs fires the rule again, creating an infinite loop.
 * <p>
 * To prevent this, write the rules so that the triggered actions do not re-fire the same rule. For example, your rule could fire only if ACLs are found to be in a bad state, instead of after any change.
 * <p>
 * An infinite loop can quickly cause higher than expected charges. We recommend that you use budgeting, which alerts you when charges exceed your specified limit. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html">Managing Your Costs with Budgets</a> .
 * <p>
 * <blockquote>
 * <p>
 * As an aid to help you jumpstart developing CloudFormation templates, the EventBridge console enables you to create templates from the existing rules in your account. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-generate-template.html">Generating CloudFormation templates from an EventBridge rule</a> in the <em>Amazon EventBridge User Guide</em> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * Object eventPattern;
 * CfnRule cfnRule = CfnRule.Builder.create(this, "MyCfnRule")
 *         .description("description")
 *         .eventBusName("eventBusName")
 *         .eventPattern(eventPattern)
 *         .name("name")
 *         .roleArn("roleArn")
 *         .scheduleExpression("scheduleExpression")
 *         .state("state")
 *         .targets(List.of(TargetProperty.builder()
 *                 .arn("arn")
 *                 .id("id")
 *                 // the properties below are optional
 *                 .appSyncParameters(AppSyncParametersProperty.builder()
 *                         .graphQlOperation("graphQlOperation")
 *                         .build())
 *                 .batchParameters(BatchParametersProperty.builder()
 *                         .jobDefinition("jobDefinition")
 *                         .jobName("jobName")
 *                         // the properties below are optional
 *                         .arrayProperties(BatchArrayPropertiesProperty.builder()
 *                                 .size(123)
 *                                 .build())
 *                         .retryStrategy(BatchRetryStrategyProperty.builder()
 *                                 .attempts(123)
 *                                 .build())
 *                         .build())
 *                 .deadLetterConfig(DeadLetterConfigProperty.builder()
 *                         .arn("arn")
 *                         .build())
 *                 .ecsParameters(EcsParametersProperty.builder()
 *                         .taskDefinitionArn("taskDefinitionArn")
 *                         // the properties below are optional
 *                         .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
 *                                 .capacityProvider("capacityProvider")
 *                                 // the properties below are optional
 *                                 .base(123)
 *                                 .weight(123)
 *                                 .build()))
 *                         .enableEcsManagedTags(false)
 *                         .enableExecuteCommand(false)
 *                         .group("group")
 *                         .launchType("launchType")
 *                         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                                 .awsVpcConfiguration(AwsVpcConfigurationProperty.builder()
 *                                         .subnets(List.of("subnets"))
 *                                         // the properties below are optional
 *                                         .assignPublicIp("assignPublicIp")
 *                                         .securityGroups(List.of("securityGroups"))
 *                                         .build())
 *                                 .build())
 *                         .placementConstraints(List.of(PlacementConstraintProperty.builder()
 *                                 .expression("expression")
 *                                 .type("type")
 *                                 .build()))
 *                         .placementStrategies(List.of(PlacementStrategyProperty.builder()
 *                                 .field("field")
 *                                 .type("type")
 *                                 .build()))
 *                         .platformVersion("platformVersion")
 *                         .propagateTags("propagateTags")
 *                         .referenceId("referenceId")
 *                         .tagList(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .taskCount(123)
 *                         .build())
 *                 .httpParameters(HttpParametersProperty.builder()
 *                         .headerParameters(Map.of(
 *                                 "headerParametersKey", "headerParameters"))
 *                         .pathParameterValues(List.of("pathParameterValues"))
 *                         .queryStringParameters(Map.of(
 *                                 "queryStringParametersKey", "queryStringParameters"))
 *                         .build())
 *                 .input("input")
 *                 .inputPath("inputPath")
 *                 .inputTransformer(InputTransformerProperty.builder()
 *                         .inputTemplate("inputTemplate")
 *                         // the properties below are optional
 *                         .inputPathsMap(Map.of(
 *                                 "inputPathsMapKey", "inputPathsMap"))
 *                         .build())
 *                 .kinesisParameters(KinesisParametersProperty.builder()
 *                         .partitionKeyPath("partitionKeyPath")
 *                         .build())
 *                 .redshiftDataParameters(RedshiftDataParametersProperty.builder()
 *                         .database("database")
 *                         // the properties below are optional
 *                         .dbUser("dbUser")
 *                         .secretManagerArn("secretManagerArn")
 *                         .sql("sql")
 *                         .sqls(List.of("sqls"))
 *                         .statementName("statementName")
 *                         .withEvent(false)
 *                         .build())
 *                 .retryPolicy(RetryPolicyProperty.builder()
 *                         .maximumEventAgeInSeconds(123)
 *                         .maximumRetryAttempts(123)
 *                         .build())
 *                 .roleArn("roleArn")
 *                 .runCommandParameters(RunCommandParametersProperty.builder()
 *                         .runCommandTargets(List.of(RunCommandTargetProperty.builder()
 *                                 .key("key")
 *                                 .values(List.of("values"))
 *                                 .build()))
 *                         .build())
 *                 .sageMakerPipelineParameters(SageMakerPipelineParametersProperty.builder()
 *                         .pipelineParameterList(List.of(SageMakerPipelineParameterProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .build())
 *                 .sqsParameters(SqsParametersProperty.builder()
 *                         .messageGroupId("messageGroupId")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:55.601Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule")
public class CfnRule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.events.CfnRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.CfnRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the rule, such as <code>arn:aws:events:us-east-2:123456789012:rule/example</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The description of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The name or ARN of the event bus associated with the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEventBusName() {
        return software.amazon.jsii.Kernel.get(this, "eventBusName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name or ARN of the event bus associated with the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventBusName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "eventBusName", value);
    }

    /**
     * The event pattern of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEventPattern() {
        return software.amazon.jsii.Kernel.get(this, "eventPattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The event pattern of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventPattern(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "eventPattern", value);
    }

    /**
     * The name of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the role that is used for target invocation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the role that is used for target invocation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", value);
    }

    /**
     * The scheduling expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScheduleExpression() {
        return software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The scheduling expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduleExpression(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scheduleExpression", value);
    }

    /**
     * The state of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setState(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "state", value);
    }

    /**
     * Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTargets() {
        return software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targets", value);
    }

    /**
     * Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.events.CfnRule.TargetProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.events.CfnRule.TargetProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "targets", value);
    }
    /**
     * Contains the GraphQL operation to be parsed and executed, if the event target is an AWS AppSync API.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * AppSyncParametersProperty appSyncParametersProperty = AppSyncParametersProperty.builder()
     *         .graphQlOperation("graphQlOperation")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-appsyncparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-appsyncparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.AppSyncParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(AppSyncParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AppSyncParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The GraphQL operation; that is, the query, mutation, or subscription to be parsed and executed by the GraphQL service.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/graphql-architecture.html#graphql-operations">Operations</a> in the <em>AWS AppSync User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-appsyncparameters.html#cfn-events-rule-appsyncparameters-graphqloperation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-appsyncparameters.html#cfn-events-rule-appsyncparameters-graphqloperation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGraphQlOperation();

        /**
         * @return a {@link Builder} of {@link AppSyncParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AppSyncParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AppSyncParametersProperty> {
            java.lang.String graphQlOperation;

            /**
             * Sets the value of {@link AppSyncParametersProperty#getGraphQlOperation}
             * @param graphQlOperation The GraphQL operation; that is, the query, mutation, or subscription to be parsed and executed by the GraphQL service. This parameter is required.
             *                         For more information, see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/graphql-architecture.html#graphql-operations">Operations</a> in the <em>AWS AppSync User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder graphQlOperation(java.lang.String graphQlOperation) {
                this.graphQlOperation = graphQlOperation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AppSyncParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AppSyncParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AppSyncParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppSyncParametersProperty {
            private final java.lang.String graphQlOperation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.graphQlOperation = software.amazon.jsii.Kernel.get(this, "graphQlOperation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.graphQlOperation = java.util.Objects.requireNonNull(builder.graphQlOperation, "graphQlOperation is required");
            }

            @Override
            public final java.lang.String getGraphQlOperation() {
                return this.graphQlOperation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("graphQlOperation", om.valueToTree(this.getGraphQlOperation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.AppSyncParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AppSyncParametersProperty.Jsii$Proxy that = (AppSyncParametersProperty.Jsii$Proxy) o;

                return this.graphQlOperation.equals(that.graphQlOperation);
            }

            @Override
            public final int hashCode() {
                int result = this.graphQlOperation.hashCode();
                return result;
            }
        }
    }
    /**
     * This structure specifies the VPC subnets and security groups for the task, and whether a public IP address is to be used.
     * <p>
     * This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network mode.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * AwsVpcConfigurationProperty awsVpcConfigurationProperty = AwsVpcConfigurationProperty.builder()
     *         .subnets(List.of("subnets"))
     *         // the properties below are optional
     *         .assignPublicIp("assignPublicIp")
     *         .securityGroups(List.of("securityGroups"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-awsvpcconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-awsvpcconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.AwsVpcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AwsVpcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AwsVpcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the subnets associated with the task.
         * <p>
         * These subnets must all be in the same VPC. You can specify as many as 16 subnets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-awsvpcconfiguration.html#cfn-events-rule-awsvpcconfiguration-subnets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-awsvpcconfiguration.html#cfn-events-rule-awsvpcconfiguration-subnets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * Specifies whether the task's elastic network interface receives a public IP address.
         * <p>
         * You can specify <code>ENABLED</code> only when <code>LaunchType</code> in <code>EcsParameters</code> is set to <code>FARGATE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-awsvpcconfiguration.html#cfn-events-rule-awsvpcconfiguration-assignpublicip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-awsvpcconfiguration.html#cfn-events-rule-awsvpcconfiguration-assignpublicip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssignPublicIp() {
            return null;
        }

        /**
         * Specifies the security groups associated with the task.
         * <p>
         * These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-awsvpcconfiguration.html#cfn-events-rule-awsvpcconfiguration-securitygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-awsvpcconfiguration.html#cfn-events-rule-awsvpcconfiguration-securitygroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AwsVpcConfigurationProperty> {
            java.util.List<java.lang.String> subnets;
            java.lang.String assignPublicIp;
            java.util.List<java.lang.String> securityGroups;

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getSubnets}
             * @param subnets Specifies the subnets associated with the task. This parameter is required.
             *                These subnets must all be in the same VPC. You can specify as many as 16 subnets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getAssignPublicIp}
             * @param assignPublicIp Specifies whether the task's elastic network interface receives a public IP address.
             *                       You can specify <code>ENABLED</code> only when <code>LaunchType</code> in <code>EcsParameters</code> is set to <code>FARGATE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assignPublicIp(java.lang.String assignPublicIp) {
                this.assignPublicIp = assignPublicIp;
                return this;
            }

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getSecurityGroups}
             * @param securityGroups Specifies the security groups associated with the task.
             *                       These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AwsVpcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AwsVpcConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsVpcConfigurationProperty {
            private final java.util.List<java.lang.String> subnets;
            private final java.lang.String assignPublicIp;
            private final java.util.List<java.lang.String> securityGroups;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.assignPublicIp = software.amazon.jsii.Kernel.get(this, "assignPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
                this.assignPublicIp = builder.assignPublicIp;
                this.securityGroups = builder.securityGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            public final java.lang.String getAssignPublicIp() {
                return this.assignPublicIp;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("subnets", om.valueToTree(this.getSubnets()));
                if (this.getAssignPublicIp() != null) {
                    data.set("assignPublicIp", om.valueToTree(this.getAssignPublicIp()));
                }
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.AwsVpcConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AwsVpcConfigurationProperty.Jsii$Proxy that = (AwsVpcConfigurationProperty.Jsii$Proxy) o;

                if (!subnets.equals(that.subnets)) return false;
                if (this.assignPublicIp != null ? !this.assignPublicIp.equals(that.assignPublicIp) : that.assignPublicIp != null) return false;
                return this.securityGroups != null ? this.securityGroups.equals(that.securityGroups) : that.securityGroups == null;
            }

            @Override
            public final int hashCode() {
                int result = this.subnets.hashCode();
                result = 31 * result + (this.assignPublicIp != null ? this.assignPublicIp.hashCode() : 0);
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The array properties for the submitted job, such as the size of the array.
     * <p>
     * The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * BatchArrayPropertiesProperty batchArrayPropertiesProperty = BatchArrayPropertiesProperty.builder()
     *         .size(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batcharrayproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batcharrayproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.BatchArrayPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(BatchArrayPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BatchArrayPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The size of the array, if this is an array batch job.
         * <p>
         * Valid values are integers between 2 and 10,000.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batcharrayproperties.html#cfn-events-rule-batcharrayproperties-size">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batcharrayproperties.html#cfn-events-rule-batcharrayproperties-size</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BatchArrayPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BatchArrayPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BatchArrayPropertiesProperty> {
            java.lang.Number size;

            /**
             * Sets the value of {@link BatchArrayPropertiesProperty#getSize}
             * @param size The size of the array, if this is an array batch job.
             *             Valid values are integers between 2 and 10,000.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder size(java.lang.Number size) {
                this.size = size;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BatchArrayPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BatchArrayPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BatchArrayPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchArrayPropertiesProperty {
            private final java.lang.Number size;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.size = builder.size;
            }

            @Override
            public final java.lang.Number getSize() {
                return this.size;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSize() != null) {
                    data.set("size", om.valueToTree(this.getSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.BatchArrayPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BatchArrayPropertiesProperty.Jsii$Proxy that = (BatchArrayPropertiesProperty.Jsii$Proxy) o;

                return this.size != null ? this.size.equals(that.size) : that.size == null;
            }

            @Override
            public final int hashCode() {
                int result = this.size != null ? this.size.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The custom parameters to be used when the target is an AWS Batch job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * BatchParametersProperty batchParametersProperty = BatchParametersProperty.builder()
     *         .jobDefinition("jobDefinition")
     *         .jobName("jobName")
     *         // the properties below are optional
     *         .arrayProperties(BatchArrayPropertiesProperty.builder()
     *                 .size(123)
     *                 .build())
     *         .retryStrategy(BatchRetryStrategyProperty.builder()
     *                 .attempts(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.BatchParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(BatchParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BatchParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN or name of the job definition to use if the event target is an AWS Batch job.
         * <p>
         * This job definition must already exist.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchparameters.html#cfn-events-rule-batchparameters-jobdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchparameters.html#cfn-events-rule-batchparameters-jobdefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getJobDefinition();

        /**
         * The name to use for this execution of the job, if the target is an AWS Batch job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchparameters.html#cfn-events-rule-batchparameters-jobname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchparameters.html#cfn-events-rule-batchparameters-jobname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getJobName();

        /**
         * The array properties for the submitted job, such as the size of the array.
         * <p>
         * The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchparameters.html#cfn-events-rule-batchparameters-arrayproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchparameters.html#cfn-events-rule-batchparameters-arrayproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getArrayProperties() {
            return null;
        }

        /**
         * The retry strategy to use for failed jobs, if the target is an AWS Batch job.
         * <p>
         * The retry strategy is the number of times to retry the failed job execution. Valid values are 1–10. When you specify a retry strategy here, it overrides the retry strategy defined in the job definition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchparameters.html#cfn-events-rule-batchparameters-retrystrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchparameters.html#cfn-events-rule-batchparameters-retrystrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryStrategy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BatchParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BatchParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BatchParametersProperty> {
            java.lang.String jobDefinition;
            java.lang.String jobName;
            java.lang.Object arrayProperties;
            java.lang.Object retryStrategy;

            /**
             * Sets the value of {@link BatchParametersProperty#getJobDefinition}
             * @param jobDefinition The ARN or name of the job definition to use if the event target is an AWS Batch job. This parameter is required.
             *                      This job definition must already exist.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobDefinition(java.lang.String jobDefinition) {
                this.jobDefinition = jobDefinition;
                return this;
            }

            /**
             * Sets the value of {@link BatchParametersProperty#getJobName}
             * @param jobName The name to use for this execution of the job, if the target is an AWS Batch job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobName(java.lang.String jobName) {
                this.jobName = jobName;
                return this;
            }

            /**
             * Sets the value of {@link BatchParametersProperty#getArrayProperties}
             * @param arrayProperties The array properties for the submitted job, such as the size of the array.
             *                        The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arrayProperties(software.amazon.awscdk.IResolvable arrayProperties) {
                this.arrayProperties = arrayProperties;
                return this;
            }

            /**
             * Sets the value of {@link BatchParametersProperty#getArrayProperties}
             * @param arrayProperties The array properties for the submitted job, such as the size of the array.
             *                        The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arrayProperties(software.amazon.awscdk.services.events.CfnRule.BatchArrayPropertiesProperty arrayProperties) {
                this.arrayProperties = arrayProperties;
                return this;
            }

            /**
             * Sets the value of {@link BatchParametersProperty#getRetryStrategy}
             * @param retryStrategy The retry strategy to use for failed jobs, if the target is an AWS Batch job.
             *                      The retry strategy is the number of times to retry the failed job execution. Valid values are 1–10. When you specify a retry strategy here, it overrides the retry strategy defined in the job definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryStrategy(software.amazon.awscdk.IResolvable retryStrategy) {
                this.retryStrategy = retryStrategy;
                return this;
            }

            /**
             * Sets the value of {@link BatchParametersProperty#getRetryStrategy}
             * @param retryStrategy The retry strategy to use for failed jobs, if the target is an AWS Batch job.
             *                      The retry strategy is the number of times to retry the failed job execution. Valid values are 1–10. When you specify a retry strategy here, it overrides the retry strategy defined in the job definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryStrategy(software.amazon.awscdk.services.events.CfnRule.BatchRetryStrategyProperty retryStrategy) {
                this.retryStrategy = retryStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BatchParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BatchParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BatchParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchParametersProperty {
            private final java.lang.String jobDefinition;
            private final java.lang.String jobName;
            private final java.lang.Object arrayProperties;
            private final java.lang.Object retryStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jobDefinition = software.amazon.jsii.Kernel.get(this, "jobDefinition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.jobName = software.amazon.jsii.Kernel.get(this, "jobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.arrayProperties = software.amazon.jsii.Kernel.get(this, "arrayProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryStrategy = software.amazon.jsii.Kernel.get(this, "retryStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jobDefinition = java.util.Objects.requireNonNull(builder.jobDefinition, "jobDefinition is required");
                this.jobName = java.util.Objects.requireNonNull(builder.jobName, "jobName is required");
                this.arrayProperties = builder.arrayProperties;
                this.retryStrategy = builder.retryStrategy;
            }

            @Override
            public final java.lang.String getJobDefinition() {
                return this.jobDefinition;
            }

            @Override
            public final java.lang.String getJobName() {
                return this.jobName;
            }

            @Override
            public final java.lang.Object getArrayProperties() {
                return this.arrayProperties;
            }

            @Override
            public final java.lang.Object getRetryStrategy() {
                return this.retryStrategy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("jobDefinition", om.valueToTree(this.getJobDefinition()));
                data.set("jobName", om.valueToTree(this.getJobName()));
                if (this.getArrayProperties() != null) {
                    data.set("arrayProperties", om.valueToTree(this.getArrayProperties()));
                }
                if (this.getRetryStrategy() != null) {
                    data.set("retryStrategy", om.valueToTree(this.getRetryStrategy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.BatchParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BatchParametersProperty.Jsii$Proxy that = (BatchParametersProperty.Jsii$Proxy) o;

                if (!jobDefinition.equals(that.jobDefinition)) return false;
                if (!jobName.equals(that.jobName)) return false;
                if (this.arrayProperties != null ? !this.arrayProperties.equals(that.arrayProperties) : that.arrayProperties != null) return false;
                return this.retryStrategy != null ? this.retryStrategy.equals(that.retryStrategy) : that.retryStrategy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.jobDefinition.hashCode();
                result = 31 * result + (this.jobName.hashCode());
                result = 31 * result + (this.arrayProperties != null ? this.arrayProperties.hashCode() : 0);
                result = 31 * result + (this.retryStrategy != null ? this.retryStrategy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The retry strategy to use for failed jobs, if the target is an AWS Batch job.
     * <p>
     * If you specify a retry strategy here, it overrides the retry strategy defined in the job definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * BatchRetryStrategyProperty batchRetryStrategyProperty = BatchRetryStrategyProperty.builder()
     *         .attempts(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchretrystrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchretrystrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.BatchRetryStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(BatchRetryStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BatchRetryStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of times to attempt to retry, if the job fails.
         * <p>
         * Valid values are 1–10.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchretrystrategy.html#cfn-events-rule-batchretrystrategy-attempts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-batchretrystrategy.html#cfn-events-rule-batchretrystrategy-attempts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAttempts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BatchRetryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BatchRetryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BatchRetryStrategyProperty> {
            java.lang.Number attempts;

            /**
             * Sets the value of {@link BatchRetryStrategyProperty#getAttempts}
             * @param attempts The number of times to attempt to retry, if the job fails.
             *                 Valid values are 1–10.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attempts(java.lang.Number attempts) {
                this.attempts = attempts;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BatchRetryStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BatchRetryStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BatchRetryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchRetryStrategyProperty {
            private final java.lang.Number attempts;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attempts = software.amazon.jsii.Kernel.get(this, "attempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attempts = builder.attempts;
            }

            @Override
            public final java.lang.Number getAttempts() {
                return this.attempts;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttempts() != null) {
                    data.set("attempts", om.valueToTree(this.getAttempts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.BatchRetryStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BatchRetryStrategyProperty.Jsii$Proxy that = (BatchRetryStrategyProperty.Jsii$Proxy) o;

                return this.attempts != null ? this.attempts.equals(that.attempts) : that.attempts == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attempts != null ? this.attempts.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The details of a capacity provider strategy.
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CapacityProviderStrategyItem.html">CapacityProviderStrategyItem</a> in the Amazon ECS API Reference.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * CapacityProviderStrategyItemProperty capacityProviderStrategyItemProperty = CapacityProviderStrategyItemProperty.builder()
     *         .capacityProvider("capacityProvider")
     *         // the properties below are optional
     *         .base(123)
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-capacityproviderstrategyitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-capacityproviderstrategyitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.CapacityProviderStrategyItemProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityProviderStrategyItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityProviderStrategyItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The short name of the capacity provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-capacityproviderstrategyitem.html#cfn-events-rule-capacityproviderstrategyitem-capacityprovider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-capacityproviderstrategyitem.html#cfn-events-rule-capacityproviderstrategyitem-capacityprovider</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCapacityProvider();

        /**
         * The base value designates how many tasks, at a minimum, to run on the specified capacity provider.
         * <p>
         * Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-capacityproviderstrategyitem.html#cfn-events-rule-capacityproviderstrategyitem-base">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-capacityproviderstrategyitem.html#cfn-events-rule-capacityproviderstrategyitem-base</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBase() {
            return null;
        }

        /**
         * The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider.
         * <p>
         * The weight value is taken into consideration after the base value, if defined, is satisfied.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-capacityproviderstrategyitem.html#cfn-events-rule-capacityproviderstrategyitem-weight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-capacityproviderstrategyitem.html#cfn-events-rule-capacityproviderstrategyitem-weight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityProviderStrategyItemProperty> {
            java.lang.String capacityProvider;
            java.lang.Number base;
            java.lang.Number weight;

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getCapacityProvider}
             * @param capacityProvider The short name of the capacity provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityProvider(java.lang.String capacityProvider) {
                this.capacityProvider = capacityProvider;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getBase}
             * @param base The base value designates how many tasks, at a minimum, to run on the specified capacity provider.
             *             Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder base(java.lang.Number base) {
                this.base = base;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getWeight}
             * @param weight The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider.
             *               The weight value is taken into consideration after the base value, if defined, is satisfied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityProviderStrategyItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityProviderStrategyItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityProviderStrategyItemProperty {
            private final java.lang.String capacityProvider;
            private final java.lang.Number base;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capacityProvider = software.amazon.jsii.Kernel.get(this, "capacityProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.base = software.amazon.jsii.Kernel.get(this, "base", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityProvider = java.util.Objects.requireNonNull(builder.capacityProvider, "capacityProvider is required");
                this.base = builder.base;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.String getCapacityProvider() {
                return this.capacityProvider;
            }

            @Override
            public final java.lang.Number getBase() {
                return this.base;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("capacityProvider", om.valueToTree(this.getCapacityProvider()));
                if (this.getBase() != null) {
                    data.set("base", om.valueToTree(this.getBase()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.CapacityProviderStrategyItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityProviderStrategyItemProperty.Jsii$Proxy that = (CapacityProviderStrategyItemProperty.Jsii$Proxy) o;

                if (!capacityProvider.equals(that.capacityProvider)) return false;
                if (this.base != null ? !this.base.equals(that.base) : that.base != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.capacityProvider.hashCode();
                result = 31 * result + (this.base != null ? this.base.hashCode() : 0);
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A <code>DeadLetterConfig</code> object that contains information about a dead-letter queue configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * DeadLetterConfigProperty deadLetterConfigProperty = DeadLetterConfigProperty.builder()
     *         .arn("arn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-deadletterconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-deadletterconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.DeadLetterConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DeadLetterConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeadLetterConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the SQS queue specified as the target for the dead-letter queue.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-deadletterconfig.html#cfn-events-rule-deadletterconfig-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-deadletterconfig.html#cfn-events-rule-deadletterconfig-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeadLetterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeadLetterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeadLetterConfigProperty> {
            java.lang.String arn;

            /**
             * Sets the value of {@link DeadLetterConfigProperty#getArn}
             * @param arn The ARN of the SQS queue specified as the target for the dead-letter queue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeadLetterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeadLetterConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeadLetterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeadLetterConfigProperty {
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.DeadLetterConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeadLetterConfigProperty.Jsii$Proxy that = (DeadLetterConfigProperty.Jsii$Proxy) o;

                return this.arn != null ? this.arn.equals(that.arn) : that.arn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The custom parameters to be used when the target is an Amazon ECS task.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * EcsParametersProperty ecsParametersProperty = EcsParametersProperty.builder()
     *         .taskDefinitionArn("taskDefinitionArn")
     *         // the properties below are optional
     *         .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
     *                 .capacityProvider("capacityProvider")
     *                 // the properties below are optional
     *                 .base(123)
     *                 .weight(123)
     *                 .build()))
     *         .enableEcsManagedTags(false)
     *         .enableExecuteCommand(false)
     *         .group("group")
     *         .launchType("launchType")
     *         .networkConfiguration(NetworkConfigurationProperty.builder()
     *                 .awsVpcConfiguration(AwsVpcConfigurationProperty.builder()
     *                         .subnets(List.of("subnets"))
     *                         // the properties below are optional
     *                         .assignPublicIp("assignPublicIp")
     *                         .securityGroups(List.of("securityGroups"))
     *                         .build())
     *                 .build())
     *         .placementConstraints(List.of(PlacementConstraintProperty.builder()
     *                 .expression("expression")
     *                 .type("type")
     *                 .build()))
     *         .placementStrategies(List.of(PlacementStrategyProperty.builder()
     *                 .field("field")
     *                 .type("type")
     *                 .build()))
     *         .platformVersion("platformVersion")
     *         .propagateTags("propagateTags")
     *         .referenceId("referenceId")
     *         .tagList(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .taskCount(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.EcsParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(EcsParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EcsParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the task definition to use if the event target is an Amazon ECS task.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskdefinitionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTaskDefinitionArn();

        /**
         * The capacity provider strategy to use for the task.
         * <p>
         * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or launchType is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-capacityproviderstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-capacityproviderstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityProviderStrategy() {
            return null;
        }

        /**
         * Specifies whether to enable Amazon ECS managed tags for the task.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the Amazon Elastic Container Service Developer Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-enableecsmanagedtags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-enableecsmanagedtags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableEcsManagedTags() {
            return null;
        }

        /**
         * Whether or not to enable the execute command functionality for the containers in this task.
         * <p>
         * If true, this enables execute command functionality on all containers in the task.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-enableexecutecommand">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-enableexecutecommand</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableExecuteCommand() {
            return null;
        }

        /**
         * Specifies an ECS task group for the task.
         * <p>
         * The maximum length is 255 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-group">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-group</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroup() {
            return null;
        }

        /**
         * Specifies the launch type on which your task is running.
         * <p>
         * The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The <code>FARGATE</code> value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html">AWS Fargate on Amazon ECS</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-launchtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-launchtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchType() {
            return null;
        }

        /**
         * Use this structure if the Amazon ECS task uses the <code>awsvpc</code> network mode.
         * <p>
         * This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if <code>LaunchType</code> is <code>FARGATE</code> because the <code>awsvpc</code> mode is required for Fargate tasks.
         * <p>
         * If you specify <code>NetworkConfiguration</code> when the target ECS task does not use the <code>awsvpc</code> network mode, the task fails.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-networkconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
            return null;
        }

        /**
         * An array of placement constraint objects to use for the task.
         * <p>
         * You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-placementconstraints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-placementconstraints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlacementConstraints() {
            return null;
        }

        /**
         * The placement strategy objects to use for the task.
         * <p>
         * You can specify a maximum of five strategy rules per task.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-placementstrategies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-placementstrategies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlacementStrategies() {
            return null;
        }

        /**
         * Specifies the platform version for the task.
         * <p>
         * Specify only the numeric portion of the platform version, such as <code>1.1.0</code> .
         * <p>
         * This structure is used only if <code>LaunchType</code> is <code>FARGATE</code> . For more information about valid platform versions, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-platformversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-platformversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPlatformVersion() {
            return null;
        }

        /**
         * Specifies whether to propagate the tags from the task definition to the task.
         * <p>
         * If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-propagatetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-propagatetags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropagateTags() {
            return null;
        }

        /**
         * The reference ID to use for the task.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-referenceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-referenceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReferenceId() {
            return null;
        }

        /**
         * The metadata that you apply to the task to help you categorize and organize them.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags">RunTask</a> in the Amazon ECS API Reference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taglist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taglist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagList() {
            return null;
        }

        /**
         * The number of tasks to create based on <code>TaskDefinition</code> .
         * <p>
         * The default is 1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-ecsparameters.html#cfn-events-rule-ecsparameters-taskcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTaskCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EcsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EcsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EcsParametersProperty> {
            java.lang.String taskDefinitionArn;
            java.lang.Object capacityProviderStrategy;
            java.lang.Object enableEcsManagedTags;
            java.lang.Object enableExecuteCommand;
            java.lang.String group;
            java.lang.String launchType;
            java.lang.Object networkConfiguration;
            java.lang.Object placementConstraints;
            java.lang.Object placementStrategies;
            java.lang.String platformVersion;
            java.lang.String propagateTags;
            java.lang.String referenceId;
            java.lang.Object tagList;
            java.lang.Number taskCount;

            /**
             * Sets the value of {@link EcsParametersProperty#getTaskDefinitionArn}
             * @param taskDefinitionArn The ARN of the task definition to use if the event target is an Amazon ECS task. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskDefinitionArn(java.lang.String taskDefinitionArn) {
                this.taskDefinitionArn = taskDefinitionArn;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getCapacityProviderStrategy}
             * @param capacityProviderStrategy The capacity provider strategy to use for the task.
             *                                 If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or launchType is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityProviderStrategy(software.amazon.awscdk.IResolvable capacityProviderStrategy) {
                this.capacityProviderStrategy = capacityProviderStrategy;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getCapacityProviderStrategy}
             * @param capacityProviderStrategy The capacity provider strategy to use for the task.
             *                                 If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or launchType is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityProviderStrategy(java.util.List<? extends java.lang.Object> capacityProviderStrategy) {
                this.capacityProviderStrategy = capacityProviderStrategy;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getEnableEcsManagedTags}
             * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the task.
             *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the Amazon Elastic Container Service Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableEcsManagedTags(java.lang.Boolean enableEcsManagedTags) {
                this.enableEcsManagedTags = enableEcsManagedTags;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getEnableEcsManagedTags}
             * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the task.
             *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the Amazon Elastic Container Service Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableEcsManagedTags(software.amazon.awscdk.IResolvable enableEcsManagedTags) {
                this.enableEcsManagedTags = enableEcsManagedTags;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getEnableExecuteCommand}
             * @param enableExecuteCommand Whether or not to enable the execute command functionality for the containers in this task.
             *                             If true, this enables execute command functionality on all containers in the task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableExecuteCommand(java.lang.Boolean enableExecuteCommand) {
                this.enableExecuteCommand = enableExecuteCommand;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getEnableExecuteCommand}
             * @param enableExecuteCommand Whether or not to enable the execute command functionality for the containers in this task.
             *                             If true, this enables execute command functionality on all containers in the task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableExecuteCommand(software.amazon.awscdk.IResolvable enableExecuteCommand) {
                this.enableExecuteCommand = enableExecuteCommand;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getGroup}
             * @param group Specifies an ECS task group for the task.
             *              The maximum length is 255 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder group(java.lang.String group) {
                this.group = group;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getLaunchType}
             * @param launchType Specifies the launch type on which your task is running.
             *                   The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The <code>FARGATE</code> value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html">AWS Fargate on Amazon ECS</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchType(java.lang.String launchType) {
                this.launchType = launchType;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getNetworkConfiguration}
             * @param networkConfiguration Use this structure if the Amazon ECS task uses the <code>awsvpc</code> network mode.
             *                             This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if <code>LaunchType</code> is <code>FARGATE</code> because the <code>awsvpc</code> mode is required for Fargate tasks.
             *                             <p>
             *                             If you specify <code>NetworkConfiguration</code> when the target ECS task does not use the <code>awsvpc</code> network mode, the task fails.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.IResolvable networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getNetworkConfiguration}
             * @param networkConfiguration Use this structure if the Amazon ECS task uses the <code>awsvpc</code> network mode.
             *                             This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if <code>LaunchType</code> is <code>FARGATE</code> because the <code>awsvpc</code> mode is required for Fargate tasks.
             *                             <p>
             *                             If you specify <code>NetworkConfiguration</code> when the target ECS task does not use the <code>awsvpc</code> network mode, the task fails.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.services.events.CfnRule.NetworkConfigurationProperty networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getPlacementConstraints}
             * @param placementConstraints An array of placement constraint objects to use for the task.
             *                             You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placementConstraints(software.amazon.awscdk.IResolvable placementConstraints) {
                this.placementConstraints = placementConstraints;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getPlacementConstraints}
             * @param placementConstraints An array of placement constraint objects to use for the task.
             *                             You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placementConstraints(java.util.List<? extends java.lang.Object> placementConstraints) {
                this.placementConstraints = placementConstraints;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getPlacementStrategies}
             * @param placementStrategies The placement strategy objects to use for the task.
             *                            You can specify a maximum of five strategy rules per task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placementStrategies(software.amazon.awscdk.IResolvable placementStrategies) {
                this.placementStrategies = placementStrategies;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getPlacementStrategies}
             * @param placementStrategies The placement strategy objects to use for the task.
             *                            You can specify a maximum of five strategy rules per task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placementStrategies(java.util.List<? extends java.lang.Object> placementStrategies) {
                this.placementStrategies = placementStrategies;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getPlatformVersion}
             * @param platformVersion Specifies the platform version for the task.
             *                        Specify only the numeric portion of the platform version, such as <code>1.1.0</code> .
             *                        <p>
             *                        This structure is used only if <code>LaunchType</code> is <code>FARGATE</code> . For more information about valid platform versions, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder platformVersion(java.lang.String platformVersion) {
                this.platformVersion = platformVersion;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getPropagateTags}
             * @param propagateTags Specifies whether to propagate the tags from the task definition to the task.
             *                      If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propagateTags(java.lang.String propagateTags) {
                this.propagateTags = propagateTags;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getReferenceId}
             * @param referenceId The reference ID to use for the task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referenceId(java.lang.String referenceId) {
                this.referenceId = referenceId;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getTagList}
             * @param tagList The metadata that you apply to the task to help you categorize and organize them.
             *                Each tag consists of a key and an optional value, both of which you define. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags">RunTask</a> in the Amazon ECS API Reference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagList(software.amazon.awscdk.IResolvable tagList) {
                this.tagList = tagList;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getTagList}
             * @param tagList The metadata that you apply to the task to help you categorize and organize them.
             *                Each tag consists of a key and an optional value, both of which you define. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags">RunTask</a> in the Amazon ECS API Reference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagList(java.util.List<? extends java.lang.Object> tagList) {
                this.tagList = tagList;
                return this;
            }

            /**
             * Sets the value of {@link EcsParametersProperty#getTaskCount}
             * @param taskCount The number of tasks to create based on <code>TaskDefinition</code> .
             *                  The default is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskCount(java.lang.Number taskCount) {
                this.taskCount = taskCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EcsParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EcsParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EcsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsParametersProperty {
            private final java.lang.String taskDefinitionArn;
            private final java.lang.Object capacityProviderStrategy;
            private final java.lang.Object enableEcsManagedTags;
            private final java.lang.Object enableExecuteCommand;
            private final java.lang.String group;
            private final java.lang.String launchType;
            private final java.lang.Object networkConfiguration;
            private final java.lang.Object placementConstraints;
            private final java.lang.Object placementStrategies;
            private final java.lang.String platformVersion;
            private final java.lang.String propagateTags;
            private final java.lang.String referenceId;
            private final java.lang.Object tagList;
            private final java.lang.Number taskCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.taskDefinitionArn = software.amazon.jsii.Kernel.get(this, "taskDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.capacityProviderStrategy = software.amazon.jsii.Kernel.get(this, "capacityProviderStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableEcsManagedTags = software.amazon.jsii.Kernel.get(this, "enableEcsManagedTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableExecuteCommand = software.amazon.jsii.Kernel.get(this, "enableExecuteCommand", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.group = software.amazon.jsii.Kernel.get(this, "group", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchType = software.amazon.jsii.Kernel.get(this, "launchType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkConfiguration = software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.placementConstraints = software.amazon.jsii.Kernel.get(this, "placementConstraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.placementStrategies = software.amazon.jsii.Kernel.get(this, "placementStrategies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.platformVersion = software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.referenceId = software.amazon.jsii.Kernel.get(this, "referenceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagList = software.amazon.jsii.Kernel.get(this, "tagList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.taskCount = software.amazon.jsii.Kernel.get(this, "taskCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.taskDefinitionArn = java.util.Objects.requireNonNull(builder.taskDefinitionArn, "taskDefinitionArn is required");
                this.capacityProviderStrategy = builder.capacityProviderStrategy;
                this.enableEcsManagedTags = builder.enableEcsManagedTags;
                this.enableExecuteCommand = builder.enableExecuteCommand;
                this.group = builder.group;
                this.launchType = builder.launchType;
                this.networkConfiguration = builder.networkConfiguration;
                this.placementConstraints = builder.placementConstraints;
                this.placementStrategies = builder.placementStrategies;
                this.platformVersion = builder.platformVersion;
                this.propagateTags = builder.propagateTags;
                this.referenceId = builder.referenceId;
                this.tagList = builder.tagList;
                this.taskCount = builder.taskCount;
            }

            @Override
            public final java.lang.String getTaskDefinitionArn() {
                return this.taskDefinitionArn;
            }

            @Override
            public final java.lang.Object getCapacityProviderStrategy() {
                return this.capacityProviderStrategy;
            }

            @Override
            public final java.lang.Object getEnableEcsManagedTags() {
                return this.enableEcsManagedTags;
            }

            @Override
            public final java.lang.Object getEnableExecuteCommand() {
                return this.enableExecuteCommand;
            }

            @Override
            public final java.lang.String getGroup() {
                return this.group;
            }

            @Override
            public final java.lang.String getLaunchType() {
                return this.launchType;
            }

            @Override
            public final java.lang.Object getNetworkConfiguration() {
                return this.networkConfiguration;
            }

            @Override
            public final java.lang.Object getPlacementConstraints() {
                return this.placementConstraints;
            }

            @Override
            public final java.lang.Object getPlacementStrategies() {
                return this.placementStrategies;
            }

            @Override
            public final java.lang.String getPlatformVersion() {
                return this.platformVersion;
            }

            @Override
            public final java.lang.String getPropagateTags() {
                return this.propagateTags;
            }

            @Override
            public final java.lang.String getReferenceId() {
                return this.referenceId;
            }

            @Override
            public final java.lang.Object getTagList() {
                return this.tagList;
            }

            @Override
            public final java.lang.Number getTaskCount() {
                return this.taskCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("taskDefinitionArn", om.valueToTree(this.getTaskDefinitionArn()));
                if (this.getCapacityProviderStrategy() != null) {
                    data.set("capacityProviderStrategy", om.valueToTree(this.getCapacityProviderStrategy()));
                }
                if (this.getEnableEcsManagedTags() != null) {
                    data.set("enableEcsManagedTags", om.valueToTree(this.getEnableEcsManagedTags()));
                }
                if (this.getEnableExecuteCommand() != null) {
                    data.set("enableExecuteCommand", om.valueToTree(this.getEnableExecuteCommand()));
                }
                if (this.getGroup() != null) {
                    data.set("group", om.valueToTree(this.getGroup()));
                }
                if (this.getLaunchType() != null) {
                    data.set("launchType", om.valueToTree(this.getLaunchType()));
                }
                if (this.getNetworkConfiguration() != null) {
                    data.set("networkConfiguration", om.valueToTree(this.getNetworkConfiguration()));
                }
                if (this.getPlacementConstraints() != null) {
                    data.set("placementConstraints", om.valueToTree(this.getPlacementConstraints()));
                }
                if (this.getPlacementStrategies() != null) {
                    data.set("placementStrategies", om.valueToTree(this.getPlacementStrategies()));
                }
                if (this.getPlatformVersion() != null) {
                    data.set("platformVersion", om.valueToTree(this.getPlatformVersion()));
                }
                if (this.getPropagateTags() != null) {
                    data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
                }
                if (this.getReferenceId() != null) {
                    data.set("referenceId", om.valueToTree(this.getReferenceId()));
                }
                if (this.getTagList() != null) {
                    data.set("tagList", om.valueToTree(this.getTagList()));
                }
                if (this.getTaskCount() != null) {
                    data.set("taskCount", om.valueToTree(this.getTaskCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.EcsParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EcsParametersProperty.Jsii$Proxy that = (EcsParametersProperty.Jsii$Proxy) o;

                if (!taskDefinitionArn.equals(that.taskDefinitionArn)) return false;
                if (this.capacityProviderStrategy != null ? !this.capacityProviderStrategy.equals(that.capacityProviderStrategy) : that.capacityProviderStrategy != null) return false;
                if (this.enableEcsManagedTags != null ? !this.enableEcsManagedTags.equals(that.enableEcsManagedTags) : that.enableEcsManagedTags != null) return false;
                if (this.enableExecuteCommand != null ? !this.enableExecuteCommand.equals(that.enableExecuteCommand) : that.enableExecuteCommand != null) return false;
                if (this.group != null ? !this.group.equals(that.group) : that.group != null) return false;
                if (this.launchType != null ? !this.launchType.equals(that.launchType) : that.launchType != null) return false;
                if (this.networkConfiguration != null ? !this.networkConfiguration.equals(that.networkConfiguration) : that.networkConfiguration != null) return false;
                if (this.placementConstraints != null ? !this.placementConstraints.equals(that.placementConstraints) : that.placementConstraints != null) return false;
                if (this.placementStrategies != null ? !this.placementStrategies.equals(that.placementStrategies) : that.placementStrategies != null) return false;
                if (this.platformVersion != null ? !this.platformVersion.equals(that.platformVersion) : that.platformVersion != null) return false;
                if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
                if (this.referenceId != null ? !this.referenceId.equals(that.referenceId) : that.referenceId != null) return false;
                if (this.tagList != null ? !this.tagList.equals(that.tagList) : that.tagList != null) return false;
                return this.taskCount != null ? this.taskCount.equals(that.taskCount) : that.taskCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.taskDefinitionArn.hashCode();
                result = 31 * result + (this.capacityProviderStrategy != null ? this.capacityProviderStrategy.hashCode() : 0);
                result = 31 * result + (this.enableEcsManagedTags != null ? this.enableEcsManagedTags.hashCode() : 0);
                result = 31 * result + (this.enableExecuteCommand != null ? this.enableExecuteCommand.hashCode() : 0);
                result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
                result = 31 * result + (this.launchType != null ? this.launchType.hashCode() : 0);
                result = 31 * result + (this.networkConfiguration != null ? this.networkConfiguration.hashCode() : 0);
                result = 31 * result + (this.placementConstraints != null ? this.placementConstraints.hashCode() : 0);
                result = 31 * result + (this.placementStrategies != null ? this.placementStrategies.hashCode() : 0);
                result = 31 * result + (this.platformVersion != null ? this.platformVersion.hashCode() : 0);
                result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
                result = 31 * result + (this.referenceId != null ? this.referenceId.hashCode() : 0);
                result = 31 * result + (this.tagList != null ? this.tagList.hashCode() : 0);
                result = 31 * result + (this.taskCount != null ? this.taskCount.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * These are custom parameter to be used when the target is an API Gateway APIs or EventBridge ApiDestinations.
     * <p>
     * In the latter case, these are merged with any InvocationParameters specified on the Connection, with any values from the Connection taking precedence.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * HttpParametersProperty httpParametersProperty = HttpParametersProperty.builder()
     *         .headerParameters(Map.of(
     *                 "headerParametersKey", "headerParameters"))
     *         .pathParameterValues(List.of("pathParameterValues"))
     *         .queryStringParameters(Map.of(
     *                 "queryStringParametersKey", "queryStringParameters"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-httpparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-httpparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.HttpParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The headers that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-httpparameters.html#cfn-events-rule-httpparameters-headerparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-httpparameters.html#cfn-events-rule-httpparameters-headerparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeaderParameters() {
            return null;
        }

        /**
         * The path parameter values to be used to populate API Gateway API or EventBridge ApiDestination path wildcards ("*").
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-httpparameters.html#cfn-events-rule-httpparameters-pathparametervalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-httpparameters.html#cfn-events-rule-httpparameters-pathparametervalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPathParameterValues() {
            return null;
        }

        /**
         * The query string keys/values that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-httpparameters.html#cfn-events-rule-httpparameters-querystringparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-httpparameters.html#cfn-events-rule-httpparameters-querystringparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryStringParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpParametersProperty> {
            java.lang.Object headerParameters;
            java.util.List<java.lang.String> pathParameterValues;
            java.lang.Object queryStringParameters;

            /**
             * Sets the value of {@link HttpParametersProperty#getHeaderParameters}
             * @param headerParameters The headers that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerParameters(software.amazon.awscdk.IResolvable headerParameters) {
                this.headerParameters = headerParameters;
                return this;
            }

            /**
             * Sets the value of {@link HttpParametersProperty#getHeaderParameters}
             * @param headerParameters The headers that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerParameters(java.util.Map<java.lang.String, java.lang.String> headerParameters) {
                this.headerParameters = headerParameters;
                return this;
            }

            /**
             * Sets the value of {@link HttpParametersProperty#getPathParameterValues}
             * @param pathParameterValues The path parameter values to be used to populate API Gateway API or EventBridge ApiDestination path wildcards ("*").
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pathParameterValues(java.util.List<java.lang.String> pathParameterValues) {
                this.pathParameterValues = pathParameterValues;
                return this;
            }

            /**
             * Sets the value of {@link HttpParametersProperty#getQueryStringParameters}
             * @param queryStringParameters The query string keys/values that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringParameters(software.amazon.awscdk.IResolvable queryStringParameters) {
                this.queryStringParameters = queryStringParameters;
                return this;
            }

            /**
             * Sets the value of {@link HttpParametersProperty#getQueryStringParameters}
             * @param queryStringParameters The query string keys/values that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringParameters(java.util.Map<java.lang.String, java.lang.String> queryStringParameters) {
                this.queryStringParameters = queryStringParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpParametersProperty {
            private final java.lang.Object headerParameters;
            private final java.util.List<java.lang.String> pathParameterValues;
            private final java.lang.Object queryStringParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.headerParameters = software.amazon.jsii.Kernel.get(this, "headerParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pathParameterValues = software.amazon.jsii.Kernel.get(this, "pathParameterValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.queryStringParameters = software.amazon.jsii.Kernel.get(this, "queryStringParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.headerParameters = builder.headerParameters;
                this.pathParameterValues = builder.pathParameterValues;
                this.queryStringParameters = builder.queryStringParameters;
            }

            @Override
            public final java.lang.Object getHeaderParameters() {
                return this.headerParameters;
            }

            @Override
            public final java.util.List<java.lang.String> getPathParameterValues() {
                return this.pathParameterValues;
            }

            @Override
            public final java.lang.Object getQueryStringParameters() {
                return this.queryStringParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHeaderParameters() != null) {
                    data.set("headerParameters", om.valueToTree(this.getHeaderParameters()));
                }
                if (this.getPathParameterValues() != null) {
                    data.set("pathParameterValues", om.valueToTree(this.getPathParameterValues()));
                }
                if (this.getQueryStringParameters() != null) {
                    data.set("queryStringParameters", om.valueToTree(this.getQueryStringParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.HttpParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpParametersProperty.Jsii$Proxy that = (HttpParametersProperty.Jsii$Proxy) o;

                if (this.headerParameters != null ? !this.headerParameters.equals(that.headerParameters) : that.headerParameters != null) return false;
                if (this.pathParameterValues != null ? !this.pathParameterValues.equals(that.pathParameterValues) : that.pathParameterValues != null) return false;
                return this.queryStringParameters != null ? this.queryStringParameters.equals(that.queryStringParameters) : that.queryStringParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.headerParameters != null ? this.headerParameters.hashCode() : 0;
                result = 31 * result + (this.pathParameterValues != null ? this.pathParameterValues.hashCode() : 0);
                result = 31 * result + (this.queryStringParameters != null ? this.queryStringParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the parameters needed for you to provide custom input to a target based on one or more pieces of data extracted from the event.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * InputTransformerProperty inputTransformerProperty = InputTransformerProperty.builder()
     *         .inputTemplate("inputTemplate")
     *         // the properties below are optional
     *         .inputPathsMap(Map.of(
     *                 "inputPathsMapKey", "inputPathsMap"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.InputTransformerProperty")
    @software.amazon.jsii.Jsii.Proxy(InputTransformerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputTransformerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Input template where you specify placeholders that will be filled with the values of the keys from <code>InputPathsMap</code> to customize the data sent to the target.
         * <p>
         * Enclose each <code>InputPathsMaps</code> value in brackets: &lt; <em>value</em> &gt;
         * <p>
         * If <code>InputTemplate</code> is a JSON object (surrounded by curly braces), the following restrictions apply:
         * <p>
         * <ul>
         * <li>The placeholder cannot be used as an object key.</li>
         * </ul>
         * <p>
         * The following example shows the syntax for using <code>InputPathsMap</code> and <code>InputTemplate</code> .
         * <p>
         * <code>"InputTransformer":</code>
         * <p>
         * <code>{</code>
         * <p>
         * <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code>
         * <p>
         * <code>"InputTemplate": "&lt;instance&gt; is in state &lt;status&gt;"</code>
         * <p>
         * <code>}</code>
         * <p>
         * To have the <code>InputTemplate</code> include quote marks within a JSON string, escape each quote marks with a slash, as in the following example:
         * <p>
         * <code>"InputTransformer":</code>
         * <p>
         * <code>{</code>
         * <p>
         * <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code>
         * <p>
         * <code>"InputTemplate": "&lt;instance&gt; is in state \"&lt;status&gt;\""</code>
         * <p>
         * <code>}</code>
         * <p>
         * The <code>InputTemplate</code> can also be valid JSON with varibles in quotes or out, as in the following example:
         * <p>
         * <code>"InputTransformer":</code>
         * <p>
         * <code>{</code>
         * <p>
         * <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code>
         * <p>
         * <code>"InputTemplate": '{"myInstance": &lt;instance&gt;,"myStatus": "&lt;instance&gt; is in state \"&lt;status&gt;\""}'</code>
         * <p>
         * <code>}</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputtemplate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInputTemplate();

        /**
         * Map of JSON paths to be extracted from the event.
         * <p>
         * You can then insert these in the template in <code>InputTemplate</code> to produce the output you want to be sent to the target.
         * <p>
         * <code>InputPathsMap</code> is an array key-value pairs, where each value is a valid JSON path. You can have as many as 100 key-value pairs. You must use JSON dot notation, not bracket notation.
         * <p>
         * The keys cannot start with " AWS ."
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-inputtransformer.html#cfn-events-rule-inputtransformer-inputpathsmap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputPathsMap() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputTransformerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputTransformerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputTransformerProperty> {
            java.lang.String inputTemplate;
            java.lang.Object inputPathsMap;

            /**
             * Sets the value of {@link InputTransformerProperty#getInputTemplate}
             * @param inputTemplate Input template where you specify placeholders that will be filled with the values of the keys from <code>InputPathsMap</code> to customize the data sent to the target. This parameter is required.
             *                      Enclose each <code>InputPathsMaps</code> value in brackets: &lt; <em>value</em> &gt;
             *                      <p>
             *                      If <code>InputTemplate</code> is a JSON object (surrounded by curly braces), the following restrictions apply:
             *                      <p>
             *                      <ul>
             *                      <li>The placeholder cannot be used as an object key.</li>
             *                      </ul>
             *                      <p>
             *                      The following example shows the syntax for using <code>InputPathsMap</code> and <code>InputTemplate</code> .
             *                      <p>
             *                      <code>"InputTransformer":</code>
             *                      <p>
             *                      <code>{</code>
             *                      <p>
             *                      <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code>
             *                      <p>
             *                      <code>"InputTemplate": "&lt;instance&gt; is in state &lt;status&gt;"</code>
             *                      <p>
             *                      <code>}</code>
             *                      <p>
             *                      To have the <code>InputTemplate</code> include quote marks within a JSON string, escape each quote marks with a slash, as in the following example:
             *                      <p>
             *                      <code>"InputTransformer":</code>
             *                      <p>
             *                      <code>{</code>
             *                      <p>
             *                      <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code>
             *                      <p>
             *                      <code>"InputTemplate": "&lt;instance&gt; is in state \"&lt;status&gt;\""</code>
             *                      <p>
             *                      <code>}</code>
             *                      <p>
             *                      The <code>InputTemplate</code> can also be valid JSON with varibles in quotes or out, as in the following example:
             *                      <p>
             *                      <code>"InputTransformer":</code>
             *                      <p>
             *                      <code>{</code>
             *                      <p>
             *                      <code>"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},</code>
             *                      <p>
             *                      <code>"InputTemplate": '{"myInstance": &lt;instance&gt;,"myStatus": "&lt;instance&gt; is in state \"&lt;status&gt;\""}'</code>
             *                      <p>
             *                      <code>}</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputTemplate(java.lang.String inputTemplate) {
                this.inputTemplate = inputTemplate;
                return this;
            }

            /**
             * Sets the value of {@link InputTransformerProperty#getInputPathsMap}
             * @param inputPathsMap Map of JSON paths to be extracted from the event.
             *                      You can then insert these in the template in <code>InputTemplate</code> to produce the output you want to be sent to the target.
             *                      <p>
             *                      <code>InputPathsMap</code> is an array key-value pairs, where each value is a valid JSON path. You can have as many as 100 key-value pairs. You must use JSON dot notation, not bracket notation.
             *                      <p>
             *                      The keys cannot start with " AWS ."
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputPathsMap(software.amazon.awscdk.IResolvable inputPathsMap) {
                this.inputPathsMap = inputPathsMap;
                return this;
            }

            /**
             * Sets the value of {@link InputTransformerProperty#getInputPathsMap}
             * @param inputPathsMap Map of JSON paths to be extracted from the event.
             *                      You can then insert these in the template in <code>InputTemplate</code> to produce the output you want to be sent to the target.
             *                      <p>
             *                      <code>InputPathsMap</code> is an array key-value pairs, where each value is a valid JSON path. You can have as many as 100 key-value pairs. You must use JSON dot notation, not bracket notation.
             *                      <p>
             *                      The keys cannot start with " AWS ."
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputPathsMap(java.util.Map<java.lang.String, java.lang.String> inputPathsMap) {
                this.inputPathsMap = inputPathsMap;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputTransformerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputTransformerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputTransformerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputTransformerProperty {
            private final java.lang.String inputTemplate;
            private final java.lang.Object inputPathsMap;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputTemplate = software.amazon.jsii.Kernel.get(this, "inputTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputPathsMap = software.amazon.jsii.Kernel.get(this, "inputPathsMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputTemplate = java.util.Objects.requireNonNull(builder.inputTemplate, "inputTemplate is required");
                this.inputPathsMap = builder.inputPathsMap;
            }

            @Override
            public final java.lang.String getInputTemplate() {
                return this.inputTemplate;
            }

            @Override
            public final java.lang.Object getInputPathsMap() {
                return this.inputPathsMap;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputTemplate", om.valueToTree(this.getInputTemplate()));
                if (this.getInputPathsMap() != null) {
                    data.set("inputPathsMap", om.valueToTree(this.getInputPathsMap()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.InputTransformerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputTransformerProperty.Jsii$Proxy that = (InputTransformerProperty.Jsii$Proxy) o;

                if (!inputTemplate.equals(that.inputTemplate)) return false;
                return this.inputPathsMap != null ? this.inputPathsMap.equals(that.inputPathsMap) : that.inputPathsMap == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputTemplate.hashCode();
                result = 31 * result + (this.inputPathsMap != null ? this.inputPathsMap.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This object enables you to specify a JSON path to extract from the event and use as the partition key for the Amazon Kinesis data stream, so that you can control the shard to which the event goes.
     * <p>
     * If you do not include this parameter, the default is to use the <code>eventId</code> as the partition key.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * KinesisParametersProperty kinesisParametersProperty = KinesisParametersProperty.builder()
     *         .partitionKeyPath("partitionKeyPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.KinesisParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The JSON path to be extracted from the event and used as the partition key.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon Kinesis Streams Key Concepts</a> in the <em>Amazon Kinesis Streams Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-kinesisparameters.html#cfn-events-rule-kinesisparameters-partitionkeypath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPartitionKeyPath();

        /**
         * @return a {@link Builder} of {@link KinesisParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisParametersProperty> {
            java.lang.String partitionKeyPath;

            /**
             * Sets the value of {@link KinesisParametersProperty#getPartitionKeyPath}
             * @param partitionKeyPath The JSON path to be extracted from the event and used as the partition key. This parameter is required.
             *                         For more information, see <a href="https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon Kinesis Streams Key Concepts</a> in the <em>Amazon Kinesis Streams Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionKeyPath(java.lang.String partitionKeyPath) {
                this.partitionKeyPath = partitionKeyPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisParametersProperty {
            private final java.lang.String partitionKeyPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.partitionKeyPath = software.amazon.jsii.Kernel.get(this, "partitionKeyPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.partitionKeyPath = java.util.Objects.requireNonNull(builder.partitionKeyPath, "partitionKeyPath is required");
            }

            @Override
            public final java.lang.String getPartitionKeyPath() {
                return this.partitionKeyPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("partitionKeyPath", om.valueToTree(this.getPartitionKeyPath()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.KinesisParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisParametersProperty.Jsii$Proxy that = (KinesisParametersProperty.Jsii$Proxy) o;

                return this.partitionKeyPath.equals(that.partitionKeyPath);
            }

            @Override
            public final int hashCode() {
                int result = this.partitionKeyPath.hashCode();
                return result;
            }
        }
    }
    /**
     * This structure specifies the network configuration for an ECS task.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * NetworkConfigurationProperty networkConfigurationProperty = NetworkConfigurationProperty.builder()
     *         .awsVpcConfiguration(AwsVpcConfigurationProperty.builder()
     *                 .subnets(List.of("subnets"))
     *                 // the properties below are optional
     *                 .assignPublicIp("assignPublicIp")
     *                 .securityGroups(List.of("securityGroups"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-networkconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-networkconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used.
         * <p>
         * This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-networkconfiguration.html#cfn-events-rule-networkconfiguration-awsvpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-networkconfiguration.html#cfn-events-rule-networkconfiguration-awsvpcconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsVpcConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            java.lang.Object awsVpcConfiguration;

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getAwsVpcConfiguration}
             * @param awsVpcConfiguration Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used.
             *                            This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsVpcConfiguration(software.amazon.awscdk.IResolvable awsVpcConfiguration) {
                this.awsVpcConfiguration = awsVpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getAwsVpcConfiguration}
             * @param awsVpcConfiguration Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used.
             *                            This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsVpcConfiguration(software.amazon.awscdk.services.events.CfnRule.AwsVpcConfigurationProperty awsVpcConfiguration) {
                this.awsVpcConfiguration = awsVpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigurationProperty {
            private final java.lang.Object awsVpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsVpcConfiguration = software.amazon.jsii.Kernel.get(this, "awsVpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsVpcConfiguration = builder.awsVpcConfiguration;
            }

            @Override
            public final java.lang.Object getAwsVpcConfiguration() {
                return this.awsVpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsVpcConfiguration() != null) {
                    data.set("awsVpcConfiguration", om.valueToTree(this.getAwsVpcConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.NetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigurationProperty.Jsii$Proxy that = (NetworkConfigurationProperty.Jsii$Proxy) o;

                return this.awsVpcConfiguration != null ? this.awsVpcConfiguration.equals(that.awsVpcConfiguration) : that.awsVpcConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsVpcConfiguration != null ? this.awsVpcConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object representing a constraint on task placement.
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html">Task Placement Constraints</a> in the Amazon Elastic Container Service Developer Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * PlacementConstraintProperty placementConstraintProperty = PlacementConstraintProperty.builder()
     *         .expression("expression")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-placementconstraint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-placementconstraint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.PlacementConstraintProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementConstraintProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementConstraintProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A cluster query language expression to apply to the constraint.
         * <p>
         * You cannot specify an expression if the constraint type is <code>distinctInstance</code> . To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the Amazon Elastic Container Service Developer Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-placementconstraint.html#cfn-events-rule-placementconstraint-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-placementconstraint.html#cfn-events-rule-placementconstraint-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpression() {
            return null;
        }

        /**
         * The type of constraint.
         * <p>
         * Use distinctInstance to ensure that each task in a particular group is running on a different container instance. Use memberOf to restrict the selection to a group of valid candidates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-placementconstraint.html#cfn-events-rule-placementconstraint-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-placementconstraint.html#cfn-events-rule-placementconstraint-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementConstraintProperty> {
            java.lang.String expression;
            java.lang.String type;

            /**
             * Sets the value of {@link PlacementConstraintProperty#getExpression}
             * @param expression A cluster query language expression to apply to the constraint.
             *                   You cannot specify an expression if the constraint type is <code>distinctInstance</code> . To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the Amazon Elastic Container Service Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link PlacementConstraintProperty#getType}
             * @param type The type of constraint.
             *             Use distinctInstance to ensure that each task in a particular group is running on a different container instance. Use memberOf to restrict the selection to a group of valid candidates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementConstraintProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementConstraintProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementConstraintProperty {
            private final java.lang.String expression;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = builder.expression;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.PlacementConstraintProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementConstraintProperty.Jsii$Proxy that = (PlacementConstraintProperty.Jsii$Proxy) o;

                if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.expression != null ? this.expression.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The task placement strategy for a task or service.
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html">Task Placement Strategies</a> in the Amazon Elastic Container Service Service Developer Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * PlacementStrategyProperty placementStrategyProperty = PlacementStrategyProperty.builder()
     *         .field("field")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-placementstrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-placementstrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.PlacementStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The field to apply the placement strategy against.
         * <p>
         * For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-placementstrategy.html#cfn-events-rule-placementstrategy-field">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-placementstrategy.html#cfn-events-rule-placementstrategy-field</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getField() {
            return null;
        }

        /**
         * The type of placement strategy.
         * <p>
         * The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-placementstrategy.html#cfn-events-rule-placementstrategy-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-placementstrategy.html#cfn-events-rule-placementstrategy-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementStrategyProperty> {
            java.lang.String field;
            java.lang.String type;

            /**
             * Sets the value of {@link PlacementStrategyProperty#getField}
             * @param field The field to apply the placement strategy against.
             *              For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Sets the value of {@link PlacementStrategyProperty#getType}
             * @param type The type of placement strategy.
             *             The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementStrategyProperty {
            private final java.lang.String field;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.field = builder.field;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getField() {
                return this.field;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getField() != null) {
                    data.set("field", om.valueToTree(this.getField()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.PlacementStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementStrategyProperty.Jsii$Proxy that = (PlacementStrategyProperty.Jsii$Proxy) o;

                if (this.field != null ? !this.field.equals(that.field) : that.field != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.field != null ? this.field.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * RedshiftDataParametersProperty redshiftDataParametersProperty = RedshiftDataParametersProperty.builder()
     *         .database("database")
     *         // the properties below are optional
     *         .dbUser("dbUser")
     *         .secretManagerArn("secretManagerArn")
     *         .sql("sql")
     *         .sqls(List.of("sqls"))
     *         .statementName("statementName")
     *         .withEvent(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.RedshiftDataParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftDataParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftDataParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the database.
         * <p>
         * Required when authenticating using temporary credentials.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html#cfn-events-rule-redshiftdataparameters-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html#cfn-events-rule-redshiftdataparameters-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * The database user name.
         * <p>
         * Required when authenticating using temporary credentials.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html#cfn-events-rule-redshiftdataparameters-dbuser">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html#cfn-events-rule-redshiftdataparameters-dbuser</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDbUser() {
            return null;
        }

        /**
         * The name or ARN of the secret that enables access to the database.
         * <p>
         * Required when authenticating using AWS Secrets Manager.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html#cfn-events-rule-redshiftdataparameters-secretmanagerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html#cfn-events-rule-redshiftdataparameters-secretmanagerarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretManagerArn() {
            return null;
        }

        /**
         * The SQL statement text to run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html#cfn-events-rule-redshiftdataparameters-sql">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html#cfn-events-rule-redshiftdataparameters-sql</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSql() {
            return null;
        }

        /**
         * One or more SQL statements to run.
         * <p>
         * The SQL statements are run as a single transaction. They run serially in the order of the array. Subsequent SQL statements don't start until the previous statement in the array completes. If any SQL statement fails, then because they are run as one transaction, all work is rolled back.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html#cfn-events-rule-redshiftdataparameters-sqls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html#cfn-events-rule-redshiftdataparameters-sqls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSqls() {
            return null;
        }

        /**
         * The name of the SQL statement.
         * <p>
         * You can name the SQL statement when you create it to identify the query.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html#cfn-events-rule-redshiftdataparameters-statementname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html#cfn-events-rule-redshiftdataparameters-statementname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatementName() {
            return null;
        }

        /**
         * Indicates whether to send an event back to EventBridge after the SQL statement runs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html#cfn-events-rule-redshiftdataparameters-withevent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-redshiftdataparameters.html#cfn-events-rule-redshiftdataparameters-withevent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWithEvent() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftDataParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftDataParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftDataParametersProperty> {
            java.lang.String database;
            java.lang.String dbUser;
            java.lang.String secretManagerArn;
            java.lang.String sql;
            java.util.List<java.lang.String> sqls;
            java.lang.String statementName;
            java.lang.Object withEvent;

            /**
             * Sets the value of {@link RedshiftDataParametersProperty#getDatabase}
             * @param database The name of the database. This parameter is required.
             *                 Required when authenticating using temporary credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDataParametersProperty#getDbUser}
             * @param dbUser The database user name.
             *               Required when authenticating using temporary credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbUser(java.lang.String dbUser) {
                this.dbUser = dbUser;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDataParametersProperty#getSecretManagerArn}
             * @param secretManagerArn The name or ARN of the secret that enables access to the database.
             *                         Required when authenticating using AWS Secrets Manager.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretManagerArn(java.lang.String secretManagerArn) {
                this.secretManagerArn = secretManagerArn;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDataParametersProperty#getSql}
             * @param sql The SQL statement text to run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sql(java.lang.String sql) {
                this.sql = sql;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDataParametersProperty#getSqls}
             * @param sqls One or more SQL statements to run.
             *             The SQL statements are run as a single transaction. They run serially in the order of the array. Subsequent SQL statements don't start until the previous statement in the array completes. If any SQL statement fails, then because they are run as one transaction, all work is rolled back.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqls(java.util.List<java.lang.String> sqls) {
                this.sqls = sqls;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDataParametersProperty#getStatementName}
             * @param statementName The name of the SQL statement.
             *                      You can name the SQL statement when you create it to identify the query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statementName(java.lang.String statementName) {
                this.statementName = statementName;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDataParametersProperty#getWithEvent}
             * @param withEvent Indicates whether to send an event back to EventBridge after the SQL statement runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEvent(java.lang.Boolean withEvent) {
                this.withEvent = withEvent;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDataParametersProperty#getWithEvent}
             * @param withEvent Indicates whether to send an event back to EventBridge after the SQL statement runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEvent(software.amazon.awscdk.IResolvable withEvent) {
                this.withEvent = withEvent;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftDataParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftDataParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftDataParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftDataParametersProperty {
            private final java.lang.String database;
            private final java.lang.String dbUser;
            private final java.lang.String secretManagerArn;
            private final java.lang.String sql;
            private final java.util.List<java.lang.String> sqls;
            private final java.lang.String statementName;
            private final java.lang.Object withEvent;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dbUser = software.amazon.jsii.Kernel.get(this, "dbUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretManagerArn = software.amazon.jsii.Kernel.get(this, "secretManagerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sql = software.amazon.jsii.Kernel.get(this, "sql", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sqls = software.amazon.jsii.Kernel.get(this, "sqls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.statementName = software.amazon.jsii.Kernel.get(this, "statementName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.withEvent = software.amazon.jsii.Kernel.get(this, "withEvent", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.dbUser = builder.dbUser;
                this.secretManagerArn = builder.secretManagerArn;
                this.sql = builder.sql;
                this.sqls = builder.sqls;
                this.statementName = builder.statementName;
                this.withEvent = builder.withEvent;
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getDbUser() {
                return this.dbUser;
            }

            @Override
            public final java.lang.String getSecretManagerArn() {
                return this.secretManagerArn;
            }

            @Override
            public final java.lang.String getSql() {
                return this.sql;
            }

            @Override
            public final java.util.List<java.lang.String> getSqls() {
                return this.sqls;
            }

            @Override
            public final java.lang.String getStatementName() {
                return this.statementName;
            }

            @Override
            public final java.lang.Object getWithEvent() {
                return this.withEvent;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("database", om.valueToTree(this.getDatabase()));
                if (this.getDbUser() != null) {
                    data.set("dbUser", om.valueToTree(this.getDbUser()));
                }
                if (this.getSecretManagerArn() != null) {
                    data.set("secretManagerArn", om.valueToTree(this.getSecretManagerArn()));
                }
                if (this.getSql() != null) {
                    data.set("sql", om.valueToTree(this.getSql()));
                }
                if (this.getSqls() != null) {
                    data.set("sqls", om.valueToTree(this.getSqls()));
                }
                if (this.getStatementName() != null) {
                    data.set("statementName", om.valueToTree(this.getStatementName()));
                }
                if (this.getWithEvent() != null) {
                    data.set("withEvent", om.valueToTree(this.getWithEvent()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.RedshiftDataParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftDataParametersProperty.Jsii$Proxy that = (RedshiftDataParametersProperty.Jsii$Proxy) o;

                if (!database.equals(that.database)) return false;
                if (this.dbUser != null ? !this.dbUser.equals(that.dbUser) : that.dbUser != null) return false;
                if (this.secretManagerArn != null ? !this.secretManagerArn.equals(that.secretManagerArn) : that.secretManagerArn != null) return false;
                if (this.sql != null ? !this.sql.equals(that.sql) : that.sql != null) return false;
                if (this.sqls != null ? !this.sqls.equals(that.sqls) : that.sqls != null) return false;
                if (this.statementName != null ? !this.statementName.equals(that.statementName) : that.statementName != null) return false;
                return this.withEvent != null ? this.withEvent.equals(that.withEvent) : that.withEvent == null;
            }

            @Override
            public final int hashCode() {
                int result = this.database.hashCode();
                result = 31 * result + (this.dbUser != null ? this.dbUser.hashCode() : 0);
                result = 31 * result + (this.secretManagerArn != null ? this.secretManagerArn.hashCode() : 0);
                result = 31 * result + (this.sql != null ? this.sql.hashCode() : 0);
                result = 31 * result + (this.sqls != null ? this.sqls.hashCode() : 0);
                result = 31 * result + (this.statementName != null ? this.statementName.hashCode() : 0);
                result = 31 * result + (this.withEvent != null ? this.withEvent.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A <code>RetryPolicy</code> object that includes information about the retry policy settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * RetryPolicyProperty retryPolicyProperty = RetryPolicyProperty.builder()
     *         .maximumEventAgeInSeconds(123)
     *         .maximumRetryAttempts(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-retrypolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-retrypolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.RetryPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(RetryPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetryPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of time, in seconds, to continue to make retry attempts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-retrypolicy.html#cfn-events-rule-retrypolicy-maximumeventageinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-retrypolicy.html#cfn-events-rule-retrypolicy-maximumeventageinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumEventAgeInSeconds() {
            return null;
        }

        /**
         * The maximum number of retry attempts to make before the request fails.
         * <p>
         * Retry attempts continue until either the maximum number of attempts is made or until the duration of the <code>MaximumEventAgeInSeconds</code> is met.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-retrypolicy.html#cfn-events-rule-retrypolicy-maximumretryattempts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-retrypolicy.html#cfn-events-rule-retrypolicy-maximumretryattempts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRetryAttempts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetryPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetryPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetryPolicyProperty> {
            java.lang.Number maximumEventAgeInSeconds;
            java.lang.Number maximumRetryAttempts;

            /**
             * Sets the value of {@link RetryPolicyProperty#getMaximumEventAgeInSeconds}
             * @param maximumEventAgeInSeconds The maximum amount of time, in seconds, to continue to make retry attempts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumEventAgeInSeconds(java.lang.Number maximumEventAgeInSeconds) {
                this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link RetryPolicyProperty#getMaximumRetryAttempts}
             * @param maximumRetryAttempts The maximum number of retry attempts to make before the request fails.
             *                             Retry attempts continue until either the maximum number of attempts is made or until the duration of the <code>MaximumEventAgeInSeconds</code> is met.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumRetryAttempts(java.lang.Number maximumRetryAttempts) {
                this.maximumRetryAttempts = maximumRetryAttempts;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetryPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetryPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetryPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetryPolicyProperty {
            private final java.lang.Number maximumEventAgeInSeconds;
            private final java.lang.Number maximumRetryAttempts;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maximumEventAgeInSeconds = software.amazon.jsii.Kernel.get(this, "maximumEventAgeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumRetryAttempts = software.amazon.jsii.Kernel.get(this, "maximumRetryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maximumEventAgeInSeconds = builder.maximumEventAgeInSeconds;
                this.maximumRetryAttempts = builder.maximumRetryAttempts;
            }

            @Override
            public final java.lang.Number getMaximumEventAgeInSeconds() {
                return this.maximumEventAgeInSeconds;
            }

            @Override
            public final java.lang.Number getMaximumRetryAttempts() {
                return this.maximumRetryAttempts;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaximumEventAgeInSeconds() != null) {
                    data.set("maximumEventAgeInSeconds", om.valueToTree(this.getMaximumEventAgeInSeconds()));
                }
                if (this.getMaximumRetryAttempts() != null) {
                    data.set("maximumRetryAttempts", om.valueToTree(this.getMaximumRetryAttempts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.RetryPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetryPolicyProperty.Jsii$Proxy that = (RetryPolicyProperty.Jsii$Proxy) o;

                if (this.maximumEventAgeInSeconds != null ? !this.maximumEventAgeInSeconds.equals(that.maximumEventAgeInSeconds) : that.maximumEventAgeInSeconds != null) return false;
                return this.maximumRetryAttempts != null ? this.maximumRetryAttempts.equals(that.maximumRetryAttempts) : that.maximumRetryAttempts == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maximumEventAgeInSeconds != null ? this.maximumEventAgeInSeconds.hashCode() : 0;
                result = 31 * result + (this.maximumRetryAttempts != null ? this.maximumRetryAttempts.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This parameter contains the criteria (either InstanceIds or a tag) used to specify which EC2 instances are to be sent the command.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * RunCommandParametersProperty runCommandParametersProperty = RunCommandParametersProperty.builder()
     *         .runCommandTargets(List.of(RunCommandTargetProperty.builder()
     *                 .key("key")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.RunCommandParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(RunCommandParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RunCommandParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Currently, we support including only one RunCommandTarget block, which specifies either an array of InstanceIds or a tag.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandparameters.html#cfn-events-rule-runcommandparameters-runcommandtargets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRunCommandTargets();

        /**
         * @return a {@link Builder} of {@link RunCommandParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RunCommandParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RunCommandParametersProperty> {
            java.lang.Object runCommandTargets;

            /**
             * Sets the value of {@link RunCommandParametersProperty#getRunCommandTargets}
             * @param runCommandTargets Currently, we support including only one RunCommandTarget block, which specifies either an array of InstanceIds or a tag. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runCommandTargets(software.amazon.awscdk.IResolvable runCommandTargets) {
                this.runCommandTargets = runCommandTargets;
                return this;
            }

            /**
             * Sets the value of {@link RunCommandParametersProperty#getRunCommandTargets}
             * @param runCommandTargets Currently, we support including only one RunCommandTarget block, which specifies either an array of InstanceIds or a tag. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runCommandTargets(java.util.List<? extends java.lang.Object> runCommandTargets) {
                this.runCommandTargets = runCommandTargets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RunCommandParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RunCommandParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RunCommandParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RunCommandParametersProperty {
            private final java.lang.Object runCommandTargets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.runCommandTargets = software.amazon.jsii.Kernel.get(this, "runCommandTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.runCommandTargets = java.util.Objects.requireNonNull(builder.runCommandTargets, "runCommandTargets is required");
            }

            @Override
            public final java.lang.Object getRunCommandTargets() {
                return this.runCommandTargets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("runCommandTargets", om.valueToTree(this.getRunCommandTargets()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.RunCommandParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RunCommandParametersProperty.Jsii$Proxy that = (RunCommandParametersProperty.Jsii$Proxy) o;

                return this.runCommandTargets.equals(that.runCommandTargets);
            }

            @Override
            public final int hashCode() {
                int result = this.runCommandTargets.hashCode();
                return result;
            }
        }
    }
    /**
     * Information about the EC2 instances that are to be sent the command, specified as key-value pairs.
     * <p>
     * Each <code>RunCommandTarget</code> block can include only one key, but this key may specify multiple values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * RunCommandTargetProperty runCommandTargetProperty = RunCommandTargetProperty.builder()
     *         .key("key")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.RunCommandTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(RunCommandTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RunCommandTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Can be either <code>tag:</code> <em>tag-key</em> or <code>InstanceIds</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * If <code>Key</code> is <code>tag:</code> <em>tag-key</em> , <code>Values</code> is a list of tag values.
         * <p>
         * If <code>Key</code> is <code>InstanceIds</code> , <code>Values</code> is a list of Amazon EC2 instance IDs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-runcommandtarget.html#cfn-events-rule-runcommandtarget-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link RunCommandTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RunCommandTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RunCommandTargetProperty> {
            java.lang.String key;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link RunCommandTargetProperty#getKey}
             * @param key Can be either <code>tag:</code> <em>tag-key</em> or <code>InstanceIds</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link RunCommandTargetProperty#getValues}
             * @param values If <code>Key</code> is <code>tag:</code> <em>tag-key</em> , <code>Values</code> is a list of tag values. This parameter is required.
             *               If <code>Key</code> is <code>InstanceIds</code> , <code>Values</code> is a list of Amazon EC2 instance IDs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RunCommandTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RunCommandTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RunCommandTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RunCommandTargetProperty {
            private final java.lang.String key;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.RunCommandTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RunCommandTargetProperty.Jsii$Proxy that = (RunCommandTargetProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * Name/Value pair of a parameter to start execution of a SageMaker Model Building Pipeline.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * SageMakerPipelineParameterProperty sageMakerPipelineParameterProperty = SageMakerPipelineParameterProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sagemakerpipelineparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sagemakerpipelineparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.SageMakerPipelineParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(SageMakerPipelineParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SageMakerPipelineParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Name of parameter to start execution of a SageMaker Model Building Pipeline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sagemakerpipelineparameter.html#cfn-events-rule-sagemakerpipelineparameter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sagemakerpipelineparameter.html#cfn-events-rule-sagemakerpipelineparameter-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Value of parameter to start execution of a SageMaker Model Building Pipeline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sagemakerpipelineparameter.html#cfn-events-rule-sagemakerpipelineparameter-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sagemakerpipelineparameter.html#cfn-events-rule-sagemakerpipelineparameter-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link SageMakerPipelineParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SageMakerPipelineParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SageMakerPipelineParameterProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link SageMakerPipelineParameterProperty#getName}
             * @param name Name of parameter to start execution of a SageMaker Model Building Pipeline. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SageMakerPipelineParameterProperty#getValue}
             * @param value Value of parameter to start execution of a SageMaker Model Building Pipeline. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SageMakerPipelineParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SageMakerPipelineParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SageMakerPipelineParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SageMakerPipelineParameterProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.SageMakerPipelineParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SageMakerPipelineParameterProperty.Jsii$Proxy that = (SageMakerPipelineParameterProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * These are custom parameters to use when the target is a SageMaker Model Building Pipeline that starts based on EventBridge events.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * SageMakerPipelineParametersProperty sageMakerPipelineParametersProperty = SageMakerPipelineParametersProperty.builder()
     *         .pipelineParameterList(List.of(SageMakerPipelineParameterProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sagemakerpipelineparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sagemakerpipelineparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.SageMakerPipelineParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(SageMakerPipelineParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SageMakerPipelineParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of Parameter names and values for SageMaker Model Building Pipeline execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sagemakerpipelineparameters.html#cfn-events-rule-sagemakerpipelineparameters-pipelineparameterlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sagemakerpipelineparameters.html#cfn-events-rule-sagemakerpipelineparameters-pipelineparameterlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPipelineParameterList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SageMakerPipelineParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SageMakerPipelineParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SageMakerPipelineParametersProperty> {
            java.lang.Object pipelineParameterList;

            /**
             * Sets the value of {@link SageMakerPipelineParametersProperty#getPipelineParameterList}
             * @param pipelineParameterList List of Parameter names and values for SageMaker Model Building Pipeline execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pipelineParameterList(software.amazon.awscdk.IResolvable pipelineParameterList) {
                this.pipelineParameterList = pipelineParameterList;
                return this;
            }

            /**
             * Sets the value of {@link SageMakerPipelineParametersProperty#getPipelineParameterList}
             * @param pipelineParameterList List of Parameter names and values for SageMaker Model Building Pipeline execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pipelineParameterList(java.util.List<? extends java.lang.Object> pipelineParameterList) {
                this.pipelineParameterList = pipelineParameterList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SageMakerPipelineParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SageMakerPipelineParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SageMakerPipelineParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SageMakerPipelineParametersProperty {
            private final java.lang.Object pipelineParameterList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pipelineParameterList = software.amazon.jsii.Kernel.get(this, "pipelineParameterList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pipelineParameterList = builder.pipelineParameterList;
            }

            @Override
            public final java.lang.Object getPipelineParameterList() {
                return this.pipelineParameterList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPipelineParameterList() != null) {
                    data.set("pipelineParameterList", om.valueToTree(this.getPipelineParameterList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.SageMakerPipelineParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SageMakerPipelineParametersProperty.Jsii$Proxy that = (SageMakerPipelineParametersProperty.Jsii$Proxy) o;

                return this.pipelineParameterList != null ? this.pipelineParameterList.equals(that.pipelineParameterList) : that.pipelineParameterList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pipelineParameterList != null ? this.pipelineParameterList.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * This structure includes the custom parameter to be used when the target is an SQS FIFO queue.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * SqsParametersProperty sqsParametersProperty = SqsParametersProperty.builder()
     *         .messageGroupId("messageGroupId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.SqsParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(SqsParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SqsParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The FIFO message group ID to use as the target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html#cfn-events-rule-sqsparameters-messagegroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-sqsparameters.html#cfn-events-rule-sqsparameters-messagegroupid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMessageGroupId();

        /**
         * @return a {@link Builder} of {@link SqsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SqsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SqsParametersProperty> {
            java.lang.String messageGroupId;

            /**
             * Sets the value of {@link SqsParametersProperty#getMessageGroupId}
             * @param messageGroupId The FIFO message group ID to use as the target. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroupId(java.lang.String messageGroupId) {
                this.messageGroupId = messageGroupId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SqsParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SqsParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SqsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SqsParametersProperty {
            private final java.lang.String messageGroupId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.messageGroupId = software.amazon.jsii.Kernel.get(this, "messageGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.messageGroupId = java.util.Objects.requireNonNull(builder.messageGroupId, "messageGroupId is required");
            }

            @Override
            public final java.lang.String getMessageGroupId() {
                return this.messageGroupId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("messageGroupId", om.valueToTree(this.getMessageGroupId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.SqsParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SqsParametersProperty.Jsii$Proxy that = (SqsParametersProperty.Jsii$Proxy) o;

                return this.messageGroupId.equals(that.messageGroupId);
            }

            @Override
            public final int hashCode() {
                int result = this.messageGroupId.hashCode();
                return result;
            }
        }
    }
    /**
     * A key-value pair associated with an ECS Target of an EventBridge rule.
     * <p>
     * The tag will be propagated to ECS by EventBridge when starting an ECS task based on a matched event.
     * <p>
     * <blockquote>
     * <p>
     * Currently, tags are only available when using ECS with EventBridge .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * TagProperty tagProperty = TagProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-tag.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-tag.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.TagProperty")
    @software.amazon.jsii.Jsii.Proxy(TagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A string you can use to assign a value.
         * <p>
         * The combination of tag keys and values can help you organize and categorize your resources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-tag.html#cfn-events-rule-tag-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-tag.html#cfn-events-rule-tag-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The value for the specified tag key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-tag.html#cfn-events-rule-tag-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-tag.html#cfn-events-rule-tag-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link TagProperty#getKey}
             * @param key A string you can use to assign a value.
             *            The combination of tag keys and values can help you organize and categorize your resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TagProperty#getValue}
             * @param value The value for the specified tag key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.TagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagProperty.Jsii$Proxy that = (TagProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Targets are the resources to be invoked when a rule is triggered.
     * <p>
     * For a complete list of services and resources that can be set as a target, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutTargets.html">PutTargets</a> .
     * <p>
     * If you are setting the event bus of another account as the target, and that account granted permission to your account through an organization instead of directly by the account ID, then you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and Receiving Events Between AWS Accounts</a> in the <em>Amazon EventBridge User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.events.*;
     * TargetProperty targetProperty = TargetProperty.builder()
     *         .arn("arn")
     *         .id("id")
     *         // the properties below are optional
     *         .appSyncParameters(AppSyncParametersProperty.builder()
     *                 .graphQlOperation("graphQlOperation")
     *                 .build())
     *         .batchParameters(BatchParametersProperty.builder()
     *                 .jobDefinition("jobDefinition")
     *                 .jobName("jobName")
     *                 // the properties below are optional
     *                 .arrayProperties(BatchArrayPropertiesProperty.builder()
     *                         .size(123)
     *                         .build())
     *                 .retryStrategy(BatchRetryStrategyProperty.builder()
     *                         .attempts(123)
     *                         .build())
     *                 .build())
     *         .deadLetterConfig(DeadLetterConfigProperty.builder()
     *                 .arn("arn")
     *                 .build())
     *         .ecsParameters(EcsParametersProperty.builder()
     *                 .taskDefinitionArn("taskDefinitionArn")
     *                 // the properties below are optional
     *                 .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
     *                         .capacityProvider("capacityProvider")
     *                         // the properties below are optional
     *                         .base(123)
     *                         .weight(123)
     *                         .build()))
     *                 .enableEcsManagedTags(false)
     *                 .enableExecuteCommand(false)
     *                 .group("group")
     *                 .launchType("launchType")
     *                 .networkConfiguration(NetworkConfigurationProperty.builder()
     *                         .awsVpcConfiguration(AwsVpcConfigurationProperty.builder()
     *                                 .subnets(List.of("subnets"))
     *                                 // the properties below are optional
     *                                 .assignPublicIp("assignPublicIp")
     *                                 .securityGroups(List.of("securityGroups"))
     *                                 .build())
     *                         .build())
     *                 .placementConstraints(List.of(PlacementConstraintProperty.builder()
     *                         .expression("expression")
     *                         .type("type")
     *                         .build()))
     *                 .placementStrategies(List.of(PlacementStrategyProperty.builder()
     *                         .field("field")
     *                         .type("type")
     *                         .build()))
     *                 .platformVersion("platformVersion")
     *                 .propagateTags("propagateTags")
     *                 .referenceId("referenceId")
     *                 .tagList(List.of(CfnTag.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .taskCount(123)
     *                 .build())
     *         .httpParameters(HttpParametersProperty.builder()
     *                 .headerParameters(Map.of(
     *                         "headerParametersKey", "headerParameters"))
     *                 .pathParameterValues(List.of("pathParameterValues"))
     *                 .queryStringParameters(Map.of(
     *                         "queryStringParametersKey", "queryStringParameters"))
     *                 .build())
     *         .input("input")
     *         .inputPath("inputPath")
     *         .inputTransformer(InputTransformerProperty.builder()
     *                 .inputTemplate("inputTemplate")
     *                 // the properties below are optional
     *                 .inputPathsMap(Map.of(
     *                         "inputPathsMapKey", "inputPathsMap"))
     *                 .build())
     *         .kinesisParameters(KinesisParametersProperty.builder()
     *                 .partitionKeyPath("partitionKeyPath")
     *                 .build())
     *         .redshiftDataParameters(RedshiftDataParametersProperty.builder()
     *                 .database("database")
     *                 // the properties below are optional
     *                 .dbUser("dbUser")
     *                 .secretManagerArn("secretManagerArn")
     *                 .sql("sql")
     *                 .sqls(List.of("sqls"))
     *                 .statementName("statementName")
     *                 .withEvent(false)
     *                 .build())
     *         .retryPolicy(RetryPolicyProperty.builder()
     *                 .maximumEventAgeInSeconds(123)
     *                 .maximumRetryAttempts(123)
     *                 .build())
     *         .roleArn("roleArn")
     *         .runCommandParameters(RunCommandParametersProperty.builder()
     *                 .runCommandTargets(List.of(RunCommandTargetProperty.builder()
     *                         .key("key")
     *                         .values(List.of("values"))
     *                         .build()))
     *                 .build())
     *         .sageMakerPipelineParameters(SageMakerPipelineParametersProperty.builder()
     *                 .pipelineParameterList(List.of(SageMakerPipelineParameterProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .sqsParameters(SqsParametersProperty.builder()
     *                 .messageGroupId("messageGroupId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRule.TargetProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * The ID of the target within the specified rule.
         * <p>
         * Use this ID to reference the target when updating the rule. We recommend using a memorable and unique string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * Contains the GraphQL operation to be parsed and executed, if the event target is an AWS AppSync API.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-appsyncparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-appsyncparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAppSyncParameters() {
            return null;
        }

        /**
         * If the event target is an AWS Batch job, this contains the job definition, job name, and other parameters.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/jobs.html">Jobs</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-batchparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-batchparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBatchParameters() {
            return null;
        }

        /**
         * The <code>DeadLetterConfig</code> that defines the target queue to send dead-letter queue events to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-deadletterconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-deadletterconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeadLetterConfig() {
            return null;
        }

        /**
         * Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task.
         * <p>
         * For more information about Amazon ECS tasks, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task Definitions</a> in the <em>Amazon EC2 Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-ecsparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEcsParameters() {
            return null;
        }

        /**
         * Contains the HTTP parameters to use when the target is a API Gateway endpoint or EventBridge ApiDestination.
         * <p>
         * If you specify an API Gateway API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-httpparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-httpparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttpParameters() {
            return null;
        }

        /**
         * Valid JSON text passed to the target.
         * <p>
         * In this case, nothing from the event itself is passed to the target. For more information, see <a href="https://docs.aws.amazon.com/http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data Interchange Format</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-input</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInput() {
            return null;
        }

        /**
         * The value of the JSONPath that is used for extracting part of the matched event when passing it to the target.
         * <p>
         * You may use JSON dot notation or bracket notation. For more information about JSON paths, see <a href="https://docs.aws.amazon.com/http://goessner.net/articles/JsonPath/">JSONPath</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputPath() {
            return null;
        }

        /**
         * Settings to enable you to provide custom input to a target based on certain event data.
         * <p>
         * You can extract one or more key-value pairs from the event and then use that data to send customized input to the target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-inputtransformer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputTransformer() {
            return null;
        }

        /**
         * The custom parameter you can use to control the shard assignment, when the target is a Kinesis data stream.
         * <p>
         * If you do not include this parameter, the default is to use the <code>eventId</code> as the partition key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-kinesisparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisParameters() {
            return null;
        }

        /**
         * Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift cluster.
         * <p>
         * If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-redshiftdataparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-redshiftdataparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftDataParameters() {
            return null;
        }

        /**
         * The <code>RetryPolicy</code> object that contains the retry policy configuration to use for the dead-letter queue.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-retrypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-retrypolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryPolicy() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered.
         * <p>
         * If one rule triggers multiple targets, you can use a different IAM role for each target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-runcommandparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRunCommandParameters() {
            return null;
        }

        /**
         * Contains the SageMaker Model Building Pipeline parameters to start execution of a SageMaker Model Building Pipeline.
         * <p>
         * If you specify a SageMaker Model Building Pipeline as a target, you can use this to specify parameters to start a pipeline execution based on EventBridge events.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-sagemakerpipelineparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-sagemakerpipelineparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSageMakerPipelineParameters() {
            return null;
        }

        /**
         * Contains the message group ID to use when the target is a FIFO queue.
         * <p>
         * If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-sqsparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-events-rule-target.html#cfn-events-rule-target-sqsparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqsParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetProperty> {
            java.lang.String arn;
            java.lang.String id;
            java.lang.Object appSyncParameters;
            java.lang.Object batchParameters;
            java.lang.Object deadLetterConfig;
            java.lang.Object ecsParameters;
            java.lang.Object httpParameters;
            java.lang.String input;
            java.lang.String inputPath;
            java.lang.Object inputTransformer;
            java.lang.Object kinesisParameters;
            java.lang.Object redshiftDataParameters;
            java.lang.Object retryPolicy;
            java.lang.String roleArn;
            java.lang.Object runCommandParameters;
            java.lang.Object sageMakerPipelineParameters;
            java.lang.Object sqsParameters;

            /**
             * Sets the value of {@link TargetProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the target. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getId}
             * @param id The ID of the target within the specified rule. This parameter is required.
             *           Use this ID to reference the target when updating the rule. We recommend using a memorable and unique string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getAppSyncParameters}
             * @param appSyncParameters Contains the GraphQL operation to be parsed and executed, if the event target is an AWS AppSync API.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appSyncParameters(software.amazon.awscdk.IResolvable appSyncParameters) {
                this.appSyncParameters = appSyncParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getAppSyncParameters}
             * @param appSyncParameters Contains the GraphQL operation to be parsed and executed, if the event target is an AWS AppSync API.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appSyncParameters(software.amazon.awscdk.services.events.CfnRule.AppSyncParametersProperty appSyncParameters) {
                this.appSyncParameters = appSyncParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getBatchParameters}
             * @param batchParameters If the event target is an AWS Batch job, this contains the job definition, job name, and other parameters.
             *                        For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/jobs.html">Jobs</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchParameters(software.amazon.awscdk.IResolvable batchParameters) {
                this.batchParameters = batchParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getBatchParameters}
             * @param batchParameters If the event target is an AWS Batch job, this contains the job definition, job name, and other parameters.
             *                        For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/jobs.html">Jobs</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchParameters(software.amazon.awscdk.services.events.CfnRule.BatchParametersProperty batchParameters) {
                this.batchParameters = batchParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getDeadLetterConfig}
             * @param deadLetterConfig The <code>DeadLetterConfig</code> that defines the target queue to send dead-letter queue events to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deadLetterConfig(software.amazon.awscdk.IResolvable deadLetterConfig) {
                this.deadLetterConfig = deadLetterConfig;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getDeadLetterConfig}
             * @param deadLetterConfig The <code>DeadLetterConfig</code> that defines the target queue to send dead-letter queue events to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deadLetterConfig(software.amazon.awscdk.services.events.CfnRule.DeadLetterConfigProperty deadLetterConfig) {
                this.deadLetterConfig = deadLetterConfig;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getEcsParameters}
             * @param ecsParameters Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task.
             *                      For more information about Amazon ECS tasks, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task Definitions</a> in the <em>Amazon EC2 Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecsParameters(software.amazon.awscdk.IResolvable ecsParameters) {
                this.ecsParameters = ecsParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getEcsParameters}
             * @param ecsParameters Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task.
             *                      For more information about Amazon ECS tasks, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task Definitions</a> in the <em>Amazon EC2 Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecsParameters(software.amazon.awscdk.services.events.CfnRule.EcsParametersProperty ecsParameters) {
                this.ecsParameters = ecsParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getHttpParameters}
             * @param httpParameters Contains the HTTP parameters to use when the target is a API Gateway endpoint or EventBridge ApiDestination.
             *                       If you specify an API Gateway API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpParameters(software.amazon.awscdk.IResolvable httpParameters) {
                this.httpParameters = httpParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getHttpParameters}
             * @param httpParameters Contains the HTTP parameters to use when the target is a API Gateway endpoint or EventBridge ApiDestination.
             *                       If you specify an API Gateway API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpParameters(software.amazon.awscdk.services.events.CfnRule.HttpParametersProperty httpParameters) {
                this.httpParameters = httpParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getInput}
             * @param input Valid JSON text passed to the target.
             *              In this case, nothing from the event itself is passed to the target. For more information, see <a href="https://docs.aws.amazon.com/http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data Interchange Format</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.String input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getInputPath}
             * @param inputPath The value of the JSONPath that is used for extracting part of the matched event when passing it to the target.
             *                  You may use JSON dot notation or bracket notation. For more information about JSON paths, see <a href="https://docs.aws.amazon.com/http://goessner.net/articles/JsonPath/">JSONPath</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputPath(java.lang.String inputPath) {
                this.inputPath = inputPath;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getInputTransformer}
             * @param inputTransformer Settings to enable you to provide custom input to a target based on certain event data.
             *                         You can extract one or more key-value pairs from the event and then use that data to send customized input to the target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputTransformer(software.amazon.awscdk.IResolvable inputTransformer) {
                this.inputTransformer = inputTransformer;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getInputTransformer}
             * @param inputTransformer Settings to enable you to provide custom input to a target based on certain event data.
             *                         You can extract one or more key-value pairs from the event and then use that data to send customized input to the target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputTransformer(software.amazon.awscdk.services.events.CfnRule.InputTransformerProperty inputTransformer) {
                this.inputTransformer = inputTransformer;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getKinesisParameters}
             * @param kinesisParameters The custom parameter you can use to control the shard assignment, when the target is a Kinesis data stream.
             *                          If you do not include this parameter, the default is to use the <code>eventId</code> as the partition key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisParameters(software.amazon.awscdk.IResolvable kinesisParameters) {
                this.kinesisParameters = kinesisParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getKinesisParameters}
             * @param kinesisParameters The custom parameter you can use to control the shard assignment, when the target is a Kinesis data stream.
             *                          If you do not include this parameter, the default is to use the <code>eventId</code> as the partition key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisParameters(software.amazon.awscdk.services.events.CfnRule.KinesisParametersProperty kinesisParameters) {
                this.kinesisParameters = kinesisParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getRedshiftDataParameters}
             * @param redshiftDataParameters Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift cluster.
             *                               If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftDataParameters(software.amazon.awscdk.IResolvable redshiftDataParameters) {
                this.redshiftDataParameters = redshiftDataParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getRedshiftDataParameters}
             * @param redshiftDataParameters Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift cluster.
             *                               If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftDataParameters(software.amazon.awscdk.services.events.CfnRule.RedshiftDataParametersProperty redshiftDataParameters) {
                this.redshiftDataParameters = redshiftDataParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getRetryPolicy}
             * @param retryPolicy The <code>RetryPolicy</code> object that contains the retry policy configuration to use for the dead-letter queue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryPolicy(software.amazon.awscdk.IResolvable retryPolicy) {
                this.retryPolicy = retryPolicy;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getRetryPolicy}
             * @param retryPolicy The <code>RetryPolicy</code> object that contains the retry policy configuration to use for the dead-letter queue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryPolicy(software.amazon.awscdk.services.events.CfnRule.RetryPolicyProperty retryPolicy) {
                this.retryPolicy = retryPolicy;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered.
             *                If one rule triggers multiple targets, you can use a different IAM role for each target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getRunCommandParameters}
             * @param runCommandParameters Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runCommandParameters(software.amazon.awscdk.IResolvable runCommandParameters) {
                this.runCommandParameters = runCommandParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getRunCommandParameters}
             * @param runCommandParameters Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runCommandParameters(software.amazon.awscdk.services.events.CfnRule.RunCommandParametersProperty runCommandParameters) {
                this.runCommandParameters = runCommandParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getSageMakerPipelineParameters}
             * @param sageMakerPipelineParameters Contains the SageMaker Model Building Pipeline parameters to start execution of a SageMaker Model Building Pipeline.
             *                                    If you specify a SageMaker Model Building Pipeline as a target, you can use this to specify parameters to start a pipeline execution based on EventBridge events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerPipelineParameters(software.amazon.awscdk.IResolvable sageMakerPipelineParameters) {
                this.sageMakerPipelineParameters = sageMakerPipelineParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getSageMakerPipelineParameters}
             * @param sageMakerPipelineParameters Contains the SageMaker Model Building Pipeline parameters to start execution of a SageMaker Model Building Pipeline.
             *                                    If you specify a SageMaker Model Building Pipeline as a target, you can use this to specify parameters to start a pipeline execution based on EventBridge events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerPipelineParameters(software.amazon.awscdk.services.events.CfnRule.SageMakerPipelineParametersProperty sageMakerPipelineParameters) {
                this.sageMakerPipelineParameters = sageMakerPipelineParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getSqsParameters}
             * @param sqsParameters Contains the message group ID to use when the target is a FIFO queue.
             *                      If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsParameters(software.amazon.awscdk.IResolvable sqsParameters) {
                this.sqsParameters = sqsParameters;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getSqsParameters}
             * @param sqsParameters Contains the message group ID to use when the target is a FIFO queue.
             *                      If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsParameters(software.amazon.awscdk.services.events.CfnRule.SqsParametersProperty sqsParameters) {
                this.sqsParameters = sqsParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetProperty {
            private final java.lang.String arn;
            private final java.lang.String id;
            private final java.lang.Object appSyncParameters;
            private final java.lang.Object batchParameters;
            private final java.lang.Object deadLetterConfig;
            private final java.lang.Object ecsParameters;
            private final java.lang.Object httpParameters;
            private final java.lang.String input;
            private final java.lang.String inputPath;
            private final java.lang.Object inputTransformer;
            private final java.lang.Object kinesisParameters;
            private final java.lang.Object redshiftDataParameters;
            private final java.lang.Object retryPolicy;
            private final java.lang.String roleArn;
            private final java.lang.Object runCommandParameters;
            private final java.lang.Object sageMakerPipelineParameters;
            private final java.lang.Object sqsParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.appSyncParameters = software.amazon.jsii.Kernel.get(this, "appSyncParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.batchParameters = software.amazon.jsii.Kernel.get(this, "batchParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deadLetterConfig = software.amazon.jsii.Kernel.get(this, "deadLetterConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ecsParameters = software.amazon.jsii.Kernel.get(this, "ecsParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.httpParameters = software.amazon.jsii.Kernel.get(this, "httpParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputTransformer = software.amazon.jsii.Kernel.get(this, "inputTransformer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisParameters = software.amazon.jsii.Kernel.get(this, "kinesisParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshiftDataParameters = software.amazon.jsii.Kernel.get(this, "redshiftDataParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryPolicy = software.amazon.jsii.Kernel.get(this, "retryPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.runCommandParameters = software.amazon.jsii.Kernel.get(this, "runCommandParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sageMakerPipelineParameters = software.amazon.jsii.Kernel.get(this, "sageMakerPipelineParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqsParameters = software.amazon.jsii.Kernel.get(this, "sqsParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.appSyncParameters = builder.appSyncParameters;
                this.batchParameters = builder.batchParameters;
                this.deadLetterConfig = builder.deadLetterConfig;
                this.ecsParameters = builder.ecsParameters;
                this.httpParameters = builder.httpParameters;
                this.input = builder.input;
                this.inputPath = builder.inputPath;
                this.inputTransformer = builder.inputTransformer;
                this.kinesisParameters = builder.kinesisParameters;
                this.redshiftDataParameters = builder.redshiftDataParameters;
                this.retryPolicy = builder.retryPolicy;
                this.roleArn = builder.roleArn;
                this.runCommandParameters = builder.runCommandParameters;
                this.sageMakerPipelineParameters = builder.sageMakerPipelineParameters;
                this.sqsParameters = builder.sqsParameters;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.Object getAppSyncParameters() {
                return this.appSyncParameters;
            }

            @Override
            public final java.lang.Object getBatchParameters() {
                return this.batchParameters;
            }

            @Override
            public final java.lang.Object getDeadLetterConfig() {
                return this.deadLetterConfig;
            }

            @Override
            public final java.lang.Object getEcsParameters() {
                return this.ecsParameters;
            }

            @Override
            public final java.lang.Object getHttpParameters() {
                return this.httpParameters;
            }

            @Override
            public final java.lang.String getInput() {
                return this.input;
            }

            @Override
            public final java.lang.String getInputPath() {
                return this.inputPath;
            }

            @Override
            public final java.lang.Object getInputTransformer() {
                return this.inputTransformer;
            }

            @Override
            public final java.lang.Object getKinesisParameters() {
                return this.kinesisParameters;
            }

            @Override
            public final java.lang.Object getRedshiftDataParameters() {
                return this.redshiftDataParameters;
            }

            @Override
            public final java.lang.Object getRetryPolicy() {
                return this.retryPolicy;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getRunCommandParameters() {
                return this.runCommandParameters;
            }

            @Override
            public final java.lang.Object getSageMakerPipelineParameters() {
                return this.sageMakerPipelineParameters;
            }

            @Override
            public final java.lang.Object getSqsParameters() {
                return this.sqsParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));
                data.set("id", om.valueToTree(this.getId()));
                if (this.getAppSyncParameters() != null) {
                    data.set("appSyncParameters", om.valueToTree(this.getAppSyncParameters()));
                }
                if (this.getBatchParameters() != null) {
                    data.set("batchParameters", om.valueToTree(this.getBatchParameters()));
                }
                if (this.getDeadLetterConfig() != null) {
                    data.set("deadLetterConfig", om.valueToTree(this.getDeadLetterConfig()));
                }
                if (this.getEcsParameters() != null) {
                    data.set("ecsParameters", om.valueToTree(this.getEcsParameters()));
                }
                if (this.getHttpParameters() != null) {
                    data.set("httpParameters", om.valueToTree(this.getHttpParameters()));
                }
                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }
                if (this.getInputPath() != null) {
                    data.set("inputPath", om.valueToTree(this.getInputPath()));
                }
                if (this.getInputTransformer() != null) {
                    data.set("inputTransformer", om.valueToTree(this.getInputTransformer()));
                }
                if (this.getKinesisParameters() != null) {
                    data.set("kinesisParameters", om.valueToTree(this.getKinesisParameters()));
                }
                if (this.getRedshiftDataParameters() != null) {
                    data.set("redshiftDataParameters", om.valueToTree(this.getRedshiftDataParameters()));
                }
                if (this.getRetryPolicy() != null) {
                    data.set("retryPolicy", om.valueToTree(this.getRetryPolicy()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getRunCommandParameters() != null) {
                    data.set("runCommandParameters", om.valueToTree(this.getRunCommandParameters()));
                }
                if (this.getSageMakerPipelineParameters() != null) {
                    data.set("sageMakerPipelineParameters", om.valueToTree(this.getSageMakerPipelineParameters()));
                }
                if (this.getSqsParameters() != null) {
                    data.set("sqsParameters", om.valueToTree(this.getSqsParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRule.TargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetProperty.Jsii$Proxy that = (TargetProperty.Jsii$Proxy) o;

                if (!arn.equals(that.arn)) return false;
                if (!id.equals(that.id)) return false;
                if (this.appSyncParameters != null ? !this.appSyncParameters.equals(that.appSyncParameters) : that.appSyncParameters != null) return false;
                if (this.batchParameters != null ? !this.batchParameters.equals(that.batchParameters) : that.batchParameters != null) return false;
                if (this.deadLetterConfig != null ? !this.deadLetterConfig.equals(that.deadLetterConfig) : that.deadLetterConfig != null) return false;
                if (this.ecsParameters != null ? !this.ecsParameters.equals(that.ecsParameters) : that.ecsParameters != null) return false;
                if (this.httpParameters != null ? !this.httpParameters.equals(that.httpParameters) : that.httpParameters != null) return false;
                if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
                if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
                if (this.inputTransformer != null ? !this.inputTransformer.equals(that.inputTransformer) : that.inputTransformer != null) return false;
                if (this.kinesisParameters != null ? !this.kinesisParameters.equals(that.kinesisParameters) : that.kinesisParameters != null) return false;
                if (this.redshiftDataParameters != null ? !this.redshiftDataParameters.equals(that.redshiftDataParameters) : that.redshiftDataParameters != null) return false;
                if (this.retryPolicy != null ? !this.retryPolicy.equals(that.retryPolicy) : that.retryPolicy != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                if (this.runCommandParameters != null ? !this.runCommandParameters.equals(that.runCommandParameters) : that.runCommandParameters != null) return false;
                if (this.sageMakerPipelineParameters != null ? !this.sageMakerPipelineParameters.equals(that.sageMakerPipelineParameters) : that.sageMakerPipelineParameters != null) return false;
                return this.sqsParameters != null ? this.sqsParameters.equals(that.sqsParameters) : that.sqsParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.appSyncParameters != null ? this.appSyncParameters.hashCode() : 0);
                result = 31 * result + (this.batchParameters != null ? this.batchParameters.hashCode() : 0);
                result = 31 * result + (this.deadLetterConfig != null ? this.deadLetterConfig.hashCode() : 0);
                result = 31 * result + (this.ecsParameters != null ? this.ecsParameters.hashCode() : 0);
                result = 31 * result + (this.httpParameters != null ? this.httpParameters.hashCode() : 0);
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
                result = 31 * result + (this.inputTransformer != null ? this.inputTransformer.hashCode() : 0);
                result = 31 * result + (this.kinesisParameters != null ? this.kinesisParameters.hashCode() : 0);
                result = 31 * result + (this.redshiftDataParameters != null ? this.redshiftDataParameters.hashCode() : 0);
                result = 31 * result + (this.retryPolicy != null ? this.retryPolicy.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.runCommandParameters != null ? this.runCommandParameters.hashCode() : 0);
                result = 31 * result + (this.sageMakerPipelineParameters != null ? this.sageMakerPipelineParameters.hashCode() : 0);
                result = 31 * result + (this.sqsParameters != null ? this.sqsParameters.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.CfnRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.CfnRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.events.CfnRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The description of the rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-description</a>
         * @param description The description of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The name or ARN of the event bus associated with the rule.
         * <p>
         * If you omit this, the default event bus is used.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-eventbusname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-eventbusname</a>
         * @param eventBusName The name or ARN of the event bus associated with the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBusName(final java.lang.String eventBusName) {
            this.props().eventBusName(eventBusName);
            return this;
        }

        /**
         * The event pattern of the rule.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <em>Amazon EventBridge User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-eventpattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-eventpattern</a>
         * @param eventPattern The event pattern of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventPattern(final java.lang.Object eventPattern) {
            this.props().eventPattern(eventPattern);
            return this;
        }

        /**
         * The name of the rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-name</a>
         * @param name The name of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the role that is used for target invocation.
         * <p>
         * If you're setting an event bus in another account as the target and that account granted permission to your account through an organization instead of directly by the account ID, you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure, instead of here in this parameter.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of the role that is used for target invocation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props().roleArn(roleArn);
            return this;
        }

        /**
         * The scheduling expression.
         * <p>
         * For example, "cron(0 20 * * ? *)", "rate(5 minutes)". For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-rule-schedule.html">Creating an Amazon EventBridge rule that runs on a schedule</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-scheduleexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-scheduleexpression</a>
         * @param scheduleExpression The scheduling expression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpression(final java.lang.String scheduleExpression) {
            this.props().scheduleExpression(scheduleExpression);
            return this;
        }

        /**
         * The state of the rule.
         * <p>
         * Valid values include:
         * <p>
         * <ul>
         * <li><code>DISABLED</code> : The rule is disabled. EventBridge does not match any events against the rule.</li>
         * <li><code>ENABLED</code> : The rule is enabled. EventBridge matches events against the rule, <em>except</em> for AWS management events delivered through CloudTrail.</li>
         * <li><code>ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS</code> : The rule is enabled for all events, including AWS management events delivered through CloudTrail.</li>
         * </ul>
         * <p>
         * Management events provide visibility into management operations that are performed on resources in your AWS account. These are also known as control plane operations. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html#logging-management-events">Logging management events</a> in the <em>CloudTrail User Guide</em> , and <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-cloudtrail">Filtering management events from AWS services</a> in the <em>Amazon EventBridge User Guide</em> .
         * <p>
         * This value is only valid for rules on the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-what-is-how-it-works-concepts.html#eb-bus-concepts-buses">default</a> event bus or <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-event-bus.html">custom event buses</a> . It does not apply to <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-saas.html">partner event buses</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-state</a>
         * @param state The state of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(final java.lang.String state) {
            this.props().state(state);
            return this;
        }

        /**
         * Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
         * <p>
         * Targets are the resources that are invoked when a rule is triggered.
         * <p>
         * The maximum number of entries per request is 10.
         * <p>
         * <blockquote>
         * <p>
         * Each rule can have up to five (5) targets associated with it at one time.
         * <p>
         * </blockquote>
         * <p>
         * For a list of services you can configure as targets for events, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-targets.html">EventBridge targets</a> in the <em>Amazon EventBridge User Guide</em> .
         * <p>
         * Creating rules with built-in targets is supported only in the AWS Management Console . The built-in targets are:
         * <p>
         * <ul>
         * <li><code>Amazon EBS CreateSnapshot API call</code></li>
         * <li><code>Amazon EC2 RebootInstances API call</code></li>
         * <li><code>Amazon EC2 StopInstances API call</code></li>
         * <li><code>Amazon EC2 TerminateInstances API call</code></li>
         * </ul>
         * <p>
         * For some target types, <code>PutTargets</code> provides target-specific parameters. If the target is a Kinesis data stream, you can optionally specify which shard the event goes to by using the <code>KinesisParameters</code> argument. To invoke a command on multiple EC2 instances with one rule, you can use the <code>RunCommandParameters</code> field.
         * <p>
         * To be able to make API calls against the resources that you own, Amazon EventBridge needs the appropriate permissions:
         * <p>
         * <ul>
         * <li>For AWS Lambda and Amazon SNS resources, EventBridge relies on resource-based policies.</li>
         * <li>For EC2 instances, Kinesis Data Streams, AWS Step Functions state machines and API Gateway APIs, EventBridge relies on IAM roles that you specify in the <code>RoleARN</code> argument in <code>PutTargets</code> .</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html">Authentication and Access Control</a> in the <em>Amazon EventBridge User Guide</em> .
         * <p>
         * If another AWS account is in the same region and has granted you permission (using <code>PutPermission</code> ), you can send events to that account. Set that account's event bus as a target of the rules in your account. To send the matched events to the other account, specify that account's event bus as the <code>Arn</code> value when you run <code>PutTargets</code> . If your account sends events to another account, your account is charged for each sent event. Each event sent to another account is charged as a custom event. The account receiving the event is not charged. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/pricing/">Amazon EventBridge Pricing</a> .
         * <p>
         * <blockquote>
         * <p>
         * <code>Input</code> , <code>InputPath</code> , and <code>InputTransformer</code> are not available with <code>PutTarget</code> if the target is an event bus of a different AWS account.
         * <p>
         * </blockquote>
         * <p>
         * If you are setting the event bus of another account as the target, and that account granted permission to your account through an organization instead of directly by the account ID, then you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and Receiving Events Between AWS Accounts</a> in the <em>Amazon EventBridge User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If you have an IAM role on a cross-account event bus target, a <code>PutTargets</code> call without a role on the same target (same <code>Id</code> and <code>Arn</code> ) will not remove the role.
         * <p>
         * </blockquote>
         * <p>
         * For more information about enabling cross-account events, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission</a> .
         * <p>
         * <em>Input</em> , <em>InputPath</em> , and <em>InputTransformer</em> are mutually exclusive and optional parameters of a target. When a rule is triggered due to a matched event:
         * <p>
         * <ul>
         * <li>If none of the following arguments are specified for a target, then the entire event is passed to the target in JSON format (unless the target is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from the event is passed to the target).</li>
         * <li>If <em>Input</em> is specified in the form of valid JSON, then the matched event is overridden with this constant.</li>
         * <li>If <em>InputPath</em> is specified in the form of JSONPath (for example, <code>$.detail</code> ), then only the part of the event specified in the path is passed to the target (for example, only the detail part of the event is passed).</li>
         * <li>If <em>InputTransformer</em> is specified, then one or more specified JSONPaths are extracted from the event and used as values in a template that you specify as the input to the target.</li>
         * </ul>
         * <p>
         * When you specify <code>InputPath</code> or <code>InputTransformer</code> , you must use JSON dot notation, not bracket notation.
         * <p>
         * When you add targets to a rule and the associated rule triggers soon after, new or updated targets might not be immediately invoked. Allow a short period of time for changes to take effect.
         * <p>
         * This action can partially fail if too many requests are made at the same time. If that happens, <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides the ID of the failed target and the error code.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-targets</a>
         * @param targets Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final software.amazon.awscdk.IResolvable targets) {
            this.props().targets(targets);
            return this;
        }
        /**
         * Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
         * <p>
         * Targets are the resources that are invoked when a rule is triggered.
         * <p>
         * The maximum number of entries per request is 10.
         * <p>
         * <blockquote>
         * <p>
         * Each rule can have up to five (5) targets associated with it at one time.
         * <p>
         * </blockquote>
         * <p>
         * For a list of services you can configure as targets for events, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-targets.html">EventBridge targets</a> in the <em>Amazon EventBridge User Guide</em> .
         * <p>
         * Creating rules with built-in targets is supported only in the AWS Management Console . The built-in targets are:
         * <p>
         * <ul>
         * <li><code>Amazon EBS CreateSnapshot API call</code></li>
         * <li><code>Amazon EC2 RebootInstances API call</code></li>
         * <li><code>Amazon EC2 StopInstances API call</code></li>
         * <li><code>Amazon EC2 TerminateInstances API call</code></li>
         * </ul>
         * <p>
         * For some target types, <code>PutTargets</code> provides target-specific parameters. If the target is a Kinesis data stream, you can optionally specify which shard the event goes to by using the <code>KinesisParameters</code> argument. To invoke a command on multiple EC2 instances with one rule, you can use the <code>RunCommandParameters</code> field.
         * <p>
         * To be able to make API calls against the resources that you own, Amazon EventBridge needs the appropriate permissions:
         * <p>
         * <ul>
         * <li>For AWS Lambda and Amazon SNS resources, EventBridge relies on resource-based policies.</li>
         * <li>For EC2 instances, Kinesis Data Streams, AWS Step Functions state machines and API Gateway APIs, EventBridge relies on IAM roles that you specify in the <code>RoleARN</code> argument in <code>PutTargets</code> .</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html">Authentication and Access Control</a> in the <em>Amazon EventBridge User Guide</em> .
         * <p>
         * If another AWS account is in the same region and has granted you permission (using <code>PutPermission</code> ), you can send events to that account. Set that account's event bus as a target of the rules in your account. To send the matched events to the other account, specify that account's event bus as the <code>Arn</code> value when you run <code>PutTargets</code> . If your account sends events to another account, your account is charged for each sent event. Each event sent to another account is charged as a custom event. The account receiving the event is not charged. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/pricing/">Amazon EventBridge Pricing</a> .
         * <p>
         * <blockquote>
         * <p>
         * <code>Input</code> , <code>InputPath</code> , and <code>InputTransformer</code> are not available with <code>PutTarget</code> if the target is an event bus of a different AWS account.
         * <p>
         * </blockquote>
         * <p>
         * If you are setting the event bus of another account as the target, and that account granted permission to your account through an organization instead of directly by the account ID, then you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and Receiving Events Between AWS Accounts</a> in the <em>Amazon EventBridge User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If you have an IAM role on a cross-account event bus target, a <code>PutTargets</code> call without a role on the same target (same <code>Id</code> and <code>Arn</code> ) will not remove the role.
         * <p>
         * </blockquote>
         * <p>
         * For more information about enabling cross-account events, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission</a> .
         * <p>
         * <em>Input</em> , <em>InputPath</em> , and <em>InputTransformer</em> are mutually exclusive and optional parameters of a target. When a rule is triggered due to a matched event:
         * <p>
         * <ul>
         * <li>If none of the following arguments are specified for a target, then the entire event is passed to the target in JSON format (unless the target is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from the event is passed to the target).</li>
         * <li>If <em>Input</em> is specified in the form of valid JSON, then the matched event is overridden with this constant.</li>
         * <li>If <em>InputPath</em> is specified in the form of JSONPath (for example, <code>$.detail</code> ), then only the part of the event specified in the path is passed to the target (for example, only the detail part of the event is passed).</li>
         * <li>If <em>InputTransformer</em> is specified, then one or more specified JSONPaths are extracted from the event and used as values in a template that you specify as the input to the target.</li>
         * </ul>
         * <p>
         * When you specify <code>InputPath</code> or <code>InputTransformer</code> , you must use JSON dot notation, not bracket notation.
         * <p>
         * When you add targets to a rule and the associated rule triggers soon after, new or updated targets might not be immediately invoked. Allow a short period of time for changes to take effect.
         * <p>
         * This action can partially fail if too many requests are made at the same time. If that happens, <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides the ID of the failed target and the error code.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-events-rule.html#cfn-events-rule-targets</a>
         * @param targets Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final java.util.List<? extends java.lang.Object> targets) {
            this.props().targets(targets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.events.CfnRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.CfnRule build() {
            return new software.amazon.awscdk.services.events.CfnRule(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.CfnRuleProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.CfnRuleProps.Builder();
            }
            return this.props;
        }
    }
}
