package software.amazon.awscdk.services.gamelift;

/**
 * The <code>AWS::GameLift::Fleet</code> resource creates an Amazon GameLift (GameLift) fleet to host custom game server or Realtime Servers.
 * <p>
 * A fleet is a set of EC2 instances, configured with instructions to run game servers on each instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * CfnFleet cfnFleet = CfnFleet.Builder.create(this, "MyCfnFleet")
 *         .name("name")
 *         // the properties below are optional
 *         .anywhereConfiguration(AnywhereConfigurationProperty.builder()
 *                 .cost("cost")
 *                 .build())
 *         .applyCapacity("applyCapacity")
 *         .buildId("buildId")
 *         .certificateConfiguration(CertificateConfigurationProperty.builder()
 *                 .certificateType("certificateType")
 *                 .build())
 *         .computeType("computeType")
 *         .description("description")
 *         .desiredEc2Instances(123)
 *         .ec2InboundPermissions(List.of(IpPermissionProperty.builder()
 *                 .fromPort(123)
 *                 .ipRange("ipRange")
 *                 .protocol("protocol")
 *                 .toPort(123)
 *                 .build()))
 *         .ec2InstanceType("ec2InstanceType")
 *         .fleetType("fleetType")
 *         .instanceRoleArn("instanceRoleArn")
 *         .instanceRoleCredentialsProvider("instanceRoleCredentialsProvider")
 *         .locations(List.of(LocationConfigurationProperty.builder()
 *                 .location("location")
 *                 // the properties below are optional
 *                 .locationCapacity(LocationCapacityProperty.builder()
 *                         .desiredEc2Instances(123)
 *                         .maxSize(123)
 *                         .minSize(123)
 *                         .build())
 *                 .build()))
 *         .logPaths(List.of("logPaths"))
 *         .maxSize(123)
 *         .metricGroups(List.of("metricGroups"))
 *         .minSize(123)
 *         .newGameSessionProtectionPolicy("newGameSessionProtectionPolicy")
 *         .peerVpcAwsAccountId("peerVpcAwsAccountId")
 *         .peerVpcId("peerVpcId")
 *         .resourceCreationLimitPolicy(ResourceCreationLimitPolicyProperty.builder()
 *                 .newGameSessionsPerCreator(123)
 *                 .policyPeriodInMinutes(123)
 *                 .build())
 *         .runtimeConfiguration(RuntimeConfigurationProperty.builder()
 *                 .gameSessionActivationTimeoutSeconds(123)
 *                 .maxConcurrentGameSessionActivations(123)
 *                 .serverProcesses(List.of(ServerProcessProperty.builder()
 *                         .concurrentExecutions(123)
 *                         .launchPath("launchPath")
 *                         // the properties below are optional
 *                         .parameters("parameters")
 *                         .build()))
 *                 .build())
 *         .scalingPolicies(List.of(ScalingPolicyProperty.builder()
 *                 .metricName("metricName")
 *                 .name("name")
 *                 // the properties below are optional
 *                 .comparisonOperator("comparisonOperator")
 *                 .evaluationPeriods(123)
 *                 .location("location")
 *                 .policyType("policyType")
 *                 .scalingAdjustment(123)
 *                 .scalingAdjustmentType("scalingAdjustmentType")
 *                 .status("status")
 *                 .targetConfiguration(TargetConfigurationProperty.builder()
 *                         .targetValue(123)
 *                         .build())
 *                 .threshold(123)
 *                 .updateStatus("updateStatus")
 *                 .build()))
 *         .scriptId("scriptId")
 *         .serverLaunchParameters("serverLaunchParameters")
 *         .serverLaunchPath("serverLaunchPath")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:55.873Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnFleet")
public class CfnFleet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFleet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFleet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.gamelift.CfnFleet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFleet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.gamelift.CfnFleetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * A unique identifier for the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFleetId() {
        return software.amazon.jsii.Kernel.get(this, "attrFleetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A descriptive label that is associated with a fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A descriptive label that is associated with a fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Amazon GameLift Anywhere configuration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAnywhereConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "anywhereConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Amazon GameLift Anywhere configuration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnywhereConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "anywhereConfiguration", value);
    }

    /**
     * Amazon GameLift Anywhere configuration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnywhereConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.gamelift.CfnFleet.AnywhereConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "anywhereConfiguration", value);
    }

    /**
     * Current resource capacity settings in a specified fleet or location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApplyCapacity() {
        return software.amazon.jsii.Kernel.get(this, "applyCapacity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Current resource capacity settings in a specified fleet or location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplyCapacity(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applyCapacity", value);
    }

    /**
     * A unique identifier for a build to be deployed on the new fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBuildId() {
        return software.amazon.jsii.Kernel.get(this, "buildId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for a build to be deployed on the new fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBuildId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "buildId", value);
    }

    /**
     * Prompts Amazon GameLift to generate a TLS/SSL certificate for the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCertificateConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "certificateConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Prompts Amazon GameLift to generate a TLS/SSL certificate for the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "certificateConfiguration", value);
    }

    /**
     * Prompts Amazon GameLift to generate a TLS/SSL certificate for the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.gamelift.CfnFleet.CertificateConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "certificateConfiguration", value);
    }

    /**
     * The type of compute resource used to host your game servers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getComputeType() {
        return software.amazon.jsii.Kernel.get(this, "computeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of compute resource used to host your game servers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputeType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "computeType", value);
    }

    /**
     * A description for the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description for the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The number of EC2 instances that you want this fleet to host.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDesiredEc2Instances() {
        return software.amazon.jsii.Kernel.get(this, "desiredEc2Instances", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of EC2 instances that you want this fleet to host.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDesiredEc2Instances(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "desiredEc2Instances", value);
    }

    /**
     * The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEc2InboundPermissions() {
        return software.amazon.jsii.Kernel.get(this, "ec2InboundPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEc2InboundPermissions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ec2InboundPermissions", value);
    }

    /**
     * The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEc2InboundPermissions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.gamelift.CfnFleet.IpPermissionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.gamelift.CfnFleet.IpPermissionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "ec2InboundPermissions", value);
    }

    /**
     * The Amazon GameLift-supported Amazon EC2 instance type to use for all fleet instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEc2InstanceType() {
        return software.amazon.jsii.Kernel.get(this, "ec2InstanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon GameLift-supported Amazon EC2 instance type to use for all fleet instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEc2InstanceType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ec2InstanceType", value);
    }

    /**
     * Indicates whether to use On-Demand or Spot instances for this fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFleetType() {
        return software.amazon.jsii.Kernel.get(this, "fleetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether to use On-Demand or Spot instances for this fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFleetType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "fleetType", value);
    }

    /**
     * A unique identifier for an IAM role with access permissions to other AWS services.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "instanceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for an IAM role with access permissions to other AWS services.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceRoleArn", value);
    }

    /**
     * Indicates that fleet instances maintain a shared credentials file for the IAM role defined in <code>InstanceRoleArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceRoleCredentialsProvider() {
        return software.amazon.jsii.Kernel.get(this, "instanceRoleCredentialsProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates that fleet instances maintain a shared credentials file for the IAM role defined in <code>InstanceRoleArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceRoleCredentialsProvider(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceRoleCredentialsProvider", value);
    }

    /**
     * A set of remote locations to deploy additional instances to and manage as part of the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLocations() {
        return software.amazon.jsii.Kernel.get(this, "locations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A set of remote locations to deploy additional instances to and manage as part of the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "locations", value);
    }

    /**
     * A set of remote locations to deploy additional instances to and manage as part of the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.gamelift.CfnFleet.LocationConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.gamelift.CfnFleet.LocationConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "locations", value);
    }

    /**
     * (deprecated) This parameter is no longer used.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLogPaths() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "logPaths", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * (deprecated) This parameter is no longer used.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setLogPaths(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "logPaths", value);
    }

    /**
     * The maximum number of instances that are allowed in the specified fleet location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxSize() {
        return software.amazon.jsii.Kernel.get(this, "maxSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum number of instances that are allowed in the specified fleet location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxSize(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxSize", value);
    }

    /**
     * The name of an AWS CloudWatch metric group to add this fleet to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMetricGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "metricGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The name of an AWS CloudWatch metric group to add this fleet to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "metricGroups", value);
    }

    /**
     * The minimum number of instances that are allowed in the specified fleet location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinSize() {
        return software.amazon.jsii.Kernel.get(this, "minSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The minimum number of instances that are allowed in the specified fleet location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinSize(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minSize", value);
    }

    /**
     * The status of termination protection for active game sessions on the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNewGameSessionProtectionPolicy() {
        return software.amazon.jsii.Kernel.get(this, "newGameSessionProtectionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of termination protection for active game sessions on the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNewGameSessionProtectionPolicy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "newGameSessionProtectionPolicy", value);
    }

    /**
     * Used when peering your Amazon GameLift fleet with a VPC, the unique identifier for the AWS account that owns the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPeerVpcAwsAccountId() {
        return software.amazon.jsii.Kernel.get(this, "peerVpcAwsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Used when peering your Amazon GameLift fleet with a VPC, the unique identifier for the AWS account that owns the VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPeerVpcAwsAccountId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "peerVpcAwsAccountId", value);
    }

    /**
     * A unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPeerVpcId() {
        return software.amazon.jsii.Kernel.get(this, "peerVpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPeerVpcId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "peerVpcId", value);
    }

    /**
     * A policy that limits the number of game sessions that an individual player can create on instances in this fleet within a specified span of time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getResourceCreationLimitPolicy() {
        return software.amazon.jsii.Kernel.get(this, "resourceCreationLimitPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A policy that limits the number of game sessions that an individual player can create on instances in this fleet within a specified span of time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceCreationLimitPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourceCreationLimitPolicy", value);
    }

    /**
     * A policy that limits the number of game sessions that an individual player can create on instances in this fleet within a specified span of time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceCreationLimitPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.gamelift.CfnFleet.ResourceCreationLimitPolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "resourceCreationLimitPolicy", value);
    }

    /**
     * Instructions for how to launch and maintain server processes on instances in the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRuntimeConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "runtimeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Instructions for how to launch and maintain server processes on instances in the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuntimeConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "runtimeConfiguration", value);
    }

    /**
     * Instructions for how to launch and maintain server processes on instances in the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuntimeConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.gamelift.CfnFleet.RuntimeConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "runtimeConfiguration", value);
    }

    /**
     * Rule that controls how a fleet is scaled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getScalingPolicies() {
        return software.amazon.jsii.Kernel.get(this, "scalingPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Rule that controls how a fleet is scaled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingPolicies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scalingPolicies", value);
    }

    /**
     * Rule that controls how a fleet is scaled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingPolicies(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.gamelift.CfnFleet.ScalingPolicyProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.gamelift.CfnFleet.ScalingPolicyProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "scalingPolicies", value);
    }

    /**
     * The unique identifier for a Realtime configuration script to be deployed on fleet instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScriptId() {
        return software.amazon.jsii.Kernel.get(this, "scriptId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for a Realtime configuration script to be deployed on fleet instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScriptId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scriptId", value);
    }

    /**
     * (deprecated) This parameter is no longer used but is retained for backward compatibility.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.String getServerLaunchParameters() {
        return software.amazon.jsii.Kernel.get(this, "serverLaunchParameters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) This parameter is no longer used but is retained for backward compatibility.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setServerLaunchParameters(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serverLaunchParameters", value);
    }

    /**
     * (deprecated) This parameter is no longer used.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.String getServerLaunchPath() {
        return software.amazon.jsii.Kernel.get(this, "serverLaunchPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) This parameter is no longer used.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setServerLaunchPath(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serverLaunchPath", value);
    }
    /**
     * Amazon GameLift Anywhere configuration options for your Anywhere fleets.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * AnywhereConfigurationProperty anywhereConfigurationProperty = AnywhereConfigurationProperty.builder()
     *         .cost("cost")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-anywhereconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-anywhereconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnFleet.AnywhereConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AnywhereConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnywhereConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The cost to run your fleet per hour.
         * <p>
         * Amazon GameLift uses the provided cost of your fleet to balance usage in queues. For more information about queues, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-intro.html">Setting up queues</a> in the <em>Amazon GameLift Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-anywhereconfiguration.html#cfn-gamelift-fleet-anywhereconfiguration-cost">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-anywhereconfiguration.html#cfn-gamelift-fleet-anywhereconfiguration-cost</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCost();

        /**
         * @return a {@link Builder} of {@link AnywhereConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnywhereConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnywhereConfigurationProperty> {
            java.lang.String cost;

            /**
             * Sets the value of {@link AnywhereConfigurationProperty#getCost}
             * @param cost The cost to run your fleet per hour. This parameter is required.
             *             Amazon GameLift uses the provided cost of your fleet to balance usage in queues. For more information about queues, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-intro.html">Setting up queues</a> in the <em>Amazon GameLift Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cost(java.lang.String cost) {
                this.cost = cost;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnywhereConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnywhereConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnywhereConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnywhereConfigurationProperty {
            private final java.lang.String cost;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cost = software.amazon.jsii.Kernel.get(this, "cost", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cost = java.util.Objects.requireNonNull(builder.cost, "cost is required");
            }

            @Override
            public final java.lang.String getCost() {
                return this.cost;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cost", om.valueToTree(this.getCost()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnFleet.AnywhereConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnywhereConfigurationProperty.Jsii$Proxy that = (AnywhereConfigurationProperty.Jsii$Proxy) o;

                return this.cost.equals(that.cost);
            }

            @Override
            public final int hashCode() {
                int result = this.cost.hashCode();
                return result;
            }
        }
    }
    /**
     * Determines whether a TLS/SSL certificate is generated for a fleet.
     * <p>
     * This feature must be enabled when creating the fleet. All instances in a fleet share the same certificate. The certificate can be retrieved by calling the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html">GameLift Server SDK</a> operation <code>GetInstanceCertificate</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * CertificateConfigurationProperty certificateConfigurationProperty = CertificateConfigurationProperty.builder()
     *         .certificateType("certificateType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-certificateconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-certificateconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnFleet.CertificateConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CertificateConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CertificateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether a TLS/SSL certificate is generated for a fleet.
         * <p>
         * Valid values include:
         * <p>
         * <ul>
         * <li><em>GENERATED</em> - Generate a TLS/SSL certificate for this fleet.</li>
         * <li><em>DISABLED</em> - (default) Do not generate a TLS/SSL certificate for this fleet.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-certificateconfiguration.html#cfn-gamelift-fleet-certificateconfiguration-certificatetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-certificateconfiguration.html#cfn-gamelift-fleet-certificateconfiguration-certificatetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCertificateType();

        /**
         * @return a {@link Builder} of {@link CertificateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CertificateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CertificateConfigurationProperty> {
            java.lang.String certificateType;

            /**
             * Sets the value of {@link CertificateConfigurationProperty#getCertificateType}
             * @param certificateType Indicates whether a TLS/SSL certificate is generated for a fleet. This parameter is required.
             *                        Valid values include:
             *                        <p>
             *                        <ul>
             *                        <li><em>GENERATED</em> - Generate a TLS/SSL certificate for this fleet.</li>
             *                        <li><em>DISABLED</em> - (default) Do not generate a TLS/SSL certificate for this fleet.</li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateType(java.lang.String certificateType) {
                this.certificateType = certificateType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CertificateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CertificateConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CertificateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificateConfigurationProperty {
            private final java.lang.String certificateType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateType = software.amazon.jsii.Kernel.get(this, "certificateType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateType = java.util.Objects.requireNonNull(builder.certificateType, "certificateType is required");
            }

            @Override
            public final java.lang.String getCertificateType() {
                return this.certificateType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificateType", om.valueToTree(this.getCertificateType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnFleet.CertificateConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CertificateConfigurationProperty.Jsii$Proxy that = (CertificateConfigurationProperty.Jsii$Proxy) o;

                return this.certificateType.equals(that.certificateType);
            }

            @Override
            public final int hashCode() {
                int result = this.certificateType.hashCode();
                return result;
            }
        }
    }
    /**
     * A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an instance in a fleet.
     * <p>
     * New game sessions are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges. Fleets with custom game builds must have permissions explicitly set. For Realtime Servers fleets, GameLift automatically opens two port ranges, one for TCP messaging and one for UDP.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * IpPermissionProperty ipPermissionProperty = IpPermissionProperty.builder()
     *         .fromPort(123)
     *         .ipRange("ipRange")
     *         .protocol("protocol")
     *         .toPort(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-ippermission.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-ippermission.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnFleet.IpPermissionProperty")
    @software.amazon.jsii.Jsii.Proxy(IpPermissionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IpPermissionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A starting value for a range of allowed port numbers.
         * <p>
         * For fleets using Linux builds, only ports <code>22</code> and <code>1026-60000</code> are valid.
         * <p>
         * For fleets using Windows builds, only ports <code>1026-60000</code> are valid.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-ippermission.html#cfn-gamelift-fleet-ippermission-fromport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-ippermission.html#cfn-gamelift-fleet-ippermission-fromport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getFromPort();

        /**
         * A range of allowed IP addresses.
         * <p>
         * This value must be expressed in CIDR notation. Example: " <code>000.000.000.000/[subnet mask]</code> " or optionally the shortened version " <code>0.0.0.0/[subnet mask]</code> ".
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-ippermission.html#cfn-gamelift-fleet-ippermission-iprange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-ippermission.html#cfn-gamelift-fleet-ippermission-iprange</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIpRange();

        /**
         * The network communication protocol used by the fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-ippermission.html#cfn-gamelift-fleet-ippermission-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-ippermission.html#cfn-gamelift-fleet-ippermission-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProtocol();

        /**
         * An ending value for a range of allowed port numbers.
         * <p>
         * Port numbers are end-inclusive. This value must be equal to or greater than <code>FromPort</code> .
         * <p>
         * For fleets using Linux builds, only ports <code>22</code> and <code>1026-60000</code> are valid.
         * <p>
         * For fleets using Windows builds, only ports <code>1026-60000</code> are valid.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-ippermission.html#cfn-gamelift-fleet-ippermission-toport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-ippermission.html#cfn-gamelift-fleet-ippermission-toport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getToPort();

        /**
         * @return a {@link Builder} of {@link IpPermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IpPermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IpPermissionProperty> {
            java.lang.Number fromPort;
            java.lang.String ipRange;
            java.lang.String protocol;
            java.lang.Number toPort;

            /**
             * Sets the value of {@link IpPermissionProperty#getFromPort}
             * @param fromPort A starting value for a range of allowed port numbers. This parameter is required.
             *                 For fleets using Linux builds, only ports <code>22</code> and <code>1026-60000</code> are valid.
             *                 <p>
             *                 For fleets using Windows builds, only ports <code>1026-60000</code> are valid.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fromPort(java.lang.Number fromPort) {
                this.fromPort = fromPort;
                return this;
            }

            /**
             * Sets the value of {@link IpPermissionProperty#getIpRange}
             * @param ipRange A range of allowed IP addresses. This parameter is required.
             *                This value must be expressed in CIDR notation. Example: " <code>000.000.000.000/[subnet mask]</code> " or optionally the shortened version " <code>0.0.0.0/[subnet mask]</code> ".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipRange(java.lang.String ipRange) {
                this.ipRange = ipRange;
                return this;
            }

            /**
             * Sets the value of {@link IpPermissionProperty#getProtocol}
             * @param protocol The network communication protocol used by the fleet. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link IpPermissionProperty#getToPort}
             * @param toPort An ending value for a range of allowed port numbers. This parameter is required.
             *               Port numbers are end-inclusive. This value must be equal to or greater than <code>FromPort</code> .
             *               <p>
             *               For fleets using Linux builds, only ports <code>22</code> and <code>1026-60000</code> are valid.
             *               <p>
             *               For fleets using Windows builds, only ports <code>1026-60000</code> are valid.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder toPort(java.lang.Number toPort) {
                this.toPort = toPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IpPermissionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IpPermissionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IpPermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IpPermissionProperty {
            private final java.lang.Number fromPort;
            private final java.lang.String ipRange;
            private final java.lang.String protocol;
            private final java.lang.Number toPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fromPort = software.amazon.jsii.Kernel.get(this, "fromPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ipRange = software.amazon.jsii.Kernel.get(this, "ipRange", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.toPort = software.amazon.jsii.Kernel.get(this, "toPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fromPort = java.util.Objects.requireNonNull(builder.fromPort, "fromPort is required");
                this.ipRange = java.util.Objects.requireNonNull(builder.ipRange, "ipRange is required");
                this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
                this.toPort = java.util.Objects.requireNonNull(builder.toPort, "toPort is required");
            }

            @Override
            public final java.lang.Number getFromPort() {
                return this.fromPort;
            }

            @Override
            public final java.lang.String getIpRange() {
                return this.ipRange;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.Number getToPort() {
                return this.toPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fromPort", om.valueToTree(this.getFromPort()));
                data.set("ipRange", om.valueToTree(this.getIpRange()));
                data.set("protocol", om.valueToTree(this.getProtocol()));
                data.set("toPort", om.valueToTree(this.getToPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnFleet.IpPermissionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IpPermissionProperty.Jsii$Proxy that = (IpPermissionProperty.Jsii$Proxy) o;

                if (!fromPort.equals(that.fromPort)) return false;
                if (!ipRange.equals(that.ipRange)) return false;
                if (!protocol.equals(that.protocol)) return false;
                return this.toPort.equals(that.toPort);
            }

            @Override
            public final int hashCode() {
                int result = this.fromPort.hashCode();
                result = 31 * result + (this.ipRange.hashCode());
                result = 31 * result + (this.protocol.hashCode());
                result = 31 * result + (this.toPort.hashCode());
                return result;
            }
        }
    }
    /**
     * Current resource capacity settings in a specified fleet or location.
     * <p>
     * The location value might refer to a fleet's remote location or its home Region.
     * <p>
     * <em>Related actions</em>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html">DescribeFleetCapacity</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html">DescribeFleetLocationCapacity</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html">UpdateFleetCapacity</a>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * LocationCapacityProperty locationCapacityProperty = LocationCapacityProperty.builder()
     *         .desiredEc2Instances(123)
     *         .maxSize(123)
     *         .minSize(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-locationcapacity.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-locationcapacity.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnFleet.LocationCapacityProperty")
    @software.amazon.jsii.Jsii.Proxy(LocationCapacityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocationCapacityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of Amazon EC2 instances you want to maintain in the specified fleet location.
         * <p>
         * This value must fall between the minimum and maximum size limits. Changes in desired instance value can take up to 1 minute to be reflected when viewing the fleet's capacity settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-locationcapacity.html#cfn-gamelift-fleet-locationcapacity-desiredec2instances">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-locationcapacity.html#cfn-gamelift-fleet-locationcapacity-desiredec2instances</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDesiredEc2Instances();

        /**
         * The maximum number of instances that are allowed in the specified fleet location.
         * <p>
         * If this parameter is not set, the default is 1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-locationcapacity.html#cfn-gamelift-fleet-locationcapacity-maxsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-locationcapacity.html#cfn-gamelift-fleet-locationcapacity-maxsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxSize();

        /**
         * The minimum number of instances that are allowed in the specified fleet location.
         * <p>
         * If this parameter is not set, the default is 0.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-locationcapacity.html#cfn-gamelift-fleet-locationcapacity-minsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-locationcapacity.html#cfn-gamelift-fleet-locationcapacity-minsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinSize();

        /**
         * @return a {@link Builder} of {@link LocationCapacityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocationCapacityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocationCapacityProperty> {
            java.lang.Number desiredEc2Instances;
            java.lang.Number maxSize;
            java.lang.Number minSize;

            /**
             * Sets the value of {@link LocationCapacityProperty#getDesiredEc2Instances}
             * @param desiredEc2Instances The number of Amazon EC2 instances you want to maintain in the specified fleet location. This parameter is required.
             *                            This value must fall between the minimum and maximum size limits. Changes in desired instance value can take up to 1 minute to be reflected when viewing the fleet's capacity settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder desiredEc2Instances(java.lang.Number desiredEc2Instances) {
                this.desiredEc2Instances = desiredEc2Instances;
                return this;
            }

            /**
             * Sets the value of {@link LocationCapacityProperty#getMaxSize}
             * @param maxSize The maximum number of instances that are allowed in the specified fleet location. This parameter is required.
             *                If this parameter is not set, the default is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxSize(java.lang.Number maxSize) {
                this.maxSize = maxSize;
                return this;
            }

            /**
             * Sets the value of {@link LocationCapacityProperty#getMinSize}
             * @param minSize The minimum number of instances that are allowed in the specified fleet location. This parameter is required.
             *                If this parameter is not set, the default is 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minSize(java.lang.Number minSize) {
                this.minSize = minSize;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocationCapacityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocationCapacityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocationCapacityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocationCapacityProperty {
            private final java.lang.Number desiredEc2Instances;
            private final java.lang.Number maxSize;
            private final java.lang.Number minSize;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.desiredEc2Instances = software.amazon.jsii.Kernel.get(this, "desiredEc2Instances", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxSize = software.amazon.jsii.Kernel.get(this, "maxSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minSize = software.amazon.jsii.Kernel.get(this, "minSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.desiredEc2Instances = java.util.Objects.requireNonNull(builder.desiredEc2Instances, "desiredEc2Instances is required");
                this.maxSize = java.util.Objects.requireNonNull(builder.maxSize, "maxSize is required");
                this.minSize = java.util.Objects.requireNonNull(builder.minSize, "minSize is required");
            }

            @Override
            public final java.lang.Number getDesiredEc2Instances() {
                return this.desiredEc2Instances;
            }

            @Override
            public final java.lang.Number getMaxSize() {
                return this.maxSize;
            }

            @Override
            public final java.lang.Number getMinSize() {
                return this.minSize;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("desiredEc2Instances", om.valueToTree(this.getDesiredEc2Instances()));
                data.set("maxSize", om.valueToTree(this.getMaxSize()));
                data.set("minSize", om.valueToTree(this.getMinSize()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnFleet.LocationCapacityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocationCapacityProperty.Jsii$Proxy that = (LocationCapacityProperty.Jsii$Proxy) o;

                if (!desiredEc2Instances.equals(that.desiredEc2Instances)) return false;
                if (!maxSize.equals(that.maxSize)) return false;
                return this.minSize.equals(that.minSize);
            }

            @Override
            public final int hashCode() {
                int result = this.desiredEc2Instances.hashCode();
                result = 31 * result + (this.maxSize.hashCode());
                result = 31 * result + (this.minSize.hashCode());
                return result;
            }
        }
    }
    /**
     * A remote location where a multi-location fleet can deploy game servers for game hosting.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * LocationConfigurationProperty locationConfigurationProperty = LocationConfigurationProperty.builder()
     *         .location("location")
     *         // the properties below are optional
     *         .locationCapacity(LocationCapacityProperty.builder()
     *                 .desiredEc2Instances(123)
     *                 .maxSize(123)
     *                 .minSize(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-locationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-locationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnFleet.LocationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LocationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An AWS Region code, such as <code>us-west-2</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-locationconfiguration.html#cfn-gamelift-fleet-locationconfiguration-location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-locationconfiguration.html#cfn-gamelift-fleet-locationconfiguration-location</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocation();

        /**
         * Current resource capacity settings in a specified fleet or location.
         * <p>
         * The location value might refer to a fleet's remote location or its home Region.
         * <p>
         * <em>Related actions</em>
         * <p>
         * <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html">DescribeFleetCapacity</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html">DescribeFleetLocationCapacity</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html">UpdateFleetCapacity</a>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-locationconfiguration.html#cfn-gamelift-fleet-locationconfiguration-locationcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-locationconfiguration.html#cfn-gamelift-fleet-locationconfiguration-locationcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLocationCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LocationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocationConfigurationProperty> {
            java.lang.String location;
            java.lang.Object locationCapacity;

            /**
             * Sets the value of {@link LocationConfigurationProperty#getLocation}
             * @param location An AWS Region code, such as <code>us-west-2</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link LocationConfigurationProperty#getLocationCapacity}
             * @param locationCapacity Current resource capacity settings in a specified fleet or location.
             *                         The location value might refer to a fleet's remote location or its home Region.
             *                         <p>
             *                         <em>Related actions</em>
             *                         <p>
             *                         <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html">DescribeFleetCapacity</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html">DescribeFleetLocationCapacity</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html">UpdateFleetCapacity</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locationCapacity(software.amazon.awscdk.IResolvable locationCapacity) {
                this.locationCapacity = locationCapacity;
                return this;
            }

            /**
             * Sets the value of {@link LocationConfigurationProperty#getLocationCapacity}
             * @param locationCapacity Current resource capacity settings in a specified fleet or location.
             *                         The location value might refer to a fleet's remote location or its home Region.
             *                         <p>
             *                         <em>Related actions</em>
             *                         <p>
             *                         <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html">DescribeFleetCapacity</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html">DescribeFleetLocationCapacity</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html">UpdateFleetCapacity</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locationCapacity(software.amazon.awscdk.services.gamelift.CfnFleet.LocationCapacityProperty locationCapacity) {
                this.locationCapacity = locationCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocationConfigurationProperty {
            private final java.lang.String location;
            private final java.lang.Object locationCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.locationCapacity = software.amazon.jsii.Kernel.get(this, "locationCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.location = java.util.Objects.requireNonNull(builder.location, "location is required");
                this.locationCapacity = builder.locationCapacity;
            }

            @Override
            public final java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public final java.lang.Object getLocationCapacity() {
                return this.locationCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("location", om.valueToTree(this.getLocation()));
                if (this.getLocationCapacity() != null) {
                    data.set("locationCapacity", om.valueToTree(this.getLocationCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnFleet.LocationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocationConfigurationProperty.Jsii$Proxy that = (LocationConfigurationProperty.Jsii$Proxy) o;

                if (!location.equals(that.location)) return false;
                return this.locationCapacity != null ? this.locationCapacity.equals(that.locationCapacity) : that.locationCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.location.hashCode();
                result = 31 * result + (this.locationCapacity != null ? this.locationCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A policy that limits the number of game sessions a player can create on the same fleet.
     * <p>
     * This optional policy gives game owners control over how players can consume available game server resources. A resource creation policy makes the following statement: "An individual player can create a maximum number of new game sessions within a specified time period".
     * <p>
     * The policy is evaluated when a player tries to create a new game session. For example, assume you have a policy of 10 new game sessions and a time period of 60 minutes. On receiving a <code>CreateGameSession</code> request, Amazon GameLift checks that the player (identified by <code>CreatorId</code> ) has created fewer than 10 game sessions in the past 60 minutes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * ResourceCreationLimitPolicyProperty resourceCreationLimitPolicyProperty = ResourceCreationLimitPolicyProperty.builder()
     *         .newGameSessionsPerCreator(123)
     *         .policyPeriodInMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-resourcecreationlimitpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-resourcecreationlimitpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnFleet.ResourceCreationLimitPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceCreationLimitPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceCreationLimitPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A policy that puts limits on the number of game sessions that a player can create within a specified span of time.
         * <p>
         * With this policy, you can control players' ability to consume available resources.
         * <p>
         * The policy is evaluated when a player tries to create a new game session. On receiving a <code>CreateGameSession</code> request, Amazon GameLift checks that the player (identified by <code>CreatorId</code> ) has created fewer than game session limit in the specified time period.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-resourcecreationlimitpolicy.html#cfn-gamelift-fleet-resourcecreationlimitpolicy-newgamesessionspercreator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-resourcecreationlimitpolicy.html#cfn-gamelift-fleet-resourcecreationlimitpolicy-newgamesessionspercreator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNewGameSessionsPerCreator() {
            return null;
        }

        /**
         * The time span used in evaluating the resource creation limit policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-resourcecreationlimitpolicy.html#cfn-gamelift-fleet-resourcecreationlimitpolicy-policyperiodinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-resourcecreationlimitpolicy.html#cfn-gamelift-fleet-resourcecreationlimitpolicy-policyperiodinminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPolicyPeriodInMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceCreationLimitPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceCreationLimitPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceCreationLimitPolicyProperty> {
            java.lang.Number newGameSessionsPerCreator;
            java.lang.Number policyPeriodInMinutes;

            /**
             * Sets the value of {@link ResourceCreationLimitPolicyProperty#getNewGameSessionsPerCreator}
             * @param newGameSessionsPerCreator A policy that puts limits on the number of game sessions that a player can create within a specified span of time.
             *                                  With this policy, you can control players' ability to consume available resources.
             *                                  <p>
             *                                  The policy is evaluated when a player tries to create a new game session. On receiving a <code>CreateGameSession</code> request, Amazon GameLift checks that the player (identified by <code>CreatorId</code> ) has created fewer than game session limit in the specified time period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newGameSessionsPerCreator(java.lang.Number newGameSessionsPerCreator) {
                this.newGameSessionsPerCreator = newGameSessionsPerCreator;
                return this;
            }

            /**
             * Sets the value of {@link ResourceCreationLimitPolicyProperty#getPolicyPeriodInMinutes}
             * @param policyPeriodInMinutes The time span used in evaluating the resource creation limit policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyPeriodInMinutes(java.lang.Number policyPeriodInMinutes) {
                this.policyPeriodInMinutes = policyPeriodInMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceCreationLimitPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceCreationLimitPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceCreationLimitPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceCreationLimitPolicyProperty {
            private final java.lang.Number newGameSessionsPerCreator;
            private final java.lang.Number policyPeriodInMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.newGameSessionsPerCreator = software.amazon.jsii.Kernel.get(this, "newGameSessionsPerCreator", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.policyPeriodInMinutes = software.amazon.jsii.Kernel.get(this, "policyPeriodInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.newGameSessionsPerCreator = builder.newGameSessionsPerCreator;
                this.policyPeriodInMinutes = builder.policyPeriodInMinutes;
            }

            @Override
            public final java.lang.Number getNewGameSessionsPerCreator() {
                return this.newGameSessionsPerCreator;
            }

            @Override
            public final java.lang.Number getPolicyPeriodInMinutes() {
                return this.policyPeriodInMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNewGameSessionsPerCreator() != null) {
                    data.set("newGameSessionsPerCreator", om.valueToTree(this.getNewGameSessionsPerCreator()));
                }
                if (this.getPolicyPeriodInMinutes() != null) {
                    data.set("policyPeriodInMinutes", om.valueToTree(this.getPolicyPeriodInMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnFleet.ResourceCreationLimitPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceCreationLimitPolicyProperty.Jsii$Proxy that = (ResourceCreationLimitPolicyProperty.Jsii$Proxy) o;

                if (this.newGameSessionsPerCreator != null ? !this.newGameSessionsPerCreator.equals(that.newGameSessionsPerCreator) : that.newGameSessionsPerCreator != null) return false;
                return this.policyPeriodInMinutes != null ? this.policyPeriodInMinutes.equals(that.policyPeriodInMinutes) : that.policyPeriodInMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.newGameSessionsPerCreator != null ? this.newGameSessionsPerCreator.hashCode() : 0;
                result = 31 * result + (this.policyPeriodInMinutes != null ? this.policyPeriodInMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A collection of server process configurations that describe the set of processes to run on each instance in a fleet.
     * <p>
     * Server processes run either an executable in a custom game build or a Realtime Servers script. GameLift launches the configured processes, manages their life cycle, and replaces them as needed. Each instance checks regularly for an updated runtime configuration.
     * <p>
     * A GameLift instance is limited to 50 processes running concurrently. To calculate the total number of processes in a runtime configuration, add the values of the <code>ConcurrentExecutions</code> parameter for each ServerProcess. Learn more about <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html">Running Multiple Processes on a Fleet</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * RuntimeConfigurationProperty runtimeConfigurationProperty = RuntimeConfigurationProperty.builder()
     *         .gameSessionActivationTimeoutSeconds(123)
     *         .maxConcurrentGameSessionActivations(123)
     *         .serverProcesses(List.of(ServerProcessProperty.builder()
     *                 .concurrentExecutions(123)
     *                 .launchPath("launchPath")
     *                 // the properties below are optional
     *                 .parameters("parameters")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-runtimeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-runtimeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnFleet.RuntimeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RuntimeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuntimeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of time (in seconds) allowed to launch a new game session and have it report ready to host players.
         * <p>
         * During this time, the game session is in status <code>ACTIVATING</code> . If the game session does not become active before the timeout, it is ended and the game session status is changed to <code>TERMINATED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-runtimeconfiguration.html#cfn-gamelift-fleet-runtimeconfiguration-gamesessionactivationtimeoutseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-runtimeconfiguration.html#cfn-gamelift-fleet-runtimeconfiguration-gamesessionactivationtimeoutseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGameSessionActivationTimeoutSeconds() {
            return null;
        }

        /**
         * The number of game sessions in status <code>ACTIVATING</code> to allow on an instance.
         * <p>
         * This setting limits the instance resources that can be used for new game activations at any one time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-runtimeconfiguration.html#cfn-gamelift-fleet-runtimeconfiguration-maxconcurrentgamesessionactivations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-runtimeconfiguration.html#cfn-gamelift-fleet-runtimeconfiguration-maxconcurrentgamesessionactivations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrentGameSessionActivations() {
            return null;
        }

        /**
         * A collection of server process configurations that identify what server processes to run on each instance in a fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-runtimeconfiguration.html#cfn-gamelift-fleet-runtimeconfiguration-serverprocesses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-runtimeconfiguration.html#cfn-gamelift-fleet-runtimeconfiguration-serverprocesses</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServerProcesses() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuntimeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuntimeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuntimeConfigurationProperty> {
            java.lang.Number gameSessionActivationTimeoutSeconds;
            java.lang.Number maxConcurrentGameSessionActivations;
            java.lang.Object serverProcesses;

            /**
             * Sets the value of {@link RuntimeConfigurationProperty#getGameSessionActivationTimeoutSeconds}
             * @param gameSessionActivationTimeoutSeconds The maximum amount of time (in seconds) allowed to launch a new game session and have it report ready to host players.
             *                                            During this time, the game session is in status <code>ACTIVATING</code> . If the game session does not become active before the timeout, it is ended and the game session status is changed to <code>TERMINATED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gameSessionActivationTimeoutSeconds(java.lang.Number gameSessionActivationTimeoutSeconds) {
                this.gameSessionActivationTimeoutSeconds = gameSessionActivationTimeoutSeconds;
                return this;
            }

            /**
             * Sets the value of {@link RuntimeConfigurationProperty#getMaxConcurrentGameSessionActivations}
             * @param maxConcurrentGameSessionActivations The number of game sessions in status <code>ACTIVATING</code> to allow on an instance.
             *                                            This setting limits the instance resources that can be used for new game activations at any one time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxConcurrentGameSessionActivations(java.lang.Number maxConcurrentGameSessionActivations) {
                this.maxConcurrentGameSessionActivations = maxConcurrentGameSessionActivations;
                return this;
            }

            /**
             * Sets the value of {@link RuntimeConfigurationProperty#getServerProcesses}
             * @param serverProcesses A collection of server process configurations that identify what server processes to run on each instance in a fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverProcesses(software.amazon.awscdk.IResolvable serverProcesses) {
                this.serverProcesses = serverProcesses;
                return this;
            }

            /**
             * Sets the value of {@link RuntimeConfigurationProperty#getServerProcesses}
             * @param serverProcesses A collection of server process configurations that identify what server processes to run on each instance in a fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverProcesses(java.util.List<? extends java.lang.Object> serverProcesses) {
                this.serverProcesses = serverProcesses;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuntimeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuntimeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuntimeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuntimeConfigurationProperty {
            private final java.lang.Number gameSessionActivationTimeoutSeconds;
            private final java.lang.Number maxConcurrentGameSessionActivations;
            private final java.lang.Object serverProcesses;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.gameSessionActivationTimeoutSeconds = software.amazon.jsii.Kernel.get(this, "gameSessionActivationTimeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxConcurrentGameSessionActivations = software.amazon.jsii.Kernel.get(this, "maxConcurrentGameSessionActivations", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serverProcesses = software.amazon.jsii.Kernel.get(this, "serverProcesses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.gameSessionActivationTimeoutSeconds = builder.gameSessionActivationTimeoutSeconds;
                this.maxConcurrentGameSessionActivations = builder.maxConcurrentGameSessionActivations;
                this.serverProcesses = builder.serverProcesses;
            }

            @Override
            public final java.lang.Number getGameSessionActivationTimeoutSeconds() {
                return this.gameSessionActivationTimeoutSeconds;
            }

            @Override
            public final java.lang.Number getMaxConcurrentGameSessionActivations() {
                return this.maxConcurrentGameSessionActivations;
            }

            @Override
            public final java.lang.Object getServerProcesses() {
                return this.serverProcesses;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGameSessionActivationTimeoutSeconds() != null) {
                    data.set("gameSessionActivationTimeoutSeconds", om.valueToTree(this.getGameSessionActivationTimeoutSeconds()));
                }
                if (this.getMaxConcurrentGameSessionActivations() != null) {
                    data.set("maxConcurrentGameSessionActivations", om.valueToTree(this.getMaxConcurrentGameSessionActivations()));
                }
                if (this.getServerProcesses() != null) {
                    data.set("serverProcesses", om.valueToTree(this.getServerProcesses()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnFleet.RuntimeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuntimeConfigurationProperty.Jsii$Proxy that = (RuntimeConfigurationProperty.Jsii$Proxy) o;

                if (this.gameSessionActivationTimeoutSeconds != null ? !this.gameSessionActivationTimeoutSeconds.equals(that.gameSessionActivationTimeoutSeconds) : that.gameSessionActivationTimeoutSeconds != null) return false;
                if (this.maxConcurrentGameSessionActivations != null ? !this.maxConcurrentGameSessionActivations.equals(that.maxConcurrentGameSessionActivations) : that.maxConcurrentGameSessionActivations != null) return false;
                return this.serverProcesses != null ? this.serverProcesses.equals(that.serverProcesses) : that.serverProcesses == null;
            }

            @Override
            public final int hashCode() {
                int result = this.gameSessionActivationTimeoutSeconds != null ? this.gameSessionActivationTimeoutSeconds.hashCode() : 0;
                result = 31 * result + (this.maxConcurrentGameSessionActivations != null ? this.maxConcurrentGameSessionActivations.hashCode() : 0);
                result = 31 * result + (this.serverProcesses != null ? this.serverProcesses.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Rule that controls how a fleet is scaled.
     * <p>
     * Scaling policies are uniquely identified by the combination of name and fleet ID.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * ScalingPolicyProperty scalingPolicyProperty = ScalingPolicyProperty.builder()
     *         .metricName("metricName")
     *         .name("name")
     *         // the properties below are optional
     *         .comparisonOperator("comparisonOperator")
     *         .evaluationPeriods(123)
     *         .location("location")
     *         .policyType("policyType")
     *         .scalingAdjustment(123)
     *         .scalingAdjustmentType("scalingAdjustmentType")
     *         .status("status")
     *         .targetConfiguration(TargetConfigurationProperty.builder()
     *                 .targetValue(123)
     *                 .build())
     *         .threshold(123)
     *         .updateStatus("updateStatus")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnFleet.ScalingPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
         * <p>
         * For detailed descriptions of fleet metrics, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon GameLift with Amazon CloudWatch</a> .
         * <p>
         * <ul>
         * <li><em>ActivatingGameSessions</em> -- Game sessions in the process of being created.</li>
         * <li><em>ActiveGameSessions</em> -- Game sessions that are currently running.</li>
         * <li><em>ActiveInstances</em> -- Fleet instances that are currently running at least one game session.</li>
         * <li><em>AvailableGameSessions</em> -- Additional game sessions that fleet could host simultaneously, given current capacity.</li>
         * <li><em>AvailablePlayerSessions</em> -- Empty player slots in currently active game sessions. This includes game sessions that are not currently accepting players. Reserved player slots are not included.</li>
         * <li><em>CurrentPlayerSessions</em> -- Player slots in active game sessions that are being used by a player or are reserved for a player.</li>
         * <li><em>IdleInstances</em> -- Active instances that are currently hosting zero game sessions.</li>
         * <li><em>PercentAvailableGameSessions</em> -- Unused percentage of the total number of game sessions that a fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.</li>
         * <li><em>PercentIdleInstances</em> -- Percentage of the total number of active instances that are hosting zero game sessions.</li>
         * <li><em>QueueDepth</em> -- Pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</li>
         * <li><em>WaitTime</em> -- Current wait time for pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-metricname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * A descriptive label that is associated with a fleet's scaling policy.
         * <p>
         * Policy names do not need to be unique.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Comparison operator to use when measuring a metric against the threshold value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-comparisonoperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-comparisonoperator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComparisonOperator() {
            return null;
        }

        /**
         * Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-evaluationperiods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-evaluationperiods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEvaluationPeriods() {
            return null;
        }

        /**
         * The fleet location.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-location</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocation() {
            return null;
        }

        /**
         * The type of scaling policy to create.
         * <p>
         * For a target-based policy, set the parameter <em>MetricName</em> to 'PercentAvailableGameSessions' and specify a <em>TargetConfiguration</em> . For a rule-based policy set the following parameters: <em>MetricName</em> , <em>ComparisonOperator</em> , <em>Threshold</em> , <em>EvaluationPeriods</em> , <em>ScalingAdjustmentType</em> , and <em>ScalingAdjustment</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-policytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-policytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPolicyType() {
            return null;
        }

        /**
         * Amount of adjustment to make, based on the scaling adjustment type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-scalingadjustment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-scalingadjustment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScalingAdjustment() {
            return null;
        }

        /**
         * The type of adjustment to make to a fleet's instance count.
         * <p>
         * <ul>
         * <li><em>ChangeInCapacity</em> -- add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.</li>
         * <li><em>ExactCapacity</em> -- set the instance count to the scaling adjustment value.</li>
         * <li><em>PercentChangeInCapacity</em> -- increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-scalingadjustmenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-scalingadjustmenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScalingAdjustmentType() {
            return null;
        }

        /**
         * Current status of the scaling policy.
         * <p>
         * The scaling policy can be in force only when in an <code>ACTIVE</code> status. Scaling policies can be suspended for individual fleets. If the policy is suspended for a fleet, the policy status does not change.
         * <p>
         * <ul>
         * <li><em>ACTIVE</em> -- The scaling policy can be used for auto-scaling a fleet.</li>
         * <li><em>UPDATE_REQUESTED</em> -- A request to update the scaling policy has been received.</li>
         * <li><em>UPDATING</em> -- A change is being made to the scaling policy.</li>
         * <li><em>DELETE_REQUESTED</em> -- A request to delete the scaling policy has been received.</li>
         * <li><em>DELETING</em> -- The scaling policy is being deleted.</li>
         * <li><em>DELETED</em> -- The scaling policy has been deleted.</li>
         * <li><em>ERROR</em> -- An error occurred in creating the policy. It should be removed and recreated.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * An object that contains settings for a target-based scaling policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-targetconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-targetconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetConfiguration() {
            return null;
        }

        /**
         * Metric value used to trigger a scaling event.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-threshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-threshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThreshold() {
            return null;
        }

        /**
         * The current status of the fleet's scaling policies in a requested fleet location.
         * <p>
         * The status <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been completed for the location.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-updatestatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-scalingpolicy.html#cfn-gamelift-fleet-scalingpolicy-updatestatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUpdateStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingPolicyProperty> {
            java.lang.String metricName;
            java.lang.String name;
            java.lang.String comparisonOperator;
            java.lang.Number evaluationPeriods;
            java.lang.String location;
            java.lang.String policyType;
            java.lang.Number scalingAdjustment;
            java.lang.String scalingAdjustmentType;
            java.lang.String status;
            java.lang.Object targetConfiguration;
            java.lang.Number threshold;
            java.lang.String updateStatus;

            /**
             * Sets the value of {@link ScalingPolicyProperty#getMetricName}
             * @param metricName Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment. This parameter is required.
             *                   For detailed descriptions of fleet metrics, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html">Monitor Amazon GameLift with Amazon CloudWatch</a> .
             *                   <p>
             *                   <ul>
             *                   <li><em>ActivatingGameSessions</em> -- Game sessions in the process of being created.</li>
             *                   <li><em>ActiveGameSessions</em> -- Game sessions that are currently running.</li>
             *                   <li><em>ActiveInstances</em> -- Fleet instances that are currently running at least one game session.</li>
             *                   <li><em>AvailableGameSessions</em> -- Additional game sessions that fleet could host simultaneously, given current capacity.</li>
             *                   <li><em>AvailablePlayerSessions</em> -- Empty player slots in currently active game sessions. This includes game sessions that are not currently accepting players. Reserved player slots are not included.</li>
             *                   <li><em>CurrentPlayerSessions</em> -- Player slots in active game sessions that are being used by a player or are reserved for a player.</li>
             *                   <li><em>IdleInstances</em> -- Active instances that are currently hosting zero game sessions.</li>
             *                   <li><em>PercentAvailableGameSessions</em> -- Unused percentage of the total number of game sessions that a fleet could host simultaneously, given current capacity. Use this metric for a target-based scaling policy.</li>
             *                   <li><em>PercentIdleInstances</em> -- Percentage of the total number of active instances that are hosting zero game sessions.</li>
             *                   <li><em>QueueDepth</em> -- Pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</li>
             *                   <li><em>WaitTime</em> -- Current wait time for pending game session placement requests, in any queue, where the current fleet is the top-priority destination.</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getName}
             * @param name A descriptive label that is associated with a fleet's scaling policy. This parameter is required.
             *             Policy names do not need to be unique.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getComparisonOperator}
             * @param comparisonOperator Comparison operator to use when measuring a metric against the threshold value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonOperator(java.lang.String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getEvaluationPeriods}
             * @param evaluationPeriods Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluationPeriods(java.lang.Number evaluationPeriods) {
                this.evaluationPeriods = evaluationPeriods;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getLocation}
             * @param location The fleet location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getPolicyType}
             * @param policyType The type of scaling policy to create.
             *                   For a target-based policy, set the parameter <em>MetricName</em> to 'PercentAvailableGameSessions' and specify a <em>TargetConfiguration</em> . For a rule-based policy set the following parameters: <em>MetricName</em> , <em>ComparisonOperator</em> , <em>Threshold</em> , <em>EvaluationPeriods</em> , <em>ScalingAdjustmentType</em> , and <em>ScalingAdjustment</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyType(java.lang.String policyType) {
                this.policyType = policyType;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getScalingAdjustment}
             * @param scalingAdjustment Amount of adjustment to make, based on the scaling adjustment type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingAdjustment(java.lang.Number scalingAdjustment) {
                this.scalingAdjustment = scalingAdjustment;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getScalingAdjustmentType}
             * @param scalingAdjustmentType The type of adjustment to make to a fleet's instance count.
             *                              <ul>
             *                              <li><em>ChangeInCapacity</em> -- add (or subtract) the scaling adjustment value from the current instance count. Positive values scale up while negative values scale down.</li>
             *                              <li><em>ExactCapacity</em> -- set the instance count to the scaling adjustment value.</li>
             *                              <li><em>PercentChangeInCapacity</em> -- increase or reduce the current instance count by the scaling adjustment, read as a percentage. Positive values scale up while negative values scale down.</li>
             *                              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingAdjustmentType(java.lang.String scalingAdjustmentType) {
                this.scalingAdjustmentType = scalingAdjustmentType;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getStatus}
             * @param status Current status of the scaling policy.
             *               The scaling policy can be in force only when in an <code>ACTIVE</code> status. Scaling policies can be suspended for individual fleets. If the policy is suspended for a fleet, the policy status does not change.
             *               <p>
             *               <ul>
             *               <li><em>ACTIVE</em> -- The scaling policy can be used for auto-scaling a fleet.</li>
             *               <li><em>UPDATE_REQUESTED</em> -- A request to update the scaling policy has been received.</li>
             *               <li><em>UPDATING</em> -- A change is being made to the scaling policy.</li>
             *               <li><em>DELETE_REQUESTED</em> -- A request to delete the scaling policy has been received.</li>
             *               <li><em>DELETING</em> -- The scaling policy is being deleted.</li>
             *               <li><em>DELETED</em> -- The scaling policy has been deleted.</li>
             *               <li><em>ERROR</em> -- An error occurred in creating the policy. It should be removed and recreated.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getTargetConfiguration}
             * @param targetConfiguration An object that contains settings for a target-based scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetConfiguration(software.amazon.awscdk.IResolvable targetConfiguration) {
                this.targetConfiguration = targetConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getTargetConfiguration}
             * @param targetConfiguration An object that contains settings for a target-based scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetConfiguration(software.amazon.awscdk.services.gamelift.CfnFleet.TargetConfigurationProperty targetConfiguration) {
                this.targetConfiguration = targetConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getThreshold}
             * @param threshold Metric value used to trigger a scaling event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threshold(java.lang.Number threshold) {
                this.threshold = threshold;
                return this;
            }

            /**
             * Sets the value of {@link ScalingPolicyProperty#getUpdateStatus}
             * @param updateStatus The current status of the fleet's scaling policies in a requested fleet location.
             *                     The status <code>PENDING_UPDATE</code> indicates that an update was requested for the fleet but has not yet been completed for the location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateStatus(java.lang.String updateStatus) {
                this.updateStatus = updateStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingPolicyProperty {
            private final java.lang.String metricName;
            private final java.lang.String name;
            private final java.lang.String comparisonOperator;
            private final java.lang.Number evaluationPeriods;
            private final java.lang.String location;
            private final java.lang.String policyType;
            private final java.lang.Number scalingAdjustment;
            private final java.lang.String scalingAdjustmentType;
            private final java.lang.String status;
            private final java.lang.Object targetConfiguration;
            private final java.lang.Number threshold;
            private final java.lang.String updateStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.evaluationPeriods = software.amazon.jsii.Kernel.get(this, "evaluationPeriods", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.policyType = software.amazon.jsii.Kernel.get(this, "policyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scalingAdjustment = software.amazon.jsii.Kernel.get(this, "scalingAdjustment", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scalingAdjustmentType = software.amazon.jsii.Kernel.get(this, "scalingAdjustmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetConfiguration = software.amazon.jsii.Kernel.get(this, "targetConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.threshold = software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.updateStatus = software.amazon.jsii.Kernel.get(this, "updateStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.comparisonOperator = builder.comparisonOperator;
                this.evaluationPeriods = builder.evaluationPeriods;
                this.location = builder.location;
                this.policyType = builder.policyType;
                this.scalingAdjustment = builder.scalingAdjustment;
                this.scalingAdjustmentType = builder.scalingAdjustmentType;
                this.status = builder.status;
                this.targetConfiguration = builder.targetConfiguration;
                this.threshold = builder.threshold;
                this.updateStatus = builder.updateStatus;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getComparisonOperator() {
                return this.comparisonOperator;
            }

            @Override
            public final java.lang.Number getEvaluationPeriods() {
                return this.evaluationPeriods;
            }

            @Override
            public final java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public final java.lang.String getPolicyType() {
                return this.policyType;
            }

            @Override
            public final java.lang.Number getScalingAdjustment() {
                return this.scalingAdjustment;
            }

            @Override
            public final java.lang.String getScalingAdjustmentType() {
                return this.scalingAdjustmentType;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Object getTargetConfiguration() {
                return this.targetConfiguration;
            }

            @Override
            public final java.lang.Number getThreshold() {
                return this.threshold;
            }

            @Override
            public final java.lang.String getUpdateStatus() {
                return this.updateStatus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getComparisonOperator() != null) {
                    data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
                }
                if (this.getEvaluationPeriods() != null) {
                    data.set("evaluationPeriods", om.valueToTree(this.getEvaluationPeriods()));
                }
                if (this.getLocation() != null) {
                    data.set("location", om.valueToTree(this.getLocation()));
                }
                if (this.getPolicyType() != null) {
                    data.set("policyType", om.valueToTree(this.getPolicyType()));
                }
                if (this.getScalingAdjustment() != null) {
                    data.set("scalingAdjustment", om.valueToTree(this.getScalingAdjustment()));
                }
                if (this.getScalingAdjustmentType() != null) {
                    data.set("scalingAdjustmentType", om.valueToTree(this.getScalingAdjustmentType()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getTargetConfiguration() != null) {
                    data.set("targetConfiguration", om.valueToTree(this.getTargetConfiguration()));
                }
                if (this.getThreshold() != null) {
                    data.set("threshold", om.valueToTree(this.getThreshold()));
                }
                if (this.getUpdateStatus() != null) {
                    data.set("updateStatus", om.valueToTree(this.getUpdateStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnFleet.ScalingPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingPolicyProperty.Jsii$Proxy that = (ScalingPolicyProperty.Jsii$Proxy) o;

                if (!metricName.equals(that.metricName)) return false;
                if (!name.equals(that.name)) return false;
                if (this.comparisonOperator != null ? !this.comparisonOperator.equals(that.comparisonOperator) : that.comparisonOperator != null) return false;
                if (this.evaluationPeriods != null ? !this.evaluationPeriods.equals(that.evaluationPeriods) : that.evaluationPeriods != null) return false;
                if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
                if (this.policyType != null ? !this.policyType.equals(that.policyType) : that.policyType != null) return false;
                if (this.scalingAdjustment != null ? !this.scalingAdjustment.equals(that.scalingAdjustment) : that.scalingAdjustment != null) return false;
                if (this.scalingAdjustmentType != null ? !this.scalingAdjustmentType.equals(that.scalingAdjustmentType) : that.scalingAdjustmentType != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                if (this.targetConfiguration != null ? !this.targetConfiguration.equals(that.targetConfiguration) : that.targetConfiguration != null) return false;
                if (this.threshold != null ? !this.threshold.equals(that.threshold) : that.threshold != null) return false;
                return this.updateStatus != null ? this.updateStatus.equals(that.updateStatus) : that.updateStatus == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricName.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.comparisonOperator != null ? this.comparisonOperator.hashCode() : 0);
                result = 31 * result + (this.evaluationPeriods != null ? this.evaluationPeriods.hashCode() : 0);
                result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
                result = 31 * result + (this.policyType != null ? this.policyType.hashCode() : 0);
                result = 31 * result + (this.scalingAdjustment != null ? this.scalingAdjustment.hashCode() : 0);
                result = 31 * result + (this.scalingAdjustmentType != null ? this.scalingAdjustmentType.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.targetConfiguration != null ? this.targetConfiguration.hashCode() : 0);
                result = 31 * result + (this.threshold != null ? this.threshold.hashCode() : 0);
                result = 31 * result + (this.updateStatus != null ? this.updateStatus.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A set of instructions for launching server processes on each instance in a fleet.
     * <p>
     * Server processes run either an executable in a custom game build or a Realtime Servers script.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * ServerProcessProperty serverProcessProperty = ServerProcessProperty.builder()
     *         .concurrentExecutions(123)
     *         .launchPath("launchPath")
     *         // the properties below are optional
     *         .parameters("parameters")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-serverprocess.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-serverprocess.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnFleet.ServerProcessProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerProcessProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerProcessProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of server processes using this configuration that run concurrently on each instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-serverprocess.html#cfn-gamelift-fleet-serverprocess-concurrentexecutions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-serverprocess.html#cfn-gamelift-fleet-serverprocess-concurrentexecutions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getConcurrentExecutions();

        /**
         * The location of a game build executable or Realtime script.
         * <p>
         * Game builds and Realtime scripts are installed on instances at the root:
         * <p>
         * <ul>
         * <li>Windows (custom game builds only): <code>C:\game</code> . Example: " <code>C:\game\MyGame\server.exe</code> "</li>
         * <li>Linux: <code>/local/game</code> . Examples: " <code>/local/game/MyGame/server.exe</code> " or " <code>/local/game/MyRealtimeScript.js</code> "</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Amazon GameLift doesn't support the use of setup scripts that launch the game executable. For custom game builds, this parameter must indicate the executable that calls the server SDK operations <code>initSDK()</code> and <code>ProcessReady()</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-serverprocess.html#cfn-gamelift-fleet-serverprocess-launchpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-serverprocess.html#cfn-gamelift-fleet-serverprocess-launchpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLaunchPath();

        /**
         * An optional list of parameters to pass to the server executable or Realtime script on launch.
         * <p>
         * Length Constraints: Minimum length of 1. Maximum length of 1024.
         * <p>
         * Pattern: [A-Za-z0-9_:.+/- =&#64;{},?'[]"]+
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-serverprocess.html#cfn-gamelift-fleet-serverprocess-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-serverprocess.html#cfn-gamelift-fleet-serverprocess-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerProcessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerProcessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerProcessProperty> {
            java.lang.Number concurrentExecutions;
            java.lang.String launchPath;
            java.lang.String parameters;

            /**
             * Sets the value of {@link ServerProcessProperty#getConcurrentExecutions}
             * @param concurrentExecutions The number of server processes using this configuration that run concurrently on each instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder concurrentExecutions(java.lang.Number concurrentExecutions) {
                this.concurrentExecutions = concurrentExecutions;
                return this;
            }

            /**
             * Sets the value of {@link ServerProcessProperty#getLaunchPath}
             * @param launchPath The location of a game build executable or Realtime script. This parameter is required.
             *                   Game builds and Realtime scripts are installed on instances at the root:
             *                   <p>
             *                   <ul>
             *                   <li>Windows (custom game builds only): <code>C:\game</code> . Example: " <code>C:\game\MyGame\server.exe</code> "</li>
             *                   <li>Linux: <code>/local/game</code> . Examples: " <code>/local/game/MyGame/server.exe</code> " or " <code>/local/game/MyRealtimeScript.js</code> "</li>
             *                   </ul>
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   Amazon GameLift doesn't support the use of setup scripts that launch the game executable. For custom game builds, this parameter must indicate the executable that calls the server SDK operations <code>initSDK()</code> and <code>ProcessReady()</code> .
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchPath(java.lang.String launchPath) {
                this.launchPath = launchPath;
                return this;
            }

            /**
             * Sets the value of {@link ServerProcessProperty#getParameters}
             * @param parameters An optional list of parameters to pass to the server executable or Realtime script on launch.
             *                   Length Constraints: Minimum length of 1. Maximum length of 1024.
             *                   <p>
             *                   Pattern: [A-Za-z0-9_:.+/- =&#64;{},?'[]"]+
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.lang.String parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerProcessProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerProcessProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerProcessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerProcessProperty {
            private final java.lang.Number concurrentExecutions;
            private final java.lang.String launchPath;
            private final java.lang.String parameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.concurrentExecutions = software.amazon.jsii.Kernel.get(this, "concurrentExecutions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.launchPath = software.amazon.jsii.Kernel.get(this, "launchPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.concurrentExecutions = java.util.Objects.requireNonNull(builder.concurrentExecutions, "concurrentExecutions is required");
                this.launchPath = java.util.Objects.requireNonNull(builder.launchPath, "launchPath is required");
                this.parameters = builder.parameters;
            }

            @Override
            public final java.lang.Number getConcurrentExecutions() {
                return this.concurrentExecutions;
            }

            @Override
            public final java.lang.String getLaunchPath() {
                return this.launchPath;
            }

            @Override
            public final java.lang.String getParameters() {
                return this.parameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("concurrentExecutions", om.valueToTree(this.getConcurrentExecutions()));
                data.set("launchPath", om.valueToTree(this.getLaunchPath()));
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnFleet.ServerProcessProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerProcessProperty.Jsii$Proxy that = (ServerProcessProperty.Jsii$Proxy) o;

                if (!concurrentExecutions.equals(that.concurrentExecutions)) return false;
                if (!launchPath.equals(that.launchPath)) return false;
                return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.concurrentExecutions.hashCode();
                result = 31 * result + (this.launchPath.hashCode());
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings for a target-based scaling policy.
     * <p>
     * A target-based policy tracks a particular fleet metric specifies a target value for the metric. As player usage changes, the policy triggers Amazon GameLift to adjust capacity so that the metric returns to the target value. The target configuration specifies settings as needed for the target based policy, including the target value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * TargetConfigurationProperty targetConfigurationProperty = TargetConfigurationProperty.builder()
     *         .targetValue(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-targetconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-targetconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnFleet.TargetConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Desired value to use with a target-based scaling policy.
         * <p>
         * The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-targetconfiguration.html#cfn-gamelift-fleet-targetconfiguration-targetvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-targetconfiguration.html#cfn-gamelift-fleet-targetconfiguration-targetvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTargetValue();

        /**
         * @return a {@link Builder} of {@link TargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetConfigurationProperty> {
            java.lang.Number targetValue;

            /**
             * Sets the value of {@link TargetConfigurationProperty#getTargetValue}
             * @param targetValue Desired value to use with a target-based scaling policy. This parameter is required.
             *                    The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetValue(java.lang.Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetConfigurationProperty {
            private final java.lang.Number targetValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetValue = software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetValue = java.util.Objects.requireNonNull(builder.targetValue, "targetValue is required");
            }

            @Override
            public final java.lang.Number getTargetValue() {
                return this.targetValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetValue", om.valueToTree(this.getTargetValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnFleet.TargetConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetConfigurationProperty.Jsii$Proxy that = (TargetConfigurationProperty.Jsii$Proxy) o;

                return this.targetValue.equals(that.targetValue);
            }

            @Override
            public final int hashCode() {
                int result = this.targetValue.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.gamelift.CfnFleet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.gamelift.CfnFleet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.gamelift.CfnFleetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.gamelift.CfnFleetProps.Builder();
        }

        /**
         * A descriptive label that is associated with a fleet.
         * <p>
         * Fleet names do not need to be unique.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-name</a>
         * @param name A descriptive label that is associated with a fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Amazon GameLift Anywhere configuration options.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-anywhereconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-anywhereconfiguration</a>
         * @param anywhereConfiguration Amazon GameLift Anywhere configuration options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder anywhereConfiguration(final software.amazon.awscdk.IResolvable anywhereConfiguration) {
            this.props.anywhereConfiguration(anywhereConfiguration);
            return this;
        }
        /**
         * Amazon GameLift Anywhere configuration options.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-anywhereconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-anywhereconfiguration</a>
         * @param anywhereConfiguration Amazon GameLift Anywhere configuration options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder anywhereConfiguration(final software.amazon.awscdk.services.gamelift.CfnFleet.AnywhereConfigurationProperty anywhereConfiguration) {
            this.props.anywhereConfiguration(anywhereConfiguration);
            return this;
        }

        /**
         * Current resource capacity settings in a specified fleet or location.
         * <p>
         * The location value might refer to a fleet's remote location or its home Region.
         * <p>
         * <em>Related actions</em>
         * <p>
         * <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html">DescribeFleetCapacity</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html">DescribeFleetLocationCapacity</a> | <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html">UpdateFleetCapacity</a>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-applycapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-applycapacity</a>
         * @param applyCapacity Current resource capacity settings in a specified fleet or location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyCapacity(final java.lang.String applyCapacity) {
            this.props.applyCapacity(applyCapacity);
            return this;
        }

        /**
         * A unique identifier for a build to be deployed on the new fleet.
         * <p>
         * If you are deploying the fleet with a custom game build, you must specify this property. The build must have been successfully uploaded to Amazon GameLift and be in a <code>READY</code> status. This fleet setting cannot be changed once the fleet is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-buildid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-buildid</a>
         * @param buildId A unique identifier for a build to be deployed on the new fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildId(final java.lang.String buildId) {
            this.props.buildId(buildId);
            return this;
        }

        /**
         * Prompts Amazon GameLift to generate a TLS/SSL certificate for the fleet.
         * <p>
         * Amazon GameLift uses the certificates to encrypt traffic between game clients and the game servers running on Amazon GameLift. By default, the <code>CertificateConfiguration</code> is <code>DISABLED</code> . You can't change this property after you create the fleet.
         * <p>
         * AWS Certificate Manager (ACM) certificates expire after 13 months. Certificate expiration can cause fleets to fail, preventing players from connecting to instances in the fleet. We recommend you replace fleets before 13 months, consider using fleet aliases for a smooth transition.
         * <p>
         * <blockquote>
         * <p>
         * ACM isn't available in all AWS regions. A fleet creation request with certificate generation enabled in an unsupported Region, fails with a 4xx error. For more information about the supported Regions, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-regions.html">Supported Regions</a> in the <em>AWS Certificate Manager User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-certificateconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-certificateconfiguration</a>
         * @param certificateConfiguration Prompts Amazon GameLift to generate a TLS/SSL certificate for the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateConfiguration(final software.amazon.awscdk.IResolvable certificateConfiguration) {
            this.props.certificateConfiguration(certificateConfiguration);
            return this;
        }
        /**
         * Prompts Amazon GameLift to generate a TLS/SSL certificate for the fleet.
         * <p>
         * Amazon GameLift uses the certificates to encrypt traffic between game clients and the game servers running on Amazon GameLift. By default, the <code>CertificateConfiguration</code> is <code>DISABLED</code> . You can't change this property after you create the fleet.
         * <p>
         * AWS Certificate Manager (ACM) certificates expire after 13 months. Certificate expiration can cause fleets to fail, preventing players from connecting to instances in the fleet. We recommend you replace fleets before 13 months, consider using fleet aliases for a smooth transition.
         * <p>
         * <blockquote>
         * <p>
         * ACM isn't available in all AWS regions. A fleet creation request with certificate generation enabled in an unsupported Region, fails with a 4xx error. For more information about the supported Regions, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-regions.html">Supported Regions</a> in the <em>AWS Certificate Manager User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-certificateconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-certificateconfiguration</a>
         * @param certificateConfiguration Prompts Amazon GameLift to generate a TLS/SSL certificate for the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateConfiguration(final software.amazon.awscdk.services.gamelift.CfnFleet.CertificateConfigurationProperty certificateConfiguration) {
            this.props.certificateConfiguration(certificateConfiguration);
            return this;
        }

        /**
         * The type of compute resource used to host your game servers.
         * <p>
         * You can use your own compute resources with Amazon GameLift Anywhere or use Amazon EC2 instances with managed Amazon GameLift. By default, this property is set to <code>EC2</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-computetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-computetype</a>
         * @param computeType The type of compute resource used to host your game servers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeType(final java.lang.String computeType) {
            this.props.computeType(computeType);
            return this;
        }

        /**
         * A description for the fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-description</a>
         * @param description A description for the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The number of EC2 instances that you want this fleet to host.
         * <p>
         * When creating a new fleet, GameLift automatically sets this value to "1" and initiates a single instance. Once the fleet is active, update this value to trigger GameLift to add or remove instances from the fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-desiredec2instances">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-desiredec2instances</a>
         * @param desiredEc2Instances The number of EC2 instances that you want this fleet to host. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredEc2Instances(final java.lang.Number desiredEc2Instances) {
            this.props.desiredEc2Instances(desiredEc2Instances);
            return this;
        }

        /**
         * The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet.
         * <p>
         * If the fleet is hosting a custom game build, this property must be set before players can connect to game sessions. For Realtime Servers fleets, Amazon GameLift automatically sets TCP and UDP ranges.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-ec2inboundpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-ec2inboundpermissions</a>
         * @param ec2InboundPermissions The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2InboundPermissions(final software.amazon.awscdk.IResolvable ec2InboundPermissions) {
            this.props.ec2InboundPermissions(ec2InboundPermissions);
            return this;
        }
        /**
         * The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet.
         * <p>
         * If the fleet is hosting a custom game build, this property must be set before players can connect to game sessions. For Realtime Servers fleets, Amazon GameLift automatically sets TCP and UDP ranges.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-ec2inboundpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-ec2inboundpermissions</a>
         * @param ec2InboundPermissions The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2InboundPermissions(final java.util.List<? extends java.lang.Object> ec2InboundPermissions) {
            this.props.ec2InboundPermissions(ec2InboundPermissions);
            return this;
        }

        /**
         * The Amazon GameLift-supported Amazon EC2 instance type to use for all fleet instances.
         * <p>
         * Instance type determines the computing resources that will be used to host your game servers, including CPU, memory, storage, and networking capacity. See <a href="https://docs.aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions of Amazon EC2 instance types.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-ec2instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-ec2instancetype</a>
         * @param ec2InstanceType The Amazon GameLift-supported Amazon EC2 instance type to use for all fleet instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2InstanceType(final java.lang.String ec2InstanceType) {
            this.props.ec2InstanceType(ec2InstanceType);
            return this;
        }

        /**
         * Indicates whether to use On-Demand or Spot instances for this fleet.
         * <p>
         * By default, this property is set to <code>ON_DEMAND</code> . Learn more about when to use <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot">On-Demand versus Spot Instances</a> . This fleet property can't be changed after the fleet is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-fleettype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-fleettype</a>
         * @param fleetType Indicates whether to use On-Demand or Spot instances for this fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetType(final java.lang.String fleetType) {
            this.props.fleetType(fleetType);
            return this;
        }

        /**
         * A unique identifier for an IAM role with access permissions to other AWS services.
         * <p>
         * Any application that runs on an instance in the fleet--including install scripts, server processes, and other processes--can use these permissions to interact with AWS resources that you own or have access to. For more information about using the role with your game server builds, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html">Communicate with other AWS resources from your fleets</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-instancerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-instancerolearn</a>
         * @param instanceRoleArn A unique identifier for an IAM role with access permissions to other AWS services. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRoleArn(final java.lang.String instanceRoleArn) {
            this.props.instanceRoleArn(instanceRoleArn);
            return this;
        }

        /**
         * Indicates that fleet instances maintain a shared credentials file for the IAM role defined in <code>InstanceRoleArn</code> .
         * <p>
         * Shared credentials allow applications that are deployed with the game server executable to communicate with other AWS resources. This property is used only when the game server is integrated with the server SDK version 5.x. For more information about using shared credentials, see <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html">Communicate with other AWS resources from your fleets</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-instancerolecredentialsprovider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-instancerolecredentialsprovider</a>
         * @param instanceRoleCredentialsProvider Indicates that fleet instances maintain a shared credentials file for the IAM role defined in <code>InstanceRoleArn</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRoleCredentialsProvider(final java.lang.String instanceRoleCredentialsProvider) {
            this.props.instanceRoleCredentialsProvider(instanceRoleCredentialsProvider);
            return this;
        }

        /**
         * A set of remote locations to deploy additional instances to and manage as part of the fleet.
         * <p>
         * This parameter can only be used when creating fleets in AWS Regions that support multiple locations. You can add any Amazon GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as <code>us-west-2</code> . To create a fleet with instances in the home Region only, don't use this parameter.
         * <p>
         * To use this parameter, Amazon GameLift requires you to use your home location in the request.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-locations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-locations</a>
         * @param locations A set of remote locations to deploy additional instances to and manage as part of the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locations(final software.amazon.awscdk.IResolvable locations) {
            this.props.locations(locations);
            return this;
        }
        /**
         * A set of remote locations to deploy additional instances to and manage as part of the fleet.
         * <p>
         * This parameter can only be used when creating fleets in AWS Regions that support multiple locations. You can add any Amazon GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as <code>us-west-2</code> . To create a fleet with instances in the home Region only, don't use this parameter.
         * <p>
         * To use this parameter, Amazon GameLift requires you to use your home location in the request.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-locations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-locations</a>
         * @param locations A set of remote locations to deploy additional instances to and manage as part of the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locations(final java.util.List<? extends java.lang.Object> locations) {
            this.props.locations(locations);
            return this;
        }

        /**
         * (deprecated) This parameter is no longer used.
         * <p>
         * When hosting a custom game build, specify where Amazon GameLift should store log files using the Amazon GameLift server API call ProcessReady()
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-logpaths">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-logpaths</a>
         * @deprecated this property has been deprecated
         * @param logPaths This parameter is no longer used. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder logPaths(final java.util.List<java.lang.String> logPaths) {
            this.props.logPaths(logPaths);
            return this;
        }

        /**
         * The maximum number of instances that are allowed in the specified fleet location.
         * <p>
         * If this parameter is not set, the default is 1.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-maxsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-maxsize</a>
         * @param maxSize The maximum number of instances that are allowed in the specified fleet location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSize(final java.lang.Number maxSize) {
            this.props.maxSize(maxSize);
            return this;
        }

        /**
         * The name of an AWS CloudWatch metric group to add this fleet to.
         * <p>
         * A metric group is used to aggregate the metrics for multiple fleets. You can specify an existing metric group name or set a new name to create a new metric group. A fleet can be included in only one metric group at a time.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-metricgroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-metricgroups</a>
         * @param metricGroups The name of an AWS CloudWatch metric group to add this fleet to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricGroups(final java.util.List<java.lang.String> metricGroups) {
            this.props.metricGroups(metricGroups);
            return this;
        }

        /**
         * The minimum number of instances that are allowed in the specified fleet location.
         * <p>
         * If this parameter is not set, the default is 0.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-minsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-minsize</a>
         * @param minSize The minimum number of instances that are allowed in the specified fleet location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSize(final java.lang.Number minSize) {
            this.props.minSize(minSize);
            return this;
        }

        /**
         * The status of termination protection for active game sessions on the fleet.
         * <p>
         * By default, this property is set to <code>NoProtection</code> .
         * <p>
         * <ul>
         * <li><em>NoProtection</em> - Game sessions can be terminated during active gameplay as a result of a scale-down event.</li>
         * <li><em>FullProtection</em> - Game sessions in <code>ACTIVE</code> status cannot be terminated during a scale-down event.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-newgamesessionprotectionpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-newgamesessionprotectionpolicy</a>
         * @param newGameSessionProtectionPolicy The status of termination protection for active game sessions on the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder newGameSessionProtectionPolicy(final java.lang.String newGameSessionProtectionPolicy) {
            this.props.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy);
            return this;
        }

        /**
         * Used when peering your Amazon GameLift fleet with a VPC, the unique identifier for the AWS account that owns the VPC.
         * <p>
         * You can find your account ID in the AWS Management Console under account settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-peervpcawsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-peervpcawsaccountid</a>
         * @param peerVpcAwsAccountId Used when peering your Amazon GameLift fleet with a VPC, the unique identifier for the AWS account that owns the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peerVpcAwsAccountId(final java.lang.String peerVpcAwsAccountId) {
            this.props.peerVpcAwsAccountId(peerVpcAwsAccountId);
            return this;
        }

        /**
         * A unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet.
         * <p>
         * The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://docs.aws.amazon.com/vpc/">VPC Dashboard</a> in the AWS Management Console . Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with Amazon GameLift Fleets</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-peervpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-peervpcid</a>
         * @param peerVpcId A unique identifier for a VPC with resources to be accessed by your Amazon GameLift fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peerVpcId(final java.lang.String peerVpcId) {
            this.props.peerVpcId(peerVpcId);
            return this;
        }

        /**
         * A policy that limits the number of game sessions that an individual player can create on instances in this fleet within a specified span of time.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-resourcecreationlimitpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-resourcecreationlimitpolicy</a>
         * @param resourceCreationLimitPolicy A policy that limits the number of game sessions that an individual player can create on instances in this fleet within a specified span of time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceCreationLimitPolicy(final software.amazon.awscdk.IResolvable resourceCreationLimitPolicy) {
            this.props.resourceCreationLimitPolicy(resourceCreationLimitPolicy);
            return this;
        }
        /**
         * A policy that limits the number of game sessions that an individual player can create on instances in this fleet within a specified span of time.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-resourcecreationlimitpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-resourcecreationlimitpolicy</a>
         * @param resourceCreationLimitPolicy A policy that limits the number of game sessions that an individual player can create on instances in this fleet within a specified span of time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceCreationLimitPolicy(final software.amazon.awscdk.services.gamelift.CfnFleet.ResourceCreationLimitPolicyProperty resourceCreationLimitPolicy) {
            this.props.resourceCreationLimitPolicy(resourceCreationLimitPolicy);
            return this;
        }

        /**
         * Instructions for how to launch and maintain server processes on instances in the fleet.
         * <p>
         * The runtime configuration defines one or more server process configurations, each identifying a build executable or Realtime script file and the number of processes of that type to run concurrently.
         * <p>
         * <blockquote>
         * <p>
         * The <code>RuntimeConfiguration</code> parameter is required unless the fleet is being configured using the older parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code> , which are still supported for backward compatibility.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-runtimeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-runtimeconfiguration</a>
         * @param runtimeConfiguration Instructions for how to launch and maintain server processes on instances in the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeConfiguration(final software.amazon.awscdk.IResolvable runtimeConfiguration) {
            this.props.runtimeConfiguration(runtimeConfiguration);
            return this;
        }
        /**
         * Instructions for how to launch and maintain server processes on instances in the fleet.
         * <p>
         * The runtime configuration defines one or more server process configurations, each identifying a build executable or Realtime script file and the number of processes of that type to run concurrently.
         * <p>
         * <blockquote>
         * <p>
         * The <code>RuntimeConfiguration</code> parameter is required unless the fleet is being configured using the older parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code> , which are still supported for backward compatibility.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-runtimeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-runtimeconfiguration</a>
         * @param runtimeConfiguration Instructions for how to launch and maintain server processes on instances in the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeConfiguration(final software.amazon.awscdk.services.gamelift.CfnFleet.RuntimeConfigurationProperty runtimeConfiguration) {
            this.props.runtimeConfiguration(runtimeConfiguration);
            return this;
        }

        /**
         * Rule that controls how a fleet is scaled.
         * <p>
         * Scaling policies are uniquely identified by the combination of name and fleet ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-scalingpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-scalingpolicies</a>
         * @param scalingPolicies Rule that controls how a fleet is scaled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingPolicies(final software.amazon.awscdk.IResolvable scalingPolicies) {
            this.props.scalingPolicies(scalingPolicies);
            return this;
        }
        /**
         * Rule that controls how a fleet is scaled.
         * <p>
         * Scaling policies are uniquely identified by the combination of name and fleet ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-scalingpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-scalingpolicies</a>
         * @param scalingPolicies Rule that controls how a fleet is scaled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingPolicies(final java.util.List<? extends java.lang.Object> scalingPolicies) {
            this.props.scalingPolicies(scalingPolicies);
            return this;
        }

        /**
         * The unique identifier for a Realtime configuration script to be deployed on fleet instances.
         * <p>
         * You can use either the script ID or ARN. Scripts must be uploaded to Amazon GameLift prior to creating the fleet. This fleet property cannot be changed later.
         * <p>
         * <blockquote>
         * <p>
         * You can't use the <code>!Ref</code> command to reference a script created with a CloudFormation template for the fleet property <code>ScriptId</code> . Instead, use <code>Fn::GetAtt Script.Arn</code> or <code>Fn::GetAtt Script.Id</code> to retrieve either of these properties as input for <code>ScriptId</code> . Alternatively, enter a <code>ScriptId</code> string manually.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-scriptid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-scriptid</a>
         * @param scriptId The unique identifier for a Realtime configuration script to be deployed on fleet instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scriptId(final java.lang.String scriptId) {
            this.props.scriptId(scriptId);
            return this;
        }

        /**
         * (deprecated) This parameter is no longer used but is retained for backward compatibility.
         * <p>
         * Instead, specify server launch parameters in the RuntimeConfiguration parameter. A request must specify either a runtime configuration or values for both ServerLaunchParameters and ServerLaunchPath.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-serverlaunchparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-serverlaunchparameters</a>
         * @deprecated this property has been deprecated
         * @param serverLaunchParameters This parameter is no longer used but is retained for backward compatibility. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder serverLaunchParameters(final java.lang.String serverLaunchParameters) {
            this.props.serverLaunchParameters(serverLaunchParameters);
            return this;
        }

        /**
         * (deprecated) This parameter is no longer used.
         * <p>
         * Instead, specify a server launch path using the RuntimeConfiguration parameter. Requests that specify a server launch path and launch parameters instead of a runtime configuration will continue to work.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-serverlaunchpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-serverlaunchpath</a>
         * @deprecated this property has been deprecated
         * @param serverLaunchPath This parameter is no longer used. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder serverLaunchPath(final java.lang.String serverLaunchPath) {
            this.props.serverLaunchPath(serverLaunchPath);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.gamelift.CfnFleet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.gamelift.CfnFleet build() {
            return new software.amazon.awscdk.services.gamelift.CfnFleet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
