package software.amazon.awscdk.services.glue;

/**
 * Properties for defining a <code>CfnDataCatalogEncryptionSettings</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * CfnDataCatalogEncryptionSettingsProps cfnDataCatalogEncryptionSettingsProps = CfnDataCatalogEncryptionSettingsProps.builder()
 *         .catalogId("catalogId")
 *         .dataCatalogEncryptionSettings(DataCatalogEncryptionSettingsProperty.builder()
 *                 .connectionPasswordEncryption(ConnectionPasswordEncryptionProperty.builder()
 *                         .kmsKeyId("kmsKeyId")
 *                         .returnConnectionPasswordEncrypted(false)
 *                         .build())
 *                 .encryptionAtRest(EncryptionAtRestProperty.builder()
 *                         .catalogEncryptionMode("catalogEncryptionMode")
 *                         .catalogEncryptionServiceRole("catalogEncryptionServiceRole")
 *                         .sseAwsKmsKeyId("sseAwsKmsKeyId")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:55.982Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnDataCatalogEncryptionSettingsProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataCatalogEncryptionSettingsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataCatalogEncryptionSettingsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the Data Catalog in which the settings are created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-catalogid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

    /**
     * Contains configuration information for maintaining Data Catalog security.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-datacatalogencryptionsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-datacatalogencryptionsettings.html#cfn-glue-datacatalogencryptionsettings-datacatalogencryptionsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDataCatalogEncryptionSettings();

    /**
     * @return a {@link Builder} of {@link CfnDataCatalogEncryptionSettingsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataCatalogEncryptionSettingsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataCatalogEncryptionSettingsProps> {
        java.lang.String catalogId;
        java.lang.Object dataCatalogEncryptionSettings;

        /**
         * Sets the value of {@link CfnDataCatalogEncryptionSettingsProps#getCatalogId}
         * @param catalogId The ID of the Data Catalog in which the settings are created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catalogId(java.lang.String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataCatalogEncryptionSettingsProps#getDataCatalogEncryptionSettings}
         * @param dataCatalogEncryptionSettings Contains configuration information for maintaining Data Catalog security. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCatalogEncryptionSettings(software.amazon.awscdk.IResolvable dataCatalogEncryptionSettings) {
            this.dataCatalogEncryptionSettings = dataCatalogEncryptionSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataCatalogEncryptionSettingsProps#getDataCatalogEncryptionSettings}
         * @param dataCatalogEncryptionSettings Contains configuration information for maintaining Data Catalog security. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCatalogEncryptionSettings(software.amazon.awscdk.services.glue.CfnDataCatalogEncryptionSettings.DataCatalogEncryptionSettingsProperty dataCatalogEncryptionSettings) {
            this.dataCatalogEncryptionSettings = dataCatalogEncryptionSettings;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataCatalogEncryptionSettingsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataCatalogEncryptionSettingsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataCatalogEncryptionSettingsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataCatalogEncryptionSettingsProps {
        private final java.lang.String catalogId;
        private final java.lang.Object dataCatalogEncryptionSettings;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataCatalogEncryptionSettings = software.amazon.jsii.Kernel.get(this, "dataCatalogEncryptionSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
            this.dataCatalogEncryptionSettings = java.util.Objects.requireNonNull(builder.dataCatalogEncryptionSettings, "dataCatalogEncryptionSettings is required");
        }

        @Override
        public final java.lang.String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final java.lang.Object getDataCatalogEncryptionSettings() {
            return this.dataCatalogEncryptionSettings;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("catalogId", om.valueToTree(this.getCatalogId()));
            data.set("dataCatalogEncryptionSettings", om.valueToTree(this.getDataCatalogEncryptionSettings()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnDataCatalogEncryptionSettingsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataCatalogEncryptionSettingsProps.Jsii$Proxy that = (CfnDataCatalogEncryptionSettingsProps.Jsii$Proxy) o;

            if (!catalogId.equals(that.catalogId)) return false;
            return this.dataCatalogEncryptionSettings.equals(that.dataCatalogEncryptionSettings);
        }

        @Override
        public final int hashCode() {
            int result = this.catalogId.hashCode();
            result = 31 * result + (this.dataCatalogEncryptionSettings.hashCode());
            return result;
        }
    }
}
