package software.amazon.awscdk.services.glue;

/**
 * Properties for defining a <code>CfnJob</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * Object defaultArguments;
 * Object nonOverridableArguments;
 * Object tags;
 * CfnJobProps cfnJobProps = CfnJobProps.builder()
 *         .command(JobCommandProperty.builder()
 *                 .name("name")
 *                 .pythonVersion("pythonVersion")
 *                 .runtime("runtime")
 *                 .scriptLocation("scriptLocation")
 *                 .build())
 *         .role("role")
 *         // the properties below are optional
 *         .allocatedCapacity(123)
 *         .connections(ConnectionsListProperty.builder()
 *                 .connections(List.of("connections"))
 *                 .build())
 *         .defaultArguments(defaultArguments)
 *         .description("description")
 *         .executionClass("executionClass")
 *         .executionProperty(ExecutionPropertyProperty.builder()
 *                 .maxConcurrentRuns(123)
 *                 .build())
 *         .glueVersion("glueVersion")
 *         .logUri("logUri")
 *         .maxCapacity(123)
 *         .maxRetries(123)
 *         .name("name")
 *         .nonOverridableArguments(nonOverridableArguments)
 *         .notificationProperty(NotificationPropertyProperty.builder()
 *                 .notifyDelayAfter(123)
 *                 .build())
 *         .numberOfWorkers(123)
 *         .securityConfiguration("securityConfiguration")
 *         .tags(tags)
 *         .timeout(123)
 *         .workerType("workerType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:55.995Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnJobProps")
@software.amazon.jsii.Jsii.Proxy(CfnJobProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnJobProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The code that executes a job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-command">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-command</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getCommand();

    /**
     * The name or Amazon Resource Name (ARN) of the IAM role associated with this job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-role</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRole();

    /**
     * This parameter is no longer supported. Use <code>MaxCapacity</code> instead.
     * <p>
     * The number of capacity units that are allocated to this job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-allocatedcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-allocatedcapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAllocatedCapacity() {
        return null;
    }

    /**
     * The connections used for this job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-connections">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-connections</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConnections() {
        return null;
    }

    /**
     * The default arguments for this job, specified as name-value pairs.
     * <p>
     * You can specify arguments here that your own job-execution script consumes, in addition to arguments that AWS Glue itself consumes.
     * <p>
     * For information about how to specify and consume your own job arguments, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling AWS Glue APIs in Python</a> in the <em>AWS Glue Developer Guide</em> .
     * <p>
     * For information about the key-value pairs that AWS Glue consumes to set up your job, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by AWS Glue</a> in the <em>AWS Glue Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-defaultarguments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-defaultarguments</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultArguments() {
        return null;
    }

    /**
     * A description of the job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Indicates whether the job is run with a standard or flexible execution class.
     * <p>
     * The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources.
     * <p>
     * The flexible execution class is appropriate for time-insensitive jobs whose start and completion times may vary.
     * <p>
     * Only jobs with AWS Glue version 3.0 and above and command type <code>glueetl</code> will be allowed to set <code>ExecutionClass</code> to <code>FLEX</code> . The flexible execution class is available for Spark jobs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-executionclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-executionclass</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionClass() {
        return null;
    }

    /**
     * The maximum number of concurrent runs that are allowed for this job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-executionproperty">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-executionproperty</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExecutionProperty() {
        return null;
    }

    /**
     * Glue version determines the versions of Apache Spark and Python that AWS Glue supports.
     * <p>
     * The Python version indicates the version supported for jobs of type Spark.
     * <p>
     * For more information about the available AWS Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.
     * <p>
     * Jobs that are created without specifying a Glue version default to Glue 0.9.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-glueversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-glueversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGlueVersion() {
        return null;
    }

    /**
     * This field is reserved for future use.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-loguri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-loguri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogUri() {
        return null;
    }

    /**
     * The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs.
     * <p>
     * A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
     * <p>
     * Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code> .
     * <p>
     * The value that can be allocated for <code>MaxCapacity</code> depends on whether you are running a Python shell job or an Apache Spark ETL job:
     * <p>
     * <ul>
     * <li>When you specify a Python shell job ( <code>JobCommand.Name</code> ="pythonshell"), you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</li>
     * <li>When you specify an Apache Spark ETL job ( <code>JobCommand.Name</code> ="glueetl"), you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-maxcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-maxcapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
        return null;
    }

    /**
     * The maximum number of times to retry this job after a JobRun fails.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-maxretries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-maxretries</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxRetries() {
        return null;
    }

    /**
     * The name you assign to this job definition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Non-overridable arguments for this job, specified as name-value pairs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-nonoverridablearguments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-nonoverridablearguments</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNonOverridableArguments() {
        return null;
    }

    /**
     * Specifies configuration properties of a notification.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-notificationproperty">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-notificationproperty</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNotificationProperty() {
        return null;
    }

    /**
     * The number of workers of a defined <code>workerType</code> that are allocated when a job runs.
     * <p>
     * The maximum number of workers you can define are 299 for <code>G.1X</code> , and 149 for <code>G.2X</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-numberofworkers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-numberofworkers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfWorkers() {
        return null;
    }

    /**
     * The name of the <code>SecurityConfiguration</code> structure to be used with this job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-securityconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-securityconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityConfiguration() {
        return null;
    }

    /**
     * The tags to use with this job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * The job timeout in minutes.
     * <p>
     * This is the maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status. The default is 2,880 minutes (48 hours).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-timeout</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
        return null;
    }

    /**
     * The type of predefined worker that is allocated when a job runs.
     * <p>
     * Accepts a value of G.1X, G.2X, G.4X, G.8X or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
     * <p>
     * <ul>
     * <li>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPUs, 16 GB of memory) with 84GB disk (approximately 34GB free), and provides 1 executor per worker. We recommend this worker type for workloads such as data transforms, joins, and queries, to offers a scalable and cost effective way to run most jobs.</li>
     * <li>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPUs, 32 GB of memory) with 128GB disk (approximately 77GB free), and provides 1 executor per worker. We recommend this worker type for workloads such as data transforms, joins, and queries, to offers a scalable and cost effective way to run most jobs.</li>
     * <li>For the <code>G.4X</code> worker type, each worker maps to 4 DPU (16 vCPUs, 64 GB of memory) with 256GB disk (approximately 235GB free), and provides 1 executor per worker. We recommend this worker type for jobs whose workloads contain your most demanding transforms, aggregations, joins, and queries. This worker type is available only for AWS Glue version 3.0 or later Spark ETL jobs in the following AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).</li>
     * <li>For the <code>G.8X</code> worker type, each worker maps to 8 DPU (32 vCPUs, 128 GB of memory) with 512GB disk (approximately 487GB free), and provides 1 executor per worker. We recommend this worker type for jobs whose workloads contain your most demanding transforms, aggregations, joins, and queries. This worker type is available only for AWS Glue version 3.0 or later Spark ETL jobs, in the same AWS Regions as supported for the <code>G.4X</code> worker type.</li>
     * <li>For the <code>G.025X</code> worker type, each worker maps to 0.25 DPU (2 vCPUs, 4 GB of memory) with 84GB disk (approximately 34GB free), and provides 1 executor per worker. We recommend this worker type for low volume streaming jobs. This worker type is only available for AWS Glue version 3.0 streaming jobs.</li>
     * <li>For the <code>Z.2X</code> worker type, each worker maps to 2 M-DPU (8vCPUs, 64 GB of memory) with 128 GB disk (approximately 120GB free), and provides up to 8 Ray workers based on the autoscaler.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-workertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-job.html#cfn-glue-job-workertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkerType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnJobProps> {
        java.lang.Object command;
        java.lang.String role;
        java.lang.Number allocatedCapacity;
        java.lang.Object connections;
        java.lang.Object defaultArguments;
        java.lang.String description;
        java.lang.String executionClass;
        java.lang.Object executionProperty;
        java.lang.String glueVersion;
        java.lang.String logUri;
        java.lang.Number maxCapacity;
        java.lang.Number maxRetries;
        java.lang.String name;
        java.lang.Object nonOverridableArguments;
        java.lang.Object notificationProperty;
        java.lang.Number numberOfWorkers;
        java.lang.String securityConfiguration;
        java.lang.Object tags;
        java.lang.Number timeout;
        java.lang.String workerType;

        /**
         * Sets the value of {@link CfnJobProps#getCommand}
         * @param command The code that executes a job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(software.amazon.awscdk.IResolvable command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getCommand}
         * @param command The code that executes a job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(software.amazon.awscdk.services.glue.CfnJob.JobCommandProperty command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getRole}
         * @param role The name or Amazon Resource Name (ARN) of the IAM role associated with this job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(java.lang.String role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getAllocatedCapacity}
         * @param allocatedCapacity This parameter is no longer supported. Use <code>MaxCapacity</code> instead.
         *                          The number of capacity units that are allocated to this job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocatedCapacity(java.lang.Number allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getConnections}
         * @param connections The connections used for this job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connections(software.amazon.awscdk.IResolvable connections) {
            this.connections = connections;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getConnections}
         * @param connections The connections used for this job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connections(software.amazon.awscdk.services.glue.CfnJob.ConnectionsListProperty connections) {
            this.connections = connections;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getDefaultArguments}
         * @param defaultArguments The default arguments for this job, specified as name-value pairs.
         *                         You can specify arguments here that your own job-execution script consumes, in addition to arguments that AWS Glue itself consumes.
         *                         <p>
         *                         For information about how to specify and consume your own job arguments, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling AWS Glue APIs in Python</a> in the <em>AWS Glue Developer Guide</em> .
         *                         <p>
         *                         For information about the key-value pairs that AWS Glue consumes to set up your job, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by AWS Glue</a> in the <em>AWS Glue Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultArguments(java.lang.Object defaultArguments) {
            this.defaultArguments = defaultArguments;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getDescription}
         * @param description A description of the job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getExecutionClass}
         * @param executionClass Indicates whether the job is run with a standard or flexible execution class.
         *                       The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources.
         *                       <p>
         *                       The flexible execution class is appropriate for time-insensitive jobs whose start and completion times may vary.
         *                       <p>
         *                       Only jobs with AWS Glue version 3.0 and above and command type <code>glueetl</code> will be allowed to set <code>ExecutionClass</code> to <code>FLEX</code> . The flexible execution class is available for Spark jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionClass(java.lang.String executionClass) {
            this.executionClass = executionClass;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getExecutionProperty}
         * @param executionProperty The maximum number of concurrent runs that are allowed for this job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionProperty(software.amazon.awscdk.IResolvable executionProperty) {
            this.executionProperty = executionProperty;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getExecutionProperty}
         * @param executionProperty The maximum number of concurrent runs that are allowed for this job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionProperty(software.amazon.awscdk.services.glue.CfnJob.ExecutionPropertyProperty executionProperty) {
            this.executionProperty = executionProperty;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getGlueVersion}
         * @param glueVersion Glue version determines the versions of Apache Spark and Python that AWS Glue supports.
         *                    The Python version indicates the version supported for jobs of type Spark.
         *                    <p>
         *                    For more information about the available AWS Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.
         *                    <p>
         *                    Jobs that are created without specifying a Glue version default to Glue 0.9.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder glueVersion(java.lang.String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getLogUri}
         * @param logUri This field is reserved for future use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logUri(java.lang.String logUri) {
            this.logUri = logUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getMaxCapacity}
         * @param maxCapacity The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs.
         *                    A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
         *                    <p>
         *                    Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code> .
         *                    <p>
         *                    The value that can be allocated for <code>MaxCapacity</code> depends on whether you are running a Python shell job or an Apache Spark ETL job:
         *                    <p>
         *                    <ul>
         *                    <li>When you specify a Python shell job ( <code>JobCommand.Name</code> ="pythonshell"), you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</li>
         *                    <li>When you specify an Apache Spark ETL job ( <code>JobCommand.Name</code> ="glueetl"), you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</li>
         *                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(java.lang.Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getMaxRetries}
         * @param maxRetries The maximum number of times to retry this job after a JobRun fails.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRetries(java.lang.Number maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getName}
         * @param name The name you assign to this job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getNonOverridableArguments}
         * @param nonOverridableArguments Non-overridable arguments for this job, specified as name-value pairs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nonOverridableArguments(java.lang.Object nonOverridableArguments) {
            this.nonOverridableArguments = nonOverridableArguments;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getNotificationProperty}
         * @param notificationProperty Specifies configuration properties of a notification.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationProperty(software.amazon.awscdk.IResolvable notificationProperty) {
            this.notificationProperty = notificationProperty;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getNotificationProperty}
         * @param notificationProperty Specifies configuration properties of a notification.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationProperty(software.amazon.awscdk.services.glue.CfnJob.NotificationPropertyProperty notificationProperty) {
            this.notificationProperty = notificationProperty;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getNumberOfWorkers}
         * @param numberOfWorkers The number of workers of a defined <code>workerType</code> that are allocated when a job runs.
         *                        The maximum number of workers you can define are 299 for <code>G.1X</code> , and 149 for <code>G.2X</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numberOfWorkers(java.lang.Number numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getSecurityConfiguration}
         * @param securityConfiguration The name of the <code>SecurityConfiguration</code> structure to be used with this job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityConfiguration(java.lang.String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getTags}
         * @param tags The tags to use with this job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getTimeout}
         * @param timeout The job timeout in minutes.
         *                This is the maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status. The default is 2,880 minutes (48 hours).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(java.lang.Number timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getWorkerType}
         * @param workerType The type of predefined worker that is allocated when a job runs.
         *                   Accepts a value of G.1X, G.2X, G.4X, G.8X or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
         *                   <p>
         *                   <ul>
         *                   <li>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPUs, 16 GB of memory) with 84GB disk (approximately 34GB free), and provides 1 executor per worker. We recommend this worker type for workloads such as data transforms, joins, and queries, to offers a scalable and cost effective way to run most jobs.</li>
         *                   <li>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPUs, 32 GB of memory) with 128GB disk (approximately 77GB free), and provides 1 executor per worker. We recommend this worker type for workloads such as data transforms, joins, and queries, to offers a scalable and cost effective way to run most jobs.</li>
         *                   <li>For the <code>G.4X</code> worker type, each worker maps to 4 DPU (16 vCPUs, 64 GB of memory) with 256GB disk (approximately 235GB free), and provides 1 executor per worker. We recommend this worker type for jobs whose workloads contain your most demanding transforms, aggregations, joins, and queries. This worker type is available only for AWS Glue version 3.0 or later Spark ETL jobs in the following AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).</li>
         *                   <li>For the <code>G.8X</code> worker type, each worker maps to 8 DPU (32 vCPUs, 128 GB of memory) with 512GB disk (approximately 487GB free), and provides 1 executor per worker. We recommend this worker type for jobs whose workloads contain your most demanding transforms, aggregations, joins, and queries. This worker type is available only for AWS Glue version 3.0 or later Spark ETL jobs, in the same AWS Regions as supported for the <code>G.4X</code> worker type.</li>
         *                   <li>For the <code>G.025X</code> worker type, each worker maps to 0.25 DPU (2 vCPUs, 4 GB of memory) with 84GB disk (approximately 34GB free), and provides 1 executor per worker. We recommend this worker type for low volume streaming jobs. This worker type is only available for AWS Glue version 3.0 streaming jobs.</li>
         *                   <li>For the <code>Z.2X</code> worker type, each worker maps to 2 M-DPU (8vCPUs, 64 GB of memory) with 128 GB disk (approximately 120GB free), and provides up to 8 Ray workers based on the autoscaler.</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerType(java.lang.String workerType) {
            this.workerType = workerType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnJobProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnJobProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnJobProps {
        private final java.lang.Object command;
        private final java.lang.String role;
        private final java.lang.Number allocatedCapacity;
        private final java.lang.Object connections;
        private final java.lang.Object defaultArguments;
        private final java.lang.String description;
        private final java.lang.String executionClass;
        private final java.lang.Object executionProperty;
        private final java.lang.String glueVersion;
        private final java.lang.String logUri;
        private final java.lang.Number maxCapacity;
        private final java.lang.Number maxRetries;
        private final java.lang.String name;
        private final java.lang.Object nonOverridableArguments;
        private final java.lang.Object notificationProperty;
        private final java.lang.Number numberOfWorkers;
        private final java.lang.String securityConfiguration;
        private final java.lang.Object tags;
        private final java.lang.Number timeout;
        private final java.lang.String workerType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allocatedCapacity = software.amazon.jsii.Kernel.get(this, "allocatedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.connections = software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.defaultArguments = software.amazon.jsii.Kernel.get(this, "defaultArguments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionClass = software.amazon.jsii.Kernel.get(this, "executionClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionProperty = software.amazon.jsii.Kernel.get(this, "executionProperty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.glueVersion = software.amazon.jsii.Kernel.get(this, "glueVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logUri = software.amazon.jsii.Kernel.get(this, "logUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxRetries = software.amazon.jsii.Kernel.get(this, "maxRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nonOverridableArguments = software.amazon.jsii.Kernel.get(this, "nonOverridableArguments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.notificationProperty = software.amazon.jsii.Kernel.get(this, "notificationProperty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.numberOfWorkers = software.amazon.jsii.Kernel.get(this, "numberOfWorkers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.securityConfiguration = software.amazon.jsii.Kernel.get(this, "securityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.workerType = software.amazon.jsii.Kernel.get(this, "workerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.command = java.util.Objects.requireNonNull(builder.command, "command is required");
            this.role = java.util.Objects.requireNonNull(builder.role, "role is required");
            this.allocatedCapacity = builder.allocatedCapacity;
            this.connections = builder.connections;
            this.defaultArguments = builder.defaultArguments;
            this.description = builder.description;
            this.executionClass = builder.executionClass;
            this.executionProperty = builder.executionProperty;
            this.glueVersion = builder.glueVersion;
            this.logUri = builder.logUri;
            this.maxCapacity = builder.maxCapacity;
            this.maxRetries = builder.maxRetries;
            this.name = builder.name;
            this.nonOverridableArguments = builder.nonOverridableArguments;
            this.notificationProperty = builder.notificationProperty;
            this.numberOfWorkers = builder.numberOfWorkers;
            this.securityConfiguration = builder.securityConfiguration;
            this.tags = builder.tags;
            this.timeout = builder.timeout;
            this.workerType = builder.workerType;
        }

        @Override
        public final java.lang.Object getCommand() {
            return this.command;
        }

        @Override
        public final java.lang.String getRole() {
            return this.role;
        }

        @Override
        public final java.lang.Number getAllocatedCapacity() {
            return this.allocatedCapacity;
        }

        @Override
        public final java.lang.Object getConnections() {
            return this.connections;
        }

        @Override
        public final java.lang.Object getDefaultArguments() {
            return this.defaultArguments;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getExecutionClass() {
            return this.executionClass;
        }

        @Override
        public final java.lang.Object getExecutionProperty() {
            return this.executionProperty;
        }

        @Override
        public final java.lang.String getGlueVersion() {
            return this.glueVersion;
        }

        @Override
        public final java.lang.String getLogUri() {
            return this.logUri;
        }

        @Override
        public final java.lang.Number getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final java.lang.Number getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getNonOverridableArguments() {
            return this.nonOverridableArguments;
        }

        @Override
        public final java.lang.Object getNotificationProperty() {
            return this.notificationProperty;
        }

        @Override
        public final java.lang.Number getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        @Override
        public final java.lang.String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Number getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.lang.String getWorkerType() {
            return this.workerType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("command", om.valueToTree(this.getCommand()));
            data.set("role", om.valueToTree(this.getRole()));
            if (this.getAllocatedCapacity() != null) {
                data.set("allocatedCapacity", om.valueToTree(this.getAllocatedCapacity()));
            }
            if (this.getConnections() != null) {
                data.set("connections", om.valueToTree(this.getConnections()));
            }
            if (this.getDefaultArguments() != null) {
                data.set("defaultArguments", om.valueToTree(this.getDefaultArguments()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExecutionClass() != null) {
                data.set("executionClass", om.valueToTree(this.getExecutionClass()));
            }
            if (this.getExecutionProperty() != null) {
                data.set("executionProperty", om.valueToTree(this.getExecutionProperty()));
            }
            if (this.getGlueVersion() != null) {
                data.set("glueVersion", om.valueToTree(this.getGlueVersion()));
            }
            if (this.getLogUri() != null) {
                data.set("logUri", om.valueToTree(this.getLogUri()));
            }
            if (this.getMaxCapacity() != null) {
                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            }
            if (this.getMaxRetries() != null) {
                data.set("maxRetries", om.valueToTree(this.getMaxRetries()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getNonOverridableArguments() != null) {
                data.set("nonOverridableArguments", om.valueToTree(this.getNonOverridableArguments()));
            }
            if (this.getNotificationProperty() != null) {
                data.set("notificationProperty", om.valueToTree(this.getNotificationProperty()));
            }
            if (this.getNumberOfWorkers() != null) {
                data.set("numberOfWorkers", om.valueToTree(this.getNumberOfWorkers()));
            }
            if (this.getSecurityConfiguration() != null) {
                data.set("securityConfiguration", om.valueToTree(this.getSecurityConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getWorkerType() != null) {
                data.set("workerType", om.valueToTree(this.getWorkerType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnJobProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnJobProps.Jsii$Proxy that = (CfnJobProps.Jsii$Proxy) o;

            if (!command.equals(that.command)) return false;
            if (!role.equals(that.role)) return false;
            if (this.allocatedCapacity != null ? !this.allocatedCapacity.equals(that.allocatedCapacity) : that.allocatedCapacity != null) return false;
            if (this.connections != null ? !this.connections.equals(that.connections) : that.connections != null) return false;
            if (this.defaultArguments != null ? !this.defaultArguments.equals(that.defaultArguments) : that.defaultArguments != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.executionClass != null ? !this.executionClass.equals(that.executionClass) : that.executionClass != null) return false;
            if (this.executionProperty != null ? !this.executionProperty.equals(that.executionProperty) : that.executionProperty != null) return false;
            if (this.glueVersion != null ? !this.glueVersion.equals(that.glueVersion) : that.glueVersion != null) return false;
            if (this.logUri != null ? !this.logUri.equals(that.logUri) : that.logUri != null) return false;
            if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
            if (this.maxRetries != null ? !this.maxRetries.equals(that.maxRetries) : that.maxRetries != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.nonOverridableArguments != null ? !this.nonOverridableArguments.equals(that.nonOverridableArguments) : that.nonOverridableArguments != null) return false;
            if (this.notificationProperty != null ? !this.notificationProperty.equals(that.notificationProperty) : that.notificationProperty != null) return false;
            if (this.numberOfWorkers != null ? !this.numberOfWorkers.equals(that.numberOfWorkers) : that.numberOfWorkers != null) return false;
            if (this.securityConfiguration != null ? !this.securityConfiguration.equals(that.securityConfiguration) : that.securityConfiguration != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.workerType != null ? this.workerType.equals(that.workerType) : that.workerType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.command.hashCode();
            result = 31 * result + (this.role.hashCode());
            result = 31 * result + (this.allocatedCapacity != null ? this.allocatedCapacity.hashCode() : 0);
            result = 31 * result + (this.connections != null ? this.connections.hashCode() : 0);
            result = 31 * result + (this.defaultArguments != null ? this.defaultArguments.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.executionClass != null ? this.executionClass.hashCode() : 0);
            result = 31 * result + (this.executionProperty != null ? this.executionProperty.hashCode() : 0);
            result = 31 * result + (this.glueVersion != null ? this.glueVersion.hashCode() : 0);
            result = 31 * result + (this.logUri != null ? this.logUri.hashCode() : 0);
            result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
            result = 31 * result + (this.maxRetries != null ? this.maxRetries.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.nonOverridableArguments != null ? this.nonOverridableArguments.hashCode() : 0);
            result = 31 * result + (this.notificationProperty != null ? this.notificationProperty.hashCode() : 0);
            result = 31 * result + (this.numberOfWorkers != null ? this.numberOfWorkers.hashCode() : 0);
            result = 31 * result + (this.securityConfiguration != null ? this.securityConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.workerType != null ? this.workerType.hashCode() : 0);
            return result;
        }
    }
}
