package software.amazon.awscdk.services.internetmonitor;

/**
 * The <code>AWS::InternetMonitor::Monitor</code> resource is an Internet Monitor resource type that contains information about how you create a monitor in Amazon CloudWatch Internet Monitor.
 * <p>
 * A monitor in Internet Monitor provides visibility into performance and availability between your applications hosted on AWS and your end users, using a traffic profile that it creates based on the application resources that you add: Virtual Private Clouds (VPCs), Amazon CloudFront distributions, or WorkSpaces directories.
 * <p>
 * Internet Monitor also alerts you to internet issues that impact your application in the city-networks (geographies and networks) where your end users use it. With Internet Monitor, you can quickly pinpoint the locations and providers that are affected, so that you can address the issue.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-InternetMonitor.html">Using Amazon CloudWatch Internet Monitor</a> in the <em>Amazon CloudWatch User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.internetmonitor.*;
 * CfnMonitor cfnMonitor = CfnMonitor.Builder.create(this, "MyCfnMonitor")
 *         .monitorName("monitorName")
 *         // the properties below are optional
 *         .healthEventsConfig(HealthEventsConfigProperty.builder()
 *                 .availabilityLocalHealthEventsConfig(LocalHealthEventsConfigProperty.builder()
 *                         .healthScoreThreshold(123)
 *                         .minTrafficImpact(123)
 *                         .status("status")
 *                         .build())
 *                 .availabilityScoreThreshold(123)
 *                 .performanceLocalHealthEventsConfig(LocalHealthEventsConfigProperty.builder()
 *                         .healthScoreThreshold(123)
 *                         .minTrafficImpact(123)
 *                         .status("status")
 *                         .build())
 *                 .performanceScoreThreshold(123)
 *                 .build())
 *         .internetMeasurementsLogDelivery(InternetMeasurementsLogDeliveryProperty.builder()
 *                 .s3Config(S3ConfigProperty.builder()
 *                         .bucketName("bucketName")
 *                         .bucketPrefix("bucketPrefix")
 *                         .logDeliveryStatus("logDeliveryStatus")
 *                         .build())
 *                 .build())
 *         .maxCityNetworksToMonitor(123)
 *         .resources(List.of("resources"))
 *         .resourcesToAdd(List.of("resourcesToAdd"))
 *         .resourcesToRemove(List.of("resourcesToRemove"))
 *         .status("status")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trafficPercentageToMonitor(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:56.438Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_internetmonitor.CfnMonitor")
public class CfnMonitor extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnMonitor(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMonitor(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.internetmonitor.CfnMonitor.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMonitor(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.internetmonitor.CfnMonitorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time when the monitor was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The last time that the monitor was modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrModifiedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrModifiedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMonitorArn() {
        return software.amazon.jsii.Kernel.get(this, "attrMonitorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The health of data processing for the monitor.
     * <p>
     * For more information, see <code>ProcessingStatus</code> under <a href="https://docs.aws.amazon.com/internet-monitor/latest/api/API_MonitorListMember.html">MonitorListMember</a> in the <em>Amazon CloudWatch Internet Monitor API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProcessingStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrProcessingStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Additional information about the health of the data processing for the monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProcessingStatusInfo() {
        return software.amazon.jsii.Kernel.get(this, "attrProcessingStatusInfo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMonitorName() {
        return software.amazon.jsii.Kernel.get(this, "monitorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitorName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "monitorName", java.util.Objects.requireNonNull(value, "monitorName is required"));
    }

    /**
     * A complex type with the configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for an overall performance or availability issue, across an application's geographies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHealthEventsConfig() {
        return software.amazon.jsii.Kernel.get(this, "healthEventsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A complex type with the configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for an overall performance or availability issue, across an application's geographies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthEventsConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "healthEventsConfig", value);
    }

    /**
     * A complex type with the configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for an overall performance or availability issue, across an application's geographies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthEventsConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.internetmonitor.CfnMonitor.HealthEventsConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "healthEventsConfig", value);
    }

    /**
     * Publish internet measurements for a monitor for all city-networks (up to the 500,000 service limit) to another location, such as an Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInternetMeasurementsLogDelivery() {
        return software.amazon.jsii.Kernel.get(this, "internetMeasurementsLogDelivery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Publish internet measurements for a monitor for all city-networks (up to the 500,000 service limit) to another location, such as an Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInternetMeasurementsLogDelivery(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "internetMeasurementsLogDelivery", value);
    }

    /**
     * Publish internet measurements for a monitor for all city-networks (up to the 500,000 service limit) to another location, such as an Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInternetMeasurementsLogDelivery(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.internetmonitor.CfnMonitor.InternetMeasurementsLogDeliveryProperty value) {
        software.amazon.jsii.Kernel.set(this, "internetMeasurementsLogDelivery", value);
    }

    /**
     * The maximum number of city-networks to monitor for your resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxCityNetworksToMonitor() {
        return software.amazon.jsii.Kernel.get(this, "maxCityNetworksToMonitor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum number of city-networks to monitor for your resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxCityNetworksToMonitor(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxCityNetworksToMonitor", value);
    }

    /**
     * The resources that have been added for the monitor, listed by their Amazon Resource Names (ARNs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResources() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The resources that have been added for the monitor, listed by their Amazon Resource Names (ARNs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResources(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "resources", value);
    }

    /**
     * The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourcesToAdd() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "resourcesToAdd", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourcesToAdd(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "resourcesToAdd", value);
    }

    /**
     * The resources to remove from a monitor, which you provide as a set of Amazon Resource Names (ARNs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourcesToRemove() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "resourcesToRemove", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The resources to remove from a monitor, which you provide as a set of Amazon Resource Names (ARNs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourcesToRemove(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "resourcesToRemove", value);
    }

    /**
     * The status of a monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of a monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "status", value);
    }

    /**
     * The tags for a monitor, listed as a set of <em>key:value</em> pairs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags for a monitor, listed as a set of <em>key:value</em> pairs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The percentage of the internet-facing traffic for your application that you want to monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTrafficPercentageToMonitor() {
        return software.amazon.jsii.Kernel.get(this, "trafficPercentageToMonitor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The percentage of the internet-facing traffic for your application that you want to monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrafficPercentageToMonitor(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "trafficPercentageToMonitor", value);
    }
    /**
     * Define the health event threshold percentages for the performance score and availability score for your application's monitor.
     * <p>
     * Amazon CloudWatch Internet Monitor creates a health event when there's an internet issue that affects your application end users where a health score percentage is at or below a set threshold.
     * <p>
     * If you don't set a health event threshold, the default value is 95%.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.internetmonitor.*;
     * HealthEventsConfigProperty healthEventsConfigProperty = HealthEventsConfigProperty.builder()
     *         .availabilityLocalHealthEventsConfig(LocalHealthEventsConfigProperty.builder()
     *                 .healthScoreThreshold(123)
     *                 .minTrafficImpact(123)
     *                 .status("status")
     *                 .build())
     *         .availabilityScoreThreshold(123)
     *         .performanceLocalHealthEventsConfig(LocalHealthEventsConfigProperty.builder()
     *                 .healthScoreThreshold(123)
     *                 .minTrafficImpact(123)
     *                 .status("status")
     *                 .build())
     *         .performanceScoreThreshold(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-healtheventsconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-healtheventsconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_internetmonitor.CfnMonitor.HealthEventsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HealthEventsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HealthEventsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local availability issue.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-healtheventsconfig.html#cfn-internetmonitor-monitor-healtheventsconfig-availabilitylocalhealtheventsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-healtheventsconfig.html#cfn-internetmonitor-monitor-healtheventsconfig-availabilitylocalhealtheventsconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAvailabilityLocalHealthEventsConfig() {
            return null;
        }

        /**
         * The health event threshold percentage set for availability scores.
         * <p>
         * When the overall availability score is at or below this percentage, Internet Monitor creates a health event.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-healtheventsconfig.html#cfn-internetmonitor-monitor-healtheventsconfig-availabilityscorethreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-healtheventsconfig.html#cfn-internetmonitor-monitor-healtheventsconfig-availabilityscorethreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAvailabilityScoreThreshold() {
            return null;
        }

        /**
         * The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local performance issue.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-healtheventsconfig.html#cfn-internetmonitor-monitor-healtheventsconfig-performancelocalhealtheventsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-healtheventsconfig.html#cfn-internetmonitor-monitor-healtheventsconfig-performancelocalhealtheventsconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPerformanceLocalHealthEventsConfig() {
            return null;
        }

        /**
         * The health event threshold percentage set for performance scores.
         * <p>
         * When the overall performance score is at or below this percentage, Internet Monitor creates a health event.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-healtheventsconfig.html#cfn-internetmonitor-monitor-healtheventsconfig-performancescorethreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-healtheventsconfig.html#cfn-internetmonitor-monitor-healtheventsconfig-performancescorethreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPerformanceScoreThreshold() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HealthEventsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HealthEventsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HealthEventsConfigProperty> {
            java.lang.Object availabilityLocalHealthEventsConfig;
            java.lang.Number availabilityScoreThreshold;
            java.lang.Object performanceLocalHealthEventsConfig;
            java.lang.Number performanceScoreThreshold;

            /**
             * Sets the value of {@link HealthEventsConfigProperty#getAvailabilityLocalHealthEventsConfig}
             * @param availabilityLocalHealthEventsConfig The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local availability issue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityLocalHealthEventsConfig(software.amazon.awscdk.IResolvable availabilityLocalHealthEventsConfig) {
                this.availabilityLocalHealthEventsConfig = availabilityLocalHealthEventsConfig;
                return this;
            }

            /**
             * Sets the value of {@link HealthEventsConfigProperty#getAvailabilityLocalHealthEventsConfig}
             * @param availabilityLocalHealthEventsConfig The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local availability issue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityLocalHealthEventsConfig(software.amazon.awscdk.services.internetmonitor.CfnMonitor.LocalHealthEventsConfigProperty availabilityLocalHealthEventsConfig) {
                this.availabilityLocalHealthEventsConfig = availabilityLocalHealthEventsConfig;
                return this;
            }

            /**
             * Sets the value of {@link HealthEventsConfigProperty#getAvailabilityScoreThreshold}
             * @param availabilityScoreThreshold The health event threshold percentage set for availability scores.
             *                                   When the overall availability score is at or below this percentage, Internet Monitor creates a health event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityScoreThreshold(java.lang.Number availabilityScoreThreshold) {
                this.availabilityScoreThreshold = availabilityScoreThreshold;
                return this;
            }

            /**
             * Sets the value of {@link HealthEventsConfigProperty#getPerformanceLocalHealthEventsConfig}
             * @param performanceLocalHealthEventsConfig The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local performance issue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder performanceLocalHealthEventsConfig(software.amazon.awscdk.IResolvable performanceLocalHealthEventsConfig) {
                this.performanceLocalHealthEventsConfig = performanceLocalHealthEventsConfig;
                return this;
            }

            /**
             * Sets the value of {@link HealthEventsConfigProperty#getPerformanceLocalHealthEventsConfig}
             * @param performanceLocalHealthEventsConfig The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local performance issue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder performanceLocalHealthEventsConfig(software.amazon.awscdk.services.internetmonitor.CfnMonitor.LocalHealthEventsConfigProperty performanceLocalHealthEventsConfig) {
                this.performanceLocalHealthEventsConfig = performanceLocalHealthEventsConfig;
                return this;
            }

            /**
             * Sets the value of {@link HealthEventsConfigProperty#getPerformanceScoreThreshold}
             * @param performanceScoreThreshold The health event threshold percentage set for performance scores.
             *                                  When the overall performance score is at or below this percentage, Internet Monitor creates a health event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder performanceScoreThreshold(java.lang.Number performanceScoreThreshold) {
                this.performanceScoreThreshold = performanceScoreThreshold;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HealthEventsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HealthEventsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HealthEventsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthEventsConfigProperty {
            private final java.lang.Object availabilityLocalHealthEventsConfig;
            private final java.lang.Number availabilityScoreThreshold;
            private final java.lang.Object performanceLocalHealthEventsConfig;
            private final java.lang.Number performanceScoreThreshold;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityLocalHealthEventsConfig = software.amazon.jsii.Kernel.get(this, "availabilityLocalHealthEventsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.availabilityScoreThreshold = software.amazon.jsii.Kernel.get(this, "availabilityScoreThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.performanceLocalHealthEventsConfig = software.amazon.jsii.Kernel.get(this, "performanceLocalHealthEventsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.performanceScoreThreshold = software.amazon.jsii.Kernel.get(this, "performanceScoreThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityLocalHealthEventsConfig = builder.availabilityLocalHealthEventsConfig;
                this.availabilityScoreThreshold = builder.availabilityScoreThreshold;
                this.performanceLocalHealthEventsConfig = builder.performanceLocalHealthEventsConfig;
                this.performanceScoreThreshold = builder.performanceScoreThreshold;
            }

            @Override
            public final java.lang.Object getAvailabilityLocalHealthEventsConfig() {
                return this.availabilityLocalHealthEventsConfig;
            }

            @Override
            public final java.lang.Number getAvailabilityScoreThreshold() {
                return this.availabilityScoreThreshold;
            }

            @Override
            public final java.lang.Object getPerformanceLocalHealthEventsConfig() {
                return this.performanceLocalHealthEventsConfig;
            }

            @Override
            public final java.lang.Number getPerformanceScoreThreshold() {
                return this.performanceScoreThreshold;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityLocalHealthEventsConfig() != null) {
                    data.set("availabilityLocalHealthEventsConfig", om.valueToTree(this.getAvailabilityLocalHealthEventsConfig()));
                }
                if (this.getAvailabilityScoreThreshold() != null) {
                    data.set("availabilityScoreThreshold", om.valueToTree(this.getAvailabilityScoreThreshold()));
                }
                if (this.getPerformanceLocalHealthEventsConfig() != null) {
                    data.set("performanceLocalHealthEventsConfig", om.valueToTree(this.getPerformanceLocalHealthEventsConfig()));
                }
                if (this.getPerformanceScoreThreshold() != null) {
                    data.set("performanceScoreThreshold", om.valueToTree(this.getPerformanceScoreThreshold()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_internetmonitor.CfnMonitor.HealthEventsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HealthEventsConfigProperty.Jsii$Proxy that = (HealthEventsConfigProperty.Jsii$Proxy) o;

                if (this.availabilityLocalHealthEventsConfig != null ? !this.availabilityLocalHealthEventsConfig.equals(that.availabilityLocalHealthEventsConfig) : that.availabilityLocalHealthEventsConfig != null) return false;
                if (this.availabilityScoreThreshold != null ? !this.availabilityScoreThreshold.equals(that.availabilityScoreThreshold) : that.availabilityScoreThreshold != null) return false;
                if (this.performanceLocalHealthEventsConfig != null ? !this.performanceLocalHealthEventsConfig.equals(that.performanceLocalHealthEventsConfig) : that.performanceLocalHealthEventsConfig != null) return false;
                return this.performanceScoreThreshold != null ? this.performanceScoreThreshold.equals(that.performanceScoreThreshold) : that.performanceScoreThreshold == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityLocalHealthEventsConfig != null ? this.availabilityLocalHealthEventsConfig.hashCode() : 0;
                result = 31 * result + (this.availabilityScoreThreshold != null ? this.availabilityScoreThreshold.hashCode() : 0);
                result = 31 * result + (this.performanceLocalHealthEventsConfig != null ? this.performanceLocalHealthEventsConfig.hashCode() : 0);
                result = 31 * result + (this.performanceScoreThreshold != null ? this.performanceScoreThreshold.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Publish internet measurements to an Amazon S3 bucket in addition to CloudWatch Logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.internetmonitor.*;
     * InternetMeasurementsLogDeliveryProperty internetMeasurementsLogDeliveryProperty = InternetMeasurementsLogDeliveryProperty.builder()
     *         .s3Config(S3ConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .logDeliveryStatus("logDeliveryStatus")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-internetmeasurementslogdelivery.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-internetmeasurementslogdelivery.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_internetmonitor.CfnMonitor.InternetMeasurementsLogDeliveryProperty")
    @software.amazon.jsii.Jsii.Proxy(InternetMeasurementsLogDeliveryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InternetMeasurementsLogDeliveryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration for publishing Amazon CloudWatch Internet Monitor internet measurements to Amazon S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-internetmeasurementslogdelivery.html#cfn-internetmonitor-monitor-internetmeasurementslogdelivery-s3config">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-internetmeasurementslogdelivery.html#cfn-internetmonitor-monitor-internetmeasurementslogdelivery-s3config</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Config() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InternetMeasurementsLogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InternetMeasurementsLogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InternetMeasurementsLogDeliveryProperty> {
            java.lang.Object s3Config;

            /**
             * Sets the value of {@link InternetMeasurementsLogDeliveryProperty#getS3Config}
             * @param s3Config The configuration for publishing Amazon CloudWatch Internet Monitor internet measurements to Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Config(software.amazon.awscdk.IResolvable s3Config) {
                this.s3Config = s3Config;
                return this;
            }

            /**
             * Sets the value of {@link InternetMeasurementsLogDeliveryProperty#getS3Config}
             * @param s3Config The configuration for publishing Amazon CloudWatch Internet Monitor internet measurements to Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Config(software.amazon.awscdk.services.internetmonitor.CfnMonitor.S3ConfigProperty s3Config) {
                this.s3Config = s3Config;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InternetMeasurementsLogDeliveryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InternetMeasurementsLogDeliveryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InternetMeasurementsLogDeliveryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InternetMeasurementsLogDeliveryProperty {
            private final java.lang.Object s3Config;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Config = software.amazon.jsii.Kernel.get(this, "s3Config", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Config = builder.s3Config;
            }

            @Override
            public final java.lang.Object getS3Config() {
                return this.s3Config;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Config() != null) {
                    data.set("s3Config", om.valueToTree(this.getS3Config()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_internetmonitor.CfnMonitor.InternetMeasurementsLogDeliveryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InternetMeasurementsLogDeliveryProperty.Jsii$Proxy that = (InternetMeasurementsLogDeliveryProperty.Jsii$Proxy) o;

                return this.s3Config != null ? this.s3Config.equals(that.s3Config) : that.s3Config == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Config != null ? this.s3Config.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for a local performance or availability issue, when scores cross a threshold for one or more city-networks.
     * <p>
     * Defines the percentages, for performance scores or availability scores, that are the local thresholds for when Amazon CloudWatch Internet Monitor creates a health event. Also defines whether a local threshold is enabled or disabled, and the minimum percentage of overall traffic that must be impacted by an issue before Internet Monitor creates an event when a	threshold is crossed for a local health score.
     * <p>
     * If you don't set a local health event threshold, the default value is 60%.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview">Change health event thresholds</a> in the Internet Monitor section of the <em>Amazon CloudWatch User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.internetmonitor.*;
     * LocalHealthEventsConfigProperty localHealthEventsConfigProperty = LocalHealthEventsConfigProperty.builder()
     *         .healthScoreThreshold(123)
     *         .minTrafficImpact(123)
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-localhealtheventsconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-localhealtheventsconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_internetmonitor.CfnMonitor.LocalHealthEventsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LocalHealthEventsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocalHealthEventsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The health event threshold percentage set for a local health score.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-localhealtheventsconfig.html#cfn-internetmonitor-monitor-localhealtheventsconfig-healthscorethreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-localhealtheventsconfig.html#cfn-internetmonitor-monitor-localhealtheventsconfig-healthscorethreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHealthScoreThreshold() {
            return null;
        }

        /**
         * The minimum percentage of overall traffic for an application that must be impacted by an issue before Internet Monitor creates an event when a threshold is crossed for a local health score.
         * <p>
         * If you don't set a minimum traffic impact threshold, the default value is 0.01%.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-localhealtheventsconfig.html#cfn-internetmonitor-monitor-localhealtheventsconfig-mintrafficimpact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-localhealtheventsconfig.html#cfn-internetmonitor-monitor-localhealtheventsconfig-mintrafficimpact</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinTrafficImpact() {
            return null;
        }

        /**
         * The status of whether Internet Monitor creates a health event based on a threshold percentage set for a local health score.
         * <p>
         * The status can be <code>ENABLED</code> or <code>DISABLED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-localhealtheventsconfig.html#cfn-internetmonitor-monitor-localhealtheventsconfig-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-localhealtheventsconfig.html#cfn-internetmonitor-monitor-localhealtheventsconfig-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LocalHealthEventsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocalHealthEventsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocalHealthEventsConfigProperty> {
            java.lang.Number healthScoreThreshold;
            java.lang.Number minTrafficImpact;
            java.lang.String status;

            /**
             * Sets the value of {@link LocalHealthEventsConfigProperty#getHealthScoreThreshold}
             * @param healthScoreThreshold The health event threshold percentage set for a local health score.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthScoreThreshold(java.lang.Number healthScoreThreshold) {
                this.healthScoreThreshold = healthScoreThreshold;
                return this;
            }

            /**
             * Sets the value of {@link LocalHealthEventsConfigProperty#getMinTrafficImpact}
             * @param minTrafficImpact The minimum percentage of overall traffic for an application that must be impacted by an issue before Internet Monitor creates an event when a threshold is crossed for a local health score.
             *                         If you don't set a minimum traffic impact threshold, the default value is 0.01%.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTrafficImpact(java.lang.Number minTrafficImpact) {
                this.minTrafficImpact = minTrafficImpact;
                return this;
            }

            /**
             * Sets the value of {@link LocalHealthEventsConfigProperty#getStatus}
             * @param status The status of whether Internet Monitor creates a health event based on a threshold percentage set for a local health score.
             *               The status can be <code>ENABLED</code> or <code>DISABLED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocalHealthEventsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocalHealthEventsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocalHealthEventsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocalHealthEventsConfigProperty {
            private final java.lang.Number healthScoreThreshold;
            private final java.lang.Number minTrafficImpact;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.healthScoreThreshold = software.amazon.jsii.Kernel.get(this, "healthScoreThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minTrafficImpact = software.amazon.jsii.Kernel.get(this, "minTrafficImpact", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.healthScoreThreshold = builder.healthScoreThreshold;
                this.minTrafficImpact = builder.minTrafficImpact;
                this.status = builder.status;
            }

            @Override
            public final java.lang.Number getHealthScoreThreshold() {
                return this.healthScoreThreshold;
            }

            @Override
            public final java.lang.Number getMinTrafficImpact() {
                return this.minTrafficImpact;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHealthScoreThreshold() != null) {
                    data.set("healthScoreThreshold", om.valueToTree(this.getHealthScoreThreshold()));
                }
                if (this.getMinTrafficImpact() != null) {
                    data.set("minTrafficImpact", om.valueToTree(this.getMinTrafficImpact()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_internetmonitor.CfnMonitor.LocalHealthEventsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocalHealthEventsConfigProperty.Jsii$Proxy that = (LocalHealthEventsConfigProperty.Jsii$Proxy) o;

                if (this.healthScoreThreshold != null ? !this.healthScoreThreshold.equals(that.healthScoreThreshold) : that.healthScoreThreshold != null) return false;
                if (this.minTrafficImpact != null ? !this.minTrafficImpact.equals(that.minTrafficImpact) : that.minTrafficImpact != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.healthScoreThreshold != null ? this.healthScoreThreshold.hashCode() : 0;
                result = 31 * result + (this.minTrafficImpact != null ? this.minTrafficImpact.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for publishing Amazon CloudWatch Internet Monitor internet measurements to Amazon S3.
     * <p>
     * The configuration includes the bucket name and (optionally) bucket prefix for the S3 bucket to store the measurements, and the delivery status. The delivery status is <code>ENABLED</code> if you choose to deliver internet measurements to S3 logs, and <code>DISABLED</code> otherwise.
     * <p>
     * The measurements are also published to Amazon CloudWatch Logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.internetmonitor.*;
     * S3ConfigProperty s3ConfigProperty = S3ConfigProperty.builder()
     *         .bucketName("bucketName")
     *         .bucketPrefix("bucketPrefix")
     *         .logDeliveryStatus("logDeliveryStatus")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-s3config.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-s3config.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_internetmonitor.CfnMonitor.S3ConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket name for internet measurements publishing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-s3config.html#cfn-internetmonitor-monitor-s3config-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-s3config.html#cfn-internetmonitor-monitor-s3config-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
            return null;
        }

        /**
         * An optional Amazon S3 bucket prefix for internet measurements publishing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-s3config.html#cfn-internetmonitor-monitor-s3config-bucketprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-s3config.html#cfn-internetmonitor-monitor-s3config-bucketprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
         * <p>
         * The delivery status is <code>ENABLED</code> if you choose to deliver internet measurements to an S3 bucket, and <code>DISABLED</code> otherwise.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-s3config.html#cfn-internetmonitor-monitor-s3config-logdeliverystatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-internetmonitor-monitor-s3config.html#cfn-internetmonitor-monitor-s3config-logdeliverystatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogDeliveryStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ConfigProperty> {
            java.lang.String bucketName;
            java.lang.String bucketPrefix;
            java.lang.String logDeliveryStatus;

            /**
             * Sets the value of {@link S3ConfigProperty#getBucketName}
             * @param bucketName The Amazon S3 bucket name for internet measurements publishing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigProperty#getBucketPrefix}
             * @param bucketPrefix An optional Amazon S3 bucket prefix for internet measurements publishing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigProperty#getLogDeliveryStatus}
             * @param logDeliveryStatus The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.
             *                          The delivery status is <code>ENABLED</code> if you choose to deliver internet measurements to an S3 bucket, and <code>DISABLED</code> otherwise.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logDeliveryStatus(java.lang.String logDeliveryStatus) {
                this.logDeliveryStatus = logDeliveryStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ConfigProperty {
            private final java.lang.String bucketName;
            private final java.lang.String bucketPrefix;
            private final java.lang.String logDeliveryStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logDeliveryStatus = software.amazon.jsii.Kernel.get(this, "logDeliveryStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = builder.bucketName;
                this.bucketPrefix = builder.bucketPrefix;
                this.logDeliveryStatus = builder.logDeliveryStatus;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.String getLogDeliveryStatus() {
                return this.logDeliveryStatus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucketName() != null) {
                    data.set("bucketName", om.valueToTree(this.getBucketName()));
                }
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }
                if (this.getLogDeliveryStatus() != null) {
                    data.set("logDeliveryStatus", om.valueToTree(this.getLogDeliveryStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_internetmonitor.CfnMonitor.S3ConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ConfigProperty.Jsii$Proxy that = (S3ConfigProperty.Jsii$Proxy) o;

                if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
                if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
                return this.logDeliveryStatus != null ? this.logDeliveryStatus.equals(that.logDeliveryStatus) : that.logDeliveryStatus == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName != null ? this.bucketName.hashCode() : 0;
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                result = 31 * result + (this.logDeliveryStatus != null ? this.logDeliveryStatus.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.internetmonitor.CfnMonitor}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.internetmonitor.CfnMonitor> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.internetmonitor.CfnMonitorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.internetmonitor.CfnMonitorProps.Builder();
        }

        /**
         * The name of the monitor.
         * <p>
         * A monitor name can contain only alphanumeric characters, dashes (-), periods (.), and underscores (_).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-monitorname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-monitorname</a>
         * @param monitorName The name of the monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitorName(final java.lang.String monitorName) {
            this.props.monitorName(monitorName);
            return this;
        }

        /**
         * A complex type with the configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for an overall performance or availability issue, across an application's geographies.
         * <p>
         * Defines the percentages, for overall performance scores and availability scores for an application, that are the thresholds for when Amazon CloudWatch Internet Monitor creates a health event. You can override the defaults to set a custom threshold for overall performance or availability scores, or both.
         * <p>
         * You can also set thresholds for local health scores,, where Internet Monitor creates a health event when scores cross a threshold for one or more city-networks, in addition to creating an event when an overall score crosses a threshold.
         * <p>
         * If you don't set a health event threshold, the default value is 95%.
         * <p>
         * For local thresholds, you also set a minimum percentage of overall traffic that is impacted by an issue before Internet Monitor creates an event. In addition, you can disable local thresholds, for performance scores, availability scores, or both.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview">Change health event thresholds</a> in the Internet Monitor section of the <em>CloudWatch User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-healtheventsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-healtheventsconfig</a>
         * @param healthEventsConfig A complex type with the configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for an overall performance or availability issue, across an application's geographies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthEventsConfig(final software.amazon.awscdk.IResolvable healthEventsConfig) {
            this.props.healthEventsConfig(healthEventsConfig);
            return this;
        }
        /**
         * A complex type with the configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for an overall performance or availability issue, across an application's geographies.
         * <p>
         * Defines the percentages, for overall performance scores and availability scores for an application, that are the thresholds for when Amazon CloudWatch Internet Monitor creates a health event. You can override the defaults to set a custom threshold for overall performance or availability scores, or both.
         * <p>
         * You can also set thresholds for local health scores,, where Internet Monitor creates a health event when scores cross a threshold for one or more city-networks, in addition to creating an event when an overall score crosses a threshold.
         * <p>
         * If you don't set a health event threshold, the default value is 95%.
         * <p>
         * For local thresholds, you also set a minimum percentage of overall traffic that is impacted by an issue before Internet Monitor creates an event. In addition, you can disable local thresholds, for performance scores, availability scores, or both.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview">Change health event thresholds</a> in the Internet Monitor section of the <em>CloudWatch User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-healtheventsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-healtheventsconfig</a>
         * @param healthEventsConfig A complex type with the configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for an overall performance or availability issue, across an application's geographies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthEventsConfig(final software.amazon.awscdk.services.internetmonitor.CfnMonitor.HealthEventsConfigProperty healthEventsConfig) {
            this.props.healthEventsConfig(healthEventsConfig);
            return this;
        }

        /**
         * Publish internet measurements for a monitor for all city-networks (up to the 500,000 service limit) to another location, such as an Amazon S3 bucket.
         * <p>
         * Measurements are also published to Amazon CloudWatch Logs for the first 500 (by traffic volume) city-networks (client locations and ASNs, typically internet service providers or ISPs).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-internetmeasurementslogdelivery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-internetmeasurementslogdelivery</a>
         * @param internetMeasurementsLogDelivery Publish internet measurements for a monitor for all city-networks (up to the 500,000 service limit) to another location, such as an Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetMeasurementsLogDelivery(final software.amazon.awscdk.IResolvable internetMeasurementsLogDelivery) {
            this.props.internetMeasurementsLogDelivery(internetMeasurementsLogDelivery);
            return this;
        }
        /**
         * Publish internet measurements for a monitor for all city-networks (up to the 500,000 service limit) to another location, such as an Amazon S3 bucket.
         * <p>
         * Measurements are also published to Amazon CloudWatch Logs for the first 500 (by traffic volume) city-networks (client locations and ASNs, typically internet service providers or ISPs).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-internetmeasurementslogdelivery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-internetmeasurementslogdelivery</a>
         * @param internetMeasurementsLogDelivery Publish internet measurements for a monitor for all city-networks (up to the 500,000 service limit) to another location, such as an Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetMeasurementsLogDelivery(final software.amazon.awscdk.services.internetmonitor.CfnMonitor.InternetMeasurementsLogDeliveryProperty internetMeasurementsLogDelivery) {
            this.props.internetMeasurementsLogDelivery(internetMeasurementsLogDelivery);
            return this;
        }

        /**
         * The maximum number of city-networks to monitor for your resources.
         * <p>
         * A city-network is the location (city) where clients access your application resources from and the network, such as an internet service provider, that clients access the resources through.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html">Choosing a city-network maximum value</a> in <em>Using Amazon CloudWatch Internet Monitor</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-maxcitynetworkstomonitor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-maxcitynetworkstomonitor</a>
         * @param maxCityNetworksToMonitor The maximum number of city-networks to monitor for your resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCityNetworksToMonitor(final java.lang.Number maxCityNetworksToMonitor) {
            this.props.maxCityNetworksToMonitor(maxCityNetworksToMonitor);
            return this;
        }

        /**
         * The resources that have been added for the monitor, listed by their Amazon Resource Names (ARNs).
         * <p>
         * Use this option to add or remove resources when making an update.
         * <p>
         * <blockquote>
         * <p>
         * Be aware that if you include content in the <code>Resources</code> field when you update a monitor, the <code>ResourcesToAdd</code> and <code>ResourcesToRemove</code> fields must be empty.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-resources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-resources</a>
         * @param resources The resources that have been added for the monitor, listed by their Amazon Resource Names (ARNs). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(final java.util.List<java.lang.String> resources) {
            this.props.resources(resources);
            return this;
        }

        /**
         * The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs).
         * <p>
         * Resources can be Amazon Virtual Private Cloud VPCs, Network Load Balancers (NLBs), Amazon CloudFront distributions, or Amazon WorkSpaces directories.
         * <p>
         * You can add a combination of VPCs and CloudFront distributions, or you can add WorkSpaces directories, or you can add NLBs. You can't add NLBs or WorkSpaces directories together with any other resources.
         * <p>
         * If you add only VPC resources, at least one VPC must have an Internet Gateway attached to it, to make sure that it has internet connectivity.
         * <p>
         * <blockquote>
         * <p>
         * You can specify this field for a monitor update only if the <code>Resources</code> field is empty.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-resourcestoadd">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-resourcestoadd</a>
         * @param resourcesToAdd The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesToAdd(final java.util.List<java.lang.String> resourcesToAdd) {
            this.props.resourcesToAdd(resourcesToAdd);
            return this;
        }

        /**
         * The resources to remove from a monitor, which you provide as a set of Amazon Resource Names (ARNs).
         * <p>
         * <blockquote>
         * <p>
         * You can specify this field for a monitor update only if the <code>Resources</code> field is empty.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-resourcestoremove">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-resourcestoremove</a>
         * @param resourcesToRemove The resources to remove from a monitor, which you provide as a set of Amazon Resource Names (ARNs). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesToRemove(final java.util.List<java.lang.String> resourcesToRemove) {
            this.props.resourcesToRemove(resourcesToRemove);
            return this;
        }

        /**
         * The status of a monitor.
         * <p>
         * The accepted values that you can specify for <code>Status</code> are <code>ACTIVE</code> and <code>INACTIVE</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-status</a>
         * @param status The status of a monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(final java.lang.String status) {
            this.props.status(status);
            return this;
        }

        /**
         * The tags for a monitor, listed as a set of <em>key:value</em> pairs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-tags</a>
         * @param tags The tags for a monitor, listed as a set of <em>key:value</em> pairs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The percentage of the internet-facing traffic for your application that you want to monitor.
         * <p>
         * You can also, optionally, set a limit for the number of city-networks (client locations and ASNs, typically internet service providers) that Internet Monitor will monitor traffic for. The city-networks maximum limit caps the number of city-networks that Internet Monitor monitors for your application, regardless of the percentage of traffic that you choose to monitor.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-trafficpercentagetomonitor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-internetmonitor-monitor.html#cfn-internetmonitor-monitor-trafficpercentagetomonitor</a>
         * @param trafficPercentageToMonitor The percentage of the internet-facing traffic for your application that you want to monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficPercentageToMonitor(final java.lang.Number trafficPercentageToMonitor) {
            this.props.trafficPercentageToMonitor(trafficPercentageToMonitor);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.internetmonitor.CfnMonitor}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.internetmonitor.CfnMonitor build() {
            return new software.amazon.awscdk.services.internetmonitor.CfnMonitor(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
