package software.amazon.awscdk.services.lakeformation;

/**
 * Properties for defining a <code>CfnPrincipalPermissions</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lakeformation.*;
 * Object catalog;
 * Object tableWildcard;
 * CfnPrincipalPermissionsProps cfnPrincipalPermissionsProps = CfnPrincipalPermissionsProps.builder()
 *         .permissions(List.of("permissions"))
 *         .permissionsWithGrantOption(List.of("permissionsWithGrantOption"))
 *         .principal(DataLakePrincipalProperty.builder()
 *                 .dataLakePrincipalIdentifier("dataLakePrincipalIdentifier")
 *                 .build())
 *         .resource(ResourceProperty.builder()
 *                 .catalog(catalog)
 *                 .database(DatabaseResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .name("name")
 *                         .build())
 *                 .dataCellsFilter(DataCellsFilterResourceProperty.builder()
 *                         .databaseName("databaseName")
 *                         .name("name")
 *                         .tableCatalogId("tableCatalogId")
 *                         .tableName("tableName")
 *                         .build())
 *                 .dataLocation(DataLocationResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .resourceArn("resourceArn")
 *                         .build())
 *                 .lfTag(LFTagKeyResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .tagKey("tagKey")
 *                         .tagValues(List.of("tagValues"))
 *                         .build())
 *                 .lfTagPolicy(LFTagPolicyResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .expression(List.of(LFTagProperty.builder()
 *                                 .tagKey("tagKey")
 *                                 .tagValues(List.of("tagValues"))
 *                                 .build()))
 *                         .resourceType("resourceType")
 *                         .build())
 *                 .table(TableResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .databaseName("databaseName")
 *                         // the properties below are optional
 *                         .name("name")
 *                         .tableWildcard(tableWildcard)
 *                         .build())
 *                 .tableWithColumns(TableWithColumnsResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .databaseName("databaseName")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .columnNames(List.of("columnNames"))
 *                         .columnWildcard(ColumnWildcardProperty.builder()
 *                                 .excludedColumnNames(List.of("excludedColumnNames"))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .catalog("catalog")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-principalpermissions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-principalpermissions.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:57.226Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissionsProps")
@software.amazon.jsii.Jsii.Proxy(CfnPrincipalPermissionsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPrincipalPermissionsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The permissions granted or revoked.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-principalpermissions.html#cfn-lakeformation-principalpermissions-permissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-principalpermissions.html#cfn-lakeformation-principalpermissions-permissions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getPermissions();

    /**
     * Indicates the ability to grant permissions (as a subset of permissions granted).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-principalpermissions.html#cfn-lakeformation-principalpermissions-permissionswithgrantoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-principalpermissions.html#cfn-lakeformation-principalpermissions-permissionswithgrantoption</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getPermissionsWithGrantOption();

    /**
     * The principal to be granted a permission.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-principalpermissions.html#cfn-lakeformation-principalpermissions-principal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-principalpermissions.html#cfn-lakeformation-principalpermissions-principal</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPrincipal();

    /**
     * The resource to be granted or revoked permissions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-principalpermissions.html#cfn-lakeformation-principalpermissions-resource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-principalpermissions.html#cfn-lakeformation-principalpermissions-resource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResource();

    /**
     * The identifier for the Data Catalog .
     * <p>
     * By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-principalpermissions.html#cfn-lakeformation-principalpermissions-catalog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-principalpermissions.html#cfn-lakeformation-principalpermissions-catalog</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCatalog() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPrincipalPermissionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPrincipalPermissionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPrincipalPermissionsProps> {
        java.util.List<java.lang.String> permissions;
        java.util.List<java.lang.String> permissionsWithGrantOption;
        java.lang.Object principal;
        java.lang.Object resource;
        java.lang.String catalog;

        /**
         * Sets the value of {@link CfnPrincipalPermissionsProps#getPermissions}
         * @param permissions The permissions granted or revoked. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(java.util.List<java.lang.String> permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrincipalPermissionsProps#getPermissionsWithGrantOption}
         * @param permissionsWithGrantOption Indicates the ability to grant permissions (as a subset of permissions granted). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsWithGrantOption(java.util.List<java.lang.String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = permissionsWithGrantOption;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrincipalPermissionsProps#getPrincipal}
         * @param principal The principal to be granted a permission. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(software.amazon.awscdk.IResolvable principal) {
            this.principal = principal;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrincipalPermissionsProps#getPrincipal}
         * @param principal The principal to be granted a permission. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.DataLakePrincipalProperty principal) {
            this.principal = principal;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrincipalPermissionsProps#getResource}
         * @param resource The resource to be granted or revoked permissions. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(software.amazon.awscdk.IResolvable resource) {
            this.resource = resource;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrincipalPermissionsProps#getResource}
         * @param resource The resource to be granted or revoked permissions. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.ResourceProperty resource) {
            this.resource = resource;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrincipalPermissionsProps#getCatalog}
         * @param catalog The identifier for the Data Catalog .
         *                By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catalog(java.lang.String catalog) {
            this.catalog = catalog;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPrincipalPermissionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPrincipalPermissionsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPrincipalPermissionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPrincipalPermissionsProps {
        private final java.util.List<java.lang.String> permissions;
        private final java.util.List<java.lang.String> permissionsWithGrantOption;
        private final java.lang.Object principal;
        private final java.lang.Object resource;
        private final java.lang.String catalog;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.permissionsWithGrantOption = software.amazon.jsii.Kernel.get(this, "permissionsWithGrantOption", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.catalog = software.amazon.jsii.Kernel.get(this, "catalog", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.permissions = java.util.Objects.requireNonNull(builder.permissions, "permissions is required");
            this.permissionsWithGrantOption = java.util.Objects.requireNonNull(builder.permissionsWithGrantOption, "permissionsWithGrantOption is required");
            this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            this.resource = java.util.Objects.requireNonNull(builder.resource, "resource is required");
            this.catalog = builder.catalog;
        }

        @Override
        public final java.util.List<java.lang.String> getPermissions() {
            return this.permissions;
        }

        @Override
        public final java.util.List<java.lang.String> getPermissionsWithGrantOption() {
            return this.permissionsWithGrantOption;
        }

        @Override
        public final java.lang.Object getPrincipal() {
            return this.principal;
        }

        @Override
        public final java.lang.Object getResource() {
            return this.resource;
        }

        @Override
        public final java.lang.String getCatalog() {
            return this.catalog;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("permissions", om.valueToTree(this.getPermissions()));
            data.set("permissionsWithGrantOption", om.valueToTree(this.getPermissionsWithGrantOption()));
            data.set("principal", om.valueToTree(this.getPrincipal()));
            data.set("resource", om.valueToTree(this.getResource()));
            if (this.getCatalog() != null) {
                data.set("catalog", om.valueToTree(this.getCatalog()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissionsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPrincipalPermissionsProps.Jsii$Proxy that = (CfnPrincipalPermissionsProps.Jsii$Proxy) o;

            if (!permissions.equals(that.permissions)) return false;
            if (!permissionsWithGrantOption.equals(that.permissionsWithGrantOption)) return false;
            if (!principal.equals(that.principal)) return false;
            if (!resource.equals(that.resource)) return false;
            return this.catalog != null ? this.catalog.equals(that.catalog) : that.catalog == null;
        }

        @Override
        public final int hashCode() {
            int result = this.permissions.hashCode();
            result = 31 * result + (this.permissionsWithGrantOption.hashCode());
            result = 31 * result + (this.principal.hashCode());
            result = 31 * result + (this.resource.hashCode());
            result = 31 * result + (this.catalog != null ? this.catalog.hashCode() : 0);
            return result;
        }
    }
}
