package software.amazon.awscdk.services.lakeformation;

/**
 * Properties for defining a <code>CfnResource</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lakeformation.*;
 * CfnResourceProps cfnResourceProps = CfnResourceProps.builder()
 *         .resourceArn("resourceArn")
 *         .useServiceLinkedRole(false)
 *         // the properties below are optional
 *         .hybridAccessEnabled(false)
 *         .roleArn("roleArn")
 *         .withFederation(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:57.227Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnResourceProps")
@software.amazon.jsii.Jsii.Proxy(CfnResourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-resourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-resourcearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

    /**
     * Designates a trusted caller, an IAM principal, by registering this caller with the Data Catalog .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-useservicelinkedrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-useservicelinkedrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getUseServiceLinkedRole();

    /**
     * Indicates whether the data access of tables pointing to the location can be managed by both Lake Formation permissions as well as Amazon S3 bucket policies.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-hybridaccessenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-hybridaccessenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHybridAccessEnabled() {
        return null;
    }

    /**
     * The IAM role that registered a resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * Allows Lake Formation to assume a role to access tables in a federated database.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-withfederation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html#cfn-lakeformation-resource-withfederation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWithFederation() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResourceProps> {
        java.lang.String resourceArn;
        java.lang.Object useServiceLinkedRole;
        java.lang.Object hybridAccessEnabled;
        java.lang.String roleArn;
        java.lang.Object withFederation;

        /**
         * Sets the value of {@link CfnResourceProps#getResourceArn}
         * @param resourceArn The Amazon Resource Name (ARN) of the resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceArn(java.lang.String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceProps#getUseServiceLinkedRole}
         * @param useServiceLinkedRole Designates a trusted caller, an IAM principal, by registering this caller with the Data Catalog . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useServiceLinkedRole(java.lang.Boolean useServiceLinkedRole) {
            this.useServiceLinkedRole = useServiceLinkedRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceProps#getUseServiceLinkedRole}
         * @param useServiceLinkedRole Designates a trusted caller, an IAM principal, by registering this caller with the Data Catalog . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useServiceLinkedRole(software.amazon.awscdk.IResolvable useServiceLinkedRole) {
            this.useServiceLinkedRole = useServiceLinkedRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceProps#getHybridAccessEnabled}
         * @param hybridAccessEnabled Indicates whether the data access of tables pointing to the location can be managed by both Lake Formation permissions as well as Amazon S3 bucket policies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hybridAccessEnabled(java.lang.Boolean hybridAccessEnabled) {
            this.hybridAccessEnabled = hybridAccessEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceProps#getHybridAccessEnabled}
         * @param hybridAccessEnabled Indicates whether the data access of tables pointing to the location can be managed by both Lake Formation permissions as well as Amazon S3 bucket policies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hybridAccessEnabled(software.amazon.awscdk.IResolvable hybridAccessEnabled) {
            this.hybridAccessEnabled = hybridAccessEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceProps#getRoleArn}
         * @param roleArn The IAM role that registered a resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceProps#getWithFederation}
         * @param withFederation Allows Lake Formation to assume a role to access tables in a federated database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withFederation(java.lang.Boolean withFederation) {
            this.withFederation = withFederation;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceProps#getWithFederation}
         * @param withFederation Allows Lake Formation to assume a role to access tables in a federated database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withFederation(software.amazon.awscdk.IResolvable withFederation) {
            this.withFederation = withFederation;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResourceProps {
        private final java.lang.String resourceArn;
        private final java.lang.Object useServiceLinkedRole;
        private final java.lang.Object hybridAccessEnabled;
        private final java.lang.String roleArn;
        private final java.lang.Object withFederation;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.useServiceLinkedRole = software.amazon.jsii.Kernel.get(this, "useServiceLinkedRole", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.hybridAccessEnabled = software.amazon.jsii.Kernel.get(this, "hybridAccessEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.withFederation = software.amazon.jsii.Kernel.get(this, "withFederation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
            this.useServiceLinkedRole = java.util.Objects.requireNonNull(builder.useServiceLinkedRole, "useServiceLinkedRole is required");
            this.hybridAccessEnabled = builder.hybridAccessEnabled;
            this.roleArn = builder.roleArn;
            this.withFederation = builder.withFederation;
        }

        @Override
        public final java.lang.String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final java.lang.Object getUseServiceLinkedRole() {
            return this.useServiceLinkedRole;
        }

        @Override
        public final java.lang.Object getHybridAccessEnabled() {
            return this.hybridAccessEnabled;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getWithFederation() {
            return this.withFederation;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceArn", om.valueToTree(this.getResourceArn()));
            data.set("useServiceLinkedRole", om.valueToTree(this.getUseServiceLinkedRole()));
            if (this.getHybridAccessEnabled() != null) {
                data.set("hybridAccessEnabled", om.valueToTree(this.getHybridAccessEnabled()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getWithFederation() != null) {
                data.set("withFederation", om.valueToTree(this.getWithFederation()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnResourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResourceProps.Jsii$Proxy that = (CfnResourceProps.Jsii$Proxy) o;

            if (!resourceArn.equals(that.resourceArn)) return false;
            if (!useServiceLinkedRole.equals(that.useServiceLinkedRole)) return false;
            if (this.hybridAccessEnabled != null ? !this.hybridAccessEnabled.equals(that.hybridAccessEnabled) : that.hybridAccessEnabled != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            return this.withFederation != null ? this.withFederation.equals(that.withFederation) : that.withFederation == null;
        }

        @Override
        public final int hashCode() {
            int result = this.resourceArn.hashCode();
            result = 31 * result + (this.useServiceLinkedRole.hashCode());
            result = 31 * result + (this.hybridAccessEnabled != null ? this.hybridAccessEnabled.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.withFederation != null ? this.withFederation.hashCode() : 0);
            return result;
        }
    }
}
