package software.amazon.awscdk.services.lightsail;

/**
 * The <code>AWS::Lightsail::Distribution</code> resource specifies a content delivery network (CDN) distribution.
 * <p>
 * You can create distributions only in the <code>us-east-1</code> AWS Region.
 * <p>
 * A distribution is a globally distributed network of caching servers that improve the performance of your website or web application hosted on a Lightsail instance, static content hosted on a Lightsail bucket, or through a Lightsail load balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnDistribution cfnDistribution = CfnDistribution.Builder.create(this, "MyCfnDistribution")
 *         .bundleId("bundleId")
 *         .defaultCacheBehavior(CacheBehaviorProperty.builder()
 *                 .behavior("behavior")
 *                 .build())
 *         .distributionName("distributionName")
 *         .origin(InputOriginProperty.builder()
 *                 .name("name")
 *                 .protocolPolicy("protocolPolicy")
 *                 .regionName("regionName")
 *                 .build())
 *         // the properties below are optional
 *         .cacheBehaviors(List.of(CacheBehaviorPerPathProperty.builder()
 *                 .behavior("behavior")
 *                 .path("path")
 *                 .build()))
 *         .cacheBehaviorSettings(CacheSettingsProperty.builder()
 *                 .allowedHttpMethods("allowedHttpMethods")
 *                 .cachedHttpMethods("cachedHttpMethods")
 *                 .defaultTtl(123)
 *                 .forwardedCookies(CookieObjectProperty.builder()
 *                         .cookiesAllowList(List.of("cookiesAllowList"))
 *                         .option("option")
 *                         .build())
 *                 .forwardedHeaders(HeaderObjectProperty.builder()
 *                         .headersAllowList(List.of("headersAllowList"))
 *                         .option("option")
 *                         .build())
 *                 .forwardedQueryStrings(QueryStringObjectProperty.builder()
 *                         .option(false)
 *                         .queryStringsAllowList(List.of("queryStringsAllowList"))
 *                         .build())
 *                 .maximumTtl(123)
 *                 .minimumTtl(123)
 *                 .build())
 *         .certificateName("certificateName")
 *         .ipAddressType("ipAddressType")
 *         .isEnabled(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:57.625Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnDistribution")
public class CfnDistribution extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDistribution(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDistribution(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lightsail.CfnDistribution.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDistribution(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lightsail.CfnDistributionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Indicates whether you can update the distribution’s current bundle to another bundle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrAbleToUpdateBundle() {
        return software.amazon.jsii.Kernel.get(this, "attrAbleToUpdateBundle", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDistributionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDistributionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The ID of the bundle applied to the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBundleId() {
        return software.amazon.jsii.Kernel.get(this, "bundleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the bundle applied to the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBundleId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "bundleId", java.util.Objects.requireNonNull(value, "bundleId is required"));
    }

    /**
     * An object that describes the default cache behavior of the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDefaultCacheBehavior() {
        return software.amazon.jsii.Kernel.get(this, "defaultCacheBehavior", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that describes the default cache behavior of the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultCacheBehavior(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultCacheBehavior", java.util.Objects.requireNonNull(value, "defaultCacheBehavior is required"));
    }

    /**
     * An object that describes the default cache behavior of the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultCacheBehavior(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lightsail.CfnDistribution.CacheBehaviorProperty value) {
        software.amazon.jsii.Kernel.set(this, "defaultCacheBehavior", java.util.Objects.requireNonNull(value, "defaultCacheBehavior is required"));
    }

    /**
     * The name of the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDistributionName() {
        return software.amazon.jsii.Kernel.get(this, "distributionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistributionName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "distributionName", java.util.Objects.requireNonNull(value, "distributionName is required"));
    }

    /**
     * An object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOrigin() {
        return software.amazon.jsii.Kernel.get(this, "origin", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrigin(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "origin", java.util.Objects.requireNonNull(value, "origin is required"));
    }

    /**
     * An object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrigin(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lightsail.CfnDistribution.InputOriginProperty value) {
        software.amazon.jsii.Kernel.set(this, "origin", java.util.Objects.requireNonNull(value, "origin is required"));
    }

    /**
     * An array of objects that describe the per-path cache behavior of the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCacheBehaviors() {
        return software.amazon.jsii.Kernel.get(this, "cacheBehaviors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of objects that describe the per-path cache behavior of the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheBehaviors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cacheBehaviors", value);
    }

    /**
     * An array of objects that describe the per-path cache behavior of the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheBehaviors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.lightsail.CfnDistribution.CacheBehaviorPerPathProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.lightsail.CfnDistribution.CacheBehaviorPerPathProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "cacheBehaviors", value);
    }

    /**
     * An object that describes the cache behavior settings of the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCacheBehaviorSettings() {
        return software.amazon.jsii.Kernel.get(this, "cacheBehaviorSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that describes the cache behavior settings of the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheBehaviorSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cacheBehaviorSettings", value);
    }

    /**
     * An object that describes the cache behavior settings of the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheBehaviorSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lightsail.CfnDistribution.CacheSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "cacheBehaviorSettings", value);
    }

    /**
     * The name of the SSL/TLS certificate attached to the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCertificateName() {
        return software.amazon.jsii.Kernel.get(this, "certificateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the SSL/TLS certificate attached to the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "certificateName", value);
    }

    /**
     * The IP address type of the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIpAddressType() {
        return software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IP address type of the distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpAddressType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ipAddressType", value);
    }

    /**
     * A Boolean value indicating whether the distribution is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIsEnabled() {
        return software.amazon.jsii.Kernel.get(this, "isEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A Boolean value indicating whether the distribution is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isEnabled", value);
    }

    /**
     * A Boolean value indicating whether the distribution is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "isEnabled", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * <code>CacheBehaviorPerPath</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html">AWS::Lightsail::Distribution</a> resource. It describes the per-path cache behavior of an Amazon Lightsail content delivery network (CDN) distribution.
     * <p>
     * Use a per-path cache behavior to override the default cache behavior of a distribution, or to add an exception to it. For example, if you set the <code>CacheBehavior</code> to <code>cache</code> , you can use a per-path cache behavior to specify a directory, file, or file type that your distribution will cache. If you don’t want your distribution to cache a specified directory, file, or file type, set the per-path cache behavior to <code>dont-cache</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * CacheBehaviorPerPathProperty cacheBehaviorPerPathProperty = CacheBehaviorPerPathProperty.builder()
     *         .behavior("behavior")
     *         .path("path")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachebehaviorperpath.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachebehaviorperpath.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnDistribution.CacheBehaviorPerPathProperty")
    @software.amazon.jsii.Jsii.Proxy(CacheBehaviorPerPathProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CacheBehaviorPerPathProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The cache behavior for the specified path.
         * <p>
         * You can specify one of the following per-path cache behaviors:
         * <p>
         * <ul>
         * <li><em><code>cache</code></em> - This behavior caches the specified path.</li>
         * <li><em><code>dont-cache</code></em> - This behavior doesn't cache the specified path.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachebehaviorperpath.html#cfn-lightsail-distribution-cachebehaviorperpath-behavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachebehaviorperpath.html#cfn-lightsail-distribution-cachebehaviorperpath-behavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBehavior() {
            return null;
        }

        /**
         * The path to a directory or file to cache, or not cache.
         * <p>
         * Use an asterisk symbol to specify wildcard directories ( <code>path/to/assets/*</code> ), and file types ( <code>*.html</code> , <code>*jpg</code> , <code>*js</code> ). Directories and file paths are case-sensitive.
         * <p>
         * Examples:
         * <p>
         * <ul>
         * <li>Specify the following to cache all files in the document root of an Apache web server running on a instance.</li>
         * </ul>
         * <p>
         * <code>var/www/html/</code>
         * <p>
         * <ul>
         * <li>Specify the following file to cache only the index page in the document root of an Apache web server.</li>
         * </ul>
         * <p>
         * <code>var/www/html/index.html</code>
         * <p>
         * <ul>
         * <li>Specify the following to cache only the .html files in the document root of an Apache web server.</li>
         * </ul>
         * <p>
         * <code>var/www/html/*.html</code>
         * <p>
         * <ul>
         * <li>Specify the following to cache only the .jpg, .png, and .gif files in the images sub-directory of the document root of an Apache web server.</li>
         * </ul>
         * <p>
         * <code>var/www/html/images/*.jpg</code>
         * <p>
         * <code>var/www/html/images/*.png</code>
         * <p>
         * <code>var/www/html/images/*.gif</code>
         * <p>
         * Specify the following to cache all files in the images subdirectory of the document root of an Apache web server.
         * <p>
         * <code>var/www/html/images/</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachebehaviorperpath.html#cfn-lightsail-distribution-cachebehaviorperpath-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachebehaviorperpath.html#cfn-lightsail-distribution-cachebehaviorperpath-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CacheBehaviorPerPathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CacheBehaviorPerPathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CacheBehaviorPerPathProperty> {
            java.lang.String behavior;
            java.lang.String path;

            /**
             * Sets the value of {@link CacheBehaviorPerPathProperty#getBehavior}
             * @param behavior The cache behavior for the specified path.
             *                 You can specify one of the following per-path cache behaviors:
             *                 <p>
             *                 <ul>
             *                 <li><em><code>cache</code></em> - This behavior caches the specified path.</li>
             *                 <li><em><code>dont-cache</code></em> - This behavior doesn't cache the specified path.</li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder behavior(java.lang.String behavior) {
                this.behavior = behavior;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorPerPathProperty#getPath}
             * @param path The path to a directory or file to cache, or not cache.
             *             Use an asterisk symbol to specify wildcard directories ( <code>path/to/assets/*</code> ), and file types ( <code>*.html</code> , <code>*jpg</code> , <code>*js</code> ). Directories and file paths are case-sensitive.
             *             <p>
             *             Examples:
             *             <p>
             *             <ul>
             *             <li>Specify the following to cache all files in the document root of an Apache web server running on a instance.</li>
             *             </ul>
             *             <p>
             *             <code>var/www/html/</code>
             *             <p>
             *             <ul>
             *             <li>Specify the following file to cache only the index page in the document root of an Apache web server.</li>
             *             </ul>
             *             <p>
             *             <code>var/www/html/index.html</code>
             *             <p>
             *             <ul>
             *             <li>Specify the following to cache only the .html files in the document root of an Apache web server.</li>
             *             </ul>
             *             <p>
             *             <code>var/www/html/*.html</code>
             *             <p>
             *             <ul>
             *             <li>Specify the following to cache only the .jpg, .png, and .gif files in the images sub-directory of the document root of an Apache web server.</li>
             *             </ul>
             *             <p>
             *             <code>var/www/html/images/*.jpg</code>
             *             <p>
             *             <code>var/www/html/images/*.png</code>
             *             <p>
             *             <code>var/www/html/images/*.gif</code>
             *             <p>
             *             Specify the following to cache all files in the images subdirectory of the document root of an Apache web server.
             *             <p>
             *             <code>var/www/html/images/</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CacheBehaviorPerPathProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CacheBehaviorPerPathProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CacheBehaviorPerPathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CacheBehaviorPerPathProperty {
            private final java.lang.String behavior;
            private final java.lang.String path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.behavior = software.amazon.jsii.Kernel.get(this, "behavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.behavior = builder.behavior;
                this.path = builder.path;
            }

            @Override
            public final java.lang.String getBehavior() {
                return this.behavior;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBehavior() != null) {
                    data.set("behavior", om.valueToTree(this.getBehavior()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnDistribution.CacheBehaviorPerPathProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CacheBehaviorPerPathProperty.Jsii$Proxy that = (CacheBehaviorPerPathProperty.Jsii$Proxy) o;

                if (this.behavior != null ? !this.behavior.equals(that.behavior) : that.behavior != null) return false;
                return this.path != null ? this.path.equals(that.path) : that.path == null;
            }

            @Override
            public final int hashCode() {
                int result = this.behavior != null ? this.behavior.hashCode() : 0;
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>CacheBehavior</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html">AWS::Lightsail::Distribution</a> resource. It describes the default cache behavior of an Amazon Lightsail content delivery network (CDN) distribution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * CacheBehaviorProperty cacheBehaviorProperty = CacheBehaviorProperty.builder()
     *         .behavior("behavior")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachebehavior.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachebehavior.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnDistribution.CacheBehaviorProperty")
    @software.amazon.jsii.Jsii.Proxy(CacheBehaviorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CacheBehaviorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The cache behavior of the distribution.
         * <p>
         * The following cache behaviors can be specified:
         * <p>
         * <ul>
         * <li><em><code>cache</code></em> - This option is best for static sites. When specified, your distribution caches and serves your entire website as static content. This behavior is ideal for websites with static content that doesn't change depending on who views it, or for websites that don't use cookies, headers, or query strings to personalize content.</li>
         * <li><em><code>dont-cache</code></em> - This option is best for sites that serve a mix of static and dynamic content. When specified, your distribution caches and serves only the content that is specified in the distribution’s <code>CacheBehaviorPerPath</code> parameter. This behavior is ideal for websites or web applications that use cookies, headers, and query strings to personalize content for individual users.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachebehavior.html#cfn-lightsail-distribution-cachebehavior-behavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachebehavior.html#cfn-lightsail-distribution-cachebehavior-behavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBehavior() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CacheBehaviorProperty> {
            java.lang.String behavior;

            /**
             * Sets the value of {@link CacheBehaviorProperty#getBehavior}
             * @param behavior The cache behavior of the distribution.
             *                 The following cache behaviors can be specified:
             *                 <p>
             *                 <ul>
             *                 <li><em><code>cache</code></em> - This option is best for static sites. When specified, your distribution caches and serves your entire website as static content. This behavior is ideal for websites with static content that doesn't change depending on who views it, or for websites that don't use cookies, headers, or query strings to personalize content.</li>
             *                 <li><em><code>dont-cache</code></em> - This option is best for sites that serve a mix of static and dynamic content. When specified, your distribution caches and serves only the content that is specified in the distribution’s <code>CacheBehaviorPerPath</code> parameter. This behavior is ideal for websites or web applications that use cookies, headers, and query strings to personalize content for individual users.</li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder behavior(java.lang.String behavior) {
                this.behavior = behavior;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CacheBehaviorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CacheBehaviorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CacheBehaviorProperty {
            private final java.lang.String behavior;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.behavior = software.amazon.jsii.Kernel.get(this, "behavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.behavior = builder.behavior;
            }

            @Override
            public final java.lang.String getBehavior() {
                return this.behavior;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBehavior() != null) {
                    data.set("behavior", om.valueToTree(this.getBehavior()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnDistribution.CacheBehaviorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CacheBehaviorProperty.Jsii$Proxy that = (CacheBehaviorProperty.Jsii$Proxy) o;

                return this.behavior != null ? this.behavior.equals(that.behavior) : that.behavior == null;
            }

            @Override
            public final int hashCode() {
                int result = this.behavior != null ? this.behavior.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * <code>CacheSettings</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html">AWS::Lightsail::Distribution</a> resource. It describes the cache settings of an Amazon Lightsail content delivery network (CDN) distribution.
     * <p>
     * These settings apply only to your distribution’s <code>CacheBehaviors</code> that have a <code>Behavior</code> of <code>cache</code> . This includes the <code>DefaultCacheBehavior</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * CacheSettingsProperty cacheSettingsProperty = CacheSettingsProperty.builder()
     *         .allowedHttpMethods("allowedHttpMethods")
     *         .cachedHttpMethods("cachedHttpMethods")
     *         .defaultTtl(123)
     *         .forwardedCookies(CookieObjectProperty.builder()
     *                 .cookiesAllowList(List.of("cookiesAllowList"))
     *                 .option("option")
     *                 .build())
     *         .forwardedHeaders(HeaderObjectProperty.builder()
     *                 .headersAllowList(List.of("headersAllowList"))
     *                 .option("option")
     *                 .build())
     *         .forwardedQueryStrings(QueryStringObjectProperty.builder()
     *                 .option(false)
     *                 .queryStringsAllowList(List.of("queryStringsAllowList"))
     *                 .build())
     *         .maximumTtl(123)
     *         .minimumTtl(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnDistribution.CacheSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(CacheSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CacheSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The HTTP methods that are processed and forwarded to the distribution's origin.
         * <p>
         * You can specify the following options:
         * <p>
         * <ul>
         * <li><code>GET,HEAD</code> - The distribution forwards the <code>GET</code> and <code>HEAD</code> methods.</li>
         * <li><code>GET,HEAD,OPTIONS</code> - The distribution forwards the <code>GET</code> , <code>HEAD</code> , and <code>OPTIONS</code> methods.</li>
         * <li><code>GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE</code> - The distribution forwards the <code>GET</code> , <code>HEAD</code> , <code>OPTIONS</code> , <code>PUT</code> , <code>PATCH</code> , <code>POST</code> , and <code>DELETE</code> methods.</li>
         * </ul>
         * <p>
         * If you specify <code>GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE</code> , you might need to restrict access to your distribution's origin so users can't perform operations that you don't want them to. For example, you might not want users to have permission to delete objects from your origin.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-allowedhttpmethods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-allowedhttpmethods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllowedHttpMethods() {
            return null;
        }

        /**
         * The HTTP method responses that are cached by your distribution.
         * <p>
         * You can specify the following options:
         * <p>
         * <ul>
         * <li><code>GET,HEAD</code> - The distribution caches responses to the <code>GET</code> and <code>HEAD</code> methods.</li>
         * <li><code>GET,HEAD,OPTIONS</code> - The distribution caches responses to the <code>GET</code> , <code>HEAD</code> , and <code>OPTIONS</code> methods.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-cachedhttpmethods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-cachedhttpmethods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCachedHttpMethods() {
            return null;
        }

        /**
         * The default amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the content has been updated.
         * <p>
         * <blockquote>
         * <p>
         * The value specified applies only when the origin does not add HTTP headers such as <code>Cache-Control max-age</code> , <code>Cache-Control s-maxage</code> , and <code>Expires</code> to objects.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-defaultttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-defaultttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultTtl() {
            return null;
        }

        /**
         * An object that describes the cookies that are forwarded to the origin.
         * <p>
         * Your content is cached based on the cookies that are forwarded.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-forwardedcookies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-forwardedcookies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardedCookies() {
            return null;
        }

        /**
         * An object that describes the headers that are forwarded to the origin.
         * <p>
         * Your content is cached based on the headers that are forwarded.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-forwardedheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-forwardedheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardedHeaders() {
            return null;
        }

        /**
         * An object that describes the query strings that are forwarded to the origin.
         * <p>
         * Your content is cached based on the query strings that are forwarded.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-forwardedquerystrings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-forwardedquerystrings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardedQueryStrings() {
            return null;
        }

        /**
         * The maximum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
         * <p>
         * The value specified applies only when the origin adds HTTP headers such as <code>Cache-Control max-age</code> , <code>Cache-Control s-maxage</code> , and <code>Expires</code> to objects.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-maximumttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-maximumttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumTtl() {
            return null;
        }

        /**
         * The minimum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
         * <p>
         * A value of <code>0</code> must be specified for <code>minimumTTL</code> if the distribution is configured to forward all headers to the origin.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-minimumttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html#cfn-lightsail-distribution-cachesettings-minimumttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumTtl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CacheSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CacheSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CacheSettingsProperty> {
            java.lang.String allowedHttpMethods;
            java.lang.String cachedHttpMethods;
            java.lang.Number defaultTtl;
            java.lang.Object forwardedCookies;
            java.lang.Object forwardedHeaders;
            java.lang.Object forwardedQueryStrings;
            java.lang.Number maximumTtl;
            java.lang.Number minimumTtl;

            /**
             * Sets the value of {@link CacheSettingsProperty#getAllowedHttpMethods}
             * @param allowedHttpMethods The HTTP methods that are processed and forwarded to the distribution's origin.
             *                           You can specify the following options:
             *                           <p>
             *                           <ul>
             *                           <li><code>GET,HEAD</code> - The distribution forwards the <code>GET</code> and <code>HEAD</code> methods.</li>
             *                           <li><code>GET,HEAD,OPTIONS</code> - The distribution forwards the <code>GET</code> , <code>HEAD</code> , and <code>OPTIONS</code> methods.</li>
             *                           <li><code>GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE</code> - The distribution forwards the <code>GET</code> , <code>HEAD</code> , <code>OPTIONS</code> , <code>PUT</code> , <code>PATCH</code> , <code>POST</code> , and <code>DELETE</code> methods.</li>
             *                           </ul>
             *                           <p>
             *                           If you specify <code>GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE</code> , you might need to restrict access to your distribution's origin so users can't perform operations that you don't want them to. For example, you might not want users to have permission to delete objects from your origin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedHttpMethods(java.lang.String allowedHttpMethods) {
                this.allowedHttpMethods = allowedHttpMethods;
                return this;
            }

            /**
             * Sets the value of {@link CacheSettingsProperty#getCachedHttpMethods}
             * @param cachedHttpMethods The HTTP method responses that are cached by your distribution.
             *                          You can specify the following options:
             *                          <p>
             *                          <ul>
             *                          <li><code>GET,HEAD</code> - The distribution caches responses to the <code>GET</code> and <code>HEAD</code> methods.</li>
             *                          <li><code>GET,HEAD,OPTIONS</code> - The distribution caches responses to the <code>GET</code> , <code>HEAD</code> , and <code>OPTIONS</code> methods.</li>
             *                          </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachedHttpMethods(java.lang.String cachedHttpMethods) {
                this.cachedHttpMethods = cachedHttpMethods;
                return this;
            }

            /**
             * Sets the value of {@link CacheSettingsProperty#getDefaultTtl}
             * @param defaultTtl The default amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the content has been updated.
             *                   <blockquote>
             *                   <p>
             *                   The value specified applies only when the origin does not add HTTP headers such as <code>Cache-Control max-age</code> , <code>Cache-Control s-maxage</code> , and <code>Expires</code> to objects.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultTtl(java.lang.Number defaultTtl) {
                this.defaultTtl = defaultTtl;
                return this;
            }

            /**
             * Sets the value of {@link CacheSettingsProperty#getForwardedCookies}
             * @param forwardedCookies An object that describes the cookies that are forwarded to the origin.
             *                         Your content is cached based on the cookies that are forwarded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedCookies(software.amazon.awscdk.IResolvable forwardedCookies) {
                this.forwardedCookies = forwardedCookies;
                return this;
            }

            /**
             * Sets the value of {@link CacheSettingsProperty#getForwardedCookies}
             * @param forwardedCookies An object that describes the cookies that are forwarded to the origin.
             *                         Your content is cached based on the cookies that are forwarded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedCookies(software.amazon.awscdk.services.lightsail.CfnDistribution.CookieObjectProperty forwardedCookies) {
                this.forwardedCookies = forwardedCookies;
                return this;
            }

            /**
             * Sets the value of {@link CacheSettingsProperty#getForwardedHeaders}
             * @param forwardedHeaders An object that describes the headers that are forwarded to the origin.
             *                         Your content is cached based on the headers that are forwarded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedHeaders(software.amazon.awscdk.IResolvable forwardedHeaders) {
                this.forwardedHeaders = forwardedHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CacheSettingsProperty#getForwardedHeaders}
             * @param forwardedHeaders An object that describes the headers that are forwarded to the origin.
             *                         Your content is cached based on the headers that are forwarded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedHeaders(software.amazon.awscdk.services.lightsail.CfnDistribution.HeaderObjectProperty forwardedHeaders) {
                this.forwardedHeaders = forwardedHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CacheSettingsProperty#getForwardedQueryStrings}
             * @param forwardedQueryStrings An object that describes the query strings that are forwarded to the origin.
             *                              Your content is cached based on the query strings that are forwarded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedQueryStrings(software.amazon.awscdk.IResolvable forwardedQueryStrings) {
                this.forwardedQueryStrings = forwardedQueryStrings;
                return this;
            }

            /**
             * Sets the value of {@link CacheSettingsProperty#getForwardedQueryStrings}
             * @param forwardedQueryStrings An object that describes the query strings that are forwarded to the origin.
             *                              Your content is cached based on the query strings that are forwarded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedQueryStrings(software.amazon.awscdk.services.lightsail.CfnDistribution.QueryStringObjectProperty forwardedQueryStrings) {
                this.forwardedQueryStrings = forwardedQueryStrings;
                return this;
            }

            /**
             * Sets the value of {@link CacheSettingsProperty#getMaximumTtl}
             * @param maximumTtl The maximum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
             *                   The value specified applies only when the origin adds HTTP headers such as <code>Cache-Control max-age</code> , <code>Cache-Control s-maxage</code> , and <code>Expires</code> to objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumTtl(java.lang.Number maximumTtl) {
                this.maximumTtl = maximumTtl;
                return this;
            }

            /**
             * Sets the value of {@link CacheSettingsProperty#getMinimumTtl}
             * @param minimumTtl The minimum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
             *                   A value of <code>0</code> must be specified for <code>minimumTTL</code> if the distribution is configured to forward all headers to the origin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumTtl(java.lang.Number minimumTtl) {
                this.minimumTtl = minimumTtl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CacheSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CacheSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CacheSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CacheSettingsProperty {
            private final java.lang.String allowedHttpMethods;
            private final java.lang.String cachedHttpMethods;
            private final java.lang.Number defaultTtl;
            private final java.lang.Object forwardedCookies;
            private final java.lang.Object forwardedHeaders;
            private final java.lang.Object forwardedQueryStrings;
            private final java.lang.Number maximumTtl;
            private final java.lang.Number minimumTtl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowedHttpMethods = software.amazon.jsii.Kernel.get(this, "allowedHttpMethods", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cachedHttpMethods = software.amazon.jsii.Kernel.get(this, "cachedHttpMethods", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultTtl = software.amazon.jsii.Kernel.get(this, "defaultTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.forwardedCookies = software.amazon.jsii.Kernel.get(this, "forwardedCookies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.forwardedHeaders = software.amazon.jsii.Kernel.get(this, "forwardedHeaders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.forwardedQueryStrings = software.amazon.jsii.Kernel.get(this, "forwardedQueryStrings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumTtl = software.amazon.jsii.Kernel.get(this, "maximumTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimumTtl = software.amazon.jsii.Kernel.get(this, "minimumTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedHttpMethods = builder.allowedHttpMethods;
                this.cachedHttpMethods = builder.cachedHttpMethods;
                this.defaultTtl = builder.defaultTtl;
                this.forwardedCookies = builder.forwardedCookies;
                this.forwardedHeaders = builder.forwardedHeaders;
                this.forwardedQueryStrings = builder.forwardedQueryStrings;
                this.maximumTtl = builder.maximumTtl;
                this.minimumTtl = builder.minimumTtl;
            }

            @Override
            public final java.lang.String getAllowedHttpMethods() {
                return this.allowedHttpMethods;
            }

            @Override
            public final java.lang.String getCachedHttpMethods() {
                return this.cachedHttpMethods;
            }

            @Override
            public final java.lang.Number getDefaultTtl() {
                return this.defaultTtl;
            }

            @Override
            public final java.lang.Object getForwardedCookies() {
                return this.forwardedCookies;
            }

            @Override
            public final java.lang.Object getForwardedHeaders() {
                return this.forwardedHeaders;
            }

            @Override
            public final java.lang.Object getForwardedQueryStrings() {
                return this.forwardedQueryStrings;
            }

            @Override
            public final java.lang.Number getMaximumTtl() {
                return this.maximumTtl;
            }

            @Override
            public final java.lang.Number getMinimumTtl() {
                return this.minimumTtl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowedHttpMethods() != null) {
                    data.set("allowedHttpMethods", om.valueToTree(this.getAllowedHttpMethods()));
                }
                if (this.getCachedHttpMethods() != null) {
                    data.set("cachedHttpMethods", om.valueToTree(this.getCachedHttpMethods()));
                }
                if (this.getDefaultTtl() != null) {
                    data.set("defaultTtl", om.valueToTree(this.getDefaultTtl()));
                }
                if (this.getForwardedCookies() != null) {
                    data.set("forwardedCookies", om.valueToTree(this.getForwardedCookies()));
                }
                if (this.getForwardedHeaders() != null) {
                    data.set("forwardedHeaders", om.valueToTree(this.getForwardedHeaders()));
                }
                if (this.getForwardedQueryStrings() != null) {
                    data.set("forwardedQueryStrings", om.valueToTree(this.getForwardedQueryStrings()));
                }
                if (this.getMaximumTtl() != null) {
                    data.set("maximumTtl", om.valueToTree(this.getMaximumTtl()));
                }
                if (this.getMinimumTtl() != null) {
                    data.set("minimumTtl", om.valueToTree(this.getMinimumTtl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnDistribution.CacheSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CacheSettingsProperty.Jsii$Proxy that = (CacheSettingsProperty.Jsii$Proxy) o;

                if (this.allowedHttpMethods != null ? !this.allowedHttpMethods.equals(that.allowedHttpMethods) : that.allowedHttpMethods != null) return false;
                if (this.cachedHttpMethods != null ? !this.cachedHttpMethods.equals(that.cachedHttpMethods) : that.cachedHttpMethods != null) return false;
                if (this.defaultTtl != null ? !this.defaultTtl.equals(that.defaultTtl) : that.defaultTtl != null) return false;
                if (this.forwardedCookies != null ? !this.forwardedCookies.equals(that.forwardedCookies) : that.forwardedCookies != null) return false;
                if (this.forwardedHeaders != null ? !this.forwardedHeaders.equals(that.forwardedHeaders) : that.forwardedHeaders != null) return false;
                if (this.forwardedQueryStrings != null ? !this.forwardedQueryStrings.equals(that.forwardedQueryStrings) : that.forwardedQueryStrings != null) return false;
                if (this.maximumTtl != null ? !this.maximumTtl.equals(that.maximumTtl) : that.maximumTtl != null) return false;
                return this.minimumTtl != null ? this.minimumTtl.equals(that.minimumTtl) : that.minimumTtl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowedHttpMethods != null ? this.allowedHttpMethods.hashCode() : 0;
                result = 31 * result + (this.cachedHttpMethods != null ? this.cachedHttpMethods.hashCode() : 0);
                result = 31 * result + (this.defaultTtl != null ? this.defaultTtl.hashCode() : 0);
                result = 31 * result + (this.forwardedCookies != null ? this.forwardedCookies.hashCode() : 0);
                result = 31 * result + (this.forwardedHeaders != null ? this.forwardedHeaders.hashCode() : 0);
                result = 31 * result + (this.forwardedQueryStrings != null ? this.forwardedQueryStrings.hashCode() : 0);
                result = 31 * result + (this.maximumTtl != null ? this.maximumTtl.hashCode() : 0);
                result = 31 * result + (this.minimumTtl != null ? this.minimumTtl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>CookieObject</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html">CacheSettings</a> property. It describes whether an Amazon Lightsail content delivery network (CDN) distribution forwards cookies to the origin and, if so, which ones.
     * <p>
     * For the cookies that you specify, your distribution caches separate versions of the specified content based on the cookie values in viewer requests.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * CookieObjectProperty cookieObjectProperty = CookieObjectProperty.builder()
     *         .cookiesAllowList(List.of("cookiesAllowList"))
     *         .option("option")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cookieobject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cookieobject.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnDistribution.CookieObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(CookieObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CookieObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The specific cookies to forward to your distribution's origin.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cookieobject.html#cfn-lightsail-distribution-cookieobject-cookiesallowlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cookieobject.html#cfn-lightsail-distribution-cookieobject-cookiesallowlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCookiesAllowList() {
            return null;
        }

        /**
         * Specifies which cookies to forward to the distribution's origin for a cache behavior.
         * <p>
         * Use one of the following configurations for your distribution:
         * <p>
         * <ul>
         * <li><em><code>all</code></em> - Forwards all cookies to your origin.</li>
         * <li><em><code>none</code></em> - Doesn’t forward cookies to your origin.</li>
         * <li><em><code>allow-list</code></em> - Forwards only the cookies that you specify using the <code>CookiesAllowList</code> parameter.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cookieobject.html#cfn-lightsail-distribution-cookieobject-option">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cookieobject.html#cfn-lightsail-distribution-cookieobject-option</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOption() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CookieObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CookieObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CookieObjectProperty> {
            java.util.List<java.lang.String> cookiesAllowList;
            java.lang.String option;

            /**
             * Sets the value of {@link CookieObjectProperty#getCookiesAllowList}
             * @param cookiesAllowList The specific cookies to forward to your distribution's origin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookiesAllowList(java.util.List<java.lang.String> cookiesAllowList) {
                this.cookiesAllowList = cookiesAllowList;
                return this;
            }

            /**
             * Sets the value of {@link CookieObjectProperty#getOption}
             * @param option Specifies which cookies to forward to the distribution's origin for a cache behavior.
             *               Use one of the following configurations for your distribution:
             *               <p>
             *               <ul>
             *               <li><em><code>all</code></em> - Forwards all cookies to your origin.</li>
             *               <li><em><code>none</code></em> - Doesn’t forward cookies to your origin.</li>
             *               <li><em><code>allow-list</code></em> - Forwards only the cookies that you specify using the <code>CookiesAllowList</code> parameter.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder option(java.lang.String option) {
                this.option = option;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CookieObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CookieObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CookieObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CookieObjectProperty {
            private final java.util.List<java.lang.String> cookiesAllowList;
            private final java.lang.String option;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cookiesAllowList = software.amazon.jsii.Kernel.get(this, "cookiesAllowList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.option = software.amazon.jsii.Kernel.get(this, "option", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cookiesAllowList = builder.cookiesAllowList;
                this.option = builder.option;
            }

            @Override
            public final java.util.List<java.lang.String> getCookiesAllowList() {
                return this.cookiesAllowList;
            }

            @Override
            public final java.lang.String getOption() {
                return this.option;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCookiesAllowList() != null) {
                    data.set("cookiesAllowList", om.valueToTree(this.getCookiesAllowList()));
                }
                if (this.getOption() != null) {
                    data.set("option", om.valueToTree(this.getOption()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnDistribution.CookieObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CookieObjectProperty.Jsii$Proxy that = (CookieObjectProperty.Jsii$Proxy) o;

                if (this.cookiesAllowList != null ? !this.cookiesAllowList.equals(that.cookiesAllowList) : that.cookiesAllowList != null) return false;
                return this.option != null ? this.option.equals(that.option) : that.option == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cookiesAllowList != null ? this.cookiesAllowList.hashCode() : 0;
                result = 31 * result + (this.option != null ? this.option.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>HeaderObject</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html">CacheSettings</a> property. It describes the request headers used by your distribution, which caches your content based on the request headers.
     * <p>
     * For the headers that you specify, your distribution caches separate versions of the specified content based on the header values in viewer requests. For example, suppose that viewer requests for logo.jpg contain a custom product header that has a value of either acme or apex. Also, suppose that you configure your distribution to cache your content based on values in the product header. Your distribution forwards the product header to the origin and caches the response from the origin once for each header value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * HeaderObjectProperty headerObjectProperty = HeaderObjectProperty.builder()
     *         .headersAllowList(List.of("headersAllowList"))
     *         .option("option")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-headerobject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-headerobject.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnDistribution.HeaderObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(HeaderObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HeaderObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The specific headers to forward to your distribution's origin.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-headerobject.html#cfn-lightsail-distribution-headerobject-headersallowlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-headerobject.html#cfn-lightsail-distribution-headerobject-headersallowlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHeadersAllowList() {
            return null;
        }

        /**
         * The headers that you want your distribution to forward to your origin.
         * <p>
         * Your distribution caches your content based on these headers.
         * <p>
         * Use one of the following configurations for your distribution:
         * <p>
         * <ul>
         * <li><em><code>all</code></em> - Forwards all headers to your origin..</li>
         * <li><em><code>none</code></em> - Forwards only the default headers.</li>
         * <li><em><code>allow-list</code></em> - Forwards only the headers that you specify using the <code>HeadersAllowList</code> parameter.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-headerobject.html#cfn-lightsail-distribution-headerobject-option">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-headerobject.html#cfn-lightsail-distribution-headerobject-option</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOption() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HeaderObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HeaderObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HeaderObjectProperty> {
            java.util.List<java.lang.String> headersAllowList;
            java.lang.String option;

            /**
             * Sets the value of {@link HeaderObjectProperty#getHeadersAllowList}
             * @param headersAllowList The specific headers to forward to your distribution's origin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headersAllowList(java.util.List<java.lang.String> headersAllowList) {
                this.headersAllowList = headersAllowList;
                return this;
            }

            /**
             * Sets the value of {@link HeaderObjectProperty#getOption}
             * @param option The headers that you want your distribution to forward to your origin.
             *               Your distribution caches your content based on these headers.
             *               <p>
             *               Use one of the following configurations for your distribution:
             *               <p>
             *               <ul>
             *               <li><em><code>all</code></em> - Forwards all headers to your origin..</li>
             *               <li><em><code>none</code></em> - Forwards only the default headers.</li>
             *               <li><em><code>allow-list</code></em> - Forwards only the headers that you specify using the <code>HeadersAllowList</code> parameter.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder option(java.lang.String option) {
                this.option = option;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HeaderObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HeaderObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HeaderObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HeaderObjectProperty {
            private final java.util.List<java.lang.String> headersAllowList;
            private final java.lang.String option;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.headersAllowList = software.amazon.jsii.Kernel.get(this, "headersAllowList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.option = software.amazon.jsii.Kernel.get(this, "option", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.headersAllowList = builder.headersAllowList;
                this.option = builder.option;
            }

            @Override
            public final java.util.List<java.lang.String> getHeadersAllowList() {
                return this.headersAllowList;
            }

            @Override
            public final java.lang.String getOption() {
                return this.option;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHeadersAllowList() != null) {
                    data.set("headersAllowList", om.valueToTree(this.getHeadersAllowList()));
                }
                if (this.getOption() != null) {
                    data.set("option", om.valueToTree(this.getOption()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnDistribution.HeaderObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HeaderObjectProperty.Jsii$Proxy that = (HeaderObjectProperty.Jsii$Proxy) o;

                if (this.headersAllowList != null ? !this.headersAllowList.equals(that.headersAllowList) : that.headersAllowList != null) return false;
                return this.option != null ? this.option.equals(that.option) : that.option == null;
            }

            @Override
            public final int hashCode() {
                int result = this.headersAllowList != null ? this.headersAllowList.hashCode() : 0;
                result = 31 * result + (this.option != null ? this.option.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>InputOrigin</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html">AWS::Lightsail::Distribution</a> resource. It describes the origin resource of an Amazon Lightsail content delivery network (CDN) distribution.
     * <p>
     * An origin can be a instance, bucket, or load balancer. A distribution pulls content from an origin, caches it, and serves it to viewers through a worldwide network of edge servers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * InputOriginProperty inputOriginProperty = InputOriginProperty.builder()
     *         .name("name")
     *         .protocolPolicy("protocolPolicy")
     *         .regionName("regionName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-inputorigin.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-inputorigin.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnDistribution.InputOriginProperty")
    @software.amazon.jsii.Jsii.Proxy(InputOriginProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputOriginProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the origin resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-inputorigin.html#cfn-lightsail-distribution-inputorigin-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-inputorigin.html#cfn-lightsail-distribution-inputorigin-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-inputorigin.html#cfn-lightsail-distribution-inputorigin-protocolpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-inputorigin.html#cfn-lightsail-distribution-inputorigin-protocolpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocolPolicy() {
            return null;
        }

        /**
         * The AWS Region name of the origin resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-inputorigin.html#cfn-lightsail-distribution-inputorigin-regionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-inputorigin.html#cfn-lightsail-distribution-inputorigin-regionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegionName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputOriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputOriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputOriginProperty> {
            java.lang.String name;
            java.lang.String protocolPolicy;
            java.lang.String regionName;

            /**
             * Sets the value of {@link InputOriginProperty#getName}
             * @param name The name of the origin resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link InputOriginProperty#getProtocolPolicy}
             * @param protocolPolicy The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocolPolicy(java.lang.String protocolPolicy) {
                this.protocolPolicy = protocolPolicy;
                return this;
            }

            /**
             * Sets the value of {@link InputOriginProperty#getRegionName}
             * @param regionName The AWS Region name of the origin resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regionName(java.lang.String regionName) {
                this.regionName = regionName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputOriginProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputOriginProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputOriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputOriginProperty {
            private final java.lang.String name;
            private final java.lang.String protocolPolicy;
            private final java.lang.String regionName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocolPolicy = software.amazon.jsii.Kernel.get(this, "protocolPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.regionName = software.amazon.jsii.Kernel.get(this, "regionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.protocolPolicy = builder.protocolPolicy;
                this.regionName = builder.regionName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getProtocolPolicy() {
                return this.protocolPolicy;
            }

            @Override
            public final java.lang.String getRegionName() {
                return this.regionName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getProtocolPolicy() != null) {
                    data.set("protocolPolicy", om.valueToTree(this.getProtocolPolicy()));
                }
                if (this.getRegionName() != null) {
                    data.set("regionName", om.valueToTree(this.getRegionName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnDistribution.InputOriginProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputOriginProperty.Jsii$Proxy that = (InputOriginProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.protocolPolicy != null ? !this.protocolPolicy.equals(that.protocolPolicy) : that.protocolPolicy != null) return false;
                return this.regionName != null ? this.regionName.equals(that.regionName) : that.regionName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.protocolPolicy != null ? this.protocolPolicy.hashCode() : 0);
                result = 31 * result + (this.regionName != null ? this.regionName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>QueryStringObject</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-cachesettings.html">CacheSettings</a> property. It describes the query string parameters that an Amazon Lightsail content delivery network (CDN) distribution to bases caching on.
     * <p>
     * For the query strings that you specify, your distribution caches separate versions of the specified content based on the query string values in viewer requests.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * QueryStringObjectProperty queryStringObjectProperty = QueryStringObjectProperty.builder()
     *         .option(false)
     *         .queryStringsAllowList(List.of("queryStringsAllowList"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-querystringobject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-querystringobject.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnDistribution.QueryStringObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryStringObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryStringObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the distribution forwards and caches based on query strings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-querystringobject.html#cfn-lightsail-distribution-querystringobject-option">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-querystringobject.html#cfn-lightsail-distribution-querystringobject-option</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOption() {
            return null;
        }

        /**
         * The specific query strings that the distribution forwards to the origin.
         * <p>
         * Your distribution caches content based on the specified query strings.
         * <p>
         * If the <code>option</code> parameter is true, then your distribution forwards all query strings, regardless of what you specify using the <code>QueryStringsAllowList</code> parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-querystringobject.html#cfn-lightsail-distribution-querystringobject-querystringsallowlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-distribution-querystringobject.html#cfn-lightsail-distribution-querystringobject-querystringsallowlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getQueryStringsAllowList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueryStringObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryStringObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryStringObjectProperty> {
            java.lang.Object option;
            java.util.List<java.lang.String> queryStringsAllowList;

            /**
             * Sets the value of {@link QueryStringObjectProperty#getOption}
             * @param option Indicates whether the distribution forwards and caches based on query strings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder option(java.lang.Boolean option) {
                this.option = option;
                return this;
            }

            /**
             * Sets the value of {@link QueryStringObjectProperty#getOption}
             * @param option Indicates whether the distribution forwards and caches based on query strings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder option(software.amazon.awscdk.IResolvable option) {
                this.option = option;
                return this;
            }

            /**
             * Sets the value of {@link QueryStringObjectProperty#getQueryStringsAllowList}
             * @param queryStringsAllowList The specific query strings that the distribution forwards to the origin.
             *                              Your distribution caches content based on the specified query strings.
             *                              <p>
             *                              If the <code>option</code> parameter is true, then your distribution forwards all query strings, regardless of what you specify using the <code>QueryStringsAllowList</code> parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringsAllowList(java.util.List<java.lang.String> queryStringsAllowList) {
                this.queryStringsAllowList = queryStringsAllowList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryStringObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryStringObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryStringObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryStringObjectProperty {
            private final java.lang.Object option;
            private final java.util.List<java.lang.String> queryStringsAllowList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.option = software.amazon.jsii.Kernel.get(this, "option", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queryStringsAllowList = software.amazon.jsii.Kernel.get(this, "queryStringsAllowList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.option = builder.option;
                this.queryStringsAllowList = builder.queryStringsAllowList;
            }

            @Override
            public final java.lang.Object getOption() {
                return this.option;
            }

            @Override
            public final java.util.List<java.lang.String> getQueryStringsAllowList() {
                return this.queryStringsAllowList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOption() != null) {
                    data.set("option", om.valueToTree(this.getOption()));
                }
                if (this.getQueryStringsAllowList() != null) {
                    data.set("queryStringsAllowList", om.valueToTree(this.getQueryStringsAllowList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnDistribution.QueryStringObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryStringObjectProperty.Jsii$Proxy that = (QueryStringObjectProperty.Jsii$Proxy) o;

                if (this.option != null ? !this.option.equals(that.option) : that.option != null) return false;
                return this.queryStringsAllowList != null ? this.queryStringsAllowList.equals(that.queryStringsAllowList) : that.queryStringsAllowList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.option != null ? this.option.hashCode() : 0;
                result = 31 * result + (this.queryStringsAllowList != null ? this.queryStringsAllowList.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lightsail.CfnDistribution}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lightsail.CfnDistribution> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lightsail.CfnDistributionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lightsail.CfnDistributionProps.Builder();
        }

        /**
         * The ID of the bundle applied to the distribution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-bundleid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-bundleid</a>
         * @param bundleId The ID of the bundle applied to the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundleId(final java.lang.String bundleId) {
            this.props.bundleId(bundleId);
            return this;
        }

        /**
         * An object that describes the default cache behavior of the distribution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-defaultcachebehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-defaultcachebehavior</a>
         * @param defaultCacheBehavior An object that describes the default cache behavior of the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCacheBehavior(final software.amazon.awscdk.IResolvable defaultCacheBehavior) {
            this.props.defaultCacheBehavior(defaultCacheBehavior);
            return this;
        }
        /**
         * An object that describes the default cache behavior of the distribution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-defaultcachebehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-defaultcachebehavior</a>
         * @param defaultCacheBehavior An object that describes the default cache behavior of the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCacheBehavior(final software.amazon.awscdk.services.lightsail.CfnDistribution.CacheBehaviorProperty defaultCacheBehavior) {
            this.props.defaultCacheBehavior(defaultCacheBehavior);
            return this;
        }

        /**
         * The name of the distribution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-distributionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-distributionname</a>
         * @param distributionName The name of the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionName(final java.lang.String distributionName) {
            this.props.distributionName(distributionName);
            return this;
        }

        /**
         * An object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer.
         * <p>
         * The distribution pulls, caches, and serves content from the origin.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-origin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-origin</a>
         * @param origin An object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder origin(final software.amazon.awscdk.IResolvable origin) {
            this.props.origin(origin);
            return this;
        }
        /**
         * An object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer.
         * <p>
         * The distribution pulls, caches, and serves content from the origin.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-origin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-origin</a>
         * @param origin An object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder origin(final software.amazon.awscdk.services.lightsail.CfnDistribution.InputOriginProperty origin) {
            this.props.origin(origin);
            return this;
        }

        /**
         * An array of objects that describe the per-path cache behavior of the distribution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-cachebehaviors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-cachebehaviors</a>
         * @param cacheBehaviors An array of objects that describe the per-path cache behavior of the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheBehaviors(final software.amazon.awscdk.IResolvable cacheBehaviors) {
            this.props.cacheBehaviors(cacheBehaviors);
            return this;
        }
        /**
         * An array of objects that describe the per-path cache behavior of the distribution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-cachebehaviors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-cachebehaviors</a>
         * @param cacheBehaviors An array of objects that describe the per-path cache behavior of the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheBehaviors(final java.util.List<? extends java.lang.Object> cacheBehaviors) {
            this.props.cacheBehaviors(cacheBehaviors);
            return this;
        }

        /**
         * An object that describes the cache behavior settings of the distribution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-cachebehaviorsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-cachebehaviorsettings</a>
         * @param cacheBehaviorSettings An object that describes the cache behavior settings of the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheBehaviorSettings(final software.amazon.awscdk.IResolvable cacheBehaviorSettings) {
            this.props.cacheBehaviorSettings(cacheBehaviorSettings);
            return this;
        }
        /**
         * An object that describes the cache behavior settings of the distribution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-cachebehaviorsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-cachebehaviorsettings</a>
         * @param cacheBehaviorSettings An object that describes the cache behavior settings of the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheBehaviorSettings(final software.amazon.awscdk.services.lightsail.CfnDistribution.CacheSettingsProperty cacheBehaviorSettings) {
            this.props.cacheBehaviorSettings(cacheBehaviorSettings);
            return this;
        }

        /**
         * The name of the SSL/TLS certificate attached to the distribution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-certificatename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-certificatename</a>
         * @param certificateName The name of the SSL/TLS certificate attached to the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateName(final java.lang.String certificateName) {
            this.props.certificateName(certificateName);
            return this;
        }

        /**
         * The IP address type of the distribution.
         * <p>
         * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-ipaddresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-ipaddresstype</a>
         * @param ipAddressType The IP address type of the distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(final java.lang.String ipAddressType) {
            this.props.ipAddressType(ipAddressType);
            return this;
        }

        /**
         * A Boolean value indicating whether the distribution is enabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-isenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-isenabled</a>
         * @param isEnabled A Boolean value indicating whether the distribution is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isEnabled(final java.lang.Boolean isEnabled) {
            this.props.isEnabled(isEnabled);
            return this;
        }
        /**
         * A Boolean value indicating whether the distribution is enabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-isenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-isenabled</a>
         * @param isEnabled A Boolean value indicating whether the distribution is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isEnabled(final software.amazon.awscdk.IResolvable isEnabled) {
            this.props.isEnabled(isEnabled);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lightsail.CfnDistribution}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lightsail.CfnDistribution build() {
            return new software.amazon.awscdk.services.lightsail.CfnDistribution(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
