package software.amazon.awscdk.services.logs;

/**
 * A custom data identifier.
 * <p>
 * Include a custom data identifier name and regular expression in the JSON policy used to define the data protection policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesisfirehose.alpha.*;
 * import software.amazon.awscdk.services.kinesisfirehose.destinations.alpha.*;
 * LogGroup logGroupDestination = LogGroup.Builder.create(this, "LogGroupLambdaAudit")
 *         .logGroupName("auditDestinationForCDK")
 *         .build();
 * Bucket bucket = new Bucket(this, "audit-bucket");
 * S3Bucket s3Destination = new S3Bucket(bucket);
 * DeliveryStream deliveryStream = DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destinations(List.of(s3Destination))
 *         .build();
 * DataProtectionPolicy dataProtectionPolicy = DataProtectionPolicy.Builder.create()
 *         .name("data protection policy")
 *         .description("policy description")
 *         .identifiers(List.of(DataIdentifier.DRIVERSLICENSE_US,  // managed data identifier
 *             new DataIdentifier("EmailAddress"),  // forward compatibility for new managed data identifiers
 *             new CustomDataIdentifier("EmployeeId", "EmployeeId-\\d{9}"))) // custom data identifier
 *         .logGroupAuditDestination(logGroupDestination)
 *         .s3BucketAuditDestination(bucket)
 *         .deliveryStreamNameAuditDestination(deliveryStream.getDeliveryStreamName())
 *         .build();
 * LogGroup.Builder.create(this, "LogGroupLambda")
 *         .logGroupName("cdkIntegLogGroup")
 *         .dataProtectionPolicy(dataProtectionPolicy)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:57.711Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CustomDataIdentifier")
public class CustomDataIdentifier extends software.amazon.awscdk.services.logs.DataIdentifier {

    protected CustomDataIdentifier(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CustomDataIdentifier(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create a custom data identifier.
     * <p>
     * @param name <ul><li>the name of the custom data identifier.</li></ul> This parameter is required.
     * @param regex <ul><li>the regular expresssion to detect and mask log events for.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CustomDataIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull java.lang.String regex) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(regex, "regex is required") });
    }

    /**
     * String representation of a CustomDataIdentifier.
     * <p>
     * @return the name and RegEx of the custom data identifier
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * <ul><li>the name of the custom data identifier.</li></ul>
     * <p>
     * This cannot share the same name as a managed data identifier.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * <ul><li>the regular expresssion to detect and mask log events for.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRegex() {
        return software.amazon.jsii.Kernel.get(this, "regex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
