package software.amazon.awscdk.services.mediaconnect;

/**
 * The AWS::MediaConnect::FlowSource resource is used to add additional sources to an existing flow.
 * <p>
 * Adding an additional source requires Failover to be enabled. When you enable Failover, the additional source must use the same protocol as the existing source. A source is the external video content that includes configuration information (encryption and source type) and a network address. Each flow has at least one source. A standard source comes from a source other than another AWS Elemental MediaConnect flow, such as an on-premises encoder.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * CfnFlowSource cfnFlowSource = CfnFlowSource.Builder.create(this, "MyCfnFlowSource")
 *         .description("description")
 *         .name("name")
 *         // the properties below are optional
 *         .decryption(EncryptionProperty.builder()
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .algorithm("algorithm")
 *                 .constantInitializationVector("constantInitializationVector")
 *                 .deviceId("deviceId")
 *                 .keyType("keyType")
 *                 .region("region")
 *                 .resourceId("resourceId")
 *                 .secretArn("secretArn")
 *                 .url("url")
 *                 .build())
 *         .entitlementArn("entitlementArn")
 *         .flowArn("flowArn")
 *         .gatewayBridgeSource(GatewayBridgeSourceProperty.builder()
 *                 .bridgeArn("bridgeArn")
 *                 // the properties below are optional
 *                 .vpcInterfaceAttachment(VpcInterfaceAttachmentProperty.builder()
 *                         .vpcInterfaceName("vpcInterfaceName")
 *                         .build())
 *                 .build())
 *         .ingestPort(123)
 *         .maxBitrate(123)
 *         .maxLatency(123)
 *         .minLatency(123)
 *         .protocol("protocol")
 *         .senderControlPort(123)
 *         .senderIpAddress("senderIpAddress")
 *         .sourceListenerAddress("sourceListenerAddress")
 *         .sourceListenerPort(123)
 *         .streamId("streamId")
 *         .vpcInterfaceName("vpcInterfaceName")
 *         .whitelistCidr("whitelistCidr")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:57.834Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowSource")
public class CfnFlowSource extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFlowSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlowSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mediaconnect.CfnFlowSource.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFlowSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediaconnect.CfnFlowSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The IP address that the flow listens on for incoming content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIngestIp() {
        return software.amazon.jsii.Kernel.get(this, "attrIngestIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSourceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port that the flow listens on for incoming content.
     * <p>
     * If the protocol of the source is Zixi, the port must be set to 2088.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSourceIngestPort() {
        return software.amazon.jsii.Kernel.get(this, "attrSourceIngestPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A description of the source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", java.util.Objects.requireNonNull(value, "description is required"));
    }

    /**
     * The name of the source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The type of encryption that is used on the content ingested from the source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDecryption() {
        return software.amazon.jsii.Kernel.get(this, "decryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The type of encryption that is used on the content ingested from the source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDecryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "decryption", value);
    }

    /**
     * The type of encryption that is used on the content ingested from the source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDecryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediaconnect.CfnFlowSource.EncryptionProperty value) {
        software.amazon.jsii.Kernel.set(this, "decryption", value);
    }

    /**
     * The ARN of the entitlement that allows you to subscribe to the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEntitlementArn() {
        return software.amazon.jsii.Kernel.get(this, "entitlementArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the entitlement that allows you to subscribe to the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEntitlementArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "entitlementArn", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the flow this source is connected to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFlowArn() {
        return software.amazon.jsii.Kernel.get(this, "flowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the flow this source is connected to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFlowArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "flowArn", value);
    }

    /**
     * The source configuration for cloud flows receiving a stream from a bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGatewayBridgeSource() {
        return software.amazon.jsii.Kernel.get(this, "gatewayBridgeSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The source configuration for cloud flows receiving a stream from a bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGatewayBridgeSource(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "gatewayBridgeSource", value);
    }

    /**
     * The source configuration for cloud flows receiving a stream from a bridge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGatewayBridgeSource(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediaconnect.CfnFlowSource.GatewayBridgeSourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "gatewayBridgeSource", value);
    }

    /**
     * The port that the flow listens on for incoming content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getIngestPort() {
        return software.amazon.jsii.Kernel.get(this, "ingestPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The port that the flow listens on for incoming content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIngestPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "ingestPort", value);
    }

    /**
     * The maximum bitrate for RIST, RTP, and RTP-FEC streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxBitrate() {
        return software.amazon.jsii.Kernel.get(this, "maxBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum bitrate for RIST, RTP, and RTP-FEC streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxBitrate(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxBitrate", value);
    }

    /**
     * The maximum latency in milliseconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxLatency() {
        return software.amazon.jsii.Kernel.get(this, "maxLatency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum latency in milliseconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxLatency(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxLatency", value);
    }

    /**
     * The minimum latency in milliseconds for SRT-based streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinLatency() {
        return software.amazon.jsii.Kernel.get(this, "minLatency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The minimum latency in milliseconds for SRT-based streams.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinLatency(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minLatency", value);
    }

    /**
     * The protocol that the source uses to deliver the content to MediaConnect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
        return software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The protocol that the source uses to deliver the content to MediaConnect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocol(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "protocol", value);
    }

    /**
     * The port that the flow uses to send outbound requests to initiate connection with the sender.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSenderControlPort() {
        return software.amazon.jsii.Kernel.get(this, "senderControlPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The port that the flow uses to send outbound requests to initiate connection with the sender.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSenderControlPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "senderControlPort", value);
    }

    /**
     * The IP address that the flow communicates with to initiate connection with the sender.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSenderIpAddress() {
        return software.amazon.jsii.Kernel.get(this, "senderIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IP address that the flow communicates with to initiate connection with the sender.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSenderIpAddress(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "senderIpAddress", value);
    }

    /**
     * Source IP or domain name for SRT-caller protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceListenerAddress() {
        return software.amazon.jsii.Kernel.get(this, "sourceListenerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Source IP or domain name for SRT-caller protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceListenerAddress(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceListenerAddress", value);
    }

    /**
     * Source port for SRT-caller protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSourceListenerPort() {
        return software.amazon.jsii.Kernel.get(this, "sourceListenerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Source port for SRT-caller protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceListenerPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "sourceListenerPort", value);
    }

    /**
     * The stream ID that you want to use for this transport.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStreamId() {
        return software.amazon.jsii.Kernel.get(this, "streamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The stream ID that you want to use for this transport.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStreamId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "streamId", value);
    }

    /**
     * The name of the VPC interface that you want to send your output to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcInterfaceName() {
        return software.amazon.jsii.Kernel.get(this, "vpcInterfaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the VPC interface that you want to send your output to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcInterfaceName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcInterfaceName", value);
    }

    /**
     * The range of IP addresses that are allowed to contribute content to your source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getWhitelistCidr() {
        return software.amazon.jsii.Kernel.get(this, "whitelistCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The range of IP addresses that are allowed to contribute content to your source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWhitelistCidr(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "whitelistCidr", value);
    }
    /**
     * Information about the encryption of the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * EncryptionProperty encryptionProperty = EncryptionProperty.builder()
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .algorithm("algorithm")
     *         .constantInitializationVector("constantInitializationVector")
     *         .deviceId("deviceId")
     *         .keyType("keyType")
     *         .region("region")
     *         .resourceId("resourceId")
     *         .secretArn("secretArn")
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowSource.EncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the role that you created during setup (when you set up MediaConnect as a trusted entity).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The type of algorithm that is used for static key encryption (such as aes128, aes192, or aes256).
         * <p>
         * If you are using SPEKE or SRT-password encryption, this property must be left blank.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-algorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-algorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlgorithm() {
            return null;
        }

        /**
         * A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content.
         * <p>
         * This parameter is not valid for static key encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-constantinitializationvector">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-constantinitializationvector</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConstantInitializationVector() {
            return null;
        }

        /**
         * The value of one of the devices that you configured with your digital rights management (DRM) platform key provider.
         * <p>
         * This parameter is required for SPEKE encryption and is not valid for static key encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-deviceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-deviceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeviceId() {
            return null;
        }

        /**
         * The type of key that is used for the encryption.
         * <p>
         * If you don't specify a <code>keyType</code> value, the service uses the default setting ( <code>static-key</code> ). Valid key types are: <code>static-key</code> , <code>speke</code> , and <code>srt-password</code> .
         * <p>
         * Default: - "static-key"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-keytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-keytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyType() {
            return null;
        }

        /**
         * The AWS Region that the API Gateway proxy endpoint was created in.
         * <p>
         * This parameter is required for SPEKE encryption and is not valid for static key encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * An identifier for the content.
         * <p>
         * The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-resourceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceId() {
            return null;
        }

        /**
         * The ARN of the secret that you created in AWS Secrets Manager to store the encryption key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretArn() {
            return null;
        }

        /**
         * The URL from the API Gateway proxy that you set up to talk to your key server.
         * <p>
         * This parameter is required for SPEKE encryption and is not valid for static key encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html#cfn-mediaconnect-flowsource-encryption-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionProperty> {
            java.lang.String roleArn;
            java.lang.String algorithm;
            java.lang.String constantInitializationVector;
            java.lang.String deviceId;
            java.lang.String keyType;
            java.lang.String region;
            java.lang.String resourceId;
            java.lang.String secretArn;
            java.lang.String url;

            /**
             * Sets the value of {@link EncryptionProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the role that you created during setup (when you set up MediaConnect as a trusted entity). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getAlgorithm}
             * @param algorithm The type of algorithm that is used for static key encryption (such as aes128, aes192, or aes256).
             *                  If you are using SPEKE or SRT-password encryption, this property must be left blank.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithm(java.lang.String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getConstantInitializationVector}
             * @param constantInitializationVector A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content.
             *                                     This parameter is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constantInitializationVector(java.lang.String constantInitializationVector) {
                this.constantInitializationVector = constantInitializationVector;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getDeviceId}
             * @param deviceId The value of one of the devices that you configured with your digital rights management (DRM) platform key provider.
             *                 This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceId(java.lang.String deviceId) {
                this.deviceId = deviceId;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getKeyType}
             * @param keyType The type of key that is used for the encryption.
             *                If you don't specify a <code>keyType</code> value, the service uses the default setting ( <code>static-key</code> ). Valid key types are: <code>static-key</code> , <code>speke</code> , and <code>srt-password</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyType(java.lang.String keyType) {
                this.keyType = keyType;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getRegion}
             * @param region The AWS Region that the API Gateway proxy endpoint was created in.
             *               This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getResourceId}
             * @param resourceId An identifier for the content.
             *                   The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(java.lang.String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getSecretArn}
             * @param secretArn The ARN of the secret that you created in AWS Secrets Manager to store the encryption key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getUrl}
             * @param url The URL from the API Gateway proxy that you set up to talk to your key server.
             *            This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionProperty {
            private final java.lang.String roleArn;
            private final java.lang.String algorithm;
            private final java.lang.String constantInitializationVector;
            private final java.lang.String deviceId;
            private final java.lang.String keyType;
            private final java.lang.String region;
            private final java.lang.String resourceId;
            private final java.lang.String secretArn;
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.algorithm = software.amazon.jsii.Kernel.get(this, "algorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.constantInitializationVector = software.amazon.jsii.Kernel.get(this, "constantInitializationVector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deviceId = software.amazon.jsii.Kernel.get(this, "deviceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyType = software.amazon.jsii.Kernel.get(this, "keyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.algorithm = builder.algorithm;
                this.constantInitializationVector = builder.constantInitializationVector;
                this.deviceId = builder.deviceId;
                this.keyType = builder.keyType;
                this.region = builder.region;
                this.resourceId = builder.resourceId;
                this.secretArn = builder.secretArn;
                this.url = builder.url;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getAlgorithm() {
                return this.algorithm;
            }

            @Override
            public final java.lang.String getConstantInitializationVector() {
                return this.constantInitializationVector;
            }

            @Override
            public final java.lang.String getDeviceId() {
                return this.deviceId;
            }

            @Override
            public final java.lang.String getKeyType() {
                return this.keyType;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getResourceId() {
                return this.resourceId;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getAlgorithm() != null) {
                    data.set("algorithm", om.valueToTree(this.getAlgorithm()));
                }
                if (this.getConstantInitializationVector() != null) {
                    data.set("constantInitializationVector", om.valueToTree(this.getConstantInitializationVector()));
                }
                if (this.getDeviceId() != null) {
                    data.set("deviceId", om.valueToTree(this.getDeviceId()));
                }
                if (this.getKeyType() != null) {
                    data.set("keyType", om.valueToTree(this.getKeyType()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }
                if (this.getResourceId() != null) {
                    data.set("resourceId", om.valueToTree(this.getResourceId()));
                }
                if (this.getSecretArn() != null) {
                    data.set("secretArn", om.valueToTree(this.getSecretArn()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlowSource.EncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionProperty.Jsii$Proxy that = (EncryptionProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (this.algorithm != null ? !this.algorithm.equals(that.algorithm) : that.algorithm != null) return false;
                if (this.constantInitializationVector != null ? !this.constantInitializationVector.equals(that.constantInitializationVector) : that.constantInitializationVector != null) return false;
                if (this.deviceId != null ? !this.deviceId.equals(that.deviceId) : that.deviceId != null) return false;
                if (this.keyType != null ? !this.keyType.equals(that.keyType) : that.keyType != null) return false;
                if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
                if (this.resourceId != null ? !this.resourceId.equals(that.resourceId) : that.resourceId != null) return false;
                if (this.secretArn != null ? !this.secretArn.equals(that.secretArn) : that.secretArn != null) return false;
                return this.url != null ? this.url.equals(that.url) : that.url == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
                result = 31 * result + (this.constantInitializationVector != null ? this.constantInitializationVector.hashCode() : 0);
                result = 31 * result + (this.deviceId != null ? this.deviceId.hashCode() : 0);
                result = 31 * result + (this.keyType != null ? this.keyType.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                result = 31 * result + (this.resourceId != null ? this.resourceId.hashCode() : 0);
                result = 31 * result + (this.secretArn != null ? this.secretArn.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The source configuration for cloud flows receiving a stream from a bridge.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * GatewayBridgeSourceProperty gatewayBridgeSourceProperty = GatewayBridgeSourceProperty.builder()
     *         .bridgeArn("bridgeArn")
     *         // the properties below are optional
     *         .vpcInterfaceAttachment(VpcInterfaceAttachmentProperty.builder()
     *                 .vpcInterfaceName("vpcInterfaceName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-gatewaybridgesource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-gatewaybridgesource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowSource.GatewayBridgeSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(GatewayBridgeSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GatewayBridgeSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the bridge feeding this flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-gatewaybridgesource.html#cfn-mediaconnect-flowsource-gatewaybridgesource-bridgearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-gatewaybridgesource.html#cfn-mediaconnect-flowsource-gatewaybridgesource-bridgearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBridgeArn();

        /**
         * The name of the VPC interface attachment to use for this bridge source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-gatewaybridgesource.html#cfn-mediaconnect-flowsource-gatewaybridgesource-vpcinterfaceattachment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-gatewaybridgesource.html#cfn-mediaconnect-flowsource-gatewaybridgesource-vpcinterfaceattachment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcInterfaceAttachment() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GatewayBridgeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GatewayBridgeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GatewayBridgeSourceProperty> {
            java.lang.String bridgeArn;
            java.lang.Object vpcInterfaceAttachment;

            /**
             * Sets the value of {@link GatewayBridgeSourceProperty#getBridgeArn}
             * @param bridgeArn The ARN of the bridge feeding this flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bridgeArn(java.lang.String bridgeArn) {
                this.bridgeArn = bridgeArn;
                return this;
            }

            /**
             * Sets the value of {@link GatewayBridgeSourceProperty#getVpcInterfaceAttachment}
             * @param vpcInterfaceAttachment The name of the VPC interface attachment to use for this bridge source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcInterfaceAttachment(software.amazon.awscdk.IResolvable vpcInterfaceAttachment) {
                this.vpcInterfaceAttachment = vpcInterfaceAttachment;
                return this;
            }

            /**
             * Sets the value of {@link GatewayBridgeSourceProperty#getVpcInterfaceAttachment}
             * @param vpcInterfaceAttachment The name of the VPC interface attachment to use for this bridge source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcInterfaceAttachment(software.amazon.awscdk.services.mediaconnect.CfnFlowSource.VpcInterfaceAttachmentProperty vpcInterfaceAttachment) {
                this.vpcInterfaceAttachment = vpcInterfaceAttachment;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GatewayBridgeSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GatewayBridgeSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GatewayBridgeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayBridgeSourceProperty {
            private final java.lang.String bridgeArn;
            private final java.lang.Object vpcInterfaceAttachment;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bridgeArn = software.amazon.jsii.Kernel.get(this, "bridgeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcInterfaceAttachment = software.amazon.jsii.Kernel.get(this, "vpcInterfaceAttachment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bridgeArn = java.util.Objects.requireNonNull(builder.bridgeArn, "bridgeArn is required");
                this.vpcInterfaceAttachment = builder.vpcInterfaceAttachment;
            }

            @Override
            public final java.lang.String getBridgeArn() {
                return this.bridgeArn;
            }

            @Override
            public final java.lang.Object getVpcInterfaceAttachment() {
                return this.vpcInterfaceAttachment;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bridgeArn", om.valueToTree(this.getBridgeArn()));
                if (this.getVpcInterfaceAttachment() != null) {
                    data.set("vpcInterfaceAttachment", om.valueToTree(this.getVpcInterfaceAttachment()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlowSource.GatewayBridgeSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GatewayBridgeSourceProperty.Jsii$Proxy that = (GatewayBridgeSourceProperty.Jsii$Proxy) o;

                if (!bridgeArn.equals(that.bridgeArn)) return false;
                return this.vpcInterfaceAttachment != null ? this.vpcInterfaceAttachment.equals(that.vpcInterfaceAttachment) : that.vpcInterfaceAttachment == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bridgeArn.hashCode();
                result = 31 * result + (this.vpcInterfaceAttachment != null ? this.vpcInterfaceAttachment.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The VPC interface that you want to send your output to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * VpcInterfaceAttachmentProperty vpcInterfaceAttachmentProperty = VpcInterfaceAttachmentProperty.builder()
     *         .vpcInterfaceName("vpcInterfaceName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-vpcinterfaceattachment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-vpcinterfaceattachment.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowSource.VpcInterfaceAttachmentProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcInterfaceAttachmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcInterfaceAttachmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the VPC interface that you want to send your output to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-vpcinterfaceattachment.html#cfn-mediaconnect-flowsource-vpcinterfaceattachment-vpcinterfacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-vpcinterfaceattachment.html#cfn-mediaconnect-flowsource-vpcinterfaceattachment-vpcinterfacename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcInterfaceName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpcInterfaceAttachmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcInterfaceAttachmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcInterfaceAttachmentProperty> {
            java.lang.String vpcInterfaceName;

            /**
             * Sets the value of {@link VpcInterfaceAttachmentProperty#getVpcInterfaceName}
             * @param vpcInterfaceName The name of the VPC interface that you want to send your output to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcInterfaceName(java.lang.String vpcInterfaceName) {
                this.vpcInterfaceName = vpcInterfaceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcInterfaceAttachmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcInterfaceAttachmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcInterfaceAttachmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcInterfaceAttachmentProperty {
            private final java.lang.String vpcInterfaceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.vpcInterfaceName = software.amazon.jsii.Kernel.get(this, "vpcInterfaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.vpcInterfaceName = builder.vpcInterfaceName;
            }

            @Override
            public final java.lang.String getVpcInterfaceName() {
                return this.vpcInterfaceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVpcInterfaceName() != null) {
                    data.set("vpcInterfaceName", om.valueToTree(this.getVpcInterfaceName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlowSource.VpcInterfaceAttachmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcInterfaceAttachmentProperty.Jsii$Proxy that = (VpcInterfaceAttachmentProperty.Jsii$Proxy) o;

                return this.vpcInterfaceName != null ? this.vpcInterfaceName.equals(that.vpcInterfaceName) : that.vpcInterfaceName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.vpcInterfaceName != null ? this.vpcInterfaceName.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mediaconnect.CfnFlowSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mediaconnect.CfnFlowSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mediaconnect.CfnFlowSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mediaconnect.CfnFlowSourceProps.Builder();
        }

        /**
         * A description of the source.
         * <p>
         * This description is not visible outside of the current AWS account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-description</a>
         * @param description A description of the source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-name</a>
         * @param name The name of the source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The type of encryption that is used on the content ingested from the source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-decryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-decryption</a>
         * @param decryption The type of encryption that is used on the content ingested from the source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder decryption(final software.amazon.awscdk.IResolvable decryption) {
            this.props.decryption(decryption);
            return this;
        }
        /**
         * The type of encryption that is used on the content ingested from the source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-decryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-decryption</a>
         * @param decryption The type of encryption that is used on the content ingested from the source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder decryption(final software.amazon.awscdk.services.mediaconnect.CfnFlowSource.EncryptionProperty decryption) {
            this.props.decryption(decryption);
            return this;
        }

        /**
         * The ARN of the entitlement that allows you to subscribe to the flow.
         * <p>
         * The entitlement is set by the content originator, and the ARN is generated as part of the originator's flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-entitlementarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-entitlementarn</a>
         * @param entitlementArn The ARN of the entitlement that allows you to subscribe to the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entitlementArn(final java.lang.String entitlementArn) {
            this.props.entitlementArn(entitlementArn);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the flow this source is connected to.
         * <p>
         * The flow must have Failover enabled to add an additional source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-flowarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-flowarn</a>
         * @param flowArn The Amazon Resource Name (ARN) of the flow this source is connected to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowArn(final java.lang.String flowArn) {
            this.props.flowArn(flowArn);
            return this;
        }

        /**
         * The source configuration for cloud flows receiving a stream from a bridge.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-gatewaybridgesource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-gatewaybridgesource</a>
         * @param gatewayBridgeSource The source configuration for cloud flows receiving a stream from a bridge. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayBridgeSource(final software.amazon.awscdk.IResolvable gatewayBridgeSource) {
            this.props.gatewayBridgeSource(gatewayBridgeSource);
            return this;
        }
        /**
         * The source configuration for cloud flows receiving a stream from a bridge.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-gatewaybridgesource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-gatewaybridgesource</a>
         * @param gatewayBridgeSource The source configuration for cloud flows receiving a stream from a bridge. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayBridgeSource(final software.amazon.awscdk.services.mediaconnect.CfnFlowSource.GatewayBridgeSourceProperty gatewayBridgeSource) {
            this.props.gatewayBridgeSource(gatewayBridgeSource);
            return this;
        }

        /**
         * The port that the flow listens on for incoming content.
         * <p>
         * If the protocol of the source is Zixi, the port must be set to 2088.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-ingestport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-ingestport</a>
         * @param ingestPort The port that the flow listens on for incoming content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingestPort(final java.lang.Number ingestPort) {
            this.props.ingestPort(ingestPort);
            return this;
        }

        /**
         * The maximum bitrate for RIST, RTP, and RTP-FEC streams.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxbitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxbitrate</a>
         * @param maxBitrate The maximum bitrate for RIST, RTP, and RTP-FEC streams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBitrate(final java.lang.Number maxBitrate) {
            this.props.maxBitrate(maxBitrate);
            return this;
        }

        /**
         * The maximum latency in milliseconds.
         * <p>
         * This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.
         * <p>
         * Default: - 2000
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxlatency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-maxlatency</a>
         * @param maxLatency The maximum latency in milliseconds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxLatency(final java.lang.Number maxLatency) {
            this.props.maxLatency(maxLatency);
            return this;
        }

        /**
         * The minimum latency in milliseconds for SRT-based streams.
         * <p>
         * In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
         * <p>
         * Default: - 2000
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-minlatency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-minlatency</a>
         * @param minLatency The minimum latency in milliseconds for SRT-based streams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minLatency(final java.lang.Number minLatency) {
            this.props.minLatency(minLatency);
            return this;
        }

        /**
         * The protocol that the source uses to deliver the content to MediaConnect.
         * <p>
         * Adding additional sources to an existing flow requires Failover to be enabled. When you enable Failover, the additional source must use the same protocol as the existing source. Only the following protocols support failover: Zixi-push, RTP-FEC, RTP, RIST and SRT protocols.
         * <p>
         * If you use failover with SRT caller or listener, the <code>FailoverMode</code> property must be set to <code>FAILOVER</code> . The <code>FailoverMode</code> property is found in the <code>FailoverConfig</code> resource of the same flow ARN you used for the source's <code>FlowArn</code> property. SRT caller/listener does not support merge mode failover.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-protocol</a>
         * @param protocol The protocol that the source uses to deliver the content to MediaConnect. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final java.lang.String protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * The port that the flow uses to send outbound requests to initiate connection with the sender.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-sendercontrolport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-sendercontrolport</a>
         * @param senderControlPort The port that the flow uses to send outbound requests to initiate connection with the sender. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder senderControlPort(final java.lang.Number senderControlPort) {
            this.props.senderControlPort(senderControlPort);
            return this;
        }

        /**
         * The IP address that the flow communicates with to initiate connection with the sender.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-senderipaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-senderipaddress</a>
         * @param senderIpAddress The IP address that the flow communicates with to initiate connection with the sender. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder senderIpAddress(final java.lang.String senderIpAddress) {
            this.props.senderIpAddress(senderIpAddress);
            return this;
        }

        /**
         * Source IP or domain name for SRT-caller protocol.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-sourcelisteneraddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-sourcelisteneraddress</a>
         * @param sourceListenerAddress Source IP or domain name for SRT-caller protocol. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceListenerAddress(final java.lang.String sourceListenerAddress) {
            this.props.sourceListenerAddress(sourceListenerAddress);
            return this;
        }

        /**
         * Source port for SRT-caller protocol.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-sourcelistenerport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-sourcelistenerport</a>
         * @param sourceListenerPort Source port for SRT-caller protocol. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceListenerPort(final java.lang.Number sourceListenerPort) {
            this.props.sourceListenerPort(sourceListenerPort);
            return this;
        }

        /**
         * The stream ID that you want to use for this transport.
         * <p>
         * This parameter applies only to Zixi and SRT caller-based streams.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-streamid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-streamid</a>
         * @param streamId The stream ID that you want to use for this transport. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamId(final java.lang.String streamId) {
            this.props.streamId(streamId);
            return this;
        }

        /**
         * The name of the VPC interface that you want to send your output to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-vpcinterfacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-vpcinterfacename</a>
         * @param vpcInterfaceName The name of the VPC interface that you want to send your output to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcInterfaceName(final java.lang.String vpcInterfaceName) {
            this.props.vpcInterfaceName(vpcInterfaceName);
            return this;
        }

        /**
         * The range of IP addresses that are allowed to contribute content to your source.
         * <p>
         * Format the IP addresses as a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-whitelistcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html#cfn-mediaconnect-flowsource-whitelistcidr</a>
         * @param whitelistCidr The range of IP addresses that are allowed to contribute content to your source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder whitelistCidr(final java.lang.String whitelistCidr) {
            this.props.whitelistCidr(whitelistCidr);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.mediaconnect.CfnFlowSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mediaconnect.CfnFlowSource build() {
            return new software.amazon.awscdk.services.mediaconnect.CfnFlowSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
