package software.amazon.awscdk.services.nimblestudio;

/**
 * Properties for defining a <code>CfnStudio</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.nimblestudio.*;
 * CfnStudioProps cfnStudioProps = CfnStudioProps.builder()
 *         .adminRoleArn("adminRoleArn")
 *         .displayName("displayName")
 *         .studioName("studioName")
 *         .userRoleArn("userRoleArn")
 *         // the properties below are optional
 *         .studioEncryptionConfiguration(StudioEncryptionConfigurationProperty.builder()
 *                 .keyType("keyType")
 *                 // the properties below are optional
 *                 .keyArn("keyArn")
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:21:58.357Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_nimblestudio.CfnStudioProps")
@software.amazon.jsii.Jsii.Proxy(CfnStudioProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStudioProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IAM role that studio admins assume when logging in to the Nimble Studio portal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-adminrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-adminrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAdminRoleArn();

    /**
     * A friendly name for the studio.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDisplayName();

    /**
     * The name of the studio, as included in the URL when accessing it in the Nimble Studio portal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-studioname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-studioname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStudioName();

    /**
     * The IAM role that studio users assume when logging in to the Nimble Studio portal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-userrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-userrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserRoleArn();

    /**
     * Configuration of the encryption method that is used for the studio.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-studioencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-studioencryptionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStudioEncryptionConfiguration() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studio.html#cfn-nimblestudio-studio-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStudioProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStudioProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStudioProps> {
        java.lang.String adminRoleArn;
        java.lang.String displayName;
        java.lang.String studioName;
        java.lang.String userRoleArn;
        java.lang.Object studioEncryptionConfiguration;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnStudioProps#getAdminRoleArn}
         * @param adminRoleArn The IAM role that studio admins assume when logging in to the Nimble Studio portal. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminRoleArn(java.lang.String adminRoleArn) {
            this.adminRoleArn = adminRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getDisplayName}
         * @param displayName A friendly name for the studio. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getStudioName}
         * @param studioName The name of the studio, as included in the URL when accessing it in the Nimble Studio portal. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioName(java.lang.String studioName) {
            this.studioName = studioName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getUserRoleArn}
         * @param userRoleArn The IAM role that studio users assume when logging in to the Nimble Studio portal. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userRoleArn(java.lang.String userRoleArn) {
            this.userRoleArn = userRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getStudioEncryptionConfiguration}
         * @param studioEncryptionConfiguration Configuration of the encryption method that is used for the studio.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioEncryptionConfiguration(software.amazon.awscdk.IResolvable studioEncryptionConfiguration) {
            this.studioEncryptionConfiguration = studioEncryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getStudioEncryptionConfiguration}
         * @param studioEncryptionConfiguration Configuration of the encryption method that is used for the studio.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioEncryptionConfiguration(software.amazon.awscdk.services.nimblestudio.CfnStudio.StudioEncryptionConfigurationProperty studioEncryptionConfiguration) {
            this.studioEncryptionConfiguration = studioEncryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStudioProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStudioProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStudioProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStudioProps {
        private final java.lang.String adminRoleArn;
        private final java.lang.String displayName;
        private final java.lang.String studioName;
        private final java.lang.String userRoleArn;
        private final java.lang.Object studioEncryptionConfiguration;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.adminRoleArn = software.amazon.jsii.Kernel.get(this, "adminRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.studioName = software.amazon.jsii.Kernel.get(this, "studioName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userRoleArn = software.amazon.jsii.Kernel.get(this, "userRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.studioEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "studioEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.adminRoleArn = java.util.Objects.requireNonNull(builder.adminRoleArn, "adminRoleArn is required");
            this.displayName = java.util.Objects.requireNonNull(builder.displayName, "displayName is required");
            this.studioName = java.util.Objects.requireNonNull(builder.studioName, "studioName is required");
            this.userRoleArn = java.util.Objects.requireNonNull(builder.userRoleArn, "userRoleArn is required");
            this.studioEncryptionConfiguration = builder.studioEncryptionConfiguration;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getAdminRoleArn() {
            return this.adminRoleArn;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getStudioName() {
            return this.studioName;
        }

        @Override
        public final java.lang.String getUserRoleArn() {
            return this.userRoleArn;
        }

        @Override
        public final java.lang.Object getStudioEncryptionConfiguration() {
            return this.studioEncryptionConfiguration;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("adminRoleArn", om.valueToTree(this.getAdminRoleArn()));
            data.set("displayName", om.valueToTree(this.getDisplayName()));
            data.set("studioName", om.valueToTree(this.getStudioName()));
            data.set("userRoleArn", om.valueToTree(this.getUserRoleArn()));
            if (this.getStudioEncryptionConfiguration() != null) {
                data.set("studioEncryptionConfiguration", om.valueToTree(this.getStudioEncryptionConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_nimblestudio.CfnStudioProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStudioProps.Jsii$Proxy that = (CfnStudioProps.Jsii$Proxy) o;

            if (!adminRoleArn.equals(that.adminRoleArn)) return false;
            if (!displayName.equals(that.displayName)) return false;
            if (!studioName.equals(that.studioName)) return false;
            if (!userRoleArn.equals(that.userRoleArn)) return false;
            if (this.studioEncryptionConfiguration != null ? !this.studioEncryptionConfiguration.equals(that.studioEncryptionConfiguration) : that.studioEncryptionConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.adminRoleArn.hashCode();
            result = 31 * result + (this.displayName.hashCode());
            result = 31 * result + (this.studioName.hashCode());
            result = 31 * result + (this.userRoleArn.hashCode());
            result = 31 * result + (this.studioEncryptionConfiguration != null ? this.studioEncryptionConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
