package software.amazon.awscdk.services.rds;

/**
 * Client password authentication type used by a proxy to log in as a specific database user.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.auroraMysql(AuroraMysqlClusterEngineProps.builder()
 *                 .version(AuroraMysqlEngineVersion.VER_3_03_0)
 *                 .build()))
 *         .writer(ClusterInstance.provisioned("writer"))
 *         .vpc(vpc)
 *         .build();
 * DatabaseProxy proxy = DatabaseProxy.Builder.create(this, "Proxy")
 *         .proxyTarget(ProxyTarget.fromCluster(cluster))
 *         .secrets(List.of(cluster.getSecret()))
 *         .vpc(vpc)
 *         .clientPasswordAuthType(ClientPasswordAuthType.MYSQL_NATIVE_PASSWORD)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:22:00.621Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.ClientPasswordAuthType")
public enum ClientPasswordAuthType {
    /**
     * MySQL Native Password client authentication type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MYSQL_NATIVE_PASSWORD,
    /**
     * SCRAM SHA 256 client authentication type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    POSTGRES_SCRAM_SHA_256,
    /**
     * PostgreSQL MD5 client authentication type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    POSTGRES_MD5,
    /**
     * SQL Server Authentication client authentication type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SQL_SERVER_AUTHENTICATION,
}
