package software.amazon.awscdk.services.rds;

/**
 * Represents Database Engine features.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * ClusterEngineFeatures clusterEngineFeatures = ClusterEngineFeatures.builder()
 *         .s3Export("s3Export")
 *         .s3Import("s3Import")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:22:00.622Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.ClusterEngineFeatures")
@software.amazon.jsii.Jsii.Proxy(ClusterEngineFeatures.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ClusterEngineFeatures extends software.amazon.jsii.JsiiSerializable {

    /**
     * Feature name for the DB instance that the IAM role to export to S3 bucket is to be associated with.
     * <p>
     * Default: - no s3Export feature name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getS3Export() {
        return null;
    }

    /**
     * Feature name for the DB instance that the IAM role to access the S3 bucket for import is to be associated with.
     * <p>
     * Default: - no s3Import feature name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getS3Import() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClusterEngineFeatures}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClusterEngineFeatures}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ClusterEngineFeatures> {
        java.lang.String s3Export;
        java.lang.String s3Import;

        /**
         * Sets the value of {@link ClusterEngineFeatures#getS3Export}
         * @param s3Export Feature name for the DB instance that the IAM role to export to S3 bucket is to be associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Export(java.lang.String s3Export) {
            this.s3Export = s3Export;
            return this;
        }

        /**
         * Sets the value of {@link ClusterEngineFeatures#getS3Import}
         * @param s3Import Feature name for the DB instance that the IAM role to access the S3 bucket for import is to be associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Import(java.lang.String s3Import) {
            this.s3Import = s3Import;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClusterEngineFeatures}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ClusterEngineFeatures build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClusterEngineFeatures}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterEngineFeatures {
        private final java.lang.String s3Export;
        private final java.lang.String s3Import;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.s3Export = software.amazon.jsii.Kernel.get(this, "s3Export", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3Import = software.amazon.jsii.Kernel.get(this, "s3Import", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.s3Export = builder.s3Export;
            this.s3Import = builder.s3Import;
        }

        @Override
        public final java.lang.String getS3Export() {
            return this.s3Export;
        }

        @Override
        public final java.lang.String getS3Import() {
            return this.s3Import;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getS3Export() != null) {
                data.set("s3Export", om.valueToTree(this.getS3Export()));
            }
            if (this.getS3Import() != null) {
                data.set("s3Import", om.valueToTree(this.getS3Import()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.ClusterEngineFeatures"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClusterEngineFeatures.Jsii$Proxy that = (ClusterEngineFeatures.Jsii$Proxy) o;

            if (this.s3Export != null ? !this.s3Export.equals(that.s3Export) : that.s3Export != null) return false;
            return this.s3Import != null ? this.s3Import.equals(that.s3Import) : that.s3Import == null;
        }

        @Override
        public final int hashCode() {
            int result = this.s3Export != null ? this.s3Export.hashCode() : 0;
            result = 31 * result + (this.s3Import != null ? this.s3Import.hashCode() : 0);
            return result;
        }
    }
}
