package software.amazon.awscdk.services.rds;

/**
 * The versions for the PostgreSQL instance engines (those returned by <code>DatabaseInstanceEngine.postgres</code>).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * IInstanceEngine engine = DatabaseInstanceEngine.postgres(PostgresInstanceEngineProps.builder().version(PostgresEngineVersion.VER_15_2).build());
 * Key myKey = new Key(this, "MyKey");
 * DatabaseInstance.Builder.create(this, "InstanceWithCustomizedSecret")
 *         .engine(engine)
 *         .vpc(vpc)
 *         .credentials(Credentials.fromGeneratedSecret("postgres", CredentialsBaseOptions.builder()
 *                 .secretName("my-cool-name")
 *                 .encryptionKey(myKey)
 *                 .excludeCharacters("!&amp;*^#&#64;()")
 *                 .replicaRegions(List.of(ReplicaRegion.builder().region("eu-west-1").build(), ReplicaRegion.builder().region("eu-west-2").build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:22:00.741Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.PostgresEngineVersion")
public class PostgresEngineVersion extends software.amazon.jsii.JsiiObject {

    protected PostgresEngineVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PostgresEngineVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        VER_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_22 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_22", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_23 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_23", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_10_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_10_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_22 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_22", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_11_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_11_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_12_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_12_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_13_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_13_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_14_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_14_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_15_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_15_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_15_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_15_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_15_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_15_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_15_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_15_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_15_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_15_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_16_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_16_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_16_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_16_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
        VER_9_6_24 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "VER_9_6_24", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class));
    }

    /**
     * Create a new PostgresEngineVersion with an arbitrary version.
     * <p>
     * @param postgresFullVersion the full version string, for example "13.11". This parameter is required.
     * @param postgresMajorVersion the major version of the engine, for example "13". This parameter is required.
     * @param postgresFeatures
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.PostgresEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String postgresFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String postgresMajorVersion, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.PostgresEngineFeatures postgresFeatures) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(postgresFullVersion, "postgresFullVersion is required"), java.util.Objects.requireNonNull(postgresMajorVersion, "postgresMajorVersion is required"), postgresFeatures });
    }

    /**
     * Create a new PostgresEngineVersion with an arbitrary version.
     * <p>
     * @param postgresFullVersion the full version string, for example "13.11". This parameter is required.
     * @param postgresMajorVersion the major version of the engine, for example "13". This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.PostgresEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String postgresFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String postgresMajorVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.PostgresEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.PostgresEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(postgresFullVersion, "postgresFullVersion is required"), java.util.Objects.requireNonNull(postgresMajorVersion, "postgresMajorVersion is required") });
    }

    /**
     * (deprecated) Version "10" (only a major version, without a specific minor version).
     * <p>
     * @deprecated PostgreSQL 10 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10;

    /**
     * (deprecated) Version "10.1".
     * <p>
     * @deprecated PostgreSQL 10 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_1;

    /**
     * (deprecated) Version "10.10".
     * <p>
     * @deprecated PostgreSQL 10.10 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_10;

    /**
     * (deprecated) Version "10.11".
     * <p>
     * @deprecated PostgreSQL 10.11 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_11;

    /**
     * (deprecated) Version "10.12".
     * <p>
     * @deprecated PostgreSQL 10.12 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_12;

    /**
     * (deprecated) Version "10.13".
     * <p>
     * @deprecated PostgreSQL 10.13 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_13;

    /**
     * (deprecated) Version "10.14".
     * <p>
     * @deprecated PostgreSQL 10.14 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_14;

    /**
     * (deprecated) Version "10.15".
     * <p>
     * @deprecated PostgreSQL 10.15 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_15;

    /**
     * (deprecated) Version "10.16".
     * <p>
     * @deprecated PostgreSQL 10.16 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_16;

    /**
     * (deprecated) Version "10.17".
     * <p>
     * @deprecated PostgreSQL 10.17 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_17;

    /**
     * (deprecated) Version "10.18".
     * <p>
     * @deprecated PostgreSQL 10.18 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_18;

    /**
     * (deprecated) Version "10.19".
     * <p>
     * @deprecated PostgreSQL 10.19 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_19;

    /**
     * (deprecated) Version "10.20".
     * <p>
     * @deprecated PostgreSQL 10.20 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_20;

    /**
     * (deprecated) Version "10.21".
     * <p>
     * @deprecated PostgreSQL 10.21 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_21;

    /**
     * (deprecated) Version "10.22".
     * <p>
     * @deprecated PostgreSQL 10.22 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_22;

    /**
     * (deprecated) Version "10.23".
     * <p>
     * @deprecated PostgreSQL 10.23 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_23;

    /**
     * (deprecated) Version "10.3".
     * <p>
     * @deprecated PostgreSQL 10.3 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_3;

    /**
     * (deprecated) Version "10.4".
     * <p>
     * @deprecated PostgreSQL 10.4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_4;

    /**
     * (deprecated) Version "10.5".
     * <p>
     * @deprecated PostgreSQL 10.5 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_5;

    /**
     * (deprecated) Version "10.6".
     * <p>
     * @deprecated PostgreSQL 10.6 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_6;

    /**
     * (deprecated) Version "10.7".
     * <p>
     * @deprecated PostgreSQL 10.7 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_7;

    /**
     * (deprecated) Version "10.9".
     * <p>
     * @deprecated PostgreSQL 10.9 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_10_9;

    /**
     * Version "11" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11;

    /**
     * (deprecated) Version "11.1".
     * <p>
     * @deprecated PostgreSQL 11.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_1;

    /**
     * (deprecated) Version "11.10".
     * <p>
     * @deprecated PostgreSQL 11.10 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_10;

    /**
     * (deprecated) Version "11.11".
     * <p>
     * @deprecated PostgreSQL 11.11 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_11;

    /**
     * (deprecated) Version "11.12".
     * <p>
     * @deprecated PostgreSQL 11.12 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_12;

    /**
     * (deprecated) Version "11.13".
     * <p>
     * @deprecated PostgreSQL 11.13 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_13;

    /**
     * (deprecated) Version "11.14".
     * <p>
     * @deprecated PostgreSQL 11.14 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_14;

    /**
     * (deprecated) Version "11.15".
     * <p>
     * @deprecated PostgreSQL 11.15 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_15;

    /**
     * (deprecated) Version "11.16".
     * <p>
     * @deprecated PostgreSQL 11.16 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_16;

    /**
     * Version "11.17".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_17;

    /**
     * Version "11.18".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_18;

    /**
     * Version "11.19".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_19;

    /**
     * (deprecated) Version "11.2".
     * <p>
     * @deprecated PostgreSQL 11.2 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_2;

    /**
     * Version "11.20".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_20;

    /**
     * Version "11.21".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_21;

    /**
     * Version "11.22".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_22;

    /**
     * (deprecated) Version "11.4".
     * <p>
     * @deprecated PostgreSQL 11.4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_4;

    /**
     * (deprecated) Version "11.5".
     * <p>
     * @deprecated PostgreSQL 11.5 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_5;

    /**
     * (deprecated) Version "11.6".
     * <p>
     * @deprecated PostgreSQL 11.6 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_6;

    /**
     * (deprecated) Version "11.7".
     * <p>
     * @deprecated PostgreSQL 11.7 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_7;

    /**
     * (deprecated) Version "11.8".
     * <p>
     * @deprecated PostgreSQL 11.8 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_8;

    /**
     * (deprecated) Version "11.9".
     * <p>
     * @deprecated PostgreSQL 11.9 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_11_9;

    /**
     * Version "12" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12;

    /**
     * (deprecated) Version "12.10".
     * <p>
     * @deprecated PostgreSQL 12.10 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_10;

    /**
     * (deprecated) Version "12.11".
     * <p>
     * @deprecated PostgreSQL 12.11 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_11;

    /**
     * Version "12.12".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_12;

    /**
     * Version "12.13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_13;

    /**
     * Version "12.14".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_14;

    /**
     * Version "12.15".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_15;

    /**
     * Version "12.16".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_16;

    /**
     * Version "12.17".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_17;

    /**
     * Version "12.18".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_18;

    /**
     * (deprecated) Version "12.2".
     * <p>
     * @deprecated PostgreSQL 12.2 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_2;

    /**
     * (deprecated) Version "12.3".
     * <p>
     * @deprecated PostgreSQL 12.3 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_3;

    /**
     * (deprecated) Version "12.4".
     * <p>
     * @deprecated PostgreSQL 12.4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_4;

    /**
     * (deprecated) Version "12.5".
     * <p>
     * @deprecated PostgreSQL 12.5 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_5;

    /**
     * (deprecated) Version "12.6".
     * <p>
     * @deprecated PostgreSQL 12.6 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_6;

    /**
     * (deprecated) Version "12.7".
     * <p>
     * @deprecated PostgreSQL 12.7 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_7;

    /**
     * (deprecated) Version "12.8".
     * <p>
     * @deprecated PostgreSQL 12.8 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_8;

    /**
     * (deprecated) Version "12.9".
     * <p>
     * @deprecated PostgreSQL 12.9 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_12_9;

    /**
     * Version "13" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13;

    /**
     * (deprecated) Version "13.1".
     * <p>
     * @deprecated PostgreSQL 13.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_1;

    /**
     * Version "13.10".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_10;

    /**
     * Version "13.11".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_11;

    /**
     * Version "13.12".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_12;

    /**
     * Version "13.13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_13;

    /**
     * Version "13.14".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_14;

    /**
     * (deprecated) Version "13.2".
     * <p>
     * @deprecated PostgreSQL 13.2 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_2;

    /**
     * (deprecated) Version "13.3".
     * <p>
     * @deprecated PostgreSQL 13.3 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_3;

    /**
     * (deprecated) Version "13.4".
     * <p>
     * @deprecated PostgreSQL 13.4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_4;

    /**
     * (deprecated) Version "13.5".
     * <p>
     * @deprecated PostgreSQL 13.5 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_5;

    /**
     * (deprecated) Version "13.6".
     * <p>
     * @deprecated PostgreSQL 13.6 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_6;

    /**
     * (deprecated) Version "13.7".
     * <p>
     * @deprecated PostgreSQL 13.7 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_7;

    /**
     * Version "13.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_8;

    /**
     * Version "13.9".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_13_9;

    /**
     * Version "14" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14;

    /**
     * (deprecated) Version "14.1".
     * <p>
     * @deprecated PostgreSQL 14.1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14_1;

    /**
     * Version "14.10".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14_10;

    /**
     * Version "14.11".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14_11;

    /**
     * (deprecated) Version "14.2".
     * <p>
     * @deprecated PostgreSQL 14.2 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14_2;

    /**
     * (deprecated) Version "14.3".
     * <p>
     * @deprecated PostgreSQL 14.3 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14_3;

    /**
     * (deprecated) Version "14.4".
     * <p>
     * @deprecated PostgreSQL 14.4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14_4;

    /**
     * Version "14.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14_5;

    /**
     * Version "14.6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14_6;

    /**
     * Version "14.7".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14_7;

    /**
     * Version "14.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14_8;

    /**
     * Version "14.9".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_14_9;

    /**
     * Version "15" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_15;

    /**
     * Version "15.2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_15_2;

    /**
     * Version "15.3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_15_3;

    /**
     * Version "15.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_15_4;

    /**
     * Version "15.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_15_5;

    /**
     * Version "15.6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_15_6;

    /**
     * Version "16" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_16;

    /**
     * Version "16.1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_16_1;

    /**
     * Version "16.2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_16_2;

    /**
     * (deprecated) Version "9.6.24".
     * <p>
     * @deprecated PostgreSQL 9.6 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.PostgresEngineVersion VER_9_6_24;

    /**
     * The full version string, for example, "13.11".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPostgresFullVersion() {
        return software.amazon.jsii.Kernel.get(this, "postgresFullVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The major version of the engine, for example, "13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPostgresMajorVersion() {
        return software.amazon.jsii.Kernel.get(this, "postgresMajorVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
