package software.amazon.awscdk.services.rds;

/**
 * TimeoutAction defines the action to take when a timeout occurs if a scaling point is not found.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ServerlessCluster cluster = ServerlessCluster.Builder.create(this, "AnotherCluster")
 *         .engine(DatabaseClusterEngine.AURORA_POSTGRESQL)
 *         .copyTagsToSnapshot(true) // whether to save the cluster tags when creating the snapshot. Default is 'true'
 *         .parameterGroup(ParameterGroup.fromParameterGroupName(this, "ParameterGroup", "default.aurora-postgresql11"))
 *         .vpc(vpc)
 *         .scaling(ServerlessScalingOptions.builder()
 *                 .autoPause(Duration.minutes(10)) // default is to pause after 5 minutes of idle time
 *                 .minCapacity(AuroraCapacityUnit.ACU_8) // default is 2 Aurora capacity units (ACUs)
 *                 .maxCapacity(AuroraCapacityUnit.ACU_32) // default is 16 Aurora capacity units (ACUs)
 *                 .timeout(Duration.seconds(100)) // default is 5 minutes
 *                 .timeoutAction(TimeoutAction.FORCE_APPLY_CAPACITY_CHANGE)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v1.how-it-works.html#aurora-serverless.how-it-works.timeout-action">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v1.how-it-works.html#aurora-serverless.how-it-works.timeout-action</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:22:00.770Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.TimeoutAction")
public enum TimeoutAction {
    /**
     * FORCE_APPLY_CAPACITY_CHANGE sets the capacity to the specified value as soon as possible.
     * <p>
     * Transactions may be interrupted, and connections to temporary tables and locks may be dropped.
     * Only select this option if your application can recover from dropped connections or incomplete transactions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FORCE_APPLY_CAPACITY_CHANGE,
    /**
     * ROLLBACK_CAPACITY_CHANGE ignores the capacity change if a scaling point is not found.
     * <p>
     * This is the default behavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ROLLBACK_CAPACITY_CHANGE,
}
