package software.amazon.awscdk.services.redshift;

/**
 * Properties for defining a <code>CfnClusterSecurityGroupIngress</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshift.*;
 * CfnClusterSecurityGroupIngressProps cfnClusterSecurityGroupIngressProps = CfnClusterSecurityGroupIngressProps.builder()
 *         .clusterSecurityGroupName("clusterSecurityGroupName")
 *         // the properties below are optional
 *         .cidrip("cidrip")
 *         .ec2SecurityGroupName("ec2SecurityGroupName")
 *         .ec2SecurityGroupOwnerId("ec2SecurityGroupOwnerId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clustersecuritygroupingress.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clustersecuritygroupingress.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:22:00.795Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshift.CfnClusterSecurityGroupIngressProps")
@software.amazon.jsii.Jsii.Proxy(CfnClusterSecurityGroupIngressProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClusterSecurityGroupIngressProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the security group to which the ingress rule is added.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clustersecuritygroupingress.html#cfn-redshift-clustersecuritygroupingress-clustersecuritygroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clustersecuritygroupingress.html#cfn-redshift-clustersecuritygroupingress-clustersecuritygroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterSecurityGroupName();

    /**
     * The IP range to be added the Amazon Redshift security group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clustersecuritygroupingress.html#cfn-redshift-clustersecuritygroupingress-cidrip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clustersecuritygroupingress.html#cfn-redshift-clustersecuritygroupingress-cidrip</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCidrip() {
        return null;
    }

    /**
     * The EC2 security group to be added the Amazon Redshift security group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clustersecuritygroupingress.html#cfn-redshift-clustersecuritygroupingress-ec2securitygroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clustersecuritygroupingress.html#cfn-redshift-clustersecuritygroupingress-ec2securitygroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEc2SecurityGroupName() {
        return null;
    }

    /**
     * The AWS account number of the owner of the security group specified by the <em>EC2SecurityGroupName</em> parameter.
     * <p>
     * The AWS Access Key ID is not an acceptable value.
     * <p>
     * Example: <code>111122223333</code>
     * <p>
     * Conditional. If you specify the <code>EC2SecurityGroupName</code> property, you must specify this property.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clustersecuritygroupingress.html#cfn-redshift-clustersecuritygroupingress-ec2securitygroupownerid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-clustersecuritygroupingress.html#cfn-redshift-clustersecuritygroupingress-ec2securitygroupownerid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEc2SecurityGroupOwnerId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClusterSecurityGroupIngressProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClusterSecurityGroupIngressProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClusterSecurityGroupIngressProps> {
        java.lang.String clusterSecurityGroupName;
        java.lang.String cidrip;
        java.lang.String ec2SecurityGroupName;
        java.lang.String ec2SecurityGroupOwnerId;

        /**
         * Sets the value of {@link CfnClusterSecurityGroupIngressProps#getClusterSecurityGroupName}
         * @param clusterSecurityGroupName The name of the security group to which the ingress rule is added. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSecurityGroupName(java.lang.String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterSecurityGroupIngressProps#getCidrip}
         * @param cidrip The IP range to be added the Amazon Redshift security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrip(java.lang.String cidrip) {
            this.cidrip = cidrip;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterSecurityGroupIngressProps#getEc2SecurityGroupName}
         * @param ec2SecurityGroupName The EC2 security group to be added the Amazon Redshift security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2SecurityGroupName(java.lang.String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterSecurityGroupIngressProps#getEc2SecurityGroupOwnerId}
         * @param ec2SecurityGroupOwnerId The AWS account number of the owner of the security group specified by the <em>EC2SecurityGroupName</em> parameter.
         *                                The AWS Access Key ID is not an acceptable value.
         *                                <p>
         *                                Example: <code>111122223333</code>
         *                                <p>
         *                                Conditional. If you specify the <code>EC2SecurityGroupName</code> property, you must specify this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2SecurityGroupOwnerId(java.lang.String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClusterSecurityGroupIngressProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClusterSecurityGroupIngressProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnClusterSecurityGroupIngressProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClusterSecurityGroupIngressProps {
        private final java.lang.String clusterSecurityGroupName;
        private final java.lang.String cidrip;
        private final java.lang.String ec2SecurityGroupName;
        private final java.lang.String ec2SecurityGroupOwnerId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterSecurityGroupName = software.amazon.jsii.Kernel.get(this, "clusterSecurityGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cidrip = software.amazon.jsii.Kernel.get(this, "cidrip", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ec2SecurityGroupName = software.amazon.jsii.Kernel.get(this, "ec2SecurityGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ec2SecurityGroupOwnerId = software.amazon.jsii.Kernel.get(this, "ec2SecurityGroupOwnerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterSecurityGroupName = java.util.Objects.requireNonNull(builder.clusterSecurityGroupName, "clusterSecurityGroupName is required");
            this.cidrip = builder.cidrip;
            this.ec2SecurityGroupName = builder.ec2SecurityGroupName;
            this.ec2SecurityGroupOwnerId = builder.ec2SecurityGroupOwnerId;
        }

        @Override
        public final java.lang.String getClusterSecurityGroupName() {
            return this.clusterSecurityGroupName;
        }

        @Override
        public final java.lang.String getCidrip() {
            return this.cidrip;
        }

        @Override
        public final java.lang.String getEc2SecurityGroupName() {
            return this.ec2SecurityGroupName;
        }

        @Override
        public final java.lang.String getEc2SecurityGroupOwnerId() {
            return this.ec2SecurityGroupOwnerId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterSecurityGroupName", om.valueToTree(this.getClusterSecurityGroupName()));
            if (this.getCidrip() != null) {
                data.set("cidrip", om.valueToTree(this.getCidrip()));
            }
            if (this.getEc2SecurityGroupName() != null) {
                data.set("ec2SecurityGroupName", om.valueToTree(this.getEc2SecurityGroupName()));
            }
            if (this.getEc2SecurityGroupOwnerId() != null) {
                data.set("ec2SecurityGroupOwnerId", om.valueToTree(this.getEc2SecurityGroupOwnerId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshift.CfnClusterSecurityGroupIngressProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClusterSecurityGroupIngressProps.Jsii$Proxy that = (CfnClusterSecurityGroupIngressProps.Jsii$Proxy) o;

            if (!clusterSecurityGroupName.equals(that.clusterSecurityGroupName)) return false;
            if (this.cidrip != null ? !this.cidrip.equals(that.cidrip) : that.cidrip != null) return false;
            if (this.ec2SecurityGroupName != null ? !this.ec2SecurityGroupName.equals(that.ec2SecurityGroupName) : that.ec2SecurityGroupName != null) return false;
            return this.ec2SecurityGroupOwnerId != null ? this.ec2SecurityGroupOwnerId.equals(that.ec2SecurityGroupOwnerId) : that.ec2SecurityGroupOwnerId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterSecurityGroupName.hashCode();
            result = 31 * result + (this.cidrip != null ? this.cidrip.hashCode() : 0);
            result = 31 * result + (this.ec2SecurityGroupName != null ? this.ec2SecurityGroupName.hashCode() : 0);
            result = 31 * result + (this.ec2SecurityGroupOwnerId != null ? this.ec2SecurityGroupOwnerId.hashCode() : 0);
            return result;
        }
    }
}
