package software.amazon.awscdk.services.sagemaker;

/**
 * Creates a definition for a job that monitors model quality and drift.
 * <p>
 * For information about model monitor, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnModelQualityJobDefinition cfnModelQualityJobDefinition = CfnModelQualityJobDefinition.Builder.create(this, "MyCfnModelQualityJobDefinition")
 *         .jobResources(MonitoringResourcesProperty.builder()
 *                 .clusterConfig(ClusterConfigProperty.builder()
 *                         .instanceCount(123)
 *                         .instanceType("instanceType")
 *                         .volumeSizeInGb(123)
 *                         // the properties below are optional
 *                         .volumeKmsKeyId("volumeKmsKeyId")
 *                         .build())
 *                 .build())
 *         .modelQualityAppSpecification(ModelQualityAppSpecificationProperty.builder()
 *                 .imageUri("imageUri")
 *                 .problemType("problemType")
 *                 // the properties below are optional
 *                 .containerArguments(List.of("containerArguments"))
 *                 .containerEntrypoint(List.of("containerEntrypoint"))
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .postAnalyticsProcessorSourceUri("postAnalyticsProcessorSourceUri")
 *                 .recordPreprocessorSourceUri("recordPreprocessorSourceUri")
 *                 .build())
 *         .modelQualityJobInput(ModelQualityJobInputProperty.builder()
 *                 .groundTruthS3Input(MonitoringGroundTruthS3InputProperty.builder()
 *                         .s3Uri("s3Uri")
 *                         .build())
 *                 // the properties below are optional
 *                 .batchTransformInput(BatchTransformInputProperty.builder()
 *                         .dataCapturedDestinationS3Uri("dataCapturedDestinationS3Uri")
 *                         .datasetFormat(DatasetFormatProperty.builder()
 *                                 .csv(CsvProperty.builder()
 *                                         .header(false)
 *                                         .build())
 *                                 .json(JsonProperty.builder()
 *                                         .line(false)
 *                                         .build())
 *                                 .parquet(false)
 *                                 .build())
 *                         .localPath("localPath")
 *                         // the properties below are optional
 *                         .endTimeOffset("endTimeOffset")
 *                         .inferenceAttribute("inferenceAttribute")
 *                         .probabilityAttribute("probabilityAttribute")
 *                         .probabilityThresholdAttribute(123)
 *                         .s3DataDistributionType("s3DataDistributionType")
 *                         .s3InputMode("s3InputMode")
 *                         .startTimeOffset("startTimeOffset")
 *                         .build())
 *                 .endpointInput(EndpointInputProperty.builder()
 *                         .endpointName("endpointName")
 *                         .localPath("localPath")
 *                         // the properties below are optional
 *                         .endTimeOffset("endTimeOffset")
 *                         .inferenceAttribute("inferenceAttribute")
 *                         .probabilityAttribute("probabilityAttribute")
 *                         .probabilityThresholdAttribute(123)
 *                         .s3DataDistributionType("s3DataDistributionType")
 *                         .s3InputMode("s3InputMode")
 *                         .startTimeOffset("startTimeOffset")
 *                         .build())
 *                 .build())
 *         .modelQualityJobOutputConfig(MonitoringOutputConfigProperty.builder()
 *                 .monitoringOutputs(List.of(MonitoringOutputProperty.builder()
 *                         .s3Output(S3OutputProperty.builder()
 *                                 .localPath("localPath")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .s3UploadMode("s3UploadMode")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .endpointName("endpointName")
 *         .jobDefinitionName("jobDefinitionName")
 *         .modelQualityBaselineConfig(ModelQualityBaselineConfigProperty.builder()
 *                 .baseliningJobName("baseliningJobName")
 *                 .constraintsResource(ConstraintsResourceProperty.builder()
 *                         .s3Uri("s3Uri")
 *                         .build())
 *                 .build())
 *         .networkConfig(NetworkConfigProperty.builder()
 *                 .enableInterContainerTrafficEncryption(false)
 *                 .enableNetworkIsolation(false)
 *                 .vpcConfig(VpcConfigProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .build())
 *         .stoppingCondition(StoppingConditionProperty.builder()
 *                 .maxRuntimeInSeconds(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:22:01.523Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition")
public class CfnModelQualityJobDefinition extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnModelQualityJobDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnModelQualityJobDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnModelQualityJobDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time when the job definition was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrJobDefinitionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrJobDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Identifies the resources to deploy for a monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getJobResources() {
        return software.amazon.jsii.Kernel.get(this, "jobResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Identifies the resources to deploy for a monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobResources(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "jobResources", java.util.Objects.requireNonNull(value, "jobResources is required"));
    }

    /**
     * Identifies the resources to deploy for a monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobResources(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.MonitoringResourcesProperty value) {
        software.amazon.jsii.Kernel.set(this, "jobResources", java.util.Objects.requireNonNull(value, "jobResources is required"));
    }

    /**
     * Container image configuration object for the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getModelQualityAppSpecification() {
        return software.amazon.jsii.Kernel.get(this, "modelQualityAppSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Container image configuration object for the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelQualityAppSpecification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "modelQualityAppSpecification", java.util.Objects.requireNonNull(value, "modelQualityAppSpecification is required"));
    }

    /**
     * Container image configuration object for the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelQualityAppSpecification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "modelQualityAppSpecification", java.util.Objects.requireNonNull(value, "modelQualityAppSpecification is required"));
    }

    /**
     * A list of the inputs that are monitored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getModelQualityJobInput() {
        return software.amazon.jsii.Kernel.get(this, "modelQualityJobInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of the inputs that are monitored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelQualityJobInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "modelQualityJobInput", java.util.Objects.requireNonNull(value, "modelQualityJobInput is required"));
    }

    /**
     * A list of the inputs that are monitored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelQualityJobInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.ModelQualityJobInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "modelQualityJobInput", java.util.Objects.requireNonNull(value, "modelQualityJobInput is required"));
    }

    /**
     * The output configuration for monitoring jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getModelQualityJobOutputConfig() {
        return software.amazon.jsii.Kernel.get(this, "modelQualityJobOutputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The output configuration for monitoring jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelQualityJobOutputConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "modelQualityJobOutputConfig", java.util.Objects.requireNonNull(value, "modelQualityJobOutputConfig is required"));
    }

    /**
     * The output configuration for monitoring jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelQualityJobOutputConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.MonitoringOutputConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "modelQualityJobOutputConfig", java.util.Objects.requireNonNull(value, "modelQualityJobOutputConfig is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The name of the endpoint used to run the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointName() {
        return software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the endpoint used to run the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointName", value);
    }

    /**
     * The name of the monitoring job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getJobDefinitionName() {
        return software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the monitoring job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobDefinitionName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "jobDefinitionName", value);
    }

    /**
     * Specifies the constraints and baselines for the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getModelQualityBaselineConfig() {
        return software.amazon.jsii.Kernel.get(this, "modelQualityBaselineConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the constraints and baselines for the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelQualityBaselineConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "modelQualityBaselineConfig", value);
    }

    /**
     * Specifies the constraints and baselines for the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelQualityBaselineConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.ModelQualityBaselineConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "modelQualityBaselineConfig", value);
    }

    /**
     * Specifies the network configuration for the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfig() {
        return software.amazon.jsii.Kernel.get(this, "networkConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the network configuration for the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkConfig", value);
    }

    /**
     * Specifies the network configuration for the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.NetworkConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "networkConfig", value);
    }

    /**
     * A time limit for how long the monitoring job is allowed to run before stopping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStoppingCondition() {
        return software.amazon.jsii.Kernel.get(this, "stoppingCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A time limit for how long the monitoring job is allowed to run before stopping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStoppingCondition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stoppingCondition", value);
    }

    /**
     * A time limit for how long the monitoring job is allowed to run before stopping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStoppingCondition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.StoppingConditionProperty value) {
        software.amazon.jsii.Kernel.set(this, "stoppingCondition", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Input object for the batch transform job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * BatchTransformInputProperty batchTransformInputProperty = BatchTransformInputProperty.builder()
     *         .dataCapturedDestinationS3Uri("dataCapturedDestinationS3Uri")
     *         .datasetFormat(DatasetFormatProperty.builder()
     *                 .csv(CsvProperty.builder()
     *                         .header(false)
     *                         .build())
     *                 .json(JsonProperty.builder()
     *                         .line(false)
     *                         .build())
     *                 .parquet(false)
     *                 .build())
     *         .localPath("localPath")
     *         // the properties below are optional
     *         .endTimeOffset("endTimeOffset")
     *         .inferenceAttribute("inferenceAttribute")
     *         .probabilityAttribute("probabilityAttribute")
     *         .probabilityThresholdAttribute(123)
     *         .s3DataDistributionType("s3DataDistributionType")
     *         .s3InputMode("s3InputMode")
     *         .startTimeOffset("startTimeOffset")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.BatchTransformInputProperty")
    @software.amazon.jsii.Jsii.Proxy(BatchTransformInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BatchTransformInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 location being used to capture the data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-datacaptureddestinations3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-datacaptureddestinations3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataCapturedDestinationS3Uri();

        /**
         * The dataset format for your batch transform job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-datasetformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-datasetformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDatasetFormat();

        /**
         * Path to the filesystem where the batch transform data is available to the container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-localpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-localpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocalPath();

        /**
         * If specified, monitoring jobs subtract this time from the end time.
         * <p>
         * For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-endtimeoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-endtimeoffset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndTimeOffset() {
            return null;
        }

        /**
         * The attribute of the input data that represents the ground truth label.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-inferenceattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-inferenceattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInferenceAttribute() {
            return null;
        }

        /**
         * In a classification problem, the attribute that represents the class probability.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-probabilityattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-probabilityattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProbabilityAttribute() {
            return null;
        }

        /**
         * The threshold for the class probability to be evaluated as a positive result.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-probabilitythresholdattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-probabilitythresholdattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProbabilityThresholdAttribute() {
            return null;
        }

        /**
         * Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.
         * <p>
         * Defaults to <code>FullyReplicated</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-s3datadistributiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-s3datadistributiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3DataDistributionType() {
            return null;
        }

        /**
         * Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for the monitoring job.
         * <p>
         * <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to <code>File</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-s3inputmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-s3inputmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3InputMode() {
            return null;
        }

        /**
         * If specified, monitoring jobs substract this time from the start time.
         * <p>
         * For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-starttimeoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelqualityjobdefinition-batchtransforminput-starttimeoffset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartTimeOffset() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BatchTransformInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BatchTransformInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BatchTransformInputProperty> {
            java.lang.String dataCapturedDestinationS3Uri;
            java.lang.Object datasetFormat;
            java.lang.String localPath;
            java.lang.String endTimeOffset;
            java.lang.String inferenceAttribute;
            java.lang.String probabilityAttribute;
            java.lang.Number probabilityThresholdAttribute;
            java.lang.String s3DataDistributionType;
            java.lang.String s3InputMode;
            java.lang.String startTimeOffset;

            /**
             * Sets the value of {@link BatchTransformInputProperty#getDataCapturedDestinationS3Uri}
             * @param dataCapturedDestinationS3Uri The Amazon S3 location being used to capture the data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataCapturedDestinationS3Uri(java.lang.String dataCapturedDestinationS3Uri) {
                this.dataCapturedDestinationS3Uri = dataCapturedDestinationS3Uri;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getDatasetFormat}
             * @param datasetFormat The dataset format for your batch transform job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetFormat(software.amazon.awscdk.IResolvable datasetFormat) {
                this.datasetFormat = datasetFormat;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getDatasetFormat}
             * @param datasetFormat The dataset format for your batch transform job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetFormat(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.DatasetFormatProperty datasetFormat) {
                this.datasetFormat = datasetFormat;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getLocalPath}
             * @param localPath Path to the filesystem where the batch transform data is available to the container. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localPath(java.lang.String localPath) {
                this.localPath = localPath;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getEndTimeOffset}
             * @param endTimeOffset If specified, monitoring jobs subtract this time from the end time.
             *                      For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTimeOffset(java.lang.String endTimeOffset) {
                this.endTimeOffset = endTimeOffset;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getInferenceAttribute}
             * @param inferenceAttribute The attribute of the input data that represents the ground truth label.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceAttribute(java.lang.String inferenceAttribute) {
                this.inferenceAttribute = inferenceAttribute;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getProbabilityAttribute}
             * @param probabilityAttribute In a classification problem, the attribute that represents the class probability.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder probabilityAttribute(java.lang.String probabilityAttribute) {
                this.probabilityAttribute = probabilityAttribute;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getProbabilityThresholdAttribute}
             * @param probabilityThresholdAttribute The threshold for the class probability to be evaluated as a positive result.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder probabilityThresholdAttribute(java.lang.Number probabilityThresholdAttribute) {
                this.probabilityThresholdAttribute = probabilityThresholdAttribute;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getS3DataDistributionType}
             * @param s3DataDistributionType Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.
             *                               Defaults to <code>FullyReplicated</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3DataDistributionType(java.lang.String s3DataDistributionType) {
                this.s3DataDistributionType = s3DataDistributionType;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getS3InputMode}
             * @param s3InputMode Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for the monitoring job.
             *                    <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to <code>File</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputMode(java.lang.String s3InputMode) {
                this.s3InputMode = s3InputMode;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getStartTimeOffset}
             * @param startTimeOffset If specified, monitoring jobs substract this time from the start time.
             *                        For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTimeOffset(java.lang.String startTimeOffset) {
                this.startTimeOffset = startTimeOffset;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BatchTransformInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BatchTransformInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BatchTransformInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchTransformInputProperty {
            private final java.lang.String dataCapturedDestinationS3Uri;
            private final java.lang.Object datasetFormat;
            private final java.lang.String localPath;
            private final java.lang.String endTimeOffset;
            private final java.lang.String inferenceAttribute;
            private final java.lang.String probabilityAttribute;
            private final java.lang.Number probabilityThresholdAttribute;
            private final java.lang.String s3DataDistributionType;
            private final java.lang.String s3InputMode;
            private final java.lang.String startTimeOffset;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataCapturedDestinationS3Uri = software.amazon.jsii.Kernel.get(this, "dataCapturedDestinationS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.datasetFormat = software.amazon.jsii.Kernel.get(this, "datasetFormat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.localPath = software.amazon.jsii.Kernel.get(this, "localPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endTimeOffset = software.amazon.jsii.Kernel.get(this, "endTimeOffset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inferenceAttribute = software.amazon.jsii.Kernel.get(this, "inferenceAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.probabilityAttribute = software.amazon.jsii.Kernel.get(this, "probabilityAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.probabilityThresholdAttribute = software.amazon.jsii.Kernel.get(this, "probabilityThresholdAttribute", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.s3DataDistributionType = software.amazon.jsii.Kernel.get(this, "s3DataDistributionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3InputMode = software.amazon.jsii.Kernel.get(this, "s3InputMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startTimeOffset = software.amazon.jsii.Kernel.get(this, "startTimeOffset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataCapturedDestinationS3Uri = java.util.Objects.requireNonNull(builder.dataCapturedDestinationS3Uri, "dataCapturedDestinationS3Uri is required");
                this.datasetFormat = java.util.Objects.requireNonNull(builder.datasetFormat, "datasetFormat is required");
                this.localPath = java.util.Objects.requireNonNull(builder.localPath, "localPath is required");
                this.endTimeOffset = builder.endTimeOffset;
                this.inferenceAttribute = builder.inferenceAttribute;
                this.probabilityAttribute = builder.probabilityAttribute;
                this.probabilityThresholdAttribute = builder.probabilityThresholdAttribute;
                this.s3DataDistributionType = builder.s3DataDistributionType;
                this.s3InputMode = builder.s3InputMode;
                this.startTimeOffset = builder.startTimeOffset;
            }

            @Override
            public final java.lang.String getDataCapturedDestinationS3Uri() {
                return this.dataCapturedDestinationS3Uri;
            }

            @Override
            public final java.lang.Object getDatasetFormat() {
                return this.datasetFormat;
            }

            @Override
            public final java.lang.String getLocalPath() {
                return this.localPath;
            }

            @Override
            public final java.lang.String getEndTimeOffset() {
                return this.endTimeOffset;
            }

            @Override
            public final java.lang.String getInferenceAttribute() {
                return this.inferenceAttribute;
            }

            @Override
            public final java.lang.String getProbabilityAttribute() {
                return this.probabilityAttribute;
            }

            @Override
            public final java.lang.Number getProbabilityThresholdAttribute() {
                return this.probabilityThresholdAttribute;
            }

            @Override
            public final java.lang.String getS3DataDistributionType() {
                return this.s3DataDistributionType;
            }

            @Override
            public final java.lang.String getS3InputMode() {
                return this.s3InputMode;
            }

            @Override
            public final java.lang.String getStartTimeOffset() {
                return this.startTimeOffset;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataCapturedDestinationS3Uri", om.valueToTree(this.getDataCapturedDestinationS3Uri()));
                data.set("datasetFormat", om.valueToTree(this.getDatasetFormat()));
                data.set("localPath", om.valueToTree(this.getLocalPath()));
                if (this.getEndTimeOffset() != null) {
                    data.set("endTimeOffset", om.valueToTree(this.getEndTimeOffset()));
                }
                if (this.getInferenceAttribute() != null) {
                    data.set("inferenceAttribute", om.valueToTree(this.getInferenceAttribute()));
                }
                if (this.getProbabilityAttribute() != null) {
                    data.set("probabilityAttribute", om.valueToTree(this.getProbabilityAttribute()));
                }
                if (this.getProbabilityThresholdAttribute() != null) {
                    data.set("probabilityThresholdAttribute", om.valueToTree(this.getProbabilityThresholdAttribute()));
                }
                if (this.getS3DataDistributionType() != null) {
                    data.set("s3DataDistributionType", om.valueToTree(this.getS3DataDistributionType()));
                }
                if (this.getS3InputMode() != null) {
                    data.set("s3InputMode", om.valueToTree(this.getS3InputMode()));
                }
                if (this.getStartTimeOffset() != null) {
                    data.set("startTimeOffset", om.valueToTree(this.getStartTimeOffset()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.BatchTransformInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BatchTransformInputProperty.Jsii$Proxy that = (BatchTransformInputProperty.Jsii$Proxy) o;

                if (!dataCapturedDestinationS3Uri.equals(that.dataCapturedDestinationS3Uri)) return false;
                if (!datasetFormat.equals(that.datasetFormat)) return false;
                if (!localPath.equals(that.localPath)) return false;
                if (this.endTimeOffset != null ? !this.endTimeOffset.equals(that.endTimeOffset) : that.endTimeOffset != null) return false;
                if (this.inferenceAttribute != null ? !this.inferenceAttribute.equals(that.inferenceAttribute) : that.inferenceAttribute != null) return false;
                if (this.probabilityAttribute != null ? !this.probabilityAttribute.equals(that.probabilityAttribute) : that.probabilityAttribute != null) return false;
                if (this.probabilityThresholdAttribute != null ? !this.probabilityThresholdAttribute.equals(that.probabilityThresholdAttribute) : that.probabilityThresholdAttribute != null) return false;
                if (this.s3DataDistributionType != null ? !this.s3DataDistributionType.equals(that.s3DataDistributionType) : that.s3DataDistributionType != null) return false;
                if (this.s3InputMode != null ? !this.s3InputMode.equals(that.s3InputMode) : that.s3InputMode != null) return false;
                return this.startTimeOffset != null ? this.startTimeOffset.equals(that.startTimeOffset) : that.startTimeOffset == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataCapturedDestinationS3Uri.hashCode();
                result = 31 * result + (this.datasetFormat.hashCode());
                result = 31 * result + (this.localPath.hashCode());
                result = 31 * result + (this.endTimeOffset != null ? this.endTimeOffset.hashCode() : 0);
                result = 31 * result + (this.inferenceAttribute != null ? this.inferenceAttribute.hashCode() : 0);
                result = 31 * result + (this.probabilityAttribute != null ? this.probabilityAttribute.hashCode() : 0);
                result = 31 * result + (this.probabilityThresholdAttribute != null ? this.probabilityThresholdAttribute.hashCode() : 0);
                result = 31 * result + (this.s3DataDistributionType != null ? this.s3DataDistributionType.hashCode() : 0);
                result = 31 * result + (this.s3InputMode != null ? this.s3InputMode.hashCode() : 0);
                result = 31 * result + (this.startTimeOffset != null ? this.startTimeOffset.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for the cluster of resources used to run the processing job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClusterConfigProperty clusterConfigProperty = ClusterConfigProperty.builder()
     *         .instanceCount(123)
     *         .instanceType("instanceType")
     *         .volumeSizeInGb(123)
     *         // the properties below are optional
     *         .volumeKmsKeyId("volumeKmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.ClusterConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of ML compute instances to use in the model monitoring job.
         * <p>
         * For distributed processing jobs, specify a value greater than 1. The default value is 1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-instancecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-instancecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

        /**
         * The ML compute instance type for the processing job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * The size of the ML storage volume, in gigabytes, that you want to provision.
         * <p>
         * You must specify sufficient ML storage for your scenario.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-volumesizeingb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-volumesizeingb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getVolumeSizeInGb();

        /**
         * The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-volumekmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-volumekmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterConfigProperty> {
            java.lang.Number instanceCount;
            java.lang.String instanceType;
            java.lang.Number volumeSizeInGb;
            java.lang.String volumeKmsKeyId;

            /**
             * Sets the value of {@link ClusterConfigProperty#getInstanceCount}
             * @param instanceCount The number of ML compute instances to use in the model monitoring job. This parameter is required.
             *                      For distributed processing jobs, specify a value greater than 1. The default value is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getInstanceType}
             * @param instanceType The ML compute instance type for the processing job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getVolumeSizeInGb}
             * @param volumeSizeInGb The size of the ML storage volume, in gigabytes, that you want to provision. This parameter is required.
             *                       You must specify sufficient ML storage for your scenario.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSizeInGb(java.lang.Number volumeSizeInGb) {
                this.volumeSizeInGb = volumeSizeInGb;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getVolumeKmsKeyId}
             * @param volumeKmsKeyId The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeKmsKeyId(java.lang.String volumeKmsKeyId) {
                this.volumeKmsKeyId = volumeKmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterConfigProperty {
            private final java.lang.Number instanceCount;
            private final java.lang.String instanceType;
            private final java.lang.Number volumeSizeInGb;
            private final java.lang.String volumeKmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.volumeSizeInGb = software.amazon.jsii.Kernel.get(this, "volumeSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeKmsKeyId = software.amazon.jsii.Kernel.get(this, "volumeKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceCount = java.util.Objects.requireNonNull(builder.instanceCount, "instanceCount is required");
                this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
                this.volumeSizeInGb = java.util.Objects.requireNonNull(builder.volumeSizeInGb, "volumeSizeInGb is required");
                this.volumeKmsKeyId = builder.volumeKmsKeyId;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Number getVolumeSizeInGb() {
                return this.volumeSizeInGb;
            }

            @Override
            public final java.lang.String getVolumeKmsKeyId() {
                return this.volumeKmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                data.set("volumeSizeInGb", om.valueToTree(this.getVolumeSizeInGb()));
                if (this.getVolumeKmsKeyId() != null) {
                    data.set("volumeKmsKeyId", om.valueToTree(this.getVolumeKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.ClusterConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterConfigProperty.Jsii$Proxy that = (ClusterConfigProperty.Jsii$Proxy) o;

                if (!instanceCount.equals(that.instanceCount)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (!volumeSizeInGb.equals(that.volumeSizeInGb)) return false;
                return this.volumeKmsKeyId != null ? this.volumeKmsKeyId.equals(that.volumeKmsKeyId) : that.volumeKmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceCount.hashCode();
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.volumeSizeInGb.hashCode());
                result = 31 * result + (this.volumeKmsKeyId != null ? this.volumeKmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The constraints resource for a monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ConstraintsResourceProperty constraintsResourceProperty = ConstraintsResourceProperty.builder()
     *         .s3Uri("s3Uri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-constraintsresource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-constraintsresource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.ConstraintsResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(ConstraintsResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConstraintsResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 URI for the constraints resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-constraintsresource.html#cfn-sagemaker-modelqualityjobdefinition-constraintsresource-s3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-constraintsresource.html#cfn-sagemaker-modelqualityjobdefinition-constraintsresource-s3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3Uri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConstraintsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConstraintsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConstraintsResourceProperty> {
            java.lang.String s3Uri;

            /**
             * Sets the value of {@link ConstraintsResourceProperty#getS3Uri}
             * @param s3Uri The Amazon S3 URI for the constraints resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConstraintsResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConstraintsResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConstraintsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConstraintsResourceProperty {
            private final java.lang.String s3Uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Uri = builder.s3Uri;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Uri() != null) {
                    data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.ConstraintsResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConstraintsResourceProperty.Jsii$Proxy that = (ConstraintsResourceProperty.Jsii$Proxy) o;

                return this.s3Uri != null ? this.s3Uri.equals(that.s3Uri) : that.s3Uri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Uri != null ? this.s3Uri.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The CSV format.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CsvProperty csvProperty = CsvProperty.builder()
     *         .header(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-csv.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-csv.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.CsvProperty")
    @software.amazon.jsii.Jsii.Proxy(CsvProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CsvProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A boolean flag indicating if given CSV has header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-csv.html#cfn-sagemaker-modelqualityjobdefinition-csv-header">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-csv.html#cfn-sagemaker-modelqualityjobdefinition-csv-header</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeader() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CsvProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CsvProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CsvProperty> {
            java.lang.Object header;

            /**
             * Sets the value of {@link CsvProperty#getHeader}
             * @param header A boolean flag indicating if given CSV has header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder header(java.lang.Boolean header) {
                this.header = header;
                return this;
            }

            /**
             * Sets the value of {@link CsvProperty#getHeader}
             * @param header A boolean flag indicating if given CSV has header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder header(software.amazon.awscdk.IResolvable header) {
                this.header = header;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CsvProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CsvProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CsvProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CsvProperty {
            private final java.lang.Object header;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.header = software.amazon.jsii.Kernel.get(this, "header", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.header = builder.header;
            }

            @Override
            public final java.lang.Object getHeader() {
                return this.header;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHeader() != null) {
                    data.set("header", om.valueToTree(this.getHeader()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.CsvProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CsvProperty.Jsii$Proxy that = (CsvProperty.Jsii$Proxy) o;

                return this.header != null ? this.header.equals(that.header) : that.header == null;
            }

            @Override
            public final int hashCode() {
                int result = this.header != null ? this.header.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The dataset format of the data to monitor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DatasetFormatProperty datasetFormatProperty = DatasetFormatProperty.builder()
     *         .csv(CsvProperty.builder()
     *                 .header(false)
     *                 .build())
     *         .json(JsonProperty.builder()
     *                 .line(false)
     *                 .build())
     *         .parquet(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-datasetformat.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-datasetformat.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.DatasetFormatProperty")
    @software.amazon.jsii.Jsii.Proxy(DatasetFormatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatasetFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CSV format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-datasetformat.html#cfn-sagemaker-modelqualityjobdefinition-datasetformat-csv">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-datasetformat.html#cfn-sagemaker-modelqualityjobdefinition-datasetformat-csv</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCsv() {
            return null;
        }

        /**
         * The Json format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-datasetformat.html#cfn-sagemaker-modelqualityjobdefinition-datasetformat-json">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-datasetformat.html#cfn-sagemaker-modelqualityjobdefinition-datasetformat-json</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJson() {
            return null;
        }

        /**
         * A flag indicating if the dataset format is Parquet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-datasetformat.html#cfn-sagemaker-modelqualityjobdefinition-datasetformat-parquet">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-datasetformat.html#cfn-sagemaker-modelqualityjobdefinition-datasetformat-parquet</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParquet() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatasetFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatasetFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatasetFormatProperty> {
            java.lang.Object csv;
            java.lang.Object json;
            java.lang.Object parquet;

            /**
             * Sets the value of {@link DatasetFormatProperty#getCsv}
             * @param csv The CSV format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csv(software.amazon.awscdk.IResolvable csv) {
                this.csv = csv;
                return this;
            }

            /**
             * Sets the value of {@link DatasetFormatProperty#getCsv}
             * @param csv The CSV format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csv(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.CsvProperty csv) {
                this.csv = csv;
                return this;
            }

            /**
             * Sets the value of {@link DatasetFormatProperty#getJson}
             * @param json The Json format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder json(software.amazon.awscdk.IResolvable json) {
                this.json = json;
                return this;
            }

            /**
             * Sets the value of {@link DatasetFormatProperty#getJson}
             * @param json The Json format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder json(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.JsonProperty json) {
                this.json = json;
                return this;
            }

            /**
             * Sets the value of {@link DatasetFormatProperty#getParquet}
             * @param parquet A flag indicating if the dataset format is Parquet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parquet(java.lang.Boolean parquet) {
                this.parquet = parquet;
                return this;
            }

            /**
             * Sets the value of {@link DatasetFormatProperty#getParquet}
             * @param parquet A flag indicating if the dataset format is Parquet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parquet(software.amazon.awscdk.IResolvable parquet) {
                this.parquet = parquet;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatasetFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatasetFormatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatasetFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatasetFormatProperty {
            private final java.lang.Object csv;
            private final java.lang.Object json;
            private final java.lang.Object parquet;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.csv = software.amazon.jsii.Kernel.get(this, "csv", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.json = software.amazon.jsii.Kernel.get(this, "json", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parquet = software.amazon.jsii.Kernel.get(this, "parquet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.csv = builder.csv;
                this.json = builder.json;
                this.parquet = builder.parquet;
            }

            @Override
            public final java.lang.Object getCsv() {
                return this.csv;
            }

            @Override
            public final java.lang.Object getJson() {
                return this.json;
            }

            @Override
            public final java.lang.Object getParquet() {
                return this.parquet;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCsv() != null) {
                    data.set("csv", om.valueToTree(this.getCsv()));
                }
                if (this.getJson() != null) {
                    data.set("json", om.valueToTree(this.getJson()));
                }
                if (this.getParquet() != null) {
                    data.set("parquet", om.valueToTree(this.getParquet()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.DatasetFormatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatasetFormatProperty.Jsii$Proxy that = (DatasetFormatProperty.Jsii$Proxy) o;

                if (this.csv != null ? !this.csv.equals(that.csv) : that.csv != null) return false;
                if (this.json != null ? !this.json.equals(that.json) : that.json != null) return false;
                return this.parquet != null ? this.parquet.equals(that.parquet) : that.parquet == null;
            }

            @Override
            public final int hashCode() {
                int result = this.csv != null ? this.csv.hashCode() : 0;
                result = 31 * result + (this.json != null ? this.json.hashCode() : 0);
                result = 31 * result + (this.parquet != null ? this.parquet.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Input object for the endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * EndpointInputProperty endpointInputProperty = EndpointInputProperty.builder()
     *         .endpointName("endpointName")
     *         .localPath("localPath")
     *         // the properties below are optional
     *         .endTimeOffset("endTimeOffset")
     *         .inferenceAttribute("inferenceAttribute")
     *         .probabilityAttribute("probabilityAttribute")
     *         .probabilityThresholdAttribute(123)
     *         .s3DataDistributionType("s3DataDistributionType")
     *         .s3InputMode("s3InputMode")
     *         .startTimeOffset("startTimeOffset")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.EndpointInputProperty")
    @software.amazon.jsii.Jsii.Proxy(EndpointInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EndpointInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An endpoint in customer's account which has enabled <code>DataCaptureConfig</code> enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-endpointname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-endpointname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndpointName();

        /**
         * Path to the filesystem where the endpoint data is available to the container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-localpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-localpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocalPath();

        /**
         * If specified, monitoring jobs substract this time from the end time.
         * <p>
         * For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-endtimeoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-endtimeoffset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndTimeOffset() {
            return null;
        }

        /**
         * The attribute of the input data that represents the ground truth label.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-inferenceattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-inferenceattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInferenceAttribute() {
            return null;
        }

        /**
         * In a classification problem, the attribute that represents the class probability.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-probabilityattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-probabilityattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProbabilityAttribute() {
            return null;
        }

        /**
         * The threshold for the class probability to be evaluated as a positive result.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-probabilitythresholdattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-probabilitythresholdattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProbabilityThresholdAttribute() {
            return null;
        }

        /**
         * Whether input data distributed in Amazon S3 is fully replicated or sharded by an Amazon S3 key.
         * <p>
         * Defaults to <code>FullyReplicated</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-s3datadistributiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-s3datadistributiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3DataDistributionType() {
            return null;
        }

        /**
         * Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for the monitoring job.
         * <p>
         * <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to <code>File</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-s3inputmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-s3inputmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3InputMode() {
            return null;
        }

        /**
         * If specified, monitoring jobs substract this time from the start time.
         * <p>
         * For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-starttimeoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-starttimeoffset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartTimeOffset() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EndpointInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EndpointInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EndpointInputProperty> {
            java.lang.String endpointName;
            java.lang.String localPath;
            java.lang.String endTimeOffset;
            java.lang.String inferenceAttribute;
            java.lang.String probabilityAttribute;
            java.lang.Number probabilityThresholdAttribute;
            java.lang.String s3DataDistributionType;
            java.lang.String s3InputMode;
            java.lang.String startTimeOffset;

            /**
             * Sets the value of {@link EndpointInputProperty#getEndpointName}
             * @param endpointName An endpoint in customer's account which has enabled <code>DataCaptureConfig</code> enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointName(java.lang.String endpointName) {
                this.endpointName = endpointName;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getLocalPath}
             * @param localPath Path to the filesystem where the endpoint data is available to the container. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localPath(java.lang.String localPath) {
                this.localPath = localPath;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getEndTimeOffset}
             * @param endTimeOffset If specified, monitoring jobs substract this time from the end time.
             *                      For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTimeOffset(java.lang.String endTimeOffset) {
                this.endTimeOffset = endTimeOffset;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getInferenceAttribute}
             * @param inferenceAttribute The attribute of the input data that represents the ground truth label.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceAttribute(java.lang.String inferenceAttribute) {
                this.inferenceAttribute = inferenceAttribute;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getProbabilityAttribute}
             * @param probabilityAttribute In a classification problem, the attribute that represents the class probability.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder probabilityAttribute(java.lang.String probabilityAttribute) {
                this.probabilityAttribute = probabilityAttribute;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getProbabilityThresholdAttribute}
             * @param probabilityThresholdAttribute The threshold for the class probability to be evaluated as a positive result.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder probabilityThresholdAttribute(java.lang.Number probabilityThresholdAttribute) {
                this.probabilityThresholdAttribute = probabilityThresholdAttribute;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getS3DataDistributionType}
             * @param s3DataDistributionType Whether input data distributed in Amazon S3 is fully replicated or sharded by an Amazon S3 key.
             *                               Defaults to <code>FullyReplicated</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3DataDistributionType(java.lang.String s3DataDistributionType) {
                this.s3DataDistributionType = s3DataDistributionType;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getS3InputMode}
             * @param s3InputMode Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for the monitoring job.
             *                    <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to <code>File</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputMode(java.lang.String s3InputMode) {
                this.s3InputMode = s3InputMode;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getStartTimeOffset}
             * @param startTimeOffset If specified, monitoring jobs substract this time from the start time.
             *                        For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTimeOffset(java.lang.String startTimeOffset) {
                this.startTimeOffset = startTimeOffset;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EndpointInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EndpointInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointInputProperty {
            private final java.lang.String endpointName;
            private final java.lang.String localPath;
            private final java.lang.String endTimeOffset;
            private final java.lang.String inferenceAttribute;
            private final java.lang.String probabilityAttribute;
            private final java.lang.Number probabilityThresholdAttribute;
            private final java.lang.String s3DataDistributionType;
            private final java.lang.String s3InputMode;
            private final java.lang.String startTimeOffset;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpointName = software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localPath = software.amazon.jsii.Kernel.get(this, "localPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endTimeOffset = software.amazon.jsii.Kernel.get(this, "endTimeOffset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inferenceAttribute = software.amazon.jsii.Kernel.get(this, "inferenceAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.probabilityAttribute = software.amazon.jsii.Kernel.get(this, "probabilityAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.probabilityThresholdAttribute = software.amazon.jsii.Kernel.get(this, "probabilityThresholdAttribute", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.s3DataDistributionType = software.amazon.jsii.Kernel.get(this, "s3DataDistributionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3InputMode = software.amazon.jsii.Kernel.get(this, "s3InputMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startTimeOffset = software.amazon.jsii.Kernel.get(this, "startTimeOffset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpointName = java.util.Objects.requireNonNull(builder.endpointName, "endpointName is required");
                this.localPath = java.util.Objects.requireNonNull(builder.localPath, "localPath is required");
                this.endTimeOffset = builder.endTimeOffset;
                this.inferenceAttribute = builder.inferenceAttribute;
                this.probabilityAttribute = builder.probabilityAttribute;
                this.probabilityThresholdAttribute = builder.probabilityThresholdAttribute;
                this.s3DataDistributionType = builder.s3DataDistributionType;
                this.s3InputMode = builder.s3InputMode;
                this.startTimeOffset = builder.startTimeOffset;
            }

            @Override
            public final java.lang.String getEndpointName() {
                return this.endpointName;
            }

            @Override
            public final java.lang.String getLocalPath() {
                return this.localPath;
            }

            @Override
            public final java.lang.String getEndTimeOffset() {
                return this.endTimeOffset;
            }

            @Override
            public final java.lang.String getInferenceAttribute() {
                return this.inferenceAttribute;
            }

            @Override
            public final java.lang.String getProbabilityAttribute() {
                return this.probabilityAttribute;
            }

            @Override
            public final java.lang.Number getProbabilityThresholdAttribute() {
                return this.probabilityThresholdAttribute;
            }

            @Override
            public final java.lang.String getS3DataDistributionType() {
                return this.s3DataDistributionType;
            }

            @Override
            public final java.lang.String getS3InputMode() {
                return this.s3InputMode;
            }

            @Override
            public final java.lang.String getStartTimeOffset() {
                return this.startTimeOffset;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endpointName", om.valueToTree(this.getEndpointName()));
                data.set("localPath", om.valueToTree(this.getLocalPath()));
                if (this.getEndTimeOffset() != null) {
                    data.set("endTimeOffset", om.valueToTree(this.getEndTimeOffset()));
                }
                if (this.getInferenceAttribute() != null) {
                    data.set("inferenceAttribute", om.valueToTree(this.getInferenceAttribute()));
                }
                if (this.getProbabilityAttribute() != null) {
                    data.set("probabilityAttribute", om.valueToTree(this.getProbabilityAttribute()));
                }
                if (this.getProbabilityThresholdAttribute() != null) {
                    data.set("probabilityThresholdAttribute", om.valueToTree(this.getProbabilityThresholdAttribute()));
                }
                if (this.getS3DataDistributionType() != null) {
                    data.set("s3DataDistributionType", om.valueToTree(this.getS3DataDistributionType()));
                }
                if (this.getS3InputMode() != null) {
                    data.set("s3InputMode", om.valueToTree(this.getS3InputMode()));
                }
                if (this.getStartTimeOffset() != null) {
                    data.set("startTimeOffset", om.valueToTree(this.getStartTimeOffset()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.EndpointInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EndpointInputProperty.Jsii$Proxy that = (EndpointInputProperty.Jsii$Proxy) o;

                if (!endpointName.equals(that.endpointName)) return false;
                if (!localPath.equals(that.localPath)) return false;
                if (this.endTimeOffset != null ? !this.endTimeOffset.equals(that.endTimeOffset) : that.endTimeOffset != null) return false;
                if (this.inferenceAttribute != null ? !this.inferenceAttribute.equals(that.inferenceAttribute) : that.inferenceAttribute != null) return false;
                if (this.probabilityAttribute != null ? !this.probabilityAttribute.equals(that.probabilityAttribute) : that.probabilityAttribute != null) return false;
                if (this.probabilityThresholdAttribute != null ? !this.probabilityThresholdAttribute.equals(that.probabilityThresholdAttribute) : that.probabilityThresholdAttribute != null) return false;
                if (this.s3DataDistributionType != null ? !this.s3DataDistributionType.equals(that.s3DataDistributionType) : that.s3DataDistributionType != null) return false;
                if (this.s3InputMode != null ? !this.s3InputMode.equals(that.s3InputMode) : that.s3InputMode != null) return false;
                return this.startTimeOffset != null ? this.startTimeOffset.equals(that.startTimeOffset) : that.startTimeOffset == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endpointName.hashCode();
                result = 31 * result + (this.localPath.hashCode());
                result = 31 * result + (this.endTimeOffset != null ? this.endTimeOffset.hashCode() : 0);
                result = 31 * result + (this.inferenceAttribute != null ? this.inferenceAttribute.hashCode() : 0);
                result = 31 * result + (this.probabilityAttribute != null ? this.probabilityAttribute.hashCode() : 0);
                result = 31 * result + (this.probabilityThresholdAttribute != null ? this.probabilityThresholdAttribute.hashCode() : 0);
                result = 31 * result + (this.s3DataDistributionType != null ? this.s3DataDistributionType.hashCode() : 0);
                result = 31 * result + (this.s3InputMode != null ? this.s3InputMode.hashCode() : 0);
                result = 31 * result + (this.startTimeOffset != null ? this.startTimeOffset.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Json format.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * JsonProperty jsonProperty = JsonProperty.builder()
     *         .line(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-json.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-json.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.JsonProperty")
    @software.amazon.jsii.Jsii.Proxy(JsonProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JsonProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A boolean flag indicating if it is JSON line format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-json.html#cfn-sagemaker-modelqualityjobdefinition-json-line">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-json.html#cfn-sagemaker-modelqualityjobdefinition-json-line</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLine() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JsonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JsonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JsonProperty> {
            java.lang.Object line;

            /**
             * Sets the value of {@link JsonProperty#getLine}
             * @param line A boolean flag indicating if it is JSON line format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder line(java.lang.Boolean line) {
                this.line = line;
                return this;
            }

            /**
             * Sets the value of {@link JsonProperty#getLine}
             * @param line A boolean flag indicating if it is JSON line format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder line(software.amazon.awscdk.IResolvable line) {
                this.line = line;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JsonProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JsonProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JsonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonProperty {
            private final java.lang.Object line;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.line = software.amazon.jsii.Kernel.get(this, "line", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.line = builder.line;
            }

            @Override
            public final java.lang.Object getLine() {
                return this.line;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLine() != null) {
                    data.set("line", om.valueToTree(this.getLine()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.JsonProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JsonProperty.Jsii$Proxy that = (JsonProperty.Jsii$Proxy) o;

                return this.line != null ? this.line.equals(that.line) : that.line == null;
            }

            @Override
            public final int hashCode() {
                int result = this.line != null ? this.line.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Container image configuration object for the monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ModelQualityAppSpecificationProperty modelQualityAppSpecificationProperty = ModelQualityAppSpecificationProperty.builder()
     *         .imageUri("imageUri")
     *         .problemType("problemType")
     *         // the properties below are optional
     *         .containerArguments(List.of("containerArguments"))
     *         .containerEntrypoint(List.of("containerEntrypoint"))
     *         .environment(Map.of(
     *                 "environmentKey", "environment"))
     *         .postAnalyticsProcessorSourceUri("postAnalyticsProcessorSourceUri")
     *         .recordPreprocessorSourceUri("recordPreprocessorSourceUri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ModelQualityAppSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModelQualityAppSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The address of the container image that the monitoring job runs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-imageuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-imageuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageUri();

        /**
         * The machine learning problem type of the model that the monitoring job monitors.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-problemtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-problemtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProblemType();

        /**
         * An array of arguments for the container used to run the monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-containerarguments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-containerarguments</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getContainerArguments() {
            return null;
        }

        /**
         * Specifies the entrypoint for a container that the monitoring job runs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-containerentrypoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-containerentrypoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getContainerEntrypoint() {
            return null;
        }

        /**
         * Sets the environment variables in the container that the monitoring job runs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-environment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-environment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * An Amazon S3 URI to a script that is called after analysis has been performed.
         * <p>
         * Applicable only for the built-in (first party) containers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-postanalyticsprocessorsourceuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-postanalyticsprocessorsourceuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPostAnalyticsProcessorSourceUri() {
            return null;
        }

        /**
         * An Amazon S3 URI to a script that is called per row prior to running analysis.
         * <p>
         * It can base64 decode the payload and convert it into a flattened JSON so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-recordpreprocessorsourceuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-recordpreprocessorsourceuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRecordPreprocessorSourceUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ModelQualityAppSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModelQualityAppSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModelQualityAppSpecificationProperty> {
            java.lang.String imageUri;
            java.lang.String problemType;
            java.util.List<java.lang.String> containerArguments;
            java.util.List<java.lang.String> containerEntrypoint;
            java.lang.Object environment;
            java.lang.String postAnalyticsProcessorSourceUri;
            java.lang.String recordPreprocessorSourceUri;

            /**
             * Sets the value of {@link ModelQualityAppSpecificationProperty#getImageUri}
             * @param imageUri The address of the container image that the monitoring job runs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageUri(java.lang.String imageUri) {
                this.imageUri = imageUri;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityAppSpecificationProperty#getProblemType}
             * @param problemType The machine learning problem type of the model that the monitoring job monitors. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder problemType(java.lang.String problemType) {
                this.problemType = problemType;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityAppSpecificationProperty#getContainerArguments}
             * @param containerArguments An array of arguments for the container used to run the monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerArguments(java.util.List<java.lang.String> containerArguments) {
                this.containerArguments = containerArguments;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityAppSpecificationProperty#getContainerEntrypoint}
             * @param containerEntrypoint Specifies the entrypoint for a container that the monitoring job runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerEntrypoint(java.util.List<java.lang.String> containerEntrypoint) {
                this.containerEntrypoint = containerEntrypoint;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityAppSpecificationProperty#getEnvironment}
             * @param environment Sets the environment variables in the container that the monitoring job runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityAppSpecificationProperty#getEnvironment}
             * @param environment Sets the environment variables in the container that the monitoring job runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityAppSpecificationProperty#getPostAnalyticsProcessorSourceUri}
             * @param postAnalyticsProcessorSourceUri An Amazon S3 URI to a script that is called after analysis has been performed.
             *                                        Applicable only for the built-in (first party) containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postAnalyticsProcessorSourceUri(java.lang.String postAnalyticsProcessorSourceUri) {
                this.postAnalyticsProcessorSourceUri = postAnalyticsProcessorSourceUri;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityAppSpecificationProperty#getRecordPreprocessorSourceUri}
             * @param recordPreprocessorSourceUri An Amazon S3 URI to a script that is called per row prior to running analysis.
             *                                    It can base64 decode the payload and convert it into a flattened JSON so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordPreprocessorSourceUri(java.lang.String recordPreprocessorSourceUri) {
                this.recordPreprocessorSourceUri = recordPreprocessorSourceUri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModelQualityAppSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModelQualityAppSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModelQualityAppSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelQualityAppSpecificationProperty {
            private final java.lang.String imageUri;
            private final java.lang.String problemType;
            private final java.util.List<java.lang.String> containerArguments;
            private final java.util.List<java.lang.String> containerEntrypoint;
            private final java.lang.Object environment;
            private final java.lang.String postAnalyticsProcessorSourceUri;
            private final java.lang.String recordPreprocessorSourceUri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.imageUri = software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.problemType = software.amazon.jsii.Kernel.get(this, "problemType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerArguments = software.amazon.jsii.Kernel.get(this, "containerArguments", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.containerEntrypoint = software.amazon.jsii.Kernel.get(this, "containerEntrypoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.postAnalyticsProcessorSourceUri = software.amazon.jsii.Kernel.get(this, "postAnalyticsProcessorSourceUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recordPreprocessorSourceUri = software.amazon.jsii.Kernel.get(this, "recordPreprocessorSourceUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.imageUri = java.util.Objects.requireNonNull(builder.imageUri, "imageUri is required");
                this.problemType = java.util.Objects.requireNonNull(builder.problemType, "problemType is required");
                this.containerArguments = builder.containerArguments;
                this.containerEntrypoint = builder.containerEntrypoint;
                this.environment = builder.environment;
                this.postAnalyticsProcessorSourceUri = builder.postAnalyticsProcessorSourceUri;
                this.recordPreprocessorSourceUri = builder.recordPreprocessorSourceUri;
            }

            @Override
            public final java.lang.String getImageUri() {
                return this.imageUri;
            }

            @Override
            public final java.lang.String getProblemType() {
                return this.problemType;
            }

            @Override
            public final java.util.List<java.lang.String> getContainerArguments() {
                return this.containerArguments;
            }

            @Override
            public final java.util.List<java.lang.String> getContainerEntrypoint() {
                return this.containerEntrypoint;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.String getPostAnalyticsProcessorSourceUri() {
                return this.postAnalyticsProcessorSourceUri;
            }

            @Override
            public final java.lang.String getRecordPreprocessorSourceUri() {
                return this.recordPreprocessorSourceUri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("imageUri", om.valueToTree(this.getImageUri()));
                data.set("problemType", om.valueToTree(this.getProblemType()));
                if (this.getContainerArguments() != null) {
                    data.set("containerArguments", om.valueToTree(this.getContainerArguments()));
                }
                if (this.getContainerEntrypoint() != null) {
                    data.set("containerEntrypoint", om.valueToTree(this.getContainerEntrypoint()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getPostAnalyticsProcessorSourceUri() != null) {
                    data.set("postAnalyticsProcessorSourceUri", om.valueToTree(this.getPostAnalyticsProcessorSourceUri()));
                }
                if (this.getRecordPreprocessorSourceUri() != null) {
                    data.set("recordPreprocessorSourceUri", om.valueToTree(this.getRecordPreprocessorSourceUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModelQualityAppSpecificationProperty.Jsii$Proxy that = (ModelQualityAppSpecificationProperty.Jsii$Proxy) o;

                if (!imageUri.equals(that.imageUri)) return false;
                if (!problemType.equals(that.problemType)) return false;
                if (this.containerArguments != null ? !this.containerArguments.equals(that.containerArguments) : that.containerArguments != null) return false;
                if (this.containerEntrypoint != null ? !this.containerEntrypoint.equals(that.containerEntrypoint) : that.containerEntrypoint != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.postAnalyticsProcessorSourceUri != null ? !this.postAnalyticsProcessorSourceUri.equals(that.postAnalyticsProcessorSourceUri) : that.postAnalyticsProcessorSourceUri != null) return false;
                return this.recordPreprocessorSourceUri != null ? this.recordPreprocessorSourceUri.equals(that.recordPreprocessorSourceUri) : that.recordPreprocessorSourceUri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.imageUri.hashCode();
                result = 31 * result + (this.problemType.hashCode());
                result = 31 * result + (this.containerArguments != null ? this.containerArguments.hashCode() : 0);
                result = 31 * result + (this.containerEntrypoint != null ? this.containerEntrypoint.hashCode() : 0);
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.postAnalyticsProcessorSourceUri != null ? this.postAnalyticsProcessorSourceUri.hashCode() : 0);
                result = 31 * result + (this.recordPreprocessorSourceUri != null ? this.recordPreprocessorSourceUri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for monitoring constraints and monitoring statistics.
     * <p>
     * These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ModelQualityBaselineConfigProperty modelQualityBaselineConfigProperty = ModelQualityBaselineConfigProperty.builder()
     *         .baseliningJobName("baseliningJobName")
     *         .constraintsResource(ConstraintsResourceProperty.builder()
     *                 .s3Uri("s3Uri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.ModelQualityBaselineConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ModelQualityBaselineConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModelQualityBaselineConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the job that performs baselining for the monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig-baseliningjobname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig-baseliningjobname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBaseliningJobName() {
            return null;
        }

        /**
         * The constraints resource for a monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig-constraintsresource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig-constraintsresource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConstraintsResource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ModelQualityBaselineConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModelQualityBaselineConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModelQualityBaselineConfigProperty> {
            java.lang.String baseliningJobName;
            java.lang.Object constraintsResource;

            /**
             * Sets the value of {@link ModelQualityBaselineConfigProperty#getBaseliningJobName}
             * @param baseliningJobName The name of the job that performs baselining for the monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseliningJobName(java.lang.String baseliningJobName) {
                this.baseliningJobName = baseliningJobName;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityBaselineConfigProperty#getConstraintsResource}
             * @param constraintsResource The constraints resource for a monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraintsResource(software.amazon.awscdk.IResolvable constraintsResource) {
                this.constraintsResource = constraintsResource;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityBaselineConfigProperty#getConstraintsResource}
             * @param constraintsResource The constraints resource for a monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraintsResource(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.ConstraintsResourceProperty constraintsResource) {
                this.constraintsResource = constraintsResource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModelQualityBaselineConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModelQualityBaselineConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModelQualityBaselineConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelQualityBaselineConfigProperty {
            private final java.lang.String baseliningJobName;
            private final java.lang.Object constraintsResource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.baseliningJobName = software.amazon.jsii.Kernel.get(this, "baseliningJobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.constraintsResource = software.amazon.jsii.Kernel.get(this, "constraintsResource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.baseliningJobName = builder.baseliningJobName;
                this.constraintsResource = builder.constraintsResource;
            }

            @Override
            public final java.lang.String getBaseliningJobName() {
                return this.baseliningJobName;
            }

            @Override
            public final java.lang.Object getConstraintsResource() {
                return this.constraintsResource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBaseliningJobName() != null) {
                    data.set("baseliningJobName", om.valueToTree(this.getBaseliningJobName()));
                }
                if (this.getConstraintsResource() != null) {
                    data.set("constraintsResource", om.valueToTree(this.getConstraintsResource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.ModelQualityBaselineConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModelQualityBaselineConfigProperty.Jsii$Proxy that = (ModelQualityBaselineConfigProperty.Jsii$Proxy) o;

                if (this.baseliningJobName != null ? !this.baseliningJobName.equals(that.baseliningJobName) : that.baseliningJobName != null) return false;
                return this.constraintsResource != null ? this.constraintsResource.equals(that.constraintsResource) : that.constraintsResource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.baseliningJobName != null ? this.baseliningJobName.hashCode() : 0;
                result = 31 * result + (this.constraintsResource != null ? this.constraintsResource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The input for the model quality monitoring job.
     * <p>
     * Currently endpoints are supported for input for model quality monitoring jobs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ModelQualityJobInputProperty modelQualityJobInputProperty = ModelQualityJobInputProperty.builder()
     *         .groundTruthS3Input(MonitoringGroundTruthS3InputProperty.builder()
     *                 .s3Uri("s3Uri")
     *                 .build())
     *         // the properties below are optional
     *         .batchTransformInput(BatchTransformInputProperty.builder()
     *                 .dataCapturedDestinationS3Uri("dataCapturedDestinationS3Uri")
     *                 .datasetFormat(DatasetFormatProperty.builder()
     *                         .csv(CsvProperty.builder()
     *                                 .header(false)
     *                                 .build())
     *                         .json(JsonProperty.builder()
     *                                 .line(false)
     *                                 .build())
     *                         .parquet(false)
     *                         .build())
     *                 .localPath("localPath")
     *                 // the properties below are optional
     *                 .endTimeOffset("endTimeOffset")
     *                 .inferenceAttribute("inferenceAttribute")
     *                 .probabilityAttribute("probabilityAttribute")
     *                 .probabilityThresholdAttribute(123)
     *                 .s3DataDistributionType("s3DataDistributionType")
     *                 .s3InputMode("s3InputMode")
     *                 .startTimeOffset("startTimeOffset")
     *                 .build())
     *         .endpointInput(EndpointInputProperty.builder()
     *                 .endpointName("endpointName")
     *                 .localPath("localPath")
     *                 // the properties below are optional
     *                 .endTimeOffset("endTimeOffset")
     *                 .inferenceAttribute("inferenceAttribute")
     *                 .probabilityAttribute("probabilityAttribute")
     *                 .probabilityThresholdAttribute(123)
     *                 .s3DataDistributionType("s3DataDistributionType")
     *                 .s3InputMode("s3InputMode")
     *                 .startTimeOffset("startTimeOffset")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityjobinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityjobinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.ModelQualityJobInputProperty")
    @software.amazon.jsii.Jsii.Proxy(ModelQualityJobInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModelQualityJobInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ground truth label provided for the model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityjobinput.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput-groundtruths3input">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityjobinput.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput-groundtruths3input</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getGroundTruthS3Input();

        /**
         * Input object for the batch transform job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityjobinput.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput-batchtransforminput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityjobinput.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput-batchtransforminput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBatchTransformInput() {
            return null;
        }

        /**
         * Input object for the endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityjobinput.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput-endpointinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityjobinput.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput-endpointinput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEndpointInput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ModelQualityJobInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModelQualityJobInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModelQualityJobInputProperty> {
            java.lang.Object groundTruthS3Input;
            java.lang.Object batchTransformInput;
            java.lang.Object endpointInput;

            /**
             * Sets the value of {@link ModelQualityJobInputProperty#getGroundTruthS3Input}
             * @param groundTruthS3Input The ground truth label provided for the model. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groundTruthS3Input(software.amazon.awscdk.IResolvable groundTruthS3Input) {
                this.groundTruthS3Input = groundTruthS3Input;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityJobInputProperty#getGroundTruthS3Input}
             * @param groundTruthS3Input The ground truth label provided for the model. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groundTruthS3Input(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.MonitoringGroundTruthS3InputProperty groundTruthS3Input) {
                this.groundTruthS3Input = groundTruthS3Input;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityJobInputProperty#getBatchTransformInput}
             * @param batchTransformInput Input object for the batch transform job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchTransformInput(software.amazon.awscdk.IResolvable batchTransformInput) {
                this.batchTransformInput = batchTransformInput;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityJobInputProperty#getBatchTransformInput}
             * @param batchTransformInput Input object for the batch transform job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchTransformInput(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.BatchTransformInputProperty batchTransformInput) {
                this.batchTransformInput = batchTransformInput;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityJobInputProperty#getEndpointInput}
             * @param endpointInput Input object for the endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointInput(software.amazon.awscdk.IResolvable endpointInput) {
                this.endpointInput = endpointInput;
                return this;
            }

            /**
             * Sets the value of {@link ModelQualityJobInputProperty#getEndpointInput}
             * @param endpointInput Input object for the endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointInput(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.EndpointInputProperty endpointInput) {
                this.endpointInput = endpointInput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModelQualityJobInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModelQualityJobInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModelQualityJobInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelQualityJobInputProperty {
            private final java.lang.Object groundTruthS3Input;
            private final java.lang.Object batchTransformInput;
            private final java.lang.Object endpointInput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groundTruthS3Input = software.amazon.jsii.Kernel.get(this, "groundTruthS3Input", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.batchTransformInput = software.amazon.jsii.Kernel.get(this, "batchTransformInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.endpointInput = software.amazon.jsii.Kernel.get(this, "endpointInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groundTruthS3Input = java.util.Objects.requireNonNull(builder.groundTruthS3Input, "groundTruthS3Input is required");
                this.batchTransformInput = builder.batchTransformInput;
                this.endpointInput = builder.endpointInput;
            }

            @Override
            public final java.lang.Object getGroundTruthS3Input() {
                return this.groundTruthS3Input;
            }

            @Override
            public final java.lang.Object getBatchTransformInput() {
                return this.batchTransformInput;
            }

            @Override
            public final java.lang.Object getEndpointInput() {
                return this.endpointInput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("groundTruthS3Input", om.valueToTree(this.getGroundTruthS3Input()));
                if (this.getBatchTransformInput() != null) {
                    data.set("batchTransformInput", om.valueToTree(this.getBatchTransformInput()));
                }
                if (this.getEndpointInput() != null) {
                    data.set("endpointInput", om.valueToTree(this.getEndpointInput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.ModelQualityJobInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModelQualityJobInputProperty.Jsii$Proxy that = (ModelQualityJobInputProperty.Jsii$Proxy) o;

                if (!groundTruthS3Input.equals(that.groundTruthS3Input)) return false;
                if (this.batchTransformInput != null ? !this.batchTransformInput.equals(that.batchTransformInput) : that.batchTransformInput != null) return false;
                return this.endpointInput != null ? this.endpointInput.equals(that.endpointInput) : that.endpointInput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.groundTruthS3Input.hashCode();
                result = 31 * result + (this.batchTransformInput != null ? this.batchTransformInput.hashCode() : 0);
                result = 31 * result + (this.endpointInput != null ? this.endpointInput.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The ground truth labels for the dataset used for the monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringGroundTruthS3InputProperty monitoringGroundTruthS3InputProperty = MonitoringGroundTruthS3InputProperty.builder()
     *         .s3Uri("s3Uri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringgroundtruths3input.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringgroundtruths3input.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.MonitoringGroundTruthS3InputProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringGroundTruthS3InputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringGroundTruthS3InputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The address of the Amazon S3 location of the ground truth labels.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringgroundtruths3input.html#cfn-sagemaker-modelqualityjobdefinition-monitoringgroundtruths3input-s3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringgroundtruths3input.html#cfn-sagemaker-modelqualityjobdefinition-monitoringgroundtruths3input-s3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Uri();

        /**
         * @return a {@link Builder} of {@link MonitoringGroundTruthS3InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringGroundTruthS3InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringGroundTruthS3InputProperty> {
            java.lang.String s3Uri;

            /**
             * Sets the value of {@link MonitoringGroundTruthS3InputProperty#getS3Uri}
             * @param s3Uri The address of the Amazon S3 location of the ground truth labels. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringGroundTruthS3InputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringGroundTruthS3InputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringGroundTruthS3InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringGroundTruthS3InputProperty {
            private final java.lang.String s3Uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Uri = java.util.Objects.requireNonNull(builder.s3Uri, "s3Uri is required");
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Uri", om.valueToTree(this.getS3Uri()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.MonitoringGroundTruthS3InputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringGroundTruthS3InputProperty.Jsii$Proxy that = (MonitoringGroundTruthS3InputProperty.Jsii$Proxy) o;

                return this.s3Uri.equals(that.s3Uri);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Uri.hashCode();
                return result;
            }
        }
    }
    /**
     * The output configuration for monitoring jobs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringOutputConfigProperty monitoringOutputConfigProperty = MonitoringOutputConfigProperty.builder()
     *         .monitoringOutputs(List.of(MonitoringOutputProperty.builder()
     *                 .s3Output(S3OutputProperty.builder()
     *                         .localPath("localPath")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .s3UploadMode("s3UploadMode")
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutputconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutputconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.MonitoringOutputConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringOutputConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringOutputConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Monitoring outputs for monitoring jobs.
         * <p>
         * This is where the output of the periodic monitoring jobs is uploaded.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelqualityjobdefinition-monitoringoutputconfig-monitoringoutputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelqualityjobdefinition-monitoringoutputconfig-monitoringoutputs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringOutputs();

        /**
         * The AWS Key Management Service ( AWS KMS ) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelqualityjobdefinition-monitoringoutputconfig-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelqualityjobdefinition-monitoringoutputconfig-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringOutputConfigProperty> {
            java.lang.Object monitoringOutputs;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link MonitoringOutputConfigProperty#getMonitoringOutputs}
             * @param monitoringOutputs Monitoring outputs for monitoring jobs. This parameter is required.
             *                          This is where the output of the periodic monitoring jobs is uploaded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringOutputs(software.amazon.awscdk.IResolvable monitoringOutputs) {
                this.monitoringOutputs = monitoringOutputs;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringOutputConfigProperty#getMonitoringOutputs}
             * @param monitoringOutputs Monitoring outputs for monitoring jobs. This parameter is required.
             *                          This is where the output of the periodic monitoring jobs is uploaded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringOutputs(java.util.List<? extends java.lang.Object> monitoringOutputs) {
                this.monitoringOutputs = monitoringOutputs;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringOutputConfigProperty#getKmsKeyId}
             * @param kmsKeyId The AWS Key Management Service ( AWS KMS ) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringOutputConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringOutputConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringOutputConfigProperty {
            private final java.lang.Object monitoringOutputs;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.monitoringOutputs = software.amazon.jsii.Kernel.get(this, "monitoringOutputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.monitoringOutputs = java.util.Objects.requireNonNull(builder.monitoringOutputs, "monitoringOutputs is required");
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.Object getMonitoringOutputs() {
                return this.monitoringOutputs;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("monitoringOutputs", om.valueToTree(this.getMonitoringOutputs()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.MonitoringOutputConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringOutputConfigProperty.Jsii$Proxy that = (MonitoringOutputConfigProperty.Jsii$Proxy) o;

                if (!monitoringOutputs.equals(that.monitoringOutputs)) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.monitoringOutputs.hashCode();
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The output object for a monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringOutputProperty monitoringOutputProperty = MonitoringOutputProperty.builder()
     *         .s3Output(S3OutputProperty.builder()
     *                 .localPath("localPath")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .s3UploadMode("s3UploadMode")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.MonitoringOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 storage location where the results of a monitoring job are saved.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutput.html#cfn-sagemaker-modelqualityjobdefinition-monitoringoutput-s3output">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutput.html#cfn-sagemaker-modelqualityjobdefinition-monitoringoutput-s3output</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Output();

        /**
         * @return a {@link Builder} of {@link MonitoringOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringOutputProperty> {
            java.lang.Object s3Output;

            /**
             * Sets the value of {@link MonitoringOutputProperty#getS3Output}
             * @param s3Output The Amazon S3 storage location where the results of a monitoring job are saved. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Output(software.amazon.awscdk.IResolvable s3Output) {
                this.s3Output = s3Output;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringOutputProperty#getS3Output}
             * @param s3Output The Amazon S3 storage location where the results of a monitoring job are saved. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Output(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.S3OutputProperty s3Output) {
                this.s3Output = s3Output;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringOutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringOutputProperty {
            private final java.lang.Object s3Output;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Output = software.amazon.jsii.Kernel.get(this, "s3Output", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Output = java.util.Objects.requireNonNull(builder.s3Output, "s3Output is required");
            }

            @Override
            public final java.lang.Object getS3Output() {
                return this.s3Output;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Output", om.valueToTree(this.getS3Output()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.MonitoringOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringOutputProperty.Jsii$Proxy that = (MonitoringOutputProperty.Jsii$Proxy) o;

                return this.s3Output.equals(that.s3Output);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Output.hashCode();
                return result;
            }
        }
    }
    /**
     * Identifies the resources to deploy for a monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringResourcesProperty monitoringResourcesProperty = MonitoringResourcesProperty.builder()
     *         .clusterConfig(ClusterConfigProperty.builder()
     *                 .instanceCount(123)
     *                 .instanceType("instanceType")
     *                 .volumeSizeInGb(123)
     *                 // the properties below are optional
     *                 .volumeKmsKeyId("volumeKmsKeyId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringresources.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringresources.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.MonitoringResourcesProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringResourcesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringResourcesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration for the cluster resources used to run the processing job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringresources.html#cfn-sagemaker-modelqualityjobdefinition-monitoringresources-clusterconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringresources.html#cfn-sagemaker-modelqualityjobdefinition-monitoringresources-clusterconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getClusterConfig();

        /**
         * @return a {@link Builder} of {@link MonitoringResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringResourcesProperty> {
            java.lang.Object clusterConfig;

            /**
             * Sets the value of {@link MonitoringResourcesProperty#getClusterConfig}
             * @param clusterConfig The configuration for the cluster resources used to run the processing job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterConfig(software.amazon.awscdk.IResolvable clusterConfig) {
                this.clusterConfig = clusterConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringResourcesProperty#getClusterConfig}
             * @param clusterConfig The configuration for the cluster resources used to run the processing job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterConfig(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.ClusterConfigProperty clusterConfig) {
                this.clusterConfig = clusterConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringResourcesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringResourcesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringResourcesProperty {
            private final java.lang.Object clusterConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterConfig = software.amazon.jsii.Kernel.get(this, "clusterConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterConfig = java.util.Objects.requireNonNull(builder.clusterConfig, "clusterConfig is required");
            }

            @Override
            public final java.lang.Object getClusterConfig() {
                return this.clusterConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterConfig", om.valueToTree(this.getClusterConfig()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.MonitoringResourcesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringResourcesProperty.Jsii$Proxy that = (MonitoringResourcesProperty.Jsii$Proxy) o;

                return this.clusterConfig.equals(that.clusterConfig);
            }

            @Override
            public final int hashCode() {
                int result = this.clusterConfig.hashCode();
                return result;
            }
        }
    }
    /**
     * Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * NetworkConfigProperty networkConfigProperty = NetworkConfigProperty.builder()
     *         .enableInterContainerTrafficEncryption(false)
     *         .enableNetworkIsolation(false)
     *         .vpcConfig(VpcConfigProperty.builder()
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .subnets(List.of("subnets"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.NetworkConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to encrypt all communications between distributed processing jobs.
         * <p>
         * Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig-enableintercontainertrafficencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig-enableintercontainertrafficencryption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableInterContainerTrafficEncryption() {
            return null;
        }

        /**
         * Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig-enablenetworkisolation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig-enablenetworkisolation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableNetworkIsolation() {
            return null;
        }

        /**
         * Specifies a VPC that your training jobs and hosted models have access to.
         * <p>
         * Control access to and from your training and model containers by configuring the VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig-vpcconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigProperty> {
            java.lang.Object enableInterContainerTrafficEncryption;
            java.lang.Object enableNetworkIsolation;
            java.lang.Object vpcConfig;

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableInterContainerTrafficEncryption}
             * @param enableInterContainerTrafficEncryption Whether to encrypt all communications between distributed processing jobs.
             *                                              Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableInterContainerTrafficEncryption(java.lang.Boolean enableInterContainerTrafficEncryption) {
                this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableInterContainerTrafficEncryption}
             * @param enableInterContainerTrafficEncryption Whether to encrypt all communications between distributed processing jobs.
             *                                              Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableInterContainerTrafficEncryption(software.amazon.awscdk.IResolvable enableInterContainerTrafficEncryption) {
                this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableNetworkIsolation}
             * @param enableNetworkIsolation Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableNetworkIsolation(java.lang.Boolean enableNetworkIsolation) {
                this.enableNetworkIsolation = enableNetworkIsolation;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableNetworkIsolation}
             * @param enableNetworkIsolation Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableNetworkIsolation(software.amazon.awscdk.IResolvable enableNetworkIsolation) {
                this.enableNetworkIsolation = enableNetworkIsolation;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getVpcConfig}
             * @param vpcConfig Specifies a VPC that your training jobs and hosted models have access to.
             *                  Control access to and from your training and model containers by configuring the VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfig(software.amazon.awscdk.IResolvable vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getVpcConfig}
             * @param vpcConfig Specifies a VPC that your training jobs and hosted models have access to.
             *                  Control access to and from your training and model containers by configuring the VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfig(software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.VpcConfigProperty vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigProperty {
            private final java.lang.Object enableInterContainerTrafficEncryption;
            private final java.lang.Object enableNetworkIsolation;
            private final java.lang.Object vpcConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableInterContainerTrafficEncryption = software.amazon.jsii.Kernel.get(this, "enableInterContainerTrafficEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableNetworkIsolation = software.amazon.jsii.Kernel.get(this, "enableNetworkIsolation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcConfig = software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
                this.enableNetworkIsolation = builder.enableNetworkIsolation;
                this.vpcConfig = builder.vpcConfig;
            }

            @Override
            public final java.lang.Object getEnableInterContainerTrafficEncryption() {
                return this.enableInterContainerTrafficEncryption;
            }

            @Override
            public final java.lang.Object getEnableNetworkIsolation() {
                return this.enableNetworkIsolation;
            }

            @Override
            public final java.lang.Object getVpcConfig() {
                return this.vpcConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableInterContainerTrafficEncryption() != null) {
                    data.set("enableInterContainerTrafficEncryption", om.valueToTree(this.getEnableInterContainerTrafficEncryption()));
                }
                if (this.getEnableNetworkIsolation() != null) {
                    data.set("enableNetworkIsolation", om.valueToTree(this.getEnableNetworkIsolation()));
                }
                if (this.getVpcConfig() != null) {
                    data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.NetworkConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigProperty.Jsii$Proxy that = (NetworkConfigProperty.Jsii$Proxy) o;

                if (this.enableInterContainerTrafficEncryption != null ? !this.enableInterContainerTrafficEncryption.equals(that.enableInterContainerTrafficEncryption) : that.enableInterContainerTrafficEncryption != null) return false;
                if (this.enableNetworkIsolation != null ? !this.enableNetworkIsolation.equals(that.enableNetworkIsolation) : that.enableNetworkIsolation != null) return false;
                return this.vpcConfig != null ? this.vpcConfig.equals(that.vpcConfig) : that.vpcConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableInterContainerTrafficEncryption != null ? this.enableInterContainerTrafficEncryption.hashCode() : 0;
                result = 31 * result + (this.enableNetworkIsolation != null ? this.enableNetworkIsolation.hashCode() : 0);
                result = 31 * result + (this.vpcConfig != null ? this.vpcConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amazon S3 storage location where the results of a monitoring job are saved.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * S3OutputProperty s3OutputProperty = S3OutputProperty.builder()
     *         .localPath("localPath")
     *         .s3Uri("s3Uri")
     *         // the properties below are optional
     *         .s3UploadMode("s3UploadMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.S3OutputProperty")
    @software.amazon.jsii.Jsii.Proxy(S3OutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3OutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
         * <p>
         * LocalPath is an absolute path for the output data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html#cfn-sagemaker-modelqualityjobdefinition-s3output-localpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html#cfn-sagemaker-modelqualityjobdefinition-s3output-localpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocalPath();

        /**
         * A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html#cfn-sagemaker-modelqualityjobdefinition-s3output-s3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html#cfn-sagemaker-modelqualityjobdefinition-s3output-s3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Uri();

        /**
         * Whether to upload the results of the monitoring job continuously or after the job completes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html#cfn-sagemaker-modelqualityjobdefinition-s3output-s3uploadmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html#cfn-sagemaker-modelqualityjobdefinition-s3output-s3uploadmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3UploadMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3OutputProperty> {
            java.lang.String localPath;
            java.lang.String s3Uri;
            java.lang.String s3UploadMode;

            /**
             * Sets the value of {@link S3OutputProperty#getLocalPath}
             * @param localPath The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. This parameter is required.
             *                  LocalPath is an absolute path for the output data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localPath(java.lang.String localPath) {
                this.localPath = localPath;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputProperty#getS3Uri}
             * @param s3Uri A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputProperty#getS3UploadMode}
             * @param s3UploadMode Whether to upload the results of the monitoring job continuously or after the job completes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3UploadMode(java.lang.String s3UploadMode) {
                this.s3UploadMode = s3UploadMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3OutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3OutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OutputProperty {
            private final java.lang.String localPath;
            private final java.lang.String s3Uri;
            private final java.lang.String s3UploadMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.localPath = software.amazon.jsii.Kernel.get(this, "localPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3UploadMode = software.amazon.jsii.Kernel.get(this, "s3UploadMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.localPath = java.util.Objects.requireNonNull(builder.localPath, "localPath is required");
                this.s3Uri = java.util.Objects.requireNonNull(builder.s3Uri, "s3Uri is required");
                this.s3UploadMode = builder.s3UploadMode;
            }

            @Override
            public final java.lang.String getLocalPath() {
                return this.localPath;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            public final java.lang.String getS3UploadMode() {
                return this.s3UploadMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("localPath", om.valueToTree(this.getLocalPath()));
                data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                if (this.getS3UploadMode() != null) {
                    data.set("s3UploadMode", om.valueToTree(this.getS3UploadMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.S3OutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3OutputProperty.Jsii$Proxy that = (S3OutputProperty.Jsii$Proxy) o;

                if (!localPath.equals(that.localPath)) return false;
                if (!s3Uri.equals(that.s3Uri)) return false;
                return this.s3UploadMode != null ? this.s3UploadMode.equals(that.s3UploadMode) : that.s3UploadMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.localPath.hashCode();
                result = 31 * result + (this.s3Uri.hashCode());
                result = 31 * result + (this.s3UploadMode != null ? this.s3UploadMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a limit to how long a model training job or model compilation job can run.
     * <p>
     * It also specifies how long a managed spot training job has to complete. When the job reaches the time limit, SageMaker ends the training or compilation job. Use this API to cap model training costs.
     * <p>
     * To stop a training job, SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.
     * <p>
     * The training algorithms provided by SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with <code>CreateModel</code> .
     * <p>
     * <blockquote>
     * <p>
     * The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * StoppingConditionProperty stoppingConditionProperty = StoppingConditionProperty.builder()
     *         .maxRuntimeInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-stoppingcondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-stoppingcondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.StoppingConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(StoppingConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StoppingConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum length of time, in seconds, that a training or compilation job can run before it is stopped.
         * <p>
         * For compilation jobs, if the job does not complete during this time, a <code>TimeOut</code> error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.
         * <p>
         * For all other jobs, if the job does not complete during this time, SageMaker ends the job. When <code>RetryStrategy</code> is specified in the job request, <code>MaxRuntimeInSeconds</code> specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.
         * <p>
         * The maximum time that a <code>TrainingJob</code> can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-stoppingcondition.html#cfn-sagemaker-modelqualityjobdefinition-stoppingcondition-maxruntimeinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-stoppingcondition.html#cfn-sagemaker-modelqualityjobdefinition-stoppingcondition-maxruntimeinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxRuntimeInSeconds();

        /**
         * @return a {@link Builder} of {@link StoppingConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StoppingConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StoppingConditionProperty> {
            java.lang.Number maxRuntimeInSeconds;

            /**
             * Sets the value of {@link StoppingConditionProperty#getMaxRuntimeInSeconds}
             * @param maxRuntimeInSeconds The maximum length of time, in seconds, that a training or compilation job can run before it is stopped. This parameter is required.
             *                            For compilation jobs, if the job does not complete during this time, a <code>TimeOut</code> error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.
             *                            <p>
             *                            For all other jobs, if the job does not complete during this time, SageMaker ends the job. When <code>RetryStrategy</code> is specified in the job request, <code>MaxRuntimeInSeconds</code> specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.
             *                            <p>
             *                            The maximum time that a <code>TrainingJob</code> can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRuntimeInSeconds(java.lang.Number maxRuntimeInSeconds) {
                this.maxRuntimeInSeconds = maxRuntimeInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StoppingConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StoppingConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StoppingConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StoppingConditionProperty {
            private final java.lang.Number maxRuntimeInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxRuntimeInSeconds = software.amazon.jsii.Kernel.get(this, "maxRuntimeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxRuntimeInSeconds = java.util.Objects.requireNonNull(builder.maxRuntimeInSeconds, "maxRuntimeInSeconds is required");
            }

            @Override
            public final java.lang.Number getMaxRuntimeInSeconds() {
                return this.maxRuntimeInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxRuntimeInSeconds", om.valueToTree(this.getMaxRuntimeInSeconds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.StoppingConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StoppingConditionProperty.Jsii$Proxy that = (StoppingConditionProperty.Jsii$Proxy) o;

                return this.maxRuntimeInSeconds.equals(that.maxRuntimeInSeconds);
            }

            @Override
            public final int hashCode() {
                int result = this.maxRuntimeInSeconds.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
     * <p>
     * You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * VpcConfigProperty vpcConfigProperty = VpcConfigProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnets(List.of("subnets"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-vpcconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-vpcconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.VpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The VPC security group IDs, in the form <code>sg-xxxxxxxx</code> .
         * <p>
         * Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-vpcconfig.html#cfn-sagemaker-modelqualityjobdefinition-vpcconfig-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-vpcconfig.html#cfn-sagemaker-modelqualityjobdefinition-vpcconfig-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * The ID of the subnets in the VPC to which you want to connect your training job or model.
         * <p>
         * For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported Instance Types and Availability Zones</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-vpcconfig.html#cfn-sagemaker-modelqualityjobdefinition-vpcconfig-subnets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-vpcconfig.html#cfn-sagemaker-modelqualityjobdefinition-vpcconfig-subnets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnets;

            /**
             * Sets the value of {@link VpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds The VPC security group IDs, in the form <code>sg-xxxxxxxx</code> . This parameter is required.
             *                         Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getSubnets}
             * @param subnets The ID of the subnets in the VPC to which you want to connect your training job or model. This parameter is required.
             *                For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported Instance Types and Availability Zones</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnets", om.valueToTree(this.getSubnets()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelQualityJobDefinition.VpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigProperty.Jsii$Proxy that = (VpcConfigProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnets.equals(that.subnets);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnets.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinitionProps.Builder();
        }

        /**
         * Identifies the resources to deploy for a monitoring job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-jobresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-jobresources</a>
         * @param jobResources Identifies the resources to deploy for a monitoring job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobResources(final software.amazon.awscdk.IResolvable jobResources) {
            this.props.jobResources(jobResources);
            return this;
        }
        /**
         * Identifies the resources to deploy for a monitoring job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-jobresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-jobresources</a>
         * @param jobResources Identifies the resources to deploy for a monitoring job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobResources(final software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.MonitoringResourcesProperty jobResources) {
            this.props.jobResources(jobResources);
            return this;
        }

        /**
         * Container image configuration object for the monitoring job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification</a>
         * @param modelQualityAppSpecification Container image configuration object for the monitoring job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityAppSpecification(final software.amazon.awscdk.IResolvable modelQualityAppSpecification) {
            this.props.modelQualityAppSpecification(modelQualityAppSpecification);
            return this;
        }
        /**
         * Container image configuration object for the monitoring job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification</a>
         * @param modelQualityAppSpecification Container image configuration object for the monitoring job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityAppSpecification(final software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty modelQualityAppSpecification) {
            this.props.modelQualityAppSpecification(modelQualityAppSpecification);
            return this;
        }

        /**
         * A list of the inputs that are monitored.
         * <p>
         * Currently endpoints are supported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput</a>
         * @param modelQualityJobInput A list of the inputs that are monitored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityJobInput(final software.amazon.awscdk.IResolvable modelQualityJobInput) {
            this.props.modelQualityJobInput(modelQualityJobInput);
            return this;
        }
        /**
         * A list of the inputs that are monitored.
         * <p>
         * Currently endpoints are supported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput</a>
         * @param modelQualityJobInput A list of the inputs that are monitored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityJobInput(final software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.ModelQualityJobInputProperty modelQualityJobInput) {
            this.props.modelQualityJobInput(modelQualityJobInput);
            return this;
        }

        /**
         * The output configuration for monitoring jobs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjoboutputconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjoboutputconfig</a>
         * @param modelQualityJobOutputConfig The output configuration for monitoring jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityJobOutputConfig(final software.amazon.awscdk.IResolvable modelQualityJobOutputConfig) {
            this.props.modelQualityJobOutputConfig(modelQualityJobOutputConfig);
            return this;
        }
        /**
         * The output configuration for monitoring jobs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjoboutputconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjoboutputconfig</a>
         * @param modelQualityJobOutputConfig The output configuration for monitoring jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityJobOutputConfig(final software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.MonitoringOutputConfigProperty modelQualityJobOutputConfig) {
            this.props.modelQualityJobOutputConfig(modelQualityJobOutputConfig);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The name of the endpoint used to run the monitoring job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-endpointname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-endpointname</a>
         * @param endpointName The name of the endpoint used to run the monitoring job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointName(final java.lang.String endpointName) {
            this.props.endpointName(endpointName);
            return this;
        }

        /**
         * The name of the monitoring job definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-jobdefinitionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-jobdefinitionname</a>
         * @param jobDefinitionName The name of the monitoring job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(final java.lang.String jobDefinitionName) {
            this.props.jobDefinitionName(jobDefinitionName);
            return this;
        }

        /**
         * Specifies the constraints and baselines for the monitoring job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig</a>
         * @param modelQualityBaselineConfig Specifies the constraints and baselines for the monitoring job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityBaselineConfig(final software.amazon.awscdk.IResolvable modelQualityBaselineConfig) {
            this.props.modelQualityBaselineConfig(modelQualityBaselineConfig);
            return this;
        }
        /**
         * Specifies the constraints and baselines for the monitoring job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig</a>
         * @param modelQualityBaselineConfig Specifies the constraints and baselines for the monitoring job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelQualityBaselineConfig(final software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.ModelQualityBaselineConfigProperty modelQualityBaselineConfig) {
            this.props.modelQualityBaselineConfig(modelQualityBaselineConfig);
            return this;
        }

        /**
         * Specifies the network configuration for the monitoring job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig</a>
         * @param networkConfig Specifies the network configuration for the monitoring job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(final software.amazon.awscdk.IResolvable networkConfig) {
            this.props.networkConfig(networkConfig);
            return this;
        }
        /**
         * Specifies the network configuration for the monitoring job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig</a>
         * @param networkConfig Specifies the network configuration for the monitoring job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(final software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.NetworkConfigProperty networkConfig) {
            this.props.networkConfig(networkConfig);
            return this;
        }

        /**
         * A time limit for how long the monitoring job is allowed to run before stopping.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-stoppingcondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-stoppingcondition</a>
         * @param stoppingCondition A time limit for how long the monitoring job is allowed to run before stopping. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(final software.amazon.awscdk.IResolvable stoppingCondition) {
            this.props.stoppingCondition(stoppingCondition);
            return this;
        }
        /**
         * A time limit for how long the monitoring job is allowed to run before stopping.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-stoppingcondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-stoppingcondition</a>
         * @param stoppingCondition A time limit for how long the monitoring job is allowed to run before stopping. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(final software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition.StoppingConditionProperty stoppingCondition) {
            this.props.stoppingCondition(stoppingCondition);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition build() {
            return new software.amazon.awscdk.services.sagemaker.CfnModelQualityJobDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
