package software.amazon.awscdk.services.servicecatalog;

/**
 * Result of binding <code>Template</code> into a <code>Product</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.servicecatalog.*;
 * Bucket bucket;
 * CloudFormationTemplateConfig cloudFormationTemplateConfig = CloudFormationTemplateConfig.builder()
 *         .httpUrl("httpUrl")
 *         // the properties below are optional
 *         .assetBucket(bucket)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:22:01.838Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicecatalog.CloudFormationTemplateConfig")
@software.amazon.jsii.Jsii.Proxy(CloudFormationTemplateConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CloudFormationTemplateConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The http url of the template in S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHttpUrl();

    /**
     * The S3 bucket containing product stack assets.
     * <p>
     * Default: - None - no assets are used in this product
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getAssetBucket() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CloudFormationTemplateConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudFormationTemplateConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CloudFormationTemplateConfig> {
        java.lang.String httpUrl;
        software.amazon.awscdk.services.s3.IBucket assetBucket;

        /**
         * Sets the value of {@link CloudFormationTemplateConfig#getHttpUrl}
         * @param httpUrl The http url of the template in S3. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpUrl(java.lang.String httpUrl) {
            this.httpUrl = httpUrl;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationTemplateConfig#getAssetBucket}
         * @param assetBucket The S3 bucket containing product stack assets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetBucket(software.amazon.awscdk.services.s3.IBucket assetBucket) {
            this.assetBucket = assetBucket;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudFormationTemplateConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CloudFormationTemplateConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudFormationTemplateConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudFormationTemplateConfig {
        private final java.lang.String httpUrl;
        private final software.amazon.awscdk.services.s3.IBucket assetBucket;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpUrl = software.amazon.jsii.Kernel.get(this, "httpUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetBucket = software.amazon.jsii.Kernel.get(this, "assetBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpUrl = java.util.Objects.requireNonNull(builder.httpUrl, "httpUrl is required");
            this.assetBucket = builder.assetBucket;
        }

        @Override
        public final java.lang.String getHttpUrl() {
            return this.httpUrl;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getAssetBucket() {
            return this.assetBucket;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("httpUrl", om.valueToTree(this.getHttpUrl()));
            if (this.getAssetBucket() != null) {
                data.set("assetBucket", om.valueToTree(this.getAssetBucket()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicecatalog.CloudFormationTemplateConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudFormationTemplateConfig.Jsii$Proxy that = (CloudFormationTemplateConfig.Jsii$Proxy) o;

            if (!httpUrl.equals(that.httpUrl)) return false;
            return this.assetBucket != null ? this.assetBucket.equals(that.assetBucket) : that.assetBucket == null;
        }

        @Override
        public final int hashCode() {
            int result = this.httpUrl.hashCode();
            result = 31 * result + (this.assetBucket != null ? this.assetBucket.hashCode() : 0);
            return result;
        }
    }
}
