package software.amazon.awscdk.services.servicediscovery;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicediscovery.*;
 * Service service;
 * AliasTargetInstanceProps aliasTargetInstanceProps = AliasTargetInstanceProps.builder()
 *         .dnsName("dnsName")
 *         .service(service)
 *         // the properties below are optional
 *         .customAttributes(Map.of(
 *                 "customAttributesKey", "customAttributes"))
 *         .instanceId("instanceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:22:01.857Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.AliasTargetInstanceProps")
@software.amazon.jsii.Jsii.Proxy(AliasTargetInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AliasTargetInstanceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.servicediscovery.BaseInstanceProps {

    /**
     * DNS name of the target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDnsName();

    /**
     * The Cloudmap service this resource is registered to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IService getService();

    /**
     * @return a {@link Builder} of {@link AliasTargetInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AliasTargetInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AliasTargetInstanceProps> {
        java.lang.String dnsName;
        software.amazon.awscdk.services.servicediscovery.IService service;
        java.util.Map<java.lang.String, java.lang.String> customAttributes;
        java.lang.String instanceId;

        /**
         * Sets the value of {@link AliasTargetInstanceProps#getDnsName}
         * @param dnsName DNS name of the target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsName(java.lang.String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        /**
         * Sets the value of {@link AliasTargetInstanceProps#getService}
         * @param service The Cloudmap service this resource is registered to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(software.amazon.awscdk.services.servicediscovery.IService service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link AliasTargetInstanceProps#getCustomAttributes}
         * @param customAttributes Custom attributes of the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customAttributes(java.util.Map<java.lang.String, java.lang.String> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        /**
         * Sets the value of {@link AliasTargetInstanceProps#getInstanceId}
         * @param instanceId The id of the instance resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AliasTargetInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AliasTargetInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AliasTargetInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AliasTargetInstanceProps {
        private final java.lang.String dnsName;
        private final software.amazon.awscdk.services.servicediscovery.IService service;
        private final java.util.Map<java.lang.String, java.lang.String> customAttributes;
        private final java.lang.String instanceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dnsName = software.amazon.jsii.Kernel.get(this, "dnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.IService.class));
            this.customAttributes = software.amazon.jsii.Kernel.get(this, "customAttributes", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.instanceId = software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dnsName = java.util.Objects.requireNonNull(builder.dnsName, "dnsName is required");
            this.service = java.util.Objects.requireNonNull(builder.service, "service is required");
            this.customAttributes = builder.customAttributes;
            this.instanceId = builder.instanceId;
        }

        @Override
        public final java.lang.String getDnsName() {
            return this.dnsName;
        }

        @Override
        public final software.amazon.awscdk.services.servicediscovery.IService getService() {
            return this.service;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getCustomAttributes() {
            return this.customAttributes;
        }

        @Override
        public final java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dnsName", om.valueToTree(this.getDnsName()));
            data.set("service", om.valueToTree(this.getService()));
            if (this.getCustomAttributes() != null) {
                data.set("customAttributes", om.valueToTree(this.getCustomAttributes()));
            }
            if (this.getInstanceId() != null) {
                data.set("instanceId", om.valueToTree(this.getInstanceId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicediscovery.AliasTargetInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AliasTargetInstanceProps.Jsii$Proxy that = (AliasTargetInstanceProps.Jsii$Proxy) o;

            if (!dnsName.equals(that.dnsName)) return false;
            if (!service.equals(that.service)) return false;
            if (this.customAttributes != null ? !this.customAttributes.equals(that.customAttributes) : that.customAttributes != null) return false;
            return this.instanceId != null ? this.instanceId.equals(that.instanceId) : that.instanceId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dnsName.hashCode();
            result = 31 * result + (this.service.hashCode());
            result = 31 * result + (this.customAttributes != null ? this.customAttributes.hashCode() : 0);
            result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
            return result;
        }
    }
}
