package software.amazon.awscdk.services.sso;

/**
 * Properties for defining a <code>CfnInstanceAccessControlAttributeConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sso.*;
 * CfnInstanceAccessControlAttributeConfigurationProps cfnInstanceAccessControlAttributeConfigurationProps = CfnInstanceAccessControlAttributeConfigurationProps.builder()
 *         .instanceArn("instanceArn")
 *         // the properties below are optional
 *         .accessControlAttributes(List.of(AccessControlAttributeProperty.builder()
 *                 .key("key")
 *                 .value(AccessControlAttributeValueProperty.builder()
 *                         .source(List.of("source"))
 *                         .build())
 *                 .build()))
 *         .instanceAccessControlAttributeConfiguration(InstanceAccessControlAttributeConfigurationProperty.builder()
 *                 .accessControlAttributes(List.of(AccessControlAttributeProperty.builder()
 *                         .key("key")
 *                         .value(AccessControlAttributeValueProperty.builder()
 *                                 .source(List.of("source"))
 *                                 .build())
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-instanceaccesscontrolattributeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-instanceaccesscontrolattributeconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:22:02.216Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sso.CfnInstanceAccessControlAttributeConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnInstanceAccessControlAttributeConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInstanceAccessControlAttributeConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the IAM Identity Center instance under which the operation will be executed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-instanceaccesscontrolattributeconfiguration.html#cfn-sso-instanceaccesscontrolattributeconfiguration-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-instanceaccesscontrolattributeconfiguration.html#cfn-sso-instanceaccesscontrolattributeconfiguration-instancearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn();

    /**
     * Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-instanceaccesscontrolattributeconfiguration.html#cfn-sso-instanceaccesscontrolattributeconfiguration-accesscontrolattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-instanceaccesscontrolattributeconfiguration.html#cfn-sso-instanceaccesscontrolattributeconfiguration-accesscontrolattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccessControlAttributes() {
        return null;
    }

    /**
     * (deprecated) The InstanceAccessControlAttributeConfiguration property has been deprecated but is still supported for backwards compatibility purposes.
     * <p>
     * We recomend that you use  AccessControlAttributes property instead.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-instanceaccesscontrolattributeconfiguration.html#cfn-sso-instanceaccesscontrolattributeconfiguration-instanceaccesscontrolattributeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-instanceaccesscontrolattributeconfiguration.html#cfn-sso-instanceaccesscontrolattributeconfiguration-instanceaccesscontrolattributeconfiguration</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceAccessControlAttributeConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInstanceAccessControlAttributeConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInstanceAccessControlAttributeConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInstanceAccessControlAttributeConfigurationProps> {
        java.lang.String instanceArn;
        java.lang.Object accessControlAttributes;
        java.lang.Object instanceAccessControlAttributeConfiguration;

        /**
         * Sets the value of {@link CfnInstanceAccessControlAttributeConfigurationProps#getInstanceArn}
         * @param instanceArn The ARN of the IAM Identity Center instance under which the operation will be executed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(java.lang.String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceAccessControlAttributeConfigurationProps#getAccessControlAttributes}
         * @param accessControlAttributes Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControlAttributes(software.amazon.awscdk.IResolvable accessControlAttributes) {
            this.accessControlAttributes = accessControlAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceAccessControlAttributeConfigurationProps#getAccessControlAttributes}
         * @param accessControlAttributes Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControlAttributes(java.util.List<? extends java.lang.Object> accessControlAttributes) {
            this.accessControlAttributes = accessControlAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceAccessControlAttributeConfigurationProps#getInstanceAccessControlAttributeConfiguration}
         * @param instanceAccessControlAttributeConfiguration The InstanceAccessControlAttributeConfiguration property has been deprecated but is still supported for backwards compatibility purposes.
         *                                                    We recomend that you use  AccessControlAttributes property instead.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder instanceAccessControlAttributeConfiguration(software.amazon.awscdk.IResolvable instanceAccessControlAttributeConfiguration) {
            this.instanceAccessControlAttributeConfiguration = instanceAccessControlAttributeConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceAccessControlAttributeConfigurationProps#getInstanceAccessControlAttributeConfiguration}
         * @param instanceAccessControlAttributeConfiguration The InstanceAccessControlAttributeConfiguration property has been deprecated but is still supported for backwards compatibility purposes.
         *                                                    We recomend that you use  AccessControlAttributes property instead.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder instanceAccessControlAttributeConfiguration(software.amazon.awscdk.services.sso.CfnInstanceAccessControlAttributeConfiguration.InstanceAccessControlAttributeConfigurationProperty instanceAccessControlAttributeConfiguration) {
            this.instanceAccessControlAttributeConfiguration = instanceAccessControlAttributeConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInstanceAccessControlAttributeConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInstanceAccessControlAttributeConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInstanceAccessControlAttributeConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInstanceAccessControlAttributeConfigurationProps {
        private final java.lang.String instanceArn;
        private final java.lang.Object accessControlAttributes;
        private final java.lang.Object instanceAccessControlAttributeConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceArn = software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessControlAttributes = software.amazon.jsii.Kernel.get(this, "accessControlAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.instanceAccessControlAttributeConfiguration = software.amazon.jsii.Kernel.get(this, "instanceAccessControlAttributeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceArn = java.util.Objects.requireNonNull(builder.instanceArn, "instanceArn is required");
            this.accessControlAttributes = builder.accessControlAttributes;
            this.instanceAccessControlAttributeConfiguration = builder.instanceAccessControlAttributeConfiguration;
        }

        @Override
        public final java.lang.String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final java.lang.Object getAccessControlAttributes() {
            return this.accessControlAttributes;
        }

        @Override
        public final java.lang.Object getInstanceAccessControlAttributeConfiguration() {
            return this.instanceAccessControlAttributeConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceArn", om.valueToTree(this.getInstanceArn()));
            if (this.getAccessControlAttributes() != null) {
                data.set("accessControlAttributes", om.valueToTree(this.getAccessControlAttributes()));
            }
            if (this.getInstanceAccessControlAttributeConfiguration() != null) {
                data.set("instanceAccessControlAttributeConfiguration", om.valueToTree(this.getInstanceAccessControlAttributeConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sso.CfnInstanceAccessControlAttributeConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInstanceAccessControlAttributeConfigurationProps.Jsii$Proxy that = (CfnInstanceAccessControlAttributeConfigurationProps.Jsii$Proxy) o;

            if (!instanceArn.equals(that.instanceArn)) return false;
            if (this.accessControlAttributes != null ? !this.accessControlAttributes.equals(that.accessControlAttributes) : that.accessControlAttributes != null) return false;
            return this.instanceAccessControlAttributeConfiguration != null ? this.instanceAccessControlAttributeConfiguration.equals(that.instanceAccessControlAttributeConfiguration) : that.instanceAccessControlAttributeConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceArn.hashCode();
            result = 31 * result + (this.accessControlAttributes != null ? this.accessControlAttributes.hashCode() : 0);
            result = 31 * result + (this.instanceAccessControlAttributeConfiguration != null ? this.instanceAccessControlAttributeConfiguration.hashCode() : 0);
            return result;
        }
    }
}
