package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Start an Athena Query as a Task.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AthenaStartQueryExecution startQueryExecutionJob = AthenaStartQueryExecution.Builder.create(this, "Start Athena Query")
 *         .queryString(JsonPath.stringAt("$.queryString"))
 *         .queryExecutionContext(QueryExecutionContext.builder()
 *                 .databaseName("mydatabase")
 *                 .build())
 *         .resultConfiguration(ResultConfiguration.builder()
 *                 .encryptionConfiguration(EncryptionConfiguration.builder()
 *                         .encryptionOption(EncryptionOption.S3_MANAGED)
 *                         .build())
 *                 .outputLocation(Location.builder()
 *                         .bucketName("query-results-bucket")
 *                         .objectKey("folder")
 *                         .build())
 *                 .build())
 *         .executionParameters(List.of("param1", "param2"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-athena.html">https://docs.aws.amazon.com/step-functions/latest/dg/connect-athena.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:22:02.350Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.AthenaStartQueryExecution")
public class AthenaStartQueryExecution extends software.amazon.awscdk.services.stepfunctions.TaskStateBase {

    protected AthenaStartQueryExecution(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AthenaStartQueryExecution(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id Descriptive identifier for this chainable. This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AthenaStartQueryExecution(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.AthenaStartQueryExecutionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig getTaskMetrics() {
        return software.amazon.jsii.Kernel.get(this, "taskMetrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getTaskPolicies() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)(software.amazon.jsii.Kernel.get(this, "taskPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.AthenaStartQueryExecution}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.tasks.AthenaStartQueryExecution> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id Descriptive identifier for this chainable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.stepfunctions.tasks.AthenaStartQueryExecutionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.AthenaStartQueryExecutionProps.Builder();
        }

        /**
         * An optional description for this state.
         * <p>
         * Default: - No comment
         * <p>
         * @return {@code this}
         * @param comment An optional description for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * Credentials for an IAM Role that the State Machine assumes for executing the task.
         * <p>
         * This enables cross-account resource invocations.
         * <p>
         * Default: - None (Task is executed using the State Machine's execution role)
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-access-cross-acct-resources.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-access-cross-acct-resources.html</a>
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(final software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        /**
         * (deprecated) Timeout for the heartbeat.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @deprecated use <code>heartbeatTimeout</code>
         * @param heartbeat Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(final software.amazon.awscdk.Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        /**
         * Timeout for the heartbeat.
         * <p>
         * [disable-awslint:duration-prop-type] is needed because all props interface in
         * aws-stepfunctions-tasks extend this interface
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param heartbeatTimeout Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.props.heartbeatTimeout(heartbeatTimeout);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * input to be the empty object {}.
         * <p>
         * Default: - The entire task input (JSON path '$')
         * <p>
         * @return {@code this}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(final java.lang.String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        /**
         * AWS Step Functions integrates with services directly in the Amazon States Language.
         * <p>
         * You can control these AWS services using service integration patterns.
         * <p>
         * Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * <p>
         * Default: - `IntegrationPattern.REQUEST_RESPONSE` for most tasks.
         * `IntegrationPattern.RUN_JOB` for the following exceptions:
         * `BatchSubmitJob`, `EmrAddStep`, `EmrCreateCluster`, `EmrTerminationCluster`, and `EmrContainersStartJobRun`.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-supported-services.html">https://docs.aws.amazon.com/step-functions/latest/dg/connect-supported-services.html</a>
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * JSONPath expression to select select a portion of the state output to pass to the next state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * output to be the empty object {}.
         * <p>
         * Default: - The entire JSON node determined by the state input, the task result,
         * and resultPath is passed to the next state (JSON path '$')
         * <p>
         * @return {@code this}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(final java.lang.String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        /**
         * JSONPath expression to indicate where to inject the state's output.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the state's
         * input to become its output.
         * <p>
         * Default: - Replaces the entire input with the result (JSON path '$')
         * <p>
         * @return {@code this}
         * @param resultPath JSONPath expression to indicate where to inject the state's output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(final java.lang.String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        /**
         * The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         * <p>
         * You can use ResultSelector to create a payload with values that are static
         * or selected from the state's raw result.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector</a>
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultSelector(final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        /**
         * Optional name for this state.
         * <p>
         * Default: - The construct ID will be used as state name
         * <p>
         * @return {@code this}
         * @param stateName Optional name for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(final java.lang.String stateName) {
            this.props.stateName(stateName);
            return this;
        }

        /**
         * Timeout for the task.
         * <p>
         * [disable-awslint:duration-prop-type] is needed because all props interface in
         * aws-stepfunctions-tasks extend this interface
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param taskTimeout Timeout for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.props.taskTimeout(taskTimeout);
            return this;
        }

        /**
         * (deprecated) Timeout for the task.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @deprecated use <code>taskTimeout</code>
         * @param timeout Timeout for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * Query that will be started.
         * <p>
         * @return {@code this}
         * @param queryString Query that will be started. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryString(final java.lang.String queryString) {
            this.props.queryString(queryString);
            return this;
        }

        /**
         * Unique string string to ensure idempotence.
         * <p>
         * Default: - No client request token
         * <p>
         * @return {@code this}
         * @param clientRequestToken Unique string string to ensure idempotence. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientRequestToken(final java.lang.String clientRequestToken) {
            this.props.clientRequestToken(clientRequestToken);
            return this;
        }

        /**
         * A list of values for the parameters in a query.
         * <p>
         * The values are applied sequentially to the parameters in the query in the order
         * in which the parameters occur.
         * <p>
         * Default: - No parameters
         * <p>
         * @return {@code this}
         * @param executionParameters A list of values for the parameters in a query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionParameters(final java.util.List<java.lang.String> executionParameters) {
            this.props.executionParameters(executionParameters);
            return this;
        }

        /**
         * Database within which query executes.
         * <p>
         * Default: - No query execution context
         * <p>
         * @return {@code this}
         * @param queryExecutionContext Database within which query executes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryExecutionContext(final software.amazon.awscdk.services.stepfunctions.tasks.QueryExecutionContext queryExecutionContext) {
            this.props.queryExecutionContext(queryExecutionContext);
            return this;
        }

        /**
         * Configuration on how and where to save query.
         * <p>
         * Default: - No result configuration
         * <p>
         * @return {@code this}
         * @param resultConfiguration Configuration on how and where to save query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultConfiguration(final software.amazon.awscdk.services.stepfunctions.tasks.ResultConfiguration resultConfiguration) {
            this.props.resultConfiguration(resultConfiguration);
            return this;
        }

        /**
         * Configuration on how and where to save query.
         * <p>
         * Default: - No work group
         * <p>
         * @return {@code this}
         * @param workGroup Configuration on how and where to save query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workGroup(final java.lang.String workGroup) {
            this.props.workGroup(workGroup);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.AthenaStartQueryExecution}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.AthenaStartQueryExecution build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.AthenaStartQueryExecution(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
