package software.amazon.awscdk.services.xray;

/**
 * Properties for defining a <code>CfnResourcePolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.xray.*;
 * CfnResourcePolicyProps cfnResourcePolicyProps = CfnResourcePolicyProps.builder()
 *         .policyDocument("policyDocument")
 *         .policyName("policyName")
 *         // the properties below are optional
 *         .bypassPolicyLockoutCheck(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-resourcepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-resourcepolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-03-14T22:22:02.996Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_xray.CfnResourcePolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnResourcePolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResourcePolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The resource-based policy document, which can be up to 5kb in size.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-resourcepolicy.html#cfn-xray-resourcepolicy-policydocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-resourcepolicy.html#cfn-xray-resourcepolicy-policydocument</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyDocument();

    /**
     * The name of the resource-based policy.
     * <p>
     * Must be unique within a specific AWS account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-resourcepolicy.html#cfn-xray-resourcepolicy-policyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-resourcepolicy.html#cfn-xray-resourcepolicy-policyname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyName();

    /**
     * A flag to indicate whether to bypass the resource-based policy lockout safety check.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-resourcepolicy.html#cfn-xray-resourcepolicy-bypasspolicylockoutcheck">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-resourcepolicy.html#cfn-xray-resourcepolicy-bypasspolicylockoutcheck</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBypassPolicyLockoutCheck() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResourcePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResourcePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResourcePolicyProps> {
        java.lang.String policyDocument;
        java.lang.String policyName;
        java.lang.Object bypassPolicyLockoutCheck;

        /**
         * Sets the value of {@link CfnResourcePolicyProps#getPolicyDocument}
         * @param policyDocument The resource-based policy document, which can be up to 5kb in size. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDocument(java.lang.String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourcePolicyProps#getPolicyName}
         * @param policyName The name of the resource-based policy. This parameter is required.
         *                   Must be unique within a specific AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(java.lang.String policyName) {
            this.policyName = policyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourcePolicyProps#getBypassPolicyLockoutCheck}
         * @param bypassPolicyLockoutCheck A flag to indicate whether to bypass the resource-based policy lockout safety check.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bypassPolicyLockoutCheck(java.lang.Boolean bypassPolicyLockoutCheck) {
            this.bypassPolicyLockoutCheck = bypassPolicyLockoutCheck;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourcePolicyProps#getBypassPolicyLockoutCheck}
         * @param bypassPolicyLockoutCheck A flag to indicate whether to bypass the resource-based policy lockout safety check.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bypassPolicyLockoutCheck(software.amazon.awscdk.IResolvable bypassPolicyLockoutCheck) {
            this.bypassPolicyLockoutCheck = bypassPolicyLockoutCheck;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourcePolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResourcePolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResourcePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResourcePolicyProps {
        private final java.lang.String policyDocument;
        private final java.lang.String policyName;
        private final java.lang.Object bypassPolicyLockoutCheck;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policyDocument = software.amazon.jsii.Kernel.get(this, "policyDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyName = software.amazon.jsii.Kernel.get(this, "policyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bypassPolicyLockoutCheck = software.amazon.jsii.Kernel.get(this, "bypassPolicyLockoutCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policyDocument = java.util.Objects.requireNonNull(builder.policyDocument, "policyDocument is required");
            this.policyName = java.util.Objects.requireNonNull(builder.policyName, "policyName is required");
            this.bypassPolicyLockoutCheck = builder.bypassPolicyLockoutCheck;
        }

        @Override
        public final java.lang.String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final java.lang.String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final java.lang.Object getBypassPolicyLockoutCheck() {
            return this.bypassPolicyLockoutCheck;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
            data.set("policyName", om.valueToTree(this.getPolicyName()));
            if (this.getBypassPolicyLockoutCheck() != null) {
                data.set("bypassPolicyLockoutCheck", om.valueToTree(this.getBypassPolicyLockoutCheck()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_xray.CfnResourcePolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResourcePolicyProps.Jsii$Proxy that = (CfnResourcePolicyProps.Jsii$Proxy) o;

            if (!policyDocument.equals(that.policyDocument)) return false;
            if (!policyName.equals(that.policyName)) return false;
            return this.bypassPolicyLockoutCheck != null ? this.bypassPolicyLockoutCheck.equals(that.bypassPolicyLockoutCheck) : that.bypassPolicyLockoutCheck == null;
        }

        @Override
        public final int hashCode() {
            int result = this.policyDocument.hashCode();
            result = 31 * result + (this.policyName.hashCode());
            result = 31 * result + (this.bypassPolicyLockoutCheck != null ? this.bypassPolicyLockoutCheck.hashCode() : 0);
            return result;
        }
    }
}
