/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.autoscaling;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.autoscaling.ApplyCloudFormationInitOptions;
import software.amazon.awscdk.services.autoscaling.AutoScalingGroupProps;
import software.amazon.awscdk.services.autoscaling.BasicLifecycleHookProps;
import software.amazon.awscdk.services.autoscaling.BasicScheduledActionProps;
import software.amazon.awscdk.services.autoscaling.BasicStepScalingPolicyProps;
import software.amazon.awscdk.services.autoscaling.BlockDevice;
import software.amazon.awscdk.services.autoscaling.CpuUtilizationScalingProps;
import software.amazon.awscdk.services.autoscaling.GroupMetrics;
import software.amazon.awscdk.services.autoscaling.HealthCheck;
import software.amazon.awscdk.services.autoscaling.IAutoScalingGroup;
import software.amazon.awscdk.services.autoscaling.LifecycleHook;
import software.amazon.awscdk.services.autoscaling.MetricTargetTrackingProps;
import software.amazon.awscdk.services.autoscaling.MixedInstancesPolicy;
import software.amazon.awscdk.services.autoscaling.Monitoring;
import software.amazon.awscdk.services.autoscaling.NetworkUtilizationScalingProps;
import software.amazon.awscdk.services.autoscaling.NotificationConfiguration;
import software.amazon.awscdk.services.autoscaling.RequestCountScalingProps;
import software.amazon.awscdk.services.autoscaling.ScheduledAction;
import software.amazon.awscdk.services.autoscaling.Signals;
import software.amazon.awscdk.services.autoscaling.StepScalingPolicy;
import software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy;
import software.amazon.awscdk.services.autoscaling.TerminationPolicy;
import software.amazon.awscdk.services.autoscaling.UpdatePolicy;
import software.amazon.awscdk.services.autoscaling.WarmPool;
import software.amazon.awscdk.services.autoscaling.WarmPoolOptions;
import software.amazon.awscdk.services.ec2.CloudFormationInit;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.ec2.ILaunchTemplate;
import software.amazon.awscdk.services.ec2.IMachineImage;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.OperatingSystemType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ec2.UserData;
import software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_autoscaling.AutoScalingGroup")
public class AutoScalingGroup
extends Resource
implements ILoadBalancerTarget,
IConnectable,
IApplicationLoadBalancerTarget,
INetworkLoadBalancerTarget,
IAutoScalingGroup {
    protected AutoScalingGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AutoScalingGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public AutoScalingGroup(@NotNull Construct scope, @NotNull String id, @NotNull AutoScalingGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IAutoScalingGroup fromAutoScalingGroupName(@NotNull Construct scope, @NotNull String id, @NotNull String autoScalingGroupName) {
        return (IAutoScalingGroup)JsiiObject.jsiiStaticCall(AutoScalingGroup.class, (String)"fromAutoScalingGroupName", (NativeType)NativeType.forClass(IAutoScalingGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(autoScalingGroupName, "autoScalingGroupName is required")});
    }

    @Override
    @NotNull
    public LifecycleHook addLifecycleHook(@NotNull String id, @NotNull BasicLifecycleHookProps props) {
        return (LifecycleHook)Kernel.call((Object)this, (String)"addLifecycleHook", (NativeType)NativeType.forClass(LifecycleHook.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addSecurityGroup(@NotNull ISecurityGroup securityGroup) {
        Kernel.call((Object)this, (String)"addSecurityGroup", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(securityGroup, "securityGroup is required")});
    }

    public void addToRolePolicy(@NotNull PolicyStatement statement) {
        Kernel.call((Object)this, (String)"addToRolePolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    public void addUserData(String ... commands) {
        Kernel.call((Object)this, (String)"addUserData", (NativeType)NativeType.VOID, (Object[])Arrays.stream(commands).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public WarmPool addWarmPool(@Nullable WarmPoolOptions options) {
        return (WarmPool)Kernel.call((Object)this, (String)"addWarmPool", (NativeType)NativeType.forClass(WarmPool.class), (Object[])new Object[]{options});
    }

    @Override
    @NotNull
    public WarmPool addWarmPool() {
        return (WarmPool)Kernel.call((Object)this, (String)"addWarmPool", (NativeType)NativeType.forClass(WarmPool.class), (Object[])new Object[0]);
    }

    public void applyCloudFormationInit(@NotNull CloudFormationInit init, @Nullable ApplyCloudFormationInitOptions options) {
        Kernel.call((Object)this, (String)"applyCloudFormationInit", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(init, "init is required"), options});
    }

    public void applyCloudFormationInit(@NotNull CloudFormationInit init) {
        Kernel.call((Object)this, (String)"applyCloudFormationInit", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(init, "init is required")});
    }

    @NotNull
    public Boolean areNewInstancesProtectedFromScaleIn() {
        return (Boolean)Kernel.call((Object)this, (String)"areNewInstancesProtectedFromScaleIn", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public LoadBalancerTargetProps attachToApplicationTargetGroup(@NotNull IApplicationTargetGroup targetGroup) {
        return (LoadBalancerTargetProps)Kernel.call((Object)this, (String)"attachToApplicationTargetGroup", (NativeType)NativeType.forClass(LoadBalancerTargetProps.class), (Object[])new Object[]{Objects.requireNonNull(targetGroup, "targetGroup is required")});
    }

    @Override
    public void attachToClassicLB(@NotNull LoadBalancer loadBalancer) {
        Kernel.call((Object)this, (String)"attachToClassicLB", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(loadBalancer, "loadBalancer is required")});
    }

    @Override
    @NotNull
    public LoadBalancerTargetProps attachToNetworkTargetGroup(@NotNull INetworkTargetGroup targetGroup) {
        return (LoadBalancerTargetProps)Kernel.call((Object)this, (String)"attachToNetworkTargetGroup", (NativeType)NativeType.forClass(LoadBalancerTargetProps.class), (Object[])new Object[]{Objects.requireNonNull(targetGroup, "targetGroup is required")});
    }

    public void protectNewInstancesFromScaleIn() {
        Kernel.call((Object)this, (String)"protectNewInstancesFromScaleIn", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public TargetTrackingScalingPolicy scaleOnCpuUtilization(@NotNull String id, @NotNull CpuUtilizationScalingProps props) {
        return (TargetTrackingScalingPolicy)((Object)Kernel.call((Object)this, (String)"scaleOnCpuUtilization", (NativeType)NativeType.forClass(TargetTrackingScalingPolicy.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    public TargetTrackingScalingPolicy scaleOnIncomingBytes(@NotNull String id, @NotNull NetworkUtilizationScalingProps props) {
        return (TargetTrackingScalingPolicy)((Object)Kernel.call((Object)this, (String)"scaleOnIncomingBytes", (NativeType)NativeType.forClass(TargetTrackingScalingPolicy.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    public StepScalingPolicy scaleOnMetric(@NotNull String id, @NotNull BasicStepScalingPolicyProps props) {
        return (StepScalingPolicy)((Object)Kernel.call((Object)this, (String)"scaleOnMetric", (NativeType)NativeType.forClass(StepScalingPolicy.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    public TargetTrackingScalingPolicy scaleOnOutgoingBytes(@NotNull String id, @NotNull NetworkUtilizationScalingProps props) {
        return (TargetTrackingScalingPolicy)((Object)Kernel.call((Object)this, (String)"scaleOnOutgoingBytes", (NativeType)NativeType.forClass(TargetTrackingScalingPolicy.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public TargetTrackingScalingPolicy scaleOnRequestCount(@NotNull String id, @NotNull RequestCountScalingProps props) {
        return (TargetTrackingScalingPolicy)((Object)Kernel.call((Object)this, (String)"scaleOnRequestCount", (NativeType)NativeType.forClass(TargetTrackingScalingPolicy.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    public ScheduledAction scaleOnSchedule(@NotNull String id, @NotNull BasicScheduledActionProps props) {
        return (ScheduledAction)Kernel.call((Object)this, (String)"scaleOnSchedule", (NativeType)NativeType.forClass(ScheduledAction.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public TargetTrackingScalingPolicy scaleToTrackMetric(@NotNull String id, @NotNull MetricTargetTrackingProps props) {
        return (TargetTrackingScalingPolicy)((Object)Kernel.call((Object)this, (String)"scaleToTrackMetric", (NativeType)NativeType.forClass(TargetTrackingScalingPolicy.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    public String getAutoScalingGroupArn() {
        return (String)Kernel.get((Object)this, (String)"autoScalingGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getAutoScalingGroupName() {
        return (String)Kernel.get((Object)this, (String)"autoScalingGroupName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    @Override
    @NotNull
    public OperatingSystemType getOsType() {
        return (OperatingSystemType)((Object)Kernel.get((Object)this, (String)"osType", (NativeType)NativeType.forClass(OperatingSystemType.class)));
    }

    @NotNull
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    @NotNull
    public UserData getUserData() {
        return (UserData)((Object)Kernel.get((Object)this, (String)"userData", (NativeType)NativeType.forClass(UserData.class)));
    }

    @Nullable
    public Duration getMaxInstanceLifetime() {
        return (Duration)((Object)Kernel.get((Object)this, (String)"maxInstanceLifetime", (NativeType)NativeType.forClass(Duration.class)));
    }

    @Nullable
    public String getSpotPrice() {
        return (String)Kernel.get((Object)this, (String)"spotPrice", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Boolean getHasCalledScaleOnRequestCount() {
        return (Boolean)Kernel.get((Object)this, (String)"hasCalledScaleOnRequestCount", (NativeType)NativeType.forClass(Boolean.class));
    }

    protected void setHasCalledScaleOnRequestCount(@NotNull Boolean value) {
        Kernel.set((Object)this, (String)"hasCalledScaleOnRequestCount", (Object)Objects.requireNonNull(value, "hasCalledScaleOnRequestCount is required"));
    }

    @Nullable
    protected ApplicationTargetGroup getAlbTargetGroup() {
        return (ApplicationTargetGroup)Kernel.get((Object)this, (String)"albTargetGroup", (NativeType)NativeType.forClass(ApplicationTargetGroup.class));
    }

    protected void setAlbTargetGroup(@Nullable ApplicationTargetGroup value) {
        Kernel.set((Object)this, (String)"albTargetGroup", (Object)value);
    }

    @Nullable
    protected Boolean getNewInstancesProtectedFromScaleIn() {
        return (Boolean)Kernel.get((Object)this, (String)"newInstancesProtectedFromScaleIn", (NativeType)NativeType.forClass(Boolean.class));
    }

    protected void setNewInstancesProtectedFromScaleIn(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"newInstancesProtectedFromScaleIn", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AutoScalingGroup> {
        private final Construct scope;
        private final String id;
        private final AutoScalingGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new AutoScalingGroupProps.Builder();
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.props.associatePublicIpAddress(associatePublicIpAddress);
            return this;
        }

        public Builder autoScalingGroupName(String autoScalingGroupName) {
            this.props.autoScalingGroupName(autoScalingGroupName);
            return this;
        }

        public Builder blockDevices(List<? extends BlockDevice> blockDevices) {
            this.props.blockDevices(blockDevices);
            return this;
        }

        public Builder capacityRebalance(Boolean capacityRebalance) {
            this.props.capacityRebalance(capacityRebalance);
            return this;
        }

        public Builder cooldown(Duration cooldown) {
            this.props.cooldown(cooldown);
            return this;
        }

        public Builder defaultInstanceWarmup(Duration defaultInstanceWarmup) {
            this.props.defaultInstanceWarmup(defaultInstanceWarmup);
            return this;
        }

        public Builder desiredCapacity(Number desiredCapacity) {
            this.props.desiredCapacity(desiredCapacity);
            return this;
        }

        public Builder groupMetrics(List<? extends GroupMetrics> groupMetrics) {
            this.props.groupMetrics(groupMetrics);
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        public Builder ignoreUnmodifiedSizeProperties(Boolean ignoreUnmodifiedSizeProperties) {
            this.props.ignoreUnmodifiedSizeProperties(ignoreUnmodifiedSizeProperties);
            return this;
        }

        public Builder instanceMonitoring(Monitoring instanceMonitoring) {
            this.props.instanceMonitoring(instanceMonitoring);
            return this;
        }

        public Builder keyName(String keyName) {
            this.props.keyName(keyName);
            return this;
        }

        public Builder maxCapacity(Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        public Builder maxInstanceLifetime(Duration maxInstanceLifetime) {
            this.props.maxInstanceLifetime(maxInstanceLifetime);
            return this;
        }

        public Builder minCapacity(Number minCapacity) {
            this.props.minCapacity(minCapacity);
            return this;
        }

        public Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.props.newInstancesProtectedFromScaleIn(newInstancesProtectedFromScaleIn);
            return this;
        }

        public Builder notifications(List<? extends NotificationConfiguration> notifications) {
            this.props.notifications(notifications);
            return this;
        }

        public Builder signals(Signals signals) {
            this.props.signals(signals);
            return this;
        }

        public Builder spotPrice(String spotPrice) {
            this.props.spotPrice(spotPrice);
            return this;
        }

        public Builder ssmSessionPermissions(Boolean ssmSessionPermissions) {
            this.props.ssmSessionPermissions(ssmSessionPermissions);
            return this;
        }

        public Builder terminationPolicies(List<? extends TerminationPolicy> terminationPolicies) {
            this.props.terminationPolicies(terminationPolicies);
            return this;
        }

        public Builder terminationPolicyCustomLambdaFunctionArn(String terminationPolicyCustomLambdaFunctionArn) {
            this.props.terminationPolicyCustomLambdaFunctionArn(terminationPolicyCustomLambdaFunctionArn);
            return this;
        }

        public Builder updatePolicy(UpdatePolicy updatePolicy) {
            this.props.updatePolicy(updatePolicy);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder init(CloudFormationInit init) {
            this.props.init(init);
            return this;
        }

        public Builder initOptions(ApplyCloudFormationInitOptions initOptions) {
            this.props.initOptions(initOptions);
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder launchTemplate(ILaunchTemplate launchTemplate) {
            this.props.launchTemplate(launchTemplate);
            return this;
        }

        public Builder machineImage(IMachineImage machineImage) {
            this.props.machineImage(machineImage);
            return this;
        }

        public Builder maxHealthyPercentage(Number maxHealthyPercentage) {
            this.props.maxHealthyPercentage(maxHealthyPercentage);
            return this;
        }

        public Builder minHealthyPercentage(Number minHealthyPercentage) {
            this.props.minHealthyPercentage(minHealthyPercentage);
            return this;
        }

        public Builder mixedInstancesPolicy(MixedInstancesPolicy mixedInstancesPolicy) {
            this.props.mixedInstancesPolicy(mixedInstancesPolicy);
            return this;
        }

        public Builder requireImdsv2(Boolean requireImdsv2) {
            this.props.requireImdsv2(requireImdsv2);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public Builder userData(UserData userData) {
            this.props.userData(userData);
            return this;
        }

        public AutoScalingGroup build() {
            return new AutoScalingGroup(this.scope, this.id, this.props.build());
        }
    }
}

