/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.autoscaling.BlockDevice;
import software.amazon.awscdk.services.autoscaling.CommonAutoScalingGroupProps;
import software.amazon.awscdk.services.autoscaling.GroupMetrics;
import software.amazon.awscdk.services.autoscaling.HealthCheck;
import software.amazon.awscdk.services.autoscaling.Monitoring;
import software.amazon.awscdk.services.autoscaling.NotificationConfiguration;
import software.amazon.awscdk.services.autoscaling.Signals;
import software.amazon.awscdk.services.autoscaling.TerminationPolicy;
import software.amazon.awscdk.services.autoscaling.UpdatePolicy;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.eks.AutoScalingGroupCapacityOptions;
import software.amazon.awscdk.services.eks.BootstrapOptions;
import software.amazon.awscdk.services.eks.MachineImageType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_eks.AutoScalingGroupCapacityOptions")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface AutoScalingGroupCapacityOptions
extends JsiiSerializable,
CommonAutoScalingGroupProps {
    @NotNull
    public InstanceType getInstanceType();

    @Nullable
    default public Boolean getBootstrapEnabled() {
        return null;
    }

    @Nullable
    default public BootstrapOptions getBootstrapOptions() {
        return null;
    }

    @Nullable
    default public MachineImageType getMachineImageType() {
        return null;
    }

    @Nullable
    default public Boolean getMapRole() {
        return null;
    }

    @Nullable
    default public Boolean getSpotInterruptHandler() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AutoScalingGroupCapacityOptions> {
        InstanceType instanceType;
        Boolean bootstrapEnabled;
        BootstrapOptions bootstrapOptions;
        MachineImageType machineImageType;
        Boolean mapRole;
        Boolean spotInterruptHandler;
        Boolean allowAllOutbound;
        Boolean associatePublicIpAddress;
        String autoScalingGroupName;
        List<BlockDevice> blockDevices;
        Boolean capacityRebalance;
        Duration cooldown;
        Duration defaultInstanceWarmup;
        Number desiredCapacity;
        List<GroupMetrics> groupMetrics;
        HealthCheck healthCheck;
        Boolean ignoreUnmodifiedSizeProperties;
        Monitoring instanceMonitoring;
        String keyName;
        Number maxCapacity;
        Duration maxInstanceLifetime;
        Number minCapacity;
        Boolean newInstancesProtectedFromScaleIn;
        List<NotificationConfiguration> notifications;
        Signals signals;
        String spotPrice;
        Boolean ssmSessionPermissions;
        List<TerminationPolicy> terminationPolicies;
        String terminationPolicyCustomLambdaFunctionArn;
        UpdatePolicy updatePolicy;
        SubnetSelection vpcSubnets;

        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder bootstrapEnabled(Boolean bootstrapEnabled) {
            this.bootstrapEnabled = bootstrapEnabled;
            return this;
        }

        public Builder bootstrapOptions(BootstrapOptions bootstrapOptions) {
            this.bootstrapOptions = bootstrapOptions;
            return this;
        }

        public Builder machineImageType(MachineImageType machineImageType) {
            this.machineImageType = machineImageType;
            return this;
        }

        public Builder mapRole(Boolean mapRole) {
            this.mapRole = mapRole;
            return this;
        }

        public Builder spotInterruptHandler(Boolean spotInterruptHandler) {
            this.spotInterruptHandler = spotInterruptHandler;
            return this;
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public Builder blockDevices(List<? extends BlockDevice> blockDevices) {
            this.blockDevices = blockDevices;
            return this;
        }

        public Builder capacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
            return this;
        }

        public Builder cooldown(Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder defaultInstanceWarmup(Duration defaultInstanceWarmup) {
            this.defaultInstanceWarmup = defaultInstanceWarmup;
            return this;
        }

        public Builder desiredCapacity(Number desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public Builder groupMetrics(List<? extends GroupMetrics> groupMetrics) {
            this.groupMetrics = groupMetrics;
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder ignoreUnmodifiedSizeProperties(Boolean ignoreUnmodifiedSizeProperties) {
            this.ignoreUnmodifiedSizeProperties = ignoreUnmodifiedSizeProperties;
            return this;
        }

        public Builder instanceMonitoring(Monitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder maxCapacity(Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public Builder maxInstanceLifetime(Duration maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        public Builder minCapacity(Number minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public Builder notifications(List<? extends NotificationConfiguration> notifications) {
            this.notifications = notifications;
            return this;
        }

        public Builder signals(Signals signals) {
            this.signals = signals;
            return this;
        }

        public Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public Builder ssmSessionPermissions(Boolean ssmSessionPermissions) {
            this.ssmSessionPermissions = ssmSessionPermissions;
            return this;
        }

        public Builder terminationPolicies(List<? extends TerminationPolicy> terminationPolicies) {
            this.terminationPolicies = terminationPolicies;
            return this;
        }

        public Builder terminationPolicyCustomLambdaFunctionArn(String terminationPolicyCustomLambdaFunctionArn) {
            this.terminationPolicyCustomLambdaFunctionArn = terminationPolicyCustomLambdaFunctionArn;
            return this;
        }

        public Builder updatePolicy(UpdatePolicy updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public AutoScalingGroupCapacityOptions build() {
            return new Jsii.Proxy(this);
        }
    }
}

