package software.amazon.awscdk;

/**
 * Initialization props for a stage.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App app;
 * new Stage(app, "DevStage");
 * Stage.Builder.create(app, "BetaStage")
 *         .permissionsBoundary(PermissionsBoundary.fromName("beta-permissions-boundary"))
 *         .build();
 * Stage.Builder.create(app, "GammaStage")
 *         .permissionsBoundary(PermissionsBoundary.fromName("prod-permissions-boundary"))
 *         .build();
 * Stage.Builder.create(app, "ProdStage")
 *         .permissionsBoundary(PermissionsBoundary.fromName("prod-permissions-boundary"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:18.537Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.StageProps")
@software.amazon.jsii.Jsii.Proxy(StageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Default AWS environment (account/region) for <code>Stack</code>s in this <code>Stage</code>.
     * <p>
     * Stacks defined inside this <code>Stage</code> with either <code>region</code> or <code>account</code> missing
     * from its env will use the corresponding field given here.
     * <p>
     * If either <code>region</code> or <code>account</code>is is not configured for <code>Stack</code> (either on
     * the <code>Stack</code> itself or on the containing <code>Stage</code>), the Stack will be
     * <em>environment-agnostic</em>.
     * <p>
     * Environment-agnostic stacks can be deployed to any environment, may not be
     * able to take advantage of all features of the CDK. For example, they will
     * not be able to use environmental context lookups, will not automatically
     * translate Service Principals to the right format based on the environment's
     * AWS partition, and other such enhancements.
     * <p>
     * Default: - The environments should be configured on the `Stack`s.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // Use a concrete account and region to deploy this Stage to
     * // Use a concrete account and region to deploy this Stage to
     * Stage.Builder.create(app, "Stage1")
     *         .env(Environment.builder().account("123456789012").region("us-east-1").build())
     *         .build();
     * // Use the CLI's current credentials to determine the target environment
     * // Use the CLI's current credentials to determine the target environment
     * Stage.Builder.create(app, "Stage2")
     *         .env(Environment.builder().account(process.getEnv().getCDK_DEFAULT_ACCOUNT()).region(process.getEnv().getCDK_DEFAULT_REGION()).build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Environment getEnv() {
        return null;
    }

    /**
     * The output directory into which to emit synthesized artifacts.
     * <p>
     * Can only be specified if this stage is the root stage (the app). If this is
     * specified and this stage is nested within another stage, an error will be
     * thrown.
     * <p>
     * Default: - for nested stages, outdir will be determined as a relative
     * directory to the outdir of the app. For apps, if outdir is not specified, a
     * temporary directory will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutdir() {
        return null;
    }

    /**
     * Options for applying a permissions boundary to all IAM Roles and Users created within this Stage.
     * <p>
     * Default: - no permissions boundary is applied
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.PermissionsBoundary getPermissionsBoundary() {
        return null;
    }

    /**
     * Validation plugins to run during synthesis.
     * <p>
     * If any plugin reports any violation,
     * synthesis will be interrupted and the report displayed to the user.
     * <p>
     * Default: - no validation plugins are used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.IPolicyValidationPluginBeta1> getPolicyValidationBeta1() {
        return null;
    }

    /**
     * Name of this stage.
     * <p>
     * Default: - Derived from the id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStageName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StageProps> {
        software.amazon.awscdk.Environment env;
        java.lang.String outdir;
        software.amazon.awscdk.PermissionsBoundary permissionsBoundary;
        java.util.List<software.amazon.awscdk.IPolicyValidationPluginBeta1> policyValidationBeta1;
        java.lang.String stageName;

        /**
         * Sets the value of {@link StageProps#getEnv}
         * @param env Default AWS environment (account/region) for <code>Stack</code>s in this <code>Stage</code>.
         *            Stacks defined inside this <code>Stage</code> with either <code>region</code> or <code>account</code> missing
         *            from its env will use the corresponding field given here.
         *            <p>
         *            If either <code>region</code> or <code>account</code>is is not configured for <code>Stack</code> (either on
         *            the <code>Stack</code> itself or on the containing <code>Stage</code>), the Stack will be
         *            <em>environment-agnostic</em>.
         *            <p>
         *            Environment-agnostic stacks can be deployed to any environment, may not be
         *            able to take advantage of all features of the CDK. For example, they will
         *            not be able to use environmental context lookups, will not automatically
         *            translate Service Principals to the right format based on the environment's
         *            AWS partition, and other such enhancements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(software.amazon.awscdk.Environment env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getOutdir}
         * @param outdir The output directory into which to emit synthesized artifacts.
         *               Can only be specified if this stage is the root stage (the app). If this is
         *               specified and this stage is nested within another stage, an error will be
         *               thrown.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outdir(java.lang.String outdir) {
            this.outdir = outdir;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getPermissionsBoundary}
         * @param permissionsBoundary Options for applying a permissions boundary to all IAM Roles and Users created within this Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsBoundary(software.amazon.awscdk.PermissionsBoundary permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getPolicyValidationBeta1}
         * @param policyValidationBeta1 Validation plugins to run during synthesis.
         *                              If any plugin reports any violation,
         *                              synthesis will be interrupted and the report displayed to the user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder policyValidationBeta1(java.util.List<? extends software.amazon.awscdk.IPolicyValidationPluginBeta1> policyValidationBeta1) {
            this.policyValidationBeta1 = (java.util.List<software.amazon.awscdk.IPolicyValidationPluginBeta1>)policyValidationBeta1;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getStageName}
         * @param stageName Name of this stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageProps {
        private final software.amazon.awscdk.Environment env;
        private final java.lang.String outdir;
        private final software.amazon.awscdk.PermissionsBoundary permissionsBoundary;
        private final java.util.List<software.amazon.awscdk.IPolicyValidationPluginBeta1> policyValidationBeta1;
        private final java.lang.String stageName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Environment.class));
            this.outdir = software.amazon.jsii.Kernel.get(this, "outdir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.permissionsBoundary = software.amazon.jsii.Kernel.get(this, "permissionsBoundary", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.PermissionsBoundary.class));
            this.policyValidationBeta1 = software.amazon.jsii.Kernel.get(this, "policyValidationBeta1", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IPolicyValidationPluginBeta1.class)));
            this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.env = builder.env;
            this.outdir = builder.outdir;
            this.permissionsBoundary = builder.permissionsBoundary;
            this.policyValidationBeta1 = (java.util.List<software.amazon.awscdk.IPolicyValidationPluginBeta1>)builder.policyValidationBeta1;
            this.stageName = builder.stageName;
        }

        @Override
        public final software.amazon.awscdk.Environment getEnv() {
            return this.env;
        }

        @Override
        public final java.lang.String getOutdir() {
            return this.outdir;
        }

        @Override
        public final software.amazon.awscdk.PermissionsBoundary getPermissionsBoundary() {
            return this.permissionsBoundary;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.IPolicyValidationPluginBeta1> getPolicyValidationBeta1() {
            return this.policyValidationBeta1;
        }

        @Override
        public final java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getOutdir() != null) {
                data.set("outdir", om.valueToTree(this.getOutdir()));
            }
            if (this.getPermissionsBoundary() != null) {
                data.set("permissionsBoundary", om.valueToTree(this.getPermissionsBoundary()));
            }
            if (this.getPolicyValidationBeta1() != null) {
                data.set("policyValidationBeta1", om.valueToTree(this.getPolicyValidationBeta1()));
            }
            if (this.getStageName() != null) {
                data.set("stageName", om.valueToTree(this.getStageName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.StageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StageProps.Jsii$Proxy that = (StageProps.Jsii$Proxy) o;

            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.outdir != null ? !this.outdir.equals(that.outdir) : that.outdir != null) return false;
            if (this.permissionsBoundary != null ? !this.permissionsBoundary.equals(that.permissionsBoundary) : that.permissionsBoundary != null) return false;
            if (this.policyValidationBeta1 != null ? !this.policyValidationBeta1.equals(that.policyValidationBeta1) : that.policyValidationBeta1 != null) return false;
            return this.stageName != null ? this.stageName.equals(that.stageName) : that.stageName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.env != null ? this.env.hashCode() : 0;
            result = 31 * result + (this.outdir != null ? this.outdir.hashCode() : 0);
            result = 31 * result + (this.permissionsBoundary != null ? this.permissionsBoundary.hashCode() : 0);
            result = 31 * result + (this.policyValidationBeta1 != null ? this.policyValidationBeta1.hashCode() : 0);
            result = 31 * result + (this.stageName != null ? this.stageName.hashCode() : 0);
            return result;
        }
    }
}
