package software.amazon.awscdk.aws_apigatewayv2_authorizers;

/**
 * Authorize Http Api routes via a lambda function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaAuthorizer;
 * import software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaResponseType;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegration;
 * // This function handles your auth logic
 * Function authHandler;
 * HttpLambdaAuthorizer authorizer = HttpLambdaAuthorizer.Builder.create("BooksAuthorizer", authHandler)
 *         .responseTypes(List.of(HttpLambdaResponseType.SIMPLE))
 *         .build();
 * HttpApi api = new HttpApi(this, "HttpApi");
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("BooksIntegration", "https://get-books-proxy.example.com"))
 *         .path("/books")
 *         .authorizer(authorizer)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:19.109Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_authorizers.HttpLambdaAuthorizer")
public class HttpLambdaAuthorizer extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer {

    protected HttpLambdaAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpLambdaAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Initialize a lambda authorizer to be bound with HTTP route.
     * <p>
     * @param id The id of the underlying construct. This parameter is required.
     * @param handler This parameter is required.
     * @param props Properties to configure the authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpLambdaAuthorizer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction handler, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaAuthorizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(handler, "handler is required"), props });
    }

    /**
     * Initialize a lambda authorizer to be bound with HTTP route.
     * <p>
     * @param id The id of the underlying construct. This parameter is required.
     * @param handler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpLambdaAuthorizer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction handler) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(handler, "handler is required") });
    }

    /**
     * Bind this authorizer to a specified Http route.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteAuthorizerConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteAuthorizerBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteAuthorizerConfig.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaAuthorizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaAuthorizer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id The id of the underlying construct. This parameter is required.
         * @param handler This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id, final software.amazon.awscdk.services.lambda.IFunction handler) {
            return new Builder(id, handler);
        }

        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.IFunction handler;
        private software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaAuthorizerProps.Builder props;

        private Builder(final java.lang.String id, final software.amazon.awscdk.services.lambda.IFunction handler) {
            this.id = id;
            this.handler = handler;
        }

        /**
         * Friendly authorizer name.
         * <p>
         * Default: - same value as `id` passed in the constructor.
         * <p>
         * @return {@code this}
         * @param authorizerName Friendly authorizer name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(final java.lang.String authorizerName) {
            this.props().authorizerName(authorizerName);
            return this;
        }

        /**
         * The identity source for which authorization is requested.
         * <p>
         * Default: ['$request.header.Authorization']
         * <p>
         * @return {@code this}
         * @param identitySource The identity source for which authorization is requested. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySource(final java.util.List<java.lang.String> identitySource) {
            this.props().identitySource(identitySource);
            return this;
        }

        /**
         * The types of responses the lambda can return.
         * <p>
         * If HttpLambdaResponseType.SIMPLE is included then
         * response format 2.0 will be used.
         * <p>
         * Default: [HttpLambdaResponseType.IAM]
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html#http-api-lambda-authorizer.payload-format-response">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html#http-api-lambda-authorizer.payload-format-response</a>
         * @param responseTypes The types of responses the lambda can return. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseTypes(final java.util.List<? extends software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaResponseType> responseTypes) {
            this.props().responseTypes(responseTypes);
            return this;
        }

        /**
         * How long APIGateway should cache the results.
         * <p>
         * Max 1 hour.
         * Disable caching by setting this to <code>Duration.seconds(0)</code>.
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param resultsCacheTtl How long APIGateway should cache the results. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultsCacheTtl(final software.amazon.awscdk.Duration resultsCacheTtl) {
            this.props().resultsCacheTtl(resultsCacheTtl);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaAuthorizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaAuthorizer build() {
            return new software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaAuthorizer(
                this.id,
                this.handler,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaAuthorizerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpLambdaAuthorizerProps.Builder();
            }
            return this.props;
        }
    }
}
