package software.amazon.awscdk.cloudassembly.schema;

/**
 * Default CDK CLI options that apply to all commands.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloudassembly.schema.*;
 * DefaultCdkOptions defaultCdkOptions = DefaultCdkOptions.builder()
 *         .all(false)
 *         .app("app")
 *         .assetMetadata(false)
 *         .caBundlePath("caBundlePath")
 *         .color(false)
 *         .context(Map.of(
 *                 "contextKey", "context"))
 *         .debug(false)
 *         .ec2Creds(false)
 *         .ignoreErrors(false)
 *         .json(false)
 *         .lookups(false)
 *         .notices(false)
 *         .output("output")
 *         .pathMetadata(false)
 *         .profile("profile")
 *         .proxy("proxy")
 *         .roleArn("roleArn")
 *         .stacks(List.of("stacks"))
 *         .staging(false)
 *         .strict(false)
 *         .trace(false)
 *         .verbose(false)
 *         .versionReporting(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:32.160Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.DefaultCdkOptions")
@software.amazon.jsii.Jsii.Proxy(DefaultCdkOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DefaultCdkOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Deploy all stacks.
     * <p>
     * Requried if <code>stacks</code> is not set
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAll() {
        return null;
    }

    /**
     * command-line for executing your app or a cloud assembly directory e.g. "node bin/my-app.js" or "cdk.out".
     * <p>
     * Default: - read from cdk.json
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApp() {
        return null;
    }

    /**
     * Include "aws:asset:*" CloudFormation metadata for resources that use assets.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAssetMetadata() {
        return null;
    }

    /**
     * Path to CA certificate to use when validating HTTPS requests.
     * <p>
     * Default: - read from AWS_CA_BUNDLE environment variable
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCaBundlePath() {
        return null;
    }

    /**
     * Show colors and other style from console output.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getColor() {
        return null;
    }

    /**
     * Additional context.
     * <p>
     * Default: - no additional context
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getContext() {
        return null;
    }

    /**
     * enable emission of additional debugging information, such as creation stack traces of tokens.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDebug() {
        return null;
    }

    /**
     * Force trying to fetch EC2 instance credentials.
     * <p>
     * Default: - guess EC2 instance status
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEc2Creds() {
        return null;
    }

    /**
     * Ignores synthesis errors, which will likely produce an invalid output.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreErrors() {
        return null;
    }

    /**
     * Use JSON output instead of YAML when templates are printed to STDOUT.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getJson() {
        return null;
    }

    /**
     * Perform context lookups.
     * <p>
     * Synthesis fails if this is disabled and context lookups need
     * to be performed
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLookups() {
        return null;
    }

    /**
     * Show relevant notices.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getNotices() {
        return null;
    }

    /**
     * Emits the synthesized cloud assembly into a directory.
     * <p>
     * Default: cdk.out
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutput() {
        return null;
    }

    /**
     * Include "aws:cdk:path" CloudFormation metadata for each resource.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPathMetadata() {
        return null;
    }

    /**
     * Use the indicated AWS profile as the default environment.
     * <p>
     * Default: - no profile is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProfile() {
        return null;
    }

    /**
     * Use the indicated proxy.
     * <p>
     * Will read from
     * HTTPS_PROXY environment if specified
     * <p>
     * Default: - no proxy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProxy() {
        return null;
    }

    /**
     * Role to pass to CloudFormation for deployment.
     * <p>
     * Default: - use the bootstrap cfn-exec role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * List of stacks to deploy.
     * <p>
     * Requried if <code>all</code> is not set
     * <p>
     * Default: - []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStacks() {
        return null;
    }

    /**
     * Copy assets to the output directory.
     * <p>
     * Needed for local debugging the source files with SAM CLI
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getStaging() {
        return null;
    }

    /**
     * Do not construct stacks with warnings.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getStrict() {
        return null;
    }

    /**
     * Print trace for stack warnings.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTrace() {
        return null;
    }

    /**
     * show debug logs.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getVerbose() {
        return null;
    }

    /**
     * Include "AWS::CDK::Metadata" resource in synthesized templates.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getVersionReporting() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DefaultCdkOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DefaultCdkOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DefaultCdkOptions> {
        java.lang.Boolean all;
        java.lang.String app;
        java.lang.Boolean assetMetadata;
        java.lang.String caBundlePath;
        java.lang.Boolean color;
        java.util.Map<java.lang.String, java.lang.String> context;
        java.lang.Boolean debug;
        java.lang.Boolean ec2Creds;
        java.lang.Boolean ignoreErrors;
        java.lang.Boolean json;
        java.lang.Boolean lookups;
        java.lang.Boolean notices;
        java.lang.String output;
        java.lang.Boolean pathMetadata;
        java.lang.String profile;
        java.lang.String proxy;
        java.lang.String roleArn;
        java.util.List<java.lang.String> stacks;
        java.lang.Boolean staging;
        java.lang.Boolean strict;
        java.lang.Boolean trace;
        java.lang.Boolean verbose;
        java.lang.Boolean versionReporting;

        /**
         * Sets the value of {@link DefaultCdkOptions#getAll}
         * @param all Deploy all stacks.
         *            Requried if <code>stacks</code> is not set
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder all(java.lang.Boolean all) {
            this.all = all;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getApp}
         * @param app command-line for executing your app or a cloud assembly directory e.g. "node bin/my-app.js" or "cdk.out".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder app(java.lang.String app) {
            this.app = app;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getAssetMetadata}
         * @param assetMetadata Include "aws:asset:*" CloudFormation metadata for resources that use assets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetMetadata(java.lang.Boolean assetMetadata) {
            this.assetMetadata = assetMetadata;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getCaBundlePath}
         * @param caBundlePath Path to CA certificate to use when validating HTTPS requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caBundlePath(java.lang.String caBundlePath) {
            this.caBundlePath = caBundlePath;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getColor}
         * @param color Show colors and other style from console output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder color(java.lang.Boolean color) {
            this.color = color;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getContext}
         * @param context Additional context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder context(java.util.Map<java.lang.String, java.lang.String> context) {
            this.context = context;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getDebug}
         * @param debug enable emission of additional debugging information, such as creation stack traces of tokens.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder debug(java.lang.Boolean debug) {
            this.debug = debug;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getEc2Creds}
         * @param ec2Creds Force trying to fetch EC2 instance credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2Creds(java.lang.Boolean ec2Creds) {
            this.ec2Creds = ec2Creds;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getIgnoreErrors}
         * @param ignoreErrors Ignores synthesis errors, which will likely produce an invalid output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreErrors(java.lang.Boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getJson}
         * @param json Use JSON output instead of YAML when templates are printed to STDOUT.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder json(java.lang.Boolean json) {
            this.json = json;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getLookups}
         * @param lookups Perform context lookups.
         *                Synthesis fails if this is disabled and context lookups need
         *                to be performed
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookups(java.lang.Boolean lookups) {
            this.lookups = lookups;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getNotices}
         * @param notices Show relevant notices.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notices(java.lang.Boolean notices) {
            this.notices = notices;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getOutput}
         * @param output Emits the synthesized cloud assembly into a directory.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(java.lang.String output) {
            this.output = output;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getPathMetadata}
         * @param pathMetadata Include "aws:cdk:path" CloudFormation metadata for each resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathMetadata(java.lang.Boolean pathMetadata) {
            this.pathMetadata = pathMetadata;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getProfile}
         * @param profile Use the indicated AWS profile as the default environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profile(java.lang.String profile) {
            this.profile = profile;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getProxy}
         * @param proxy Use the indicated proxy.
         *              Will read from
         *              HTTPS_PROXY environment if specified
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxy(java.lang.String proxy) {
            this.proxy = proxy;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getRoleArn}
         * @param roleArn Role to pass to CloudFormation for deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getStacks}
         * @param stacks List of stacks to deploy.
         *               Requried if <code>all</code> is not set
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stacks(java.util.List<java.lang.String> stacks) {
            this.stacks = stacks;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getStaging}
         * @param staging Copy assets to the output directory.
         *                Needed for local debugging the source files with SAM CLI
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staging(java.lang.Boolean staging) {
            this.staging = staging;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getStrict}
         * @param strict Do not construct stacks with warnings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder strict(java.lang.Boolean strict) {
            this.strict = strict;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getTrace}
         * @param trace Print trace for stack warnings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trace(java.lang.Boolean trace) {
            this.trace = trace;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getVerbose}
         * @param verbose show debug logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verbose(java.lang.Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        /**
         * Sets the value of {@link DefaultCdkOptions#getVersionReporting}
         * @param versionReporting Include "AWS::CDK::Metadata" resource in synthesized templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionReporting(java.lang.Boolean versionReporting) {
            this.versionReporting = versionReporting;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DefaultCdkOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DefaultCdkOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DefaultCdkOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultCdkOptions {
        private final java.lang.Boolean all;
        private final java.lang.String app;
        private final java.lang.Boolean assetMetadata;
        private final java.lang.String caBundlePath;
        private final java.lang.Boolean color;
        private final java.util.Map<java.lang.String, java.lang.String> context;
        private final java.lang.Boolean debug;
        private final java.lang.Boolean ec2Creds;
        private final java.lang.Boolean ignoreErrors;
        private final java.lang.Boolean json;
        private final java.lang.Boolean lookups;
        private final java.lang.Boolean notices;
        private final java.lang.String output;
        private final java.lang.Boolean pathMetadata;
        private final java.lang.String profile;
        private final java.lang.String proxy;
        private final java.lang.String roleArn;
        private final java.util.List<java.lang.String> stacks;
        private final java.lang.Boolean staging;
        private final java.lang.Boolean strict;
        private final java.lang.Boolean trace;
        private final java.lang.Boolean verbose;
        private final java.lang.Boolean versionReporting;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.all = software.amazon.jsii.Kernel.get(this, "all", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.app = software.amazon.jsii.Kernel.get(this, "app", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetMetadata = software.amazon.jsii.Kernel.get(this, "assetMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.caBundlePath = software.amazon.jsii.Kernel.get(this, "caBundlePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.color = software.amazon.jsii.Kernel.get(this, "color", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.context = software.amazon.jsii.Kernel.get(this, "context", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.debug = software.amazon.jsii.Kernel.get(this, "debug", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ec2Creds = software.amazon.jsii.Kernel.get(this, "ec2Creds", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ignoreErrors = software.amazon.jsii.Kernel.get(this, "ignoreErrors", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.json = software.amazon.jsii.Kernel.get(this, "json", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.lookups = software.amazon.jsii.Kernel.get(this, "lookups", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.notices = software.amazon.jsii.Kernel.get(this, "notices", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pathMetadata = software.amazon.jsii.Kernel.get(this, "pathMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.profile = software.amazon.jsii.Kernel.get(this, "profile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.proxy = software.amazon.jsii.Kernel.get(this, "proxy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stacks = software.amazon.jsii.Kernel.get(this, "stacks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.staging = software.amazon.jsii.Kernel.get(this, "staging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.strict = software.amazon.jsii.Kernel.get(this, "strict", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.trace = software.amazon.jsii.Kernel.get(this, "trace", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.verbose = software.amazon.jsii.Kernel.get(this, "verbose", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.versionReporting = software.amazon.jsii.Kernel.get(this, "versionReporting", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.all = builder.all;
            this.app = builder.app;
            this.assetMetadata = builder.assetMetadata;
            this.caBundlePath = builder.caBundlePath;
            this.color = builder.color;
            this.context = builder.context;
            this.debug = builder.debug;
            this.ec2Creds = builder.ec2Creds;
            this.ignoreErrors = builder.ignoreErrors;
            this.json = builder.json;
            this.lookups = builder.lookups;
            this.notices = builder.notices;
            this.output = builder.output;
            this.pathMetadata = builder.pathMetadata;
            this.profile = builder.profile;
            this.proxy = builder.proxy;
            this.roleArn = builder.roleArn;
            this.stacks = builder.stacks;
            this.staging = builder.staging;
            this.strict = builder.strict;
            this.trace = builder.trace;
            this.verbose = builder.verbose;
            this.versionReporting = builder.versionReporting;
        }

        @Override
        public final java.lang.Boolean getAll() {
            return this.all;
        }

        @Override
        public final java.lang.String getApp() {
            return this.app;
        }

        @Override
        public final java.lang.Boolean getAssetMetadata() {
            return this.assetMetadata;
        }

        @Override
        public final java.lang.String getCaBundlePath() {
            return this.caBundlePath;
        }

        @Override
        public final java.lang.Boolean getColor() {
            return this.color;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getContext() {
            return this.context;
        }

        @Override
        public final java.lang.Boolean getDebug() {
            return this.debug;
        }

        @Override
        public final java.lang.Boolean getEc2Creds() {
            return this.ec2Creds;
        }

        @Override
        public final java.lang.Boolean getIgnoreErrors() {
            return this.ignoreErrors;
        }

        @Override
        public final java.lang.Boolean getJson() {
            return this.json;
        }

        @Override
        public final java.lang.Boolean getLookups() {
            return this.lookups;
        }

        @Override
        public final java.lang.Boolean getNotices() {
            return this.notices;
        }

        @Override
        public final java.lang.String getOutput() {
            return this.output;
        }

        @Override
        public final java.lang.Boolean getPathMetadata() {
            return this.pathMetadata;
        }

        @Override
        public final java.lang.String getProfile() {
            return this.profile;
        }

        @Override
        public final java.lang.String getProxy() {
            return this.proxy;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.util.List<java.lang.String> getStacks() {
            return this.stacks;
        }

        @Override
        public final java.lang.Boolean getStaging() {
            return this.staging;
        }

        @Override
        public final java.lang.Boolean getStrict() {
            return this.strict;
        }

        @Override
        public final java.lang.Boolean getTrace() {
            return this.trace;
        }

        @Override
        public final java.lang.Boolean getVerbose() {
            return this.verbose;
        }

        @Override
        public final java.lang.Boolean getVersionReporting() {
            return this.versionReporting;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAll() != null) {
                data.set("all", om.valueToTree(this.getAll()));
            }
            if (this.getApp() != null) {
                data.set("app", om.valueToTree(this.getApp()));
            }
            if (this.getAssetMetadata() != null) {
                data.set("assetMetadata", om.valueToTree(this.getAssetMetadata()));
            }
            if (this.getCaBundlePath() != null) {
                data.set("caBundlePath", om.valueToTree(this.getCaBundlePath()));
            }
            if (this.getColor() != null) {
                data.set("color", om.valueToTree(this.getColor()));
            }
            if (this.getContext() != null) {
                data.set("context", om.valueToTree(this.getContext()));
            }
            if (this.getDebug() != null) {
                data.set("debug", om.valueToTree(this.getDebug()));
            }
            if (this.getEc2Creds() != null) {
                data.set("ec2Creds", om.valueToTree(this.getEc2Creds()));
            }
            if (this.getIgnoreErrors() != null) {
                data.set("ignoreErrors", om.valueToTree(this.getIgnoreErrors()));
            }
            if (this.getJson() != null) {
                data.set("json", om.valueToTree(this.getJson()));
            }
            if (this.getLookups() != null) {
                data.set("lookups", om.valueToTree(this.getLookups()));
            }
            if (this.getNotices() != null) {
                data.set("notices", om.valueToTree(this.getNotices()));
            }
            if (this.getOutput() != null) {
                data.set("output", om.valueToTree(this.getOutput()));
            }
            if (this.getPathMetadata() != null) {
                data.set("pathMetadata", om.valueToTree(this.getPathMetadata()));
            }
            if (this.getProfile() != null) {
                data.set("profile", om.valueToTree(this.getProfile()));
            }
            if (this.getProxy() != null) {
                data.set("proxy", om.valueToTree(this.getProxy()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getStacks() != null) {
                data.set("stacks", om.valueToTree(this.getStacks()));
            }
            if (this.getStaging() != null) {
                data.set("staging", om.valueToTree(this.getStaging()));
            }
            if (this.getStrict() != null) {
                data.set("strict", om.valueToTree(this.getStrict()));
            }
            if (this.getTrace() != null) {
                data.set("trace", om.valueToTree(this.getTrace()));
            }
            if (this.getVerbose() != null) {
                data.set("verbose", om.valueToTree(this.getVerbose()));
            }
            if (this.getVersionReporting() != null) {
                data.set("versionReporting", om.valueToTree(this.getVersionReporting()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.DefaultCdkOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DefaultCdkOptions.Jsii$Proxy that = (DefaultCdkOptions.Jsii$Proxy) o;

            if (this.all != null ? !this.all.equals(that.all) : that.all != null) return false;
            if (this.app != null ? !this.app.equals(that.app) : that.app != null) return false;
            if (this.assetMetadata != null ? !this.assetMetadata.equals(that.assetMetadata) : that.assetMetadata != null) return false;
            if (this.caBundlePath != null ? !this.caBundlePath.equals(that.caBundlePath) : that.caBundlePath != null) return false;
            if (this.color != null ? !this.color.equals(that.color) : that.color != null) return false;
            if (this.context != null ? !this.context.equals(that.context) : that.context != null) return false;
            if (this.debug != null ? !this.debug.equals(that.debug) : that.debug != null) return false;
            if (this.ec2Creds != null ? !this.ec2Creds.equals(that.ec2Creds) : that.ec2Creds != null) return false;
            if (this.ignoreErrors != null ? !this.ignoreErrors.equals(that.ignoreErrors) : that.ignoreErrors != null) return false;
            if (this.json != null ? !this.json.equals(that.json) : that.json != null) return false;
            if (this.lookups != null ? !this.lookups.equals(that.lookups) : that.lookups != null) return false;
            if (this.notices != null ? !this.notices.equals(that.notices) : that.notices != null) return false;
            if (this.output != null ? !this.output.equals(that.output) : that.output != null) return false;
            if (this.pathMetadata != null ? !this.pathMetadata.equals(that.pathMetadata) : that.pathMetadata != null) return false;
            if (this.profile != null ? !this.profile.equals(that.profile) : that.profile != null) return false;
            if (this.proxy != null ? !this.proxy.equals(that.proxy) : that.proxy != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            if (this.stacks != null ? !this.stacks.equals(that.stacks) : that.stacks != null) return false;
            if (this.staging != null ? !this.staging.equals(that.staging) : that.staging != null) return false;
            if (this.strict != null ? !this.strict.equals(that.strict) : that.strict != null) return false;
            if (this.trace != null ? !this.trace.equals(that.trace) : that.trace != null) return false;
            if (this.verbose != null ? !this.verbose.equals(that.verbose) : that.verbose != null) return false;
            return this.versionReporting != null ? this.versionReporting.equals(that.versionReporting) : that.versionReporting == null;
        }

        @Override
        public final int hashCode() {
            int result = this.all != null ? this.all.hashCode() : 0;
            result = 31 * result + (this.app != null ? this.app.hashCode() : 0);
            result = 31 * result + (this.assetMetadata != null ? this.assetMetadata.hashCode() : 0);
            result = 31 * result + (this.caBundlePath != null ? this.caBundlePath.hashCode() : 0);
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
            result = 31 * result + (this.debug != null ? this.debug.hashCode() : 0);
            result = 31 * result + (this.ec2Creds != null ? this.ec2Creds.hashCode() : 0);
            result = 31 * result + (this.ignoreErrors != null ? this.ignoreErrors.hashCode() : 0);
            result = 31 * result + (this.json != null ? this.json.hashCode() : 0);
            result = 31 * result + (this.lookups != null ? this.lookups.hashCode() : 0);
            result = 31 * result + (this.notices != null ? this.notices.hashCode() : 0);
            result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
            result = 31 * result + (this.pathMetadata != null ? this.pathMetadata.hashCode() : 0);
            result = 31 * result + (this.profile != null ? this.profile.hashCode() : 0);
            result = 31 * result + (this.proxy != null ? this.proxy.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.stacks != null ? this.stacks.hashCode() : 0);
            result = 31 * result + (this.staging != null ? this.staging.hashCode() : 0);
            result = 31 * result + (this.strict != null ? this.strict.hashCode() : 0);
            result = 31 * result + (this.trace != null ? this.trace.hashCode() : 0);
            result = 31 * result + (this.verbose != null ? this.verbose.hashCode() : 0);
            result = 31 * result + (this.versionReporting != null ? this.versionReporting.hashCode() : 0);
            return result;
        }
    }
}
